/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentSkipListSet;
import kafka.api.ApiVersion$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.raft.KafkaMetadataLog;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.snapshot.Snapshots;

public final class KafkaMetadataLog$ {
    public static final KafkaMetadataLog$ MODULE$ = new KafkaMetadataLog$();

    public KafkaMetadataLog apply(TopicPartition topicPartition, File dataDir, Time time, Scheduler scheduler, int maxBatchSizeInBytes, int maxFetchSizeInBytes) {
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Integer.toString(maxBatchSizeInBytes));
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), ApiVersion$.MODULE$.latestVersion().toString());
        LogConfig$.MODULE$.validateValues(props);
        LogConfig defaultLogConfig = new LogConfig(props, LogConfig$.MODULE$.apply$default$2());
        Log log = Log$.MODULE$.apply(dataDir, defaultLogConfig, 0L, 0L, scheduler, new BrokerTopicStats(), time, Integer.MAX_VALUE, Integer.MAX_VALUE, new LogDirFailureChannel(5), false, false);
        KafkaMetadataLog metadataLog = new KafkaMetadataLog(log, this.recoverSnapshots(log), topicPartition, maxFetchSizeInBytes);
        metadataLog.truncateToLatestSnapshot();
        return metadataLog;
    }

    /*
     * WARNING - void declaration
     */
    private ConcurrentSkipListSet<OffsetAndEpoch> recoverSnapshots(Log log) {
        void var2_2;
        ConcurrentSkipListSet snapshotIds = new ConcurrentSkipListSet();
        Files.walk(log.dir().toPath(), 1, new FileVisitOption[0]).map(path -> {
            Path path2 = path;
            Path path3 = log.dir().toPath();
            if (path2 == null ? path3 != null : !((Object)path2).equals(path3)) {
                return Snapshots.parse((Path)path);
            }
            return Optional.empty();
        }).forEach(path -> path.ifPresent(snapshotPath -> {
            if (snapshotPath.partial) {
                Files.deleteIfExists(snapshotPath.path);
                return;
            }
            snapshotIds.add(snapshotPath.snapshotId);
        }));
        return var2_2;
    }

    private KafkaMetadataLog$() {
    }
}

