/*
 * Decompiled with CFR 0.152.
 */
package kafka.api.test;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import kafka.api.test.ProducerCompressionTest$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005b\u0001\u0002\n\u0014\u0001iAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u0004.\u0001\u0001\u0006Ia\n\u0005\b]\u0001\u0011\r\u0011\"\u00030\u0011\u0019A\u0004\u0001)A\u0005a!9\u0011\b\u0001b\u0001\n\u00131\u0003B\u0002\u001e\u0001A\u0003%q\u0005C\u0004<\u0001\u0001\u0007I\u0011\u0002\u001f\t\u000f\t\u0003\u0001\u0019!C\u0005\u0007\"1\u0011\n\u0001Q!\nuBQA\u0013\u0001\u0005B-CQ\u0001\u0017\u0001\u0005B-CQ!\u0018\u0001\u0005\u0002y;Q!`\n\t\u0002y4QAE\n\t\u0002}Da!I\b\u0005\u0002\u0005\u001d\u0001BB<\u0010\t\u0003\tIAA\fQe>$WoY3s\u0007>l\u0007O]3tg&|g\u000eV3ti*\u0011A#F\u0001\u0005i\u0016\u001cHO\u0003\u0002\u0017/\u0005\u0019\u0011\r]5\u000b\u0003a\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00017A\u0011AdH\u0007\u0002;)\u0011adF\u0001\u0003u.L!\u0001I\u000f\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\t1#\u0001\u0005ce>\\WM]%e+\u00059\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#aA%oi\u0006I!M]8lKJLE\rI\u0001\u0006i>\u0004\u0018nY\u000b\u0002aA\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\u0005Y\u0006twMC\u00016\u0003\u0011Q\u0017M^1\n\u0005]\u0012$AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\u000b]Vl'+Z2pe\u0012\u001c\u0018a\u00038v[J+7m\u001c:eg\u0002\naa]3sm\u0016\u0014X#A\u001f\u0011\u0005y\u0002U\"A \u000b\u0005m:\u0012BA!@\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0015M,'O^3s?\u0012*\u0017\u000f\u0006\u0002E\u000fB\u0011\u0001&R\u0005\u0003\r&\u0012A!\u00168ji\"9\u0001*CA\u0001\u0002\u0004i\u0014a\u0001=%c\u000591/\u001a:wKJ\u0004\u0013!B:fiV\u0003H#\u0001#)\u0005-i\u0005C\u0001(W\u001b\u0005y%B\u0001\fQ\u0015\t\t&+A\u0004kkBLG/\u001a:\u000b\u0005M#\u0016!\u00026v]&$(\"A+\u0002\u0007=\u0014x-\u0003\u0002X\u001f\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D#\u0001\u0004.\u0011\u00059[\u0016B\u0001/P\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\buKN$8i\\7qe\u0016\u001c8/[8o)\t!u\fC\u0003a\u001b\u0001\u0007\u0011-A\u0006d_6\u0004(/Z:tS>t\u0007C\u00012j\u001d\t\u0019w\r\u0005\u0002eS5\tQM\u0003\u0002g3\u00051AH]8pizJ!\u0001[\u0015\u0002\rA\u0013X\rZ3g\u0013\t9$N\u0003\u0002iS!\"Q\u0002\u001c;v!\ti'/D\u0001o\u0015\ty\u0007/\u0001\u0005qe>4\u0018\u000eZ3s\u0015\t\t\b+\u0001\u0004qCJ\fWn]\u0005\u0003g:\u0014A\"T3uQ>$7k\\;sG\u0016\fQA^1mk\u0016d\u0013A^\u0011\u0002o\u0006Q\u0001/\u0019:b[\u0016$XM]:)\u00055I\bC\u0001>|\u001b\u0005\u0001\u0018B\u0001?q\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0018!J|G-^2fe\u000e{W\u000e\u001d:fgNLwN\u001c+fgR\u0004\"\u0001J\b\u0014\u0007=\t\t\u0001E\u0002)\u0003\u0007I1!!\u0002*\u0005\u0019\te.\u001f*fMR\ta0\u0006\u0002\u0002\fA1\u0011QBA\f\u00037i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0007gR\u0014X-Y7\u000b\u0007\u0005UA'\u0001\u0003vi&d\u0017\u0002BA\r\u0003\u001f\u0011aa\u0015;sK\u0006l\u0007cA7\u0002\u001e%\u0019\u0011q\u00048\u0003\u0013\u0005\u0013x-^7f]R\u001c\b")
public class ProducerCompressionTest
extends ZooKeeperTestHarness {
    private final int brokerId;
    private final String topic;
    private final int numRecords;
    private KafkaServer server = null;

    public static Stream<Arguments> parameters() {
        return ProducerCompressionTest$.MODULE$.parameters();
    }

    private int brokerId() {
        return this.brokerId;
    }

    private String topic() {
        return this.topic;
    }

    private int numRecords() {
        return this.numRecords;
    }

    private KafkaServer server() {
        return this.server;
    }

    private void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @BeforeEach
    public void setUp() {
        void createServer_time;
        Time time;
        super.setUp();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        Object var5_6 = null;
        Object var2_5 = null;
        Object var3_4 = null;
        time3 = null;
        this.server_$eq(createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))));
        super.tearDown();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testCompression(String compression) {
        Properties producerProps = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))), SecurityProtocol.PLAINTEXT);
        producerProps.put("bootstrap.servers", bootstrapServers);
        producerProps.put("compression.type", compression);
        producerProps.put("batch.size", "66000");
        producerProps.put("linger.ms", "200");
        KafkaProducer producer = new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(bootstrapServers, "group", "earliest", true, false, 500, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArrayDeserializer(), new ByteArrayDeserializer());
        try {
            TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 1, (Seq<KafkaServer>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))), new Properties());
            int partition = 0;
            IndexedSeq messageValues = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numRecords()).map((Function1 & Serializable)i -> ProducerCompressionTest.$anonfun$testCompression$1(BoxesRunTime.unboxToInt((Object)i)));
            long now = System.currentTimeMillis();
            ((IterableOps)((IndexedSeq)messageValues.map((Function1 & Serializable)message -> producer.send(new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(now), null, (Object)message.getBytes())))).zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$1 -> {
                ProducerCompressionTest.$anonfun$testCompression$4(x$1);
                return BoxedUnit.UNIT;
            });
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            consumer.assign(Collections.singleton(tp));
            consumer.seek(tp, 0L);
            Seq records = TestUtils$.MODULE$.consumeRecords(consumer, this.numRecords(), 15000L);
            ((IterableOps)((IterableOps)messageValues.zip(records)).zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null && (Tuple2)check$ifrefutable$2._1() != null))).foreach((Function1 & Serializable)x$2 -> {
                ProducerCompressionTest.$anonfun$testCompression$6(now, x$2);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            producer.close();
            consumer.close();
        }
    }

    public static final /* synthetic */ String $anonfun$testCompression$1(int i) {
        return new StringBuilder(5).append("value").append(i).toString();
    }

    public static final /* synthetic */ void $anonfun$testCompression$4(Tuple2 x$1) {
        if (x$1 != null) {
            Future future = (Future)x$1._1();
            Assertions.assertEquals((long)x$1._2$mcI$sp(), (long)((RecordMetadata)future.get()).offset());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testCompression$6(long now$1, Tuple2 x$2) {
        if (x$2 != null) {
            Tuple2 tuple2 = (Tuple2)x$2._1();
            int index = x$2._2$mcI$sp();
            if (tuple2 != null) {
                String messageValue = (String)tuple2._1();
                ConsumerRecord record = (ConsumerRecord)tuple2._2();
                Assertions.assertEquals((Object)messageValue, (Object)new String((byte[])record.value()));
                Assertions.assertEquals((long)now$1, (long)record.timestamp());
                Assertions.assertEquals((long)index, (long)record.offset());
                return;
            }
        }
        throw new MatchError((Object)x$2);
    }

    public ProducerCompressionTest() {
        this.brokerId = 0;
        this.topic = "topic";
        this.numRecords = 2000;
    }
}

