/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbortedTxn;
import kafka.log.AppendOrigin;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.FakeOffsetMap;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.LoadLogParams;
import kafka.log.LoadedLogOffsets;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogTestUtils$;
import kafka.log.LogToClean;
import kafka.log.LogToClean$;
import kafka.log.OffsetMap;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.RequestLocal;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.message.DescribeProducersResponseData;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00115d\u0001B5k\u0001=DQA\u001e\u0001\u0005\u0002]DqA\u001f\u0001C\u0002\u0013\u00051\u0010C\u0004\u0002\n\u0001\u0001\u000b\u0011\u0002?\t\u0011\u0005-\u0001A1A\u0005\u0002mDq!!\u0004\u0001A\u0003%A\u0010C\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0001\u0002\u0012!A\u0011q\u0004\u0001!\u0002\u0013\t\u0019\u0002C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0001\u0002$!A\u00111\u0006\u0001!\u0002\u0013\t)\u0003C\u0005\u0002.\u0001\u0011\r\u0011\"\u0001\u00020!A\u0011Q\b\u0001!\u0002\u0013\t\t\u0004C\u0005\u0002@\u0001\u0011\r\u0011\"\u0001\u0002B!A\u0011\u0011\n\u0001!\u0002\u0013\t\u0019\u0005C\u0004\u0002L\u0001!\t!!\u0014\t\u000f\u0005=\u0004\u0001\"\u0001\u0002N!9\u0011\u0011\u0010\u0001\u0005\u0002\u00055\u0003bBA?\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003\u0003\u0003A\u0011AA'\u0011\u001d\t)\t\u0001C\u0005\u0003\u000fCq!a-\u0001\t\u0013\t)\fC\u0004\u0002:\u0002!\t!!\u0014\t\u000f\u0005u\u0006\u0001\"\u0001\u0002N!9\u0011\u0011\u0019\u0001\u0005\u0002\u00055\u0003bBAc\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003\u0013\u0004A\u0011AA'\u0011\u001d\ti\r\u0001C\u0001\u0003\u001bBq!!5\u0001\t\u0003\ti\u0005C\u0004\u0002V\u0002!\t!!\u0014\t\u000f\u0005e\u0007\u0001\"\u0001\u0002N!9\u0011Q\u001c\u0001\u0005\u0002\u00055\u0003bBAq\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003K\u0004A\u0011AA'\u0011\u001d\tI\u000f\u0001C\u0001\u0003\u001bBq!!<\u0001\t\u0003\ti\u0005C\u0004\u0002r\u0002!\t!!\u0014\t\u000f\u0005U\b\u0001\"\u0001\u0002N!9\u0011\u0011 \u0001\u0005\u0002\u0005m\bb\u0002B\n\u0001\u0011\u0005\u0011Q\n\u0005\b\u0005/\u0001A\u0011AA'\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0003\u001bBqAa\b\u0001\t\u0003\ti\u0005C\u0004\u0003$\u0001!\t!!\u0014\t\u000f\t\u001d\u0002\u0001\"\u0001\u0002N!9!1\u0006\u0001\u0005\u0002\u00055\u0003b\u0002B\u0018\u0001\u0011\u0005\u0011Q\n\u0005\b\u0005g\u0001A\u0011AA'\u0011\u001d\u00119\u0004\u0001C\u0001\u0003\u001bBqAa\u000f\u0001\t\u0013\u0011i\u0004C\u0004\u0003T\u0001!\tA!\u0016\t\u000f\te\u0003\u0001\"\u0001\u0003\\!9!Q\r\u0001\u0005\u0002\t\u001d\u0004b\u0002B6\u0001\u0011\u0005!Q\u000e\u0005\b\u0005c\u0002A\u0011\u0001B:\u0011\u001d\u0011Y\t\u0001C\u0001\u0003\u001bBqAa$\u0001\t\u0003\ti\u0005C\u0004\u0003\u0014\u0002!\t!!\u0014\t\u000f\t]\u0005\u0001\"\u0001\u0002N!9!1\u0014\u0001\u0005\u0002\u00055\u0003b\u0002BP\u0001\u0011%!\u0011\u0015\u0005\b\u0005k\u0003A\u0011AA'\u0011\u001d\u0011I\f\u0001C\u0001\u0003\u001bBqA!0\u0001\t\u0003\ti\u0005C\u0004\u0003B\u0002!\t!!\u0014\t\u000f\t\u0015\u0007\u0001\"\u0001\u0002N!9!\u0011\u001a\u0001\u0005\u0002\u00055\u0003b\u0002Bg\u0001\u0011\u0005\u0011Q\n\u0005\b\u0005#\u0004A\u0011AA'\u0011\u001d\u0011)\u000e\u0001C\u0001\u0003\u001bBqA!7\u0001\t\u0003\ti\u0005C\u0004\u0003^\u0002!IAa8\t\u000f\t=\b\u0001\"\u0003\u0003r\"I1q\u0002\u0001\u0012\u0002\u0013%1\u0011\u0003\u0005\b\u0007O\u0001A\u0011BB\u0015\u0011\u001d\u00199\u0003\u0001C\u0005\u0007\u0007Bqaa\u0013\u0001\t\u0013\u0019i\u0005C\u0005\u0004Z\u0001\t\n\u0011\"\u0003\u0004\\!I1q\f\u0001\u0012\u0002\u0013%1\u0011\r\u0005\n\u0007K\u0002\u0011\u0013!C\u0005\u0007OBqaa\u001b\u0001\t\u0013\u0019i\u0007C\u0005\u0004\b\u0002\t\n\u0011\"\u0003\u0004\n\"I1Q\u0012\u0001\u0012\u0002\u0013%1q\u0012\u0005\b\u0005;\u0004A\u0011BBJ\u0011\u001d\u0019i\u0003\u0001C\u0005\u00077CqA!?\u0001\t\u0013\u0019i\u000bC\u0005\u0004J\u0002\t\n\u0011\"\u0003\u0004h!I11\u001a\u0001\u0012\u0002\u0013%1Q\u001a\u0005\n\u0007#\u0004\u0011\u0013!C\u0005\u0007\u001fC\u0011ba5\u0001#\u0003%Iaa$\t\u000f\rU\u0007\u0001\"\u0003\u0004X\"I1q\u001f\u0001\u0012\u0002\u0013%1q\u0012\u0005\n\u0007s\u0004\u0011\u0013!C\u0005\u0007wDqaa@\u0001\t\u0013!\t\u0001C\u0005\u0005\u0018\u0001\t\n\u0011\"\u0003\u0005\u001a!IAQ\u0004\u0001\u0012\u0002\u0013%1q\u0012\u0005\n\t?\u0001\u0011\u0013!C\u0005\u0007wDq\u0001\"\t\u0001\t\u0013!\u0019\u0003C\u0005\u0005.\u0001\t\n\u0011\"\u0003\u0004h!9Aq\u0006\u0001\u0005\n\u0011E\u0002\"\u0003C\u001d\u0001E\u0005I\u0011BB4\u0011\u001d!Y\u0004\u0001C\u0005\t{AqA!?\u0001\t\u0013!\t\u0006C\u0004\u0005X\u0001!I\u0001\"\u0017\t\u000f\u0011u\u0003\u0001\"\u0003\u0005`!9A1\r\u0001\u0005\n\u0011\u0015$A\u0004'pO\u000ecW-\u00198feR+7\u000f\u001e\u0006\u0003W2\f1\u0001\\8h\u0015\u0005i\u0017!B6bM.\f7\u0001A\n\u0003\u0001A\u0004\"!\u001d;\u000e\u0003IT\u0011a]\u0001\u0006g\u000e\fG.Y\u0005\u0003kJ\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001y!\tI\b!D\u0001k\u0003\u0019!X\u000e\u001d3jeV\tA\u0010E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011AA5p\u0015\t\t\u0019!\u0001\u0003kCZ\f\u0017bAA\u0004}\n!a)\u001b7f\u0003\u001d!X\u000e\u001d3je\u0002\n1\u0001Z5s\u0003\u0011!\u0017N\u001d\u0011\u0002\u00111|w\r\u0015:paN,\"!a\u0005\u0011\t\u0005U\u00111D\u0007\u0003\u0003/QA!!\u0007\u0002\u0002\u0005!Q\u000f^5m\u0013\u0011\ti\"a\u0006\u0003\u0015A\u0013x\u000e]3si&,7/A\u0005m_\u001e\u0004&o\u001c9tA\u0005IAn\\4D_:4\u0017nZ\u000b\u0003\u0003K\u00012!_A\u0014\u0013\r\tIC\u001b\u0002\n\u0019><7i\u001c8gS\u001e\f!\u0002\\8h\u0007>tg-[4!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]B.A\u0003vi&d7/\u0003\u0003\u0002<\u0005U\"\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u0013QD'o\u001c;uY\u0016\u0014XCAA\"!\u0011\t\u0019$!\u0012\n\t\u0005\u001d\u0013Q\u0007\u0002\n)\"\u0014x\u000e\u001e;mKJ\f!\u0002\u001e5s_R$H.\u001a:!\u0003!!X-\u0019:e_^tGCAA(!\r\t\u0018\u0011K\u0005\u0004\u0003'\u0012(\u0001B+oSRD3ADA,!\u0011\tI&a\u001b\u000e\u0005\u0005m#\u0002BA/\u0003?\n1!\u00199j\u0015\u0011\t\t'a\u0019\u0002\u000f),\b/\u001b;fe*!\u0011QMA4\u0003\u0015QWO\\5u\u0015\t\tI'A\u0002pe\u001eLA!!\u001c\u0002\\\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0012i\u0016\u001cHo\u00117fC:\u001cVmZ7f]R\u001c\bfA\b\u0002tA!\u0011\u0011LA;\u0013\u0011\t9(a\u0017\u0003\tQ+7\u000f^\u0001/i\u0016\u001cHo\u00117fC:\u001cVmZ7f]R\u001cx+\u001b;i\u0007>t7-\u001e:sK:$8+Z4nK:$H)\u001a7fi&|g\u000eK\u0002\u0011\u0003g\nq\u0006^3tiNK'0\u001a+sS6lW\r\u001a$peB\u0013X-\u00197m_\u000e\fG/\u001a3B]\u0012\u001cu.\u001c9bGR,G\rV8qS\u000eD3!EA:\u0003}!Xm\u001d;EkBd\u0017nY1uK\u000eCWmY6BMR,'o\u00117fC:Lgn\u001a\u0015\u0004%\u0005M\u0014\u0001F1tg\u0016\u0014H/\u00117m\u0003\n|'\u000f^3e)bt7\u000f\u0006\u0004\u0002P\u0005%\u00151\u0016\u0005\b\u0003\u0017\u001b\u0002\u0019AAG\u0003M)\u0007\u0010]3di\u0016$\u0017IY8si\u0016$G\u000b\u001f8t!\u0019\ty)a(\u0002&:!\u0011\u0011SAN\u001d\u0011\t\u0019*!'\u000e\u0005\u0005U%bAAL]\u00061AH]8pizJ\u0011a]\u0005\u0004\u0003;\u0013\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003C\u000b\u0019K\u0001\u0003MSN$(bAAOeB\u0019\u00110a*\n\u0007\u0005%&N\u0001\u0006BE>\u0014H/\u001a3Uq:Daa[\nA\u0002\u00055\u0006cA=\u00020&\u0019\u0011\u0011\u00176\u0003\u00071{w-A\u000fbgN,'\u000f^!mYR\u0013\u0018M\\:bGRLwN\\:D_6\u0004H.\u001a;f)\u0011\ty%a.\t\r-$\u0002\u0019AAW\u0003M\"Xm\u001d;Nk2$\u0018\u000eU1tgN+w-\\3oi\u000ecW-\u00198j]\u001e<\u0016\u000e\u001e5BE>\u0014H/\u001a3Ue\u0006t7/Y2uS>t7\u000fK\u0002\u0016\u0003g\n\u0011\u0005^3ti\n\u000b7/[2Ue\u0006t7/Y2uS>t\u0017i^1sK\u000ecW-\u00198j]\u001eD3AFA:\u0003%\"Xm\u001d;DY\u0016\fgnV5uQR\u0013\u0018M\\:bGRLwN\\:Ta\u0006tg.\u001b8h'\u0016<W.\u001a8ug\"\u001aq#a\u001d\u0002/Q,7\u000f^\"p[6LG/T1sW\u0016\u0014(+Z7pm\u0006d\u0007f\u0001\r\u0002t\u0005!C/Z:u\t\u0016dW\r^3e\u0005\u0006$8\r[3t/&$\bNT8NKN\u001c\u0018mZ3t%\u0016\fG\rK\u0002\u001a\u0003g\nq\u0005^3ti\u000e{W.\\5u\u001b\u0006\u00148.\u001a:SKR,g\u000e^5p]^KG\u000f[#naRL()\u0019;dQ\"\u001a!$a\u001d\u00025Q,7\u000f^\"mK\u0006tW)\u001c9us\u000e{g\u000e\u001e:pY\n\u000bGo\u00195)\u0007m\t\u0019(\u0001\u0015uKN$8i\\7nSR$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001c\u0006/\u00198oS:<7+Z4nK:$8\u000fK\u0002\u001d\u0003g\na\u0005^3ti\u0006\u0013wN\u001d;fIR\u0013\u0018M\\:bGRLwN\\*qC:t\u0017N\\4TK\u001elWM\u001c;tQ\ri\u00121O\u0001\u0017i\u0016\u001cH/\u00112peRl\u0015M]6feJ+Wn\u001c<bY\"\u001aa$a\u001d\u0002MQ,7\u000f^#naRL()\u0019;dQJ+Wn\u001c<bY^KG\u000f[*fcV,gnY3SKV\u001cX\rK\u0002 \u0003g\na\u0005^3ti\u0006\u0013wN\u001d;NCJ\\WM\u001d*fi\u0016tG/[8o/&$\b.R7qif\u0014\u0015\r^2iQ\r\u0001\u00131O\u0001\u0011i\u0016\u001cH\u000fT1sO\u0016lUm]:bO\u0016D3!IA:\u0003\r\"Xm\u001d;NKN\u001c\u0018mZ3MCJ<WM\u001d+iC:l\u0015\r_'fgN\fw-Z*ju\u0016D3AIA:\u0003Q\"Xm\u001d;NKN\u001c\u0018mZ3MCJ<WM\u001d+iC:l\u0015\r_'fgN\fw-Z*ju\u0016<\u0016\u000e\u001e5D_J\u0014X\u000f\u001d;IK\u0006$WM\u001d\u0015\u0004G\u0005M\u0014A\f;fgR\u001cuN\u001d:vaRlUm]:bO\u0016\u001c\u0016N_3MCJ<WM\u001d+iC:\u0014\u0015\u0010^3t\u0003Z\f\u0017\u000e\\1cY\u0016D3\u0001JA:\u0003\u0019\u001a'/Z1uK2{wmV5uQ6+7o]1hKNd\u0015M]4feRC\u0017M\\'bqNK'0\u001a\u000b\u0005\u0003{\u0014I\u0001E\u0004r\u0003\u007f\fiKa\u0001\n\u0007\t\u0005!O\u0001\u0004UkBdWM\r\t\u0004s\n\u0015\u0011b\u0001B\u0004U\nia)Y6f\u001f\u001a47/\u001a;NCBDqAa\u0003&\u0001\u0004\u0011i!\u0001\tmCJ<W-T3tg\u0006<WmU5{KB\u0019\u0011Oa\u0004\n\u0007\tE!OA\u0002J]R\fq\u0003^3ti\u000ecW-\u00198j]\u001e<\u0016\u000e\u001e5EK2,G/Z:)\u0007\u0019\n\u0019(A\nuKN$Hj\\4DY\u0016\fg.\u001a:Ti\u0006$8\u000fK\u0002(\u0003g\n\u0011\u0006^3ti2{wm\u00117fC:,'OU3uC&t7\u000f\u0015:pIV\u001cWM\u001d'bgR\u001cV-];f]\u000e,\u0007f\u0001\u0015\u0002t\u0005ID/Z:u\u0019><7\t\\3b]\u0016\u0014(+\u001a;bS:\u001cH*Y:u'\u0016\fX/\u001a8dK\u00163XM\\%g)J\fgn]1di&|g.\u00112peR,G\rK\u0002*\u0003g\n\u0001\u0007^3ti\u000ecW-\u00198j]\u001e<\u0016\u000e\u001e5LKf\u001c8i\u001c8gY&\u001cG/\u001b8h/&$\b\u000e\u0016=o\u001b\u0006\u00148.\u001a:LKf\u001c\bf\u0001\u0016\u0002t\u00059B/Z:u!\u0006\u0014H/[1m'\u0016<W.\u001a8u\u00072,\u0017M\u001c\u0015\u0004W\u0005M\u0014A\t;fgR\u001cE.Z1oS:<w+\u001b;i+:\u001cG.Z1oC\ndWmU3di&|g\u000eK\u0002-\u0003g\na\u0002^3ti2{w\rV8DY\u0016\fg\u000eK\u0002.\u0003g\nA\u0005^3ti2{w\rV8DY\u0016\fgnV5uQVs7\r\\3b]\u0006\u0014G.Z*fGRLwN\u001c\u0015\u0004]\u0005M\u0014a\b;fgR\u001cE.Z1oS:<w+\u001b;i+:\\W-_3e\u001b\u0016\u001c8/Y4fg\"\u001aq&a\u001d\u0002+\t\fGo\u00195CCN,wJ\u001a4tKR\u001c\u0018J\u001c'pOR!!q\bB)!\u0019\u0011\tEa\u0012\u0003L5\u0011!1\t\u0006\u0004\u0005\u000b\u0012\u0018AC2pY2,7\r^5p]&!!\u0011\nB\"\u0005!IE/\u001a:bE2,\u0007cA9\u0003N%\u0019!q\n:\u0003\t1{gn\u001a\u0005\u0007WB\u0002\r!!,\u000211\f7\u000f^(gMN,Go\u001d)fe\n\u000bGo\u00195J]2{w\r\u0006\u0003\u0003@\t]\u0003BB62\u0001\u0004\ti+\u0001\nmCN$8+Z9vK:\u001cWm]%o\u0019><G\u0003\u0002B/\u0005G\u0002\u0002B!\u0011\u0003`\t-#QB\u0005\u0005\u0005C\u0012\u0019EA\u0002NCBDaa\u001b\u001aA\u0002\u00055\u0016\u0001D8gMN,Go]%o\u0019><G\u0003\u0002B \u0005SBaa[\u001aA\u0002\u00055\u0016\u0001G;oW\u0016LX\rZ'fgN\fw-Z\"pk:$\u0018J\u001c'pOR!!Q\u0002B8\u0011\u0019YG\u00071\u0001\u0002.\u0006q\u0011MY8si\u000eCWmY6E_:,G\u0003BA(\u0005kBqAa\u001e6\u0001\u0004\u0011I(\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\tm$qQ\u0007\u0003\u0005{RAAa \u0003\u0002\u000611m\\7n_:T1!\u001cBB\u0015\u0011\u0011))a\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\u0011II! \u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006QB/Z:u\u00072,\u0017M\\*fO6,g\u000e^:XSRD\u0017IY8si\"\u001aa'a\u001d\u0002'Q,7\u000f^*fO6,g\u000e^$s_V\u0004\u0018N\\4)\u0007]\n\u0019(\u0001\u001buKN$8+Z4nK:$xI]8va&twmV5uQN\u0003\u0018M]:f\u001f\u001a47/\u001a;t\u0003:$W)\u001c9usN+w-\\3oiND3\u0001OA:\u0003\u0011\"Xm\u001d;TK\u001elWM\u001c;He>,\b/\u001b8h/&$\bn\u00159beN,wJ\u001a4tKR\u001c\bfA\u001d\u0002t\u0005YC/Z:u'\u0016<W.\u001a8u\u000fJ|W\u000f]5oO\u001a{G\u000e\\8xS:<Gj\\1e\u001f\u001aTVM]8J]\u0012,\u0007\u0010K\u0002;\u0003g\n\u0011c\u00195fG.\u001cVmZ7f]R|%\u000fZ3s)\u0011\tyEa)\t\u000f\t\u00156\b1\u0001\u0003(\u00061qM]8vaN\u0004bA!\u0011\u0003*\n5\u0016\u0002\u0002BV\u0005\u0007\u00121aU3r!\u0019\u0011\tE!+\u00030B\u0019\u0011P!-\n\u0007\tM&N\u0001\u0006M_\u001e\u001cVmZ7f]R\f!\u0003^3ti\n+\u0018\u000e\u001c3PM\u001a\u001cX\r^'ba\"\u001aA(a\u001d\u0002;Q,7\u000f^*fO6,g\u000e^,ji\"|eMZ:fi>3XM\u001d4m_^D3!PA:\u0003Y!Xm\u001d;SK\u000e|g/\u001a:z\u0003\u001a$XM]\"sCND\u0007f\u0001 \u0002t\u0005YB/Z:u\u0005VLG\u000eZ(gMN,G/T1q\r\u0006\\W\rT1sO\u0016D3aPA:\u0003e!Xm\u001d;Ck&dG\rU1si&\fGn\u00144gg\u0016$X*\u00199)\u0007\u0001\u000b\u0019(\u0001\u000euKN$8\t\\3b]\u000e{'O];qi6+7o]1hKN+G\u000fK\u0002B\u0003g\nQ\u0005^3ti\u000ec\u0017.\u001a8u\u0011\u0006tG\r\\5oO>37i\u001c:skB$X*Z:tC\u001e,7+\u001a;)\u0007\t\u000b\u0019(\u0001\nuKN$8\t\\3b]R{WNY:u_:,\u0007fA\"\u0002t\u0005\u0001C/Z:u\u00072,\u0017M\\5oO\n+\u0017p\u001c8e\u001b&\u001c8/\u001b8h\u001f\u001a47/\u001a;tQ\r!\u00151O\u0001\u0015i\u0016\u001cH/T1y\u00072,\u0017M\u001c+j[\u0016\u001cVmY:)\u0007\u0015\u000b\u0019(\u0001\u0006xe&$X\rV8M_\u001e$\u0002Ba\u0010\u0003b\n\r(1\u001e\u0005\u0007W\u001a\u0003\r!!,\t\u000f\t\u0015h\t1\u0001\u0003h\u0006i1.Z=t\u0003:$g+\u00197vKN\u0004bA!\u0011\u0003H\t%\bcB9\u0002\u0000\n5!Q\u0002\u0005\b\u0005[4\u0005\u0019\u0001B \u0003%ygMZ:fiN+\u0017/A\u000bj]Z\fG.\u001b3DY\u0016\fg.\u001a3NKN\u001c\u0018mZ3\u0015\u0011\tM(q`B\u0002\u0007\u000b\u0001BA!>\u0003|6\u0011!q\u001f\u0006\u0005\u0005s\u0014i(\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0005{\u00149PA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\b\u0007\u00039\u0005\u0019\u0001B&\u00035Ig.\u001b;jC2|eMZ:fi\"9!Q]$A\u0002\t\u001d\b\"CB\u0004\u000fB\u0005\t\u0019AB\u0005\u0003\u0015\u0019w\u000eZ3d!\u0011\u0011)pa\u0003\n\t\r5!q\u001f\u0002\u0010\u0007>l\u0007O]3tg&|g\u000eV=qK\u0006y\u0012N\u001c<bY&$7\t\\3b]\u0016$W*Z:tC\u001e,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\rM!\u0006BB\u0005\u0007+Y#aa\u0006\u0011\t\re11E\u0007\u0003\u00077QAa!\b\u0004 \u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007C\u0011\u0018AC1o]>$\u0018\r^5p]&!1QEB\u000e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0012[\u0016\u001c8/Y4f/&$\bn\u00144gg\u0016$H\u0003\u0003Bz\u0007W\u0019Yda\u0010\t\u000f\r5\u0012\n1\u0001\u00040\u0005\u00191.Z=\u0011\u000bE\u001c\td!\u000e\n\u0007\rM\"OA\u0003BeJ\f\u0017\u0010E\u0002r\u0007oI1a!\u000fs\u0005\u0011\u0011\u0015\u0010^3\t\u000f\ru\u0012\n1\u0001\u00040\u0005)a/\u00197vK\"91\u0011I%A\u0002\t-\u0013AB8gMN,G\u000f\u0006\u0005\u0003t\u000e\u00153qIB%\u0011\u001d\u0019iC\u0013a\u0001\u0005\u001bAqa!\u0010K\u0001\u0004\u0011i\u0001C\u0004\u0004B)\u0003\rAa\u0013\u0002\u000f5\f7.\u001a'pORA\u0011QVB(\u0007#\u001a)\u0006\u0003\u0005\u0002\f-\u0003\n\u00111\u0001}\u0011%\u0019\u0019f\u0013I\u0001\u0002\u0004\t)#\u0001\u0004d_:4\u0017n\u001a\u0005\n\u0007/Z\u0005\u0013!a\u0001\u0005\u0017\nQB]3d_Z,'/\u001f)pS:$\u0018!E7bW\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u00111Q\f\u0016\u0004y\u000eU\u0011!E7bW\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u001111\r\u0016\u0005\u0003K\u0019)\"A\tnC.,Gj\\4%I\u00164\u0017-\u001e7uIM*\"a!\u001b+\t\t-3QC\u0001\f[\u0006\\Wm\u00117fC:,'\u000f\u0006\u0005\u0004p\rU4\u0011PBB!\rI8\u0011O\u0005\u0004\u0007gR'aB\"mK\u0006tWM\u001d\u0005\b\u0007oz\u0005\u0019\u0001B\u0007\u0003!\u0019\u0017\r]1dSRL\b\"CB>\u001fB\u0005\t\u0019AB?\u0003%\u0019\u0007.Z2l\t>tW\rE\u0004r\u0007\u007f\u0012I(a\u0014\n\u0007\r\u0005%OA\u0005Gk:\u001cG/[8oc!I1QQ(\u0011\u0002\u0003\u0007!QB\u0001\u000f[\u0006DX*Z:tC\u001e,7+\u001b>f\u0003Ui\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uII*\"aa#+\t\ru4QC\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019\tJ\u000b\u0003\u0003\u000e\rUAC\u0002B \u0007+\u001b9\n\u0003\u0004l%\u0002\u0007\u0011Q\u0016\u0005\b\u00073\u0013\u0006\u0019\u0001Bt\u0003\r\u0019X-\u001d\u000b\u0005\u0007;\u001bI\u000b\u0005\u0003\u0004 \u000e\u0015VBABQ\u0015\u0011\u0019\u0019+!\u0001\u0002\u00079Lw.\u0003\u0003\u0004(\u000e\u0005&A\u0003\"zi\u0016\u0014UO\u001a4fe\"911V*A\u0002\t-\u0013AA5e)9\u0011\u0019pa,\u00042\u000eM6qWBa\u0007\u000bDqa!\fU\u0001\u0004\u0011i\u0001C\u0004\u0004>Q\u0003\rA!\u0004\t\u0013\rUF\u000b%AA\u0002\t-\u0013A\u00039s_\u0012,8-\u001a:JI\"I1\u0011\u0018+\u0011\u0002\u0003\u000711X\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0007E\u001ci,C\u0002\u0004@J\u0014Qa\u00155peRD\u0011ba1U!\u0003\u0005\rA!\u0004\u0002\u0011M,\u0017/^3oG\u0016D\u0011ba2U!\u0003\u0005\rA!\u0004\u0002)A\f'\u000f^5uS>tG*Z1eKJ,\u0005o\\2i\u0003A\u0011XmY8sI\u0012\"WMZ1vYR$3'\u0001\tsK\u000e|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u00111q\u001a\u0016\u0005\u0007w\u001b)\"\u0001\tsK\u000e|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%k\u0005\u0001\"/Z2pe\u0012$C-\u001a4bk2$HEN\u0001\u001cCB\u0004XM\u001c3Ue\u0006t7/Y2uS>t\u0017\r\\!t\u0019\u0016\fG-\u001a:\u0015\u0019\re71]Bs\u0007O\u001cIo!<\u0011\u000fE\u001cyha7\u0004^B1!\u0011\tBU\u0005\u001b\u00012!_Bp\u0013\r\u0019\tO\u001b\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\r-L\u0006\u0019AAW\u0011\u001d\u0019),\u0017a\u0001\u0005\u0017Bqa!/Z\u0001\u0004\u0019Y\fC\u0005\u0004lf\u0003\n\u00111\u0001\u0003\u000e\u0005YA.Z1eKJ,\u0005o\\2i\u0011%\u0019y/\u0017I\u0001\u0002\u0004\u0019\t0\u0001\u0004pe&<\u0017N\u001c\t\u0004s\u000eM\u0018bAB{U\na\u0011\t\u001d9f]\u0012|%/[4j]\u0006)\u0013\r\u001d9f]\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY\u0006\u001bH*Z1eKJ$C-\u001a4bk2$H\u0005N\u0001&CB\u0004XM\u001c3Ue\u0006t7/Y2uS>t\u0017\r\\!t\u0019\u0016\fG-\u001a:%I\u00164\u0017-\u001e7uIU*\"a!@+\t\rE8QC\u0001\u0019CB\u0004XM\u001c3JI\u0016l\u0007o\u001c;f]R\f5\u000fT3bI\u0016\u0014HCDBm\t\u0007!)\u0001b\u0002\u0005\n\u0011MAQ\u0003\u0005\u0007Wr\u0003\r!!,\t\u000f\rUF\f1\u0001\u0003L!91\u0011\u0018/A\u0002\rm\u0006\"\u0003C\u00069B\u0005\t\u0019\u0001C\u0007\u0003=I7\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007cA9\u0005\u0010%\u0019A\u0011\u0003:\u0003\u000f\t{w\u000e\\3b]\"I11\u001e/\u0011\u0002\u0003\u0007!Q\u0002\u0005\n\u0007_d\u0006\u0013!a\u0001\u0007c\f!%\u00199qK:$\u0017\nZ3na>$XM\u001c;Bg2+\u0017\rZ3sI\u0011,g-Y;mi\u0012\"TC\u0001C\u000eU\u0011!ia!\u0006\u0002E\u0005\u0004\b/\u001a8e\u0013\u0012,W\u000e]8uK:$\u0018i\u001d'fC\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003\t\n\u0007\u000f]3oI&#W-\u001c9pi\u0016tG/Q:MK\u0006$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u0005a1m\\7nSRl\u0015M]6feRA!1\u001fC\u0013\tO!I\u0003C\u0004\u00046\u0002\u0004\rAa\u0013\t\u000f\re\u0006\r1\u0001\u0004<\"IA1\u00061\u0011\u0002\u0003\u0007!1J\u0001\ni&lWm\u001d;b[B\facY8n[&$X*\u0019:lKJ$C-\u001a4bk2$HeM\u0001\fC\n|'\u000f^'be.,'\u000f\u0006\u0005\u0003t\u0012MBQ\u0007C\u001c\u0011\u001d\u0019)L\u0019a\u0001\u0005\u0017Bqa!/c\u0001\u0004\u0019Y\fC\u0005\u0005,\t\u0004\n\u00111\u0001\u0003L\u0005)\u0012MY8si6\u000b'o[3sI\u0011,g-Y;mi\u0012\u001a\u0014\u0001D3oIRCh.T1sW\u0016\u0014H\u0003\u0004Bz\t\u007f!\t\u0005b\u0011\u0005N\u0011=\u0003bBB[I\u0002\u0007!1\n\u0005\b\u0007s#\u0007\u0019AB^\u0011\u001d!)\u0005\u001aa\u0001\t\u000f\n\u0011cY8oiJ|GNU3d_J$G+\u001f9f!\u0011\u0011)\u0010\"\u0013\n\t\u0011-#q\u001f\u0002\u0012\u0007>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007bBB!I\u0002\u0007!1\n\u0005\b\tW!\u0007\u0019\u0001B&)\u0019\u0011\u0019\u0010b\u0015\u0005V!91QF3A\u0002\t5\u0001bBB\u001fK\u0002\u00071qF\u0001\u000ek:\\W-_3e%\u0016\u001cwN\u001d3\u0015\t\tMH1\f\u0005\b\u0007{1\u0007\u0019\u0001B\u0007\u0003=!x.\u001c2ti>tWMU3d_J$G\u0003\u0002Bz\tCBqa!\fh\u0001\u0004\u0011i!A\bsK\u000e|g/\u001a:B]\u0012\u001c\u0005.Z2l)\u0019\ti\u000bb\u001a\u0005j!911\u000b5A\u0002\u0005\u0015\u0002b\u0002C6Q\u0002\u0007!qH\u0001\rKb\u0004Xm\u0019;fI.+\u0017p\u001d")
public class LogCleanerTest {
    private final File tmpdir = TestUtils.tempDirectory(null, null);
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir());
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;

    public File tmpdir() {
        return this.tmpdir;
    }

    public File dir() {
        return this.dir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @AfterEach
    public void teardown() {
        Utils.delete((File)this.tmpdir());
    }

    @Test
    public void testCleanSegments() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$12 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$22 = file2;
        long l = 0L;
        Log log = this.makeLog(x$22, x$12, l);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        Iterable<Object> keysFound = LogTestUtils$.MODULE$.keysInLog(log);
        Assertions.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        scala.collection.immutable.Seq segments = ((IterableOnceOps)log.logSegments().take(3)).toSeq();
        CleanerStats stats = new CleanerStats(Time.SYSTEM);
        int expectedBytesRead = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)segments.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        cleaner.cleanSegments(log, (Seq)segments, (OffsetMap)map, 0L, stats, new CleanedTransactionMetadata());
        Assertions.assertEquals((Object)((Iterable)LogTestUtils$.MODULE$.keysInLog(log).filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$2 -> !keys.contains((Object)BoxesRunTime.boxToLong((long)x$2)))), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((long)expectedBytesRead, (long)stats.bytesRead());
    }

    @Test
    public void testCleanSegmentsWithConcurrentSegmentDeletion() {
        CountDownLatch deleteStartLatch = new CountDownLatch(1);
        CountDownLatch deleteCompleteLatch = new CountDownLatch(1);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString());
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(this.dir());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        int maxProducerIdExpirationMs = 3600000;
        LogSegments logSegments = new LogSegments(topicPartition);
        Option leaderEpochCache = Log$.MODULE$.maybeCreateLeaderEpochCache(this.dir(), topicPartition, logDirFailureChannel, config.recordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, this.dir(), maxProducerIdExpirationMs, (Time)this.time());
        LoadedLogOffsets offsets = LogLoader$.MODULE$.load(new LoadLogParams(this.dir(), topicPartition, config, (Scheduler)this.time().scheduler(), (Time)this.time(), logDirFailureChannel, true, logSegments, 0L, 0L, maxProducerIdExpirationMs, leaderEpochCache, producerStateManager));
        Log log = new Log(this, config, logSegments, offsets, topicPartition, leaderEpochCache, producerStateManager, logDirFailureChannel, deleteStartLatch, deleteCompleteLatch){
            private final CountDownLatch deleteStartLatch$1;
            private final CountDownLatch deleteCompleteLatch$1;

            public void replaceSegments(Seq<LogSegment> newSegments, Seq<LogSegment> oldSegments, boolean isRecoveredSwapFile) {
                this.deleteStartLatch$1.countDown();
                if (!this.deleteCompleteLatch$1.await(5000L, TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException("Log segment deletion timed out");
                }
                super.replaceSegments(newSegments, oldSegments, isRecoveredSwapFile);
            }

            public boolean replaceSegments$default$3() {
                return false;
            }
            {
                this.deleteStartLatch$1 = deleteStartLatch$1;
                this.deleteCompleteLatch$1 = deleteCompleteLatch$1;
                super($outer.dir(), config$1, logSegments$1, offsets$1.logStartOffset(), offsets$1.recoveryPoint(), offsets$1.nextOffsetMetadata(), (Scheduler)$outer.time().scheduler(), new BrokerTopicStats(), (Time)$outer.time(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), topicPartition$1, leaderEpochCache$1, producerStateManager$1, logDirFailureChannel$1, (Option)None$.MODULE$, true);
            }
        };
        new Thread(null, deleteStartLatch, log, deleteCompleteLatch){
            private final CountDownLatch deleteStartLatch$1;
            private final Log log$1;
            private final CountDownLatch deleteCompleteLatch$1;

            public void run() {
                this.deleteStartLatch$1.await(5000L, TimeUnit.MILLISECONDS);
                this.log$1.updateHighWatermark(this.log$1.activeSegment().baseOffset());
                this.log$1.maybeIncrementLogStartOffset(this.log$1.activeSegment().baseOffset(), (LogStartOffsetIncrementReason)LeaderOffsetIncremented$.MODULE$);
                this.log$1.updateHighWatermark(this.log$1.activeSegment().baseOffset());
                this.log$1.deleteOldSegments();
                this.deleteCompleteLatch$1.countDown();
            }
            {
                this.deleteStartLatch$1 = deleteStartLatch$1;
                this.log$1 = log$1;
                this.deleteCompleteLatch$1 = deleteCompleteLatch$1;
            }
        }.start();
        while (log.numberOfSegments() < 3) {
            log.appendAsLeader(this.record(0, (int)log.logEndOffset(), -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            log.roll(log.roll$default$1());
        }
        Assertions.assertEquals((int)3, (int)log.numberOfSegments());
        FileRecords firstLogFile = ((LogSegment)log.logSegments().head()).log();
        String expectedFileName = CoreUtils$.MODULE$.replaceSuffix(firstLogFile.file().getPath(), "", Log$.MODULE$.DeletedFileSuffix());
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        scala.collection.immutable.Seq segments = log.logSegments(0L, log.activeSegment().baseOffset()).toSeq();
        CleanerStats stats = new CleanerStats(Time.SYSTEM);
        cleaner.buildOffsetMap(log, 0L, log.activeSegment().baseOffset(), (OffsetMap)offsetMap, stats);
        cleaner.cleanSegments(log, (Seq)segments, (OffsetMap)offsetMap, 0L, stats, new CleanedTransactionMetadata());
        Assertions.assertEquals((Object)expectedFileName, (Object)firstLogFile.file().getPath());
        Assertions.assertEquals((int)2, (int)log.numberOfSegments());
    }

    @Test
    public void testSizeTrimmedForPreallocatedAndCompactedTopic() {
        File file;
        int originalMaxFileSize = 1024;
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(originalMaxFileSize));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact");
        logProps.put(LogConfig$.MODULE$.PreAllocateEnableProp(), "true");
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), false));
        Assertions.assertTrue((((LogSegment)log.logSegments().iterator().next()).log().channel().size() < (long)originalMaxFileSize ? 1 : 0) != 0, (String)"Cleaned segment file should be trimmed to its real size.");
    }

    @Test
    public void testDuplicateCheckAfterCleaning() {
        File file;
        File file2;
        File file3;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file4 = file3 = this.dir();
        file3 = null;
        File x$2 = file4;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        int pid4 = 4;
        this.appendIdempotentAsLeader(log, pid1, producerEpoch, false, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        this.appendIdempotentAsLeader(log, pid2, producerEpoch, false, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        this.appendIdempotentAsLeader(log, pid3, producerEpoch, false, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Option x$4 = log.roll$default$1();
        log.roll(x$4);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 5, 7})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1))})), this.lastSequencesInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 1, 4})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 6, 7})), this.offsetsInLog(log));
        log.close();
        LogConfig reloadLog$1_x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file5 = file2 = this.dir();
        file2 = null;
        File reloadLog$1_x$3 = file5;
        log = this.makeLog(reloadLog$1_x$3, reloadLog$1_x$1, 0L);
        Object var13_14 = null;
        Object var14_16 = null;
        LogAppendInfo logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader(log, pid1, producerEpoch, false, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assertions.assertEquals((long)0L, (long)((LogOffsetMetadata)logAppendInfo.firstOffset().get()).messageOffset());
        Assertions.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader(log, pid3, producerEpoch, false, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Assertions.assertEquals((long)6L, (long)((LogOffsetMetadata)logAppendInfo.firstOffset().get()).messageOffset());
        Assertions.assertEquals((long)7L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader(log, pid2, producerEpoch, false, this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        Assertions.assertEquals((long)3L, (long)((LogOffsetMetadata)logAppendInfo.firstOffset().get()).messageOffset());
        Assertions.assertEquals((long)5L, (long)logAppendInfo.lastOffset());
        this.appendIdempotentAsLeader(log, pid4, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})));
        Option x$5 = log.roll$default$1();
        log.roll(x$5);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid4)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 5, 7, 8})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 4, 2})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8})), this.offsetsInLog(log));
        log.close();
        LogConfig reloadLog$1_x$12 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file6 = file = this.dir();
        file = null;
        File reloadLog$1_x$32 = file6;
        log = this.makeLog(reloadLog$1_x$32, reloadLog$1_x$12, 0L);
        Object var16_19 = null;
        Object var17_21 = null;
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader(log, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assertions.assertEquals((long)0L, (long)((LogOffsetMetadata)logAppendInfo.firstOffset().get()).messageOffset());
        Assertions.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
    }

    private void assertAllAbortedTxns(List<AbortedTxn> expectedAbortedTxns, Log log) {
        List abortedTxns = log.collectAbortedTransactions(0L, log.logEndOffset());
        Assertions.assertEquals(expectedAbortedTxns, (Object)abortedTxns);
    }

    private void assertAllTransactionsComplete(Log log) {
        Assertions.assertTrue((boolean)log.activeProducers().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$assertAllTransactionsComplete$1(x$3))));
    }

    @Test
    public void testMultiPassSegmentCleaningWithAbortedTransactions() {
        File file;
        int deleteRetentionMs = 50000;
        int offsetMapSlots = 4;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.DeleteRetentionMsProp(), Integer.toString(deleteRetentionMs));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        int producerId1 = 1;
        int producerId2 = 2;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, producerId1, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, producerId2, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})));
        this.commit$1(producerId1, log, producerEpoch);
        this.commit$1(producerId2, log, producerEpoch);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        this.abort$1(producerId1, log, producerEpoch);
        appendProducer2.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6})));
        this.commit$1(producerId1, log, producerEpoch);
        this.abort$1(producerId2, log, producerEpoch);
        appendProducer2.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6, 7})));
        this.commit$1(producerId2, log, producerEpoch);
        log.roll(log.roll$default$1());
        Assertions.assertEquals((long)20L, (long)log.logEndOffset());
        List expectedAbortedTxns = (List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn((long)producerId1, 8L, 10L, 11L), new AbortedTxn((long)producerId2, 11L, 16L, 17L)}));
        this.assertAllTransactionsComplete(log);
        this.assertAllAbortedTxns((List<AbortedTxn>)expectedAbortedTxns, log);
        long l = 0L;
        long cleanSegments$1_deleteHorizonMs = 0L;
        FakeOffsetMap cleanSegments$1_offsetMap = new FakeOffsetMap(offsetMapSlots);
        scala.collection.immutable.Seq cleanSegments$1_segments = log.logSegments(0L, log.activeSegment().baseOffset()).toSeq();
        CleanerStats cleanSegments$1_stats = new CleanerStats((Time)this.time());
        cleaner.buildOffsetMap(log, l, log.activeSegment().baseOffset(), (OffsetMap)cleanSegments$1_offsetMap, cleanSegments$1_stats);
        cleaner.cleanSegments(log, (Seq)cleanSegments$1_segments, (OffsetMap)cleanSegments$1_offsetMap, cleanSegments$1_deleteHorizonMs, cleanSegments$1_stats, new CleanedTransactionMetadata());
        l = cleanSegments$1_offsetMap.latestOffset() + 1L;
        Object var18_18 = null;
        Object var19_19 = null;
        Object var20_20 = null;
        Assertions.assertEquals((long)4L, (long)l);
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 4, 6, 7, 10, 13, 15, 16, 17, 19})), this.batchBaseOffsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 4, 5, 6, 7, 10, 13, 14, 15, 16, 17, 18, 19})), this.offsetsInLog(log));
        this.assertAllTransactionsComplete(log);
        this.assertAllAbortedTxns((List<AbortedTxn>)expectedAbortedTxns, log);
        long cleanSegments$1_deleteHorizonMs2 = 0L;
        FakeOffsetMap cleanSegments$1_offsetMap2 = new FakeOffsetMap(offsetMapSlots);
        scala.collection.immutable.Seq cleanSegments$1_segments2 = log.logSegments(0L, log.activeSegment().baseOffset()).toSeq();
        CleanerStats cleanSegments$1_stats2 = new CleanerStats((Time)this.time());
        cleaner.buildOffsetMap(log, l, log.activeSegment().baseOffset(), (OffsetMap)cleanSegments$1_offsetMap2, cleanSegments$1_stats2);
        cleaner.cleanSegments(log, (Seq)cleanSegments$1_segments2, (OffsetMap)cleanSegments$1_offsetMap2, cleanSegments$1_deleteHorizonMs2, cleanSegments$1_stats2, new CleanedTransactionMetadata());
        l = cleanSegments$1_offsetMap2.latestOffset() + 1L;
        Object var23_22 = null;
        Object var24_23 = null;
        Object var25_24 = null;
        Assertions.assertEquals((long)14L, (long)l);
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 4, 6, 7, 10, 13, 15, 16, 17, 19})), this.batchBaseOffsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 4, 5, 6, 7, 10, 13, 14, 15, 16, 17, 18, 19})), this.offsetsInLog(log));
        this.assertAllTransactionsComplete(log);
        this.assertAllAbortedTxns((List<AbortedTxn>)((List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), log);
        long cleanSegments$1_deleteHorizonMs3 = Long.MAX_VALUE;
        FakeOffsetMap cleanSegments$1_offsetMap3 = new FakeOffsetMap(offsetMapSlots);
        scala.collection.immutable.Seq cleanSegments$1_segments3 = log.logSegments(0L, log.activeSegment().baseOffset()).toSeq();
        CleanerStats cleanSegments$1_stats3 = new CleanerStats((Time)this.time());
        cleaner.buildOffsetMap(log, l, log.activeSegment().baseOffset(), (OffsetMap)cleanSegments$1_offsetMap3, cleanSegments$1_stats3);
        cleaner.cleanSegments(log, (Seq)cleanSegments$1_segments3, (OffsetMap)cleanSegments$1_offsetMap3, cleanSegments$1_deleteHorizonMs3, cleanSegments$1_stats3, new CleanedTransactionMetadata());
        l = cleanSegments$1_offsetMap3.latestOffset() + 1L;
        Object var28_26 = null;
        Object var29_27 = null;
        Object var30_28 = null;
        Assertions.assertEquals((long)20L, (long)l);
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 4, 6, 7, 13, 15, 17, 19})), this.batchBaseOffsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 4, 5, 6, 7, 13, 15, 17, 18, 19})), this.offsetsInLog(log));
        this.assertAllTransactionsComplete(log);
        this.assertAllAbortedTxns((List<AbortedTxn>)((List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), log);
    }

    @Test
    public void testBasicTransactionAwareCleaning() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, pid1, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, pid2, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.commitMarker(pid2, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(pid1, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        List abortedTransactions = log.collectAbortedTransactions(log.logStartOffset(), log.logEndOffset());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)abortedTransactions, (Object)log.collectAbortedTransactions(log.logStartOffset(), log.logEndOffset()));
    }

    @Test
    public void testCleanWithTransactionsSpanningSegments() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, pid1, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, pid2, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Function1<Seq<Object>, LogAppendInfo> appendProducer3 = this.appendTransactionalAsLeader(log, pid3, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log.roll(log.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6, 7})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8})));
        log.appendAsLeader(this.abortMarker(pid2, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer3.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{8, 9})));
        log.appendAsLeader(this.commitMarker(pid3, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{9, 10})));
        log.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        long dirtyOffset = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false))._1$mcJ$sp();
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10})), LogTestUtils$.MODULE$.keysInLog(log));
        log.roll(log.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{11})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{12})));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, dirtyOffset, log.activeSegment().baseOffset(), false));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 6, 7, 8, 9, 11, 12})), LogTestUtils$.MODULE$.keysInLog(log));
    }

    @Test
    public void testCommitMarkerRemoval() {
        File file;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 2})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 4, 5})), this.offsetsInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), 0L)._1$mcJ$sp();
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8})), this.offsetsInLog(log));
    }

    @Test
    public void testDeletedBatchesWithNoMessagesRead() {
        File file;
        TopicPartition tp = new TopicPartition("test", 0);
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, x$3, 100);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(100));
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig x$4 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$5 = file2;
        long l = 0L;
        Log log = this.makeLog(x$5, x$4, l);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE);
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE);
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testCommitMarkerRetentionWithEmptyBatch() {
        File file;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        Function1<Seq<Object>, LogAppendInfo> producer1 = this.appendTransactionalAsLeader(log, 1L, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Function1<Seq<Object>, LogAppendInfo> producer2 = this.appendTransactionalAsLeader(log, 2L, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        producer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.roll(log.roll$default$1());
        producer2.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.commitMarker(2L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.record(2, 2, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(3, 3, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.commitMarker(1L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5, 6, 7})), this.lastOffsetsPerBatchInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5, 6, 7})), this.lastOffsetsPerBatchInLog(log));
        producer2.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.commitMarker(2L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 4, 5, 6, 7, 8, 9})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 5, 6, 7, 8, 9})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testCleanEmptyControlBatch() {
        File file;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        log.appendAsLeader(this.commitMarker(1L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(2, 2, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(3, 3, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testCommittedTransactionSpanningSegments() {
        File file;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(128));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        long producerId = 1L;
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE);
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortedTransactionSpanningSegments() {
        File file;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(128));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        long producerId = 1L;
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE);
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE);
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortMarkerRemoval() {
        File file;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), 0L)._1$mcJ$sp();
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE);
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5})), this.offsetsInLog(log));
    }

    @Test
    public void testEmptyBatchRemovalWithSequenceReuse() {
        File file;
        short producerEpoch = (short)0;
        long producerId = 1L;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        AppendOrigin.Replication$ x$7 = AppendOrigin.Replication$.MODULE$;
        int n = 0;
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, n, (AppendOrigin)x$7).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        AppendOrigin.Replication$ x$12 = AppendOrigin.Replication$.MODULE$;
        int n2 = 0;
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, n2, (AppendOrigin)x$12).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(2, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE);
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE);
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4, 5})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortMarkerRetentionWithEmptyBatch() {
        File file;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((int)0, (int)log.collectAbortedTransactions(0L, 100L).size());
    }

    @Test
    public void testLargeMessage() {
        File file;
        int largeMessageSize = 0x100000;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, x$3, 1024);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$42 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$5 = file2;
        long l = 0L;
        Log log = this.makeLog(x$5, x$42, l);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)(JFunction0.mcB.sp & Serializable)() -> 0, (ClassTag)ClassTag$.MODULE$.Byte())), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        Iterable<Object> keysFound = LogTestUtils$.MODULE$.keysInLog(log);
        Assertions.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        CleanerStats stats = new CleanerStats(Time.SYSTEM);
        cleaner.cleanSegments(log, (Seq)new .colon.colon((Object)((LogSegment)log.logSegments().head()), (List)Nil$.MODULE$), (OffsetMap)map, 0L, stats, new CleanedTransactionMetadata());
        Assertions.assertEquals((Object)((Iterable)LogTestUtils$.MODULE$.keysInLog(log).filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$4 -> !keys.contains((Object)BoxesRunTime.boxToLong((long)x$4)))), LogTestUtils$.MODULE$.keysInLog(log));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMessageLargerThanMaxMessageSize() {
        void var3_3;
        void var2_2;
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Log log = (Log)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        this.makeCleaner(Integer.MAX_VALUE, x$3, 1024).cleanSegments((Log)var2_2, (Seq)new .colon.colon((Object)((LogSegment)var2_2.logSegments().head()), (List)Nil$.MODULE$), (OffsetMap)var3_3, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
        Assertions.assertEquals((Object)((Iterable)LogTestUtils$.MODULE$.keysInLog((Log)var2_2).filter((Function1)((JFunction1.mcZJ.sp & Serializable)arg_0 -> LogCleanerTest.$anonfun$testMessageLargerThanMaxMessageSize$1((FakeOffsetMap)var3_3, arg_0)))), LogTestUtils$.MODULE$.keysInLog((Log)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMessageLargerThanMaxMessageSizeWithCorruptHeader() {
        void var3_3;
        void var2_2;
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Log log = (Log)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        RandomAccessFile file = new RandomAccessFile(((LogSegment)var2_2.logSegments().head()).log().file(), "rw");
        file.seek(16L);
        file.write(255);
        file.close();
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, x$3, 1024);
        Assertions.assertThrows(CorruptRecordException.class, () -> LogCleanerTest.$anonfun$testMessageLargerThanMaxMessageSizeWithCorruptHeader$1(cleaner, (Log)var2_2, (FakeOffsetMap)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCorruptMessageSizeLargerThanBytesAvailable() {
        void var3_3;
        void var2_2;
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Log log = (Log)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        RandomAccessFile file = new RandomAccessFile(((LogSegment)var2_2.logSegments().head()).log().file(), "rw");
        file.setLength(1024L);
        file.close();
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, x$3, 1024);
        Assertions.assertThrows(CorruptRecordException.class, () -> LogCleanerTest.$anonfun$testCorruptMessageSizeLargerThanBytesAvailable$1(cleaner, (Log)var2_2, (FakeOffsetMap)var3_3));
    }

    public Tuple2<Log, FakeOffsetMap> createLogWithMessagesLargerThanMaxSize(int largeMessageSize) {
        File file;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)(JFunction0.mcB.sp & Serializable)() -> 0, (ClassTag)ClassTag$.MODULE$.Byte())), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        Iterable<Object> keysFound = LogTestUtils$.MODULE$.keysInLog(log);
        Assertions.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize / 2));
        log.config_$eq(LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps));
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVI.sp & Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        return new Tuple2((Object)log, (Object)map);
    }

    @Test
    public void testCleaningWithDeletes() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        long leo = log.logEndOffset();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).foreach((Function1 & Serializable)key -> log.appendAsLeader(this.tombstoneRecord(BoxesRunTime.unboxToInt((Object)key)), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        Set keys = LogTestUtils$.MODULE$.keysInLog(log).toSet();
        Assertions.assertTrue((boolean)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).forall((Function1)(JFunction1.mcZI.sp & Serializable)x$8 -> !keys.contains((Object)BoxesRunTime.boxToLong((long)x$8))), (String)"None of the keys we deleted should still exist.");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogCleanerStats() {
        void var11_11;
        void var9_10;
        File file;
        Cleaner cleaner = this.makeCleaner(4, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        long initialLogSize = log.size();
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), false));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long endOffset = tuple2._1$mcJ$sp();
        CleanerStats stats = (CleanerStats)tuple2._2();
        Assertions.assertEquals((long)5L, (long)var9_10);
        Assertions.assertEquals((long)5L, (long)var11_11.messagesRead());
        Assertions.assertEquals((long)initialLogSize, (long)var11_11.bytesRead());
        Assertions.assertEquals((long)2L, (long)var11_11.messagesWritten());
        Assertions.assertEquals((long)log.size(), (long)var11_11.bytesWritten());
        Assertions.assertEquals((long)0L, (long)var11_11.invalidMessagesRead());
        Assertions.assertTrue((var11_11.endTime() >= var11_11.startTime() ? 1 : 0) != 0);
    }

    @Test
    public void testLogCleanerRetainsProducerLastSequence() {
        File file;
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 1, 1L, (short)0, 0, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 2, 2L, (short)0, 0, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 3, 3L, (short)0, 0, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, 2L, (short)0, 1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testLogCleanerRetainsLastSequenceEvenIfTransactionAborted() {
        File file;
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)2))})), this.lastSequencesInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 5})));
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 5})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)4))})), this.lastSequencesInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 5})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleaningWithKeysConflictingWithTxnMarkerKeys() {
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        MemoryRecords memoryRecords;
        File file;
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        int leaderEpoch = 5;
        short producerEpoch = (short)0;
        long producerId1 = 1L;
        this.appendTransactionalAsLeader(log, producerId1, producerEpoch, leaderEpoch, (AppendOrigin)AppendOrigin.Client$.MODULE$).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.commitMarker(producerId1, producerEpoch, this.commitMarker$default$3()), leaderEpoch, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        long producerId2 = 2L;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), LogCleanerTest.commitRecordKey$1(), ByteBuffer.wrap("foo".getBytes()))};
        boolean bl = false;
        CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
        MemoryRecords memoryRecords2 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        Object var14_14 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords2;
        log.appendAsLeader(records, leaderEpoch, (AppendOrigin)AppendOrigin.Client$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.commitMarker(producerId2, producerEpoch, this.commitMarker$default$3()), leaderEpoch, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})), this.offsetsInLog(log));
    }

    @Test
    public void testPartialSegmentClean() {
        File file;
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), false));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 1, 0})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 3L, log.activeSegment().baseOffset(), false));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 0})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 4L, log.activeSegment().baseOffset(), false));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testCleaningWithUncleanableSection() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        int N = 10;
        int numCleanableSegments = 2;
        int numTotalSegments = 7;
        while (log.numberOfSegments() <= numCleanableSegments) {
            log.appendAsLeader(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset(), -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        long firstUncleanableOffset = log.logEndOffset() + 1L;
        while (log.numberOfSegments() < numTotalSegments - 1) {
            log.appendAsLeader(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset(), -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        scala.collection.immutable.Seq disctinctValuesBySegmentBeforeClean = LogCleanerTest.distinctValuesBySegment$1(log);
        Assertions.assertTrue((boolean)((IterableOnceOps)((IterableOps)LogCleanerTest.distinctValuesBySegment$1(log).reverse()).tail()).forall((Function1)(JFunction1.mcZI.sp & Serializable)x$10 -> x$10 > N), (String)"Test is not effective unless each segment contains duplicates. Increase segment size or decrease number of keys.");
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, firstUncleanableOffset, false));
        scala.collection.immutable.Seq distinctValuesBySegmentAfterClean = LogCleanerTest.distinctValuesBySegment$1(log);
        Assertions.assertTrue((boolean)((IterableOnceOps)((IterableOps)disctinctValuesBySegmentBeforeClean.zip((IterableOnce)distinctValuesBySegmentAfterClean)).take(numCleanableSegments)).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$4(x0$1))), (String)"The cleanable segments should have fewer number of values after cleaning");
        Assertions.assertTrue((boolean)((IterableOnceOps)((IterableOps)disctinctValuesBySegmentBeforeClean.zip((IterableOnce)distinctValuesBySegmentAfterClean)).slice(numCleanableSegments, numTotalSegments)).forall((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$5(x))), (String)"The uncleanable segments should have the same number of values after cleaning");
    }

    @Test
    public void testLogToClean() {
        File file;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1 & Serializable)x$11 -> log.appendAsLeader(LogCleanerTest.createRecorcs$1(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        Assertions.assertEquals((long)new LogToClean(new TopicPartition("test", 0), log, log.activeSegment().baseOffset(), log.activeSegment().baseOffset(), false).totalBytes(), (long)(log.size() - (long)log.activeSegment().size()), (String)"Total bytes of LogToClean should equal size of all segments excluding the active segment");
    }

    @Test
    public void testLogToCleanWithUncleanableSection() {
        File file;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1 & Serializable)x$12 -> log.appendAsLeader(LogCleanerTest.createRecords$1(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        scala.collection.immutable.Seq segs = log.logSegments().toSeq();
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log, ((LogSegment)segs.apply(2)).baseOffset(), ((LogSegment)segs.apply(4)).baseOffset(), false);
        int expectedCleanSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((IterableOps)segs.take(2)).map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int expectedCleanableSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((IterableOps)segs.slice(2, 4)).map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertEquals((long)logToClean.cleanBytes(), (long)expectedCleanSize, (String)"Uncleanable bytes of LogToClean should equal size of all segments prior the one containing first dirty");
        Assertions.assertEquals((long)logToClean.cleanableBytes(), (long)expectedCleanableSize, (String)"Cleanable bytes of LogToClean should equal size of all segments from the one containing first dirty offset to the segment prior to the one with the first uncleanable offset");
        Assertions.assertEquals((long)logToClean.totalBytes(), (long)(expectedCleanSize + expectedCleanableSize), (String)"Total bytes should be the sum of the clean and cleanable segments");
        Assertions.assertEquals((double)logToClean.cleanableRatio(), (double)((double)expectedCleanableSize / (double)(expectedCleanSize + expectedCleanableSize)), (double)1.0E-6, (String)"Total cleanable ratio should be the ratio of cleanable size to clean plus cleanable");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleaningWithUnkeyedMessages() {
        void var12_12;
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.unkeyedRecord((int)log.logEndOffset()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        int numInvalidMessages = this.unkeyedMessageCountInLog(log);
        long sizeWithUnkeyedMessages = log.size();
        while (log.numberOfSegments() < 3) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        long expectedSizeAfterCleaning = log.size() - sizeWithUnkeyedMessages;
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        CleanerStats stats = (CleanerStats)tuple2._2();
        Assertions.assertEquals((int)0, (int)this.unkeyedMessageCountInLog(log), (String)"Log should only contain keyed messages after cleaning.");
        Assertions.assertEquals((long)expectedSizeAfterCleaning, (long)log.size(), (String)"Log should only contain keyed messages after cleaning.");
        Assertions.assertEquals((long)numInvalidMessages, (long)var12_12.invalidMessagesRead(), (String)"Cleaner should have seen %d invalid messages.");
    }

    private Iterable<Object> batchBaseOffsetsInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable)segment -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().batches()).asScala().map((Function1 & Serializable)batch -> BoxesRunTime.boxToLong((long)batch.baseOffset())));
    }

    public Iterable<Object> lastOffsetsPerBatchInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable)segment -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().batches()).asScala().map((Function1 & Serializable)batch -> BoxesRunTime.boxToLong((long)batch.lastOffset())));
    }

    public Map<Object, Object> lastSequencesInLog(Log log) {
        return ((IterableOnceOps)log.logSegments().flatMap((Function1 & Serializable)segment -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().batches()).asScala().withFilter((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$lastSequencesInLog$2(batch))).map((Function1 & Serializable)batch -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)BoxesRunTime.boxToInteger((int)batch.lastSequence()))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Iterable<Object> offsetsInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable)s -> (Iterable)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.IterableHasAsScala(s.log().records()).asScala().filter((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.hasValue()))).filter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.hasKey()))).map((Function1 & Serializable)m -> BoxesRunTime.boxToLong((long)m.offset())));
    }

    public int unkeyedMessageCountInLog(Log log) {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)log.logSegments().map((Function1 & Serializable)s -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$unkeyedMessageCountInLog$1(s)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void abortCheckDone(TopicPartition topicPartition) {
        throw new LogCleaningAbortedException();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanSegmentsWithAbort() {
        File file;
        void makeCleaner_checkDone;
        Cleaner cleaner;
        int n = 65536;
        Function1 & Serializable intersect = (Function1 & Serializable)topicPartition -> {
            this.abortCheckDone(topicPartition);
            return BoxedUnit.UNIT;
        };
        int makeCleaner_capacity = Integer.MAX_VALUE;
        Cleaner cleaner2 = cleaner = new Cleaner(0, (OffsetMap)new FakeOffsetMap(makeCleaner_capacity), n, n, 0.75, this.throttler(), (Time)this.time(), (Function1)makeCleaner_checkDone);
        intersect = null;
        cleaner = null;
        Cleaner cleaner3 = cleaner2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        Iterable<Object> keys = LogTestUtils$.MODULE$.keysInLog(log);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        Assertions.assertThrows(LogCleaningAbortedException.class, () -> cleaner3.cleanSegments(log, (Seq)((IterableOnceOps)log.logSegments().take(3)).toSeq(), (OffsetMap)map, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata()));
    }

    @Test
    public void testSegmentGrouping() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        int i = 0;
        while (log.numberOfSegments() < 10) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            ++i;
        }
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)1, (int)groups.size());
        Assertions.assertEquals((int)log.numberOfSegments(), (int)((SeqOps)groups.head()).size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), 1, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)log.numberOfSegments(), (int)groups.size());
        Assertions.assertTrue((boolean)groups.forall((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$1(x$18))), (String)"All groups should be singletons.");
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, 1, log.logEndOffset());
        Assertions.assertEquals((int)log.numberOfSegments(), (int)groups.size());
        Assertions.assertTrue((boolean)groups.forall((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$2(x$19))), (String)"All groups should be singletons.");
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((IterableOps)log.logSegments().take(groupSize)).map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToInteger((int)x$20.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), logSize, Integer.MAX_VALUE, log.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assertions.assertTrue((boolean)((List)groups.dropRight(1)).forall((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$4(groupSize, x$21))), (String)"All but the last group should be the target size.");
        int indexSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((IterableOps)log.logSegments().take(groupSize)).map((Function1 & Serializable)x$22 -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$testSegmentGrouping$5(x$22)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, indexSize, log.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assertions.assertTrue((boolean)((List)groups.dropRight(1)).forall((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$6(groupSize, x$23))), (String)"All but the last group should be the target size.");
    }

    @Test
    public void testSegmentGroupingWithSparseOffsetsAndEmptySegments() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        byte[] k = "key".getBytes();
        byte[] v = "val".getBytes();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(v, k, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            MemoryRecords records = this.messageWithOffset(k, v, ((long)i + 1L) * 0x80000000L - 1L);
            log.appendAsFollower(records);
            Assertions.assertEquals((int)(i + 1), (int)log.numberOfSegments());
        });
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(v, k, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        int totalSegments = 4;
        long firstUncleanableOffset = log.logEndOffset() - 1L;
        int notCleanableSegments = 1;
        Assertions.assertEquals((int)totalSegments, (int)log.numberOfSegments());
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, firstUncleanableOffset);
        Assertions.assertEquals((int)(totalSegments - notCleanableSegments), (int)groups.size());
        cleaner.clean(new LogToClean(log.topicPartition(), log, 0L, firstUncleanableOffset, false));
        Assertions.assertEquals((int)totalSegments, (int)log.numberOfSegments());
        Assertions.assertEquals((int)0, (int)((LogSegment)log.logSegments().head()).size());
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, firstUncleanableOffset);
        Assertions.assertEquals((int)(1 + 1), (int)groups.size());
        cleaner.clean(new LogToClean(log.topicPartition(), log, 0L, firstUncleanableOffset, false));
        Assertions.assertEquals((int)(totalSegments - 1), (int)log.numberOfSegments());
    }

    @Test
    public void testSegmentGroupingWithSparseOffsets() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        while (log.numberOfSegments() == 1) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        MemoryRecords records = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x7FFFFFFEL);
        log.appendAsFollower(records);
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((long)Integer.MAX_VALUE, (long)log.activeSegment().offsetIndex().lastOffset());
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)1, (int)groups.size());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)2, (int)groups.size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)(log.numberOfSegments() - 1), (int)groups.size());
        groups.foreach((Function1 & Serializable)group -> {
            LogCleanerTest.$anonfun$testSegmentGroupingWithSparseOffsets$1(group);
            return BoxedUnit.UNIT;
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    @Test
    public void testSegmentGroupingFollowingLoadOfZeroIndex() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(400));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        MemoryRecords record1 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0L);
        log.appendAsFollower(record1);
        MemoryRecords record2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 1L);
        log.appendAsFollower(record2);
        log.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0x3FFFFFFFL)));
        MemoryRecords record3 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x3FFFFFFFL);
        log.appendAsFollower(record3);
        MemoryRecords record4 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), (long)Integer.MAX_VALUE + 1L);
        log.appendAsFollower(record4);
        Assertions.assertTrue((log.logEndOffset() - 1L - log.logStartOffset() > Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Actual offset range should be > Int.MaxValue");
        Assertions.assertTrue((((LogSegment)log.logSegments().last()).offsetIndex().lastOffset() - log.logStartOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"index.lastOffset is reporting the wrong last offset");
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)2, (int)groups.size());
        groups.foreach((Function1 & Serializable)group -> {
            LogCleanerTest.$anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1(group);
            return BoxedUnit.UNIT;
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1 & Serializable)x$24 -> (Seq)x$24.map((Function1 & Serializable)x$25 -> BoxesRunTime.boxToLong((long)x$25.baseOffset())));
        Assertions.assertEquals((Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets, (String)"Offsets should be in increasing order.");
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Log log = this.makeLog(this.dir(), this.logConfig(), 0L);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        int start = 0;
        int end = 500;
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(start), end).zip((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(start), end))));
        scala.collection.immutable.Seq segments = log.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), cleaner, log);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), cleaner, log);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log.logEndOffset(), cleaner, log);
    }

    @Test
    public void testSegmentWithOffsetOverflow() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        LogTestUtils$.MODULE$.initializeLogDirWithOverflowedSegment(this.dir());
        File file2 = file = this.dir();
        file = null;
        File x$3 = file2;
        Log log = this.makeLog(x$3, config, Long.MAX_VALUE);
        LogSegment segmentWithOverflow = (LogSegment)LogTestUtils$.MODULE$.firstOverflowSegment(log).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)"Failed to create log with a segment which has overflowed offsets");
        });
        int numSegmentsInitial = log.logSegments().size();
        List allKeys = LogTestUtils$.MODULE$.keysInLog(log).toList();
        ArrayBuffer expectedKeysAfterCleaning = new ArrayBuffer();
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), allKeys.size()).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)k -> {
            expectedKeysAfterCleaning.$plus$eq(allKeys.apply(k - 1));
            offsetMap.put(this.key(BoxesRunTime.unboxToLong((Object)allKeys.apply(k))), Long.MAX_VALUE);
        });
        Assertions.assertThrows(LogCleaningAbortedException.class, () -> cleaner.cleanSegments(log, (Seq)new .colon.colon((Object)segmentWithOverflow, (List)Nil$.MODULE$), (OffsetMap)offsetMap, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata()));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)log.logSegments().size());
        Assertions.assertEquals((Object)allKeys, LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertFalse((boolean)LogTestUtils$.MODULE$.hasOffsetOverflow(log));
        log.logSegments().foreach((Function1 & Serializable)segmentToClean -> {
            cleaner.cleanSegments(log, (Seq)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{segmentToClean})), (OffsetMap)offsetMap, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)expectedKeysAfterCleaning, LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertFalse((boolean)LogTestUtils$.MODULE$.hasOffsetOverflow(log));
        log.close();
    }

    @Test
    public void testRecoveryAfterCrash() {
        File file2;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(10));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file3 = file2 = this.dir();
        file2 = null;
        File x$2 = file3;
        long l = 0L;
        Log log = this.makeLog(x$2, config, l);
        int messageCount = 0;
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$4 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), -1L, (short)-1, -1, -1);
            AppendOrigin x$6 = log.appendAsLeader$default$3();
            ApiVersion x$7 = log.appendAsLeader$default$4();
            RequestLocal x$8 = log.appendAsLeader$default$5();
            log.appendAsLeader(x$4, 0, x$6, x$7, x$8);
            ++messageCount;
        }
        Iterable<Object> allKeys = LogTestUtils$.MODULE$.keysInLog(log);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, (Seq)((IterableOnceOps)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        LogTestUtils$.MODULE$.keysInLog(log);
        log.close();
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$2(file))).foreach((Function1 & Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$3(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck(config, allKeys);
        cleaner.cleanSegments(log, (Seq)((IterableOnceOps)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        LogTestUtils$.MODULE$.keysInLog(log);
        log.close();
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        ((LogSegment)log.logSegments().head()).log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(((LogSegment)log.logSegments().head()).log().file().getPath(), Log$.MODULE$.CleanedFileSuffix(), Log$.MODULE$.SwapFileSuffix())));
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$4(file))).foreach((Function1 & Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$5(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck(config, allKeys);
        cleaner.cleanSegments(log, (Seq)((IterableOnceOps)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        Iterable<Object> cleanedKeys = LogTestUtils$.MODULE$.keysInLog(log);
        log.close();
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$6(file))).foreach((Function1 & Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$7(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$9 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), -1L, (short)-1, -1, -1);
            AppendOrigin x$11 = log.appendAsLeader$default$3();
            ApiVersion x$12 = log.appendAsLeader$default$4();
            RequestLocal x$13 = log.appendAsLeader$default$5();
            log.appendAsLeader(x$9, 0, x$11, x$12, x$13);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, (Seq)((IterableOnceOps)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        cleanedKeys = LogTestUtils$.MODULE$.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        log = this.recoverAndCheck(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$14 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), -1L, (short)-1, -1, -1);
            AppendOrigin x$16 = log.appendAsLeader$default$3();
            ApiVersion x$17 = log.appendAsLeader$default$4();
            RequestLocal x$18 = log.appendAsLeader$default$5();
            log.appendAsLeader(x$14, 0, x$16, x$17, x$18);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, (Seq)((IterableOnceOps)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        cleanedKeys = LogTestUtils$.MODULE$.keysInLog(log);
        ((LogSegment)log.logSegments().head()).timeIndex().file().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(((LogSegment)log.logSegments().head()).timeIndex().file().getPath(), "", Log$.MODULE$.SwapFileSuffix())));
        log = this.recoverAndCheck(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$19 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), -1L, (short)-1, -1, -1);
            AppendOrigin x$21 = log.appendAsLeader$default$3();
            ApiVersion x$22 = log.appendAsLeader$default$4();
            RequestLocal x$23 = log.appendAsLeader$default$5();
            log.appendAsLeader(x$19, 0, x$21, x$22, x$23);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, (Seq)((IterableOnceOps)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        cleanedKeys = LogTestUtils$.MODULE$.keysInLog(log);
        log.close();
        log = this.recoverAndCheck(config, cleanedKeys);
        log.close();
    }

    @Test
    public void testBuildOffsetMapFakeLarge() {
        File file;
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, logConfig, l);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        int keyStart = 0;
        int keyEnd = 2;
        long offsetStart = 0L;
        long offsetEnd = 7206178L;
        Seq offsetSeq = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{offsetStart, offsetEnd}));
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(keyStart), keyEnd).zip((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(keyStart), keyEnd))), (Iterable<Object>)offsetSeq);
        cleaner.buildOffsetMap(log, (long)keyStart, offsetEnd + 1L, (OffsetMap)map, new CleanerStats(Time.SYSTEM));
        Assertions.assertEquals((long)offsetEnd, (long)map.latestOffset(), (String)"Last offset should be the end offset.");
        Assertions.assertEquals((int)(keyEnd - keyStart), (int)map.size(), (String)"Should have the expected number of messages in the map.");
        Assertions.assertEquals((long)0L, (long)map.get(this.key(0L)), (String)"Map should contain first value");
        Assertions.assertEquals((long)offsetEnd, (long)map.get(this.key(1L)), (String)"Map should contain second value");
    }

    @Test
    public void testBuildPartialOffsetMap() {
        Log log = this.makeLog(this.dir(), this.logConfig(), 0L);
        Cleaner cleaner = this.makeCleaner(3, this.makeCleaner$default$2(), 65536);
        OffsetMap map = cleaner.offsetMap();
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(2, 2, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(3, 3, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(4, 4, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        CleanerStats stats = new CleanerStats(Time.SYSTEM);
        cleaner.buildOffsetMap(log, 2L, Integer.MAX_VALUE, map, stats);
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((long)-1L, (long)map.get(this.key(0L)));
        Assertions.assertEquals((long)2L, (long)map.get(this.key(2L)));
        Assertions.assertEquals((long)3L, (long)map.get(this.key(3L)));
        Assertions.assertEquals((long)-1L, (long)map.get(this.key(4L)));
        Assertions.assertEquals((long)4L, (long)stats.mapMessagesRead());
    }

    @Test
    public void testCleanCorruptMessageSet() {
        File file;
        CompressionType codec = CompressionType.GZIP;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), codec.name);
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, logConfig, l);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), 65536);
        IndexedSeq dupSetKeys = (IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).$plus$plus((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2));
        int dupSetOffset = 25;
        IndexedSeq dupSet = (IndexedSeq)dupSetKeys.zip((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(dupSetOffset), dupSetOffset + dupSetKeys.size()));
        Range noDupSetKeys = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(3), 5);
        int noDupSetOffset = 50;
        IndexedSeq noDupSet = (IndexedSeq)noDupSetKeys.zip((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(noDupSetOffset), noDupSetOffset + noDupSetKeys.size()));
        log.appendAsFollower(this.invalidCleanedMessage(dupSetOffset, (Iterable<Tuple2<Object, Object>>)dupSet, codec));
        log.appendAsFollower(this.invalidCleanedMessage(noDupSetOffset, (Iterable<Tuple2<Object, Object>>)noDupSet, codec));
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        log.logSegments().foreach((Function1 & Serializable)segment -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$1(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testClientHandlingOfCorruptMessageSet() {
        Range keys = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 10);
        int offset = 50;
        IndexedSeq set = (IndexedSeq)keys.zip((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(offset), offset + keys.size()));
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.invalidCleanedMessage(offset, (Iterable<Tuple2<Object, Object>>)set, CompressionType.GZIP).buffer());
        CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().foreach((Function1 & Serializable)logEntry -> {
            LogCleanerTest.$anonfun$testClientHandlingOfCorruptMessageSet$1(logEntry);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCleanTombstone() {
        CompressionType compressionType;
        CompressionType compressionType2;
        CompressionType compressionType3;
        File file;
        LogConfig logConfig = new LogConfig((java.util.Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, logConfig, l);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), 65536);
        byte[] x$4 = "0".getBytes();
        byte[] x$5 = "0".getBytes();
        long x$6 = this.time().milliseconds() + Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) + 10000L;
        CompressionType compressionType4 = compressionType3 = CompressionType.NONE;
        compressionType3 = null;
        CompressionType x$7 = compressionType4;
        byte by = 2;
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$4, x$5, x$7, x$6, by), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        byte[] x$10 = "0".getBytes();
        long x$11 = this.time().milliseconds() - Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) - 10000L;
        CompressionType compressionType5 = compressionType2 = CompressionType.NONE;
        compressionType2 = null;
        CompressionType x$12 = compressionType5;
        byte by2 = 2;
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(null, x$10, x$12, x$11, by2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 1L, log.activeSegment().baseOffset(), false));
        Assertions.assertEquals((long)1L, (long)((RecordBatch)((LogSegment)log.logSegments().head()).log().batches().iterator().next()).lastOffset(), (String)"The tombstone should be retained.");
        byte[] x$14 = "1".getBytes();
        byte[] x$15 = "1".getBytes();
        long x$16 = this.time().milliseconds();
        CompressionType compressionType6 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$17 = compressionType6;
        byte by3 = 2;
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$14, x$15, x$17, x$16, by3), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), false));
        Assertions.assertEquals((long)1L, (long)((RecordBatch)((LogSegment)log.logSegments().head()).log().batches().iterator().next()).lastOffset(), (String)"The tombstone should be retained.");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleaningBeyondMissingOffsets() {
        void var10_9;
        void var6_6;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(0x100000));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Log log = this.makeLog(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir()), logConfig, 0L);
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 9).zip((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 9))), (Iterable<Object>)new RichLong(Predef$.MODULE$.longWrapper(0L)).to((Object)BoxesRunTime.boxToLong((long)9L)));
        log.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)11L)));
        log.appendAsFollower(this.messageWithOffset(1015, 1015, 11L));
        Tuple2 tuple2 = cleaner.clean(new LogToClean(log.topicPartition(), log, 0L, log.activeSegment().baseOffset(), true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)var6_6, (String)"Cleaning point should pass offset gap");
        Log log2 = this.makeLog(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir()), logConfig, 0L);
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 9).zip((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 9))), (Iterable<Object>)new RichLong(Predef$.MODULE$.longWrapper(0L)).to((Object)BoxesRunTime.boxToLong((long)9L)));
        log2.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)15L)));
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(15), 24).zip((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(15), 24))), (Iterable<Object>)new RichLong(Predef$.MODULE$.longWrapper(15L)).to((Object)BoxesRunTime.boxToLong((long)24L)));
        log2.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)30L)));
        log2.appendAsFollower(this.messageWithOffset(1015, 1015, 30L));
        Tuple2 tuple22 = cleaner.clean(new LogToClean(log2.topicPartition(), log2, 0L, log2.activeSegment().baseOffset(), true));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset2 = tuple22._1$mcJ$sp();
        Assertions.assertEquals((long)log2.activeSegment().baseOffset(), (long)var10_9, (String)"Cleaning point should pass offset gap in multiple segments");
    }

    @Test
    public void testMaxCleanTimeSecs() {
        Object[] objectArray = new File[1];
        objectArray[0] = TestUtils.tempDirectory(null, null);
        LogCleaner logCleaner = new LogCleaner(new CleanerConfig(1, 0x400000L, 0.9, 0x100000, 0x2000000, Double.MAX_VALUE, 15000L, true, "MD5"), (Seq)Predef$.MODULE$.wrapRefArray(objectArray), new Pool((Option)None$.MODULE$), new LogDirFailureChannel(1), (Time)this.time());
        try {
            this.checkGauge$1("max-buffer-utilization-percent", logCleaner);
            this.checkGauge$1("max-clean-time-secs", logCleaner);
            this.checkGauge$1("max-compaction-delay-secs", logCleaner);
        }
        finally {
            logCleaner.shutdown();
        }
    }

    private Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> keysAndValues, Iterable<Object> offsetSeq) {
        return (Iterable)((IterableOps)keysAndValues.zip(offsetSeq)).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null && (Tuple2)check$ifrefutable$1._1() != null))).map((Function1 & Serializable)x$26 -> BoxesRunTime.boxToLong((long)LogCleanerTest.$anonfun$writeToLog$2(this, log, x$26)));
    }

    private MemoryRecords invalidCleanedMessage(long initialOffset, Iterable<Tuple2<Object, Object>> keysAndValues, CompressionType codec) {
        Iterable records = (Iterable)keysAndValues.map((Function1 & Serializable)kv -> LegacyRecord.create((byte)0, (long)-1L, (byte[])Integer.toString(kv._1$mcI$sp()).getBytes(), (byte[])Integer.toString(kv._2$mcI$sp()).getBytes(), (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((IterableOnceOps)records.map((Function1 & Serializable)x$27 -> BoxesRunTime.boxToInteger((int)x$27.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536)), (byte)1, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)initialOffset);
        LongRef offset = LongRef.create((long)initialOffset);
        records.foreach((Function1 & Serializable)record -> {
            LogCleanerTest.$anonfun$invalidCleanedMessage$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private CompressionType invalidCleanedMessage$default$3() {
        return CompressionType.GZIP;
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords messageWithOffset(byte[] key, byte[] value, long offset) {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(key, value)};
        boolean bl = false;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    private MemoryRecords messageWithOffset(int key, int value, long offset) {
        return this.messageWithOffset(Integer.toString(key).getBytes(), Integer.toString(value).getBytes(), offset);
    }

    private Log makeLog(File dir, LogConfig config, long recoveryPoint) {
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        None$ x$11 = None$.MODULE$;
        boolean bl = true;
        return Log$.MODULE$.apply(dir, config, 0L, recoveryPoint, (Scheduler)x$5, x$7, (Time)x$6, 3600000, x$9, x$10, bl, (Option)x$11, true);
    }

    private File makeLog$default$1() {
        return this.dir();
    }

    private LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    private long makeLog$default$3() {
        return 0L;
    }

    private Cleaner makeCleaner(int capacity, Function1<TopicPartition, BoxedUnit> checkDone, int maxMessageSize) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), maxMessageSize, maxMessageSize, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    private Function1<TopicPartition, BoxedUnit> makeCleaner$default$2() {
        return (Function1 & Serializable)x$28 -> {
            LogCleanerTest.$anonfun$makeCleaner$default$2$1(x$28);
            return BoxedUnit.UNIT;
        };
    }

    private int makeCleaner$default$3() {
        return 65536;
    }

    private Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).map((Function1 & Serializable)x$29 -> BoxesRunTime.boxToLong((long)LogCleanerTest.$anonfun$writeToLog$4(this, log, x$29)));
    }

    private ByteBuffer key(long id) {
        return ByteBuffer.wrap(Long.toString(id).getBytes());
    }

    private MemoryRecords record(int key, int value, long producerId, short producerEpoch, int sequence, int partitionLeaderEpoch) {
        SimpleRecord[] withIdempotentRecords_records = new SimpleRecord[]{new SimpleRecord(Integer.toString(key).getBytes(), Integer.toString(value).getBytes())};
        return MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
    }

    private Function1<Seq<Object>, LogAppendInfo> appendTransactionalAsLeader(Log log, long producerId, short producerEpoch, int leaderEpoch, AppendOrigin origin) {
        return this.appendIdempotentAsLeader(log, producerId, producerEpoch, true, leaderEpoch, origin);
    }

    private int appendTransactionalAsLeader$default$4() {
        return 0;
    }

    private AppendOrigin appendTransactionalAsLeader$default$5() {
        return AppendOrigin.Client$.MODULE$;
    }

    private Function1<Seq<Object>, LogAppendInfo> appendIdempotentAsLeader(Log log, long producerId, short producerEpoch, boolean isTransactional, int leaderEpoch, AppendOrigin origin) {
        IntRef sequence = IntRef.create((int)0);
        return (Function1 & Serializable)keys -> {
            MemoryRecords memoryRecords;
            Seq simpleRecords = (Seq)keys.map((Function1 & Serializable)key -> LogCleanerTest.$anonfun$appendIdempotentAsLeader$2(this, BoxesRunTime.unboxToInt((Object)key)));
            if (isTransactional) {
                void withTransactionalRecords_records;
                void withTransactionalRecords_baseSequence;
                SimpleRecord[] simpleRecordArray = (SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
                int n = sequence$1.elem;
                CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
                memoryRecords = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
                Object var12_12 = null;
                simpleRecordArray = null;
            } else {
                void withIdempotentRecords_records;
                void withIdempotentRecords_baseSequence;
                MemoryRecords memoryRecords2;
                SimpleRecord[] simpleRecordArray = (SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
                int n = sequence$1.elem;
                CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
                memoryRecords = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)withIdempotentRecords_baseSequence, (int)-1, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
                Object var15_15 = null;
                simpleRecordArray = null;
                memoryRecords2 = null;
            }
            MemoryRecords records = memoryRecords;
            sequence$1.elem += simpleRecords.size();
            return log.appendAsLeader(records, leaderEpoch, origin, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        };
    }

    private boolean appendIdempotentAsLeader$default$4() {
        return false;
    }

    private int appendIdempotentAsLeader$default$5() {
        return 0;
    }

    private AppendOrigin appendIdempotentAsLeader$default$6() {
        return AppendOrigin.Client$.MODULE$;
    }

    private MemoryRecords commitMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.COMMIT, 0L, timestamp);
    }

    private long commitMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords abortMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.ABORT, 0L, timestamp);
    }

    private long abortMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords endTxnMarker(long producerId, short producerEpoch, ControlRecordType controlRecordType, long offset, long timestamp) {
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlRecordType, 0);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)endTxnMarker);
    }

    private MemoryRecords record(int key, byte[] value) {
        CompressionType compressionType;
        byte[] x$1 = Integer.toString(key).getBytes();
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$3 = compressionType2;
        long l = -1L;
        byte by = 2;
        return TestUtils$.MODULE$.singletonRecords(value, x$1, x$3, l, by);
    }

    private long record$default$3() {
        return -1L;
    }

    private short record$default$4() {
        return -1;
    }

    private int record$default$5() {
        return -1;
    }

    private int record$default$6() {
        return -1;
    }

    private MemoryRecords unkeyedRecord(int value) {
        return TestUtils$.MODULE$.singletonRecords(Integer.toString(value).getBytes(), null, CompressionType.NONE, -1L, (byte)2);
    }

    private MemoryRecords tombstoneRecord(int key) {
        return this.record(key, null);
    }

    private Log recoverAndCheck(LogConfig config, Iterable<Object> expectedKeys) {
        return LogTestUtils$.MODULE$.recoverAndCheck(this.dir(), config, expectedKeys, new BrokerTopicStats(), (Time)this.time(), this.time().scheduler());
    }

    private final void reloadLog$1(ObjectRef log$2, Properties logProps$1) {
        File file;
        ((Log)log$2.elem).close();
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps$1);
        File file2 = file = this.dir();
        file = null;
        File x$3 = file2;
        log$2.elem = this.makeLog(x$3, x$1, 0L);
    }

    public static final /* synthetic */ boolean $anonfun$assertAllTransactionsComplete$1(DescribeProducersResponseData.ProducerState x$3) {
        return x$3.currentTxnStartOffset() == -1L;
    }

    private final void abort$1(long producerId, Log log$3, short producerEpoch$1) {
        log$3.appendAsLeader(this.abortMarker(producerId, producerEpoch$1, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Replication$.MODULE$, log$3.appendAsLeader$default$4(), log$3.appendAsLeader$default$5());
    }

    private final void commit$1(long producerId, Log log$3, short producerEpoch$1) {
        log$3.appendAsLeader(this.commitMarker(producerId, producerEpoch$1, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Replication$.MODULE$, log$3.appendAsLeader$default$4(), log$3.appendAsLeader$default$5());
    }

    private final void cleanSegments$1(long deleteHorizonMs, int offsetMapSlots$1, Log log$3, Cleaner cleaner$1, LongRef dirtyOffset$1) {
        FakeOffsetMap offsetMap = new FakeOffsetMap(offsetMapSlots$1);
        scala.collection.immutable.Seq segments = log$3.logSegments(0L, log$3.activeSegment().baseOffset()).toSeq();
        CleanerStats stats = new CleanerStats((Time)this.time());
        cleaner$1.buildOffsetMap(log$3, dirtyOffset$1.elem, log$3.activeSegment().baseOffset(), (OffsetMap)offsetMap, stats);
        cleaner$1.cleanSegments(log$3, (Seq)segments, (OffsetMap)offsetMap, deleteHorizonMs, stats, new CleanedTransactionMetadata());
        dirtyOffset$1.elem = offsetMap.latestOffset() + 1L;
    }

    private static final void assertAbortedTransactionIndexed$1(Log log$4, long producerId$1) {
        List abortedTxns = log$4.collectAbortedTransactions(0L, 100L);
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        Assertions.assertEquals((long)producerId$1, (long)((AbortedTxn)abortedTxns.head()).producerId());
        Assertions.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.head()).firstOffset());
        Assertions.assertEquals((long)2L, (long)((AbortedTxn)abortedTxns.head()).lastOffset());
    }

    public static final /* synthetic */ boolean $anonfun$testMessageLargerThanMaxMessageSize$1(FakeOffsetMap offsetMap$1, long k) {
        return !offsetMap$1.map().containsKey(Long.toString(k));
    }

    public static final /* synthetic */ void $anonfun$testMessageLargerThanMaxMessageSizeWithCorruptHeader$1(Cleaner cleaner$2, Log log$5, FakeOffsetMap offsetMap$2) {
        cleaner$2.cleanSegments(log$5, (Seq)new .colon.colon((Object)((LogSegment)log$5.logSegments().head()), (List)Nil$.MODULE$), (OffsetMap)offsetMap$2, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
    }

    public static final /* synthetic */ void $anonfun$testCorruptMessageSizeLargerThanBytesAvailable$1(Cleaner cleaner$3, Log log$6, FakeOffsetMap offsetMap$3) {
        cleaner$3.cleanSegments(log$6, (Seq)new .colon.colon((Object)((LogSegment)log$6.logSegments().head()), (List)Nil$.MODULE$), (OffsetMap)offsetMap$3, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
    }

    /*
     * WARNING - void declaration
     */
    private static final ByteBuffer commitRecordKey$1() {
        void var0;
        ByteBuffer key = ByteBuffer.allocate(ControlRecordType.COMMIT.recordKey().sizeOf());
        ControlRecordType.COMMIT.recordKey().writeTo(key);
        key.flip();
        return var0;
    }

    public static final /* synthetic */ int $anonfun$testCleaningWithUncleanableSection$1(LogSegment s) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(s.log().records()).asScala().map((Function1 & Serializable)record -> TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toSet().size();
    }

    private static final scala.collection.immutable.Seq distinctValuesBySegment$1(Log log$8) {
        return ((IterableOnceOps)log$8.logSegments().map((Function1 & Serializable)s -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$1(s)))).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$testCleaningWithUncleanableSection$4(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int before = x0$1._1$mcI$sp();
        boolean bl = x0$1._2$mcI$sp() < before;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testCleaningWithUncleanableSection$5(Tuple2 x) {
        return x._1$mcI$sp() == x._2$mcI$sp();
    }

    private static final MemoryRecords createRecorcs$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)(JFunction0.mcB.sp & Serializable)() -> 0, (ClassTag)ClassTag$.MODULE$.Byte()), Integer.toString(1).getBytes(), CompressionType.NONE, -1L, (byte)2);
    }

    private static final MemoryRecords createRecords$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)(JFunction0.mcB.sp & Serializable)() -> 0, (ClassTag)ClassTag$.MODULE$.Byte()), Integer.toString(1).getBytes(), CompressionType.NONE, -1L, (byte)2);
    }

    public static final /* synthetic */ boolean $anonfun$lastSequencesInLog$2(FileLogInputStream.FileChannelRecordBatch batch) {
        return !batch.isControlBatch() && batch.hasProducerId();
    }

    public static final /* synthetic */ boolean $anonfun$unkeyedMessageCountInLog$3(Record m) {
        return !m.hasKey();
    }

    public static final /* synthetic */ int $anonfun$unkeyedMessageCountInLog$1(LogSegment s) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(s.log().records()).asScala().filter((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.hasValue()))).count((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$unkeyedMessageCountInLog$3(m)));
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$1(Seq x$18) {
        return x$18.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$2(Seq x$19) {
        return x$19.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$4(int groupSize$1, Seq x$21) {
        return x$21.size() == groupSize$1;
    }

    public static final /* synthetic */ int $anonfun$testSegmentGrouping$5(LogSegment x$22) {
        return x$22.offsetIndex().sizeInBytes();
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$6(int groupSize$1, Seq x$23) {
        return x$23.size() == groupSize$1;
    }

    public static final /* synthetic */ void $anonfun$testSegmentGroupingWithSparseOffsets$1(Seq group) {
        Assertions.assertTrue((((LogSegment)group.last()).offsetIndex().lastOffset() - ((LogSegment)group.head()).offsetIndex().baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Relative offset greater than Int.MaxValue");
    }

    public static final /* synthetic */ void $anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1(Seq group) {
        Assertions.assertTrue((((LogSegment)group.last()).readNextOffset() - 1L - ((LogSegment)group.head()).baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Relative offset greater than Int.MaxValue");
    }

    private final void checkRange$1(FakeOffsetMap map, int start, int end, Cleaner cleaner$5, Log log$13) {
        CleanerStats stats = new CleanerStats(Time.SYSTEM);
        cleaner$5.buildOffsetMap(log$13, (long)start, (long)end, (OffsetMap)map, stats);
        long endOffset = map.latestOffset() + 1L;
        Assertions.assertEquals((long)end, (long)endOffset, (String)"Last offset should be the end offset.");
        Assertions.assertEquals((int)(end - start), (int)map.size(), (String)"Should have the expected number of messages in the map.");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(start), end).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((long)i, (long)map.get(this.key(i)), (String)"Should find all the keys"));
        Assertions.assertEquals((long)-1L, (long)map.get(this.key(start - 1)), (String)"Should not find a value too small");
        Assertions.assertEquals((long)-1L, (long)map.get(this.key(end)), (String)"Should not find a value too large");
        Assertions.assertEquals((long)(end - start), (long)stats.mapMessagesRead());
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$2(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]), (boolean)false);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$4(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$5(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]), (boolean)false);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$6(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$7(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]), (boolean)false);
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$3(FileLogInputStream.FileChannelRecordBatch batch$1, Record record) {
        Assertions.assertTrue((boolean)record.hasMagic(batch$1.magic()));
        long value = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2())));
        Assertions.assertEquals((long)record.offset(), (long)value);
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$2(FileLogInputStream.FileChannelRecordBatch batch) {
        CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$3(batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$1(LogSegment segment) {
        CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().batches()).asScala().foreach((Function1 & Serializable)batch -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$2(batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testClientHandlingOfCorruptMessageSet$1(Record logEntry) {
        long offset = logEntry.offset();
        long value = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(logEntry.value(), TestUtils$.MODULE$.readString$default$2())));
        Assertions.assertEquals((long)offset, (long)value);
    }

    public static final /* synthetic */ int kafka$log$LogCleanerTest$$$anonfun$testMaxCleanTimeSecs$1() {
        return 999;
    }

    private final void checkGauge$1(String name, LogCleaner logCleaner$1) {
        Gauge gauge = logCleaner$1.newGauge(name, (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerTest $outer;

            public final int value() {
                return 999;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, logCleaner$1.newGauge$default$3());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ long $anonfun$writeToLog$2(LogCleanerTest $this, Log log$15, Tuple2 x$26) {
        long offset;
        Tuple2 tuple2;
        block3: {
            block2: {
                if (x$26 == null) break block2;
                tuple2 = (Tuple2)x$26._1();
                offset = x$26._2$mcJ$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)x$26);
        }
        int key = tuple2._1$mcI$sp();
        int value = tuple2._2$mcI$sp();
        long l = log$15.appendAsFollower($this.messageWithOffset(key, value, offset)).lastOffset();
        return l;
    }

    public static final /* synthetic */ void $anonfun$invalidCleanedMessage$3(MemoryRecordsBuilder builder$1, LongRef offset$1, LegacyRecord record) {
        builder$1.appendUncheckedWithOffset(offset$1.elem, record);
        ++offset$1.elem;
    }

    public static final /* synthetic */ void $anonfun$makeCleaner$default$2$1(TopicPartition x$28) {
    }

    public static final /* synthetic */ long $anonfun$writeToLog$4(LogCleanerTest $this, Log log$16, Tuple2 x$29) {
        if (x$29 == null) {
            throw new MatchError(null);
        }
        int key = x$29._1$mcI$sp();
        int value = x$29._2$mcI$sp();
        long l = ((LogOffsetMetadata)log$16.appendAsLeader($this.record(key, value, -1L, (short)-1, -1, -1), 0, log$16.appendAsLeader$default$3(), log$16.appendAsLeader$default$4(), log$16.appendAsLeader$default$5()).firstOffset().get()).messageOffset();
        return l;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendIdempotentAsLeader$2(LogCleanerTest $this, int key) {
        byte[] keyBytes = Integer.toString(key).getBytes();
        return new SimpleRecord($this.time().milliseconds(), keyBytes, keyBytes);
    }

    public LogCleanerTest() {
        String string;
        String string2;
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), Long.toString(Long.MAX_VALUE));
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime();
        MockTime x$3 = this.time();
        boolean bl = true;
        String string3 = string2 = "throttler";
        string2 = null;
        String x$5 = string3;
        String string4 = string = "entries";
        string = null;
        String x$6 = string4;
        this.throttler = new Throttler(Double.MAX_VALUE, Long.MAX_VALUE, bl, x$5, x$6, (Time)x$3);
    }
}

