/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignPartitionsIntegrationTest$LogDirReassignment$;
import kafka.admin.ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$;
import kafka.api.KAFKA_2_7_IV1$;
import kafka.server.IsrChangePropagationConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.server.ZkIsrManager$;
import kafka.utils.Implicits;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0005\u0011Ub\u0001\u00022d\u0001!DQa\u001c\u0001\u0005\u0002ADqa\u001d\u0001A\u0002\u0013\u0005A\u000fC\u0005\u0002t\u0002\u0001\r\u0011\"\u0001\u0002v\"9\u0011\u0011 \u0001!B\u0013)\bbBA~\u0001\u0011\u0005\u00131\u001c\u0005\n\u0005'\u0001!\u0019!C\u0001\u0005+A\u0001B!\u000b\u0001A\u0003%!q\u0003\u0005\b\u0005W\u0001A\u0011AAn\u0011\u001d\u0011)\u0004\u0001C\u0001\u00037DqA!\u000f\u0001\t\u0003\tY\u000eC\u0004\u0003>\u0001!\t!a7\t\u000f\t}\u0002\u0001\"\u0001\u0002\\\"9!1\t\u0001\u0005\u0002\u0005m\u0007b\u0002B$\u0001\u0011\u0005\u00111\u001c\u0005\b\u0005\u0017\u0002A\u0011AAn\u0011\u001d\u0011y\u0005\u0001C\u0001\u00037DqAa\u0015\u0001\t\u0013\u0011)\u0006C\u0004\u0003f\u0001!IAa\u001a\t\u000f\t=\u0004\u0001\"\u0003\u0003r!9!1\u0010\u0001\u0005\n\tu\u0004b\u0002BC\u0001\u0011%!q\u0011\u0005\b\u0005\u001b\u0003A\u0011AAn\u0011\u001d\u0011\t\n\u0001C\u0001\u000374aA!&\u0001\u0001\n]\u0005B\u0003B\\1\tU\r\u0011\"\u0001\u0002\u0012!Q!\u0011\u0018\r\u0003\u0012\u0003\u0006I!a\u0005\t\u0015\tm\u0006D!f\u0001\n\u0003\t\t\u0002\u0003\u0006\u0003>b\u0011\t\u0012)A\u0005\u0003'A!Ba0\u0019\u0005+\u0007I\u0011AA\t\u0011)\u0011\t\r\u0007B\tB\u0003%\u00111\u0003\u0005\u0007_b!\tAa1\t\u0013\t5\u0007$!A\u0005\u0002\t=\u0007\"\u0003Bl1E\u0005I\u0011\u0001Bm\u0011%\u0011y\u000fGI\u0001\n\u0003\u0011I\u000eC\u0005\u0003rb\t\n\u0011\"\u0001\u0003Z\"I!1\u001f\r\u0002\u0002\u0013\u0005#Q\u001f\u0005\n\u0005oD\u0012\u0011!C\u0001\u0005sD\u0011Ba?\u0019\u0003\u0003%\tA!@\t\u0013\r\u001d\u0001$!A\u0005B\r%\u0001\"CB\t1\u0005\u0005I\u0011AB\n\u0011%\u0019i\u0002GA\u0001\n\u0003\u001ay\u0002C\u0005\u0004$a\t\t\u0011\"\u0011\u0004&!I1q\u0005\r\u0002\u0002\u0013\u00053\u0011\u0006\u0005\n\u0007WA\u0012\u0011!C!\u0007[9\u0011b!\r\u0001\u0003\u0003E\taa\r\u0007\u0013\tU\u0005!!A\t\u0002\rU\u0002BB8/\t\u0003\u00199\u0005C\u0005\u0004(9\n\t\u0011\"\u0012\u0004*!I1\u0011\n\u0018\u0002\u0002\u0013\u000551\n\u0005\n\u0007'r\u0013\u0011!CA\u0007+Bqaa\u001a\u0001\t\u0013\u0019I\u0007C\u0004\u0004\u0004\u0002!Ia!\"\t\u000f\r\u001d\u0006\u0001\"\u0003\u0004*\"91Q\u0017\u0001\u0005\n\r]\u0006bBBe\u0001\u0011%11\u001a\u0004\u0007\u0007G\u0004\u0001a!:\t\u0015\r\u001d\bH!A!\u0002\u0013\u0019I\u000f\u0003\u0006\u0004~a\u0012)\u0019!C\u0001\u0005sD!ba<9\u0005\u0003\u0005\u000b\u0011BA!\u0011\u0019y\u0007\b\"\u0001\u0004r\"I1\u0011 \u001dC\u0002\u0013\u000511 \u0005\t\t\u0007A\u0004\u0015!\u0003\u0004~\"IAQ\u0001\u001dC\u0002\u0013\u0005Aq\u0001\u0005\t\t\u001fA\u0004\u0015!\u0003\u0005\n!IA\u0011\u0003\u001dC\u0002\u0013\u0005Aq\u0001\u0005\t\t'A\u0004\u0015!\u0003\u0005\n\u0019!q\u000f\u0001\u0001y\u0011)\tya\u0011BC\u0002\u0013\u0005\u0011\u0011\u0003\u0005\u000b\u0003[\u0019%\u0011!Q\u0001\n\u0005M\u0001BCA\u0018\u0007\n\u0005\t\u0015!\u0003\u00022!Q\u0011QH\"\u0003\u0002\u0003\u0006I!a\u0010\t\r=\u001cE\u0011AA%\u0011%\t\tf\u0011b\u0001\n\u0003\t\u0019\u0006\u0003\u0005\u0002\\\r\u0003\u000b\u0011BA+\u0011%\tif\u0011b\u0001\n\u0003\ty\u0006\u0003\u0005\u0002l\r\u0003\u000b\u0011BA1\u0011%\tig\u0011b\u0001\n\u0003\ty\u0007\u0003\u0005\u0002\n\u000e\u0003\u000b\u0011BA9\u0011%\tYi\u0011a\u0001\n\u0003\ti\tC\u0005\u0002\u001c\u000e\u0003\r\u0011\"\u0001\u0002\u001e\"A\u0011\u0011V\"!B\u0013\ty\tC\u0005\u0002,\u000e\u0003\r\u0011\"\u0001\u0002\u0012!I\u0011QV\"A\u0002\u0013\u0005\u0011q\u0016\u0005\t\u0003g\u001b\u0005\u0015)\u0003\u0002\u0014!I\u0011QW\"A\u0002\u0013\u0005\u0011q\u0017\u0005\n\u0003#\u001c\u0005\u0019!C\u0001\u0003'D\u0001\"a6DA\u0003&\u0011\u0011\u0018\u0005\b\u00033\u001cE\u0011AAn\u0011\u001d\tin\u0011C\u0001\u00037Dq!a8D\t\u0003\tY\u000eC\u0004\u0002b\u000e#\t!a9\t\u000f\u0005E8\t\"\u0011\u0002\\\u001eIAQ\u0003\u0001\u0002\u0002#\u0005Aq\u0003\u0004\to\u0002\t\t\u0011#\u0001\u0005\u001a!1qN\u0018C\u0001\t7A\u0011\u0002\"\b_#\u0003%\t\u0001b\b\t\u0013\u0011\rb,%A\u0005\u0002\u0011\u0015\"!\t*fCN\u001c\u0018n\u001a8QCJ$\u0018\u000e^5p]NLe\u000e^3he\u0006$\u0018n\u001c8UKN$(B\u00013f\u0003\u0015\tG-\\5o\u0015\u00051\u0017!B6bM.\f7\u0001A\n\u0003\u0001%\u0004\"A[7\u000e\u0003-T!\u0001\\3\u0002\rM,'O^3s\u0013\tq7NA\tRk>\u0014X/\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A9\u0011\u0005I\u0004Q\"A2\u0002\u000f\rdWo\u001d;feV\tQ\u000f\u0005\u0002w\u00076\t\u0001AA\u000fSK\u0006\u001c8/[4o!\u0006\u0014H/\u001b;j_:\u001cH+Z:u\u00072,8\u000f^3s'\u0011\u0019\u00150a\u0001\u0011\u0005i|X\"A>\u000b\u0005ql\u0018\u0001\u00027b]\u001eT\u0011A`\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0002m\u0014aa\u00142kK\u000e$\b\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%Q0\u0001\u0002j_&!\u0011QBA\u0004\u0005%\u0019En\\:fC\ndW-A\u0005{W\u000e{gN\\3diV\u0011\u00111\u0003\t\u0005\u0003+\t9C\u0004\u0003\u0002\u0018\u0005\r\u0002\u0003BA\r\u0003?i!!a\u0007\u000b\u0007\u0005uq-\u0001\u0004=e>|GO\u0010\u0006\u0003\u0003C\tQa]2bY\u0006LA!!\n\u0002 \u00051\u0001K]3eK\u001aLA!!\u000b\u0002,\t11\u000b\u001e:j]\u001eTA!!\n\u0002 \u0005Q!p[\"p]:,7\r\u001e\u0011\u0002\u001f\r|gNZ5h\u001fZ,'O]5eKN\u0004\u0002\"a\r\u0002:\u0005M\u00111C\u0007\u0003\u0003kQA!a\u000e\u0002 \u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0012Q\u0007\u0002\u0004\u001b\u0006\u0004\u0018!\u00062s_.,'oQ8oM&<wJ^3se&$Wm\u001d\t\t\u0003g\tI$!\u0011\u00022A!\u00111IA#\u001b\t\ty\"\u0003\u0003\u0002H\u0005}!aA%oiR9Q/a\u0013\u0002N\u0005=\u0003bBA\b\u0011\u0002\u0007\u00111\u0003\u0005\n\u0003_A\u0005\u0013!a\u0001\u0003cA\u0011\"!\u0010I!\u0003\u0005\r!a\u0010\u0002\u000f\t\u0014xn[3sgV\u0011\u0011Q\u000b\t\t\u0003g\tI$!\u0011\u0002XA\u0019!0!\u0017\n\u0007\u0005%20\u0001\u0005ce>\\WM]:!\u0003\u0019!x\u000e]5dgV\u0011\u0011\u0011\r\t\t\u0003g\tI$a\u0016\u0002dA1\u00111GA3\u0003SJA!a\u001a\u00026\t\u00191+Z9\u0011\r\u0005M\u0012QMA!\u0003\u001d!x\u000e]5dg\u0002\nQB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u001cXCAA9!\u0019\t\u0019(!\u001f\u0002~5\u0011\u0011Q\u000f\u0006\u0005\u0003o\n)$A\u0004nkR\f'\r\\3\n\t\u0005m\u0014Q\u000f\u0002\u0007\u0005V4g-\u001a:\u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003S1!a!~\u0003\u0011)H/\u001b7\n\t\u0005\u001d\u0015\u0011\u0011\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018A\u00042s_.,'oQ8oM&<7\u000fI\u0001\bg\u0016\u0014h/\u001a:t+\t\ty\t\u0005\u0004\u0002t\u0005E\u0015QS\u0005\u0005\u0003'\u000b)HA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bc\u00016\u0002\u0018&\u0019\u0011\u0011T6\u0003\u0017-\u000bgm[1TKJ4XM]\u0001\fg\u0016\u0014h/\u001a:t?\u0012*\u0017\u000f\u0006\u0003\u0002 \u0006\u0015\u0006\u0003BA\"\u0003CKA!a)\u0002 \t!QK\\5u\u0011%\t9\u000bUA\u0001\u0002\u0004\ty)A\u0002yIE\n\u0001b]3sm\u0016\u00148\u000fI\u0001\u000bEJ|7.\u001a:MSN$\u0018A\u00042s_.,'\u000fT5ti~#S-\u001d\u000b\u0005\u0003?\u000b\t\fC\u0005\u0002(N\u000b\t\u00111\u0001\u0002\u0014\u0005Y!M]8lKJd\u0015n\u001d;!\u0003-\tG-\\5o\u00072LWM\u001c;\u0016\u0005\u0005e\u0006\u0003BA^\u0003\u001bl!!!0\u000b\u0007\u0011\fyL\u0003\u0003\u0002B\u0006\r\u0017aB2mS\u0016tGo\u001d\u0006\u0004M\u0006\u0015'\u0002BAd\u0003\u0013\fa!\u00199bG\",'BAAf\u0003\ry'oZ\u0005\u0005\u0003\u001f\fiLA\u0003BI6Lg.A\bbI6Lgn\u00117jK:$x\fJ3r)\u0011\ty*!6\t\u0013\u0005\u001df+!AA\u0002\u0005e\u0016\u0001D1e[&t7\t\\5f]R\u0004\u0013!B:fiV\u0004HCAAP\u00035\u0019'/Z1uKN+'O^3sg\u0006a1M]3bi\u0016$v\u000e]5dg\u0006y\u0001O]8ek\u000e,W*Z:tC\u001e,7\u000f\u0006\u0005\u0002 \u0006\u0015\u0018\u0011^Aw\u0011\u001d\t9o\u0017a\u0001\u0003'\tQ\u0001^8qS\u000eDq!a;\\\u0001\u0004\t\t%A\u0005qCJ$\u0018\u000e^5p]\"9\u0011q^.A\u0002\u0005\u0005\u0013a\u00038v[6+7o]1hKN\fQa\u00197pg\u0016\f1b\u00197vgR,'o\u0018\u0013fcR!\u0011qTA|\u0011!\t9kAA\u0001\u0002\u0004)\u0018\u0001C2mkN$XM\u001d\u0011\u0002\u0011Q,\u0017M\u001d#po:D3!BA\u0000!\u0011\u0011\tAa\u0004\u000e\u0005\t\r!\u0002\u0002B\u0003\u0005\u000f\t1!\u00199j\u0015\u0011\u0011IAa\u0003\u0002\u000f),\b/\u001b;fe*!!QBAe\u0003\u0015QWO\\5u\u0013\u0011\u0011\tBa\u0001\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001G;oi\"\u0014x\u000e\u001e;mK\u0012\u0014%o\\6fe\u000e{gNZ5hgV\u0011!q\u0003\t\t\u00053\u0011y\"!\u0011\u0003\"5\u0011!1\u0004\u0006\u0005\u0005;\t)$A\u0005j[6,H/\u00192mK&!\u00111\bB\u000e!!\u0011IBa\b\u0002X\t\r\u0002\u0003BA\"\u0005KIAAa\n\u0002 \t!Aj\u001c8h\u0003e)h\u000e\u001e5s_R$H.\u001a3Ce>\\WM]\"p]\u001aLwm\u001d\u0011\u0002!Q,7\u000f\u001e*fCN\u001c\u0018n\u001a8nK:$\bf\u0001\u0005\u00030A!!\u0011\u0001B\u0019\u0013\u0011\u0011\u0019Da\u0001\u0003\tQ+7\u000f^\u0001%i\u0016\u001cHOU3bgNLwM\\7f]R<\u0016\u000e\u001e5BYR,'/S:s\t&\u001c\u0018M\u00197fI\"\u001a\u0011Ba\f\u0002]Q,7\u000f\u001e*fCN\u001c\u0018n\u001a8nK:$8i\\7qY\u0016$\u0018n\u001c8EkJLgn\u001a)beRL\u0017\r\\+qOJ\fG-\u001a\u0015\u0004\u0015\t=\u0012\u0001H3yK\u000e,H/Z!oIZ+'/\u001b4z%\u0016\f7o]5h]6,g\u000e^\u0001,i\u0016\u001cH\u000fS5hQ^\u000bG/\u001a:NCJ\\\u0017I\u001a;feB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oi\"\u001aABa\f\u0002;Q,7\u000f^!mi\u0016\u0014(+Z1tg&<g.\\3oiRC'o\u001c;uY\u0016D3!\u0004B\u0018\u0003e!Xm\u001d;UQJ|G\u000f\u001e7fIJ+\u0017m]:jO:lWM\u001c;)\u00079\u0011y#A\u0018uKN$\bK]8ek\u000e,\u0017I\u001c3D_:\u001cX/\\3XSRD'+Z1tg&<g.\\3oi&s\u0007K]8he\u0016\u001c8\u000fK\u0002\u0010\u0005_\t\u0001\u0003^3ti\u000e\u000bgnY3mY\u0006$\u0018n\u001c8)\u0007A\u0011y#A\u000bxC&$hi\u001c:M_\u001e$\u0015N\u001d+ie>$H\u000f\\3\u0015\r\u0005}%q\u000bB1\u0011\u001d\u0011I&\u0005a\u0001\u00057\n\u0001\u0003\u001e5s_R$H.\u001a3Ce>\\WM]:\u0011\r\u0005U!QLA!\u0013\u0011\u0011y&a\u000b\u0003\u0007M+G\u000fC\u0004\u0003dE\u0001\rAa\t\u0002\u001d1|w\rR5s)\"\u0014x\u000e\u001e;mK\u0006Qr/Y5u\r>\u0014\u0018J\u001c;fe\n\u0013xn[3s)\"\u0014x\u000e\u001e;mKR1\u0011q\u0014B5\u0005WBqA!\u0017\u0013\u0001\u0004\u0011Y\u0006C\u0004\u0003nI\u0001\rAa\t\u0002'%tG/\u001a:Ce>\\WM\u001d+ie>$H\u000f\\3\u0002-]\f\u0017\u000e\u001e$pe\n\u0013xn[3s)\"\u0014x\u000e\u001e;mKN$b!a(\u0003t\tU\u0004b\u0002B-'\u0001\u0007!1\f\u0005\b\u0005o\u001a\u0002\u0019\u0001B=\u00039!\bN]8ui2,7i\u001c8gS\u001e\u0004\u0002\"a\r\u0002:\u0005M!1E\u0001\u001co\u0006LGOR8s\u0005J|7.\u001a:MKZ,G\u000e\u00165s_R$H.Z:\u0015\t\u0005}%q\u0010\u0005\b\u0005\u0003#\u0002\u0019\u0001BB\u0003=!\u0018M]4fiRC'o\u001c;uY\u0016\u001c\b\u0003CA\u001a\u0003s\t\tE!\u001f\u00029\u0011,7o\u0019:jE\u0016\u0014%o\\6fe2+g/\u001a7UQJ|G\u000f\u001e7fgR!!1\u0011BE\u0011\u001d\u0011Y)\u0006a\u0001\u0003S\n\u0011B\u0019:pW\u0016\u0014\u0018\nZ:\u0002-Q,7\u000f\u001e'pO\u0012K'OU3bgNLwM\\7f]RD3A\u0006B\u0018\u0003\r\"Xm\u001d;BYR,'\u000fT8h\t&\u0014(+Z1tg&<g.\\3oiRC'o\u001c;uY\u0016D3a\u0006B\u0018\u0005Iaun\u001a#jeJ+\u0017m]:jO:lWM\u001c;\u0014\u000fa\u0011IJa(\u0003&B!\u00111\tBN\u0013\u0011\u0011i*a\b\u0003\r\u0005s\u0017PU3g!\u0011\t\u0019E!)\n\t\t\r\u0016q\u0004\u0002\b!J|G-^2u!\u0011\u00119K!-\u000f\t\t%&Q\u0016\b\u0005\u00033\u0011Y+\u0003\u0002\u0002\"%!!qVA\u0010\u0003\u001d\u0001\u0018mY6bO\u0016LAAa-\u00036\na1+\u001a:jC2L'0\u00192mK*!!qVA\u0010\u0003\u0011Q7o\u001c8\u0002\u000b)\u001cxN\u001c\u0011\u0002\u0015\r,(O]3oi\u0012K'/A\u0006dkJ\u0014XM\u001c;ESJ\u0004\u0013!\u0003;be\u001e,G\u000fR5s\u0003)!\u0018M]4fi\u0012K'\u000f\t\u000b\t\u0005\u000b\u00149M!3\u0003LB\u0011a\u000f\u0007\u0005\b\u0005o{\u0002\u0019AA\n\u0011\u001d\u0011Yl\ba\u0001\u0003'AqAa0 \u0001\u0004\t\u0019\"\u0001\u0003d_BLH\u0003\u0003Bc\u0005#\u0014\u0019N!6\t\u0013\t]\u0006\u0005%AA\u0002\u0005M\u0001\"\u0003B^AA\u0005\t\u0019AA\n\u0011%\u0011y\f\tI\u0001\u0002\u0004\t\u0019\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tm'\u0006BA\n\u0005;\\#Aa8\u0011\t\t\u0005(1^\u0007\u0003\u0005GTAA!:\u0003h\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0005S\fy\"\u0001\u0006b]:|G/\u0019;j_:LAA!<\u0003d\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002X\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011I\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011yp!\u0002\u0011\t\u0005\r3\u0011A\u0005\u0005\u0007\u0007\tyBA\u0002B]fD\u0011\"a*'\u0003\u0003\u0005\r!!\u0011\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"aa\u0003\u0011\r\u0005M2Q\u0002B\u0000\u0013\u0011\u0019y!!\u000e\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0007+\u0019Y\u0002\u0005\u0003\u0002D\r]\u0011\u0002BB\r\u0003?\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002(\"\n\t\u00111\u0001\u0003\u0000\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t9f!\t\t\u0013\u0005\u001d\u0016&!AA\u0002\u0005\u0005\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u0005\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0004\u0016\r=\u0002\"CATY\u0005\u0005\t\u0019\u0001B\u0000\u0003Iaun\u001a#jeJ+\u0017m]:jO:lWM\u001c;\u0011\u0005Yt3#\u0002\u0018\u00048\r\r\u0003\u0003DB\u001d\u0007\u007f\t\u0019\"a\u0005\u0002\u0014\t\u0015WBAB\u001e\u0015\u0011\u0019i$a\b\u0002\u000fI,h\u000e^5nK&!1\u0011IB\u001e\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0003\u000b\u0019)%\u0003\u0003\u00034\u0006\u001dACAB\u001a\u0003\u0015\t\u0007\u000f\u001d7z)!\u0011)m!\u0014\u0004P\rE\u0003b\u0002B\\c\u0001\u0007\u00111\u0003\u0005\b\u0005w\u000b\u0004\u0019AA\n\u0011\u001d\u0011y,\ra\u0001\u0003'\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004X\r\r\u0004CBA\"\u00073\u001ai&\u0003\u0003\u0004\\\u0005}!AB(qi&|g\u000e\u0005\u0006\u0002D\r}\u00131CA\n\u0003'IAa!\u0019\u0002 \t1A+\u001e9mKNB\u0011b!\u001a3\u0003\u0003\u0005\rA!2\u0002\u0007a$\u0003'A\fck&dG\rT8h\t&\u0014(+Z1tg&<g.\\3oiRA!QYB6\u0007w\u001ay\bC\u0004\u0004nM\u0002\raa\u001c\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!1\u0011OB<\u001b\t\u0019\u0019H\u0003\u0003\u0004v\u0005\r\u0017AB2p[6|g.\u0003\u0003\u0004z\rM$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0007{\u001a\u0004\u0019AA!\u0003!\u0011'o\\6fe&#\u0007bBBAg\u0001\u0007\u0011\u0011N\u0001\te\u0016\u0004H.[2bg\u0006\u0019\"/\u001e8WKJLg-_!tg&<g.\\3oiRA1qQBO\u0007?\u001b\u0019\u000b\u0005\u0003\u0004\n\u000e]e\u0002BBF\u0007'sAa!$\u0004\u0012:!\u0011\u0011DBH\u0013\u00051\u0017B\u00013f\u0013\r\u0019)jY\u0001\u001a%\u0016\f7o]5h]B\u000b'\u000f^5uS>t7oQ8n[\u0006tG-\u0003\u0003\u0004\u001a\u000em%A\u0006,fe&4\u00170Q:tS\u001etW.\u001a8u%\u0016\u001cX\u000f\u001c;\u000b\u0007\rU5\rC\u0004\u00026R\u0002\r!!/\t\u000f\r\u0005F\u00071\u0001\u0002\u0014\u0005Q!n]8o'R\u0014\u0018N\\4\t\u000f\r\u0015F\u00071\u0001\u0004\u0016\u0005\t\u0002O]3tKJ4X\r\u00165s_R$H.Z:\u0002/]\f\u0017\u000e\u001e$peZ+'/\u001b4z\u0003N\u001c\u0018n\u001a8nK:$HCCAP\u0007W\u001bika,\u00042\"9\u0011QW\u001bA\u0002\u0005e\u0006bBBQk\u0001\u0007\u00111\u0003\u0005\b\u0007K+\u0004\u0019AB\u000b\u0011\u001d\u0019\u0019,\u000ea\u0001\u0007\u000f\u000ba\"\u001a=qK\u000e$X\r\u001a*fgVdG/\u0001\u000bsk:,\u00050Z2vi\u0016\f5o]5h]6,g\u000e\u001e\u000b\r\u0003?\u001bIla/\u0004@\u000e\r7Q\u0019\u0005\b\u0003k3\u0004\u0019AA]\u0011\u001d\u0019iL\u000ea\u0001\u0007+\t!\"\u00193eSRLwN\\1m\u0011\u001d\u0019\tM\u000ea\u0001\u0003'\t\u0001C]3bgNLwM\\7f]RT5o\u001c8\t\u000f\t5d\u00071\u0001\u0003$!91q\u0019\u001cA\u0002\t\r\u0012a\u0007:fa2L7-Y!mi\u0016\u0014Hj\\4ESJ\u001cH\u000b\u001b:piRdW-A\nsk:\u001c\u0015M\\2fY\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0005\u0004N\u000eu7q\\Bq!!\t\u0019ea4\u0004T\u000eU\u0017\u0002BBi\u0003?\u0011a\u0001V;qY\u0016\u0014\u0004CBA\u000b\u0005;\u001ay\u0007\u0005\u0004\u0002\u0016\tu3q\u001b\t\u0005\u0007c\u001aI.\u0003\u0003\u0004\\\u000eM$!\u0006+pa&\u001c\u0007+\u0019:uSRLwN\u001c*fa2L7-\u0019\u0005\b\u0003k;\u0004\u0019AA]\u0011\u001d\u0019\tk\u000ea\u0001\u0003'Aqa!*8\u0001\u0004\u0019)B\u0001\u0006Ce>\\WM\u001d#jeN\u001c2\u0001\u000fBM\u0003\u0019\u0011Xm];miB!\u00111XBv\u0013\u0011\u0019i/!0\u0003+\u0011+7o\u0019:jE\u0016dun\u001a#jeN\u0014Vm];mi\u0006I!M]8lKJLE\r\t\u000b\u0007\u0007g\u001c)pa>\u0011\u0005YD\u0004bBBty\u0001\u00071\u0011\u001e\u0005\b\u0007{b\u0004\u0019AA!\u0003\u001dawn\u001a#jeN,\"a!@\u0011\r\u0005M4q`A\n\u0013\u0011!\t!!\u001e\u0003\u000f!\u000b7\u000f[*fi\u0006AAn\\4ESJ\u001c\b%\u0001\u0006dkJdun\u001a#jeN,\"\u0001\"\u0003\u0011\u0011\u0005MD1BB8\u0003'IA\u0001\"\u0004\u0002v\t9\u0001*Y:i\u001b\u0006\u0004\u0018aC2ve2{w\rR5sg\u0002\nQBZ;ukJ,Gj\\4ESJ\u001c\u0018A\u00044viV\u0014X\rT8h\t&\u00148\u000fI\u0001\u001e%\u0016\f7o]5h]B\u000b'\u000f^5uS>t7\u000fV3ti\u000ecWo\u001d;feB\u0011aOX\n\u0004=\neEC\u0001C\f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011A\u0011\u0005\u0016\u0005\u0003c\u0011i.A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\tOQC!a\u0010\u0003^\":\u0001\u0001b\u000b\u00052\u0011M\u0002\u0003\u0002B\u0001\t[IA\u0001b\f\u0003\u0004\t9A+[7f_V$\u0018!\u0002<bYV,gDA\u0001-\u0001")
public class ReassignPartitionsIntegrationTest
extends QuorumTestHarness {
    private volatile ReassignPartitionsIntegrationTest$LogDirReassignment$ LogDirReassignment$module;
    private volatile ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$ ReassignPartitionsTestCluster$module;
    private ReassignPartitionsTestCluster cluster = null;
    private final scala.collection.immutable.Map<Object, scala.collection.immutable.Map<String, Object>> unthrottledBrokerConfigs = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)brokerId -> ReassignPartitionsIntegrationTest.$anonfun$unthrottledBrokerConfigs$1(BoxesRunTime.unboxToInt((Object)brokerId))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());

    public ReassignPartitionsIntegrationTest$LogDirReassignment$ LogDirReassignment() {
        if (this.LogDirReassignment$module == null) {
            this.LogDirReassignment$lzycompute$1();
        }
        return this.LogDirReassignment$module;
    }

    public ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$ ReassignPartitionsTestCluster() {
        if (this.ReassignPartitionsTestCluster$module == null) {
            this.ReassignPartitionsTestCluster$lzycompute$1();
        }
        return this.ReassignPartitionsTestCluster$module;
    }

    public ReassignPartitionsTestCluster cluster() {
        return this.cluster;
    }

    public void cluster_$eq(ReassignPartitionsTestCluster x$1) {
        this.cluster = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        Utils.closeQuietly((AutoCloseable)this.cluster(), (String)"ReassignPartitionsTestCluster");
        super.tearDown();
    }

    public scala.collection.immutable.Map<Object, scala.collection.immutable.Map<String, Object>> unthrottledBrokerConfigs() {
        return this.unthrottledBrokerConfigs;
    }

    @Test
    public void testReassignment() {
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)((Map)Map$.MODULE$.empty()), (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        this.executeAndVerifyReassignment();
    }

    @Test
    public void testReassignmentWithAlterIsrDisabled() {
        Map configOverrides = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp()), (Object)KAFKA_2_7_IV1$.MODULE$.version())}));
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)configOverrides, (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        this.executeAndVerifyReassignment();
    }

    @Test
    public void testReassignmentCompletionDuringPartialUpgrade() {
        Map map;
        ZkIsrManager$.MODULE$.DefaultIsrPropagationConfig_$eq(new IsrChangePropagationConfig(500L, 500L, 100L));
        Map oldIbpConfig = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp()), (Object)KAFKA_2_7_IV1$.MODULE$.version())}));
        Map brokerConfigOverrides = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)oldIbpConfig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)oldIbpConfig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)oldIbpConfig)}));
        String x$4 = this.zkConnect();
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        Map map2 = map = (Map)Map$.MODULE$.empty();
        map = null;
        Map x$6 = map2;
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, x$4, (Map<String, String>)x$6, (Map<Object, Map<String, String>>)brokerConfigOverrides));
        this.cluster().setup();
        this.executeAndVerifyReassignment();
    }

    public void executeAndVerifyReassignment() {
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1,3],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"bar\",\"partition\":0,\"replicas\":[3,2,0],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        Map initialAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0})), true))}));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(initialAssignment, false, (Map)Map$.MODULE$.empty(), false));
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, -1L, -1L);
        Assertions.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
        Map finalAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0})), true))}));
        Assertions.assertFalse((boolean)this.runVerifyAssignment(this.cluster().adminClient(), assignment, false).movesOngoing());
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        Assertions.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
    }

    @Test
    public void testHighWaterMarkAfterPartitionReassignment() {
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)((Map)Map$.MODULE$.empty()), (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[3,1,2],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        TopicPartition part = new TopicPartition("foo", 0);
        ((KafkaServer)this.cluster().servers().apply(0)).replicaManager().logManager().truncateFullyAndStartAt(part, 123L, false);
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, -1L, -1L);
        Map finalAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)part), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), true))}));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        long l = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReassignPartitionsIntegrationTest.$anonfun$testHighWaterMarkAfterPartitionReassignment$1(this, part)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"broker 3 should be the new leader");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)123L, (long)((KafkaServer)this.cluster().servers().apply(3)).replicaManager().localLogOrException(part).highWatermark(), (String)"Expected broker 3 to have the correct high water mark for the partition.");
    }

    @Test
    public void testAlterReassignmentThrottle() {
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)((Map)Map$.MODULE$.empty()), (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        this.cluster().produceMessages("foo", 0, 50);
        this.cluster().produceMessages("baz", 2, 60);
        String assignment = "{\"version\":1,\"partitions\":\n      [{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,3,2],\"log_dirs\":[\"any\",\"any\",\"any\"]},\n      {\"topic\":\"baz\",\"partition\":2,\"replicas\":[3,2,1],\"log_dirs\":[\"any\",\"any\",\"any\"]}\n      ]}";
        long initialThrottle = 1L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, initialThrottle, -1L);
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), initialThrottle);
        long updatedThrottle = 300000L;
        this.runExecuteAssignment(this.cluster().adminClient(), true, assignment, updatedThrottle, -1L);
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), updatedThrottle);
        Map finalAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 2)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true))}));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
    }

    @Test
    public void testThrottledReassignment() {
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)((Map)Map$.MODULE$.empty()), (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        this.cluster().produceMessages("foo", 0, 50);
        this.cluster().produceMessages("baz", 2, 60);
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,3,2],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"baz\",\"partition\":2,\"replicas\":[3,2,1],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        Map initialAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 2)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true))}));
        Assertions.assertEquals((Object)new ReassignPartitionsCommand.VerifyAssignmentResult(initialAssignment, false, (Map)Map$.MODULE$.empty(), false), (Object)this.runVerifyAssignment(this.cluster().adminClient(), assignment, false));
        Assertions.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
        long interBrokerThrottle = 300000L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, interBrokerThrottle, -1L);
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle);
        Map finalAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 2)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true))}));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReassignPartitionsIntegrationTest.$anonfun$testThrottledReassignment$1(this, assignment, interBrokerThrottle)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Expected reassignment to complete.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, true, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle);
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
    }

    @Test
    public void testProduceAndConsumeWithReassignmentInProgress() {
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)((Map)Map$.MODULE$.empty()), (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        this.cluster().produceMessages("baz", 2, 60);
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"baz\",\"partition\":2,\"replicas\":[3,2,1],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, 300L, -1L);
        this.cluster().produceMessages("baz", 2, 100);
        TopicPartition part = new TopicPartition("baz", 2);
        try (KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(this.cluster().brokerList(), "group", "earliest", true, false, 500, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArrayDeserializer(), new ByteArrayDeserializer());){
            consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)part, (List)Nil$.MODULE$)).asJava());
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 100, 15000L);
        }
        TestUtils$.MODULE$.removeReplicationThrottleForPartitions(this.cluster().adminClient(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{part}))));
        Map finalAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)part), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true))}));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
    }

    @Test
    public void testCancellation() {
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)((Map)Map$.MODULE$.empty()), (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        this.cluster().produceMessages("foo", 0, 200);
        this.cluster().produceMessages("baz", 1, 200);
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1,3],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"baz\",\"partition\":1,\"replicas\":[0,2,3],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        Assertions.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
        long interBrokerThrottle = 1L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, interBrokerThrottle, -1L);
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle);
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 1)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3})), false))})), true, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), false));
        Assertions.assertEquals((Object)new Tuple2(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("baz", 1)})), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), this.runCancelAssignment(this.cluster().adminClient(), assignment, true));
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle);
        Assertions.assertEquals((Object)new Tuple2(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), this.runCancelAssignment(this.cluster().adminClient(), assignment, false));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
        Assertions.assertFalse((boolean)this.runVerifyAssignment(this.cluster().adminClient(), assignment, false).partsOngoing());
    }

    private void waitForLogDirThrottle(Set<Object> throttledBrokers, long logDirThrottle) {
        Map throttledConfigMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLeaderThrottle()), (Object)BoxesRunTime.boxToLong((long)-1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelFollowerThrottle()), (Object)BoxesRunTime.boxToLong((long)-1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle()), (Object)BoxesRunTime.boxToLong((long)logDirThrottle))}));
        this.waitForBrokerThrottles(throttledBrokers, (Map<String, Object>)throttledConfigMap);
    }

    private void waitForInterBrokerThrottle(Set<Object> throttledBrokers, long interBrokerThrottle) {
        Map throttledConfigMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLeaderThrottle()), (Object)BoxesRunTime.boxToLong((long)interBrokerThrottle)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelFollowerThrottle()), (Object)BoxesRunTime.boxToLong((long)interBrokerThrottle)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle()), (Object)BoxesRunTime.boxToLong((long)-1L))}));
        this.waitForBrokerThrottles(throttledBrokers, (Map<String, Object>)throttledConfigMap);
    }

    private void waitForBrokerThrottles(Set<Object> throttledBrokers, Map<String, Object> throttleConfig) {
        scala.collection.immutable.Map throttledBrokerConfigs = (scala.collection.immutable.Map)this.unthrottledBrokerConfigs().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int brokerId = x0$1._1$mcI$sp();
            scala.collection.immutable.Map unthrottledConfig = (scala.collection.immutable.Map)x0$1._2();
            Map expectedThrottleConfig = throttledBrokers.contains((Object)BoxesRunTime.boxToInteger((int)brokerId)) ? throttleConfig : unthrottledConfig;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Object)expectedThrottleConfig);
            return tuple2;
        });
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)throttledBrokerConfigs);
    }

    private void waitForBrokerLevelThrottles(Map<Object, Map<String, Object>> targetThrottles) {
        Map<Object, Map<String, Object>> map;
        Map cfr_ignored_0 = (Map)Map$.MODULE$.empty();
        long l = 15000L;
        long waitUntilTrue_pause = 25L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!targetThrottles.equals(map = this.describeBrokerLevelThrottles((Seq<Object>)targetThrottles.keySet().toSeq()))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)new StringBuilder(0).append(new StringBuilder(51).append("timed out waiting for broker throttle to become ").append(targetThrottles).append(".  ").toString()).append(new StringBuilder(22).append("Latest throttles were ").append(map).toString()).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), waitUntilTrue_pause));
        }
    }

    private Map<Object, Map<String, Object>> describeBrokerLevelThrottles(Seq<Object> brokerIds) {
        return ((IterableOnceOps)brokerIds.map((Function1 & Serializable)brokerId -> ReassignPartitionsIntegrationTest.$anonfun$describeBrokerLevelThrottles$1(this, BoxesRunTime.unboxToInt((Object)brokerId)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Test
    public void testLogDirReassignment() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)((Map)Map$.MODULE$.empty()), (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        this.cluster().produceMessages(topicPartition.topic(), topicPartition.partition(), 700);
        int targetBrokerId = 0;
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        LogDirReassignment reassignment = this.buildLogDirReassignment(topicPartition, targetBrokerId, (Seq<Object>)replicas);
        long logDirThrottle = 1L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, reassignment.json(), -1L, logDirThrottle);
        this.waitForVerifyAssignment(this.cluster().adminClient(), reassignment.json(), true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), true))})), false, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topicPartition.topic(), topicPartition.partition(), 0)), (Object)new ReassignPartitionsCommand.ActiveMoveState(reassignment.currentDir(), reassignment.targetDir(), reassignment.targetDir()))})), true));
        this.waitForLogDirThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), logDirThrottle);
        this.cluster().adminClient().incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, "0"), Collections.singletonList(new AlterConfigOp(new ConfigEntry(ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle(), ""), AlterConfigOp.OpType.DELETE)))).all().get();
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
        this.waitForVerifyAssignment(this.cluster().adminClient(), reassignment.json(), true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), true))})), false, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topicPartition.topic(), topicPartition.partition(), 0)), (Object)new ReassignPartitionsCommand.CompletedMoveState(reassignment.targetDir()))})), false));
        BrokerDirs info1 = new BrokerDirs(this, this.cluster().adminClient().describeLogDirs(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)x$3 -> ReassignPartitionsIntegrationTest.$anonfun$testLogDirReassignment$1(BoxesRunTime.unboxToInt((Object)x$3)))).asJavaCollection()), 0);
        Assertions.assertEquals((Object)reassignment.targetDir(), (Object)info1.curLogDirs().getOrElse((Object)topicPartition, (Function0 & Serializable)() -> ""));
    }

    @Test
    public void testAlterLogDirReassignmentThrottle() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)((Map)Map$.MODULE$.empty()), (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        this.cluster().produceMessages(topicPartition.topic(), topicPartition.partition(), 700);
        int targetBrokerId = 0;
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        LogDirReassignment reassignment = this.buildLogDirReassignment(topicPartition, targetBrokerId, (Seq<Object>)replicas);
        long initialLogDirThrottle = 1L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, reassignment.json(), -1L, initialLogDirThrottle);
        this.waitForLogDirThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), initialLogDirThrottle);
        long updatedLogDirThrottle = 3000000L;
        this.runExecuteAssignment(this.cluster().adminClient(), true, reassignment.json(), -1L, updatedLogDirThrottle);
        this.waitForLogDirThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), updatedLogDirThrottle);
        this.waitForVerifyAssignment(this.cluster().adminClient(), reassignment.json(), true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), true))})), false, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topicPartition.topic(), topicPartition.partition(), targetBrokerId)), (Object)new ReassignPartitionsCommand.CompletedMoveState(reassignment.targetDir()))})), false));
    }

    private LogDirReassignment buildLogDirReassignment(TopicPartition topicPartition, int brokerId, Seq<Object> replicas) {
        DescribeLogDirsResult describeLogDirsResult = this.cluster().adminClient().describeLogDirs(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)x$4 -> ReassignPartitionsIntegrationTest.$anonfun$buildLogDirReassignment$1(BoxesRunTime.unboxToInt((Object)x$4)))).asJavaCollection());
        BrokerDirs logDirInfo = new BrokerDirs(this, describeLogDirsResult, brokerId);
        Assertions.assertTrue((boolean)logDirInfo.futureLogDirs().isEmpty());
        String currentDir = (String)logDirInfo.curLogDirs().apply((Object)topicPartition);
        String newDir = (String)logDirInfo.logDirs().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsIntegrationTest.$anonfun$buildLogDirReassignment$2(currentDir, x$5))).get();
        Seq logDirs = (Seq)replicas.map((Function1 & Serializable)replicaId -> ReassignPartitionsIntegrationTest.$anonfun$buildLogDirReassignment$3(brokerId, newDir, BoxesRunTime.unboxToInt((Object)replicaId)));
        String reassignmentJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(246).append("\n         | { \"version\": 1,\n         |  \"partitions\": [\n         |    {\n         |     \"topic\": \"").append(topicPartition.topic()).append("\",\n         |     \"partition\": ").append(topicPartition.partition()).append(",\n         |     \"replicas\": [").append(replicas.mkString(",")).append("],\n         |     \"log_dirs\": [").append(logDirs.mkString(",")).append("]\n         |    }\n         |   ]\n         |  }\n         |").toString()));
        return new LogDirReassignment(this, reassignmentJson, currentDir, newDir);
    }

    private ReassignPartitionsCommand.VerifyAssignmentResult runVerifyAssignment(Admin adminClient, String jsonString, boolean preserveThrottles) {
        Predef$.MODULE$.println((Object)new StringBuilder(46).append("==> verifyAssignment(adminClient, jsonString=").append(jsonString).append(")").toString());
        return ReassignPartitionsCommand$.MODULE$.verifyAssignment(adminClient, jsonString, preserveThrottles);
    }

    private void waitForVerifyAssignment(Admin adminClient, String jsonString, boolean preserveThrottles, ReassignPartitionsCommand.VerifyAssignmentResult expectedResult) {
        ReassignPartitionsCommand.VerifyAssignmentResult verifyAssignmentResult;
        long l = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!expectedResult.equals((Object)(verifyAssignmentResult = this.runVerifyAssignment(adminClient, jsonString, preserveThrottles)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)new StringBuilder(0).append(new StringBuilder(49).append("Timed out waiting for verifyAssignment result ").append(expectedResult).append(".  ").toString()).append(new StringBuilder(22).append("The latest result was ").append(verifyAssignmentResult).toString()).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), waitUntilTrue_pause));
        }
    }

    private void runExecuteAssignment(Admin adminClient, boolean additional, String reassignmentJson, long interBrokerThrottle, long replicaAlterLogDirsThrottle) {
        Predef$.MODULE$.println((Object)new StringBuilder(0).append(new StringBuilder(48).append("==> executeAssignment(adminClient, additional=").append(additional).append(", ").toString()).append(new StringBuilder(19).append("reassignmentJson=").append(reassignmentJson).append(", ").toString()).append(new StringBuilder(22).append("interBrokerThrottle=").append(interBrokerThrottle).append(", ").toString()).append(new StringBuilder(30).append("replicaAlterLogDirsThrottle=").append(replicaAlterLogDirsThrottle).append("))").toString()).toString());
        ReassignPartitionsCommand$.MODULE$.executeAssignment(adminClient, additional, reassignmentJson, interBrokerThrottle, replicaAlterLogDirsThrottle, 10000L, Time.SYSTEM);
    }

    private Tuple2<Set<TopicPartition>, Set<TopicPartitionReplica>> runCancelAssignment(Admin adminClient, String jsonString, boolean preserveThrottles) {
        Predef$.MODULE$.println((Object)new StringBuilder(46).append("==> cancelAssignment(adminClient, jsonString=").append(jsonString).append(")").toString());
        return ReassignPartitionsCommand$.MODULE$.cancelAssignment(adminClient, jsonString, preserveThrottles, 10000L, Time.SYSTEM);
    }

    private final void LogDirReassignment$lzycompute$1() {
        synchronized (this) {
            if (this.LogDirReassignment$module == null) {
                this.LogDirReassignment$module = new ReassignPartitionsIntegrationTest$LogDirReassignment$(this);
            }
            return;
        }
    }

    private final void ReassignPartitionsTestCluster$lzycompute$1() {
        synchronized (this) {
            if (this.ReassignPartitionsTestCluster$module == null) {
                this.ReassignPartitionsTestCluster$module = new ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testHighWaterMarkAfterPartitionReassignment$1(ReassignPartitionsIntegrationTest $this, TopicPartition part$1) {
        return ((KafkaServer)$this.cluster().servers().apply(3)).replicaManager().onlinePartition(part$1).flatMap((Function1 & Serializable)x$1 -> x$1.leaderLogIfLocal()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testHighWaterMarkAfterPartitionReassignment$3() {
        return "broker 3 should be the new leader";
    }

    public static final /* synthetic */ boolean $anonfun$testThrottledReassignment$2(Tuple2 x$2) {
        return ((ReassignPartitionsCommand.PartitionReassignmentState)x$2._2()).done();
    }

    public static final /* synthetic */ boolean $anonfun$testThrottledReassignment$1(ReassignPartitionsIntegrationTest $this, String assignment$1, long interBrokerThrottle$1) {
        ReassignPartitionsCommand.VerifyAssignmentResult result = $this.runVerifyAssignment($this.cluster().adminClient(), assignment$1, true);
        if (!result.partsOngoing()) {
            return true;
        }
        Assertions.assertFalse((boolean)result.partStates().forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsIntegrationTest.$anonfun$testThrottledReassignment$2(x$2))), (String)new StringBuilder(73).append("Expected at least one partition reassignment to be ongoing when result = ").append(result).toString());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), (Object)((ReassignPartitionsCommand.PartitionReassignmentState)result.partStates().apply((Object)new TopicPartition("foo", 0))).targetReplicas());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Object)((ReassignPartitionsCommand.PartitionReassignmentState)result.partStates().apply((Object)new TopicPartition("baz", 2))).targetReplicas());
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Current result: {}", (Object)result);
        }
        $this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle$1);
        return false;
    }

    public static final /* synthetic */ String $anonfun$testThrottledReassignment$3() {
        return "Expected reassignment to complete.";
    }

    public static final /* synthetic */ boolean $anonfun$waitForBrokerLevelThrottles$1(ReassignPartitionsIntegrationTest $this, ObjectRef curThrottles$1, Map targetThrottles$1) {
        curThrottles$1.elem = $this.describeBrokerLevelThrottles((Seq<Object>)targetThrottles$1.keySet().toSeq());
        return targetThrottles$1.equals((Object)((Map)curThrottles$1.elem));
    }

    public static final /* synthetic */ String $anonfun$waitForBrokerLevelThrottles$2(Map targetThrottles$1, ObjectRef curThrottles$1) {
        return new StringBuilder(0).append(new StringBuilder(51).append("timed out waiting for broker throttle to become ").append(targetThrottles$1).append(".  ").toString()).append(new StringBuilder(22).append("Latest throttles were ").append((Map)curThrottles$1.elem).toString()).toString();
    }

    public static final /* synthetic */ Tuple2 $anonfun$describeBrokerLevelThrottles$1(ReassignPartitionsIntegrationTest $this, int brokerId) {
        Properties props = $this.zkClient().getEntityConfigs("brokers", Integer.toString(brokerId));
        scala.collection.immutable.Map throttles = ((IterableOnceOps)ReassignPartitionsCommand$.MODULE$.brokerLevelThrottles().map((Function1 & Serializable)throttleName -> new Tuple2(throttleName, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)props.getOrDefault(throttleName, "-1"))))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Object)throttles);
    }

    public static final /* synthetic */ Integer $anonfun$testLogDirReassignment$1(int x$3) {
        return BoxesRunTime.boxToInteger((int)x$3);
    }

    public static final /* synthetic */ Integer $anonfun$buildLogDirReassignment$1(int x$4) {
        return BoxesRunTime.boxToInteger((int)x$4);
    }

    public static final /* synthetic */ boolean $anonfun$buildLogDirReassignment$2(String currentDir$1, String x$5) {
        return !x$5.equals(currentDir$1);
    }

    public static final /* synthetic */ String $anonfun$buildLogDirReassignment$3(int brokerId$1, String newDir$1, int replicaId) {
        if (replicaId == brokerId$1) {
            return new StringBuilder(2).append("\"").append(newDir$1).append("\"").toString();
        }
        return "\"any\"";
    }

    public static final /* synthetic */ boolean $anonfun$waitForVerifyAssignment$1(ReassignPartitionsIntegrationTest $this, ObjectRef latestResult$1, Admin adminClient$1, String jsonString$1, boolean preserveThrottles$1, ReassignPartitionsCommand.VerifyAssignmentResult expectedResult$1) {
        latestResult$1.elem = $this.runVerifyAssignment(adminClient$1, jsonString$1, preserveThrottles$1);
        return expectedResult$1.equals((Object)((ReassignPartitionsCommand.VerifyAssignmentResult)latestResult$1.elem));
    }

    public static final /* synthetic */ String $anonfun$waitForVerifyAssignment$2(ReassignPartitionsCommand.VerifyAssignmentResult expectedResult$1, ObjectRef latestResult$1) {
        return new StringBuilder(0).append(new StringBuilder(49).append("Timed out waiting for verifyAssignment result ").append(expectedResult$1).append(".  ").toString()).append(new StringBuilder(22).append("The latest result was ").append((ReassignPartitionsCommand.VerifyAssignmentResult)latestResult$1.elem).toString()).toString();
    }

    public class BrokerDirs {
        private final int brokerId;
        private final HashSet<String> logDirs;
        private final scala.collection.mutable.HashMap<TopicPartition, String> curLogDirs;
        private final scala.collection.mutable.HashMap<TopicPartition, String> futureLogDirs;
        public final /* synthetic */ ReassignPartitionsIntegrationTest $outer;

        public int brokerId() {
            return this.brokerId;
        }

        public HashSet<String> logDirs() {
            return this.logDirs;
        }

        public scala.collection.mutable.HashMap<TopicPartition, String> curLogDirs() {
            return this.curLogDirs;
        }

        public scala.collection.mutable.HashMap<TopicPartition, String> futureLogDirs() {
            return this.futureLogDirs;
        }

        public /* synthetic */ ReassignPartitionsIntegrationTest kafka$admin$ReassignPartitionsIntegrationTest$BrokerDirs$$$outer() {
            return this.$outer;
        }

        public BrokerDirs(ReassignPartitionsIntegrationTest $outer, DescribeLogDirsResult result, int brokerId) {
            this.brokerId = brokerId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.logDirs = new HashSet();
            this.curLogDirs = new scala.collection.mutable.HashMap();
            this.futureLogDirs = new scala.collection.mutable.HashMap();
            ((java.util.Map)((KafkaFuture)result.descriptions().get(BoxesRunTime.boxToInteger((int)brokerId))).get()).forEach((x0$1, x1$1) -> {
                this.logDirs().add(x0$1);
                x1$1.replicaInfos().forEach((x0$2, x1$2) -> {
                    if (x1$2.isFuture()) {
                        this.futureLogDirs().put(x0$2, x0$1);
                        return;
                    }
                    this.curLogDirs().put(x0$2, x0$1);
                });
            });
        }
    }

    public class LogDirReassignment
    implements Product,
    Serializable {
        private final String json;
        private final String currentDir;
        private final String targetDir;
        public final /* synthetic */ ReassignPartitionsIntegrationTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String json() {
            return this.json;
        }

        public String currentDir() {
            return this.currentDir;
        }

        public String targetDir() {
            return this.targetDir;
        }

        public LogDirReassignment copy(String json, String currentDir, String targetDir) {
            return new LogDirReassignment(this.kafka$admin$ReassignPartitionsIntegrationTest$LogDirReassignment$$$outer(), json, currentDir, targetDir);
        }

        public String copy$default$1() {
            return this.json();
        }

        public String copy$default$2() {
            return this.currentDir();
        }

        public String copy$default$3() {
            return this.targetDir();
        }

        public String productPrefix() {
            return "LogDirReassignment";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.json();
                }
                case 1: {
                    return this.currentDir();
                }
                case 2: {
                    return this.targetDir();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LogDirReassignment;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "json";
                }
                case 1: {
                    return "currentDir";
                }
                case 2: {
                    return "targetDir";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof LogDirReassignment)) return false;
            if (((LogDirReassignment)x$1).kafka$admin$ReassignPartitionsIntegrationTest$LogDirReassignment$$$outer() != this.kafka$admin$ReassignPartitionsIntegrationTest$LogDirReassignment$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            LogDirReassignment logDirReassignment = (LogDirReassignment)x$1;
            String string = this.json();
            String string2 = logDirReassignment.json();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.currentDir();
            String string4 = logDirReassignment.currentDir();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.targetDir();
            String string6 = logDirReassignment.targetDir();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (!logDirReassignment.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ReassignPartitionsIntegrationTest kafka$admin$ReassignPartitionsIntegrationTest$LogDirReassignment$$$outer() {
            return this.$outer;
        }

        public LogDirReassignment(ReassignPartitionsIntegrationTest $outer, String json, String currentDir, String targetDir) {
            this.json = json;
            this.currentDir = currentDir;
            this.targetDir = targetDir;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class ReassignPartitionsTestCluster
    implements Closeable {
        private final String zkConnect;
        private final Map<String, String> configOverrides;
        private final Map<Object, Map<String, String>> brokerConfigOverrides;
        private final Map<Object, String> brokers;
        private final Map<String, Seq<Seq<Object>>> topics;
        private final Buffer<Properties> brokerConfigs;
        private ArrayBuffer<KafkaServer> servers;
        private String brokerList;
        private Admin adminClient;
        public final /* synthetic */ ReassignPartitionsIntegrationTest $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public Map<Object, String> brokers() {
            return this.brokers;
        }

        public Map<String, Seq<Seq<Object>>> topics() {
            return this.topics;
        }

        public Buffer<Properties> brokerConfigs() {
            return this.brokerConfigs;
        }

        public ArrayBuffer<KafkaServer> servers() {
            return this.servers;
        }

        public void servers_$eq(ArrayBuffer<KafkaServer> x$1) {
            this.servers = x$1;
        }

        public String brokerList() {
            return this.brokerList;
        }

        public void brokerList_$eq(String x$1) {
            this.brokerList = x$1;
        }

        public Admin adminClient() {
            return this.adminClient;
        }

        public void adminClient_$eq(Admin x$1) {
            this.adminClient = x$1;
        }

        public void setup() {
            this.createServers();
            this.createTopics();
        }

        public void createServers() {
            this.brokers().keySet().foreach((Function1 & Serializable)brokerId -> ReassignPartitionsTestCluster.$anonfun$createServers$1(this, BoxesRunTime.unboxToInt((Object)brokerId)));
        }

        public void createTopics() {
            TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), 15000L);
            this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers(this.servers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT)));
            this.adminClient_$eq(Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.brokerList())}))).asJava()));
            this.adminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)this.topics().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String topicName = (String)x0$1._1();
                Seq parts = (Seq)x0$1._2();
                HashMap partMap = new HashMap();
                ((IterableOnceOps)parts.zipWithIndex()).foreach((Function1 & Serializable)x0$2 -> {
                    if (x0$2 == null) {
                        throw new MatchError(null);
                    }
                    Seq part = (Seq)x0$2._1();
                    int index = x0$2._2$mcI$sp();
                    java.util.List list = partMap.put(Predef$.MODULE$.int2Integer(index), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)part.map((Function1 & Serializable)x$6 -> BoxesRunTime.unboxToInt((Object)x$6))).asJava());
                    return list;
                });
                NewTopic newTopic = new NewTopic(topicName, partMap);
                return newTopic;
            })).toList()).asJava()).all().get();
            this.topics().foreach((Function1 & Serializable)x0$3 -> {
                if (x0$3 == null) {
                    throw new MatchError(null);
                }
                String topicName = (String)x0$3._1();
                Seq parts = (Seq)x0$3._2();
                Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> map = TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), topicName, parts.size());
                return map;
            });
        }

        public void produceMessages(String topic, int partition, int numMessages) {
            IndexedSeq records = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable)x$7 -> ReassignPartitionsTestCluster.$anonfun$produceMessages$1(topic, partition, BoxesRunTime.unboxToInt((Object)x$7)));
            TestUtils$.MODULE$.produceMessages(this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)records, -1);
        }

        @Override
        public void close() {
            this.brokerList_$eq(null);
            Utils.closeQuietly((AutoCloseable)this.adminClient(), (String)"adminClient");
            this.adminClient_$eq(null);
            try {
                TestUtils$.MODULE$.shutdownServers(this.servers());
            }
            finally {
                this.servers().clear();
            }
        }

        public /* synthetic */ ReassignPartitionsIntegrationTest kafka$admin$ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$brokerConfigs$3(Properties config$1, Map overrides) {
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(x$1, x$2) -> config$1.setProperty((String)x$1, (String)x$2);
            overrides.foreachEntry((arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ ArrayBuffer $anonfun$createServers$1(ReassignPartitionsTestCluster $this, int brokerId) {
            void createServer_time;
            void createServer_config;
            Time time;
            boolean bl = true;
            java.util.Map apply_props = (java.util.Map)$this.brokerConfigs().apply(brokerId);
            Object var2_3 = null;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time time3 = time2;
            KafkaConfig kafkaConfig = new KafkaConfig(apply_props, bl);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            Object var6_8 = null;
            Object var3_7 = null;
            kafkaConfig = null;
            time3 = null;
            return (ArrayBuffer)$this.servers().$plus$eq((Object)createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false));
        }

        public static final /* synthetic */ ProducerRecord $anonfun$produceMessages$1(String topic$1, int partition$1, int x$7) {
            return new ProducerRecord(topic$1, Predef$.MODULE$.int2Integer(partition$1), null, (Object)new byte[10000]);
        }

        public ReassignPartitionsTestCluster(ReassignPartitionsIntegrationTest $outer, String zkConnect, Map<String, String> configOverrides, Map<Object, Map<String, String>> brokerConfigOverrides) {
            this.zkConnect = zkConnect;
            this.configOverrides = configOverrides;
            this.brokerConfigOverrides = brokerConfigOverrides;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.brokers = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack1")}));
            this.topics = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1}))), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"baz"), (Object)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 2}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 1}))), (List)Nil$.MODULE$))))}));
            this.brokerConfigs = ((IterableOnceOps)this.brokers().map((Function1 & Serializable)x0$1 -> {
                void var4_24;
                None$ none$;
                None$ none$2;
                None$ none$3;
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int brokerId = x0$1._1$mcI$sp();
                String rack = (String)x0$1._2();
                String x$22 = this.zkConnect();
                Some x$3 = new Some((Object)rack);
                boolean bl = true;
                int n = TestUtils$.MODULE$.RandomPort();
                None$ none$4 = none$3 = None$.MODULE$;
                none$3 = null;
                None$ x$8 = none$4;
                None$ none$5 = none$2 = None$.MODULE$;
                none$2 = null;
                None$ x$9 = none$5;
                None$ none$6 = none$ = None$.MODULE$;
                none$ = null;
                None$ x$10 = none$6;
                boolean bl2 = true;
                boolean bl3 = false;
                int n2 = TestUtils$.MODULE$.RandomPort();
                boolean bl4 = false;
                int n3 = TestUtils$.MODULE$.RandomPort();
                boolean bl5 = false;
                int n4 = TestUtils$.MODULE$.RandomPort();
                boolean bl6 = false;
                int n5 = 1;
                short s = 1;
                Properties config = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$22, false, bl, n, (Option<SecurityProtocol>)x$8, (Option<File>)x$9, (Option<Properties>)x$10, bl2, bl3, n2, bl4, n3, bl5, n4, (Option<String>)x$3, 3, bl6, n5, s);
                config.setProperty(KafkaConfig$.MODULE$.ReplicaFetchBackoffMsProp(), "100");
                config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
                config.setProperty(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "1000");
                $this.configOverrides.foreachEntry((arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(x$1, x$2) -> config.setProperty((String)x$1, (String)x$2), arg_0, arg_1));
                $this.brokerConfigOverrides.get((Object)BoxesRunTime.boxToInteger((int)brokerId)).foreach((Function1 & Serializable)overrides -> {
                    ReassignPartitionsTestCluster.$anonfun$brokerConfigs$3(config, overrides);
                    return BoxedUnit.UNIT;
                });
                return var4_24;
            })).toBuffer();
            this.servers = new ArrayBuffer();
            this.brokerList = null;
            this.adminClient = null;
        }
    }
}

