/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import kafka.network.RequestChannel;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaType;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t}c\u0001B\u001c9\u0001uBQA\u0011\u0001\u0005\u0002\rCq!\u0012\u0001C\u0002\u0013%a\t\u0003\u0004K\u0001\u0001\u0006Ia\u0012\u0005\u0006\u0017\u0002!I\u0001\u0014\u0005\b\u0003O\u0003A\u0011AAU\u0011\u001d\t)\r\u0001C\u0001\u0003SCq!!3\u0001\t\u0003\tI\u000bC\u0004\u0002N\u0002!\t!!+\t\u000f\u0005E\u0007\u0001\"\u0001\u0002*\"9\u0011Q\u001b\u0001\u0005\n\u0005]\u0007bBA}\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003{\u0004A\u0011AAU\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0003SCqA!\u0002\u0001\t\u0003\tI\u000bC\u0004\u0003\n\u0001!\t!!+\t\u000f\t5\u0001\u0001\"\u0001\u0002*\"9!\u0011\u0003\u0001\u0005\u0002\u0005%\u0006b\u0002B\u000b\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u00053\u0001A\u0011AAU\r\u0011A\u0006\u0001R-\t\u00111$\"Q3A\u0005\u00025D\u0001B\u001e\u000b\u0003\u0012\u0003\u0006IA\u001c\u0005\toR\u0011)\u001a!C\u0001[\"A\u0001\u0010\u0006B\tB\u0003%a\u000e\u0003\u0005z)\tU\r\u0011\"\u0001{\u0011!qHC!E!\u0002\u0013Y\b\u0002C@\u0015\u0005+\u0007I\u0011\u0001>\t\u0013\u0005\u0005AC!E!\u0002\u0013Y\bB\u0002\"\u0015\t\u0003\t\u0019\u0001C\u0004\u0002\u000eQ!\t!a\u0004\t\u0013\u0005\u0005B#!A\u0005\u0002\u0005\r\u0002\"CA\u0017)E\u0005I\u0011AA\u0018\u0011%\t)\u0005FI\u0001\n\u0003\ty\u0003C\u0005\u0002HQ\t\n\u0011\"\u0001\u0002J!I\u0011Q\n\u000b\u0012\u0002\u0013\u0005\u0011\u0011\n\u0005\n\u0003\u001f\"\u0012\u0011!C!\u0003#B\u0011\"a\u0015\u0015\u0003\u0003%\t!!\u0016\t\u0013\u0005uC#!A\u0005\u0002\u0005}\u0003\"CA6)\u0005\u0005I\u0011IA7\u0011%\tY\bFA\u0001\n\u0003\ti\bC\u0005\u0002\bR\t\t\u0011\"\u0011\u0002\n\"I\u0011Q\u0012\u000b\u0002\u0002\u0013\u0005\u0013q\u0012\u0005\n\u0003##\u0012\u0011!C!\u0003'C\u0011\"!&\u0015\u0003\u0003%\t%a&\b\u0013\tu\u0001!!A\t\n\t}a\u0001\u0003-\u0001\u0003\u0003EIA!\t\t\r\tsC\u0011\u0001B\u001d\u0011%\t\tJLA\u0001\n\u000b\n\u0019\nC\u0005\u0003<9\n\t\u0011\"!\u0003>!I!q\t\u0018\u0012\u0002\u0013\u0005\u0011\u0011\n\u0005\n\u0005\u0013r\u0013\u0013!C\u0001\u0003\u0013B\u0011Ba\u0013/\u0003\u0003%\tI!\u0014\t\u0013\tmc&%A\u0005\u0002\u0005%\u0003\"\u0003B/]E\u0005I\u0011AA%\u0005Y\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:UKN$(BA\u001d;\u0003\u0019\u0019XM\u001d<fe*\t1(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001q\u0004CA A\u001b\u0005A\u0014BA!9\u0005i\u0011\u0015m]3DY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014H+Z:u\u0003\u0019a\u0014N\\5u}Q\tA\t\u0005\u0002@\u0001\u000511m\u001c8gS\u001e,\u0012a\u0012\t\u0003\u007f!K!!\u0013\u001d\u00031\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002!Q,7\u000f^)v_R\f\u0007+\u0019:tS:<G#C'T)\u0006m\u0015qTAR!\tq\u0015+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u0011)f.\u001b;\t\u000b\u0015#\u0001\u0019A$\t\u000bU#\u0001\u0019\u0001,\u0002\u000f\rd\u0017.\u001a8ucA\u0011q\u000bF\u0007\u0002\u0001\tQQk]3s\u00072LWM\u001c;\u0014\tQQV\f\u0019\t\u0003\u001dnK!\u0001X(\u0003\r\u0005s\u0017PU3g!\tqe,\u0003\u0002`\u001f\n9\u0001K]8ek\u000e$\bCA1j\u001d\t\u0011wM\u0004\u0002dM6\tAM\u0003\u0002fy\u00051AH]8pizJ\u0011\u0001U\u0005\u0003Q>\u000bq\u0001]1dW\u0006<W-\u0003\u0002kW\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001nT\u0001\u0005kN,'/F\u0001o!\ty7O\u0004\u0002qcB\u00111mT\u0005\u0003e>\u000ba\u0001\u0015:fI\u00164\u0017B\u0001;v\u0005\u0019\u0019FO]5oO*\u0011!oT\u0001\u0006kN,'\u000fI\u0001\tG2LWM\u001c;JI\u0006I1\r\\5f]RLE\rI\u0001\u000bG>tg-[4Vg\u0016\u0014X#A>\u0011\u00079ch.\u0003\u0002~\u001f\n1q\n\u001d;j_:\f1bY8oM&<Wk]3sA\u0005q1m\u001c8gS\u001e\u001cE.[3oi&#\u0017aD2p]\u001aLwm\u00117jK:$\u0018\n\u001a\u0011\u0015\u0013Y\u000b)!a\u0002\u0002\n\u0005-\u0001\"\u00027\u001e\u0001\u0004q\u0007\"B<\u001e\u0001\u0004q\u0007bB=\u001e!\u0003\u0005\ra\u001f\u0005\b\u007fv\u0001\n\u00111\u0001|\u0003]\u0019\u0018M\\5uSj,GmQ8oM&<7\t\\5f]RLE-\u0006\u0002\u0002\u0012A!a\n`A\n!\u0011\t)\"a\b\u000e\u0005\u0005]!\u0002BA\r\u00037\tA\u0001\\1oO*\u0011\u0011QD\u0001\u0005U\u00064\u0018-C\u0002u\u0003/\tAaY8qsRIa+!\n\u0002(\u0005%\u00121\u0006\u0005\bY~\u0001\n\u00111\u0001o\u0011\u001d9x\u0004%AA\u00029Dq!_\u0010\u0011\u0002\u0003\u00071\u0010C\u0004\u0000?A\u0005\t\u0019A>\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0007\u0016\u0004]\u0006M2FAA\u001b!\u0011\t9$!\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}r*\u0001\u0006b]:|G/\u0019;j_:LA!a\u0011\u0002:\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA&U\rY\u00181G\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111C\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003/\u00022ATA-\u0013\r\tYf\u0014\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003C\n9\u0007E\u0002O\u0003GJ1!!\u001aP\u0005\r\te.\u001f\u0005\n\u0003S2\u0013\u0011!a\u0001\u0003/\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA8!\u0019\t\t(a\u001e\u0002b5\u0011\u00111\u000f\u0006\u0004\u0003kz\u0015AC2pY2,7\r^5p]&!\u0011\u0011PA:\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005}\u0014Q\u0011\t\u0004\u001d\u0006\u0005\u0015bAAB\u001f\n9!i\\8mK\u0006t\u0007\"CA5Q\u0005\u0005\t\u0019AA1\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005M\u00111\u0012\u0005\n\u0003SJ\u0013\u0011!a\u0001\u0003/\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003/\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003'\ta!Z9vC2\u001cH\u0003BA@\u00033C\u0011\"!\u001b-\u0003\u0003\u0005\r!!\u0019\t\r\u0005uE\u00011\u0001W\u0003\u001d\u0019G.[3oiJBa!!)\u0005\u0001\u00041\u0016\u0001\u0004:b]\u0012|Wn\u00117jK:$\bBBAS\t\u0001\u0007a+A\neK\u001a\fW\u000f\u001c;D_:4\u0017nZ\"mS\u0016tG/\u0001\ruKN$8\t\\5f]RLE-U;pi\u0006\u0004\u0016M]:j]\u001e$\u0012!\u0014\u0015\u0004\u000b\u00055\u0006\u0003BAX\u0003\u0003l!!!-\u000b\t\u0005M\u0016QW\u0001\u0004CBL'\u0002BA\\\u0003s\u000bqA[;qSR,'O\u0003\u0003\u0002<\u0006u\u0016!\u00026v]&$(BAA`\u0003\ry'oZ\u0005\u0005\u0003\u0007\f\tL\u0001\u0003UKN$\u0018\u0001\u0006;fgR,6/\u001a:Rk>$\u0018\rU1sg&tw\rK\u0002\u0007\u0003[\u000bA\u0004^3tiV\u001bXM]\"mS\u0016tG/\u00133Rk>$\u0018\rU1sg&tw\rK\u0002\b\u0003[\u000bA\u0006^3tiV\u001bXM])v_R\f\u0007+\u0019:tS:<w+\u001b;i\t\u00164\u0017-\u001e7u\u00072LWM\u001c;JIF+x\u000e^1)\u0007!\ti+\u0001\u001buKN$Xk]3s\u00072LWM\u001c;Rk>$\u0018\rU1sg&tw-\u00133XSRDG)\u001a4bk2$8\t\\5f]RLE-U;pi\u0006D3!CAW\u0003)\u0019\u0007.Z2l#V|G/\u0019\u000b\u000e\u001b\u0006e\u00171]As\u0003O\f\t0!>\t\u000f\u0005m'\u00021\u0001\u0002^\u0006a\u0011/^8uC6\u000bg.Y4feB\u0019q(a8\n\u0007\u0005\u0005\bH\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\b\"\u00027\u000b\u0001\u0004q\u0007\"B<\u000b\u0001\u0004q\u0007bBAu\u0015\u0001\u0007\u00111^\u0001\u000eKb\u0004Xm\u0019;fI\n{WO\u001c3\u0011\u00079\u000bi/C\u0002\u0002p>\u0013A\u0001T8oO\"9\u00111\u001f\u0006A\u0002\u0005]\u0013!\u0002<bYV,\u0007bBA|\u0015\u0001\u0007\u0011qP\u0001\u000fKb\u0004Xm\u0019;UQJ|G\u000f\u001e7f\u0003U\"Xm\u001d;HKRl\u0015\r\u001f,bYV,\u0017J\\)v_R\fw+\u001b8e_^<\u0016\u000e\u001e5O_:$UMZ1vYR\fVo\u001c;b/&tGm\\<)\u0007-\ti+\u0001\u0011uKN$8+\u001a;B]\u0012\u0014V-\\8wK\u0012+g-Y;miV\u001bXM])v_R\f\u0007f\u0001\u0007\u0002.\u0006IB/Z:u'\u0016$\u0018I\u001c3SK6|g/Z+tKJ\fVo\u001c;bQ\ri\u0011QV\u0001 i\u0016\u001cHoU3u\u0003:$'+Z7pm\u0016,6/\u001a:DY&,g\u000e^)v_R\f\u0007f\u0001\b\u0002.\u0006IB/Z:u#V|G/Y\"p]\u001aLw\r\u0015:fG\u0016$WM\\2fQ\ry\u0011QV\u0001\u0013i\u0016\u001cH/U;pi\u00064\u0016n\u001c7bi&|g\u000eK\u0002\u0011\u0003[\u000bA\u0004^3ti\u0016C\b/\u001b:f)\"\u0014x\u000e\u001e;mKRKW.Z*f]N|'\u000fK\u0002\u0012\u0003[\u000ba\u0003^3ti\u0016C\b/\u001b:f#V|G/Y*f]N|'o\u001d\u0015\u0004%\u00055\u0016\u0001\u0007;fgR\u001cE.[3oi&#gj\u001c;TC:LG/\u001b>fI\"\u001a1#!,\u0002\u0015U\u001bXM]\"mS\u0016tG\u000f\u0005\u0002X]M)aFa\t\u00030AI!Q\u0005B\u0016]:\\8PV\u0007\u0003\u0005OQ1A!\u000bP\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\f\u0003(\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0011\t\tE\"qG\u0007\u0003\u0005gQAA!\u000e\u0002\u001c\u0005\u0011\u0011n\\\u0005\u0004U\nMBC\u0001B\u0010\u0003\u0015\t\u0007\u000f\u001d7z)%1&q\bB!\u0005\u0007\u0012)\u0005C\u0003mc\u0001\u0007a\u000eC\u0003xc\u0001\u0007a\u000eC\u0004zcA\u0005\t\u0019A>\t\u000f}\f\u0004\u0013!a\u0001w\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d)h.\u00199qYf$BAa\u0014\u0003XA!a\n B)!\u001dq%1\u000b8ownL1A!\u0016P\u0005\u0019!V\u000f\u001d7fi!A!\u0011\f\u001b\u0002\u0002\u0003\u0007a+A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C\u0007")
public class ClientQuotaManagerTest
extends BaseClientQuotaManagerTest {
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples(), ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds());

    private ClientQuotaManagerTest$UserClient$ UserClient() {
        if (this.UserClient$module == null) {
            this.UserClient$lzycompute$1();
        }
        return this.UserClient$module;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(config, this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)Long.MAX_VALUE, (double)clientQuotaManager.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0, (String)new StringBuilder(33).append("Default producer quota should be ").append((double)Long.MAX_VALUE).toString());
            Assertions.assertEquals((double)2000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (2000)");
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client2.user(), client2.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (4000)");
            int throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples());
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assertions.assertEquals((double)3000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (3000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 0.0);
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the default value (500)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 0.0);
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientQuotaManager.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (4000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples());
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples(), ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples(), ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    private void checkQuota(ClientQuotaManager quotaManager, String user, String clientId, long expectedBound, int value, boolean expectThrottle) {
        Assertions.assertEquals((double)expectedBound, (double)quotaManager.quota(user, clientId).bound(), (double)0.0);
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", user), InetAddress.getLocalHost());
        Assertions.assertEquals((double)(expectedBound < Long.MAX_VALUE ? (double)(this.config().quotaWindowSizeSeconds() * (this.config().numQuotaSamples() - 1)) * (double)expectedBound : Double.MAX_VALUE), (double)quotaManager.getMaxValueInQuotaWindow(session, clientId), (double)0.01);
        int throttleTimeMs = this.maybeRecord(quotaManager, user, clientId, value * this.config().numQuotaSamples());
        if (expectThrottle) {
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            return;
        }
        Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
    }

    @Test
    public void testGetMaxValueInQuotaWindowWithNonDefaultQuotaWindow() {
        int numFullQuotaWindows = 3;
        ClientQuotaManagerConfig nonDefaultConfig = new ClientQuotaManagerConfig(numFullQuotaWindows + 1, ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds());
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(nonDefaultConfig, this.metrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        RequestChannel.Session userSession = new RequestChannel.Session(new KafkaPrincipal("User", "userA"), InetAddress.getLocalHost());
        try {
            Assertions.assertEquals((double)Double.MAX_VALUE, (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            Assertions.assertEquals((double)(10 * numFullQuotaWindows), (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveDefaultUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples(), ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples(), ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserClientQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples(), ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples(), ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 4500, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 4000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client3", 4000L, 0, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 0, false);
            this.checkQuota(clientQuotaManager, "userB", "client1", 7000L, 8000, true);
            this.checkQuota(clientQuotaManager, "userB", "client2", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userB", "client3", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userD", "client1", 3000L, 3500, true);
            this.checkQuota(clientQuotaManager, "userD", "client2", 3000L, 2500, false);
            this.checkQuota(clientQuotaManager, "userE", "client1", 3000L, 2500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userD", "client1", 1000L, 0, false);
            this.checkQuota(clientQuotaManager, "userE", "client4", 1000L, 1500, true);
            this.checkQuota(clientQuotaManager, "userF", "client4", 1000L, 800, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 1000L, 800, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userF", "client4", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 2500, true);
            this.checkQuota(clientQuotaManager, "userG", "client5", 2000L, 0, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 6000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 8000L, 0, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client6", 11000L, 8500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 12000L, 4000, true);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0));
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 2300.0);
            Assertions.assertEquals((int)2100, (int)throttleTime, (String)"Should be throttled");
            this.throttle(clientQuotaManager, "ANONYMOUS", "unknown", throttleTime, this.callback());
            Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assertions.assertEquals((int)1, (int)this.numCallbacks());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0);
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 0.0), (String)"Should be unthrottled since bursty sample has rolled over");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            this.metrics().removeSensor("Produce-ANONYMOUS:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Assertions.assertNotNull((Object)this.metrics().getSensor("ProduceThrottleTime-:client1"), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor("Produce-:client1"), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdNotSanitized() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        String clientId = "client@#$%";
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", clientId, 100.0);
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(21).append("ProduceThrottleTime-:").append(clientId).toString()), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(9).append("Produce-:").append(clientId).toString()), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    private final void UserClient$lzycompute$1() {
        synchronized (this) {
            if (this.UserClient$module == null) {
                this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            }
            return;
        }
    }

    private class UserClient
    implements Product,
    Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            return this.configClientId().map((Function1 & Serializable)x -> {
                String string = x;
                String string2 = ConfigEntityName$.MODULE$.Default();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return ConfigEntityName$.MODULE$.Default();
                }
                return Sanitizer.sanitize((String)x);
            });
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.user();
                }
                case 1: {
                    return this.clientId();
                }
                case 2: {
                    return this.configUser();
                }
                case 3: {
                    return this.configClientId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "user";
                }
                case 1: {
                    return "clientId";
                }
                case 2: {
                    return "configUser";
                }
                case 3: {
                    return "configClientId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof UserClient)) return false;
            if (((UserClient)x$1).kafka$server$ClientQuotaManagerTest$UserClient$$$outer() != this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            UserClient userClient = (UserClient)x$1;
            String string = this.user();
            String string2 = userClient.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = userClient.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.configUser();
            Option<String> option2 = userClient.configUser();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.configClientId();
            Option<String> option4 = userClient.configClientId();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!userClient.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

