/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.GroupAuthorizerIntegrationTest$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.server.BaseRequestTest;
import kafka.server.ControllerServer;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005=u!B\u000f\u001f\u0011\u0003\u0019c!B\u0013\u001f\u0011\u00031\u0003\"B\u0017\u0002\t\u0003q\u0003bB\u0018\u0002\u0005\u0004%\t\u0001\r\u0005\u0007\u0001\u0006\u0001\u000b\u0011B\u0019\t\u000f\u0005\u000b!\u0019!C\u0001a!1!)\u0001Q\u0001\nEBqaQ\u0001C\u0002\u0013\u0005A\t\u0003\u0004N\u0003\u0001\u0006I!\u0012\u0005\b\u001d\u0006\u0011\r\u0011\"\u0001E\u0011\u0019y\u0015\u0001)A\u0005\u000b\u001a!\u0001+\u0001\u0001R\u0011\u0015i3\u0002\"\u0001Y\u0011\u0015Y6\u0002\"\u0011]\r\u0011)c\u0004\u00012\t\u000b5rA\u0011A5\t\u000f-t!\u0019!C\u0001Y\"1\u0001O\u0004Q\u0001\n5DQ!\u001d\b\u0005BIDQA\u001e\b\u0005B]DQA \b\u0005B]DQa \b\u0005\u0002ABa!!\u0001\u000f\t\u0003\u0001\u0004bBA\u0002\u001d\u0011\u0005\u0013Q\u0001\u0005\b\u0003;qA\u0011IA\u0010\u0011\u001d\tyD\u0004C\u0005\u0003\u0003B\u0011\"a\u001a\u000f#\u0003%I!!\u001b\t\u000f\u0005}d\u0002\"\u0001\u0002\u0002\"9\u00111\u0012\b\u0005\u0002\u0005\u0005\u0015AH$s_V\u0004\u0018)\u001e;i_JL'0\u001a:J]R,wM]1uS>tG+Z:u\u0015\ty\u0002%A\u0002ba&T\u0011!I\u0001\u0006W\u000647.Y\u0002\u0001!\t!\u0013!D\u0001\u001f\u0005y9%o\\;q\u0003V$\bn\u001c:ju\u0016\u0014\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHo\u0005\u0002\u0002OA\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0012\u0002\u001f\t\u0013xn[3s!JLgnY5qC2,\u0012!\r\t\u0003eyj\u0011a\r\u0006\u0003iU\nA!Y;uQ*\u0011agN\u0001\tg\u0016\u001cWO]5us*\u0011\u0001(O\u0001\u0007G>lWn\u001c8\u000b\u0005\u0005R$BA\u001e=\u0003\u0019\t\u0007/Y2iK*\tQ(A\u0002pe\u001eL!aP\u001a\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\u0006\u0001\"I]8lKJ\u0004&/\u001b8dSB\fG\u000eI\u0001\u0010\u00072LWM\u001c;Qe&t7-\u001b9bY\u0006\u00012\t\\5f]R\u0004&/\u001b8dSB\fG\u000eI\u0001\u0013\u0005J|7.\u001a:MSN$XM\\3s\u001d\u0006lW-F\u0001F!\t15*D\u0001H\u0015\tA\u0015*\u0001\u0003mC:<'\"\u0001&\u0002\t)\fg/Y\u0005\u0003\u0019\u001e\u0013aa\u0015;sS:<\u0017a\u0005\"s_.,'\u000fT5ti\u0016tWM\u001d(b[\u0016\u0004\u0013AE\"mS\u0016tG\u000fT5ti\u0016tWM\u001d(b[\u0016\f1c\u00117jK:$H*[:uK:,'OT1nK\u0002\u0012Qc\u0012:pkB\u0004&/\u001b8dSB\fGNQ;jY\u0012,'o\u0005\u0002\f%B\u00111KV\u0007\u0002)*\u0011Q+N\u0001\u000eCV$\b.\u001a8uS\u000e\fGo\u001c:\n\u0005]#&\u0001\b#fM\u0006,H\u000e^&bM.\f\u0007K]5oG&\u0004\u0018\r\u001c\"vS2$WM\u001d\u000b\u00023B\u0011!lC\u0007\u0002\u0003\u0005)!-^5mIR\u0011\u0011'\u0018\u0005\u0006=6\u0001\raX\u0001\bG>tG/\u001a=u!\t\u0011\u0004-\u0003\u0002bg\t)\u0012)\u001e;iK:$\u0018nY1uS>t7i\u001c8uKb$8C\u0001\bd!\t!w-D\u0001f\u0015\t1\u0007%\u0001\u0004tKJ4XM]\u0005\u0003Q\u0016\u0014qBQ1tKJ+\u0017/^3tiR+7\u000f\u001e\u000b\u0002UB\u0011AED\u0001\tEJ|7.\u001a:JIV\tQ\u000e\u0005\u0002G]&\u0011qn\u0012\u0002\b\u0013:$XmZ3s\u0003%\u0011'o\\6fe&#\u0007%A\u0006ce>\\WM]\"pk:$X#A:\u0011\u0005!\"\u0018BA;*\u0005\rIe\u000e^\u0001\u0018S:$XM\u001d\"s_.,'\u000fT5ti\u0016tWM\u001d(b[\u0016,\u0012\u0001\u001f\t\u0003srl\u0011A\u001f\u0006\u0003w^\nqA\\3uo>\u00148.\u0003\u0002~u\naA*[:uK:,'OT1nK\u0006aA.[:uK:,'OT1nK\u0006y!M]8lKJ\u0004&/\u001b8dSB\fG.A\bdY&,g\u000e\u001e)sS:\u001c\u0017\u000e]1m\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0006\u0003\u0002\b\u00055\u0001c\u0001\u0015\u0002\n%\u0019\u00111B\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u001f9\u0002\u0019AA\t\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011qC%\u0002\tU$\u0018\u000e\\\u0005\u0005\u00037\t)B\u0001\u0006Qe>\u0004XM\u001d;jKN\fQa]3u+B$B!a\u0002\u0002\"!9\u00111\u0005\rA\u0002\u0005\u0015\u0012\u0001\u0003;fgRLeNZ8\u0011\t\u0005\u001d\u00121G\u0007\u0003\u0003SQ1aHA\u0016\u0015\u0011\ti#a\f\u0002\u000f),\b/\u001b;fe*\u0019\u0011\u0011\u0007\u001f\u0002\u000b),h.\u001b;\n\t\u0005U\u0012\u0011\u0006\u0002\t)\u0016\u001cH/\u00138g_\"\u001a\u0001$!\u000f\u0011\t\u0005\u001d\u00121H\u0005\u0005\u0003{\tIC\u0001\u0006CK\u001a|'/Z#bG\"\f\u0011b\u0019:fCR,\u0017i\u00197\u0015\u0011\u0005\r\u0013qJA-\u0003G\u0002B!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0004\u0003\u0013:\u0014aA1dY&!\u0011QJA$\u0005I\t5mY3tg\u000e{g\u000e\u001e:pY\u0016sGO]=\t\u000f\u0005E\u0013\u00041\u0001\u0002T\u0005a\u0011m\u00197Pa\u0016\u0014\u0018\r^5p]B!\u0011QIA+\u0013\u0011\t9&a\u0012\u0003\u0019\u0005\u001bGn\u00149fe\u0006$\u0018n\u001c8\t\u000f\u0005m\u0013\u00041\u0001\u0002^\u0005\t\u0012m\u00197QKJl\u0017n]:j_:$\u0016\u0010]3\u0011\t\u0005\u0015\u0013qL\u0005\u0005\u0003C\n9EA\tBG2\u0004VM]7jgNLwN\u001c+za\u0016D\u0001\"!\u001a\u001a!\u0003\u0005\r!M\u0001\naJLgnY5qC2\f1c\u0019:fCR,\u0017i\u00197%I\u00164\u0017-\u001e7uIM*\"!a\u001b+\u0007E\nig\u000b\u0002\u0002pA!\u0011\u0011OA>\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0014!C;oG\",7m[3e\u0015\r\tI(K\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA?\u0003g\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0005\"Xm\u001d;V]\u0006,H\u000f[8sSj,G\r\u0015:pIV\u001cW-\u00118e\u0007>t7/^7f)\t\t9\u0001K\u0002\u001c\u0003\u000b\u0003B!a\n\u0002\b&!\u0011\u0011RA\u0015\u0005\u0011!Vm\u001d;\u0002?Q,7\u000f^!vi\"|'/\u001b>fIB\u0013x\u000eZ;dK\u0006sGmQ8ogVlW\rK\u0002\u001d\u0003\u000b\u0003")
public class GroupAuthorizerIntegrationTest
extends BaseRequestTest {
    private final Integer brokerId = Predef$.MODULE$.int2Integer(0);

    public static String ClientListenerName() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientListenerName();
    }

    public static String BrokerListenerName() {
        return GroupAuthorizerIntegrationTest$.MODULE$.BrokerListenerName();
    }

    public static KafkaPrincipal ClientPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
    }

    public static KafkaPrincipal BrokerPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal();
    }

    public Integer brokerId() {
        return this.brokerId;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public ListenerName interBrokerListenerName() {
        return new ListenerName(GroupAuthorizerIntegrationTest$.MODULE$.BrokerListenerName());
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName(GroupAuthorizerIntegrationTest$.MODULE$.ClientListenerName());
    }

    public KafkaPrincipal brokerPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal();
    }

    public KafkaPrincipal clientPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), AclAuthorizer.class.getName());
        properties.put(KafkaConfig$.MODULE$.BrokerIdProp(), this.brokerId().toString());
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        properties.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), "1");
        properties.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), "1");
        properties.put("principal.builder.class", GroupPrincipalBuilder.class.getName());
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, false);
        TestUtils$.MODULE$.addAndVerifyAcls(this.brokers(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.CLUSTER_ACTION, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal())}))), new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL), (Seq<ControllerServer>)Nil$.MODULE$);
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
    }

    private AccessControlEntry createAcl(AclOperation aclOperation, AclPermissionType aclPermissionType, KafkaPrincipal principal) {
        return new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), aclOperation, aclPermissionType);
    }

    private KafkaPrincipal createAcl$default$3() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
    }

    @Test
    public void testUnauthorizedProduceAndConsume() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Throwable produceException = Assertions.assertThrows(ExecutionException.class, () -> producer.send(new ProducerRecord(topic, (Object)"message".getBytes())).get()).getCause();
        Assertions.assertTrue((boolean)(produceException instanceof TopicAuthorizationException));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(((TopicAuthorizationException)produceException).unauthorizedTopics()).asScala());
        List x$1 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"group.id"}));
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        Properties x$4 = this.createConsumer$default$3();
        KafkaConsumer consumer = this.createConsumer(x$2, x$3, x$4, (List<String>)x$1);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))).asJava());
        TopicAuthorizationException consumeException = (TopicAuthorizationException)Assertions.assertThrows(TopicAuthorizationException.class, () -> TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(consumeException.unauthorizedTopics()).asScala());
    }

    @Test
    public void testAuthorizedProduceAndConsume() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        TestUtils$.MODULE$.addAndVerifyAcls(this.brokers(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.WRITE, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal())}))), new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL), (Seq<ControllerServer>)Nil$.MODULE$);
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(new ProducerRecord(topic, (Object)"message".getBytes())).get();
        TestUtils$.MODULE$.addAndVerifyAcls(this.brokers(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.READ, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal())}))), new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL), (Seq<ControllerServer>)Nil$.MODULE$);
        List x$1 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"group.id"}));
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        Properties x$4 = this.createConsumer$default$3();
        KafkaConsumer consumer = this.createConsumer(x$2, x$3, x$4, (List<String>)x$1);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))).asJava());
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L);
    }

    public static class GroupPrincipalBuilder
    extends DefaultKafkaPrincipalBuilder {
        public KafkaPrincipal build(AuthenticationContext context) {
            KafkaPrincipal kafkaPrincipal;
            String string = context.listenerName();
            String string2 = GroupAuthorizerIntegrationTest$.MODULE$.BrokerListenerName();
            if (!(string2 != null ? !string2.equals(string) : string != null)) {
                kafkaPrincipal = GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal();
            } else {
                String string3 = GroupAuthorizerIntegrationTest$.MODULE$.ClientListenerName();
                if (!(string3 != null ? !string3.equals(string) : string != null)) {
                    kafkaPrincipal = GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
                } else {
                    throw new IllegalArgumentException(new StringBuilder(32).append("No principal mapped to listener ").append(string).toString());
                }
            }
            return kafkaPrincipal;
        }

        public GroupPrincipalBuilder() {
            super(null, null);
        }
    }
}

