/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.network.SocketServer;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ByteUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001B\u000b\u0017\u0001mAQA\t\u0001\u0005\u0002\rBQA\n\u0001\u0005\u0002\u001dBQ!\u000e\u0001\u0005\nYBQ!\u0010\u0001\u0005\nyBqA\u0017\u0001\u0012\u0002\u0013%1\fC\u0004g\u0001E\u0005I\u0011B4\t\u000b%\u0004A\u0011\u00026\t\u0013\u0005\r\u0001!%A\u0005\n\u0005\u0015\u0001bBA\u0005\u0001\u0011%\u00111\u0002\u0005\b\u0003\u001f\u0001A\u0011BA\t\u0011%\t9\u0002AI\u0001\n\u0013\t)\u0001C\u0004\u0002\u001a\u0001!\t!a\u0007\t\u0013\u0005%\u0003!%A\u0005\u0002\u0005-\u0003\"CA(\u0001E\u0005I\u0011AA)\u0011\u001d\t)\u0006\u0001C\u0005\u0003/Bq!a\u0017\u0001\t\u0003\ti\u0006C\u0004\u0002v\u0001!\t!!\u0018\t\u000f\u0005e\u0004\u0001\"\u0001\u0002^!9\u0011Q\u0010\u0001\u0005\u0002\u0005u\u0003bBAA\u0001\u0011\u0005\u0011Q\f\u0002\u0014\u000b\u0012<WmQ1tKJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003/a\taa]3sm\u0016\u0014(\"A\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0003?a\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011\u0011E\b\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012\u0001\n\t\u0003K\u0001i\u0011AF\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\t\u0001\u0006E\u0002*aIj\u0011A\u000b\u0006\u0003W1\n\u0011\"[7nkR\f'\r\\3\u000b\u00055r\u0013AC2pY2,7\r^5p]*\tq&A\u0003tG\u0006d\u0017-\u0003\u00022U\t!A*[:u!\t)3'\u0003\u00025-\tY1*\u00194lC\u000e{gNZ5h\u00031\u0019xnY6fiN+'O^3s+\u00059\u0004C\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u0019\u0003\u001dqW\r^<pe.L!\u0001P\u001d\u0003\u0019M{7m[3u'\u0016\u0014h/\u001a:\u0002\u000f\r|gN\\3diR\u0019qhR%\u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015a\u00018fi*\tA)\u0001\u0003kCZ\f\u0017B\u0001$B\u0005\u0019\u0019vnY6fi\"9\u0001\n\u0002I\u0001\u0002\u00049\u0014!A:\t\u000f)#\u0001\u0013!a\u0001\u0017\u0006A\u0001O]8u_\u000e|G\u000e\u0005\u0002M16\tQJ\u0003\u0002O\u001f\u0006!\u0011-\u001e;i\u0015\t\u0001\u0016+\u0001\u0005tK\u000e,(/\u001b;z\u0015\t\u00116+\u0001\u0004d_6lwN\u001c\u0006\u00033QS!!\u0016,\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0016aA8sO&\u0011\u0011,\u0014\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2\f\u0011cY8o]\u0016\u001cG\u000f\n3fM\u0006,H\u000e\u001e\u00132+\u0005a&FA\u001c^W\u0005q\u0006CA0e\u001b\u0005\u0001'BA1c\u0003%)hn\u00195fG.,GM\u0003\u0002d]\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\u0015\u0004'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\t2m\u001c8oK\u000e$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003!T#aS/\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\u0005W>\f\u0018\u0010\u0005\u0002m[6\ta&\u0003\u0002o]\t!QK\\5u\u0011\u0015\u0001x\u00011\u0001@\u0003\u0019\u0019xnY6fi\")!o\u0002a\u0001g\u00069!/Z9vKN$\bc\u00017um&\u0011QO\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003Y^L!\u0001\u001f\u0018\u0003\t\tKH/\u001a\u0005\bu\u001e\u0001\n\u00111\u0001|\u0003\tIG\rE\u0002myzL!! \u0018\u0003\r=\u0003H/[8o!\taw0C\u0002\u0002\u00029\u0012Qa\u00155peR\fQc]3oIJ+\u0017/^3ti\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\b)\u001210X\u0001\u0010e\u0016\u001cW-\u001b<f%\u0016\u001c\bo\u001c8tKR\u00191/!\u0004\t\u000bAL\u0001\u0019A \u0002#I,\u0017/^3ti\u0006sGMU3dK&4X\rF\u0003t\u0003'\t)\u0002C\u0003s\u0015\u0001\u00071\u000fC\u0004{\u0015A\u0005\t\u0019A>\u00027I,\u0017/^3ti\u0006sGMU3dK&4X\r\n3fM\u0006,H\u000e\u001e\u00133\u0003I\u0011X-];fgRDU-\u00193fe\nKH/Z:\u0015\u0013M\fi\"!\t\u0002&\u0005}\u0002BBA\u0010\u0019\u0001\u0007a0\u0001\u0004ba&\\U-\u001f\u0005\u0007\u0003Ga\u0001\u0019\u0001@\u0002\u0015\u0005\u0004\u0018NV3sg&|g\u000eC\u0005\u0002(1\u0001\n\u00111\u0001\u0002*\u0005A1\r\\5f]RLE\r\u0005\u0003\u0002,\u0005eb\u0002BA\u0017\u0003k\u00012!a\f/\u001b\t\t\tDC\u0002\u00024i\ta\u0001\u0010:p_Rt\u0014bAA\u001c]\u00051\u0001K]3eK\u001aLA!a\u000f\u0002>\t11\u000b\u001e:j]\u001eT1!a\u000e/\u0011%\t\t\u0005\u0004I\u0001\u0002\u0004\t\u0019%A\u0007d_J\u0014X\r\\1uS>t\u0017\n\u001a\t\u0004Y\u0006\u0015\u0013bAA$]\t\u0019\u0011J\u001c;\u00029I,\u0017/^3ti\"+\u0017\rZ3s\u0005f$Xm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\n\u0016\u0004\u0003Si\u0016\u0001\b:fcV,7\u000f\u001e%fC\u0012,'OQ=uKN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003'R3!a\u0011^\u0003A1XM]5gs\u0012K7oY8o]\u0016\u001cG\u000fF\u0002l\u00033BQA]\bA\u0002M\f!\u0005^3tiB\u0013x\u000eZ;dKJ+\u0017/^3ti^KG\u000f\u001b(vY2\u001cE.[3oi&#G#A6)\u0007A\t\t\u0007\u0005\u0003\u0002d\u0005ETBAA3\u0015\u0011\t9'!\u001b\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002l\u00055\u0014a\u00026va&$XM\u001d\u0006\u0004\u0003_2\u0016!\u00026v]&$\u0018\u0002BA:\u0003K\u0012A\u0001V3ti\u0006)B/Z:u\u0011\u0016\fG-\u001a:P]2L(+Z9vKN$\bfA\t\u0002b\u0005AB/Z:u\u0013:4\u0018\r\\5e\u0003BL7*Z=SKF,Xm\u001d;)\u0007I\t\t'\u0001\u000fuKN$\u0018J\u001c<bY&$\u0017\t]5WKJ\u001c\u0018n\u001c8SKF,Xm\u001d;)\u0007M\t\t'\u0001\u000euKN$X*\u00197g_JlW\r\u001a%fC\u0012,'OU3rk\u0016\u001cH\u000fK\u0002\u0015\u0003C\u0002")
public class EdgeCaseRequestTest
extends KafkaServerTestHarness {
    public List<KafkaConfig> generateConfigs() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{KafkaConfig$.MODULE$.fromProps(props)}));
    }

    private SocketServer socketServer() {
        return ((KafkaServer)this.servers().head()).socketServer();
    }

    private Socket connect(SocketServer s, SecurityProtocol protocol) {
        return new Socket("localhost", s.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)protocol)));
    }

    private SocketServer connect$default$1() {
        return this.socketServer();
    }

    private SecurityProtocol connect$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    private void sendRequest(Socket socket, byte[] request, Option<Object> id) {
        DataOutputStream outgoing = new DataOutputStream(socket.getOutputStream());
        if (id instanceof Some) {
            short id2 = BoxesRunTime.unboxToShort((Object)((Some)id).value());
            outgoing.writeInt(request.length + 2);
            outgoing.writeShort(id2);
        } else if (None$.MODULE$.equals(id)) {
            outgoing.writeInt(request.length);
        } else {
            throw new MatchError(id);
        }
        outgoing.write(request);
        outgoing.flush();
    }

    private Option<Object> sendRequest$default$3() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] receiveResponse(Socket socket) {
        void var3_3;
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        byte[] response = new byte[incoming.readInt()];
        incoming.readFully(response);
        return var3_3;
    }

    private byte[] requestAndReceive(byte[] request, Option<Object> id) {
        byte[] byArray;
        try (Socket plainSocket = this.connect(this.connect$default$1(), SecurityProtocol.PLAINTEXT);){
            this.sendRequest(plainSocket, request, id);
            byArray = this.receiveResponse(plainSocket);
        }
        return byArray;
    }

    private Option<Object> requestAndReceive$default$2() {
        return None$.MODULE$;
    }

    public byte[] requestHeaderBytes(short apiKey, short apiVersion, String clientId, int correlationId) {
        boolean flexVersion = apiKey >= 0 ? ApiKeys.forId((int)apiKey).requestHeaderVersion(apiVersion) >= 2 : false;
        ByteBuffer buffer = ByteBuffer.allocate(8 + Type.NULLABLE_STRING.sizeOf((Object)clientId) + (flexVersion ? ByteUtils.sizeOfUnsignedVarint((int)0) : 0));
        buffer.putShort(apiKey);
        buffer.putShort(apiVersion);
        buffer.putInt(correlationId);
        Type.NULLABLE_STRING.write(buffer, (Object)clientId);
        if (flexVersion) {
            ByteUtils.writeUnsignedVarint((int)0, (ByteBuffer)buffer);
        }
        return buffer.array();
    }

    public String requestHeaderBytes$default$3() {
        return "";
    }

    public int requestHeaderBytes$default$4() {
        return -1;
    }

    private void verifyDisconnect(byte[] request) {
        try (Socket plainSocket = this.connect(this.connect$default$1(), SecurityProtocol.PLAINTEXT);){
            this.sendRequest(plainSocket, this.requestHeaderBytes((short)-1, (short)0, this.requestHeaderBytes$default$3(), this.requestHeaderBytes$default$4()), (Option<Object>)None$.MODULE$);
            Assertions.assertEquals((int)-1, (int)plainSocket.getInputStream().read(), (String)"The server should disconnect");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProduceRequestWithNullClientId() {
        void var9_16;
        void withRecords_records;
        void withRecords_timestampType;
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int correlationId = -1;
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        short version = ApiKeys.PRODUCE.latestVersion();
        byte[] headerBytes = this.requestHeaderBytes(ApiKeys.PRODUCE.id, version, "", correlationId);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("message".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var15_7 = null;
        simpleRecordArray = null;
        ProduceRequestData forCurrentMagic_data = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records))))).iterator())).setAcks((short)1).setTimeoutMs(10000).setTransactionalId(null);
        Object var17_11 = null;
        ProduceRequest request = (ProduceRequest)ProduceRequest.forMagic((byte)2, (ProduceRequestData)forCurrentMagic_data).build();
        ByteBuffer bodyBytes = request.serialize();
        ByteBuffer byteBuffer = ByteBuffer.allocate(headerBytes.length + bodyBytes.remaining());
        byteBuffer.put(headerBytes);
        byteBuffer.put(bodyBytes);
        short s = request.apiKey().responseHeaderVersion(version);
        byte[] serializedBytes = byteBuffer.array();
        ByteBuffer responseBuffer = ByteBuffer.wrap(this.requestAndReceive((byte[])var9_16, (Option<Object>)None$.MODULE$));
        ResponseHeader responseHeader = ResponseHeader.parse((ByteBuffer)responseBuffer, (short)s);
        ProduceResponse produceResponse = ProduceResponse.parse((ByteBuffer)responseBuffer, (short)version);
        Assertions.assertEquals((int)0, (int)responseBuffer.remaining(), (String)"The response should parse completely");
        Assertions.assertEquals((int)correlationId, (int)responseHeader.correlationId(), (String)"The correlationId should match request");
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size(), (String)"One topic response should be returned");
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size(), (String)"One partition response should be returned");
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        Assertions.assertNotNull((Object)partitionProduceResponse);
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()), (String)"There should be no error");
    }

    @Test
    public void testHeaderOnlyRequest() {
        this.verifyDisconnect(this.requestHeaderBytes(ApiKeys.PRODUCE.id, (short)1, this.requestHeaderBytes$default$3(), this.requestHeaderBytes$default$4()));
    }

    @Test
    public void testInvalidApiKeyRequest() {
        this.verifyDisconnect(this.requestHeaderBytes((short)-1, (short)0, this.requestHeaderBytes$default$3(), this.requestHeaderBytes$default$4()));
    }

    @Test
    public void testInvalidApiVersionRequest() {
        this.verifyDisconnect(this.requestHeaderBytes(ApiKeys.PRODUCE.id, (short)-1, this.requestHeaderBytes$default$3(), this.requestHeaderBytes$default$4()));
    }

    @Test
    public void testMalformedHeaderRequest() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putShort(ApiKeys.PRODUCE.id);
        buffer.putShort((short)1);
        byte[] serializedBytes = buffer.array();
        this.verifyDisconnect(serializedBytes);
    }
}

