/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.api.KAFKA_3_2_IV0$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaYammerMetrics;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.network.DataPlaneAcceptor$;
import kafka.network.SocketServer;
import kafka.raft.RaftManager;
import kafka.security.CredentialProvider;
import kafka.server.ControllerApis;
import kafka.server.ControllerConfigurationValidator;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.MetaProperties;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.Server;
import kafka.server.Server$SHUTDOWN$;
import kafka.server.Server$SHUTTING_DOWN$;
import kafka.server.Server$STARTED$;
import kafka.server.Server$STARTING$;
import kafka.server.SimpleApiVersionManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.ControllerMetrics;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.controller.QuorumControllerMetrics;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\reb\u0001B\"E\u0001%C\u0001\u0002\u0018\u0001\u0003\u0006\u0004%\t!\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0005=\"A1\r\u0001BC\u0002\u0013\u0005A\r\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003f\u0011!I\u0007A!b\u0001\n\u0003Q\u0007\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011B6\t\u0011y\u0004!Q1A\u0005\u0002}D!\"!\u0004\u0001\u0005\u0003\u0005\u000b\u0011BA\u0001\u0011%I\u0006A!b\u0001\n\u0003\ty\u0001\u0003\u0006\u0002\u001c\u0001\u0011\t\u0011)A\u0005\u0003#A!\"!\b\u0001\u0005\u000b\u0007I\u0011AA\u0010\u0011)\ti\u0004\u0001B\u0001B\u0003%\u0011\u0011\u0005\u0005\u000b\u0003\u007f\u0001!Q1A\u0005\u0002\u0005\u0005\u0003BCAF\u0001\t\u0005\t\u0015!\u0003\u0002D!Q\u0011Q\u0012\u0001\u0003\u0006\u0004%\t!a$\t\u0015\u0005u\u0005A!A!\u0002\u0013\t\t\nC\u0004\u0002 \u0002!\t!!)\t\u0013\u0005U\u0006A1A\u0005\u0002\u0005]\u0006\u0002CAc\u0001\u0001\u0006I!!/\t\u0013\u0005\u001d\u0007A1A\u0005\u0002\u0005%\u0007\u0002CAi\u0001\u0001\u0006I!a3\t\u0013\u0005M\u0007\u00011A\u0005\u0002\u0005U\u0007\"CAw\u0001\u0001\u0007I\u0011AAx\u0011!\tY\u0010\u0001Q!\n\u0005]\u0007\"CA\u007f\u0001\u0001\u0007I\u0011AA\u0000\u0011%\u00119\u0001\u0001a\u0001\n\u0003\u0011I\u0001\u0003\u0005\u0003\u000e\u0001\u0001\u000b\u0015\u0002B\u0001\u0011%\u0011y\u0001\u0001a\u0001\n\u0003\u0011\t\u0002C\u0005\u0003 \u0001\u0001\r\u0011\"\u0001\u0003\"!A!Q\u0005\u0001!B\u0013\u0011\u0019\u0002C\u0005\u00030\u0001\u0001\r\u0011\"\u0001\u00032!I!1\n\u0001A\u0002\u0013\u0005!Q\n\u0005\t\u0005#\u0002\u0001\u0015)\u0003\u00034!I!1\u000b\u0001A\u0002\u0013\u0005!Q\u000b\u0005\n\u0005C\u0002\u0001\u0019!C\u0001\u0005GB\u0001Ba\u001a\u0001A\u0003&!q\u000b\u0005\n\u0005S\u0002\u0001\u0019!C\u0001\u0005WB\u0011B!\u001f\u0001\u0001\u0004%\tAa\u001f\t\u0011\t}\u0004\u0001)Q\u0005\u0005[B\u0011B!!\u0001\u0005\u0004%\tAa!\t\u0011\t\u001d\u0005\u0001)A\u0005\u0005\u000bC\u0011B!#\u0001\u0001\u0004%\tAa#\t\u0013\tm\u0005\u00011A\u0005\u0002\tu\u0005\u0002\u0003BQ\u0001\u0001\u0006KA!$\t\u0013\t\r\u0006\u00011A\u0005\u0002\t\u0015\u0006\"\u0003BX\u0001\u0001\u0007I\u0011\u0001BY\u0011!\u0011)\f\u0001Q!\n\t\u001d\u0006\"\u0003B\\\u0001\u0001\u0007I\u0011\u0001B]\u0011%\u0011)\r\u0001a\u0001\n\u0003\u00119\r\u0003\u0005\u0003L\u0002\u0001\u000b\u0015\u0002B^\u0011%\u0011i\r\u0001b\u0001\n\u0003\u0011y\r\u0003\u0005\u0003\\\u0002\u0001\u000b\u0011\u0002Bi\u0011%\u0011i\u000e\u0001a\u0001\n\u0003\u0011y\u000eC\u0005\u0003p\u0002\u0001\r\u0011\"\u0001\u0003r\"A!Q\u001f\u0001!B\u0013\u0011\t\u000fC\u0005\u0003x\u0002\u0001\r\u0011\"\u0001\u0003z\"I1\u0011\u0001\u0001A\u0002\u0013\u000511\u0001\u0005\t\u0007\u000f\u0001\u0001\u0015)\u0003\u0003|\"I1\u0011\u0002\u0001A\u0002\u0013\u000511\u0002\u0005\n\u0007'\u0001\u0001\u0019!C\u0001\u0007+A\u0001b!\u0007\u0001A\u0003&1Q\u0002\u0005\b\u00077\u0001A\u0011BB\u000f\u0011\u001d\u0019i\u0003\u0001C\u0001\u0007_Aqa!\r\u0001\t\u0003\u0019\u0019\u0004C\u0004\u00046\u0001!\taa\r\t\u000f\r]\u0002\u0001\"\u0001\u00044\t\u00012i\u001c8ue>dG.\u001a:TKJ4XM\u001d\u0006\u0003\u000b\u001a\u000baa]3sm\u0016\u0014(\"A$\u0002\u000b-\fgm[1\u0004\u0001M!\u0001A\u0013)W!\tYe*D\u0001M\u0015\u0005i\u0015!B:dC2\f\u0017BA(M\u0005\u0019\te.\u001f*fMB\u0011\u0011\u000bV\u0007\u0002%*\u00111KR\u0001\u0006kRLGn]\u0005\u0003+J\u0013q\u0001T8hO&tw\r\u0005\u0002X56\t\u0001L\u0003\u0002Z\r\u00069Q.\u001a;sS\u000e\u001c\u0018BA.Y\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\u000f[\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t+\u0005q\u0006CA0a\u001b\u0005!\u0015BA1E\u00059iU\r^1Qe>\u0004XM\u001d;jKN\fq\"\\3uCB\u0013x\u000e]3si&,7\u000fI\u0001\u0007G>tg-[4\u0016\u0003\u0015\u0004\"a\u00184\n\u0005\u001d$%aC&bM.\f7i\u001c8gS\u001e\fqaY8oM&<\u0007%A\u0006sC\u001a$X*\u00198bO\u0016\u0014X#A6\u0011\u00071|\u0017/D\u0001n\u0015\tqg)\u0001\u0003sC\u001a$\u0018B\u00019n\u0005-\u0011\u0016M\u001a;NC:\fw-\u001a:\u0011\u0005I\\X\"A:\u000b\u0005Q,\u0018AB2p[6|gN\u0003\u0002Fm*\u0011qi\u001e\u0006\u0003qf\fa!\u00199bG\",'\"\u0001>\u0002\u0007=\u0014x-\u0003\u0002}g\n!\u0012\t]5NKN\u001c\u0018mZ3B]\u00124VM]:j_:\fAB]1gi6\u000bg.Y4fe\u0002\nA\u0001^5nKV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u00191+a\u0002\u000b\u0005Q4\u0018\u0002BA\u0006\u0003\u000b\u0011A\u0001V5nK\u0006)A/[7fAU\u0011\u0011\u0011\u0003\t\u0005\u0003'\t9\"\u0004\u0002\u0002\u0016)\u0019\u0011,a\u0002\n\t\u0005e\u0011Q\u0003\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y+\t\t\t\u0003E\u0003L\u0003G\t9#C\u0002\u0002&1\u0013aa\u00149uS>t\u0007\u0003BA\u0015\u0003oqA!a\u000b\u00024A\u0019\u0011Q\u0006'\u000e\u0005\u0005=\"bAA\u0019\u0011\u00061AH]8pizJ1!!\u000eM\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011HA\u001e\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0007'\u0002#QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\b%\u0001\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3\u0016\u0005\u0005\r\u0003CBA#\u0003'\n9&\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003\u001b\ny%\u0001\u0003vi&d'BAA)\u0003\u0011Q\u0017M^1\n\t\u0005U\u0013q\t\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003CA-\u00037\ny&a\u001b\u000e\u0005\u0005-\u0013\u0002BA/\u0003\u0017\u00121!T1q!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$\u0002BA3\u0003\u001f\nA\u0001\\1oO&!\u0011\u0011NA2\u0005\u001dIe\u000e^3hKJ\u0004B!!\u001c\u0002\u0006:!\u0011qNA@\u001d\u0011\t\t(! \u000f\t\u0005M\u00141\u0010\b\u0005\u0003k\nIH\u0004\u0003\u0002.\u0005]\u0014\"\u0001>\n\u0005aL\u0018BA$x\u0013\tqg/\u0003\u0003\u0002\u0002\u0006\r\u0015A\u0003*bMR\u001cuN\u001c4jO*\u0011aN^\u0005\u0005\u0003\u000f\u000bIIA\u0006BI\u0012\u0014Xm]:Ta\u0016\u001c'\u0002BAA\u0003\u0007\u000bQdY8oiJ|G\u000e\\3s#V|'/^7W_R,'o\u001d$viV\u0014X\rI\u0001\rG>tg-[4TG\",W.Y\u000b\u0003\u0003#\u0003B!a%\u0002\u001a6\u0011\u0011Q\u0013\u0006\u0004\u0003/3\u0018\u0001C7fi\u0006$\u0017\r^1\n\t\u0005m\u0015Q\u0013\u0002\u0012\u0017\u000647.Y\"p]\u001aLwmU2iK6\f\u0017!D2p]\u001aLwmU2iK6\f\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003G\u000b)+a*\u0002*\u0006-\u0016QVAX\u0003c\u000b\u0019\f\u0005\u0002`\u0001!)A,\u0005a\u0001=\")1-\u0005a\u0001K\")\u0011.\u0005a\u0001W\"1a0\u0005a\u0001\u0003\u0003Aa!W\tA\u0002\u0005E\u0001bBA\u000f#\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003\u007f\t\u0002\u0019AA\"\u0011\u001d\ti)\u0005a\u0001\u0003#\u000bA\u0001\\8dWV\u0011\u0011\u0011\u0018\t\u0005\u0003w\u000b\t-\u0004\u0002\u0002>*!\u0011qXA$\u0003\u0015awnY6t\u0013\u0011\t\u0019-!0\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0003\u0015awnY6!\u0003E\tw/Y5u'\",H\u000fZ8x]\u000e{g\u000eZ\u000b\u0003\u0003\u0017\u0004B!a/\u0002N&!\u0011qZA_\u0005%\u0019uN\u001c3ji&|g.\u0001\nbo\u0006LGo\u00155vi\u0012|wO\\\"p]\u0012\u0004\u0013AB:uCR,8/\u0006\u0002\u0002XB!\u0011\u0011\\At\u001d\u0011\tY.a9\u000f\t\u0005u\u0017\u0011\u001d\b\u0005\u0003[\ty.C\u0001H\u0013\t)e)C\u0002\u0002f\u0012\u000baaU3sm\u0016\u0014\u0018\u0002BAu\u0003W\u0014Q\u0002\u0015:pG\u0016\u001c8o\u0015;biV\u001c(bAAs\t\u0006Q1\u000f^1ukN|F%Z9\u0015\t\u0005E\u0018q\u001f\t\u0004\u0017\u0006M\u0018bAA{\u0019\n!QK\\5u\u0011%\tIpFA\u0001\u0002\u0004\t9.A\u0002yIE\nqa\u001d;biV\u001c\b%A\fmS:,\b0S8NKR\u0014\u0018nY:D_2dWm\u0019;peV\u0011!\u0011\u0001\t\u0004/\n\r\u0011b\u0001B\u00031\n9B*\u001b8vq&{W*\u001a;sS\u000e\u001c8i\u001c7mK\u000e$xN]\u0001\u001cY&tW\u000f_%p\u001b\u0016$(/[2t\u0007>dG.Z2u_J|F%Z9\u0015\t\u0005E(1\u0002\u0005\n\u0003sT\u0012\u0011!a\u0001\u0005\u0003\t\u0001\u0004\\5okbLu.T3ue&\u001c7oQ8mY\u0016\u001cGo\u001c:!\u0003)\tW\u000f\u001e5pe&TXM]\u000b\u0003\u0005'\u0001RaSA\u0012\u0005+\u0001BAa\u0006\u0003\u001c5\u0011!\u0011\u0004\u0006\u0004\u0005\u001f)\u0018\u0002\u0002B\u000f\u00053\u0011!\"Q;uQ>\u0014\u0018N_3s\u00039\tW\u000f\u001e5pe&TXM]0%KF$B!!=\u0003$!I\u0011\u0011`\u000f\u0002\u0002\u0003\u0007!1C\u0001\fCV$\bn\u001c:ju\u0016\u0014\b\u0005K\u0002\u001f\u0005S\u00012a\u0013B\u0016\u0013\r\u0011i\u0003\u0014\u0002\tm>d\u0017\r^5mK\u0006QAo\\6f]\u000e\u000b7\r[3\u0016\u0005\tM\u0002\u0003\u0002B\u001b\u0005\u000fj!Aa\u000e\u000b\t\te\"1H\u0001\nS:$XM\u001d8bYNTAA!\u0010\u0003@\u0005QA-\u001a7fO\u0006$\u0018n\u001c8\u000b\t\t\u0005#1I\u0001\u0006i>\\WM\u001c\u0006\u0005\u0005\u000b\n9!\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\u0011IEa\u000e\u0003)\u0011+G.Z4bi&|g\u000eV8lK:\u001c\u0015m\u00195f\u00039!xn[3o\u0007\u0006\u001c\u0007.Z0%KF$B!!=\u0003P!I\u0011\u0011 \u0011\u0002\u0002\u0003\u0007!1G\u0001\fi>\\WM\\\"bG\",\u0007%\u0001\nde\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014XC\u0001B,!\u0011\u0011IF!\u0018\u000e\u0005\tm#b\u0001B#\r&!!q\fB.\u0005I\u0019%/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\u0002-\r\u0014X\rZ3oi&\fG\u000e\u0015:pm&$WM]0%KF$B!!=\u0003f!I\u0011\u0011`\u0012\u0002\u0002\u0003\u0007!qK\u0001\u0014GJ,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'\u000fI\u0001\rg>\u001c7.\u001a;TKJ4XM]\u000b\u0003\u0005[\u0002BAa\u001c\u0003v5\u0011!\u0011\u000f\u0006\u0004\u0005g2\u0015a\u00028fi^|'o[\u0005\u0005\u0005o\u0012\tH\u0001\u0007T_\u000e\\W\r^*feZ,'/\u0001\tt_\u000e\\W\r^*feZ,'o\u0018\u0013fcR!\u0011\u0011\u001fB?\u0011%\tIPJA\u0001\u0002\u0004\u0011i'A\u0007t_\u000e\\W\r^*feZ,'\u000fI\u0001!g>\u001c7.\u001a;TKJ4XM\u001d$jeN$(i\\;oIB{'\u000f\u001e$viV\u0014X-\u0006\u0002\u0003\u0006B1\u0011QIA*\u0003?\n\u0011e]8dW\u0016$8+\u001a:wKJ4\u0015N]:u\u0005>,h\u000e\u001a)peR4U\u000f^;sK\u0002\n\u0011c\u0019:fCR,Gk\u001c9jGB{G.[2z+\t\u0011i\tE\u0003L\u0003G\u0011y\t\u0005\u0003\u0003\u0012\n]UB\u0001BJ\u0015\r\u0011)*^\u0001\u0007a>d\u0017nY=\n\t\te%1\u0013\u0002\u0012\u0007J,\u0017\r^3U_BL7\rU8mS\u000eL\u0018!F2sK\u0006$X\rV8qS\u000e\u0004v\u000e\\5ds~#S-\u001d\u000b\u0005\u0003c\u0014y\nC\u0005\u0002z.\n\t\u00111\u0001\u0003\u000e\u0006\u00112M]3bi\u0016$v\u000e]5d!>d\u0017nY=!\u0003E\tG\u000e^3s\u0007>tg-[4Q_2L7-_\u000b\u0003\u0005O\u0003RaSA\u0012\u0005S\u0003BA!%\u0003,&!!Q\u0016BJ\u0005E\tE\u000e^3s\u0007>tg-[4Q_2L7-_\u0001\u0016C2$XM]\"p]\u001aLw\rU8mS\u000eLx\fJ3r)\u0011\t\tPa-\t\u0013\u0005eh&!AA\u0002\t\u001d\u0016AE1mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5ds\u0002\n!bY8oiJ|G\u000e\\3s+\t\u0011Y\f\u0005\u0003\u0003>\n\u0005WB\u0001B`\u0015\r\u00119L^\u0005\u0005\u0005\u0007\u0014yL\u0001\u0006D_:$(o\u001c7mKJ\fabY8oiJ|G\u000e\\3s?\u0012*\u0017\u000f\u0006\u0003\u0002r\n%\u0007\"CA}c\u0005\u0005\t\u0019\u0001B^\u0003-\u0019wN\u001c;s_2dWM\u001d\u0011\u0002#M,\b\u000f]8si\u0016$g)Z1ukJ,7/\u0006\u0002\u0003RBA\u0011\u0011\u0006Bj\u0003O\u0011).\u0003\u0003\u0002^\u0005m\u0002\u0003BAJ\u0005/LAA!7\u0002\u0016\naa+\u001a:tS>t'+\u00198hK\u0006\u00112/\u001e9q_J$X\r\u001a$fCR,(/Z:!\u00035\tXo\u001c;b\u001b\u0006t\u0017mZ3sgV\u0011!\u0011\u001d\t\u0005\u0005G\u0014IO\u0004\u0003\u0002\\\n\u0015\u0018b\u0001Bt\t\u0006a\u0011+^8uC\u001a\u000b7\r^8ss&!!1\u001eBw\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0019!q\u001d#\u0002#E,x\u000e^1NC:\fw-\u001a:t?\u0012*\u0017\u000f\u0006\u0003\u0002r\nM\b\"CA}m\u0005\u0005\t\u0019\u0001Bq\u00039\tXo\u001c;b\u001b\u0006t\u0017mZ3sg\u0002\nabY8oiJ|G\u000e\\3s\u0003BL7/\u0006\u0002\u0003|B\u0019qL!@\n\u0007\t}HI\u0001\bD_:$(o\u001c7mKJ\f\u0005/[:\u0002%\r|g\u000e\u001e:pY2,'/\u00119jg~#S-\u001d\u000b\u0005\u0003c\u001c)\u0001C\u0005\u0002zf\n\t\u00111\u0001\u0003|\u0006y1m\u001c8ue>dG.\u001a:Ba&\u001c\b%A\rd_:$(o\u001c7mKJ\f\u0005/[:IC:$G.\u001a:Q_>dWCAB\u0007!\ry6qB\u0005\u0004\u0007#!%aF&bM.\f'+Z9vKN$\b*\u00198eY\u0016\u0014\bk\\8m\u0003u\u0019wN\u001c;s_2dWM]!qSND\u0015M\u001c3mKJ\u0004vn\u001c7`I\u0015\fH\u0003BAy\u0007/A\u0011\"!?=\u0003\u0003\u0005\ra!\u0004\u00025\r|g\u000e\u001e:pY2,'/\u00119jg\"\u000bg\u000e\u001a7feB{w\u000e\u001c\u0011\u0002#5\f\u0017PY3DQ\u0006tw-Z*uCR,8\u000f\u0006\u0004\u0004 \r\u00152\u0011\u0006\t\u0004\u0017\u000e\u0005\u0012bAB\u0012\u0019\n9!i\\8mK\u0006t\u0007bBB\u0014}\u0001\u0007\u0011q[\u0001\u0005MJ|W\u000eC\u0004\u0004,y\u0002\r!a6\u0002\u0005Q|\u0017!C2mkN$XM]%e+\t\t9#A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u0005E\u0018\u0001C:ikR$wn\u001e8\u0002\u001b\u0005<\u0018-\u001b;TQV$Hm\\<o\u0001")
public class ControllerServer
implements KafkaMetricsGroup {
    private final MetaProperties metaProperties;
    private final KafkaConfig config;
    private final RaftManager<ApiMessageAndVersion> raftManager;
    private final Time time;
    private final Metrics metrics;
    private final Option<String> threadNamePrefix;
    private final CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final KafkaConfigSchema configSchema;
    private final ReentrantLock lock;
    private final Condition awaitShutdownCond;
    private Server.ProcessStatus status;
    private LinuxIoMetricsCollector linuxIoMetricsCollector;
    private volatile Option<Authorizer> authorizer;
    private DelegationTokenCache tokenCache;
    private CredentialProvider credentialProvider;
    private SocketServer socketServer;
    private final CompletableFuture<Integer> socketServerFirstBoundPortFuture;
    private Option<CreateTopicPolicy> createTopicPolicy;
    private Option<AlterConfigPolicy> alterConfigPolicy;
    private Controller controller;
    private final scala.collection.immutable.Map<String, VersionRange> supportedFeatures;
    private QuotaFactory.QuotaManagers quotaManagers;
    private ControllerApis controllerApis;
    private KafkaRequestHandlerPool controllerApisHandlerPool;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public MetaProperties metaProperties() {
        return this.metaProperties;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public RaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public Time time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Option<String> threadNamePrefix() {
        return this.threadNamePrefix;
    }

    public CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public KafkaConfigSchema configSchema() {
        return this.configSchema;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public Condition awaitShutdownCond() {
        return this.awaitShutdownCond;
    }

    public Server.ProcessStatus status() {
        return this.status;
    }

    public void status_$eq(Server.ProcessStatus x$1) {
        this.status = x$1;
    }

    public LinuxIoMetricsCollector linuxIoMetricsCollector() {
        return this.linuxIoMetricsCollector;
    }

    public void linuxIoMetricsCollector_$eq(LinuxIoMetricsCollector x$1) {
        this.linuxIoMetricsCollector = x$1;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public void authorizer_$eq(Option<Authorizer> x$1) {
        this.authorizer = x$1;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public void tokenCache_$eq(DelegationTokenCache x$1) {
        this.tokenCache = x$1;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public void credentialProvider_$eq(CredentialProvider x$1) {
        this.credentialProvider = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public void socketServer_$eq(SocketServer x$1) {
        this.socketServer = x$1;
    }

    public CompletableFuture<Integer> socketServerFirstBoundPortFuture() {
        return this.socketServerFirstBoundPortFuture;
    }

    public Option<CreateTopicPolicy> createTopicPolicy() {
        return this.createTopicPolicy;
    }

    public void createTopicPolicy_$eq(Option<CreateTopicPolicy> x$1) {
        this.createTopicPolicy = x$1;
    }

    public Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public void alterConfigPolicy_$eq(Option<AlterConfigPolicy> x$1) {
        this.alterConfigPolicy = x$1;
    }

    public Controller controller() {
        return this.controller;
    }

    public void controller_$eq(Controller x$1) {
        this.controller = x$1;
    }

    public scala.collection.immutable.Map<String, VersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public void quotaManagers_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManagers = x$1;
    }

    public ControllerApis controllerApis() {
        return this.controllerApis;
    }

    public void controllerApis_$eq(ControllerApis x$1) {
        this.controllerApis = x$1;
    }

    public KafkaRequestHandlerPool controllerApisHandlerPool() {
        return this.controllerApisHandlerPool;
    }

    public void controllerApisHandlerPool_$eq(KafkaRequestHandlerPool x$1) {
        this.controllerApisHandlerPool = x$1;
    }

    private boolean maybeChangeStatus(Server.ProcessStatus from, Server.ProcessStatus to) {
        block8: {
            boolean bl;
            block7: {
                this.lock().lock();
                try {
                    Server.ProcessStatus processStatus = this.status();
                    if (processStatus == null ? from != null : !processStatus.equals(from)) {
                        bl = false;
                        break block7;
                    }
                    this.status_$eq(to);
                    Server.ProcessStatus processStatus2 = to;
                    Server$SHUTDOWN$ server$SHUTDOWN$ = Server$SHUTDOWN$.MODULE$;
                    if (processStatus2 == null) {
                    } else if (processStatus2.equals(server$SHUTDOWN$)) {
                        this.awaitShutdownCond().signalAll();
                    }
                    break block8;
                }
                finally {
                    this.lock().unlock();
                }
            }
            return bl;
        }
        return true;
    }

    public String clusterId() {
        return this.metaProperties().clusterId();
    }

    public void startup() {
        if (!this.maybeChangeStatus(Server$SHUTDOWN$.MODULE$, Server$STARTING$.MODULE$)) {
            return;
        }
        try {
            Authorizer a;
            scala.collection.immutable.Map map;
            this.info((Function0<String>)(Function0 & Serializable)() -> "Starting controller");
            this.maybeChangeStatus(Server$STARTING$.MODULE$, Server$STARTED$.MODULE$);
            this.logIdent_$eq(new LogContext(new StringBuilder(23).append("[ControllerServer id=").append(this.config().nodeId()).append("] ").toString()).logPrefix());
            this.newGauge("ClusterId", new Gauge<String>(this){
                private final /* synthetic */ ControllerServer $outer;

                public final String value() {
                    ControllerServer controllerServer = this.$outer;
                    if (controllerServer == null) {
                        throw null;
                    }
                    return controllerServer.clusterId();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.newGauge$default$3());
            this.newGauge("yammer-metrics-count", new Gauge<Object>(this){
                private final /* synthetic */ ControllerServer $outer;

                public final int value() {
                    return ControllerServer.kafka$server$ControllerServer$$$anonfun$startup$4();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.newGauge$default$3());
            this.linuxIoMetricsCollector_$eq(new LinuxIoMetricsCollector("/proc", this.time(), this.logger().underlying()));
            if (this.linuxIoMetricsCollector().usable()) {
                this.newGauge("linux-disk-read-bytes", new Gauge<Object>(this){
                    private final /* synthetic */ ControllerServer $outer;

                    public final long value() {
                        return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$6();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.newGauge$default$3());
                this.newGauge("linux-disk-write-bytes", new Gauge<Object>(this){
                    private final /* synthetic */ ControllerServer $outer;

                    public final long value() {
                        return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$8();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.newGauge$default$3());
            }
            List javaListeners = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.config().controllerListeners().map((Function1 & Serializable)x$1 -> x$1.toJava())).asJava();
            this.authorizer_$eq(this.config().authorizer());
            this.authorizer().foreach((Function1 & Serializable)x$2 -> {
                x$2.configure(this.config().originals());
                return BoxedUnit.UNIT;
            });
            Option<Authorizer> option = this.authorizer();
            if (option instanceof Some) {
                Authorizer authZ = (Authorizer)((Some)option).value();
                Broker.ServerInfo controllerAuthorizerInfo = new Broker.ServerInfo(new ClusterResource(this.clusterId()), this.config().nodeId(), javaListeners, (Endpoint)javaListeners.get(0));
                map = CollectionConverters$.MODULE$.MapHasAsScala(authZ.start((AuthorizerServerInfo)controllerAuthorizerInfo)).asScala().map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    Endpoint ep = (Endpoint)x0$1._1();
                    CompletionStage cs = (CompletionStage)x0$1._2();
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ep), cs.toCompletableFuture());
                    return tuple2;
                }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            } else if (None$.MODULE$.equals(option)) {
                map = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(javaListeners).asScala().map((Function1 & Serializable)ep -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ep), CompletableFuture.completedFuture(null)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            } else {
                throw new MatchError(option);
            }
            SimpleApiVersionManager apiVersionManager = new SimpleApiVersionManager(ApiMessageType.ListenerType.CONTROLLER);
            this.tokenCache_$eq(new DelegationTokenCache(ScramMechanism.mechanismNames()));
            this.credentialProvider_$eq(new CredentialProvider(ScramMechanism.mechanismNames(), this.tokenCache()));
            this.socketServer_$eq(new SocketServer(this.config(), this.metrics(), this.time(), this.credentialProvider(), apiVersionManager));
            this.socketServer().startup(false, (Option<EndPoint>)None$.MODULE$, this.config().controllerListeners());
            if (!this.config().controllerListeners().nonEmpty()) {
                throw new ConfigException("No controller.listener.names defined for controller");
            }
            this.socketServerFirstBoundPortFuture().complete(Predef$.MODULE$.int2Integer(this.socketServer().boundPort(((EndPoint)this.config().controllerListeners().head()).listenerName())));
            String threadNamePrefixAsString = (String)this.threadNamePrefix().getOrElse((Function0 & Serializable)() -> "");
            this.createTopicPolicy_$eq((Option<CreateTopicPolicy>)Option$.MODULE$.apply(this.config().getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class)));
            this.alterConfigPolicy_$eq((Option<AlterConfigPolicy>)Option$.MODULE$.apply(this.config().getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class)));
            OptionalLong leaderImbalanceCheckIntervalNs = Predef$.MODULE$.Boolean2boolean(this.config().autoLeaderRebalanceEnable()) ? OptionalLong.of(TimeUnit.NANOSECONDS.convert(this.config().leaderImbalanceCheckIntervalSeconds(), TimeUnit.SECONDS)) : OptionalLong.empty();
            QuorumController.Builder controllerBuilder = new QuorumController.Builder(this.config().nodeId(), this.metaProperties().clusterId()).setTime(this.time()).setThreadNamePrefix(threadNamePrefixAsString).setConfigSchema(this.configSchema()).setRaftClient(this.raftManager().client()).setDefaultReplicationFactor((short)this.config().defaultReplicationFactor()).setDefaultNumPartitions(this.config().numPartitions().intValue()).setIsLeaderRecoverySupported(this.config().interBrokerProtocolVersion().$greater$eq(KAFKA_3_2_IV0$.MODULE$)).setSessionTimeoutNs(TimeUnit.NANOSECONDS.convert(this.config().brokerSessionTimeoutMs(), TimeUnit.MILLISECONDS)).setSnapshotMaxNewRecordBytes(Predef$.MODULE$.Long2long(this.config().metadataSnapshotMaxNewRecordBytes())).setLeaderImbalanceCheckIntervalNs(leaderImbalanceCheckIntervalNs).setMetrics((ControllerMetrics)new QuorumControllerMetrics(KafkaYammerMetrics.defaultRegistry())).setCreateTopicPolicy(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.createTopicPolicy()))).setAlterConfigPolicy(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.alterConfigPolicy()))).setConfigurationValidator((ConfigurationValidator)new ControllerConfigurationValidator());
            Option<Authorizer> option2 = this.authorizer();
            if (option2 instanceof Some && (a = (Authorizer)((Some)option2).value()) instanceof ClusterMetadataAuthorizer) {
                ClusterMetadataAuthorizer clusterMetadataAuthorizer = (ClusterMetadataAuthorizer)a;
                controllerBuilder.setAuthorizer(clusterMetadataAuthorizer);
            }
            this.controller_$eq((Controller)controllerBuilder.build());
            this.quotaManagers_$eq(QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), this.time(), (String)this.threadNamePrefix().getOrElse((Function0 & Serializable)() -> "")));
            Buffer controllerNodes = CollectionConverters$.MODULE$.ListHasAsScala(RaftConfig.voterConnectionsToNodes(this.controllerQuorumVotersFuture().get())).asScala();
            this.controllerApis_$eq(new ControllerApis(this.socketServer().dataPlaneRequestChannel(), this.authorizer(), this.quotaManagers(), this.time(), this.supportedFeatures(), this.controller(), this.raftManager(), this.config(), this.metaProperties(), (scala.collection.immutable.Seq<Node>)controllerNodes.toSeq(), apiVersionManager));
            this.controllerApisHandlerPool_$eq(new KafkaRequestHandlerPool(this.config().nodeId(), this.socketServer().dataPlaneRequestChannel(), this.controllerApis(), this.time(), Predef$.MODULE$.Integer2int(this.config().numIoThreads()), new StringBuilder(28).append(DataPlaneAcceptor$.MODULE$.MetricPrefix()).append("RequestHandlerAvgIdlePercent").toString(), DataPlaneAcceptor$.MODULE$.ThreadPrefix()));
            this.socketServer().startProcessingRequests((Map<Endpoint, CompletableFuture<Void>>)map);
            return;
        }
        catch (Throwable e) {
            this.maybeChangeStatus(Server$STARTING$.MODULE$, Server$STARTED$.MODULE$);
            this.fatal((Function0<String>)(Function0 & Serializable)() -> "Fatal error during controller startup. Prepare to shutdown", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.shutdown();
            throw e;
        }
    }

    public void shutdown() {
        if (!this.maybeChangeStatus(Server$STARTED$.MODULE$, Server$SHUTTING_DOWN$.MODULE$)) {
            return;
        }
        try {
            try {
                this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
                if (this.socketServer() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.socketServer().stopProcessingRequests(), this, Level.WARN);
                }
                if (this.controller() != null) {
                    this.controller().beginShutdown();
                }
                if (this.socketServer() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.socketServer().shutdown(), this, Level.WARN);
                }
                if (this.controllerApisHandlerPool() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.controllerApisHandlerPool().shutdown(), this, Level.WARN);
                }
                if (this.controllerApis() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.controllerApis().close(), this, Level.WARN);
                }
                if (this.quotaManagers() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.quotaManagers().shutdown(), this, Level.WARN);
                }
                if (this.controller() != null) {
                    this.controller().close();
                }
                this.createTopicPolicy().foreach((Function1 & Serializable)policy -> {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> policy.close(), this, Level.WARN);
                    return BoxedUnit.UNIT;
                });
                this.alterConfigPolicy().foreach((Function1 & Serializable)policy -> {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> policy.close(), this, Level.WARN);
                    return BoxedUnit.UNIT;
                });
                this.socketServerFirstBoundPortFuture().completeExceptionally(new RuntimeException("shutting down"));
            }
            catch (Throwable e) {
                this.fatal((Function0<String>)(Function0 & Serializable)() -> "Fatal error during controller shutdown.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        }
        finally {
            this.maybeChangeStatus(Server$SHUTTING_DOWN$.MODULE$, Server$SHUTDOWN$.MODULE$);
        }
    }

    public void awaitShutdown() {
        this.lock().lock();
        try {
            while (true) {
                Server.ProcessStatus processStatus = this.status();
                Server$SHUTDOWN$ server$SHUTDOWN$ = Server$SHUTDOWN$.MODULE$;
                if (processStatus == null || !processStatus.equals(server$SHUTDOWN$)) {
                    this.awaitShutdownCond().awaitUninterruptibly();
                    continue;
                }
                break;
            }
        }
        finally {
            this.lock().unlock();
        }
    }

    public final /* synthetic */ String kafka$server$ControllerServer$$$anonfun$startup$2() {
        return this.clusterId();
    }

    public static final /* synthetic */ int kafka$server$ControllerServer$$$anonfun$startup$4() {
        return KafkaYammerMetrics.defaultRegistry().allMetrics().size();
    }

    public final /* synthetic */ long kafka$server$ControllerServer$$$anonfun$startup$6() {
        return this.linuxIoMetricsCollector().readBytes();
    }

    public final /* synthetic */ long kafka$server$ControllerServer$$$anonfun$startup$8() {
        return this.linuxIoMetricsCollector().writeBytes();
    }

    public ControllerServer(MetaProperties metaProperties, KafkaConfig config, RaftManager<ApiMessageAndVersion> raftManager, Time time, Metrics metrics, Option<String> threadNamePrefix, CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, KafkaConfigSchema configSchema) {
        this.metaProperties = metaProperties;
        this.config = config;
        this.raftManager = raftManager;
        this.time = time;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.configSchema = configSchema;
        this.lock = new ReentrantLock();
        this.awaitShutdownCond = this.lock().newCondition();
        this.status = Server$SHUTDOWN$.MODULE$;
        this.linuxIoMetricsCollector = null;
        this.authorizer = null;
        this.tokenCache = null;
        this.credentialProvider = null;
        this.socketServer = null;
        this.socketServerFirstBoundPortFuture = new CompletableFuture();
        this.createTopicPolicy = None$.MODULE$;
        this.alterConfigPolicy = None$.MODULE$;
        this.controller = null;
        this.supportedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.quotaManagers = null;
        this.controllerApis = null;
        this.controllerApisHandlerPool = null;
    }
}

