/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerContext;
import kafka.controller.StateChangeLogger;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.VolatileObjectRef;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0005\t\u001da\u0001\u0002\u0011\"\u0001\u0019BQ!\f\u0001\u0005\u00029Bq!\r\u0001C\u0002\u0013\u0005!\u0007\u0003\u0004<\u0001\u0001\u0006Ia\r\u0005\by\u0001\u0011\r\u0011\"\u00013\u0011\u0019i\u0004\u0001)A\u0005g!9a\b\u0001b\u0001\n\u0003y\u0004B\u0002&\u0001A\u0003%\u0001\tC\u0004L\u0001\t\u0007I\u0011A \t\r1\u0003\u0001\u0015!\u0003A\u0011\u001di\u0005A1A\u0005\u00029Ca!\u0016\u0001!\u0002\u0013y\u0005b\u0002,\u0001\u0001\u0004%\ta\u0016\u0005\b?\u0002\u0001\r\u0011\"\u0001a\u0011\u00191\u0007\u0001)Q\u00051\")q\r\u0001C!Q\")Q\u000e\u0001C!]\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003'\u0002A\u0011AA+\u0011\u001d\ty\u0006\u0001C\u0001\u0003CBq!a\u001b\u0001\t\u0003\ti\u0007C\u0004\u0002x\u0001!I!!\u001f\t\u0011\u0005M\u0006\u0001)C\u0005\u0003kCq!a2\u0001\t\u0003\tI\rC\u0004\u0002L\u0002!\t!!4\t\u000f\u0005]\u0007\u0001\"\u0001\u0002J\"9\u0011\u0011\u001d\u0001\u0005\n\u0005\r\bbBAs\u0001\u0011%\u0011q\u001d\u0005\b\u0003_\u0004A\u0011BAe\u0011\u001d\t\t\u0010\u0001C\u0005\u0003\u0013Dq!a=\u0001\t\u0013\t)P\u0001\nTKJ4XM]*ikR$wn\u001e8UKN$(B\u0001\u0012$\u0003\u0019\u0019XM\u001d<fe*\tA%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00019\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016$\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u00051J#AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005y\u0003C\u0001\u0019\u0001\u001b\u0005\t\u0013\u0001\u00025pgR,\u0012a\r\t\u0003iej\u0011!\u000e\u0006\u0003m]\nA\u0001\\1oO*\t\u0001(\u0001\u0003kCZ\f\u0017B\u0001\u001e6\u0005\u0019\u0019FO]5oO\u0006)\u0001n\\:uA\u0005)Ao\u001c9jG\u00061Ao\u001c9jG\u0002\nQa]3oiF*\u0012\u0001\u0011\t\u0004\u0003\"\u001bT\"\u0001\"\u000b\u0005\r#\u0015!C5n[V$\u0018M\u00197f\u0015\t)e)\u0001\u0006d_2dWm\u0019;j_:T\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\n\u0013A\u0001T5ti\u000611/\u001a8uc\u0001\nQa]3oiJ\naa]3oiJ\u0002\u0013\u0001\u00079s_B\u001cHk\\\"iC:<W-\u00169p]J+7\u000f^1siV\tq\n\u0005\u0002Q'6\t\u0011K\u0003\u0002So\u0005!Q\u000f^5m\u0013\t!\u0016K\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0011\u0004\u001d:paN$vn\u00115b]\u001e,W\u000b]8o%\u0016\u001cH/\u0019:uA\u0005Y\u0001O]5pe\u000e{gNZ5h+\u0005A\u0006cA-[96\ta)\u0003\u0002\\\r\n1q\n\u001d;j_:\u0004\"\u0001M/\n\u0005y\u000b#aC&bM.\f7i\u001c8gS\u001e\fq\u0002\u001d:j_J\u001cuN\u001c4jO~#S-\u001d\u000b\u0003C\u0012\u0004\"!\u00172\n\u0005\r4%\u0001B+oSRDq!Z\u0007\u0002\u0002\u0003\u0007\u0001,A\u0002yIE\nA\u0002\u001d:j_J\u001cuN\u001c4jO\u0002\nqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002SB\u0019!n\u001b/\u000e\u0003\u0011K!\u0001\u001c#\u0003\u0007M+\u0017/A\u0003tKR,\u0006\u000f\u0006\u0002b_\")\u0001\u000f\u0005a\u0001c\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002sw6\t1O\u0003\u0002uk\u0006\u0019\u0011\r]5\u000b\u0005Y<\u0018a\u00026va&$XM\u001d\u0006\u0003qf\fQA[;oSRT\u0011A_\u0001\u0004_J<\u0017B\u0001?t\u0005!!Vm\u001d;J]\u001a|\u0007F\u0001\t\u007f!\t\u0011x0C\u0002\u0002\u0002M\u0014!BQ3g_J,W)Y2i\u0003E!Xm\u001d;DY\u0016\fgn\u00155vi\u0012|wO\u001c\u000b\u0004C\u0006\u001d\u0001bBA\u0005#\u0001\u0007\u00111B\u0001\u0007cV|'/^7\u0011\t\u00055\u00111\u0004\b\u0005\u0003\u001f\t9\u0002E\u0002\u0002\u0012\u0019k!!a\u0005\u000b\u0007\u0005UQ%\u0001\u0004=e>|GOP\u0005\u0004\u000331\u0015A\u0002)sK\u0012,g-C\u0002;\u0003;Q1!!\u0007GQ\u001d\t\u0012\u0011EA\u0019\u0003g\u0001B!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0005qe>4\u0018\u000eZ3s\u0015\r\tY#^\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005=\u0012Q\u0005\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u0005U\u0012\u0011H\u0011\u0003\u0003o\t!A_6\"\u0005\u0005m\u0012!B6sC\u001a$\bfA\t\u0002@A!\u0011\u0011IA\"\u001b\t\tI#\u0003\u0003\u0002F\u0005%\"!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006\u0019C/Z:u\u00072,\u0017M\\*ikR$wn\u001e8BMR,'OR1jY\u0016$7\u000b^1siV\u0004HcA1\u0002L!9\u0011\u0011\u0002\nA\u0002\u0005-\u0001f\u0002\n\u0002\"\u0005E\u0012q\n\u0017\u0005\u0003k\tI\u0004K\u0002\u0013\u0003\u007f\tQ\u0007^3ti:{7\t\\3b]NCW\u000f\u001e3po:\fe\r^3s\r\u0006LG.\u001a3Ti\u0006\u0014H/\u001e9Ek\u0016$vnQ8seV\u0004H\u000fT8hgR\u0019\u0011-a\u0016\t\u000f\u0005%1\u00031\u0001\u0002\f!:1#!\t\u00022\u0005mC\u0006BA\u001b\u0003sA3aEA \u0003\t\"Xm\u001d;DY\u0016\fgn\u00155vi\u0012|wO\\,ji\"T6.\u00168bm\u0006LG.\u00192mKR\u0019\u0011-a\u0019\t\u000f\u0005%A\u00031\u0001\u0002\f!:A#!\t\u00022\u0005\u001dDFAA\u001bQ\r!\u0012qH\u00010i\u0016\u001cHo\u00117fC:\u001c\u0006.\u001e;e_^tw+\u001b;i\u0017J\u000bg\r^\"p]R\u0014x\u000e\u001c7feVs\u0017M^1jY\u0006\u0014G.\u001a\u000b\u0004C\u0006=\u0004bBA\u0005+\u0001\u0007\u00111\u0002\u0015\b+\u0005\u0005\u0012\u0011GA:Y\t\tI\u0004K\u0002\u0016\u0003\u007f\tQE^3sS\u001aL8\t\\3b]NCW\u000f\u001e3po:\fe\r^3s\r\u0006LG.\u001a3Ti\u0006\u0014H/\u001e9\u0016\t\u0005m\u00141\u0013\u000b\u0005\u0003{\n\t\fF\u0002b\u0003\u007fBq!!!\u0017\u0001\b\t\u0019)A\tfq\u000e,\u0007\u000f^5p]\u000ec\u0017m]:UC\u001e\u0004b!!\"\u0002\f\u0006=UBAAD\u0015\r\tIIR\u0001\be\u00164G.Z2u\u0013\u0011\ti)a\"\u0003\u0011\rc\u0017m]:UC\u001e\u0004B!!%\u0002\u00142\u0001AaBAK-\t\u0007\u0011q\u0013\u0002\u0002\u000bF!\u0011\u0011TAP!\rI\u00161T\u0005\u0004\u0003;3%a\u0002(pi\"Lgn\u001a\t\u0005\u0003C\u000bYK\u0004\u0003\u0002$\u0006\u001df\u0002BA\t\u0003KK\u0011aR\u0005\u0004\u0003S3\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003[\u000byKA\u0005Fq\u000e,\u0007\u000f^5p]*\u0019\u0011\u0011\u0016$\t\u000f\u0005%a\u00031\u0001\u0002\f\u00051\u0012n\u001d(p]\u0012\u000bW-\\8o\u0017\u000647.\u0019+ie\u0016\fG\r\u0006\u0003\u00028\u0006u\u0006cA-\u0002:&\u0019\u00111\u0018$\u0003\u000f\t{w\u000e\\3b]\"9\u0011qX\fA\u0002\u0005\u0005\u0017!\u0001;\u0011\u0007Q\n\u0019-C\u0002\u0002FV\u0012a\u0001\u00165sK\u0006$\u0017\u0001\b<fe&4\u0017PT8o\t\u0006,Wn\u001c8UQJ,\u0017\rZ:Ti\u0006$Xo\u001d\u000b\u0002C\u00069B/Z:u\u0007>t7/Z2vi&4Xm\u00155vi\u0012|wO\u001c\u000b\u0004C\u0006=\u0007bBA\u00053\u0001\u0007\u00111\u0002\u0015\b3\u0005\u0005\u0012\u0011GAjY\u0011\t)$!\u000f)\u0007e\ty$\u0001\u0011uKN$8i\u001c8ue>dG.\u001a:TQV$Hm\\<o\tV\u0014\u0018N\\4TK:$\u0007f\u0001\u000e\u0002\\B\u0019!/!8\n\u0007\u0005}7O\u0001\u0003UKN$\u0018AB2p]\u001aLw-F\u0001]\u0003\u0019\u0011'o\\6feV\u0011\u0011\u0011\u001e\t\u0004a\u0005-\u0018bAAwC\tY1*\u00194lC\n\u0013xn[3s\u00039\u0019\b.\u001e;e_^t'I]8lKJ\fQB]3ti\u0006\u0014HO\u0011:pW\u0016\u0014\u0018A\u0004:fGJ,\u0017\r^3Ce>\\WM\u001d\u000b\u0004C\u0006]\bbBA}?\u0001\u0007\u0011qW\u0001\bgR\f'\u000f^;qQ\u001d\u0001\u0011Q B\u0002\u0005\u000b\u00012A]A\u0000\u0013\r\u0011\ta\u001d\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\u0005a\u0004")
public class ServerShutdownTest
extends KafkaServerTestHarness {
    private final String host;
    private final String topic;
    private final List<String> sent1 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
    private final List<String> sent2 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"more", "messages"}));
    private final Properties propsToChangeUponRestart = new Properties();
    private Option<KafkaConfig> priorConfig = None$.MODULE$;

    public String host() {
        return this.host;
    }

    public String topic() {
        return this.topic;
    }

    public List<String> sent1() {
        return this.sent1;
    }

    public List<String> sent2() {
        return this.sent2;
    }

    public Properties propsToChangeUponRestart() {
        return this.propsToChangeUponRestart;
    }

    public Option<KafkaConfig> priorConfig() {
        return this.priorConfig;
    }

    public void priorConfig_$eq(Option<KafkaConfig> x$1) {
        this.priorConfig = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        this.priorConfig().foreach((Function1 & Serializable)config -> {
            java.util.Map originals = config.originals();
            Object logDirsValue = originals.get(KafkaConfig$.MODULE$.LogDirsProp());
            if (logDirsValue != null) {
                return this.propsToChangeUponRestart().put(KafkaConfig$.MODULE$.LogDirsProp(), logDirsValue);
            }
            return this.propsToChangeUponRestart().put(KafkaConfig$.MODULE$.LogDirProp(), originals.get(KafkaConfig$.MODULE$.LogDirProp()));
        });
        this.priorConfig_$eq((Option<KafkaConfig>)new Some((Object)KafkaConfig$.MODULE$.fromProps((Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).head(), this.propsToChangeUponRestart(), true)));
        return new .colon.colon((Object)((KafkaConfig)this.priorConfig().get()), (List)Nil$.MODULE$);
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.priorConfig_$eq((Option<KafkaConfig>)None$.MODULE$);
        this.propsToChangeUponRestart().clear();
        super.setUp(testInfo);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdown(String quorum) {
        ObjectRef producer = ObjectRef.create((Object)this.createProducer$1());
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sent1().map((Function1 & Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value))).foreach((Function1 & Serializable)x$1 -> (RecordMetadata)x$1.get());
        this.killBroker(0);
        this.config().logDirs().foreach((Function1 & Serializable)logDir -> {
            ServerShutdownTest.$anonfun$testCleanShutdown$3(logDir);
            return BoxedUnit.UNIT;
        });
        ((KafkaProducer)producer.elem).close();
        this.restartBroker();
        TestUtils$.MODULE$.waitForPartitionMetadata(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), this.topic(), 0, 15000L);
        producer.elem = this.createProducer$1();
        KafkaConsumer consumer = this.createConsumer$1();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        Seq consumerRecords = TestUtils$.MODULE$.consumeRecords(consumer, this.sent1().size(), 15000L);
        Assertions.assertEquals(this.sent1(), (Object)consumerRecords.map((Function1 & Serializable)x$2 -> (String)x$2.value()));
        this.sent2().map((Function1 & Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value))).foreach((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get());
        Seq consumerRecords2 = TestUtils$.MODULE$.consumeRecords(consumer, this.sent2().size(), 15000L);
        Assertions.assertEquals(this.sent2(), (Object)consumerRecords2.map((Function1 & Serializable)x$4 -> (String)x$4.value()));
        consumer.close();
        ((KafkaProducer)producer.elem).close();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdownAfterFailedStartup(String quorum) {
        String string = quorum;
        String string2 = "zk";
        if (string != null && string.equals(string2)) {
            this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "50");
            this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "some.invalid.hostname.foo.bar.local:65535");
            this.verifyCleanShutdownAfterFailedStartup(quorum, ClassTag$.MODULE$.apply(ZooKeeperClientTimeoutException.class));
            return;
        }
        this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.InitialBrokerRegistrationTimeoutMsProp(), "1000");
        this.killBroker(0);
        this.shutdownKRaftController();
        this.verifyCleanShutdownAfterFailedStartup(quorum, ClassTag$.MODULE$.apply(CancellationException.class));
    }

    /*
     * Unable to fully structure code
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testNoCleanShutdownAfterFailedStartupDueToCorruptLogs(String quorum) {
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        this.killBroker(0);
        this.config().logDirs().foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1$adapted(kafka.server.ServerShutdownTest java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((ServerShutdownTest)this));
        expectedStatusCode = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        receivedStatusCode = VolatileObjectRef.create((Object)Option$.MODULE$.empty());
        hasHaltProcedureCalled = VolatileBooleanRef.create((boolean)false);
        setHaltProcedure_haltProcedure = (Function2 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3$adapted(scala.runtime.VolatileBooleanRef scala.runtime.VolatileObjectRef java.lang.Object scala.Option ), (Ljava/lang/Object;Lscala/Option;)Lscala/runtime/Nothing$;)((VolatileBooleanRef)hasHaltProcedureCalled, (VolatileObjectRef)receivedStatusCode);
        Exit.setHaltProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        var6_5 = null;
        try {
            Assertions.assertDoesNotThrow((Executable)(Executable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$4(kafka.server.ServerShutdownTest ), ()V)((ServerShutdownTest)this));
            var9_6 = 15000L;
            var11_7 = 100L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if (!hasHaltProcedureCalled.elem) ** GOTO lbl-1000
                v0 = expectedStatusCode;
                var13_9 = (Option)receivedStatusCode.elem;
                if (!(v0 != null ? v0.equals(var13_9) == false : var13_9 != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                var13_9 = null;
                if (!v1) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + var9_6) {
                        Assertions.fail((String)new StringBuilder(0).append(new StringBuilder(58).append("Expected to halt directly with the expected status code:").append(expectedStatusCode.get()).append(", ").toString()).append(new StringBuilder(59).append("but got hasHaltProcedureCalled: ").append(hasHaltProcedureCalled.elem).append(" and received status code: ").append(((Option)receivedStatusCode.elem).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).toString()).toString());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(var9_6), var11_7));
                    continue;
                }
                break;
            }
        }
        finally {
            Exit.resetHaltProcedure();
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testCleanShutdownWithZkUnavailable(String quorum) {
        this.shutdownZooKeeper();
        this.killBroker(0);
        CoreUtils$.MODULE$.delete(this.broker().config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCleanShutdownWithKRaftControllerUnavailable(String quorum) {
        this.shutdownKRaftController();
        this.killBroker(0);
        CoreUtils$.MODULE$.delete(this.broker().config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    private <E extends Exception> void verifyCleanShutdownAfterFailedStartup(String quorum, ClassTag<E> exceptionClassTag) {
        try {
            try {
                this.recreateBroker(true);
                Assertions.fail((String)"Expected KafkaServer setup to fail and throw exception");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)exceptionClassTag.runtimeClass().isInstance(e), (String)new StringBuilder(21).append("Unexpected exception ").append(e).toString());
                String string = quorum;
                String string2 = "zk";
                Assertions.assertEquals((Object)(string != null && string.equals(string2) ? BrokerState.NOT_RUNNING : BrokerState.SHUTTING_DOWN), (Object)((KafkaBroker)this.brokers().head()).brokerState());
            }
        }
        finally {
            this.killBroker(0);
        }
    }

    private boolean isNonDaemonKafkaThread(Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(this.getClass().getName());
    }

    public void verifyNonDaemonThreadsStatus() {
        Assertions.assertEquals((int)0, (int)ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(Thread.getAllStackTraces().keySet().toArray()), (Function1 & Serializable)x$6 -> (Thread)x$6, ClassTag$.MODULE$.apply(Thread.class))), (Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)this.isNonDaemonKafkaThread(t))));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testConsecutiveShutdown(String quorum) {
        this.killBroker(0);
        ((KafkaBroker)this.brokers().head()).shutdown();
    }

    @Test
    public void testControllerShutdownDuringSend() {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        int controllerId = 2;
        Metrics metrics = new Metrics();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ObjectRef serverSocket = ObjectRef.create(null);
        ObjectRef controllerChannelManager = ObjectRef.create(null);
        try {
            serverSocket.elem = new ServerSocket(0);
            Future<?> receiveFuture = executor.submit(new Runnable(null, serverSocket){
                private final ObjectRef serverSocket$1;

                public void run() {
                    Socket socket = ((ServerSocket)this.serverSocket$1.elem).accept();
                    new DataInputStream(socket.getInputStream()).readByte();
                }
                {
                    this.serverSocket$1 = serverSocket$1;
                }
            });
            scala.collection.immutable.Map brokerAndEpochs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Broker(1, "localhost", ((ServerSocket)serverSocket.elem).getLocalPort(), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)0L))}));
            KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
            ControllerContext controllerContext = new ControllerContext();
            controllerContext.setLiveBrokers((Map)brokerAndEpochs);
            controllerChannelManager.elem = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), (Option)None$.MODULE$);
            ((ControllerChannelManager)controllerChannelManager.elem).startup();
            LeaderAndIsrRequest.Builder requestBuilder = new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, 1, 0L, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), Collections.singletonMap(this.topic(), Uuid.randomUuid()), (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)((IterableOnceOps)brokerAndEpochs.keys().map((Function1 & Serializable)x$7 -> x$7.node(listenerName))).toSet()).asJava());
            ControllerChannelManager qual$1 = (ControllerChannelManager)controllerChannelManager.elem;
            Function1 x$3 = qual$1.sendRequest$default$3();
            qual$1.sendRequest(1, (AbstractControlRequest.Builder)requestBuilder, x$3);
            receiveFuture.get(10L, TimeUnit.SECONDS);
            executor.submit(new Runnable(null, controllerChannelManager){
                private final ObjectRef controllerChannelManager$1;

                public void run() {
                    ((ControllerChannelManager)this.controllerChannelManager$1.elem).shutdown();
                }
                {
                    this.controllerChannelManager$1 = controllerChannelManager$1;
                }
            }).get(10L, TimeUnit.SECONDS);
        }
        finally {
            if ((ServerSocket)serverSocket.elem != null) {
                ((ServerSocket)serverSocket.elem).close();
            }
            if ((ControllerChannelManager)controllerChannelManager.elem != null) {
                ((ControllerChannelManager)controllerChannelManager.elem).shutdown();
            }
            executor.shutdownNow();
            metrics.close();
        }
    }

    private KafkaConfig config() {
        return (KafkaConfig)this.configs().head();
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private void shutdownBroker() {
        this.killBroker(0);
    }

    private void restartBroker() {
        this.killBroker(0);
        this.restartDeadBrokers(!this.propsToChangeUponRestart().isEmpty());
    }

    private void recreateBroker(boolean startup) {
        this.recreateBrokers(!this.propsToChangeUponRestart().isEmpty(), startup);
    }

    private final KafkaProducer createProducer$1() {
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        IntegerSerializer x$2 = new IntegerSerializer();
        StringSerializer x$3 = new StringSerializer();
        int n = -1;
        long l = 60000L;
        long l2 = 0x100000L;
        int n2 = Integer.MAX_VALUE;
        int n3 = 30000;
        int n4 = 0;
        int n5 = 16384;
        String string2 = string = "none";
        string = null;
        String x$11 = string2;
        int n6 = 20000;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$13 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$14 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$15 = none$4;
        boolean bl = false;
        return TestUtils$.MODULE$.createProducer(x$1, n, l, l2, n2, n3, n4, n5, x$11, n6, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$2, x$3, bl);
    }

    private final KafkaConsumer createConsumer$1() {
        None$ none$;
        None$ none$2;
        String string;
        String string2;
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        IntegerDeserializer x$3 = new IntegerDeserializer();
        StringDeserializer x$4 = new StringDeserializer();
        String string3 = string2 = "group";
        string2 = null;
        String x$5 = string3;
        String string4 = string = "earliest";
        string = null;
        String x$6 = string4;
        boolean bl = true;
        boolean bl2 = false;
        int n = 500;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$10 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$11 = none$4;
        return TestUtils$.MODULE$.createConsumer(x$1, x$5, x$6, bl, bl2, n, SecurityProtocol.PLAINTEXT, (Option<File>)x$10, (Option<Properties>)x$11, x$3, x$4);
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdown$3(String logDir) {
        File OffsetCheckpointFile2 = new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile());
        Assertions.assertTrue((boolean)OffsetCheckpointFile2.exists());
        Assertions.assertTrue((OffsetCheckpointFile2.length() > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1(ServerShutdownTest $this, String dirName) {
        File partitionDir = new File(dirName, new StringBuilder(2).append($this.topic()).append("-0").toString());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])partitionDir.listFiles()), (Function1 & Serializable)f -> {
            TestUtils$.MODULE$.appendNonsenseToFile(f, TestUtils$.MODULE$.random().nextInt(1024) + 1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Nothing$ $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3(VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1, int statusCode, Option x$5) {
        hasHaltProcedureCalled$1.elem = true;
        receivedStatusCode$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
        return (Nothing$)BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$4(ServerShutdownTest $this) {
        $this.recreateBroker(true);
    }

    public static final /* synthetic */ boolean $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$5(VolatileBooleanRef hasHaltProcedureCalled$1, Some expectedStatusCode$1, VolatileObjectRef receivedStatusCode$1) {
        if (hasHaltProcedureCalled$1.elem) {
            Some some = expectedStatusCode$1;
            Option option = (Option)receivedStatusCode$1.elem;
            if (!(some != null ? !some.equals(option) : option != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$6(Some expectedStatusCode$1, VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1) {
        return new StringBuilder(0).append(new StringBuilder(58).append("Expected to halt directly with the expected status code:").append(expectedStatusCode$1.get()).append(", ").toString()).append(new StringBuilder(59).append("but got hasHaltProcedureCalled: ").append(hasHaltProcedureCalled$1.elem).append(" and received status code: ").append(((Option)receivedStatusCode$1.elem).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).toString()).toString();
    }

    public ServerShutdownTest() {
        this.host = "localhost";
        this.topic = "test";
    }

    public static final /* synthetic */ Object $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1$adapted(ServerShutdownTest $this, String dirName) {
        ServerShutdownTest.$anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1($this, dirName);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Nothing$ $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3$adapted(VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1, Object statusCode, Option x$5) {
        return ServerShutdownTest.$anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3(hasHaltProcedureCalled$1, receivedStatusCode$1, BoxesRunTime.unboxToInt((Object)statusCode), x$5);
    }
}

