/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.ConfigAdminManager$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.FinalizedFeatureCache;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal$;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.ClientQuotaMetadataManager;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.MetadataPublisher;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.AclsDelta;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\u0005ux!\u0002\u000f\u001e\u0011\u0003!c!\u0002\u0014\u001e\u0011\u00039\u0003\"\u0002\u001b\u0002\t\u0003)\u0004\"\u0002\u001c\u0002\t\u00039\u0004\"B/\u0002\t\u0003qf!\u0002\u0014\u001e\u0001\u0005\r\u0001BCA\u0006\u000b\t\u0005\t\u0015!\u0003\u0002\u000e!Q\u0011QC\u0003\u0003\u0002\u0003\u0006I!a\u0006\t\u0015\u0005uQA!A!\u0002\u0013\ty\u0002\u0003\u0006\u0002&\u0015\u0011\t\u0011)A\u0005\u0003OA!\"!\f\u0006\u0005\u0003\u0005\u000b\u0011BA\u0018\u0011)\ty$\u0002B\u0001B\u0003%\u0011\u0011\t\u0005\u000b\u0003\u001b*!\u0011!Q\u0001\n\u0005=\u0003BCA+\u000b\t\u0005\t\u0015!\u0003\u0002X!Q\u0011QL\u0003\u0003\u0002\u0003\u0006I!a\u0018\t\u0015\u0005-TA!b\u0001\n\u0013\ti\u0007\u0003\u0006\u0002\u0000\u0015\u0011\t\u0011)A\u0005\u0003_Ba\u0001N\u0003\u0005\u0002\u0005\u0005\u0005\u0002C8\u0006\u0005\u0004%\t!!'\t\u000f\u0005mU\u0001)A\u0005a\"I\u0011QT\u0003A\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003O+\u0001\u0019!C\u0001\u0003SC\u0001\"!.\u0006A\u0003&\u0011\u0011\u0015\u0005\b\u0003o+A\u0011IA]\u0011\u001d\ty,\u0002C\u0001\u0003\u0003Dq!a6\u0006\t\u0013\tI\u000eC\u0004\u0002t\u0016!I!!>\t\u000f\u0005]X\u0001\"\u0003\u0002z\u00069\"I]8lKJlU\r^1eCR\f\u0007+\u001e2mSNDWM\u001d\u0006\u0003=}\t\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003A\u0005\naa]3sm\u0016\u0014(\"\u0001\u0012\u0002\u000b-\fgm[1\u0004\u0001A\u0011Q%A\u0007\u0002;\t9\"I]8lKJlU\r^1eCR\f\u0007+\u001e2mSNDWM]\n\u0004\u0003!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00020e5\t\u0001G\u0003\u00022C\u0005)Q\u000f^5mg&\u00111\u0007\r\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tA%A\u0007hKR$v\u000e]5d\t\u0016dG/\u0019\u000b\u0005q\u0019\u001b\u0006\fE\u0002*smJ!A\u000f\u0016\u0003\r=\u0003H/[8o!\taD)D\u0001>\u0015\tqt(A\u0003j[\u0006<WM\u0003\u0002#\u0001*\u0011\u0011IQ\u0001\u0007CB\f7\r[3\u000b\u0003\r\u000b1a\u001c:h\u0013\t)UH\u0001\u0006U_BL7\rR3mi\u0006DQaR\u0002A\u0002!\u000b\u0011\u0002^8qS\u000et\u0015-\\3\u0011\u0005%\u0003fB\u0001&O!\tY%&D\u0001M\u0015\ti5%\u0001\u0004=e>|GOP\u0005\u0003\u001f*\na\u0001\u0015:fI\u00164\u0017BA)S\u0005\u0019\u0019FO]5oO*\u0011qJ\u000b\u0005\u0006)\u000e\u0001\r!V\u0001\t]\u0016<\u0018*\\1hKB\u0011AHV\u0005\u0003/v\u0012Q\"T3uC\u0012\fG/Y%nC\u001e,\u0007\"B-\u0004\u0001\u0004Q\u0016!\u00023fYR\f\u0007C\u0001\u001f\\\u0013\taVHA\u0007NKR\fG-\u0019;b\t\u0016dG/Y\u0001\u0014M&tGm\u0015;sCf\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005?:\u001c\b\u0010E\u0002aK\"t!!Y2\u000f\u0005-\u0013\u0017\"A\u0016\n\u0005\u0011T\u0013a\u00029bG.\fw-Z\u0005\u0003M\u001e\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0003I*\u0002\"!\u001b7\u000e\u0003)T!a[ \u0002\r\r|W.\\8o\u0013\ti'N\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000b=$\u0001\u0019\u00019\u0002\u0011\t\u0014xn[3s\u0013\u0012\u0004\"!K9\n\u0005IT#aA%oi\")A\u000f\u0002a\u0001k\u0006qa.Z<U_BL7m]%nC\u001e,\u0007C\u0001\u001fw\u0013\t9XHA\u0006U_BL7m]%nC\u001e,\u0007\"B=\u0005\u0001\u0004Q\u0018\u0001\u00027pON\u00042\u0001Y3|!\tax0D\u0001~\u0015\tq\u0018%A\u0002m_\u001eL1!!\u0001~\u0005))f.\u001b4jK\u0012dunZ\n\u0006\u000b!\n)A\f\t\u0004K\u0005\u001d\u0011bAA\u0005;\t\tR*\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001a:\u0002\t\r|gN\u001a\t\u0005\u0003\u001f\t\t\"D\u0001 \u0013\r\t\u0019b\b\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\t\u0004K\u0005e\u0011bAA\u000e;\t\u00112JU1gi6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0003)awnZ'b]\u0006<WM\u001d\t\u0004y\u0006\u0005\u0012bAA\u0012{\nQAj\\4NC:\fw-\u001a:\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB!\u0011qBA\u0015\u0013\r\tYc\b\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003A9'o\\;q\u0007>|'\u000fZ5oCR|'\u000f\u0005\u0003\u00022\u0005mRBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0007\u0005e\u0012%A\u0006d_>\u0014H-\u001b8bi>\u0014\u0018\u0002BA\u001f\u0003g\u0011\u0001c\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\u0002\u001dQDhnQ8pe\u0012Lg.\u0019;peB!\u00111IA%\u001b\t\t)E\u0003\u0003\u0002H\u0005]\u0012a\u0003;sC:\u001c\u0018m\u0019;j_:LA!a\u0013\u0002F\t1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'/\u0001\u000edY&,g\u000e^)v_R\fW*\u001a;bI\u0006$\u0018-T1oC\u001e,'\u000fE\u0002&\u0003#J1!a\u0015\u001e\u0005i\u0019E.[3oiF+x\u000e^1NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u000311W-\u0019;ve\u0016\u001c\u0015m\u00195f!\u0011\ty!!\u0017\n\u0007\u0005msDA\u000bGS:\fG.\u001b>fI\u001a+\u0017\r^;sK\u000e\u000b7\r[3\u0002+\u0011Lh.Y7jG\u000e{gNZ5h\u0011\u0006tG\r\\3sgB1\u0011*!\u0019I\u0003KJ1!a\u0019S\u0005\ri\u0015\r\u001d\t\u0005\u0003\u001f\t9'C\u0002\u0002j}\u0011QbQ8oM&<\u0007*\u00198eY\u0016\u0014\u0018aC0bkRDwN]5{KJ,\"!a\u001c\u0011\t%J\u0014\u0011\u000f\t\u0005\u0003g\nY(\u0004\u0002\u0002v)!\u0011qOA=\u0003)\tW\u000f\u001e5pe&TXM\u001d\u0006\u0003A}JA!! \u0002v\tQ\u0011)\u001e;i_JL'0\u001a:\u0002\u0019}\u000bW\u000f\u001e5pe&TXM\u001d\u0011\u0015-\u0005\r\u0015QQAD\u0003\u0013\u000bY)!$\u0002\u0010\u0006E\u00151SAK\u0003/\u0003\"!J\u0003\t\u000f\u0005-\u0011\u00031\u0001\u0002\u000e!9\u0011QC\tA\u0002\u0005]\u0001bBA\u000f#\u0001\u0007\u0011q\u0004\u0005\b\u0003K\t\u0002\u0019AA\u0014\u0011\u001d\ti#\u0005a\u0001\u0003_Aq!a\u0010\u0012\u0001\u0004\t\t\u0005C\u0004\u0002NE\u0001\r!a\u0014\t\u000f\u0005U\u0013\u00031\u0001\u0002X!9\u0011QL\tA\u0002\u0005}\u0003bBA6#\u0001\u0007\u0011qN\u000b\u0002a\u0006I!M]8lKJLE\rI\u0001\u000e?\u001aL'o\u001d;Qk\nd\u0017n\u001d5\u0016\u0005\u0005\u0005\u0006cA\u0015\u0002$&\u0019\u0011Q\u0015\u0016\u0003\u000f\t{w\u000e\\3b]\u0006\trLZ5sgR\u0004VO\u00197jg\"|F%Z9\u0015\t\u0005-\u0016\u0011\u0017\t\u0004S\u00055\u0016bAAXU\t!QK\\5u\u0011%\t\u0019,FA\u0001\u0002\u0004\t\t+A\u0002yIE\nab\u00184jeN$\b+\u001e2mSND\u0007%A\u0004qk\nd\u0017n\u001d5\u0015\r\u0005-\u00161XA_\u0011\u0015Iv\u00031\u0001[\u0011\u0015!v\u00031\u0001V\u0003\u0015\u0012X\r\\8bIV\u0003H-\u0019;fI\u001aKG.Z:XSRDw.\u001e;D_:4\u0017nZ\"iC:<W\r\u0006\u0003\u0002,\u0006\r\u0007bBAc1\u0001\u0007\u0011qY\u0001\u0006aJ|\u0007o\u001d\t\u0005\u0003\u0013\f\u0019.\u0004\u0002\u0002L*!\u0011QZAh\u0003\u0011)H/\u001b7\u000b\u0005\u0005E\u0017\u0001\u00026bm\u0006LA!!6\u0002L\nQ\u0001K]8qKJ$\u0018.Z:\u0002#U\u0004H-\u0019;f\u0007>|'\u000fZ5oCR|'\u000f\u0006\u0007\u0002,\u0006m\u0017Q\\Ap\u0003C\fY\u000fC\u0003?3\u0001\u0007Q\u000bC\u0003Z3\u0001\u0007!\fC\u0003H3\u0001\u0007\u0001\nC\u0004\u0002df\u0001\r!!:\u0002\u0011\u0015dWm\u0019;j_:\u0004r!KAtaB\fY+C\u0002\u0002j*\u0012\u0011BR;oGRLwN\u001c\u001a\t\u000f\u00055\u0018\u00041\u0001\u0002p\u0006Y!/Z:jO:\fG/[8o!!I\u0013q\u001d9\u0002r\u0006-\u0006cA\u0015:a\u0006\u0011\u0012N\\5uS\u0006d\u0017N_3NC:\fw-\u001a:t)\t\tY+\u0001\u0011gS:L7\u000f[%oSRL\u0017\r\\5{S:<'+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014H\u0003BAV\u0003wDQ\u0001V\u000eA\u0002U\u0003")
public class BrokerMetadataPublisher
implements MetadataPublisher,
Logging {
    private final KafkaConfig conf;
    private final KRaftMetadataCache metadataCache;
    private final LogManager logManager;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final ClientQuotaMetadataManager clientQuotaMetadataManager;
    private final FinalizedFeatureCache featureCache;
    private final Map<String, ConfigHandler> dynamicConfigHandlers;
    private final Option<Authorizer> _authorizer;
    private final int brokerId;
    private boolean _firstPublish;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Iterable<TopicPartition> findStrayPartitions(int brokerId, TopicsImage newTopicsImage, Iterable<UnifiedLog> logs) {
        return BrokerMetadataPublisher$.MODULE$.findStrayPartitions(brokerId, newTopicsImage, logs);
    }

    public static Option<TopicDelta> getTopicDelta(String topicName, MetadataImage newImage, MetadataDelta delta) {
        return BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, newImage, delta);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Option<Authorizer> _authorizer() {
        return this._authorizer;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    @Override
    public void publish(MetadataDelta delta, MetadataImage newImage) {
        OffsetAndEpoch highestOffsetAndEpoch = newImage.highestOffsetAndEpoch();
        try {
            try {
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Publishing delta ").append(delta).append(" with highest offset ").append(highestOffsetAndEpoch).toString());
                this.metadataCache.setImage(newImage);
                if (this._firstPublish()) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Publishing initial metadata at offset ").append(highestOffsetAndEpoch).append(".").toString());
                    this.initializeManagers();
                } else if (this.isDebugEnabled()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Publishing metadata at offset ").append(highestOffsetAndEpoch).append(".").toString());
                }
                Option$.MODULE$.apply((Object)delta.featuresDelta()).foreach((Function1 & Serializable)featuresDelta -> {
                    this.featureCache.update(featuresDelta, highestOffsetAndEpoch.offset);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
                    BrokerMetadataPublisher.$anonfun$publish$5(this, newImage, delta, topicsDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.configsDelta()).foreach((Function1 & Serializable)configsDelta -> {
                    BrokerMetadataPublisher.$anonfun$publish$12(this, newImage, configsDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.clientQuotasDelta()).foreach((Function1 & Serializable)clientQuotasDelta -> {
                    this.clientQuotaMetadataManager.update(clientQuotasDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.aclsDelta()).foreach((Function1 & Serializable)aclsDelta -> {
                    BrokerMetadataPublisher.$anonfun$publish$18(this, newImage, aclsDelta);
                    return BoxedUnit.UNIT;
                });
                if (this._firstPublish()) {
                    this.finishInitializingReplicaManager(newImage);
                }
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Error publishing broker metadata at ").append(highestOffsetAndEpoch).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                throw t;
            }
        }
        finally {
            this._firstPublish_$eq(false);
        }
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties props) {
        this.conf.dynamicConfig().reloadUpdatedFilesWithoutConfigChange(props);
    }

    private void updateCoordinator(MetadataImage image, MetadataDelta delta, String topicName, Function2<Object, Object, BoxedUnit> election, Function2<Object, Option<Object>, BoxedUnit> resignation) {
        Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$1(this, topicName, resignation, topicsDelta);
            return BoxedUnit.UNIT;
        });
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, image, delta).foreach((Function1 & Serializable)topicDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$3(this, resignation, election, topicDelta);
            return BoxedUnit.UNIT;
        });
    }

    private void initializeManagers() {
        this.logManager.startup(this.metadataCache.getAllTopics());
        Option$.MODULE$.apply((Object)this.logManager.cleaner()).foreach((Function1 & Serializable)reconfigurable -> {
            BrokerMetadataPublisher.$anonfun$initializeManagers$1(this, reconfigurable);
            return BoxedUnit.UNIT;
        });
        this.replicaManager.startup();
        this.groupCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__consumer_offsets").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.offsetsTopicPartitions()))), this.groupCoordinator.startup$default$2());
        this.txnCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.transactionTopicPartitions()))), this.txnCoordinator.startup$default$2());
    }

    private void finishInitializingReplicaManager(MetadataImage newImage) {
        Iterable<TopicPartition> strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(this.brokerId(), newImage.topics(), this.logManager.allLogs());
        if (strayPartitions.nonEmpty()) {
            this.replicaManager.deleteStrayReplicas(strayPartitions);
        }
        this.replicaManager.startHighWatermarkCheckPointThread();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$publish$5(BrokerMetadataPublisher $this, MetadataImage newImage$1, MetadataDelta delta$2, TopicsDelta topicsDelta) {
        void updateCoordinator_election;
        void updateCoordinator_resignation;
        void updateCoordinator_election2;
        void updateCoordinator_resignation2;
        $this.replicaManager.applyDelta(topicsDelta, newImage$1);
        Function2 & Serializable intersect = (Function2 & Serializable)(offsetTopicPartitionId, coordinatorEpoch) -> {
            $this.groupCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)offsetTopicPartitionId), (Option<Object>)coordinatorEpoch);
            return BoxedUnit.UNIT;
        };
        JFunction2.mcVII.sp & Serializable intersect2 = (JFunction2.mcVII.sp & Serializable)(offsetTopicPartitionId, coordinatorEpoch) -> $this.groupCoordinator.onElection(offsetTopicPartitionId, coordinatorEpoch);
        String updateCoordinator_topicName = "__consumer_offsets";
        Option$.MODULE$.apply((Object)delta$2.topicsDelta()).foreach(arg_0 -> BrokerMetadataPublisher.$anonfun$updateCoordinator$1$adapted($this, updateCoordinator_topicName, (Function2)updateCoordinator_resignation2, arg_0));
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(updateCoordinator_topicName, newImage$1, delta$2).foreach(arg_0 -> BrokerMetadataPublisher.$anonfun$updateCoordinator$3$adapted($this, (Function2)updateCoordinator_resignation2, (Function2)updateCoordinator_election2, arg_0));
        Object var5_6 = null;
        intersect2 = null;
        intersect = null;
        Function2 & Serializable intersect3 = (Function2 & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> {
            $this.txnCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)txnTopicPartitionId), (Option<Object>)coordinatorEpoch);
            return BoxedUnit.UNIT;
        };
        JFunction2.mcVII.sp & Serializable intersect4 = (JFunction2.mcVII.sp & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> $this.txnCoordinator.onElection(txnTopicPartitionId, coordinatorEpoch);
        String updateCoordinator_topicName2 = "__transaction_state";
        Option$.MODULE$.apply((Object)delta$2.topicsDelta()).foreach(arg_0 -> BrokerMetadataPublisher.$anonfun$updateCoordinator$1$adapted($this, updateCoordinator_topicName2, (Function2)updateCoordinator_resignation, arg_0));
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(updateCoordinator_topicName2, newImage$1, delta$2).foreach(arg_0 -> BrokerMetadataPublisher.$anonfun$updateCoordinator$3$adapted($this, (Function2)updateCoordinator_resignation, (Function2)updateCoordinator_election, arg_0));
        Object var8_9 = null;
        intersect4 = null;
        intersect3 = null;
        ArrayBuffer deletedTopicPartitions = new ArrayBuffer();
        topicsDelta.deletedTopicIds().forEach(id2 -> {
            TopicImage topicImage = topicsDelta.image().getTopic(id2);
            topicImage.partitions().keySet().forEach(id -> deletedTopicPartitions.$plus$eq((Object)new TopicPartition(topicImage.name(), Predef$.MODULE$.Integer2int(id))));
        });
        if (deletedTopicPartitions.nonEmpty()) {
            $this.groupCoordinator.handleDeletedPartitions((Seq<TopicPartition>)deletedTopicPartitions, RequestLocal$.MODULE$.NoCaching());
        }
    }

    public static final /* synthetic */ void $anonfun$publish$12(BrokerMetadataPublisher $this, MetadataImage newImage$1, ConfigurationsDelta configsDelta) {
        configsDelta.changes().keySet().forEach(resource -> {
            block7: {
                Properties props;
                block9: {
                    String string;
                    String string2;
                    block8: {
                        props = newImage$1.configs().configProperties(resource);
                        ConfigResource.Type type = resource.type();
                        if (ConfigResource.Type.TOPIC.equals(type)) {
                            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(41).append("Updating topic ").append(resource.name()).append(" with new configuration : ").toString()).append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                            ((ConfigHandler)$this.dynamicConfigHandlers.apply((Object)ConfigType$.MODULE$.Topic())).processConfigChanges(resource.name(), props);
                            return;
                        }
                        if (!ConfigResource.Type.BROKER.equals(type)) break block7;
                        if (resource.name().isEmpty()) {
                            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Updating cluster configuration : ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                            ((ConfigHandler)$this.dynamicConfigHandlers.apply((Object)ConfigType$.MODULE$.Broker())).processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
                            return;
                        }
                        string2 = resource.name();
                        string = Integer.toString($this.brokerId());
                        if (string2 != null) break block8;
                        if (string != null) {
                            return;
                        }
                        break block9;
                    }
                    if (!string2.equals(string)) break block7;
                }
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("Updating broker ").append($this.brokerId()).append(" with new configuration : ").toString()).append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                ((ConfigHandler)$this.dynamicConfigHandlers.apply((Object)ConfigType$.MODULE$.Broker())).processConfigChanges(resource.name(), props);
                $this.reloadUpdatedFilesWithoutConfigChange(props);
                return;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$publish$18(BrokerMetadataPublisher $this, MetadataImage newImage$1, AclsDelta aclsDelta) {
        Authorizer authorizer;
        Option<Authorizer> option = $this._authorizer();
        if (option instanceof Some && (authorizer = (Authorizer)((Some)option).value()) instanceof ClusterMetadataAuthorizer) {
            ClusterMetadataAuthorizer clusterMetadataAuthorizer = (ClusterMetadataAuthorizer)authorizer;
            if (aclsDelta.isSnapshotDelta()) {
                clusterMetadataAuthorizer.loadSnapshot(newImage$1.acls().acls());
                return;
            }
            aclsDelta.changes().entrySet().forEach(e -> {
                if (((Optional)e.getValue()).isPresent()) {
                    clusterMetadataAuthorizer.addAcl((Uuid)e.getKey(), (StandardAcl)((Optional)e.getValue()).get());
                    return;
                }
                clusterMetadataAuthorizer.removeAcl((Uuid)e.getKey());
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$1(BrokerMetadataPublisher $this, String topicName$1, Function2 resignation$1, TopicsDelta topicsDelta) {
        if (topicsDelta.topicWasDeleted(topicName$1)) {
            topicsDelta.image().getTopic(topicName$1).partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == $this.brokerId()) {
                    resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                }
            });
        }
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$3(BrokerMetadataPublisher $this, Function2 resignation$1, Function2 election$1, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
        changes.leaders().forEach((topicPartition, partitionInfo) -> election$1.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ void $anonfun$initializeManagers$1(BrokerMetadataPublisher $this, BrokerReconfigurable reconfigurable) {
        $this.conf.dynamicConfig().addBrokerReconfigurable(reconfigurable);
    }

    public BrokerMetadataPublisher(KafkaConfig conf, KRaftMetadataCache metadataCache, LogManager logManager, ReplicaManager replicaManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, ClientQuotaMetadataManager clientQuotaMetadataManager, FinalizedFeatureCache featureCache, Map<String, ConfigHandler> dynamicConfigHandlers, Option<Authorizer> _authorizer) {
        this.conf = conf;
        this.metadataCache = metadataCache;
        this.logManager = logManager;
        this.replicaManager = replicaManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.clientQuotaMetadataManager = clientQuotaMetadataManager;
        this.featureCache = featureCache;
        this.dynamicConfigHandlers = dynamicConfigHandlers;
        this._authorizer = _authorizer;
        this.logIdent_$eq(new StringBuilder(30).append("[BrokerMetadataPublisher id=").append(conf.nodeId()).append("] ").toString());
        this.brokerId = conf.nodeId();
        this._firstPublish = true;
    }
}

