/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import kafka.admin.AclCommand$;
import kafka.api.DelegationTokenEndToEndAuthorizationTest;
import kafka.utils.JaasTestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001B\u000f\u001f\u0001\rBQ\u0001\u000b\u0001\u0005\u0002%BQa\u000b\u0001\u0005\u00021BQA\u0010\u0001\u0005\u00021BQa\u0010\u0001\u0005\u00021BQ\u0001\u0011\u0001\u0005B\u0005Cqa\u0014\u0001C\u0002\u0013%\u0001\u000b\u0003\u0004\\\u0001\u0001\u0006I!\u0015\u0005\b9\u0002\u0011\r\u0011\"\u0003^\u0011\u0019)\u0007\u0001)A\u0005=\"9a\r\u0001b\u0001\n\u0013\u0001\u0006BB4\u0001A\u0003%\u0011\u000bC\u0004i\u0001\t\u0007I\u0011B/\t\r%\u0004\u0001\u0015!\u0003_\u0011\u001dQ\u0007A1A\u0005\nACaa\u001b\u0001!\u0002\u0013\t\u0006b\u00027\u0001\u0005\u0004%I!\u0018\u0005\u0007[\u0002\u0001\u000b\u0011\u00020\t\u000f9\u0004!\u0019!C\u0005!\"1q\u000e\u0001Q\u0001\nECq\u0001\u001d\u0001C\u0002\u0013%Q\f\u0003\u0004r\u0001\u0001\u0006IA\u0018\u0005\u0006e\u0002!\te\u001d\u0005\u0006o\u0002!\te\u001d\u0005\u0006q\u0002!\t%\u001f\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0011\u0019\t\t\u0002\u0001C\u0001g\"1\u0011q\u0005\u0001\u0005\u0002MDa!a\u000b\u0001\t\u0003\u0019(!\r#fY\u0016<\u0017\r^5p]R{7.\u001a8F]\u0012$v.\u00128e\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8XSRDwj\u001e8feR+7\u000f\u001e\u0006\u0003?\u0001\n1!\u00199j\u0015\u0005\t\u0013!B6bM.\f7\u0001A\n\u0003\u0001\u0011\u0002\"!\n\u0014\u000e\u0003yI!a\n\u0010\u0003Q\u0011+G.Z4bi&|g\u000eV8lK:,e\u000e\u001a+p\u000b:$\u0017)\u001e;i_JL'0\u0019;j_:$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005Q\u0003CA\u0013\u0001\u0003m\u0019'/Z1uKR{7.\u001a8G_J4\u0016\r\\5e+N,'/\u0011:hgV\tQ\u0006E\u0002/cMj\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003imr!!N\u001d\u0011\u0005YzS\"A\u001c\u000b\u0005a\u0012\u0013A\u0002\u001fs_>$h(\u0003\u0002;_\u00051\u0001K]3eK\u001aL!\u0001P\u001f\u0003\rM#(/\u001b8h\u0015\tQt&A\u000feKN\u001c'/\u001b2f)>\\WM\u001c$peZ\u000bG.\u001b3Vg\u0016\u0014\u0018I]4t\u0003e!Wm]2sS\n,Gk\\6f]\u001a{'/\u00113nS:\f%oZ:\u00029\r\u0014X-\u0019;f\t\u0016dWmZ1uS>tGk\\6f]>\u0003H/[8ogR\t!\t\u0005\u0002D\u001b6\tAI\u0003\u0002F\r\u0006)\u0011\rZ7j]*\u0011q\tS\u0001\bG2LWM\u001c;t\u0015\t\t\u0013J\u0003\u0002K\u0017\u00061\u0011\r]1dQ\u0016T\u0011\u0001T\u0001\u0004_J<\u0017B\u0001(E\u0005q\u0019%/Z1uK\u0012+G.Z4bi&|g\u000eV8lK:|\u0005\u000f^5p]N\fq\u0003^8lK:\u0014V-];fgR,'\u000f\u0015:j]\u000eL\u0007/\u00197\u0016\u0003E\u0003\"AU-\u000e\u0003MS!\u0001V+\u0002\t\u0005,H\u000f\u001b\u0006\u0003-^\u000b\u0001b]3dkJLG/\u001f\u0006\u00031\"\u000baaY8n[>t\u0017B\u0001.T\u00059Y\u0015MZ6b!JLgnY5qC2\f\u0001\u0004^8lK:\u0014V-];fgR,'\u000f\u0015:j]\u000eL\u0007/\u00197!\u0003Y!xn[3o%\u0016\fX/Z:uKJ\u0004\u0016m]:x_J$W#\u00010\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001\u00027b]\u001eT\u0011aY\u0001\u0005U\u00064\u0018-\u0003\u0002=A\u00069Bo\\6f]J+\u0017/^3ti\u0016\u0014\b+Y:to>\u0014H\rI\u0001\u0015_RDWM]\"mS\u0016tG\u000f\u0015:j]\u000eL\u0007/\u00197\u0002+=$\b.\u001a:DY&,g\u000e\u001e)sS:\u001c\u0017\u000e]1mA\u0005\u0019r\u000e\u001e5fe\u000ec\u0017.\u001a8u!\u0006\u001c8o^8sI\u0006!r\u000e\u001e5fe\u000ec\u0017.\u001a8u!\u0006\u001c8o^8sI\u0002\nQd\u001c;iKJ\u001cE.[3oiJ+\u0017/^3ti\u0016\u0014\bK]5oG&\u0004\u0018\r\\\u0001\u001f_RDWM]\"mS\u0016tGOU3rk\u0016\u001cH/\u001a:Qe&t7-\u001b9bY\u0002\nAd\u001c;iKJ\u001cE.[3oiJ+\u0017/^3ti\u0016\u0014\b+Y:to>\u0014H-A\u000fpi\",'o\u00117jK:$(+Z9vKN$XM\u001d)bgN<xN\u001d3!\u0003i!Wm]2sS\n,Gk\\6f]\u001a\u000b\u0017\u000e\u001c)sS:\u001c\u0017\u000e]1m\u0003m!Wm]2sS\n,Gk\\6f]\u001a\u000b\u0017\u000e\u001c)sS:\u001c\u0017\u000e]1mA\u0005IB-Z:de&\u0014W\rV8lK:4\u0015-\u001b7QCN\u001cxo\u001c:e\u0003i!Wm]2sS\n,Gk\\6f]\u001a\u000b\u0017\u000e\u001c)bgN<xN\u001d3!\u0003\u0011\u001awN\u001c4jOV\u0014X\rV8lK:\f5\r\\:CK\u001a|'/Z*feZ,'o]*uCJ$H#\u0001;\u0011\u00059*\u0018B\u0001<0\u0005\u0011)f.\u001b;\u0002]\r\u0014X-\u0019;f\u0003\u0012$\u0017\u000e^5p]\u0006d7I]3eK:$\u0018.\u00197t\u0003\u001a$XM]*feZ,'o]*uCJ$X\rZ\u0001\fCN\u001cXM\u001d;U_.,g\u000e\u0006\u0002uu\")1\u0010\u0007a\u0001y\u0006)Ao\\6f]B\u0019Q0a\u0001\u000e\u0003yT1a`A\u0001\u0003)!W\r\\3hCRLwN\u001c\u0006\u0003wVK1!!\u0002\u007f\u0005=!U\r\\3hCRLwN\u001c+pW\u0016t\u0017aH2sK\u0006$X\rV8lK:\u0014V-];fgR,'/\u00113nS:\u001cE.[3oiR\u0011\u00111\u0002\t\u0004\u0007\u00065\u0011bAA\b\t\n)\u0011\tZ7j]\u0006\u0001C/Z:u\u0007J,\u0017\r^3U_.,gNR8s\u001fRDWM]+tKJ4\u0015-\u001b7tQ\rQ\u0012Q\u0003\t\u0005\u0003/\t\u0019#\u0004\u0002\u0002\u001a)\u0019q$a\u0007\u000b\t\u0005u\u0011qD\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t\tcS\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003K\tIB\u0001\u0003UKN$\u0018A\t;fgR$Um]2sS\n,Gk\\6f]\u001a{'o\u0014;iKJ,6/\u001a:GC&d7\u000fK\u0002\u001c\u0003+\t1\u0005^3ti\u0012+7o\u0019:jE\u0016$vn[3o\r>\u0014x\n\u001e5feV\u001bXM\u001d)bgN,7\u000fK\u0002\u001d\u0003+\u0001")
public class DelegationTokenEndToEndAuthorizationWithOwnerTest
extends DelegationTokenEndToEndAuthorizationTest {
    private final KafkaPrincipal tokenRequesterPrincipal = new KafkaPrincipal("User", JaasTestUtils$.MODULE$.KafkaScramUser2());
    private final String tokenRequesterPassword = JaasTestUtils$.MODULE$.KafkaScramPassword2();
    private final KafkaPrincipal otherClientPrincipal = new KafkaPrincipal("User", "other-client-principal");
    private final String otherClientPassword;
    private final KafkaPrincipal otherClientRequesterPrincipal = new KafkaPrincipal("User", "other-client-requester-principal");
    private final String otherClientRequesterPassword;
    private final KafkaPrincipal describeTokenFailPrincipal = new KafkaPrincipal("User", "describe-token-fail-principal");
    private final String describeTokenFailPassword;

    public String[] createTokenForValidUserArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(17).append("--user-principal=").append(this.clientPrincipal()).toString(), "--operation=CreateTokens", new StringBuilder(18).append("--allow-principal=").append(this.tokenRequesterPrincipal()).toString()};
    }

    public String[] describeTokenForValidUserArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(17).append("--user-principal=").append(this.clientPrincipal()).toString(), "--operation=DescribeTokens", new StringBuilder(18).append("--allow-principal=").append(this.tokenRequesterPrincipal()).toString()};
    }

    public String[] describeTokenForAdminArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(17).append("--user-principal=").append(this.otherClientPrincipal()).toString(), "--operation=DescribeTokens", new StringBuilder(18).append("--allow-principal=").append(this.otherClientRequesterPrincipal()).toString()};
    }

    @Override
    public CreateDelegationTokenOptions createDelegationTokenOptions() {
        return new CreateDelegationTokenOptions().owner(this.clientPrincipal());
    }

    private KafkaPrincipal tokenRequesterPrincipal() {
        return this.tokenRequesterPrincipal;
    }

    private String tokenRequesterPassword() {
        return this.tokenRequesterPassword;
    }

    private KafkaPrincipal otherClientPrincipal() {
        return this.otherClientPrincipal;
    }

    private String otherClientPassword() {
        return this.otherClientPassword;
    }

    private KafkaPrincipal otherClientRequesterPrincipal() {
        return this.otherClientRequesterPrincipal;
    }

    private String otherClientRequesterPassword() {
        return this.otherClientRequesterPassword;
    }

    private KafkaPrincipal describeTokenFailPrincipal() {
        return this.describeTokenFailPrincipal;
    }

    private String describeTokenFailPassword() {
        return this.describeTokenFailPassword;
    }

    @Override
    public void configureTokenAclsBeforeServersStart() {
        super.configureTokenAclsBeforeServersStart();
        AclCommand$.MODULE$.main(this.createTokenForValidUserArgs());
        AclCommand$.MODULE$.main(this.describeTokenForValidUserArgs());
        AclCommand$.MODULE$.main(this.describeTokenForAdminArgs());
    }

    @Override
    public void createAdditionalCredentialsAfterServersStarted() {
        super.createAdditionalCredentialsAfterServersStarted();
        this.createScramCredentialsViaPrivilegedAdminClient(this.tokenRequesterPrincipal().getName(), this.tokenRequesterPassword());
        this.createScramCredentialsViaPrivilegedAdminClient(this.otherClientPrincipal().getName(), this.otherClientPassword());
        this.createScramCredentialsViaPrivilegedAdminClient(this.otherClientRequesterPrincipal().getName(), this.otherClientRequesterPassword());
        this.createScramCredentialsViaPrivilegedAdminClient(this.describeTokenFailPrincipal().getName(), this.describeTokenFailPassword());
    }

    @Override
    public void assertToken(DelegationToken token) {
        this.assertTokenOwner(this.clientPrincipal(), token);
        this.assertTokenRequester(this.tokenRequesterPrincipal(), token);
    }

    @Override
    public Admin createTokenRequesterAdminClient() {
        return this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.tokenRequesterPrincipal().getName(), this.tokenRequesterPassword());
    }

    @Test
    public void testCreateTokenForOtherUserFails() {
        Assertions.assertTrue((boolean)((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.createDelegationTokens((Function0<CreateDelegationTokenOptions>)(Function0 & Serializable)() -> new CreateDelegationTokenOptions().owner(this.otherClientPrincipal()), false))).getMessage().contains("Delegation Token authorization failed"));
    }

    @Test
    public void testDescribeTokenForOtherUserFails() {
        Admin describeTokenFailAdminClient = this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.describeTokenFailPrincipal().getName(), this.describeTokenFailPassword());
        Admin otherClientAdminClient = this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.otherClientPrincipal().getName(), this.otherClientPassword());
        try {
            otherClientAdminClient.createDelegationToken().delegationToken().get();
            Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala((List)describeTokenFailAdminClient.describeDelegationToken(new DescribeDelegationTokenOptions().owners(Collections.singletonList(this.otherClientPrincipal()))).delegationTokens().get()).asScala().isEmpty());
        }
        finally {
            describeTokenFailAdminClient.close();
            otherClientAdminClient.close();
        }
    }

    @Test
    public void testDescribeTokenForOtherUserPasses() {
        try (Admin adminClient = this.createTokenRequesterAdminClient();){
            Buffer tokens = CollectionConverters$.MODULE$.ListHasAsScala((List)adminClient.describeDelegationToken(new DescribeDelegationTokenOptions().owners(Collections.singletonList(this.clientPrincipal()))).delegationTokens().get()).asScala();
            Assertions.assertTrue((boolean)tokens.nonEmpty());
            tokens.foreach((Function1 & Serializable)t -> {
                DelegationTokenEndToEndAuthorizationWithOwnerTest.$anonfun$testDescribeTokenForOtherUserPasses$1(this, t);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$testDescribeTokenForOtherUserPasses$1(DelegationTokenEndToEndAuthorizationWithOwnerTest $this, DelegationToken t) {
        Assertions.assertTrue((boolean)t.tokenInfo().owner().equals((Object)$this.clientPrincipal()));
        Assertions.assertTrue((boolean)t.tokenInfo().tokenRequester().equals((Object)$this.tokenRequesterPrincipal()));
    }

    public DelegationTokenEndToEndAuthorizationWithOwnerTest() {
        this.otherClientPassword = "other-client-password";
        this.otherClientRequesterPassword = "other-client-requester-password";
        this.describeTokenFailPassword = "describe-token-fail-password";
    }
}

