/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kafka.api.LeaderAndIsr;
import kafka.server.AlterPartitionManager;
import kafka.server.AlterPartitionManagerTest$;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.DefaultAlterPartitionManager;
import kafka.server.ZkAlterPartitionManager;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rud\u0001B\u001f?\u0001\rCQA\u0013\u0001\u0005\u0002-CqA\u0014\u0001C\u0002\u0013\u0005q\n\u0003\u0004Y\u0001\u0001\u0006I\u0001\u0015\u0005\b3\u0002\u0011\r\u0011\"\u0001[\u0011\u00191\u0007\u0001)A\u00057\"9q\r\u0001b\u0001\n\u0003A\u0007BB8\u0001A\u0003%\u0011\u000eC\u0004q\u0001\t\u0007I\u0011A9\t\r]\u0004\u0001\u0015!\u0003s\u0011\u001dA\bA1A\u0005\u0002eDa! \u0001!\u0002\u0013Q\b\"\u0003@\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0000\u0011-\t9\u0001\u0001a\u0001\u0002\u0004%\t!!\u0003\t\u0017\u0005U\u0001\u00011A\u0001B\u0003&\u0011\u0011\u0001\u0005\n\u0003/\u0001!\u0019!C\u0001\u00033A\u0001\"!\t\u0001A\u0003%\u00111\u0004\u0005\n\u0003G\u0001!\u0019!C\u0001\u00033A\u0001\"!\n\u0001A\u0003%\u00111\u0004\u0005\n\u0003O\u0001!\u0019!C\u0001\u00033A\u0001\"!\u000b\u0001A\u0003%\u00111\u0004\u0005\b\u0003W\u0001A\u0011AA\u0017\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fBq!! \u0001\t\u0003\ty\bC\u0004\u0002\u001e\u0002!\t!a(\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\"9\u0011Q\u0017\u0001\u0005\u0002\u00055\u0002bBA`\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003\u0007\u0004A\u0011AA\u0017\u0011\u001d\t9\r\u0001C\u0001\u0003[Aq!a3\u0001\t\u0003\ti\u0003C\u0004\u0002P\u0002!\t!!\f\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\"9\u0011q\u001d\u0001\u0005\n\u0005%\bbBA~\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003\u007f\u0004A\u0011AA\u0017\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0003[AqAa\u0002\u0001\t\u0003\ti\u0003C\u0004\u0003\f\u0001!IA!\u0004\t\u000f\tE\u0001\u0001\"\u0003\u0003\u0014!9!\u0011\u0005\u0001\u0005\u0002\t\r\u0002b\u0002B\u0017\u0001\u0011\u0005!q\u0006\u0005\b\u0005s\u0001A\u0011\u0001B\u001e\u0011\u001d\u0011)\u0005\u0001C\u0005\u0005\u000fBqA!$\u0001\t\u0013\u0011y\tC\u0004\u0003B\u0002!IAa1\t\u000f\tE\u0007\u0001\"\u0003\u0003T\"9!q \u0001\u0005\n\r\u0005\u0001bBB\u0005\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0007\u001b\u0001A\u0011BB\b\u0011%\u0019Y\u0003AI\u0001\n\u0013\u0019i\u0003C\u0005\u0004D\u0001\t\n\u0011\"\u0003\u0004F!I1\u0011\n\u0001\u0012\u0002\u0013%11\n\u0005\n\u0007\u001f\u0002\u0011\u0013!C\u0005\u0007\u0017B\u0011b!\u0015\u0001#\u0003%Iaa\u0013\t\u0013\rM\u0003!%A\u0005\n\rUsaBB-}!\u000511\f\u0004\u0007{yB\ta!\u0018\t\r)KD\u0011AB0\u0011\u001d\t\t(\u000fC\u0001\u0007CBq!!':\t\u0003\u0019\u0019HA\rBYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:UKN$(BA A\u0003\u0019\u0019XM\u001d<fe*\t\u0011)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001!\u0005CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0019B\u0011Q\nA\u0007\u0002}\u0005)Ao\u001c9jGV\t\u0001\u000b\u0005\u0002R-6\t!K\u0003\u0002T)\u0006!A.\u00198h\u0015\u0005)\u0016\u0001\u00026bm\u0006L!a\u0016*\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u00059Ao\u001c9jG&#W#A.\u0011\u0005q#W\"A/\u000b\u0005y{\u0016AB2p[6|gN\u0003\u0002BA*\u0011\u0011MY\u0001\u0007CB\f7\r[3\u000b\u0003\r\f1a\u001c:h\u0013\t)WL\u0001\u0003Vk&$\u0017\u0001\u0003;pa&\u001c\u0017\n\u001a\u0011\u0002\tQLW.Z\u000b\u0002SB\u0011!.\\\u0007\u0002W*\u0011A\u000eQ\u0001\u0006kRLGn]\u0005\u0003].\u0014\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\b[\u0016$(/[2t+\u0005\u0011\bCA:v\u001b\u0005!(B\u00019^\u0013\t1HOA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\n\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002uB\u0011Qi_\u0005\u0003y\u001a\u00131!\u00138u\u0003%\u0011'o\\6fe&#\u0007%\u0001\nce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u0014XCAA\u0001!\ri\u00151A\u0005\u0004\u0003\u000bq$\u0001\t\"s_.,'\u000fV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\faC\u0019:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7fe~#S-\u001d\u000b\u0005\u0003\u0017\t\t\u0002E\u0002F\u0003\u001bI1!a\u0004G\u0005\u0011)f.\u001b;\t\u0013\u0005MQ\"!AA\u0002\u0005\u0005\u0011a\u0001=%c\u0005\u0019\"M]8lKJ$vnQ8oiJ|G\u000e\\3sA\u0005\u0019A\u000f\u001d\u0019\u0016\u0005\u0005m\u0001c\u0001/\u0002\u001e%\u0019\u0011qD/\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017\u0001\u0002;qa\u0001\n1\u0001\u001e92\u0003\u0011!\b/\r\u0011\u0002\u0007Q\u0004('\u0001\u0003uaJ\u0002\u0013!B:fiV\u0004HCAA\u0006Q\r)\u0012\u0011\u0007\t\u0005\u0003g\t\t%\u0004\u0002\u00026)!\u0011qGA\u001d\u0003\r\t\u0007/\u001b\u0006\u0005\u0003w\ti$A\u0004kkBLG/\u001a:\u000b\u0007\u0005}\"-A\u0003kk:LG/\u0003\u0003\u0002D\u0005U\"A\u0003\"fM>\u0014X-R1dQ\u0006IA/Z:u\u0005\u0006\u001c\u0018n\u0019\u000b\u0005\u0003\u0017\tI\u0005C\u0004\u0002LY\u0001\r!!\u0014\u0002\u001f5,G/\u00193bi\u00064VM]:j_:\u0004B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004=\u0006M#BA `\u0013\u0011\t9&!\u0015\u0003\u001f5+G/\u00193bi\u00064VM]:j_:DsAFA.\u0003W\ni\u0007\u0005\u0003\u0002^\u0005\u001dTBAA0\u0015\u0011\t\t'a\u0019\u0002\u0011A\u0014xN^5eKJTA!!\u001a\u0002:\u00051\u0001/\u0019:b[NLA!!\u001b\u0002`\taQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\u0012\u0011qN\u0011\u0003\u0003c\nq\u0003\u001d:pm&$W-T3uC\u0012\fG/\u0019,feNLwN\\:)\u0007Y\t)\b\u0005\u0003\u0002x\u0005eTBAA2\u0013\u0011\tY(a\u0019\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0011uKN$()Y:jGN+g\u000e\u001e'fC\u0012,'OU3d_Z,'/_*uCR,GCBA\u0006\u0003\u0003\u000b\u0019\tC\u0004\u0002L]\u0001\r!!\u0014\t\u000f\u0005\u0015u\u00031\u0001\u0002\b\u0006\u0019B.Z1eKJ\u0014VmY8wKJL8\u000b^1uKB!\u0011\u0011RAH\u001b\t\tYIC\u0002\u0002\u000e~\u000b\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003#\u000bYIA\nMK\u0006$WM\u001d*fG>4XM]=Ti\u0006$X\rK\u0004\u0018\u00037\nY'!&-\u0005\u0005]\u0015EAAM\u0003i\u0001(o\u001c<jI\u0016dU-\u00193feJ+7m\u001c<fef\u001cF/\u0019;fQ\r9\u0012QO\u0001\u0019i\u0016\u001cHo\u0014<fe^\u0014\u0018\u000e^3XSRD\u0017N\u001c\"bi\u000eDG\u0003BA\u0006\u0003CCq!a\u0013\u0019\u0001\u0004\ti\u0005K\u0004\u0019\u00037\nY'!*-\u0005\u0005=\u0004f\u0001\r\u0002v\u0005yA/Z:u'&tw\r\\3CCR\u001c\u0007\u000e\u0006\u0003\u0002\f\u00055\u0006bBA&3\u0001\u0007\u0011Q\n\u0015\b3\u0005m\u00131NAYY\t\ty\u0007K\u0002\u001a\u0003k\na\u0003^3tiN+(-\\5u\rJ|WnQ1mY\n\f7m\u001b\u0015\u00045\u0005e\u0006\u0003BA\u001a\u0003wKA!!0\u00026\t!A+Z:u\u0003]!Xm\u001d;BkRDwN]5{CRLwN\u001c$bS2,G\rK\u0002\u001c\u0003s\u000bA\u0003^3tiN#\u0018\r\\3Ce>\\WM]#q_\u000eD\u0007f\u0001\u000f\u0002:\u0006\tB/Z:u+:\\gn\\<o'\u0016\u0014h/\u001a:)\u0007u\tI,\u0001\u0011uKN$(+\u001a;ss>s\u0017)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,\u0007f\u0001\u0010\u0002:\u0006\u0011C/Z:u%\u0016$(/_(o+:\u001cX\u000f\u001d9peR,GMV3sg&|g.\u0012:s_JD3aHA]\u0003a!Xm\u001d;SKR\u0014\u0018p\u00148U_BdUM^3m\u000bJ\u0014xN\u001d\u000b\u0005\u0003\u0017\t9\u000eC\u0004\u0002Z\u0002\u0002\r!a7\u0002\u000b\u0015\u0014(o\u001c:\u0011\t\u0005u\u00171]\u0007\u0003\u0003?T1!!9^\u0003!\u0001(o\u001c;pG>d\u0017\u0002BAs\u0003?\u0014a!\u0012:s_J\u001c\u0018\u0001\u0007;fgR\u0014V\r\u001e:z\u001f:,%O]8s%\u0016\u001c\bo\u001c8tKR!\u00111BAv\u0011\u001d\ti/\ta\u0001\u0003_\f\u0001B]3ta>t7/\u001a\t\u0005\u0003c\f90\u0004\u0002\u0002t*\u0019\u0011Q_0\u0002\u000f\rd\u0017.\u001a8ug&!\u0011\u0011`Az\u00059\u0019E.[3oiJ+7\u000f]8og\u0016\f\u0001\u0004^3ti&sg/\u00197jIV\u0003H-\u0019;f-\u0016\u00148/[8oQ\r\u0011\u0013\u0011X\u0001\u001ai\u0016\u001cH/\u00168l]><h\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eK\u0002$\u0003s\u000bq\u0003^3ti:{G\u000fT3bI\u0016\u0014xJ\u001d$pY2|w/\u001a:)\u0007\u0011\nI,\u0001\nuKN$\u0018J\u001c<bY&$'+Z9vKN$\bfA\u0013\u0002:\u0006\u00192\r[3dWB\u000b'\u000f^5uS>tWI\u001d:peR!\u00111\u0002B\b\u0011\u001d\tIN\na\u0001\u00037\f!\u0003^3tiB\u000b'\u000f^5uS>tWI\u001d:peR1!Q\u0003B\u000e\u0005?\u00012!\u0014B\f\u0013\r\u0011IB\u0010\u0002\u0016\u00032$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3s\u0011\u001d\u0011ib\na\u0001\u00037\t!\u0001\u001e9\t\u000f\u0005ew\u00051\u0001\u0002\\\u0006yA/Z:u\u001f:,\u0017J\u001c$mS\u001eDG\u000f\u0006\u0003\u0002\f\t\u0015\u0002bBA&Q\u0001\u0007\u0011Q\n\u0015\bQ\u0005m\u00131\u000eB\u0015Y\t\ty\u0007K\u0002)\u0003k\na\u0004^3tiB\u000b'\u000f^5uS>tW*[:tS:<\u0017J\u001c*fgB|gn]3\u0015\t\u0005-!\u0011\u0007\u0005\b\u0003\u0017J\u0003\u0019AA'Q\u001dI\u00131LA6\u0005ka#!a\u001c)\u0007%\n)(A\nuKN$\b+\u0019:uS\u0006dGk\u001c9jG&#7\u000f\u0006\u0003\u0002\f\tu\u0002bBA&U\u0001\u0007\u0011Q\n\u0015\bU\u0005m\u00131\u000eB!Y\t\ty\u0007K\u0002+\u0003k\n\u0011C^3sS\u001aL8+\u001a8e%\u0016\fX/Z:u)\u0019\u0011IEa\u0014\u0003RA\u0019QJa\u0013\n\u0007\t5cH\u0001\u0012D_:$(o\u001c7mKJ\u0014V-];fgR\u001cu.\u001c9mKRLwN\u001c%b]\u0012dWM\u001d\u0005\u0007}.\u0002\r!!\u0001\t\u000f\tM3\u00061\u0001\u0003V\u0005yQ\r\u001f9fGR,GMU3rk\u0016\u001cH\u000f\u0005\u0004\u0003X\tu#\u0011M\u0007\u0003\u00053R1Aa\u0017c\u0003\u001diwnY6ji>LAAa\u0018\u0003Z\ty\u0011I]4v[\u0016tG/T1uG\",'\u000f\r\u0003\u0003d\tm\u0004C\u0002B3\u0005c\u00129H\u0004\u0003\u0003h\t5TB\u0001B5\u0015\r\u0011Y'X\u0001\te\u0016\fX/Z:ug&!!q\u000eB5\u0003=\t%m\u001d;sC\u000e$(+Z9vKN$\u0018\u0002\u0002B:\u0005k\u0012qAQ;jY\u0012,'O\u0003\u0003\u0003p\t%\u0004\u0003\u0002B=\u0005wb\u0001\u0001\u0002\u0007\u0003~\tE\u0013\u0011!A\u0001\u0006\u0003\u0011yHA\u0002`IE\nBA!!\u0003\bB\u0019QIa!\n\u0007\t\u0015eIA\u0004O_RD\u0017N\\4\u0011\t\t\u001d$\u0011R\u0005\u0005\u0005\u0017\u0013IGA\bBEN$(/Y2u%\u0016\fX/Z:u\u0003q\tG\u000e^3s!\u0006\u0014H/\u001b;j_:\u0014V-];fgRl\u0015\r^2iKJ$bA!%\u0003\u001e\n]\u0006C\u0002B,\u0005;\u0012\u0019\n\r\u0003\u0003\u0016\ne\u0005C\u0002B3\u0005c\u00129\n\u0005\u0003\u0003z\teEa\u0003BNY\u0005\u0005\t\u0011!B\u0001\u0005\u007f\u00121a\u0018\u00133\u0011\u001d\u0011y\n\fa\u0001\u0005C\u000bq#\u001a=qK\u000e$X\r\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\r\t\r&\u0011WA\u000e\u001d\u0011\u0011)K!,\u0011\u0007\t\u001df)\u0004\u0002\u0003**\u0019!1\u0016\"\u0002\rq\u0012xn\u001c;?\u0013\r\u0011yKR\u0001\u0007!J,G-\u001a4\n\t\tM&Q\u0017\u0002\u0004'\u0016$(b\u0001BX\r\"9!\u0011\u0018\u0017A\u0002\tm\u0016aD3ya\u0016\u001cG/\u001a3WKJ\u001c\u0018n\u001c8\u0011\u0007\u0015\u0013i,C\u0002\u0003@\u001a\u0013Qa\u00155peR\f!#\\1lK\u000ec\u0017.\u001a8u%\u0016\u001c\bo\u001c8tKR1\u0011q\u001eBc\u0005\u001bDq!!<.\u0001\u0004\u00119\r\u0005\u0003\u0003h\t%\u0017\u0002\u0002Bf\u0005S\u0012a#\u00117uKJ\u0004\u0016M\u001d;ji&|gNU3ta>t7/\u001a\u0005\b\u0005\u001fl\u0003\u0019\u0001B^\u0003\u001d1XM]:j_:\f!#\\1lK\u0006cG/\u001a:QCJ$\u0018\u000e^5p]R!!q\u0019Bk\u0011\u001d\u00119N\fa\u0001\u00053\fa\u0001^8qS\u000e\u001c\bC\u0002Bn\u0005K\u0014YO\u0004\u0003\u0003^\n\u0005h\u0002\u0002BT\u0005?L\u0011aR\u0005\u0004\u0005G4\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005O\u0014IOA\u0002TKFT1Aa9G!\u0011\u0011iO!?\u000f\t\t=(Q_\u0007\u0003\u0005cT1Aa=^\u0003\u001diWm]:bO\u0016LAAa>\u0003r\u0006Q\u0012\t\u001c;feB\u000b'\u000f^5uS>t'+Z:q_:\u001cX\rR1uC&!!1 B\u007f\u0005%!v\u000e]5d\t\u0006$\u0018M\u0003\u0003\u0003x\nE\u0018aG7bW\u0016\fE\u000e^3s!\u0006\u0014H/\u001b;j_:$v\u000e]5d\t\u0006$\u0018\r\u0006\u0004\u0003l\u000e\r1q\u0001\u0005\b\u0007\u000by\u0003\u0019AA\u000e\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002Z>\u0002\r!a7\u0002\u0017Q,7\u000f\u001e.l\u0005\u0006\u001c\u0018n\u0019\u0015\u0004a\u0005e\u0016!\u00059beRLG/[8o%\u0016\u001c\bo\u001c8tKRq!qYB\t\u0007'\u0019)b!\u0007\u0004\u001e\r\u0005\u0002\"\u0003B\u000fcA\u0005\t\u0019AA\u000e\u0011%\tI.\rI\u0001\u0002\u0004\tY\u000e\u0003\u0005\u0004\u0018E\u0002\n\u00111\u0001{\u00039\u0001\u0018M\u001d;ji&|g.\u00129pG\"D\u0001ba\u00072!\u0003\u0005\rA_\u0001\tY\u0016\fG-\u001a:JI\"A1qD\u0019\u0011\u0002\u0003\u0007!0A\u0006mK\u0006$WM]#q_\u000eD\u0007\"CB\u0012cA\u0005\t\u0019AB\u0013\u0003\rI7O\u001d\t\u0006\u00057\u001c9C_\u0005\u0005\u0007S\u0011IO\u0001\u0003MSN$\u0018a\u00079beRLG/[8o%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00040)\"\u00111DB\u0019W\t\u0019\u0019\u0004\u0005\u0003\u00046\r}RBAB\u001c\u0015\u0011\u0019Ida\u000f\u0002\u0013Ut7\r[3dW\u0016$'bAB\u001f\r\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r\u00053q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u00079beRLG/[8o%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$#'\u0006\u0002\u0004H)\"\u00111\\B\u0019\u0003m\u0001\u0018M\u001d;ji&|gNU3ta>t7/\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u00111Q\n\u0016\u0004u\u000eE\u0012a\u00079beRLG/[8o%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$C'A\u000eqCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016$C-\u001a4bk2$H%N\u0001\u001ca\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\r]#\u0006BB\u0013\u0007c\t\u0011$\u00117uKJ\u0004\u0016M\u001d;ji&|g.T1oC\u001e,'\u000fV3tiB\u0011Q*O\n\u0003s\u0011#\"aa\u0017\u0015\u0005\r\r\u0004CBB3\u0007_\ni%\u0004\u0002\u0004h)!1\u0011NB6\u0003\u0019\u0019HO]3b[*\u00191Q\u000e+\u0002\tU$\u0018\u000e\\\u0005\u0005\u0007c\u001a9G\u0001\u0004TiJ,\u0017-\u001c\u000b\u0003\u0007k\u0002ba!\u001a\u0004p\r]\u0004\u0003BA/\u0007sJAaa\u001f\u0002`\tI\u0011I]4v[\u0016tGo\u001d")
public class AlterPartitionManagerTest {
    private final String topic;
    private final Uuid topicId = Uuid.randomUuid();
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private BrokerToControllerChannelManager brokerToController;
    private final TopicIdPartition tp0 = new TopicIdPartition(this.topicId(), 0, this.topic());
    private final TopicIdPartition tp1 = new TopicIdPartition(this.topicId(), 1, this.topic());
    private final TopicIdPartition tp2 = new TopicIdPartition(this.topicId(), 2, this.topic());

    public static Stream<Arguments> provideLeaderRecoveryState() {
        return AlterPartitionManagerTest$.MODULE$.provideLeaderRecoveryState();
    }

    public static Stream<MetadataVersion> provideMetadataVersions() {
        return AlterPartitionManagerTest$.MODULE$.provideMetadataVersions();
    }

    public String topic() {
        return this.topic;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(BrokerToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public TopicIdPartition tp0() {
        return this.tp0;
    }

    public TopicIdPartition tp1() {
        return this.tp1;
    }

    public TopicIdPartition tp2() {
        return this.tp2;
    }

    @BeforeEach
    public void setup() {
        this.brokerToController_$eq((BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class));
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testBasic(MetadataVersion metadataVersion) {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @MethodSource(value={"provideLeaderRecoveryState"})
    public void testBasicSentLeaderRecoveryState(MetadataVersion metadataVersion, LeaderRecoveryState leaderRecoveryState) {
        ArgumentCaptor requestCapture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), leaderRecoveryState, 10), 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)requestCapture.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)requestCapture.getValue()).build();
        Assertions.assertEquals((byte)(metadataVersion.isAtLeast(MetadataVersion.IBP_3_2_IV0) ? leaderRecoveryState : LeaderRecoveryState.RECOVERED).value(), (byte)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).leaderRecoveryState());
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testOverwriteWithinBatch(MetadataVersion metadataVersion) {
        boolean canUseTopicIds = metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV0);
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        Assertions.assertFalse((boolean)alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0).isDone());
        CompletableFuture failedSubmitFuture = alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), LeaderRecoveryState.RECOVERED, 10), 0);
        Assertions.assertTrue((boolean)failedSubmitFuture.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)failedSubmitFuture, OperationNotAttemptedException.class);
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(this.tp0(), Errors.NONE, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertFalse((boolean)alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), LeaderRecoveryState.RECOVERED, 10), 0).isDone());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)1);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testSingleBatch(MetadataVersion metadataVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(new TopicIdPartition(this.topicId(), 0, this.topic()), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 9).foreach((Function1 & Serializable)i -> alterPartitionManager.submit(new TopicIdPartition(this.topicId(), BoxesRunTime.unboxToInt((Object)i), this.topic()), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0));
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().size(), (int)10);
    }

    @Test
    public void testSubmitFromCallback() {
        AlterPartitionResponse alterPartitionRespWithPartitionError = this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse errorResponse = this.makeClientResponse(alterPartitionRespWithPartitionError, ApiKeys.ALTER_PARTITION.latestVersion());
        int leaderId = 1;
        int leaderEpoch = 1;
        int partitionEpoch = 10;
        List isr = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(leaderId, leaderEpoch, isr, LeaderRecoveryState.RECOVERED, partitionEpoch);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        CompletableFuture future = alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0);
        CompletableFuture finalFuture = new CompletableFuture();
        future.whenComplete((x$2, e2) -> {
            if (e2 != null) {
                alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0).whenComplete((result, e) -> {
                    if (e != null) {
                        finalFuture.completeExceptionally((Throwable)e);
                        return;
                    }
                    finalFuture.complete(result);
                });
                return;
            }
            finalFuture.completeExceptionally((Throwable)((Object)new AssertionError((Object)"Expected the future to be failed")));
        });
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(errorResponse);
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, partitionEpoch, leaderId, leaderEpoch, (List<Object>)isr);
        ClientResponse retryResponse = this.makeClientResponse(retryAlterPartitionResponse, ApiKeys.ALTER_PARTITION.latestVersion());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertEquals((Object)leaderAndIsr, finalFuture.get(200L, TimeUnit.MILLISECONDS));
        Assertions.assertFalse((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
    }

    @Test
    public void testAuthorizationFailed() {
        this.testRetryOnTopLevelError(Errors.CLUSTER_AUTHORIZATION_FAILED);
    }

    @Test
    public void testStaleBrokerEpoch() {
        this.testRetryOnTopLevelError(Errors.STALE_BROKER_EPOCH);
    }

    @Test
    public void testUnknownServer() {
        this.testRetryOnTopLevelError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void testRetryOnAuthenticationFailure() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, null, new AuthenticationException("authentication failed"), null));
    }

    @Test
    public void testRetryOnUnsupportedVersionError() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, new UnsupportedVersionException("unsupported version"), null, null));
    }

    private void testRetryOnTopLevelError(Errors error) {
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData().setErrorCode(error.code()));
        ClientResponse response = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        this.testRetryOnErrorResponse(response);
    }

    private void testRetryOnErrorResponse(ClientResponse response) {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(response);
        Assertions.assertTrue((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        this.time().sleep(100L);
        scheduler.tick();
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse retryResponse = this.makeClientResponse(retryAlterPartitionResponse, ApiKeys.ALTER_PARTITION.latestVersion());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertFalse((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
    }

    @Test
    public void testInvalidUpdateVersion() {
        this.checkPartitionError(Errors.INVALID_UPDATE_VERSION);
    }

    @Test
    public void testUnknownTopicPartition() {
        this.checkPartitionError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testNotLeaderOrFollower() {
        this.checkPartitionError(Errors.NOT_LEADER_OR_FOLLOWER);
    }

    @Test
    public void testInvalidRequest() {
        this.checkPartitionError(Errors.INVALID_REQUEST);
    }

    private void checkPartitionError(Errors error) {
        Assertions.assertFalse((boolean)this.testPartitionError(this.tp0(), error).submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0).isDone());
    }

    private AlterPartitionManager testPartitionError(TopicIdPartition tp, Errors error) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        CompletableFuture future = alterPartitionManager.submit(tp, new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(tp, error, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, (Class)error.exception().getClass());
        return alterPartitionManager;
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testOneInFlight(MetadataVersion metadataVersion) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        alterPartitionManager.submit(this.tp1(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        alterPartitionManager.submit(this.tp2(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testPartitionMissingInResponse(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isTopicIdsSupported() ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1;
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10);
        int controlledEpoch = 0;
        int brokerEpoch = 2;
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        BrokerToControllerChannelManager brokerToController = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(brokerToController, (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> brokerEpoch, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        CompletableFuture future1 = alterPartitionManager.submit(this.tp0(), leaderAndIsr, controlledEpoch);
        ControllerRequestCompletionHandler callback1 = this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp0()}))), expectedVersion));
        CompletableFuture future2 = alterPartitionManager.submit(this.tp1(), leaderAndIsr, controlledEpoch);
        CompletableFuture future3 = alterPartitionManager.submit(this.tp2(), leaderAndIsr, controlledEpoch);
        callback1.onComplete(this.makeClientResponse(this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future1, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp1(), this.tp2()}))), expectedVersion)).onComplete(this.makeClientResponse(this.partitionResponse(this.tp2(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future3, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp1()}))), expectedVersion)).onComplete(this.makeClientResponse(this.partitionResponse(this.tp1(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future2, UnknownServerException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testPartialTopicIds(MetadataVersion metadataVersion) {
        boolean canUseTopicIds = metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV0);
        TopicIdPartition foo = new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo");
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), 0, "bar");
        TopicIdPartition zar = new TopicIdPartition(Uuid.randomUuid(), 0, "zar");
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10);
        int controlledEpoch = 0;
        int brokerEpoch = 2;
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        BrokerToControllerChannelManager brokerToController = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(brokerToController, (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> brokerEpoch, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        CompletableFuture future1 = alterPartitionManager.submit(zar, leaderAndIsr, controlledEpoch);
        ControllerRequestCompletionHandler callback1 = this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{zar}))), canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1));
        CompletableFuture future2 = alterPartitionManager.submit(foo, leaderAndIsr, controlledEpoch);
        CompletableFuture future3 = alterPartitionManager.submit(bar, leaderAndIsr, controlledEpoch);
        callback1.onComplete(this.makeClientResponse(this.makeAlterPartition((scala.collection.immutable.Seq<AlterPartitionResponseData.TopicData>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterPartitionResponseData.TopicData[]{this.makeAlterPartitionTopicData(zar, Errors.NONE)})))), canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1));
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo, bar}))), (short)1)).onComplete(this.makeClientResponse(this.makeAlterPartition((scala.collection.immutable.Seq<AlterPartitionResponseData.TopicData>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterPartitionResponseData.TopicData[]{this.makeAlterPartitionTopicData(foo, Errors.NONE), this.makeAlterPartitionTopicData(bar, Errors.NONE)})))), (short)1));
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertTrue((boolean)future2.isDone());
        Assertions.assertTrue((boolean)future3.isDone());
    }

    private ControllerRequestCompletionHandler verifySendRequest(BrokerToControllerChannelManager brokerToController, ArgumentMatcher<AbstractRequest.Builder<? extends AbstractRequest>> expectedRequest) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)brokerToController)).sendRequest((AbstractRequest.Builder)ArgumentMatchers.argThat(expectedRequest), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{brokerToController});
        return (ControllerRequestCompletionHandler)callbackCapture.getValue();
    }

    private ArgumentMatcher<AbstractRequest.Builder<? extends AbstractRequest>> alterPartitionRequestMatcher(Set<TopicIdPartition> expectedTopicPartitions, short expectedVersion) {
        return request -> {
            Assertions.assertEquals((Object)ApiKeys.ALTER_PARTITION, (Object)request.apiKey());
            AlterPartitionRequest alterPartitionRequest = (AlterPartitionRequest)((AlterPartitionRequest.Builder)request).build();
            Assertions.assertEquals((short)expectedVersion, (short)alterPartitionRequest.version());
            Set requestTopicPartitions = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(alterPartitionRequest.data().topics()).asScala().flatMap((Function1 & Serializable)topicData -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicData.partitions()).asScala().map((Function1 & Serializable)partitionData -> new TopicIdPartition(topicData.topicId(), partitionData.partitionIndex(), topicData.topicName())))).toSet();
            Set set = expectedTopicPartitions;
            return !(set != null ? !set.equals(requestTopicPartitions) : requestTopicPartitions != null);
        };
    }

    private ClientResponse makeClientResponse(AlterPartitionResponse response, short version) {
        return new ClientResponse(new RequestHeader(response.apiKey(), version, "", 0), null, "", 0L, 0L, false, null, null, (AbstractResponse)AlterPartitionResponse.parse((ByteBuffer)MessageUtil.toByteBuffer((Message)response.data(), (short)version), (short)version));
    }

    private AlterPartitionResponse makeAlterPartition(scala.collection.immutable.Seq<AlterPartitionResponseData.TopicData> topics) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setTopics(CollectionConverters$.MODULE$.SeqHasAsJava(topics).asJava()));
    }

    private AlterPartitionResponseData.TopicData makeAlterPartitionTopicData(TopicIdPartition topicIdPartition, Errors error) {
        return new AlterPartitionResponseData.TopicData().setTopicName(topicIdPartition.topic()).setTopicId(topicIdPartition.topicId()).setPartitions(Collections.singletonList(new AlterPartitionResponseData.PartitionData().setPartitionIndex(topicIdPartition.partition()).setErrorCode(error.code())));
    }

    @Test
    public void testZkBasic() {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        scheduler.startup();
        KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ((KafkaZkClient)Mockito.doAnswer(x$3 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (Option)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.doAnswer(x$4 -> new Tuple2.mcZI.sp(false, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)3), (Option)ArgumentMatchers.any());
        ZkAlterPartitionManager zkIsrManager = new ZkAlterPartitionManager((Scheduler)scheduler, (Time)this.time(), kafkaZkClient);
        zkIsrManager.start();
        CompletableFuture future1 = zkIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 1), 0);
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertEquals((Object)new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 2), future1.get());
        CompletableFuture future2 = zkIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 3), 0);
        Assertions.assertTrue((boolean)future2.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future2, InvalidUpdateVersionException.class);
    }

    private AlterPartitionResponse partitionResponse(TopicIdPartition tp, Errors error, int partitionEpoch, int leaderId, int leaderEpoch, List<Object> isr) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setTopics(Collections.singletonList(new AlterPartitionResponseData.TopicData().setTopicName(tp.topic()).setTopicId(tp.topicId()).setPartitions(Collections.singletonList(new AlterPartitionResponseData.PartitionData().setPartitionIndex(tp.partition()).setPartitionEpoch(partitionEpoch).setLeaderEpoch(leaderEpoch).setLeaderId(leaderId).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)isr.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setErrorCode(error.code()))))));
    }

    private TopicIdPartition partitionResponse$default$1() {
        return this.tp0();
    }

    private Errors partitionResponse$default$2() {
        return Errors.NONE;
    }

    private int partitionResponse$default$3() {
        return 0;
    }

    private int partitionResponse$default$4() {
        return 0;
    }

    private int partitionResponse$default$5() {
        return 0;
    }

    private List<Object> partitionResponse$default$6() {
        return package$.MODULE$.List().empty();
    }

    public AlterPartitionManagerTest() {
        this.topic = "test-topic";
        this.brokerId = 1;
    }
}

