/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.utils.IncludeList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00192Aa\u0001\u0003\u0001\u0013!)\u0001\u0003\u0001C\u0001#!)A\u0003\u0001C\u0001+\tyAk\u001c9jG\u001aKG\u000e^3s)\u0016\u001cHO\u0003\u0002\u0006\r\u0005)Q\u000f^5mg*\tq!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002%A\u00111\u0003A\u0007\u0002\t\u0005\u0001B/Z:u\u0013:\u001cG.\u001e3f\u0019&\u001cHo\u001d\u000b\u0002-A\u00111bF\u0005\u000311\u0011A!\u00168ji\"\u0012!A\u0007\t\u00037\u0011j\u0011\u0001\b\u0006\u0003;y\t1!\u00199j\u0015\ty\u0002%A\u0004kkBLG/\u001a:\u000b\u0005\u0005\u0012\u0013!\u00026v]&$(\"A\u0012\u0002\u0007=\u0014x-\u0003\u0002&9\t!A+Z:u\u0001")
public class TopicFilterTest {
    @Test
    public void testIncludeLists() {
        IncludeList topicFilter1 = new IncludeList("yes1,yes2");
        Assertions.assertTrue((boolean)topicFilter1.isTopicAllowed("yes2", true));
        Assertions.assertTrue((boolean)topicFilter1.isTopicAllowed("yes2", false));
        Assertions.assertFalse((boolean)topicFilter1.isTopicAllowed("no1", true));
        Assertions.assertFalse((boolean)topicFilter1.isTopicAllowed("no1", false));
        IncludeList topicFilter2 = new IncludeList(".+");
        Assertions.assertTrue((boolean)topicFilter2.isTopicAllowed("alltopics", true));
        Assertions.assertFalse((boolean)topicFilter2.isTopicAllowed("__consumer_offsets", true));
        Assertions.assertTrue((boolean)topicFilter2.isTopicAllowed("__consumer_offsets", false));
        IncludeList topicFilter3 = new IncludeList("included-topic.+");
        Assertions.assertTrue((boolean)topicFilter3.isTopicAllowed("included-topic1", true));
        Assertions.assertFalse((boolean)topicFilter3.isTopicAllowed("no1", true));
        IncludeList topicFilter4 = new IncludeList("test-(?!bad\\b)[\\w]+");
        Assertions.assertTrue((boolean)topicFilter4.isTopicAllowed("test-good", true));
        Assertions.assertFalse((boolean)topicFilter4.isTopicAllowed("test-bad", true));
    }
}

