/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.nio.charset.StandardCharsets;
import kafka.security.authorizer.AclEntry$;
import kafka.zk.AclChangeNode;
import kafka.zk.LiteralAclChangeStore$;
import kafka.zk.LiteralAclStore$;
import kafka.zk.ZkAclChangeStore;
import kafka.zk.ZkAclStore;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005E3AAD\b\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003B\u0002\u0018\u0001A\u0003%\u0011\u0005C\u00040\u0001\t\u0007I\u0011\u0002\u0011\t\rA\u0002\u0001\u0015!\u0003\"\u0011\u001d\t\u0004A1A\u0005\nIBaA\u000e\u0001!\u0002\u0013\u0019\u0004\"B\u001c\u0001\t\u0003A\u0004\"B$\u0001\t\u0003A\u0004\"B%\u0001\t\u0003A\u0004\"B&\u0001\t\u0003A\u0004\"B'\u0001\t\u0003A\u0004\"B(\u0001\t\u0003A$a\u0005'ji\u0016\u0014\u0018\r\\!dYN#xN]3UKN$(B\u0001\t\u0012\u0003\tQ8NC\u0001\u0013\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\tq\"A\bmSR,'/\u00197SKN|WO]2f+\u0005\t\u0003C\u0001\u0012-\u001b\u0005\u0019#B\u0001\u0013&\u0003!\u0011Xm]8ve\u000e,'B\u0001\u0014(\u0003\u0019\u0019w.\\7p]*\u0011!\u0003\u000b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014x-\u0003\u0002.G\ty!+Z:pkJ\u001cW\rU1ui\u0016\u0014h.\u0001\tmSR,'/\u00197SKN|WO]2fA\u0005\u0001\u0002O]3gSb,GMU3t_V\u00148-Z\u0001\u0012aJ,g-\u001b=fIJ+7o\\;sG\u0016\u0004\u0013!B:u_J,W#A\u001a\u000f\u0005y!\u0014BA\u001b\u0010\u0003=a\u0015\u000e^3sC2\f5\r\\*u_J,\u0017AB:u_J,\u0007%\u0001\ftQ>,H\u000e\u001a%bm\u0016\u001cuN\u001d:fGR\u0004\u0016\r\u001e5t)\u0005I\u0004C\u0001\f;\u0013\tYtC\u0001\u0003V]&$\bF\u0001\u0005>!\tqT)D\u0001@\u0015\t\u0001\u0015)A\u0002ba&T!AQ\"\u0002\u000f),\b/\u001b;fe*\u0011AIK\u0001\u0006UVt\u0017\u000e^\u0005\u0003\r~\u0012A\u0001V3ti\u0006a2\u000f[8vY\u0012D\u0015M^3D_J\u0014Xm\u0019;QCR$XM\u001d8UsB,\u0007FA\u0005>\u0003\t\u001a\bn\\;mIRC'o\\<Ge>lWI\\2pI\u0016|eNT8oK2KG/\u001a:bY\"\u0012!\"P\u0001!g\"|W\u000f\u001c3Xe&$Xm\u00115b]\u001e,7\u000fV8UQ\u0016<&/\u001b;f!\u0006$\b\u000e\u000b\u0002\f{\u0005I2\u000f[8vY\u0012\u0014v.\u001e8e)JL\u0007o\u00115b]\u001e,gj\u001c3fQ\taQ(A\u0013tQ>,H\u000e\u001a#fG>$WMU3t_V\u00148-Z+tS:<Gk^8QCJ$Hj\\4jG\"\u0012Q\"\u0010")
public class LiteralAclStoreTest {
    private final ResourcePattern literalResource = new ResourcePattern(ResourceType.TOPIC, "some-topic", PatternType.LITERAL);
    private final ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "some-topic", PatternType.PREFIXED);
    private final LiteralAclStore$ store = LiteralAclStore$.MODULE$;

    private ResourcePattern literalResource() {
        return this.literalResource;
    }

    private ResourcePattern prefixedResource() {
        return this.prefixedResource;
    }

    private LiteralAclStore$ store() {
        return this.store;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldHaveCorrectPaths() {
        void path_resourceType;
        Assertions.assertEquals((Object)"/kafka-acl", (Object)this.store().aclPath());
        LiteralAclStore$ literalAclStore$ = this.store();
        ResourceType resourceType = ResourceType.TOPIC;
        if (literalAclStore$ == null) {
            throw null;
        }
        resourceType = null;
        Assertions.assertEquals((Object)"/kafka-acl/Topic", (Object)ZkAclStore.path$((ZkAclStore)literalAclStore$, (ResourceType)path_resourceType));
        if (this.store() == null) {
            throw null;
        }
        Assertions.assertEquals((Object)"/kafka-acl-changes", (Object)LiteralAclChangeStore$.MODULE$.aclChangePath());
    }

    @Test
    public void shouldHaveCorrectPatternType() {
        Assertions.assertEquals((Object)PatternType.LITERAL, (Object)this.store().patternType());
    }

    @Test
    public void shouldThrowFromEncodeOnNoneLiteral() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            if (this.store() == null) {
                throw null;
            }
            ZkAclChangeStore.createChangeNode$((ZkAclChangeStore)LiteralAclChangeStore$.MODULE$, (ResourcePattern)this.prefixedResource());
        });
    }

    @Test
    public void shouldWriteChangesToTheWritePath() {
        AclChangeNode aclChangeNode;
        if (this.store() == null) {
            throw null;
        }
        ResourcePattern createChangeNode_resource = this.literalResource();
        LiteralAclChangeStore$ createChangeNode_this = LiteralAclChangeStore$.MODULE$;
        AclChangeNode aclChangeNode2 = aclChangeNode = ZkAclChangeStore.createChangeNode$((ZkAclChangeStore)createChangeNode_this, (ResourcePattern)createChangeNode_resource);
        Object var2_2 = null;
        Object var3_1 = null;
        aclChangeNode = null;
        AclChangeNode changeNode = aclChangeNode2;
        Assertions.assertEquals((Object)"/kafka-acl-changes/acl_changes_", (Object)changeNode.path());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldRoundTripChangeNode() {
        void createChangeNode_resource;
        AclChangeNode aclChangeNode;
        if (this.store() == null) {
            throw null;
        }
        ResourcePattern resourcePattern = this.literalResource();
        LiteralAclChangeStore$ createChangeNode_this = LiteralAclChangeStore$.MODULE$;
        AclChangeNode aclChangeNode2 = aclChangeNode = ZkAclChangeStore.createChangeNode$((ZkAclChangeStore)createChangeNode_this, (ResourcePattern)createChangeNode_resource);
        Object var3_2 = null;
        resourcePattern = null;
        aclChangeNode = null;
        AclChangeNode changeNode = aclChangeNode2;
        if (this.store() == null) {
            throw null;
        }
        ResourcePattern actual = LiteralAclChangeStore$.MODULE$.decode(changeNode.bytes());
        Assertions.assertEquals((Object)this.literalResource(), (Object)actual);
    }

    @Test
    public void shouldDecodeResourceUsingTwoPartLogic() {
        ResourcePattern resource = new ResourcePattern(ResourceType.GROUP, "PREFIXED:this, including the PREFIXED part, is a valid two part group name", PatternType.LITERAL);
        byte[] encoded = new StringBuilder(0).append(resource.resourceType().toString()).append(AclEntry$.MODULE$.ResourceSeparator()).append(resource.name()).toString().getBytes(StandardCharsets.UTF_8);
        if (this.store() == null) {
            throw null;
        }
        ResourcePattern actual = LiteralAclChangeStore$.MODULE$.decode(encoded);
        Assertions.assertEquals((Object)resource, (Object)actual);
    }
}

