/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\rMg\u0001\u0002 @\u0001\u0011CQ!\u0016\u0001\u0005\u0002YCQ\u0001\u0017\u0001\u0005BeCq\u0001\u001b\u0001C\u0002\u0013%\u0011\u000e\u0003\u0004o\u0001\u0001\u0006IA\u001b\u0005\b_\u0002\u0011\r\u0011\"\u0003q\u0011\u0019!\b\u0001)A\u0005c\"IQ\u000f\u0001a\u0001\u0002\u0004%IA\u001e\u0005\f\u0003\u0017\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0001\u0003\u0006\u0002\u001a\u0001\u0001\r\u0011!Q!\n]D1\"a\u0007\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001e!Y\u0011q\u0007\u0001A\u0002\u0003\u0007I\u0011BA\u001d\u0011-\ti\u0004\u0001a\u0001\u0002\u0003\u0006K!a\b\t\u0017\u0005}\u0002\u00011AA\u0002\u0013%\u0011\u0011\t\u0005\f\u0003'\u0002\u0001\u0019!a\u0001\n\u0013\t)\u0006C\u0006\u0002Z\u0001\u0001\r\u0011!Q!\n\u0005\r\u0003\u0002CA.\u0001\u0001&I!!\u0018\t\u0011\u0005%\u0004\u0001)C\u0005\u0003WB\u0011\"!\u001e\u0001#\u0003%I!a\u001e\t\u000f\u00055\u0005\u0001\"\u0011\u0002\u0010\"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0006bBA_\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003g\u0004A\u0011AA{\u0011\u001d\ty\u0010\u0001C\u0001\u0005\u0003AqAa\u0003\u0001\t\u0003\u0011i\u0001C\u0004\u0003\u0018\u0001!\tA!\u0007\t\u000f\t\r\u0002\u0001\"\u0001\u0003&!9!q\u0006\u0001\u0005\u0002\tE\u0002b\u0002B\u001e\u0001\u0011\u0005!Q\b\u0005\b\u0005\u000f\u0002A\u0011\u0001B%\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0005+BqAa\u0018\u0001\t\u0003\u0011\t\u0007C\u0004\u0003l\u0001!\tA!\u001c\t\u000f\t]\u0004\u0001\"\u0001\u0003z!9!1\u0011\u0001\u0005\u0002\t\u0015\u0005b\u0002BH\u0001\u0011\u0005!\u0011\u0013\u0005\b\u00057\u0003A\u0011\u0001BO\u0011\u001d\u00119\u000b\u0001C\u0001\u0005SCqAa-\u0001\t\u0003\u0011)\fC\u0004\u0003@\u0002!\tA!1\t\u000f\t-\u0007\u0001\"\u0001\u0003N\"9!q\u001b\u0001\u0005\u0002\te\u0007b\u0002Br\u0001\u0011\u0005!Q\u001d\u0005\b\u0005_\u0004A\u0011\u0001By\u0011\u001d\u0011Y\u0010\u0001C\u0001\u0005{Dqaa\u0002\u0001\t\u0003\u0019I\u0001C\u0004\u0004\u0014\u0001!\ta!\u0006\t\u000f\r}\u0001\u0001\"\u0001\u0004\"!911\u0006\u0001\u0005\u0002\r5\u0002bBB\u001c\u0001\u0011\u00051\u0011\b\u0005\b\u0007\u0007\u0002A\u0011AB#\u0011\u001d\u0019y\u0005\u0001C\u0001\u0007#Bqaa\u0017\u0001\t\u0003\u0019i\u0006C\u0004\u0004h\u0001!\ta!\u001b\t\u000f\rM\u0004\u0001\"\u0001\u0004v!91q\u0010\u0001\u0005\u0002\r\u0005\u0005bBBF\u0001\u0011\u00051Q\u0012\u0005\b\u0007/\u0003A\u0011ABM\u0011\u001d\u0019\u0019\u000b\u0001C\u0001\u0007KCqaa,\u0001\t\u0003\u0019\t\fC\u0004\u0004<\u0002!\ta!0\t\u000f\r\u001d\u0007\u0001\"\u0001\u0004J\nYBk\u001c9jG\u000e{W.\\1oI&sG/Z4sCRLwN\u001c+fgRT!\u0001Q!\u0002\u000b\u0005$W.\u001b8\u000b\u0003\t\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u000b.\u000b\u0006C\u0001$J\u001b\u00059%B\u0001%B\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005);%AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0011\u00051{U\"A'\u000b\u00059\u000b\u0015!B;uS2\u001c\u0018B\u0001)N\u0005\u001daunZ4j]\u001e\u0004\"AU*\u000e\u0003}J!\u0001V \u0003\u001bI\u000b7m[!xCJ,G+Z:u\u0003\u0019a\u0014N\\5u}Q\tq\u000b\u0005\u0002S\u0001\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001[!\rY\u0006MY\u0007\u00029*\u0011QLX\u0001\u000bG>dG.Z2uS>t'\"A0\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005d&aA*fcB\u00111MZ\u0007\u0002I*\u0011Q-Q\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u001d$'aC&bM.\f7i\u001c8gS\u001e\fQB\\;n!\u0006\u0014H/\u001b;j_:\u001cX#\u00016\u0011\u0005-dW\"\u00010\n\u00055t&aA%oi\u0006qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0013\u0001\u00073fM\u0006,H\u000e\u001e*fa2L7-\u0019;j_:4\u0015m\u0019;peV\t\u0011\u000f\u0005\u0002le&\u00111O\u0018\u0002\u0006'\"|'\u000f^\u0001\u001aI\u00164\u0017-\u001e7u%\u0016\u0004H.[2bi&|gNR1di>\u0014\b%\u0001\u0007u_BL7mU3sm&\u001cW-F\u0001x!\rA\u0018Q\u0001\b\u0004s\u0006\u0005aB\u0001>\u0000\u001d\tYh0D\u0001}\u0015\ti8)\u0001\u0004=e>|GOP\u0005\u0002\u0005&\u0011\u0001)Q\u0005\u0004\u0003\u0007y\u0014\u0001\u0004+pa&\u001c7i\\7nC:$\u0017\u0002BA\u0004\u0003\u0013\u0011A\u0002V8qS\u000e\u001cVM\u001d<jG\u0016T1!a\u0001@\u0003A!x\u000e]5d'\u0016\u0014h/[2f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0010\u0005U\u0001cA6\u0002\u0012%\u0019\u00111\u00030\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003/A\u0011\u0011!a\u0001o\u0006\u0019\u0001\u0010J\u0019\u0002\u001bQ|\u0007/[2TKJ4\u0018nY3!\u0003-\tG-\\5o\u00072LWM\u001c;\u0016\u0005\u0005}\u0001\u0003BA\u0011\u0003gi!!a\t\u000b\u0007\u0001\u000b)C\u0003\u0003\u0002(\u0005%\u0012aB2mS\u0016tGo\u001d\u0006\u0004\u0005\u0006-\"\u0002BA\u0017\u0003_\ta!\u00199bG\",'BAA\u0019\u0003\ry'oZ\u0005\u0005\u0003k\t\u0019CA\u0003BI6Lg.A\bbI6Lgn\u00117jK:$x\fJ3r)\u0011\ty!a\u000f\t\u0013\u0005]1\"!AA\u0002\u0005}\u0011\u0001D1e[&t7\t\\5f]R\u0004\u0013!\u0004;fgR$v\u000e]5d\u001d\u0006lW-\u0006\u0002\u0002DA!\u0011QIA'\u001d\u0011\t9%!\u0013\u0011\u0005mt\u0016bAA&=\u00061\u0001K]3eK\u001aLA!a\u0014\u0002R\t11\u000b\u001e:j]\u001eT1!a\u0013_\u0003E!Xm\u001d;U_BL7MT1nK~#S-\u001d\u000b\u0005\u0003\u001f\t9\u0006C\u0005\u0002\u00189\t\t\u00111\u0001\u0002D\u0005qA/Z:u)>\u0004\u0018n\u0019(b[\u0016\u0004\u0013AE2sK\u0006$X-\u00118e/\u0006LG\u000fV8qS\u000e$B!a\u0004\u0002`!9\u0011\u0011\r\tA\u0002\u0005\r\u0014\u0001B8qiN\u00042\u0001_A3\u0013\u0011\t9'!\u0003\u0003'Q{\u0007/[2D_6l\u0017M\u001c3PaRLwN\\:\u0002']\f\u0017\u000e\u001e$peR{\u0007/[2De\u0016\fG/\u001a3\u0015\r\u0005=\u0011QNA9\u0011\u001d\ty'\u0005a\u0001\u0003\u0007\n\u0011\u0002^8qS\u000et\u0015-\\3\t\u0011\u0005M\u0014\u0003%AA\u0002)\fq\u0001^5nK>,H/A\u000fxC&$hi\u001c:U_BL7m\u0011:fCR,G\r\n3fM\u0006,H\u000e\u001e\u00133+\t\tIHK\u0002k\u0003wZ#!! \u0011\t\u0005}\u0014\u0011R\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000fs\u0016AC1o]>$\u0018\r^5p]&!\u00111RAA\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0005\u0003\u001f\t\t\nC\u0004\u0002\u0014N\u0001\r!!&\u0002\t%tgm\u001c\t\u0005\u0003/\u000b)+\u0004\u0002\u0002\u001a*!\u00111TAO\u0003\r\t\u0007/\u001b\u0006\u0005\u0003?\u000b\t+A\u0004kkBLG/\u001a:\u000b\t\u0005\r\u0016qF\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003O\u000bIJ\u0001\u0005UKN$\u0018J\u001c4pQ\r\u0019\u00121\u0016\t\u0005\u0003/\u000bi+\u0003\u0003\u00020\u0006e%A\u0003\"fM>\u0014X-R1dQ\u0006)1\r\\8tKR\u0011\u0011q\u0002\u0015\u0004)\u0005]\u0006\u0003BAL\u0003sKA!a/\u0002\u001a\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u000bi\u0016\u001cHo\u0011:fCR,G\u0003BA\b\u0003\u0003Dq!a1\u0016\u0001\u0004\t\u0019%\u0001\u0004rk>\u0014X/\u001c\u0015\b+\u0005\u001d\u0017q[Am!\u0011\tI-a5\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\f\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0005\u0003#\fi*\u0001\u0004qCJ\fWn]\u0005\u0005\u0003+\fYMA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u00037\fy.\t\u0002\u0002^\u0006\u0011!p[\u0011\u0003\u0003C\fQa\u001b:bMRDs!FAs\u0003[\fy\u000f\u0005\u0003\u0002h\u0006%XBAAh\u0013\u0011\tY/a4\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAAy\u0003aYH-[:qY\u0006Lh*Y7f{:\nXo\u001c:v[vZ\b'`\u0001\u0017i\u0016\u001cHo\u0011:fCR,w+\u001b;i\t\u00164\u0017-\u001e7ugR!\u0011qBA|\u0011\u001d\t\u0019M\u0006a\u0001\u0003\u0007BsAFAd\u0003/\fY\u0010\f\u0003\u0002\\\u0006}\u0007f\u0002\f\u0002f\u00065\u0018q^\u0001!i\u0016\u001cHo\u0011:fCR,w+\u001b;i\t\u00164\u0017-\u001e7u%\u0016\u0004H.[2bi&|g\u000e\u0006\u0003\u0002\u0010\t\r\u0001bBAb/\u0001\u0007\u00111\t\u0015\b/\u0005\u001d\u0017q\u001bB\u0004Y\u0011\tY.a8)\u000f]\t)/!<\u0002p\u0006yB/Z:u\u0007J,\u0017\r^3XSRDG)\u001a4bk2$\b+\u0019:uSRLwN\\:\u0015\t\u0005=!q\u0002\u0005\b\u0003\u0007D\u0002\u0019AA\"Q\u001dA\u0012qYAl\u0005'aC!a7\u0002`\":\u0001$!:\u0002n\u0006=\u0018!\u0006;fgR\u001c%/Z1uK^KG\u000f[\"p]\u001aLwm\u001d\u000b\u0005\u0003\u001f\u0011Y\u0002C\u0004\u0002Df\u0001\r!a\u0011)\u000fe\t9-a6\u0003 1\"\u00111\\ApQ\u001dI\u0012Q]Aw\u0003_\f1\u0004^3ti\u000e\u0013X-\u0019;f/\",g.\u00117sK\u0006$\u00170\u0012=jgR\u001cH\u0003BA\b\u0005OAq!a1\u001b\u0001\u0004\t\u0019\u0005K\u0004\u001b\u0003\u000f\f9Na\u000b-\t\u0005m\u0017q\u001c\u0015\b5\u0005\u0015\u0018Q^Ax\u0003)\"Xm\u001d;De\u0016\fG/Z,iK:\fEN]3bIf,\u00050[:ug^KG\u000f[%g\u001d>$X\t_5tiN$B!a\u0004\u00034!9\u00111Y\u000eA\u0002\u0005\r\u0003fB\u000e\u0002H\u0006]'q\u0007\u0017\u0005\u00037\fy\u000eK\u0004\u001c\u0003K\fi/a<\u0002?Q,7\u000f^\"sK\u0006$XmV5uQJ+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0003\u0002\u0010\t}\u0002bBAb9\u0001\u0007\u00111\t\u0015\b9\u0005\u001d\u0017q\u001bB\"Y\u0011\tY.a8)\u000fq\t)/!<\u0002p\u00061C/Z:u\u0007J,\u0017\r^3XSRD\u0017J\u001c<bY&$'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0015\t\u0005=!1\n\u0005\b\u0003\u0007l\u0002\u0019AA\"Q\u001di\u0012qYAl\u0005\u001fbC!a7\u0002`\":Q$!:\u0002n\u0006=\u0018a\n;fgR\u001c%/Z1uK^KG\u000f\u001b(fO\u0006$\u0018N^3SKBd\u0017nY1uS>tg)Y2u_J$B!a\u0004\u0003X!9\u00111\u0019\u0010A\u0002\u0005\r\u0003f\u0002\u0010\u0002H\u0006]'1\f\u0017\u0005\u00037\fy\u000eK\u0004\u001f\u0003K\fi/a<\u0002IQ,7\u000f^\"sK\u0006$XmV5uQ:+w-\u0019;jm\u0016\u0004\u0016M\u001d;ji&|gnQ8v]R$B!a\u0004\u0003d!9\u00111Y\u0010A\u0002\u0005\r\u0003fB\u0010\u0002H\u0006]'q\r\u0017\u0005\u00037\fy\u000eK\u0004 \u0003K\fi/a<\u00027Q,7\u000f^%om\u0006d\u0017\u000e\u001a+pa&\u001cG*\u001a<fY\u000e{gNZ5h)\u0011\tyAa\u001c\t\u000f\u0005\r\u0007\u00051\u0001\u0002D!:\u0001%a2\u0002X\nMD\u0006BAn\u0003?Ds\u0001IAs\u0003[\fy/\u0001\buKN$H*[:u)>\u0004\u0018nY:\u0015\t\u0005=!1\u0010\u0005\b\u0003\u0007\f\u0003\u0019AA\"Q\u001d\t\u0013qYAl\u0005\u007fbC!a7\u0002`\":\u0011%!:\u0002n\u0006=\u0018!\b;fgRd\u0015n\u001d;U_BL7m],ji\"Len\u00197vI\u0016d\u0015n\u001d;\u0015\t\u0005=!q\u0011\u0005\b\u0003\u0007\u0014\u0003\u0019AA\"Q\u001d\u0011\u0013qYAl\u0005\u0017cC!a7\u0002`\":!%!:\u0002n\u0006=\u0018!\t;fgRd\u0015n\u001d;U_BL7m],ji\",\u0005p\u00197vI\u0016Le\u000e^3s]\u0006dG\u0003BA\b\u0005'Cq!a1$\u0001\u0004\t\u0019\u0005K\u0004$\u0003\u000f\f9Na&-\t\u0005m\u0017q\u001c\u0015\bG\u0005\u0015\u0018Q^Ax\u0003]!Xm\u001d;BYR,'\u000fU1si&$\u0018n\u001c8D_VtG\u000f\u0006\u0003\u0002\u0010\t}\u0005bBAbI\u0001\u0007\u00111\t\u0015\bI\u0005\u001d\u0017q\u001bBRY\u0011\tY.a8)\u000f\u0011\n)/!<\u0002p\u0006\u0019B/Z:u\u00032$XM]!tg&<g.\\3oiR!\u0011q\u0002BV\u0011\u001d\t\u0019-\na\u0001\u0003\u0007Bs!JAd\u0003/\u0014y\u000b\f\u0003\u0002\\\u0006}\u0007fB\u0013\u0002f\u00065\u0018q^\u00014i\u0016\u001cH/\u00117uKJ\f5o]5h]6,g\u000e^,ji\"luN]3BgNLwM\\7f]R$\u0006.\u00198QCJ$\u0018\u000e^5p]N$B!a\u0004\u00038\"9\u00111\u0019\u0014A\u0002\u0005\r\u0003f\u0002\u0014\u0002H\u0006]'1\u0018\u0017\u0005\u00037\fy\u000eK\u0004'\u0003K\fi/a<\u0002gQ,7\u000f^!mi\u0016\u0014\u0018i]:jO:lWM\u001c;XSRDWj\u001c:f!\u0006\u0014H/\u001b;j_:\u001cH\u000b[1o\u0003N\u001c\u0018n\u001a8nK:$H\u0003BA\b\u0005\u0007Dq!a1(\u0001\u0004\t\u0019\u0005K\u0004(\u0003\u000f\f9Na2-\t\u0005m\u0017q\u001c\u0015\bO\u0005\u0015\u0018Q^Ax\u0003\t\"Xm\u001d;BYR,'oV5uQ&sg/\u00197jIB\u000b'\u000f^5uS>t7i\\;oiR!\u0011q\u0002Bh\u0011\u001d\t\u0019\r\u000ba\u0001\u0003\u0007Bs\u0001KAd\u0003/\u0014\u0019\u000e\f\u0003\u0002\\\u0006}\u0007f\u0002\u0015\u0002f\u00065\u0018q^\u0001\u001ei\u0016\u001cH/\u00117uKJ<\u0006.\u001a8U_BL7\rR8fg:$X\t_5tiR!\u0011q\u0002Bn\u0011\u001d\t\u0019-\u000ba\u0001\u0003\u0007Bs!KAd\u0003/\u0014y\u000e\f\u0003\u0002\\\u0006}\u0007fB\u0015\u0002f\u00065\u0018q^\u0001*i\u0016\u001cH/\u00117uKJ<\u0006.\u001a8U_BL7\rR8fg:$X\t_5ti^KG\u000f[%g\u000bbL7\u000f^:\u0015\t\u0005=!q\u001d\u0005\b\u0003\u0007T\u0003\u0019AA\"Q\u001dQ\u0013qYAl\u0005WdC!a7\u0002`\":!&!:\u0002n\u0006=\u0018!\t;fgR\u001c%/Z1uK\u0006cG/\u001a:U_BL7mV5uQJ\u000b7m[!xCJ,G\u0003BA\b\u0005gDq!a1,\u0001\u0004\t\u0019\u0005K\u0004,\u0003\u000f\f9Na>-\t\u0005m\u0017q\u001c\u0015\bW\u0005\u0015\u0018Q^Ax\u0003=\"Xm\u001d;D_:4\u0017n\u001a)sKN,'O^1uS>t\u0017i\u0019:pgN\u0004\u0016M\u001d;ji&|g.\u00117uKJ\fG/[8o)\u0011\tyAa@\t\u000f\u0005\rG\u00061\u0001\u0002D!:A&a2\u0002X\u000e\rA\u0006BAn\u0003?Ds\u0001LAs\u0003[\fy/A\tuKN$Hk\u001c9jG\u0012+G.\u001a;j_:$B!a\u0004\u0004\f!9\u00111Y\u0017A\u0002\u0005\r\u0003fB\u0017\u0002H\u0006]7q\u0002\u0017\u0005\u00037\fy\u000eK\u0004.\u0003K\fi/a<\u0002/Q,7\u000f\u001e#fY\u0016$X-\u00138uKJt\u0017\r\u001c+pa&\u001cG\u0003BA\b\u0007/Aq!a1/\u0001\u0004\t\u0019\u0005K\u0004/\u0003\u000f\f9na\u0007-\t\u0005m\u0017q\u001c\u0015\b]\u0005\u0015\u0018Q^Ax\u0003y!Xm\u001d;EK2,G/Z,iK:$v\u000e]5d\t>,7O\u001c;Fq&\u001cH\u000f\u0006\u0003\u0002\u0010\r\r\u0002bBAb_\u0001\u0007\u00111\t\u0015\b_\u0005\u001d\u0017q[B\u0014Y\u0011\tY.a8)\u000f=\n)/!<\u0002p\u0006QC/Z:u\t\u0016dW\r^3XQ\u0016tGk\u001c9jG\u0012{Wm\u001d8u\u000bbL7\u000f^,ji\"Le-\u0012=jgR\u001cH\u0003BA\b\u0007_Aq!a11\u0001\u0004\t\u0019\u0005K\u00041\u0003\u000f\f9na\r-\t\u0005m\u0017q\u001c\u0015\ba\u0005\u0015\u0018Q^Ax\u00031!Xm\u001d;EKN\u001c'/\u001b2f)\u0011\tyaa\u000f\t\u000f\u0005\r\u0017\u00071\u0001\u0002D!:\u0011'a2\u0002X\u000e}B\u0006BAn\u0003?Ds!MAs\u0003[\fy/\u0001\u0011uKN$H)Z:de&\u0014Wm\u00165f]R{\u0007/[2E_\u0016\u001ch\u000e^#ySN$H\u0003BA\b\u0007\u000fBq!a13\u0001\u0004\t\u0019\u0005K\u00043\u0003\u000f\f9na\u0013-\t\u0005m\u0017q\u001c\u0015\be\u0005\u0015\u0018Q^Ax\u00031\"Xm\u001d;EKN\u001c'/\u001b2f/\",g\u000eV8qS\u000e$u.Z:oi\u0016C\u0018n\u001d;XSRD\u0017JZ#ySN$8\u000f\u0006\u0003\u0002\u0010\rM\u0003bBAbg\u0001\u0007\u00111\t\u0015\bg\u0005\u001d\u0017q[B,Y\u0011\tY.a8)\u000fM\n)/!<\u0002p\u0006\tC/Z:u\t\u0016\u001c8M]5cKVs\u0017M^1jY\u0006\u0014G.\u001a)beRLG/[8ogR!\u0011qBB0\u0011\u001d\t\u0019\r\u000ea\u0001\u0003\u0007Bs\u0001NAd\u0003/\u001c\u0019\u0007\f\u0003\u0002\\\u0006}\u0007f\u0002\u001b\u0002f\u00065\u0018q^\u0001&i\u0016\u001cH\u000fR3tGJL'-Z+oI\u0016\u0014(+\u001a9mS\u000e\fG/\u001a3QCJ$\u0018\u000e^5p]N$B!a\u0004\u0004l!9\u00111Y\u001bA\u0002\u0005\r\u0003fB\u001b\u0002H\u0006]7q\u000e\u0017\u0005\u00037\fy\u000eK\u00046\u0003K\fi/a<\u0002CQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3V]\u0012,'/T5o\u0013N\u0014\b+\u0019:uSRLwN\\:\u0015\t\u0005=1q\u000f\u0005\b\u0003\u00074\u0004\u0019AA\"Q\u001d1\u0014qYAl\u0007wbC!a7\u0002`\":a'!:\u0002n\u0006=\u0018!\u0011;fgR$Um]2sS\n,WK\u001c3feJ+\u0007\u000f\\5dCR,G\rU1si&$\u0018n\u001c8t/\",gNU3bgNLwM\\7f]RL5/\u00138Qe><'/Z:t)\u0011\tyaa!\t\u000f\u0005\rw\u00071\u0001\u0002D!:q'a2\u0002X\u000e\u001dE\u0006BAn\u0003?DsaNAs\u0003[\fy/\u0001\u0010uKN$H)Z:de&\u0014W-\u0011;NS:L5O\u001d)beRLG/[8ogR!\u0011qBBH\u0011\u001d\t\u0019\r\u000fa\u0001\u0003\u0007Bs\u0001OAd\u0003/\u001c\u0019\n\f\u0003\u0002\\\u0006}\u0007f\u0002\u001d\u0002f\u00065\u0018q^\u0001'i\u0016\u001cH\u000fR3tGJL'-Z+oI\u0016\u0014X*\u001b8JgJ\u0004\u0016M\u001d;ji&|gn]'jq\u0016$G\u0003BA\b\u00077Cq!a1:\u0001\u0004\t\u0019\u0005K\u0004:\u0003\u000f\f9na(-\t\u0005m\u0017q\u001c\u0015\bs\u0005\u0015\u0018Q^Ax\u0003\r\"Xm\u001d;EKN\u001c'/\u001b2f%\u0016\u0004xN\u001d;Pm\u0016\u0014(/\u001b3eK:\u001cuN\u001c4jON$B!a\u0004\u0004(\"9\u00111\u0019\u001eA\u0002\u0005\r\u0003f\u0002\u001e\u0002H\u0006]71\u0016\u0017\u0005\u00037\fy\u000eK\u0004;\u0003K\fi/a<\u0002]Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3B]\u0012d\u0015n\u001d;U_BL7m],ji\"|W\u000f^%oi\u0016\u0014h.\u00197U_BL7m\u001d\u000b\u0005\u0003\u001f\u0019\u0019\fC\u0004\u0002Dn\u0002\r!a\u0011)\u000fm\n9-a6\u000482\"\u00111\\ApQ\u001dY\u0014Q]Aw\u0003_\fA\b^3ti\u0012+7o\u0019:jE\u0016$u.Z:O_R4\u0015-\u001b7XQ\u0016tG*[:uS:<'+Z1tg&<g.\\3oi&\u001bXK\\1vi\"|'/\u001b>fIR!\u0011qBB`\u0011\u001d\t\u0019\r\u0010a\u0001\u0003\u0007Bs\u0001PAd\u0003/\u001c\u0019\r\f\u0003\u0002\\\u0006}\u0007f\u0002\u001f\u0002f\u00065\u0018q^\u0001!i\u0016\u001cHo\u0011:fCR,w+\u001b;i)>\u0004\u0018n\u0019(b[\u0016\u001cu\u000e\u001c7jg&|g\u000e\u0006\u0003\u0002\u0010\r-\u0007bBAb{\u0001\u0007\u00111\t\u0015\b{\u0005\u001d\u0017q[BhY\u0011\tY.a8)\u000fu\n)/!<\u0002p\u0002")
public class TopicCommandIntegrationTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private final int numPartitions;
    private final short defaultReplicationFactor = (short)1;
    private TopicCommand.TopicService topicService;
    private Admin adminClient;
    private String testTopicName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        String x$2 = this.zkConnectOrNull();
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int x$4 = this.numPartitions();
        short x$5 = this.defaultReplicationFactor();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$8 = none$4;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$9 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$10 = none$6;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = 1;
        boolean bl7 = false;
        int n2 = 0;
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(6, x$2, bl, bl2, (Option<SecurityProtocol>)x$8, (Option<File>)x$9, (Option<Properties>)x$10, bl3, bl4, bl5, bl6, (Map<Object, String>)x$3, n, bl7, x$4, x$5, n2).map((Function1 & Serializable)props -> {
            props.put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), "1");
            return KafkaConfig$.MODULE$.fromProps(props);
        });
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    private TopicCommand.TopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.TopicService x$1) {
        this.topicService = x$1;
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private void createAndWaitTopic(TopicCommand.TopicCommandOptions opts) {
        this.topicService().createTopic(opts);
        this.waitForTopicCreated((String)opts.topic().get(), 10000);
    }

    private void waitForTopicCreated(String topicName, int timeout) {
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), topicName, 0, timeout);
    }

    private int waitForTopicCreated$default$2() {
        return 10000;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo info) {
        super.setUp(info);
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.adminClient_$eq(Admin.create((Properties)props));
        Admin apply_adminClient = this.adminClient();
        Object var3_3 = null;
        this.topicService_$eq(new TopicCommand.TopicService(apply_adminClient));
        this.testTopicName_$eq(new StringBuilder(1).append(((Method)info.getTestMethod().get()).getName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @AfterEach
    public void close() {
        if (this.topicService() != null) {
            this.topicService().close();
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreate(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()}));
        ((java.util.Set)this.adminClient().listTopics().names().get()).contains(this.testTopicName());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithDefaults(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)this.numPartitions());
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)this.defaultReplicationFactor());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithDefaultReplication(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "2"}));
        List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)2);
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)this.defaultReplicationFactor());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithDefaultPartitions(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replication-factor", "2"}));
        List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)this.numPartitions());
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)2);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithConfigs(String quorum) {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", "delete.retention.ms=1000"}));
        Config configs = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertEquals((int)1000, (Integer)Integer.valueOf(configs.get("delete.retention.ms").value()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWhenAlreadyExists(String quorum) {
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", "1", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        Assertions.assertThrows(TopicExistsException.class, () -> this.topicService().createTopic(createOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWhenAlreadyExistsWithIfNotExists(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-not-exists"});
        this.createAndWaitTopic(createOpts);
        this.topicService().createTopic(createOpts);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithReplicaAssignment(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)3, (int)partitions.size());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)partitions.get(0)).replicas()).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id())));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)partitions.get(1)).replicas()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id())));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)partitions.get(2)).replicas()).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithInvalidReplicationFactor(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", Integer.toString(32768), "--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithNegativeReplicationFactor(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithNegativePartitionCount(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidTopicLevelConfig(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"});
        Assertions.assertThrows(ConfigException.class, () -> this.topicService().createTopic(createOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListTopics(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var2_2 = null;
        Object var3_3 = null;
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(this.testTopicName()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListTopicsWithIncludeList(String quorum) {
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic1, 2, (short)2), new NewTopic(topic2, 2, (short)2), new NewTopic(topic3, 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, 10000);
        this.waitForTopicCreated(topic2, 10000);
        this.waitForTopicCreated(topic3, 10000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--topic", "kafka.*"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var6_5 = null;
        Object var7_6 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)output.contains(topic1));
        Assertions.assertTrue((boolean)output.contains(topic2));
        Assertions.assertFalse((boolean)output.contains(topic3));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListTopicsWithExcludeInternal(String quorum) {
        String topic1 = "kafka.testTopic1";
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic1, 2, (short)2), new NewTopic("__consumer_offsets", 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, 10000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var4_3 = null;
        Object var5_4 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)output.contains(topic1));
        Assertions.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterPartitionCount(String quorum) {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.testTopicName(), 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "3"}));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testAlterPartitionCount$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timeout waiting for new assignment propagating to broker");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Assertions.assertTrue((((TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).topicNameValues().get(this.testTopicName())).get()).partitions().size() == 3 ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterAssignment(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"}));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testAlterAssignment$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timeout waiting for new assignment propagating to broker");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).topicNameValues().get(this.testTopicName())).get();
        Assertions.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterAssignmentWithMoreAssignmentThanPartitions(String quorum) {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.testTopicName(), 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2,3:2", "--partitions", "3"})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterAssignmentWithMorePartitionsThanAssignment(String quorum) {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.testTopicName(), 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "6"})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterWithInvalidPartitionCount(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterWhenTopicDoesntExist(String quorum) {
        TopicCommand.TopicService topicService;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "1"});
        Admin apply_adminClient = this.adminClient();
        TopicCommand.TopicService topicService2 = topicService = new TopicCommand.TopicService(apply_adminClient);
        Object var4_3 = null;
        topicService = null;
        TopicCommand.TopicService topicService3 = topicService2;
        Assertions.assertThrows(IllegalArgumentException.class, () -> topicService3.alterTopic(alterOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterWhenTopicDoesntExistWithIfExists(String quorum) {
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "1", "--if-exists"}));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateAlterTopicWithRackAware(String quorum) {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", Integer.toString(replicationFactor), "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        scala.collection.immutable.Map assignment = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions()).asScala().map((Function1 & Serializable)info -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)info.partition())), CollectionConverters$.MODULE$.ListHasAsScala(info.replicas()).asScala().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(alteredNumPartitions), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testCreateAlterTopicWithRackAware$3(this, alteredNumPartitions)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timeout waiting for new assignment propagating to broker");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        assignment = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions()).asScala().map((Function1 & Serializable)info -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)info.partition())), CollectionConverters$.MODULE$.ListHasAsScala(info.replicas()).asScala().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.id()))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConfigPreservationAcrossPartitionAlteration(String quorum) {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        Config props = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertNotNull((Object)props.get(cleanupKey), (String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString());
        Assertions.assertEquals((Object)cleanupVal, (Object)props.get(cleanupKey).value(), (String)"Properties after creation have incorrect value");
        if (!this.isKRaftTest()) {
            this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        }
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitionsModified), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        Config newProps = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertNotNull((Object)newProps.get(cleanupKey), (String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString());
        Assertions.assertEquals((Object)cleanupVal, (Object)newProps.get(cleanupKey).value(), (String)"Updated properties have incorrect value");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicDeletion(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        if (!this.isKRaftTest()) {
            String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
            Assertions.assertFalse((boolean)this.zkClient().pathExists(deletePath), (String)"Delete path for topic shouldn't exist before deletion.");
        }
        this.topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), this.testTopicName(), 1, this.brokers());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteInternalTopic(String quorum) {
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"});
        this.createAndWaitTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", "__consumer_offsets"});
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        if (!this.isKRaftTest()) {
            Assertions.assertFalse((boolean)this.zkClient().pathExists(deleteOffsetTopicPath), (String)"Delete path for topic shouldn't exist before deletion.");
        }
        this.topicService().deleteTopic(deleteOffsetTopicOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), "__consumer_offsets", 1, this.brokers());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteWhenTopicDoesntExist(String quorum) {
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().deleteTopic(deleteOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteWhenTopicDoesntExistWithIfExists(String quorum) {
        this.topicService().deleteTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-exists"}));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribe(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_2 = null;
        Object var4_3 = null;
        Object[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((int)3, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(rows)));
        Assertions.assertTrue((boolean)((String)rows[0]).startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeWhenTopicDoesntExist(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeWhenTopicDoesntExistWithIfExists(String quorum) {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-exists"}));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnavailablePartitions(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 6, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            TopicDescription testTopicDescription = (TopicDescription)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).asScala().apply((Object)this.testTopicName());
            int partitionOnBroker0 = ((TopicPartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(testTopicDescription.partitions()).asScala().find((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$1(x$13))).get()).partition();
            this.killBroker(0);
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$2(this, partitionOnBroker0)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$7(this));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--unavailable-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var8_7 = null;
            Object var9_8 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assertions.assertTrue((boolean)rows[0].contains("Leader: none\tReplicas: 0\tIsr:"));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderReplicatedPartitions(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            this.killBroker(0);
            if (this.isKRaftTest()) {
                this.ensureConsistentKRaftMetadata();
            } else {
                TestUtils$.MODULE$.waitForPartitionMetadata(this.aliveBrokers(), this.testTopicName(), 0, 15000L);
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-replicated-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var4_2 = null;
            Object var5_3 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()), (String)new StringBuilder(19).append("Unexpected output: ").append(rows[0]).toString());
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderMinIsrPartitions(String quorum) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            this.killBroker(0);
            if (this.isKRaftTest()) {
                this.ensureConsistentKRaftMetadata();
            } else {
                long l = 15000L;
                long l2 = 100L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitions$1(this)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                        Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitions$3(this));
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
                }
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var6_6 = null;
            Object var7_7 = null;
            Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress(String quorum) {
        String string;
        HashMap configMap = new HashMap();
        short replicationFactor = 1;
        int partitions = 1;
        TopicPartition tp = new TopicPartition(this.testTopicName(), 0);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), partitions, replicationFactor).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.testTopicName(), 10, -1);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.testTopicName(), 10, -1);
        Buffer brokerIds = (Buffer)this.brokers().map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(x$18)));
        TestUtils$.MODULE$.setReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 1);
        TopicDescription testTopicDesc = (TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singleton(this.testTopicName())).allTopicNames().get()).get(this.testTopicName());
        TopicPartitionInfo firstPartition = (TopicPartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(testTopicDesc.partitions()).asScala().head();
        Buffer replicasOfFirstPartition = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(firstPartition.replicas()).asScala().map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.id()));
        int targetReplica = BoxesRunTime.unboxToInt((Object)((IterableOps)brokerIds.diff((Seq)replicasOfFirstPartition)).head());
        this.adminClient().alterPartitionReassignments(Collections.singletonMap(tp, Optional.of(new NewPartitionReassignment(Collections.singletonList(Predef$.MODULE$.int2Integer(targetReplica)))))).all().get();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(this, tp)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Reassignment didn't add the second node");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var16_14 = null;
        Object var17_15 = null;
        Object[] simpleDescribeOutputRows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertTrue((boolean)simpleDescribeOutputRows[0].startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
        Assertions.assertEquals((int)2, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(simpleDescribeOutputRows)));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-replicated-partitions"}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = string = grabConsoleOutput_out2.toString();
        Object var19_18 = null;
        Object var20_19 = null;
        string = null;
        String underReplicatedOutput = string2;
        Assertions.assertEquals((Object)"", (Object)underReplicatedOutput, (String)new StringBuilder(59).append("--under-replicated-partitions shouldn't return anything: '").append(underReplicatedOutput).append("'").toString());
        PartitionReassignment reassignments = (PartitionReassignment)((java.util.Map)this.adminClient().listPartitionReassignments(Collections.singleton(tp)).reassignments().get()).get(tp);
        Assertions.assertFalse((boolean)Option$.MODULE$.apply((Object)reassignments).forall((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(x$20))));
        TestUtils$.MODULE$.removeReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))));
        TestUtils$.MODULE$.waitForAllReassignmentsToComplete(this.adminClient(), 100L);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeAtMinIsrPartitions(String quorum) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "4");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            this.killBroker(0);
            this.killBroker(1);
            if (this.isKRaftTest()) {
                this.ensureConsistentKRaftMetadata();
            } else {
                long l = 15000L;
                long l2 = 100L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TopicCommandIntegrationTest.$anonfun$testDescribeAtMinIsrPartitions$1(this)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                        Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeAtMinIsrPartitions$3(this));
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
                }
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--at-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var7_6 = null;
            Object var8_7 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assertions.assertEquals((int)1, (int)rows.length);
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderMinIsrPartitionsMixed(String quorum) {
        String underMinIsrTopic = "under-min-isr-topic";
        String notUnderMinIsrTopic = "not-under-min-isr-topic";
        String offlineTopic = "offline-topic";
        String fullyReplicatedTopic = "fully-replicated-topic";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Arrays.asList(new NewTopic(underMinIsrTopic, 1, (short)6).configs(configMap), new NewTopic(notUnderMinIsrTopic, 1, (short)6), new NewTopic(offlineTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Collections.singletonList(Predef$.MODULE$.int2Integer(0)))), new NewTopic(fullyReplicatedTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)))))).all().get();
        this.waitForTopicCreated(underMinIsrTopic, 10000);
        this.waitForTopicCreated(notUnderMinIsrTopic, 10000);
        this.waitForTopicCreated(offlineTopic, 10000);
        this.waitForTopicCreated(fullyReplicatedTopic, 10000);
        try {
            this.killBroker(0);
            if (this.isKRaftTest()) {
                this.ensureConsistentKRaftMetadata();
            } else {
                long l = 15000L;
                long l2 = 100L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$1(this, underMinIsrTopic, offlineTopic)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                        Assertions.fail((String)"Timeout waiting for partition metadata propagating to brokers for underMinIsrTopic topic");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
                }
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var11_10 = null;
            Object var12_11 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(underMinIsrTopic).toString()));
            Assertions.assertTrue((boolean)rows[1].startsWith(new StringBuilder(8).append("\tTopic: ").append(offlineTopic).toString()));
            Assertions.assertEquals((int)2, (int)rows.length);
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeReportOverriddenConfigs(String quorum) {
        String config = "file.delete.delay.ms=1000";
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", config}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_3 = null;
        Object var4_4 = null;
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(config), (String)new StringBuilder(38).append("Describe output should have contained ").append(config).toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeAndListTopicsWithoutInternalTopics(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--describe", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_2 = null;
        Object var4_3 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)output.contains(this.testTopicName()), (String)new StringBuilder(29).append("Output should have contained ").append(this.testTopicName()).toString());
        Assertions.assertFalse((boolean)output.contains("__consumer_offsets"));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--list", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var6_6 = null;
        Object var7_7 = null;
        output = grabConsoleOutput_out2.toString();
        Assertions.assertTrue((boolean)output.contains(this.testTopicName()));
        Assertions.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeDoesNotFailWhenListingReassignmentIsUnauthorized(String quorum) {
        this.adminClient_$eq((Admin)Mockito.spy((Object)this.adminClient()));
        Admin apply_adminClient = this.adminClient();
        Object var6_2 = null;
        this.topicService_$eq(new TopicCommand.TopicService(apply_adminClient));
        ((Admin)Mockito.doReturn((Object)AdminClientTestUtils.listPartitionReassignmentsResult((Throwable)new ClusterAuthorizationException("Unauthorized")), (Object[])new Object[]{null}).when((Object)this.adminClient())).listPartitionReassignments(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.testTopicName(), 0)}))).asJava());
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_3 = null;
        Object var4_4 = null;
        Object[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((int)2, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(rows)));
        Assertions.assertTrue((boolean)((String)rows[0]).startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithTopicNameCollision(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic("foo_bar", 1, (short)6))).all().get();
        this.waitForTopicCreated("foo_bar", 10000);
        Assertions.assertThrows(InvalidTopicException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", "foo.bar"})));
    }

    public static final /* synthetic */ boolean $anonfun$testAlterPartitionCount$2(TopicCommandIntegrationTest $this, KafkaBroker x$7) {
        return x$7.metadataCache().getTopicPartitions($this.testTopicName()).size() == 3;
    }

    public static final /* synthetic */ boolean $anonfun$testAlterPartitionCount$1(TopicCommandIntegrationTest $this) {
        return $this.brokers().forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testAlterPartitionCount$2($this, x$7)));
    }

    public static final /* synthetic */ String $anonfun$testAlterPartitionCount$3() {
        return "Timeout waiting for new assignment propagating to broker";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAssignment$2(TopicCommandIntegrationTest $this, KafkaBroker x$8) {
        return x$8.metadataCache().getTopicPartitions($this.testTopicName()).size() == 3;
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAssignment$1(TopicCommandIntegrationTest $this) {
        return $this.brokers().forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testAlterAssignment$2($this, x$8)));
    }

    public static final /* synthetic */ String $anonfun$testAlterAssignment$3() {
        return "Timeout waiting for new assignment propagating to broker";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAlterTopicWithRackAware$4(TopicCommandIntegrationTest $this, int alteredNumPartitions$1, KafkaBroker x$11) {
        return x$11.metadataCache().getTopicPartitions($this.testTopicName()).size() == alteredNumPartitions$1;
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAlterTopicWithRackAware$3(TopicCommandIntegrationTest $this, int alteredNumPartitions$1) {
        return $this.brokers().forall((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testCreateAlterTopicWithRackAware$4($this, alteredNumPartitions$1, x$11)));
    }

    public static final /* synthetic */ String $anonfun$testCreateAlterTopicWithRackAware$5() {
        return "Timeout waiting for new assignment propagating to broker";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$1(TopicPartitionInfo x$13) {
        return x$13.leader().id() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$3(KafkaBroker x$14) {
        return x$14.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$5(TopicCommandIntegrationTest $this, MetadataResponseData.MetadataResponseTopic x$15) {
        return x$15.name().equals($this.testTopicName());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$6(int partitionOnBroker0$1, MetadataResponseData.MetadataResponsePartition x$16) {
        return x$16.partitionIndex() == partitionOnBroker0$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$4(TopicCommandIntegrationTest $this, int partitionOnBroker0$1, boolean result, KafkaBroker server) {
        boolean x$4;
        boolean x$3;
        ListenerName x$2;
        scala.collection.immutable.Set x$1;
        MetadataCache qual$1 = server.dataPlaneRequestProcessor().metadataCache();
        Seq topicMetadatas = qual$1.getTopicMetadata((Set)(x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.testTopicName()}))), x$2 = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), x$3 = qual$1.getTopicMetadata$default$3(), x$4 = qual$1.getTopicMetadata$default$4());
        Option testPartitionMetadata = CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponseData.MetadataResponseTopic)topicMetadatas.find((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$5($this, x$15))).get()).partitions()).asScala().find((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$6(partitionOnBroker0$1, x$16)));
        if (None$.MODULE$.equals(testPartitionMetadata)) {
            throw new AssertionError((Object)"Partition metadata is not found in metadata cache");
        }
        if (!(testPartitionMetadata instanceof Some)) {
            throw new MatchError((Object)testPartitionMetadata);
        }
        MetadataResponseData.MetadataResponsePartition metadata = (MetadataResponseData.MetadataResponsePartition)((Some)testPartitionMetadata).value();
        boolean bl = result && metadata.errorCode() == Errors.LEADER_NOT_AVAILABLE.code();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$2(TopicCommandIntegrationTest $this, int partitionOnBroker0$1) {
        return BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)$this.brokers().filterNot((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$3(x$14)))).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable)(result, server) -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$4($this, partitionOnBroker0$1, BoxesRunTime.unboxToBoolean((Object)result), server))));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnavailablePartitions$7(TopicCommandIntegrationTest $this) {
        return new StringBuilder(41).append("Partition metadata for ").append($this.testTopicName()).append(" is not propagated").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$2(TopicCommandIntegrationTest $this, KafkaBroker x$17) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$17.metadataCache().getPartitionInfo($this.testTopicName(), 0).get()).isr().size() == 5;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$1(TopicCommandIntegrationTest $this) {
        return $this.aliveBrokers().forall((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitions$2($this, x$17)));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderMinIsrPartitions$3(TopicCommandIntegrationTest $this) {
        return new StringBuilder(72).append("Timeout waiting for partition metadata propagating to brokers for ").append($this.testTopicName()).append(" topic").toString();
    }

    public static final /* synthetic */ int $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(KafkaBroker x$18) {
        return x$18.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(TopicCommandIntegrationTest $this, TopicPartition tp$1) {
        return !((PartitionReassignment)((java.util.Map)$this.adminClient().listPartitionReassignments(Collections.singleton(tp$1)).reassignments().get()).get(tp$1)).addingReplicas().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$4() {
        return "Reassignment didn't add the second node";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(PartitionReassignment x$20) {
        return x$20.addingReplicas().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeAtMinIsrPartitions$2(TopicCommandIntegrationTest $this, KafkaBroker x$21) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$21.metadataCache().getPartitionInfo($this.testTopicName(), 0).get()).isr().size() == 4;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeAtMinIsrPartitions$1(TopicCommandIntegrationTest $this) {
        return $this.aliveBrokers().forall((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeAtMinIsrPartitions$2($this, x$21)));
    }

    public static final /* synthetic */ String $anonfun$testDescribeAtMinIsrPartitions$3(TopicCommandIntegrationTest $this) {
        return new StringBuilder(72).append("Timeout waiting for partition metadata propagating to brokers for ").append($this.testTopicName()).append(" topic").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$2(String underMinIsrTopic$1, String offlineTopic$1, KafkaBroker broker) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)broker.metadataCache().getPartitionInfo(underMinIsrTopic$1, 0).get()).isr().size() < 6 && ((UpdateMetadataRequestData.UpdateMetadataPartitionState)broker.metadataCache().getPartitionInfo(offlineTopic$1, 0).get()).leader() == -1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$1(TopicCommandIntegrationTest $this, String underMinIsrTopic$1, String offlineTopic$1) {
        return $this.aliveBrokers().forall((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$2(underMinIsrTopic$1, offlineTopic$1, broker)));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderMinIsrPartitionsMixed$3() {
        return "Timeout waiting for partition metadata propagating to brokers for underMinIsrTopic topic";
    }

    public TopicCommandIntegrationTest() {
        this.numPartitions = 1;
    }
}

