/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kafka.log.AppendOrigin;
import kafka.log.ClientRecordDeletion$;
import kafka.log.LoadedLogOffsets;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleanerManagerTest;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogToClean;
import kafka.log.OffsetsToClean;
import kafka.log.ProducerStateManager;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r%b\u0001\u0002'N\u0001ICQa\u0018\u0001\u0005\u0002\u0001Dqa\u0019\u0001C\u0002\u0013\u0005A\r\u0003\u0004n\u0001\u0001\u0006I!\u001a\u0005\b]\u0002\u0011\r\u0011\"\u0001e\u0011\u0019y\u0007\u0001)A\u0005K\"9\u0001\u000f\u0001b\u0001\n\u0003!\u0007BB9\u0001A\u0003%Q\rC\u0004s\u0001\t\u0007I\u0011\u00013\t\rM\u0004\u0001\u0015!\u0003f\u0011\u001d!\bA1A\u0005\u0002UDq!a\u0001\u0001A\u0003%a\u000f\u0003\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0001v\u0011\u001d\t9\u0001\u0001Q\u0001\nYD\u0011\"!\u0003\u0001\u0005\u0004%\t!a\u0003\t\u0011\u0005e\u0001\u0001)A\u0005\u0003\u001bA\u0011\"a\u0007\u0001\u0005\u0004%\t!!\b\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003?A\u0011\"a\n\u0001\u0005\u0004%\t!!\u000b\t\u0011\u0005E\u0002\u0001)A\u0005\u0003WA\u0011\"a\r\u0001\u0005\u0004%\t!!\u000e\t\u0011\u0005u\u0002\u0001)A\u0005\u0003oA\u0011\"a\u0010\u0001\u0005\u0004%\t!!\u0011\t\u0011\u0005e\u0003\u0001)A\u0005\u0003\u00072a!a\u0017\u0001\u0001\u0005u\u0003\u0002DA31\t\u0005\t\u0015!\u0003\u0002h\u0005}\u0004\u0002DAA1\t\u0005\t\u0015!\u0003\u0002\u0004\u0006=\u0005\u0002DAI1\t\u0005\t\u0015!\u0003\u0002\u0014\u0006}\u0005BB0\u0019\t\u0003\t\t\u000bC\u0004\u0002.b!\t%a,\t\u000f\u0005}\u0006\u0004\"\u0011\u0002B\"I\u00111\u001d\r\u0012\u0002\u0013\u0005\u0011Q\u001d\u0005\n\u0003wD\u0012\u0013!C\u0001\u0003{DqA!\u0001\u0001\t\u0003\u0011\u0019\u0001C\u0004\u0003\u001c\u0001!IA!\b\t\u000f\t5\u0002\u0001\"\u0001\u0003\u0004!9!q\u0007\u0001\u0005\u0002\t\r\u0001b\u0002B\u001e\u0001\u0011\u0005!1\u0001\u0005\b\u0005\u007f\u0001A\u0011\u0001B\u0002\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0005\u0007AqAa\u0012\u0001\t\u0003\u0011\u0019\u0001C\u0004\u0003L\u0001!\tAa\u0001\t\u000f\t=\u0003\u0001\"\u0001\u0003\u0004!9!1\u000b\u0001\u0005\u0002\t\r\u0001b\u0002B,\u0001\u0011\u0005!1\u0001\u0005\b\u00057\u0002A\u0011\u0001B\u0002\u0011\u001d\u0011y\u0006\u0001C\u0001\u0005\u0007AqAa\u0019\u0001\t\u0003\u0011\u0019\u0001C\u0004\u0003h\u0001!\tAa\u0001\t\u000f\t-\u0004\u0001\"\u0001\u0003\u0004!9!q\u000e\u0001\u0005\u0002\t\r\u0001b\u0002B:\u0001\u0011\u0005!1\u0001\u0005\b\u0005o\u0002A\u0011\u0001B\u0002\u0011\u001d\u0011Y\b\u0001C\u0001\u0005\u0007AqAa \u0001\t\u0003\u0011\u0019\u0001C\u0004\u0003\u0004\u0002!\tAa\u0001\t\u000f\t\u001d\u0005\u0001\"\u0001\u0003\u0004!9!1\u0012\u0001\u0005\u0002\t\r\u0001b\u0002BH\u0001\u0011\u0005!1\u0001\u0005\b\u0005'\u0003A\u0011\u0001B\u0002\u0011\u001d\u00119\n\u0001C\u0001\u0005\u0007AqAa'\u0001\t\u0003\u0011\u0019\u0001C\u0004\u0003 \u0002!\tAa\u0001\t\u000f\t\r\u0006\u0001\"\u0001\u0003\u0004!9!q\u0015\u0001\u0005\u0002\t\r\u0001b\u0002BV\u0001\u0011\u0005!1\u0001\u0005\b\u0005_\u0003A\u0011\u0002BY\u0011\u001d\u0011)\f\u0001C\u0005\u0005oCqA!0\u0001\t\u0013\u0011y\fC\u0005\u0003R\u0002\t\n\u0011\"\u0003\u0003T\"9!q\u001b\u0001\u0005\n\te\u0007b\u0002Bp\u0001\u0011%!\u0011\u001d\u0005\b\u0005c\u0004A\u0011\u0002Bz\u0011\u001d\u0011Y\u0010\u0001C\u0005\u0005{D\u0011ba\u0002\u0001#\u0003%Ia!\u0003\t\u000f\r5\u0001\u0001\"\u0003\u0004\u0010\t)Bj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:UKN$(B\u0001(P\u0003\rawn\u001a\u0006\u0002!\u0006)1.\u00194lC\u000e\u00011c\u0001\u0001T3B\u0011AkV\u0007\u0002+*\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\n1\u0011I\\=SK\u001a\u0004\"AW/\u000e\u0003mS!\u0001X(\u0002\u000bU$\u0018\u000e\\:\n\u0005y[&a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0004\"A\u0019\u0001\u000e\u00035\u000ba\u0001^7q\t&\u0014X#A3\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017AA5p\u0015\u0005Q\u0017\u0001\u00026bm\u0006L!\u0001\\4\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003\u001d!X\u000e\u001d#jeJ\n\u0001\u0002^7q\t&\u0014(\u0007I\u0001\u0007Y><G)\u001b:\u0002\u000f1|w\rR5sA\u00059An\\4ESJ\u0014\u0014\u0001\u00037pO\u0012K'O\r\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\ta\u000f\u0005\u0002x\u007f6\t\u0001P\u0003\u0002zu\u000611m\\7n_:T!\u0001U>\u000b\u0005ql\u0018AB1qC\u000eDWMC\u0001\u007f\u0003\ry'oZ\u0005\u0004\u0003\u0003A(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t''\u0001\tu_BL7\rU1si&$\u0018n\u001c83A\u0005AAn\\4Qe>\u00048/\u0006\u0002\u0002\u000eA!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014%\fA!\u001e;jY&!\u0011qCA\t\u0005)\u0001&o\u001c9feRLWm]\u0001\nY><\u0007K]8qg\u0002\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u0005\u0005}\u0001c\u00012\u0002\"%\u0019\u00111E'\u0003\u00131{wmQ8oM&<\u0017A\u00037pO\u000e{gNZ5hA\u0005!A/[7f+\t\tY\u0003E\u0002[\u0003[I1!a\f\\\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013AB8gMN,G/\u0006\u0002\u00028A\u0019A+!\u000f\n\u0007\u0005mRKA\u0002J]R\fqa\u001c4gg\u0016$\b%\u0001\ndY\u0016\fg.\u001a:DQ\u0016\u001c7\u000e]8j]R\u001cXCAA\"!\u001d\t)%a\u0014w\u0003'j!!a\u0012\u000b\t\u0005%\u00131J\u0001\b[V$\u0018M\u00197f\u0015\r\ti%V\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA)\u0003\u000f\u00121!T1q!\r!\u0016QK\u0005\u0004\u0003/*&\u0001\u0002'p]\u001e\f1c\u00197fC:,'o\u00115fG.\u0004x.\u001b8ug\u0002\u0012Q\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s\u001b>\u001c7nE\u0002\u0019\u0003?\u00022AYA1\u0013\r\t\u0019'\u0014\u0002\u0012\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014\u0018a\u00027pO\u0012K'o\u001d\t\u0006\u0003S\nI(\u001a\b\u0005\u0003W\n)H\u0004\u0003\u0002n\u0005MTBAA8\u0015\r\t\t(U\u0001\u0007yI|w\u000e\u001e \n\u0003YK1!a\u001eV\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001f\u0002~\t\u00191+Z9\u000b\u0007\u0005]T+\u0003\u0003\u0002f\u0005\u0005\u0014\u0001\u00027pON\u0004bAWACm\u0006%\u0015bAAD7\n!\u0001k\\8m!\r\u0011\u00171R\u0005\u0004\u0003\u001bk%AC+oS\u001aLW\r\u001a'pO&!\u0011\u0011QA1\u0003Qawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYB!\u0011QSAN\u001b\t\t9JC\u0002\u0002\u001a>\u000baa]3sm\u0016\u0014\u0018\u0002BAO\u0003/\u0013A\u0003T8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0017\u0002BAI\u0003C\"\u0002\"a)\u0002(\u0006%\u00161\u0016\t\u0004\u0003KCR\"\u0001\u0001\t\u000f\u0005\u0015D\u00041\u0001\u0002h!9\u0011\u0011\u0011\u000fA\u0002\u0005\r\u0005bBAI9\u0001\u0007\u00111S\u0001\u0016C2d7\t\\3b]\u0016\u00148\t[3dWB|\u0017N\u001c;t+\t\t\t\fE\u0004\u00024\u0006mf/a\u0015\u000f\t\u0005U\u0016q\u0017\t\u0004\u0003[*\u0016bAA]+\u00061\u0001K]3eK\u001aLA!!\u0015\u0002>*\u0019\u0011\u0011X+\u0002#U\u0004H-\u0019;f\u0007\",7m\u001b9pS:$8\u000f\u0006\u0005\u0002D\u0006%\u0017QZAo!\r!\u0016QY\u0005\u0004\u0003\u000f,&\u0001B+oSRDa!a3\u001f\u0001\u0004)\u0017a\u00023bi\u0006$\u0015N\u001d\u0005\n\u0003\u001ft\u0002\u0013!a\u0001\u0003#\fa\u0003]1si&$\u0018n\u001c8U_V\u0003H-\u0019;f\u001fJ\fE\r\u001a\t\u0006)\u0006M\u0017q[\u0005\u0004\u0003+,&AB(qi&|g\u000e\u0005\u0004U\u000334\u00181K\u0005\u0004\u00037,&A\u0002+va2,'\u0007C\u0005\u0002`z\u0001\n\u00111\u0001\u0002b\u0006\t\u0002/\u0019:uSRLwN\u001c+p%\u0016lwN^3\u0011\tQ\u000b\u0019N^\u0001\u001ckB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u001d(\u0006BAi\u0003S\\#!a;\u0011\t\u00055\u0018q_\u0007\u0003\u0003_TA!!=\u0002t\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003k,\u0016AC1o]>$\u0018\r^5p]&!\u0011\u0011`Ax\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001ckB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005}(\u0006BAq\u0003S\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0003\u0003\u0007D3!\tB\u0004!\u0011\u0011IAa\u0006\u000e\u0005\t-!\u0002\u0002B\u0007\u0005\u001f\t1!\u00199j\u0015\u0011\u0011\tBa\u0005\u0002\u000f),\b/\u001b;fe*\u0019!QC?\u0002\u000b),h.\u001b;\n\t\te!1\u0002\u0002\n\u0003\u001a$XM]#bG\"\f1d]3ukBLen\u0019:fCNLgn\u001a7z\r&dG\u000f[=M_\u001e\u001cH\u0003CAB\u0005?\u0011)C!\u000b\t\u000f\t\u0005\"\u00051\u0001\u0003$\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u000b\u0005%\u0014\u0011\u0010<\t\u000f\t\u001d\"\u00051\u0001\u00028\u0005y1\u000f^1si:+XNQ1uG\",7\u000fC\u0004\u0003,\t\u0002\r!a\u000e\u0002\u001d\t\fGo\u00195J]\u000e\u0014X-\\3oi\u0006aC/Z:u\u000fJ\f'MR5mi\"LWm\u001d;D_6\u0004\u0018m\u0019;fI2{w\r\u00165s_^\u001cX\t_2faRLwN\u001c\u0015\u0004G\tE\u0002\u0003\u0002B\u0005\u0005gIAA!\u000e\u0003\f\t!A+Z:u\u0003a\"Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><'+\u001a;ve:\u001cHj\\4XSRDG)\u001b:uS\u0016\u001cHOU1uS>D3\u0001\nB\u0019\u0003e\"Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><\u0017j\u001a8pe\u0016\u001cXK\\2mK\u0006t\u0017M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\bfA\u0013\u00032\u0005AD/Z:u\u000fJ\f'MR5mi\"LWm\u001d;D_6\u0004\u0018m\u0019;fI2{w-S4o_J,7/\u00138Qe><'/Z:t!\u0006\u0014H/\u001b;j_:\u001c\bf\u0001\u0014\u00032\u0005!F/Z:u\u000fJ\f'MR5mi\"LWm\u001d;D_6\u0004\u0018m\u0019;fI2{w-S4o_J,7OQ8uQ&s\u0007K]8he\u0016\u001c8\u000fU1si&$\u0018n\u001c8t\u0003:$WK\\2mK\u0006t\u0017M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\bfA\u0014\u00032\u0005IC/Z:u\t&\u0014H/_(gMN,GOU3tKRLe\rT1sO\u0016\u0014H\u000b[1o\u000b:$wJ\u001a4tKRD3\u0001\u000bB\u0019\u00031\"Xm\u001d;ESJ$\u0018p\u00144gg\u0016$(+Z:fi&37+\\1mY\u0016\u0014H\u000b[1o'R\f'\u000f^(gMN,G\u000fK\u0002*\u0005c\t1\u0007^3ti2{wm\u0015;beR|eMZ:fi2\u000b'oZ3s)\"\fg.Q2uSZ,7+Z4nK:$()Y:f\u001f\u001a47/\u001a;)\u0007)\u0012\t$\u0001\u0019uKN$H)\u001b:us>3gm]3u\u0019\u0006\u0014x-\u001a:UQ\u0006t\u0017i\u0019;jm\u0016\u001cVmZ7f]R\u0014\u0015m]3PM\u001a\u001cX\r\u001e\u0015\u0004W\tE\u0012\u0001\u0012;fgRdunZ:XSRD7+Z4nK:$8\u000fV8EK2,G/Z*i_VdGMT8u\u0007>t7/\u001b3fe\u000ecW-\u00198vaB{G.[2z\t\u0016dW\r^3M_\u001e\u001c\bf\u0001\u0017\u00032\u0005AE/Z:u\u0019><7oV5uQN+w-\\3oiN$v\u000eR3mKR,7\u000b[8vY\u0012\u001cuN\\:jI\u0016\u00148\t\\3b]V\u0004\bk\u001c7jGf\u001cu.\u001c9bGR$U\r\\3uK2{wm\u001d\u0015\u0004[\tE\u0012A\u0011;fgRdunZ:XSRD7+Z4nK:$8\u000fV8EK2,G/Z*i_VdGmQ8og&$WM]\"mK\u0006tW\u000f\u001d)pY&\u001c\u0017pQ8na\u0006\u001cG\u000fT8hg\"\u001aaF!\r\u0002WQ,7\u000f\u001e'pON,f\u000eZ3s\u00072,\u0017M\\;q\u0013:,G.[4jE2,gi\u001c:D_6\u0004\u0018m\u0019;j_:D3a\fB\u0019\u0003=\"Xm\u001d;Va\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN\u001c\u0006n\\;mI\u0006#Gm\u00144gg\u0016$Hk\u001c)beRLG/[8oQ\r\u0001$\u0011G\u0001/i\u0016\u001cH/\u00169eCR,7\t[3dWB|\u0017N\u001c;t'\"|W\u000f\u001c3SK6|g/\u001a)beRLG/[8o\t\u0006$\u0018\rK\u00022\u0005c\tQ\u0006^3ti\"\u000bg\u000e\u001a7f\u0019><G)\u001b:GC&dWO]3TQ>,H\u000e\u001a*f[>4X\rR5s\u0003:$G)\u0019;bQ\r\u0011$\u0011G\u0001.i\u0016\u001cH/T1zE\u0016$&/\u001e8dCR,7\t[3dWB|\u0017N\u001c;TQ>,H\u000e\u001a+sk:\u001c\u0017\r^3ECR\f\u0007fA\u001a\u00032\u0005aD/Z:u\u00032$XM]\"iK\u000e\\\u0007o\\5oi\u0012K'o\u00155pk2$'+Z7pm\u0016$\u0015\r^1J]N\u00138\rR5s\u0003:$\u0017\t\u001a3J]:+w\u000fR5sQ\r!$\u0011G\u0001)i\u0016\u001cHoQ8oGV\u0014(/\u001a8u\u0019><7\t\\3b]V\u0004\u0018I\u001c3M_\u001e$&/\u001e8dCRLwN\u001c\u0015\u0004k\tE\u0012\u0001\u000b;fgR\u001cuN\\2veJ,g\u000e\u001e'pO\u000ecW-\u00198va\u0006sG\rV8qS\u000e$U\r\\3uS>t\u0007f\u0001\u001c\u00032\u0005\u0011E/Z:u\u0019><7oV5uQN+w-\\3oiN$v\u000eR3mKR,7\u000b[8vY\u0012tu\u000e^\"p]NLG-\u001a:V]\u000edW-\u00198bE2,\u0007+\u0019:uSRLwN\\:)\u0007]\u0012\t$A\u000euKN$8\t\\3b]\u0006\u0014G.Z(gMN,Go\u001d$pe:{g.\u001a\u0015\u0004q\tE\u0012!\t;fgR\u001cE.Z1oC\ndWm\u00144gg\u0016$8/Q2uSZ,7+Z4nK:$\bfA\u001d\u00032\u0005YB/Z:u\u00072,\u0017M\\1cY\u0016|eMZ:fiN4uN\u001d+j[\u0016D3A\u000fB\u0019\u0003\u0001\"Xm\u001d;DY\u0016\fg.\u00192mK>3gm]3ug\u001a{'o\u00155peR$\u0016.\\3)\u0007m\u0012\t$\u0001\u0015uKN$8\t\\3b]\u0006\u0014G.Z(gMN,Go\u001d(fK\u0012\u001c8\t[3dWB|\u0017N\u001c;SKN,G\u000fK\u0002=\u0005c\t!\u0006^3tiVsG-Z2jI\u0016$GK]1og\u0006\u001cG/[8oC2$\u0015\r^1O_R\u001cE.Z1oC\ndW\rK\u0002>\u0005c\t\u0001\u0003^3ti\u0012{g.Z\"mK\u0006t\u0017N\\4)\u0007y\u0012\t$\u0001\tuKN$Hi\u001c8f\t\u0016dW\r^5oO\"\u001aqH!\r\u0002_Q,7\u000f^\"iK\u000e\\\u0007o\\5oiV\u0003H-\u0019;fI\u001a{'/\u00138wC2LGm\u00144gg\u0016$hj\\\"mK\u0006t\u0017N\\4)\u0007\u0001\u0013\t$\u0001\u0019uKN$8\t[3dWB|\u0017N\u001c;Va\u0012\fG/\u001a3G_JLeN^1mS\u0012|eMZ:fi:{GoU3mK\u000e$X\r\u001a\u0015\u0004\u0003\nE\u0012\u0001F2sK\u0006$Xm\u00117fC:,'/T1oC\u001e,'\u000f\u0006\u0003\u0002`\tM\u0006B\u0002(C\u0001\u0004\tI)\u0001\rde\u0016\fG/Z\"mK\u0006tWM]'b]\u0006<WM]'pG.$B!a)\u0003:\"9!1X\"A\u0002\u0005\r\u0015\u0001\u00029p_2\f\u0011b\u0019:fCR,Gj\\4\u0015\u0011\u0005%%\u0011\u0019Bc\u0005\u001fDqAa1E\u0001\u0004\t9$A\u0006tK\u001elWM\u001c;TSj,\u0007b\u0002Bd\t\u0002\u0007!\u0011Z\u0001\u000eG2,\u0017M\\;q!>d\u0017nY=\u0011\t\u0005M&1Z\u0005\u0005\u0005\u001b\fiL\u0001\u0004TiJLgn\u001a\u0005\bi\u0012\u0003\n\u00111\u0001w\u0003M\u0019'/Z1uK2{w\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011)NK\u0002w\u0003S\f1d\u0019:fCR,Gj\\<SKR,g\u000e^5p]2{wmQ8oM&<GCBA\u0010\u00057\u0014i\u000eC\u0004\u0003D\u001a\u0003\r!a\u000e\t\u000f\t\u001dg\t1\u0001\u0003J\u0006aqO]5uKJ+7m\u001c:egRQ\u00111\u0019Br\u0005K\u0014IO!<\t\r9;\u0005\u0019AAE\u0011\u001d\u00119o\u0012a\u0001\u0003o\t!B\\;n\u0005\u0006$8\r[3t\u0011\u001d\u0011Yo\u0012a\u0001\u0003o\tqB]3d_J$7\u000fU3s\u0005\u0006$8\r\u001b\u0005\b\u0005_<\u0005\u0019AA\u001c\u0003E\u0011\u0017\r^2iKN\u0004VM]*fO6,g\u000e^\u0001\u000eCB\u0004XM\u001c3SK\u000e|'\u000fZ:\u0015\r\u0005\r'Q\u001fB|\u0011\u0019q\u0005\n1\u0001\u0002\n\"9!\u0011 %A\u0002\u0005]\u0012A\u00038v[J+7m\u001c:eg\u00069Q.Y6f\u0019><GCBAE\u0005\u007f\u001c\u0019\u0001\u0003\u0005\u0004\u0002%\u0003\n\u00111\u0001f\u0003\r!\u0017N\u001d\u0005\b\u0007\u000bI\u0005\u0019AA\u0010\u0003\u0019\u0019wN\u001c4jO\u0006\tR.Y6f\u0019><G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\r-!fA3\u0002j\u00069!/Z2pe\u0012\u001cH\u0003CB\t\u0007;\u0019\tc!\n\u0011\t\rM1\u0011D\u0007\u0003\u0007+Q1aa\u0006y\u0003\u0019\u0011XmY8sI&!11DB\u000b\u00055iU-\\8ssJ+7m\u001c:eg\"91qD&A\u0002\u0005]\u0012aA6fs\"911E&A\u0002\u0005]\u0012!\u0002<bYV,\u0007bBB\u0014\u0017\u0002\u0007\u00111K\u0001\ni&lWm\u001d;b[B\u0004")
public class LogCleanerManagerTest
implements Logging {
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File tmpDir2 = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final File logDir2 = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final TopicPartition topicPartition = new TopicPartition("log", 0);
    private final TopicPartition topicPartition2 = new TopicPartition("log2", 0);
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final int offset;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File tmpDir2() {
        return this.tmpDir2;
    }

    public File logDir() {
        return this.logDir;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public int offset() {
        return this.offset;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    private Pool<TopicPartition, UnifiedLog> setupIncreasinglyFilthyLogs(scala.collection.immutable.Seq<TopicPartition> partitions, int startNumBatches, int batchIncrement) {
        Pool logs = new Pool((Option)None$.MODULE$);
        IntRef numBatches = IntRef.create((int)startNumBatches);
        partitions.foreach((Function1 & Serializable)tp -> {
            LogCleanerManagerTest.$anonfun$setupIncreasinglyFilthyLogs$1(this, logs, numBatches, batchIncrement, tp);
            return BoxedUnit.UNIT;
        });
        return logs;
    }

    @Test
    public void testGrabFilthiestCompactedLogThrowsException() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        Files.createDirectories(tpDir.toPath(), new FileAttribute[0]);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        LogConfig config = this.createLowRetentionLogConfig(logSegmentSize, LogConfig$.MODULE$.Compact());
        int maxTransactionTimeoutMs = 300000;
        int maxProducerIdExpirationMs = 3600000;
        LogSegments segments = new LogSegments(tp);
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(tpDir, this.topicPartition(), logDirFailureChannel, config.recordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(this.topicPartition(), tpDir, maxTransactionTimeoutMs, maxProducerIdExpirationMs, (Time)this.time());
        LoadedLogOffsets offsets = new LogLoader(tpDir, tp, config, (Scheduler)this.time().scheduler(), (Time)this.time(), logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager, new ConcurrentHashMap()).load();
        LocalLog localLog = new LocalLog(tpDir, config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.time().scheduler(), (Time)this.time(), tp, logDirFailureChannel);
        public class Kafka_log_LogCleanerManagerTest$LogMock$1
        extends UnifiedLog {
            public Iterable<Object> getFirstBatchTimestampForSegments(Iterable<LogSegment> segments) {
                throw new IllegalStateException("Error!");
            }

            public Kafka_log_LogCleanerManagerTest$LogMock$1(LogCleanerManagerTest $outer, LoadedLogOffsets offsets$1, LocalLog localLog$1, Option leaderEpochCache$1, ProducerStateManager producerStateManager$1) {
                super(offsets$1.logStartOffset(), localLog$1, new BrokerTopicStats(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), leaderEpochCache$1, producerStateManager$1, (Option)None$.MODULE$, true);
            }
        }
        Kafka_log_LogCleanerManagerTest$LogMock$1 log = new Kafka_log_LogCleanerManagerTest$LogMock$1(null, offsets, localLog, leaderEpochCache, producerStateManager);
        this.writeRecords(log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)None$.MODULE$);
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, UnifiedLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        LogCleaningException thrownException = (LogCleaningException)Assertions.assertThrows(LogCleaningException.class, () -> cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get());
        Assertions.assertEquals((Object)((Object)log), (Object)thrownException.log());
        Assertions.assertTrue((boolean)(thrownException.getCause() instanceof IllegalStateException));
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.markPartitionUncleanable(((UnifiedLog)logs.get((Object)tp2)).dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(((UnifiedLog)logs.get((Object)tp1)).dir().getParent(), tp1);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetResetIfLargerThanEndOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)200L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((long)0L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testDirtyOffsetResetIfSmallerThanStartOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 20, 5);
        ((UnifiedLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((long)10L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testLogStartOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        UnifiedLog log = this.createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        Pool logs = new Pool((Option)None$.MODULE$);
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.logSegments().size());
        log.maybeIncrementLogStartOffset(2L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, UnifiedLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool logs = new Pool((Option)None$.MODULE$);
        UnifiedLog log = this.createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.logSegments().size());
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, UnifiedLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)3L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.updateHighWatermark(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog.size(), (String)"should have 1 logs ready to be deleted");
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), log.config().segmentSize());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), log.config().retentionMs());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.updateConfig(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((int)0, (int)Option$.MODULE$.option2Iterable(cleanable).size(), (String)"should have 0 logs ready to be compacted");
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1 & Serializable)x$2 -> (TopicPartition)x$2._1()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((int)1, (int)Option$.MODULE$.option2Iterable(cleanable2).size(), (String)"should have 1 logs ready to be compacted");
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig config2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.updateConfig(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)0, (int)deletableLog2.size(), (String)"should have 0 logs ready to be deleted");
        cleanerManager.doneDeleting((Iterable)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{((LogToClean)cleanable2.get()).topicPartition()})));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog3.size(), (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testUpdateCheckpointsShouldAddOffsetToPartition() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions.assertNotEquals((Object)BoxesRunTime.boxToInteger((int)this.offset()), (Object)cleanerManager.allCleanerCheckpoints().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testUpdateCheckpointsShouldRemovePartitionData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        File x$1 = this.logDir();
        Option x$2 = Option$.MODULE$.apply((Object)this.topicPartition());
        Option x$3 = cleanerManager.updateCheckpoints$default$2();
        cleanerManager.updateCheckpoints(x$1, x$3, x$2);
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testHandleLogDirFailureShouldRemoveDirAndData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        cleanerManager.updateCheckpoints(this.logDir2(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition2(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        cleanerManager.handleLogDirFailure(this.logDir().getAbsolutePath());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testMaybeTruncateCheckpointShouldTruncateData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        long lowerOffset = 1L;
        long higherOffset = 1000L;
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), higherOffset);
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), lowerOffset);
        Assertions.assertEquals((long)lowerOffset, (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testAlterCheckpointDirShouldRemoveDataInSrcDirAndAddInNewDir() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.alterCheckpointDir(this.topicPartition(), this.logDir(), this.logDir2());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.handleLogDirFailure(this.logDir2().getAbsolutePath());
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{log.topicPartition()})));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable)x$3 -> (TopicPartition)x$3._1()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable)x$4 -> (TopicPartition)x$4._1()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.markPartitionUncleanable(log.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testCleanableOffsetsForNone() {
        File file;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.logDir();
        file = null;
        File x$2 = file2;
        UnifiedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(50L);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.highWatermark(), (long)log.lastStableOffset(), (String)"The high watermark equals the last stable offset as no transactions are in progress");
        Assertions.assertEquals((long)log.lastStableOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset is bounded by the last stable offset.");
    }

    @Test
    public void testCleanableOffsetsActiveSegment() {
        File file;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.logDir();
        file = null;
        File x$2 = file2;
        UnifiedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(log.logEndOffset());
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the active segment.");
    }

    @Test
    public void testCleanableOffsetsForTime() {
        File file;
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.logDir();
        file = null;
        File x$2 = file2;
        UnifiedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(log.logEndOffset());
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)activeSegAtT0.baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the second block of log entries.");
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        File file;
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.logDir();
        file = null;
        File x$2 = file2;
        UnifiedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(log.logEndOffset());
        this.time().sleep(compactionLag + 1);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with active segment.");
    }

    @Test
    public void testCleanableOffsetsNeedsCheckpointReset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 20, 5);
        ((UnifiedLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)15L));
        Assertions.assertFalse((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((UnifiedLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset should not be reset if valid");
        ((UnifiedLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertTrue((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((UnifiedLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if less than log start offset");
        lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)25L));
        Assertions.assertTrue((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((UnifiedLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if greater than log end offset");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        void withEndTransactionMarker_marker;
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_records2;
        File file;
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.logDir();
        file = null;
        File x$2 = file2;
        UnifiedLog log = this.makeLog(x$2, x$1);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())};
        CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
        Object var12_11 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())};
        int n = sequence + 2;
        CompressionType withTransactionalRecords_compressionType2 = CompressionType.NONE;
        Object var14_14 = null;
        simpleRecordArray2 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        log.updateHighWatermark(3L);
        this.time().sleep(compactionLag + 1);
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        EndTransactionMarker endTransactionMarker = new EndTransactionMarker(ControlRecordType.ABORT, 15);
        long withEndTransactionMarker_timestamp = this.time().milliseconds();
        endTransactionMarker = null;
        log.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)0L, (long)withEndTransactionMarker_timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)withEndTransactionMarker_marker), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        log.updateHighWatermark(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)3L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)4L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testDoneCleaning() {
        File file;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.logDir();
        file = null;
        File x$2 = file2;
        UnifiedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        long endOffset = 1L;
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), endOffset);
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)), (Object)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), endOffset);
        Assertions.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting((Iterable)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting((Iterable)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNoCleaning() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 20, 5);
        ((UnifiedLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)15L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog, (String)"Log should not be selected for cleaning");
        Assertions.assertEquals((long)20L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().apply((Object)tp)), (String)"Unselected log should have checkpoint offset updated");
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNotSelected() {
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1}));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        ((UnifiedLog)logs.get((Object)tp0)).maybeIncrementLogStartOffset(15L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp0, (Object)BoxesRunTime.boxToLong((long)10L));
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)5L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition(), (String)"Dirtier log should be selected");
        Assertions.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().apply((Object)tp0)), (String)"Unselected log should have checkpoint offset updated");
    }

    private LogCleanerManager createCleanerManager(UnifiedLog log) {
        Pool logs = new Pool((Option)None$.MODULE$);
        logs.put((Object)this.topicPartition(), (Object)log);
        return new LogCleanerManager((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir(), this.logDir2()})), logs, null);
    }

    private LogCleanerManagerMock createCleanerManagerMock(Pool<TopicPartition, UnifiedLog> pool) {
        return new LogCleanerManagerMock((scala.collection.immutable.Seq<File>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}))), pool, null);
    }

    private UnifiedLog createLog(int segmentSize, String cleanupPolicy, TopicPartition topicPartition) {
        ConcurrentHashMap concurrentHashMap;
        LogConfig config = this.createLowRetentionLogConfig(segmentSize, cleanupPolicy);
        File partitionDir = new File(this.logDir(), LocalLog$.MODULE$.logDirName(topicPartition));
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean bl = true;
        ConcurrentHashMap concurrentHashMap2 = concurrentHashMap = new ConcurrentHashMap();
        concurrentHashMap = null;
        ConcurrentHashMap x$15 = concurrentHashMap2;
        return UnifiedLog$.MODULE$.apply(partitionDir, config, 0L, 0L, (Scheduler)x$5, x$7, (Time)x$6, 300000, 3600000, x$10, x$11, bl, (Option)x$12, true, x$15);
    }

    private TopicPartition createLog$default$3() {
        return new TopicPartition("log", 0);
    }

    private LogConfig createLowRetentionLogConfig(int segmentSize, String cleanupPolicy) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        return new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
    }

    private void writeRecords(UnifiedLog log, int numBatches, int recordsPerBatch, int batchesPerSegment) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBatches).foreach((Function1 & Serializable)i -> LogCleanerManagerTest.$anonfun$writeRecords$1(this, log, recordsPerBatch, batchesPerSegment, BoxesRunTime.unboxToInt((Object)i)));
        log.roll(log.roll$default$1());
    }

    /*
     * WARNING - void declaration
     */
    private void appendRecords(UnifiedLog log, int numRecords) {
        void withRecords_records;
        void withRecords_timestampType;
        long startOffset = log.logEndOffset();
        long endOffset = startOffset + (long)numRecords;
        LongRef lastTimestamp = LongRef.create((long)0L);
        IndexedSeq records = (IndexedSeq)new RichLong(Predef$.MODULE$.longWrapper(startOffset)).until((Object)BoxesRunTime.boxToLong((long)endOffset)).map((Function1 & Serializable)offset -> LogCleanerManagerTest.$anonfun$appendRecords$1(this, endOffset, lastTimestamp, BoxesRunTime.unboxToLong((Object)offset)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var9_8 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.maybeIncrementHighWatermark(log.logEndOffsetMetadata());
    }

    private UnifiedLog makeLog(File dir, LogConfig config) {
        ConcurrentHashMap concurrentHashMap;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean bl = true;
        ConcurrentHashMap concurrentHashMap2 = concurrentHashMap = new ConcurrentHashMap();
        concurrentHashMap = null;
        ConcurrentHashMap x$15 = concurrentHashMap2;
        return UnifiedLog$.MODULE$.apply(dir, config, 0L, 0L, (Scheduler)x$5, x$7, (Time)x$6, 300000, 3600000, x$10, x$11, bl, (Option)x$12, true, x$15);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords records(int key, int value, long timestamp) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(timestamp, Integer.toString(key).getBytes(), Integer.toString(value).getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        return MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    public static final /* synthetic */ void $anonfun$setupIncreasinglyFilthyLogs$1(LogCleanerManagerTest $this, Pool logs$1, IntRef numBatches$1, int batchIncrement$1, TopicPartition tp) {
        UnifiedLog log = $this.createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        logs$1.put((Object)tp, (Object)log);
        $this.writeRecords(log, numBatches$1.elem, 1, 5);
        numBatches$1.elem += batchIncrement$1;
    }

    public static final /* synthetic */ Object $anonfun$writeRecords$1(LogCleanerManagerTest $this, UnifiedLog log$2, int recordsPerBatch$1, int batchesPerSegment$1, int i) {
        $this.appendRecords(log$2, recordsPerBatch$1);
        if (i % batchesPerSegment$1 == 0) {
            return log$2.roll(log$2.roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendRecords$1(LogCleanerManagerTest $this, long endOffset$1, LongRef lastTimestamp$1, long offset) {
        long currentTimestamp = $this.time().milliseconds();
        if (offset == endOffset$1 - 1L) {
            lastTimestamp$1.elem = currentTimestamp;
        }
        return new SimpleRecord(currentTimestamp, new StringBuilder(4).append("key-").append(offset).toString().getBytes(), new StringBuilder(6).append("value-").append(offset).toString().getBytes());
    }

    public LogCleanerManagerTest() {
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime(1400000000000L, 1000L);
        this.offset = 999;
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        /*
         * WARNING - void declaration
         */
        public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
            void var5_5;
            Predef$.MODULE$.assert(partitionToRemove.isEmpty(), (Function0 & Serializable)() -> "partitionToRemove argument with value not yet handled");
            Tuple2 tuple2 = (Tuple2)partitionToUpdateOrAdd.getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("partitionToUpdateOrAdd==None argument not yet handled");
            });
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long l = tuple2._2$mcJ$sp();
            this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().put((Object)var5_5, (Object)BoxesRunTime.boxToLong((long)l));
        }

        public Option<Tuple2<TopicPartition, Object>> updateCheckpoints$default$2() {
            return None$.MODULE$;
        }

        public Option<TopicPartition> updateCheckpoints$default$3() {
            return None$.MODULE$;
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public LogCleanerManagerMock(scala.collection.immutable.Seq<File> logDirs, Pool<TopicPartition, UnifiedLog> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

