/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import kafka.log.CleanerConfig;
import kafka.log.LocalLog$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogMetricNames$;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.TimeIndex;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.directory.api.util.FileUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\tmg\u0001\u0002!B\u0001\u0019CQ!\u0014\u0001\u0005\u00029Cq!\u0015\u0001C\u0002\u0013\u0005!\u000b\u0003\u0004Z\u0001\u0001\u0006Ia\u0015\u0005\b5\u0002\u0011\r\u0011\"\u0001\\\u0011\u0019y\u0006\u0001)A\u00059\"9\u0001\r\u0001b\u0001\n\u0003Y\u0006BB1\u0001A\u0003%A\fC\u0004c\u0001\t\u0007I\u0011A2\t\r1\u0004\u0001\u0015!\u0003e\u0011\u001di\u0007A1A\u0005\u00029DaA\u001d\u0001!\u0002\u0013y\u0007bB:\u0001\u0001\u0004%\t\u0001\u001e\u0005\bw\u0002\u0001\r\u0011\"\u0001}\u0011\u001d\t)\u0001\u0001Q!\nUD\u0011\"a\u0002\u0001\u0001\u0004%\t!!\u0003\t\u0013\u0005E\u0001\u00011A\u0005\u0002\u0005M\u0001\u0002CA\f\u0001\u0001\u0006K!a\u0003\t\u0013\u0005e\u0001A1A\u0005\u0002\u0005m\u0001\u0002CA\u0015\u0001\u0001\u0006I!!\b\t\u0013\u0005-\u0002A1A\u0005\u0002\u00055\u0002\u0002CA\u001b\u0001\u0001\u0006I!a\f\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!9\u0011Q\u000b\u0001\u0005\u0002\u0005e\u0002bBA0\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003S\u0002A\u0011AA\u001d\u0011\u001d\ti\u0007\u0001C\u0001\u0003sAq!!\u001d\u0001\t\u0003\tI\u0004C\u0004\u0002v\u0001!\t!!\u000f\t\u000f\u0005e\u0004\u0001\"\u0001\u0002:!9\u0011Q\u0010\u0001\u0005\u0002\u0005e\u0002bBAA\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003\u000b\u0003A\u0011AA\u001d\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!!*\u0001\t\u0003\tI\u0004C\u0004\u0002*\u0002!\t!!\u000f\t\u000f\u00055\u0006\u0001\"\u0001\u0002:!9\u0011\u0011\u0017\u0001\u0005\u0002\u0005e\u0002bBA[\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003s\u0003A\u0011AA\u001d\u0011\u001d\ti\f\u0001C\u0005\u0003\u007fCq!!<\u0001\t\u0013\ty\u000fC\u0005\u0003\u0010\u0001\t\n\u0011\"\u0003\u0003\u0012!I!q\u0005\u0001\u0012\u0002\u0013%!\u0011\u0006\u0005\n\u0005[\u0001\u0011\u0013!C\u0005\u0005_AqAa\r\u0001\t\u0003\tI\u0004C\u0004\u00038\u0001!\t!!\u000f\t\u000f\tm\u0002\u0001\"\u0001\u0002:!9!q\b\u0001\u0005\n\t\u0005\u0003\"\u0003B.\u0001E\u0005I\u0011\u0002B\u0018\u0011\u001d\u0011i\u0006\u0001C\u0001\u0003sAqA!\u0019\u0001\t\u0003\tI\u0004C\u0004\u0003f\u0001!\t!!\u000f\t\u000f\t%\u0004\u0001\"\u0001\u0002:!9!Q\u000e\u0001\u0005\u0002\u0005e\u0002b\u0002B9\u0001\u0011%!1\u000f\u0005\b\u0005\u001b\u0003A\u0011\u0002BH\u0011\u001d\u0011)\u000b\u0001C\u0005\u0005OCqA!1\u0001\t\u0013\u0011\u0019\rC\u0004\u0003H\u0002!\t!!\u000f\t\u000f\t-\u0007\u0001\"\u0001\u0002:!9!q\u001a\u0001\u0005\u0002\u0005e\u0002b\u0002Bj\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0005/\u0004A\u0011AA\u001d\u00059aunZ'b]\u0006<WM\u001d+fgRT!AQ\"\u0002\u00071|wMC\u0001E\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A$\u0011\u0005![U\"A%\u000b\u0003)\u000bQa]2bY\u0006L!\u0001T%\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\n\u0005\u0002Q\u00015\t\u0011)\u0001\u0003uS6,W#A*\u0011\u0005Q;V\"A+\u000b\u0005Y\u001b\u0015!B;uS2\u001c\u0018B\u0001-V\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013aD7bqJ{G\u000e\\%oi\u0016\u0014h/\u00197\u0016\u0003q\u0003\"\u0001S/\n\u0005yK%aA%oi\u0006\u0001R.\u0019=S_2d\u0017J\u001c;feZ\fG\u000eI\u0001\f[\u0006DHj\\4BO\u0016l5/\u0001\u0007nCbdunZ!hK6\u001b\b%\u0001\u0005m_\u001e\u0004&o\u001c9t+\u0005!\u0007CA3k\u001b\u00051'BA4i\u0003\u0011)H/\u001b7\u000b\u0003%\fAA[1wC&\u00111N\u001a\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\u00037pOB\u0013x\u000e]:!\u0003%awnZ\"p]\u001aLw-F\u0001p!\t\u0001\u0006/\u0003\u0002r\u0003\nIAj\\4D_:4\u0017nZ\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0013A\u00027pO\u0012K'/F\u0001v!\t1\u00180D\u0001x\u0015\tA\b.\u0001\u0002j_&\u0011!p\u001e\u0002\u0005\r&dW-\u0001\u0006m_\u001e$\u0015N]0%KF$2!`A\u0001!\tAe0\u0003\u0002\u0000\u0013\n!QK\\5u\u0011!\t\u0019!DA\u0001\u0002\u0004)\u0018a\u0001=%c\u00059An\\4ESJ\u0004\u0013A\u00037pO6\u000bg.Y4feV\u0011\u00111\u0002\t\u0004!\u00065\u0011bAA\b\u0003\nQAj\\4NC:\fw-\u001a:\u0002\u001d1|w-T1oC\u001e,'o\u0018\u0013fcR\u0019Q0!\u0006\t\u0013\u0005\r\u0001#!AA\u0002\u0005-\u0011a\u00037pO6\u000bg.Y4fe\u0002\nAA\\1nKV\u0011\u0011Q\u0004\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019\u00111\u00055\u0002\t1\fgnZ\u0005\u0005\u0003O\t\tC\u0001\u0004TiJLgnZ\u0001\u0006]\u0006lW\rI\u0001\u001am\u0016\u0014\u0018\u0010T1sO\u0016dun\u001a$mkND\u0017J\u001c;feZ\fG.\u0006\u0002\u00020A\u0019\u0001*!\r\n\u0007\u0005M\u0012J\u0001\u0003M_:<\u0017A\u0007<fefd\u0015M]4f\u0019><g\t\\;tQ&sG/\u001a:wC2\u0004\u0013!B:fiV\u0003H#A?)\u0007Y\ti\u0004\u0005\u0003\u0002@\u0005ESBAA!\u0015\u0011\t\u0019%!\u0012\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002H\u0005%\u0013a\u00026va&$XM\u001d\u0006\u0005\u0003\u0017\ni%A\u0003kk:LGO\u0003\u0002\u0002P\u0005\u0019qN]4\n\t\u0005M\u0013\u0011\t\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007]\tI\u0006\u0005\u0003\u0002@\u0005m\u0013\u0002BA/\u0003\u0003\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u001bQ,7\u000f^\"sK\u0006$X\rT8hQ\rA\u00121\r\t\u0005\u0003\u007f\t)'\u0003\u0003\u0002h\u0005\u0005#\u0001\u0002+fgR\fA\u0005^3ti\"\u000bg\u000e\u001a7j]\u001e,\u0005pY3qi&|gn\u001d#ve&twm\u00155vi\u0012|wO\u001c\u0015\u00043\u0005\r\u0014A\b;fgR\u001c%/Z1uK2{wmV5uQ&sg/\u00197jI2{w\rR5sQ\rQ\u00121M\u0001 i\u0016\u001cHo\u0011:fCR,Gj\\4XSRDGj\\4ESJ4\u0015\r\u001c7cC\u000e\\\u0007fA\u000e\u0002d\u0005)B/Z:u\u000f\u0016$hj\u001c8Fq&\u001cH/\u001a8u\u0019><\u0007f\u0001\u000f\u0002d\u0005QB/Z:u\u00072,\u0017M\\;q\u000bb\u0004\u0018N]3e'\u0016<W.\u001a8ug\"\u001aQ$a\u0019\u0002CQ,7\u000f^\"mK\u0006tW\u000f]*fO6,g\u000e^:U_6\u000b\u0017N\u001c;bS:\u001c\u0016N_3)\u0007y\t\u0019'\u0001\u0016uKN$Hi\\3t]R\u001cE.Z1o\u0019><7oV5uQ\u000e{W\u000e]1di\u0012+G.\u001a;f!>d\u0017nY=)\u0007}\t\u0019'\u0001\u0013uKN$Hi\\3t]R\u001cE.Z1o\u0019><7oV5uQ\u000e{W\u000e]1diB{G.[2zQ\r\u0001\u00131M\u0001\u0014i\u0016\u001cH\u000fR8fg:$8\t\\3b]2{wm\u001d\u000b\u0004{\u00065\u0005bBAHC\u0001\u0007\u0011\u0011S\u0001\u0007a>d\u0017nY=\u0011\t\u0005M\u0015\u0011\u0015\b\u0005\u0003+\u000bi\nE\u0002\u0002\u0018&k!!!'\u000b\u0007\u0005mU)\u0001\u0004=e>|GOP\u0005\u0004\u0003?K\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002(\u0005\r&bAAP\u0013\u0006\u0011B/Z:u)&lWMQ1tK\u00124E.^:iQ\r\u0011\u00131M\u0001\u001ai\u0016\u001cH\u000fT3bgRdu.\u00193fI\u0006\u001b8/[4o[\u0016tG\u000fK\u0002$\u0003G\n1\u0005^3tiR;x\u000eT8h\u001b\u0006t\u0017mZ3sgV\u001b\u0018N\\4TC6,G)\u001b:GC&d7\u000fK\u0002%\u0003G\nA\u0004^3ti\u000eCWmY6q_&tGOU3d_Z,'/\u001f)pS:$8\u000fK\u0002&\u0003G\nQ\u0006^3tiJ+7m\u001c<fef$\u0015N]3di>\u0014\u00180T1qa&twmV5uQR\u0013\u0018-\u001b7j]\u001e\u001cF.Y:iQ\r1\u00131M\u00012i\u0016\u001cHOU3d_Z,'/\u001f#je\u0016\u001cGo\u001c:z\u001b\u0006\u0004\b/\u001b8h/&$\bNU3mCRLg/\u001a#je\u0016\u001cGo\u001c:zQ\r9\u00131M\u0001\u0019m\u0016\u0014\u0018NZ=DQ\u0016\u001c7\u000e]8j]R\u0014VmY8wKJLHcB?\u0002B\u0006%\u00181\u001e\u0005\b\u0003\u0007D\u0003\u0019AAc\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\bCBAd\u0003#\f9N\u0004\u0003\u0002J\u00065g\u0002BAL\u0003\u0017L\u0011AS\u0005\u0004\u0003\u001fL\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003'\f)NA\u0002TKFT1!a4J!\u0011\tI.!:\u000e\u0005\u0005m'\u0002BAo\u0003?\faaY8n[>t'b\u0001#\u0002b*!\u00111]A'\u0003\u0019\t\u0007/Y2iK&!\u0011q]An\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a\u0002)\u0001\u0004\tY\u0001C\u0003tQ\u0001\u0007Q/\u0001\tde\u0016\fG/\u001a'pO6\u000bg.Y4feRA\u00111BAy\u0003o\u0014Y\u0001C\u0005\u0002t&\u0002\n\u00111\u0001\u0002v\u00069An\\4ESJ\u001c\b#BAd\u0003#,\b\"CA}SA\u0005\t\u0019AA~\u0003A\u0019wN\u001c4jOJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0002~\n\u001dQBAA\u0000\u0015\u0011\u0011\tAa\u0001\u0002\u00115,G/\u00193bi\u0006T1A!\u0002D\u0003\u0019\u0019XM\u001d<fe&!!\u0011BA\u0000\u0005A\u0019uN\u001c4jOJ+\u0007o\\:ji>\u0014\u0018\u0010\u0003\u0005\u0003\u000e%\u0002\n\u00111\u0001]\u0003e\u0011XmY8wKJLH\u000b\u001b:fC\u0012\u001c\b+\u001a:ECR\fG)\u001b:\u00025\r\u0014X-\u0019;f\u0019><W*\u00198bO\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tM!\u0006BA{\u0005+Y#Aa\u0006\u0011\t\te!1E\u0007\u0003\u00057QAA!\b\u0003 \u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005CI\u0015AC1o]>$\u0018\r^5p]&!!Q\u0005B\u000e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001bGJ,\u0017\r^3M_\u001el\u0015M\\1hKJ$C-\u001a4bk2$HEM\u000b\u0003\u0005WQC!a?\u0003\u0016\u0005Q2M]3bi\u0016dunZ'b]\u0006<WM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u0007\u0016\u00049\nU\u0011A\t;fgR4\u0015\u000e\\3SK\u001a,'/\u001a8dKN\fe\r^3s\u0003NLhn\u0019#fY\u0016$X\rK\u0002.\u0003G\n!\u0005^3ti\u000e\u0013X-\u0019;f\u0003:$G)\u001a7fi\u0016|e/\u001a:ms2{gn\u001a+pa&\u001c\u0007f\u0001\u0018\u0002d\u0005\tC/Z:u\u0007\",7m\u001b9pS:$hi\u001c:P]2L\u0018I\u001a4fGR,G\rT8hg\"\u001aq&a\u0019\u0002\u000fI,\u0017\r\u001a'pORA!1\tB&\u0005'\u00129\u0006\u0005\u0003\u0003F\t\u001dSB\u0001B\u0002\u0013\u0011\u0011IEa\u0001\u0003\u001b\u0019+Go\u00195ECR\f\u0017J\u001c4p\u0011\u0019\u0011\u0005\u00071\u0001\u0003NA\u0019\u0001Ka\u0014\n\u0007\tE\u0013I\u0001\u0006V]&4\u0017.\u001a3M_\u001eDqA!\u00161\u0001\u0004\ty#\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\t\u00053\u0002\u0004\u0013!a\u00019\u0006IQ.\u0019=MK:<G\u000f[\u0001\u0012e\u0016\fG\rT8hI\u0011,g-Y;mi\u0012\u001a\u0014!\n;fgR$v\u000e]5d\u0007>tg-[4DQ\u0006tw-Z+qI\u0006$Xm\u001d'pO\u000e{gNZ5hQ\r\u0011\u00141M\u0001\u001ei\u0016\u001cHoQ8oM&<7\t[1oO\u0016<U\r^:DY\u0016\fg.\u001a3Va\"\u001a1'a\u0019\u0002QQ,7\u000f\u001e\"s_.,'oQ8oM&<7\t[1oO\u0016$U\r\\5wKJ,G\rV8BY2dunZ:)\u0007Q\n\u0019'A\u001auKN$Hk\u001c9jG\u000e{gNZ5h\u0007\"\fgnZ3Ti>\u00048\t\\3b]&tw-\u00134D_6\u0004\u0018m\u0019;JgJ+Wn\u001c<fI\"\u001aQ'a\u0019\u0002YQ,7\u000f^\"p]\u001aLwm\u00115b]\u001e,7oV5uQ:{Gj\\4HKR$\u0018N\\4J]&$\u0018.\u00197ju\u0016$\u0007f\u0001\u001c\u0002d\u0005\u0011\u0012\r\u001d9f]\u0012\u0014VmY8sIN$v\u000eT8h)-i(Q\u000fB<\u0005w\u0012yH!#\t\u000bE;\u0004\u0019A*\t\r\tet\u00071\u0001v\u00031\u0001\u0018M]3oi2{w\rR5s\u0011\u0019\u0011ih\u000ea\u00019\u0006Y\u0001/\u0019:uSRLwN\\%e\u0011\u001d\u0011\ti\u000ea\u0001\u0005\u0007\u000b\u0001C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0011\t\t\u0015#QQ\u0005\u0005\u0005\u000f\u0013\u0019A\u0001\tCe>\\WM\u001d+pa&\u001c7\u000b^1ug\"1!1R\u001cA\u0002q\u000ba#\u001a=qK\u000e$X\rZ*fO6,g\u000e^:QKJdunZ\u0001#m\u0016\u0014\u0018NZ=SK6\f\u0017N\\5oO2{wm\u001d+p%\u0016\u001cwN^3s\u001b\u0016$(/[2\u0015\u000bu\u0014\tJ!&\t\u000f\tM\u0005\b1\u0001\u0002\f\u0005i1\u000f]=M_\u001el\u0015M\\1hKJDqAa&9\u0001\u0004\u0011I*\u0001\bfqB,7\r^3e!\u0006\u0014\u0018-\\:\u0011\u000f\tm%\u0011UAI96\u0011!Q\u0014\u0006\u0004\u0005?K\u0015AC2pY2,7\r^5p]&!!1\u0015BO\u0005\ri\u0015\r]\u0001'm\u0016\u0014\u0018NZ=SK6\f\u0017N\\5oON+w-\\3oiN$vNU3d_Z,'/T3ue&\u001cGcC?\u0003*\n-&Q\u0016BX\u0005\u007fCqAa%:\u0001\u0004\tY\u0001C\u0004\u0002tf\u0002\r!!>\t\r\t5\u0011\b1\u0001]\u0011\u001d\u0011\t,\u000fa\u0001\u0005g\u000bq!\\8dW6\u000b\u0007\u000fE\u0004\u00036\nm\u0016\u0011\u0013/\u000e\u0005\t]&b\u0001B]M\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\tu&q\u0017\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bb\u0002BLs\u0001\u0007!\u0011T\u0001\u001fm\u0016\u0014\u0018NZ=M_\u001e\u0014VmY8wKJlU\r\u001e:jGN\u0014V-\\8wK\u0012$2! Bc\u0011\u001d\u0011\u0019J\u000fa\u0001\u0003\u0017\ta\u0003^3ti2{wMU3d_Z,'/_'fiJL7m\u001d\u0015\u0004w\u0005\r\u0014A\u000e;fgRdun\u001a*fG>4XM]=NKR\u0014\u0018nY:TQ>,H\u000e\u001a\"f%\u0016lwN^3e\u0003\u001a$XM\u001d'pOJ+7m\u001c<fe\u0016$\u0007f\u0001\u001f\u0002d\u0005\u0001D/Z:u\u001b\u0016$(/[2t\u000bbL7\u000f^,iK:dunZ%t%\u0016\u001c'/Z1uK\u0012\u0014UMZ8sK\u0012+G.\u001a;j_:D3!PA2\u0003E\"Xm\u001d;NKR\u0014\u0018nY:Be\u0016\u0014V-\\8wK\u0012<\u0006.\u001a8N_ZLgnZ\"veJ,g\u000e\u001e+p\rV$XO]3M_\u001eD3APA2\u0003a!Xm\u001d;XC&$hi\u001c:BY2$vnQ8na2,G/\u001a\u0015\u0004\u007f\u0005\r\u0004")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository(), 1));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
    }

    @AfterEach
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir());
        if (this.logManager() != null) {
            this.logManager().liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
                LogManagerTest.$anonfun$tearDown$1(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        Assertions.assertEquals((int)1, (int)this.logManager().liveLogDirs().size());
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testHandlingExceptionsDuringShutdown() {
        File file;
        File file2;
        File file3;
        File file4;
        File file5;
        File file6;
        File file7 = file6 = TestUtils.tempDirectory(null, null);
        file6 = null;
        File file8 = file5 = file7;
        file5 = null;
        File file9 = file4 = file8;
        file4 = null;
        File logDir1 = file9;
        File file10 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file11 = file2 = file10;
        file2 = null;
        File file12 = file = file11;
        file = null;
        File logDir2 = file12;
        Option logManagerForTest = Option$.MODULE$.empty();
        try {
            logManagerForTest = new Some((Object)this.createLogManager((scala.collection.immutable.Seq<File>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{logDir1, logDir2}))), new MockConfigRepository(), 1));
            Assertions.assertEquals((int)2, (int)((LogManager)logManagerForTest.get()).liveLogDirs().size());
            ((LogManager)logManagerForTest.get()).startup((Set)Predef$.MODULE$.Set().empty());
            LogManager qual$1 = (LogManager)logManagerForTest.get();
            TopicPartition x$1 = new TopicPartition(this.name(), 0);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            UnifiedLog log1 = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            LogManager qual$2 = (LogManager)logManagerForTest.get();
            TopicPartition x$5 = new TopicPartition(this.name(), 1);
            None$ x$6 = None$.MODULE$;
            boolean x$7 = qual$2.getOrCreateLog$default$2();
            boolean x$8 = qual$2.getOrCreateLog$default$3();
            UnifiedLog log2 = qual$2.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
            File logFile1 = new File(logDir1, new StringBuilder(2).append(this.name()).append("-0").toString());
            Assertions.assertTrue((boolean)logFile1.exists());
            Assertions.assertTrue((boolean)new File(logDir2, new StringBuilder(2).append(this.name()).append("-1").toString()).exists());
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
            log1.takeProducerSnapshot();
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5());
            log2.takeProducerSnapshot();
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5());
            FileUtils.deleteDirectory((File)logFile1);
            ((LogManager)logManagerForTest.get()).shutdown();
            Assertions.assertFalse((boolean)Files.exists(new File(logDir1, LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
            Assertions.assertTrue((boolean)Files.exists(new File(logDir2, LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
        }
        finally {
            logManagerForTest.foreach((Function1 & Serializable)manager -> {
                LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$1(manager);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        scala.collection.immutable.Seq dirs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir(), new File("\u0000")}));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$3 = None$.MODULE$;
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, true, x$4, (Option)x$3);
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testCreateLogWithLogDirFallback() {
        IndexedSeq dirs = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)x$1 -> LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$1(BoxesRunTime.unboxToInt((Object)x$1))).map((Function1 & Serializable)x$2 -> this.logDir().toPath().resolve((String)x$2).toFile());
        this.logManager().shutdown();
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1)));
        scala.collection.mutable.Set brokenDirs = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File logDir = (File)invocation.getArgument(0);
            if (brokenDirs.contains((Object)logDir) || brokenDirs.size() < dirs.length() / 2) {
                brokenDirs.add((Object)logDir);
                return new Failure(new Throwable("broken dir"));
            }
            return (Try)invocation.callRealMethod();
        }).when((Object)this.logManager())).createLogDirectory((File)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$12 = new TopicPartition(this.name(), 0);
        None$ x$3 = None$.MODULE$;
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$12, true, x$4, (Option)x$3);
        Assertions.assertEquals((int)(dirs.length() / 2), (int)brokenDirs.size());
        Function1 & Serializable containsLogFile = (Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$4(this, dir));
        Assertions.assertEquals((int)1, (int)dirs.count((Function1)containsLogFile), (String)"More than one log file created");
        Assertions.assertFalse((boolean)brokenDirs.exists((Function1)containsLogFile));
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log, (String)"No log should be found.");
        Assertions.assertFalse((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
    }

    @Test
    public void testCleanupExpiredSegments() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$32 = qual$1.getOrCreateLog$default$2();
        boolean x$42 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$32, x$42, (Option)x$2);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$1.elem = info.lastOffset();
        });
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.updateHighWatermark(log.logEndOffset());
        log.logSegments().foreach((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCleanupExpiredSegments$2(this, x$4)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assertions.assertEquals((int)1, (int)log.numberOfSegments(), (String)"Now there should only be only one segment in the index.");
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        log.logSegments().foreach((Function1 & Serializable)s -> {
            s.lazyOffsetIndex().get();
            return (TimeIndex)s.lazyTimeIndex().get();
        });
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        int n = 1024;
        long readLog_offset = offset.elem + 1L;
        Assertions.assertEquals((int)0, (int)log.read(readLog_offset, n, (FetchIsolation)FetchLogEnd$.MODULE$, true).records().sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> {
            int n = 1024;
            long readLog_offset = 0L;
            log.read(readLog_offset, n, (FetchIsolation)FetchLogEnd$.MODULE$, true);
        }, () -> "Should get exception from fetching earlier.");
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes();
        this.logManager().shutdown();
        int segmentBytes = 10 * setSize;
        Properties properties = new Properties();
        properties.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(segmentBytes));
        properties.put(LogConfig$.MODULE$.RetentionBytesProp(), Long.toString(50L * (long)setSize + 10L));
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), properties);
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int n = 1;
        this.logManager_$eq(this.createLogManager(x$2, configRepository, n));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$4 = new TopicPartition(this.name(), 0);
        None$ x$52 = None$.MODULE$;
        boolean x$6 = qual$1.getOrCreateLog$default$2();
        boolean x$7 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$4, x$6, x$7, (Option)x$52);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$2.elem = ((LogOffsetMetadata)info.firstOffset().get()).messageOffset();
        });
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertEquals((int)(numMessages * setSize / segmentBytes), (int)log.numberOfSegments(), (String)"Check we have the expected number of segments.");
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertEquals((int)6, (int)log.numberOfSegments(), (String)"Now there should be exactly 6 segments");
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        int n2 = 1024;
        long readLog_offset = offset.elem + 1L;
        Assertions.assertEquals((int)0, (int)log.read(readLog_offset, n2, (FetchIsolation)FetchLogEnd$.MODULE$, true).records().sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> {
            int n = 1024;
            long readLog_offset = 0L;
            log.read(readLog_offset, n, (FetchIsolation)FetchLogEnd$.MODULE$, true);
        });
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs(new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString());
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs(LogConfig$.MODULE$.Compact());
    }

    private void testDoesntCleanLogs(String policy) {
        this.logManager().shutdown();
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), LogConfig$.MODULE$.CleanupPolicyProp(), policy);
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int n = 1;
        this.logManager_$eq(this.createLogManager(x$2, configRepository, n));
        LogManager qual$1 = this.logManager();
        TopicPartition x$4 = new TopicPartition(this.name(), 0);
        None$ x$5 = None$.MODULE$;
        boolean x$62 = qual$1.getOrCreateLog$default$2();
        boolean x$72 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$4, x$62, x$72, (Option)x$5);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$3.elem = info.lastOffset();
        });
        int numSegments = log.numberOfSegments();
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.logSegments().foreach((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testDoesntCleanLogs$2(this, x$7)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assertions.assertEquals((int)numSegments, (int)log.numberOfSegments(), (String)"number of segments shouldn't have changed");
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), LogConfig$.MODULE$.FlushMsProp(), "1000");
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int n = 1;
        this.logManager_$eq(this.createLogManager(x$2, configRepository, n));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$4 = new TopicPartition(this.name(), 0);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = qual$1.getOrCreateLog$default$2();
        boolean x$7 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$4, x$6, x$7, (Option)x$5);
        long lastFlush = log.lastFlushTime();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1 & Serializable)x$8 -> LogManagerTest.$anonfun$testTimeBasedFlush$1(log, BoxesRunTime.unboxToInt((Object)x$8)));
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((lastFlush != log.lastFlushTime() ? 1 : 0) != 0, (String)"Time based flush should have been triggered");
    }

    @Test
    public void testLeastLoadedAssignment() {
        Object[] objectArray = new File[3];
        objectArray[0] = TestUtils.tempDirectory(null, null);
        objectArray[1] = TestUtils.tempDirectory(null, null);
        objectArray[2] = TestUtils.tempDirectory(null, null);
        scala.collection.immutable.Seq dirs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> {
            LogManager qual$1 = this.logManager();
            TopicPartition x$1 = new TopicPartition("test", partition);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            Assertions.assertEquals((int)(partition + 1), (int)this.logManager().allLogs().size(), (String)"We should have created the right number of logs");
            Iterable counts = (Iterable)this.logManager().allLogs().groupBy((Function1 & Serializable)x$9 -> x$9.dir().getParent()).values().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.size()));
            Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0, (String)"Load should balance evenly");
        });
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        Assertions.assertThrows(KafkaException.class, () -> this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository(), 1));
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1), new TopicPartition("test-b", 1)}))), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        Object[] objectArray = new File[1];
        objectArray[0] = new File(new StringBuilder(0).append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append(File.separator).toString());
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), LogConfig$.MODULE$.apply(), new MockConfigRepository(), TestUtils$.MODULE$.createLogManager$default$4(), new MockTime(), MetadataVersion.latest(), 4));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{new File("data", this.logDir().getName()).getAbsoluteFile()}))), new MockConfigRepository(), 1));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(scala.collection.immutable.Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        scala.collection.immutable.Seq logs = (scala.collection.immutable.Seq)topicPartitions.map((Function1 & Serializable)x$11 -> {
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            return logManager.getOrCreateLog(x$11, x$3, x$4, (Option)x$2);
        });
        logs.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$2(log);
            return BoxedUnit.UNIT;
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), null).read();
        ((IterableOnceOps)topicPartitions.zip((IterableOnce)logs)).foreach((Function1 & Serializable)x0$1 -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private LogManager createLogManager(scala.collection.immutable.Seq<File> logDirs, ConfigRepository configRepository, int recoveryThreadsPerDataDir) {
        MetadataVersion metadataVersion;
        LogConfig x$1 = this.logConfig();
        MockTime x$4 = this.time();
        CleanerConfig x$6 = TestUtils$.MODULE$.createLogManager$default$4();
        MetadataVersion metadataVersion2 = metadataVersion = MetadataVersion.latest();
        metadataVersion = null;
        MetadataVersion x$7 = metadataVersion2;
        return TestUtils$.MODULE$.createLogManager((Seq<File>)logDirs, x$1, configRepository, x$6, x$4, x$7, recoveryThreadsPerDataDir);
    }

    private scala.collection.immutable.Seq<File> createLogManager$default$1() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}));
    }

    private ConfigRepository createLogManager$default$2() {
        return new MockConfigRepository();
    }

    private int createLogManager$default$3() {
        return 1;
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        LogSegment activeSegment = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2).activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        Object[] indexFilesOnDiskBeforeDelete = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])activeSegment.log().file().getParentFile().listFiles()), (Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$1(x$13)));
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        UnifiedLog removedLog = (UnifiedLog)qual$2.asyncDelete(x$5, x$6, x$7).get();
        LogSegment removedSegment = removedLog.activeSegment();
        scala.collection.immutable.Seq indexFilesAfterDelete = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{removedSegment.lazyOffsetIndex().file(), removedSegment.lazyTimeIndex().file(), removedSegment.txnIndex().file()}));
        Assertions.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.lazyOffsetIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.lazyTimeIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(indexFilesOnDiskBeforeDelete), (Function1 & Serializable)fileBeforeDelete -> {
            LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(indexFilesAfterDelete, fileBeforeDelete);
            return BoxedUnit.UNIT;
        });
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs deleted too early");
        this.time().sleep(Predef$.MODULE$.Long2long(this.logManager().currentDefaultConfig().fileDeleteDelayMs()) - (long)this.logManager().InitialTaskDelayMs());
        Assertions.assertFalse((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs not deleted");
    }

    @Test
    public void testCreateAndDeleteOverlyLongTopic() {
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(253, "x"));
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(invalidTopicName, 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(invalidTopicName, 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        qual$2.asyncDelete(x$5, x$6, x$7);
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        scala.collection.immutable.Seq tps = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 0), new TopicPartition("test-a", 1), new TopicPartition("test-a", 2), new TopicPartition("test-b", 0), new TopicPartition("test-b", 1)}));
        scala.collection.immutable.Seq allLogs = (scala.collection.immutable.Seq)tps.map((Function1 & Serializable)x$16 -> {
            LogManager qual$1 = this.logManager();
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            return qual$1.getOrCreateLog(x$16, x$3, x$4, (Option)x$2);
        });
        allLogs.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$2(log);
            return BoxedUnit.UNIT;
        });
        this.logManager().checkpointRecoveryOffsetsInDir(this.logDir());
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), null).read();
        ((IterableOnceOps)tps.zip((IterableOnce)allLogs)).foreach((Function1 & Serializable)x0$1 -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private FetchDataInfo readLog(UnifiedLog log, long offset, int maxLength) {
        return log.read(offset, maxLength, (FetchIsolation)FetchLogEnd$.MODULE$, true);
    }

    private int readLog$default$3() {
        return 1024;
    }

    @Test
    public void testTopicConfigChangeUpdatesLogConfig() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int n = 1;
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, n));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        UnifiedLog mockLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.topicConfigUpdated(testTopicOne);
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicTwo);
    }

    @Test
    public void testConfigChangeGetsCleanedUp() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int n = 1;
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, n));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        TopicPartition testTopicPartition = new TopicPartition("test-topic", 1);
        spyLogManager.initializingLog(testTopicPartition);
        spyLogManager.finishedInitializingLog(testTopicPartition, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicPartition.topic());
    }

    @Test
    public void testBrokerConfigChangeDeliveredToAllLogs() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int n = 1;
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, n));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        UnifiedLog mockLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.brokerConfigUpdated();
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicTwo);
    }

    @Test
    public void testTopicConfigChangeStopCleaningIfCompactIsRemoved() {
        this.logManager().shutdown();
        MockConfigRepository x$1 = new MockConfigRepository();
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int n = 1;
        this.logManager_$eq(this.createLogManager(x$2, x$1, n));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        String topic = "topic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Properties oldProperties = new Properties();
        oldProperties.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig oldLogConfig = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), oldProperties);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = spyLogManager.getOrCreateLog$default$2();
        boolean x$7 = spyLogManager.getOrCreateLog$default$3();
        UnifiedLog log0 = spyLogManager.getOrCreateLog(tp0, x$6, x$7, (Option)x$5);
        log0.updateConfig(oldLogConfig);
        None$ x$9 = None$.MODULE$;
        boolean x$10 = spyLogManager.getOrCreateLog$default$2();
        boolean x$11 = spyLogManager.getOrCreateLog$default$3();
        UnifiedLog log1 = spyLogManager.getOrCreateLog(tp1, x$10, x$11, (Option)x$9);
        log1.updateConfig(oldLogConfig);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnifiedLog[]{log0, log1})), (Object)spyLogManager.logsByTopic(topic).toSet());
        Properties newProperties = new Properties();
        newProperties.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        spyLogManager.updateTopicConfig(topic, newProperties);
        Assertions.assertTrue((boolean)log0.config().delete());
        Assertions.assertTrue((boolean)log1.config().delete());
        Assertions.assertFalse((boolean)log0.config().compact());
        Assertions.assertFalse((boolean)log1.config().compact());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).topicConfigUpdated(topic);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp0);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp1);
    }

    @Test
    public void testConfigChangesWithNoLogGettingInitialized() {
        this.logManager().brokerConfigUpdated();
        this.logManager().topicConfigUpdated("test-topic");
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
    }

    private void appendRecordsToLog(MockTime time, File parentLogDir, int partitionId, BrokerTopicStats brokerTopicStats, int expectedSegmentsPerLog) {
        File tpFile = new File(parentLogDir, new StringBuilder(1).append(this.name()).append("-").append(partitionId).toString());
        int segmentBytes = 1024;
        UnifiedLog log = LogTestUtils$.MODULE$.createLog(tpFile, this.logConfig(), brokerTopicStats, time.scheduler(), (Time)time, 0L, 0L, 300000, 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>());
        Assertions.assertTrue((expectedSegmentsPerLog > 0 ? 1 : 0) != 0);
        int numMessages = (int)Math.floor(segmentBytes * expectedSegmentsPerLog / LogManagerTest.createRecord$1(time).sizeInBytes());
        try {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable)x$18 -> log.appendAsLeader(LogManagerTest.createRecord$1(time), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
            Assertions.assertEquals((int)expectedSegmentsPerLog, (int)log.numberOfSegments());
        }
        finally {
            log.close();
        }
    }

    private void verifyRemainingLogsToRecoverMetric(LogManager spyLogManager, Map<String, Object> expectedParams) {
        String spyLogManagerClassName = spyLogManager.getClass().getSimpleName();
        ArrayBuffer logMetrics = (ArrayBuffer)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$1(spyLogManagerClassName, x0$1)))).map((Function1 & Serializable)x0$2 -> {
            void var1_1;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            Metric gauge = (Metric)x0$2._2();
            return var1_1;
        });
        Assertions.assertEquals((int)expectedParams.size(), (int)logMetrics.size());
        ArgumentCaptor capturedPath = ArgumentCaptor.forClass(String.class);
        int expectedCallTimes = BoxesRunTime.unboxToInt((Object)expectedParams.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)expectedCallTimes))).decNumRemainingLogs((ConcurrentMap)ArgumentMatchers.any(), (String)capturedPath.capture());
        List paths = capturedPath.getAllValues();
        expectedParams.foreach((Function1 & Serializable)x0$3 -> {
            LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$3(paths, x0$3);
            return BoxedUnit.UNIT;
        });
        logMetrics.foreach((Function1 & Serializable)gauge -> {
            LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$4(gauge);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyRemainingSegmentsToRecoverMetric(LogManager spyLogManager, scala.collection.immutable.Seq<File> logDirs, int recoveryThreadsPerDataDir, ConcurrentHashMap<String, Object> mockMap, Map<String, Object> expectedParams) {
        String spyLogManagerClassName = spyLogManager.getClass().getSimpleName();
        ArrayBuffer logSegmentMetrics = (ArrayBuffer)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$1(spyLogManagerClassName, x0$1)))).map((Function1 & Serializable)x0$2 -> {
            void var1_1;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            Metric gauge = (Metric)x0$2._2();
            return var1_1;
        });
        Assertions.assertEquals((int)(recoveryThreadsPerDataDir * logDirs.size()), (int)logSegmentMetrics.size());
        ArgumentCaptor capturedThreadName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor capturedNumRemainingSegments = ArgumentCaptor.forClass(Integer.TYPE);
        int expectedCallTimes = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)expectedParams.values().map((Function1)(JFunction1.mcII.sp & Serializable)num -> num + 1)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ((ConcurrentHashMap)Mockito.verify(mockMap, (VerificationMode)Mockito.times((int)expectedCallTimes))).put(capturedThreadName.capture(), capturedNumRemainingSegments.capture());
        logSegmentMetrics.foreach((Function1 & Serializable)gauge -> {
            LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$4(gauge);
            return BoxedUnit.UNIT;
        });
        List threadNames = capturedThreadName.getAllValues();
        List numRemainingSegments = capturedNumRemainingSegments.getAllValues();
        expectedParams.foreach((Function1 & Serializable)x0$3 -> {
            LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$5(threadNames, numRemainingSegments, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyLogRecoverMetricsRemoved(LogManager spyLogManager) {
        String spyLogManagerClassName = spyLogManager.getClass().getSimpleName();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$1(spyLogManagerClassName).isEmpty());
        Assertions.assertTrue((boolean)((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyLogRecoverMetricsRemoved$2(spyLogManagerClassName, metric)))).isEmpty());
    }

    @Test
    public void testLogRecoveryMetrics() {
        MockConfigRepository mockConfigRepository;
        File file;
        File file2;
        File file3;
        File file4;
        File file5;
        File file6;
        this.logManager().shutdown();
        File file7 = file6 = TestUtils.tempDirectory(null, null);
        file6 = null;
        File file8 = file5 = file7;
        file5 = null;
        File file9 = file4 = file8;
        file4 = null;
        File logDir1 = file9;
        File file10 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file11 = file2 = file10;
        file2 = null;
        File file12 = file = file11;
        file = null;
        File logDir2 = file12;
        scala.collection.immutable.Seq logDirs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{logDir1, logDir2}));
        int recoveryThreadsPerDataDir = 2;
        MockConfigRepository mockConfigRepository2 = mockConfigRepository = new MockConfigRepository();
        mockConfigRepository = null;
        MockConfigRepository x$3 = mockConfigRepository2;
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)logDirs, x$3, recoveryThreadsPerDataDir));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Assertions.assertEquals((int)2, (int)spyLogManager.liveLogDirs().size());
        MockTime mockTime = new MockTime();
        ConcurrentHashMap mockMap = (ConcurrentHashMap)Mockito.mock(ConcurrentHashMap.class);
        BrokerTopicStats mockBrokerTopicStats = (BrokerTopicStats)Mockito.mock(BrokerTopicStats.class);
        int expectedSegmentsPerLog = 2;
        this.appendRecordsToLog(mockTime, logDir1, 0, mockBrokerTopicStats, expectedSegmentsPerLog);
        this.appendRecordsToLog(mockTime, logDir2, 1, mockBrokerTopicStats, expectedSegmentsPerLog);
        ((LogManager)Mockito.doAnswer(invocation -> {
            TopicPartition topicPartition;
            File dir = (File)invocation.getArgument(0);
            scala.collection.mutable.Map topicConfigOverrides = (scala.collection.mutable.Map)invocation.getArgument(5);
            TopicPartition topicPartition2 = topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
            topicPartition = null;
            TopicPartition topicPartition3 = topicPartition2;
            LogConfig config = (LogConfig)topicConfigOverrides.getOrElse((Object)topicPartition3.topic(), (Function0 & Serializable)() -> this.logConfig());
            int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
            MockScheduler x$11 = mockTime.scheduler();
            LogDirFailureChannel x$14 = (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class);
            None$ x$16 = None$.MODULE$;
            return UnifiedLog$.MODULE$.apply(dir, config, 0L, 0L, (Scheduler)x$11, mockBrokerTopicStats, (Time)mockTime, 300000, 300000, x$10, x$14, false, (Option)x$16, false, (ConcurrentMap)mockMap);
        }).when((Object)spyLogManager)).loadLog((File)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (LogConfig)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.doNothing().when((Object)spyLogManager)).removeLogRecoveryMetrics();
        spyLogManager.startup((Set)Predef$.MODULE$.Set().empty());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).addLogRecoveryMetrics((ConcurrentMap)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).removeLogRecoveryMetrics();
        Map expectedRemainingLogsParams = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir1.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir2.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)1))}));
        this.verifyRemainingLogsToRecoverMetric(spyLogManager, (Map<String, Object>)expectedRemainingLogsParams);
        Map expectedRemainingSegmentsParams = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir1.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)expectedSegmentsPerLog)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir2.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)expectedSegmentsPerLog))}));
        this.verifyRemainingSegmentsToRecoverMetric(spyLogManager, (scala.collection.immutable.Seq<File>)logDirs, recoveryThreadsPerDataDir, mockMap, (Map<String, Object>)expectedRemainingSegmentsParams);
    }

    @Test
    public void testLogRecoveryMetricsShouldBeRemovedAfterLogRecovered() {
        MockConfigRepository mockConfigRepository;
        File file;
        File file2;
        File file3;
        File file4;
        File file5;
        File file6;
        this.logManager().shutdown();
        File file7 = file6 = TestUtils.tempDirectory(null, null);
        file6 = null;
        File file8 = file5 = file7;
        file5 = null;
        File file9 = file4 = file8;
        file4 = null;
        File logDir1 = file9;
        File file10 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file11 = file2 = file10;
        file2 = null;
        File file12 = file = file11;
        file = null;
        File logDir2 = file12;
        scala.collection.immutable.Seq logDirs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{logDir1, logDir2}));
        int recoveryThreadsPerDataDir = 2;
        MockConfigRepository mockConfigRepository2 = mockConfigRepository = new MockConfigRepository();
        mockConfigRepository = null;
        MockConfigRepository x$3 = mockConfigRepository2;
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)logDirs, x$3, recoveryThreadsPerDataDir));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Assertions.assertEquals((int)2, (int)spyLogManager.liveLogDirs().size());
        spyLogManager.startup((Set)Predef$.MODULE$.Set().empty());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).addLogRecoveryMetrics((ConcurrentMap)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).removeLogRecoveryMetrics();
        this.verifyLogRecoverMetricsRemoved(spyLogManager);
    }

    @Test
    public void testMetricsExistWhenLogIsRecreatedBeforeDeletion() {
        String topicName = "metric-test";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        LogManager qual$2 = this.logManager();
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        UnifiedLog removedLog = (UnifiedLog)qual$2.asyncDelete(tp, x$6, x$7).get();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$2(topicName).isEmpty());
        LogManager qual$3 = this.logManager();
        None$ x$9 = None$.MODULE$;
        boolean x$10 = qual$3.getOrCreateLog$default$2();
        boolean x$11 = qual$3.getOrCreateLog$default$3();
        qual$3.getOrCreateLog(tp, x$10, x$11, (Option)x$9);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        this.time().sleep(Predef$.MODULE$.Long2long(this.logConfig().fileDeleteDelayMs()) + 1L);
        Assertions.assertTrue((boolean)removedLog.logSegments().isEmpty());
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
    }

    @Test
    public void testMetricsAreRemovedWhenMovingCurrentToFutureLog() {
        File file;
        File file2;
        File file3;
        File file4;
        File file5;
        File file6;
        File file7 = file6 = TestUtils.tempDirectory(null, null);
        file6 = null;
        File file8 = file5 = file7;
        file5 = null;
        File file9 = file4 = file8;
        file4 = null;
        File dir1 = file9;
        File file10 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file11 = file2 = file10;
        file2 = null;
        File file12 = file = file11;
        file = null;
        File dir2 = file12;
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{dir1, dir2}))), new MockConfigRepository(), 1));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        String topicName = "future-log";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        this.logManager().maybeUpdatePreferredLogDir(tp, dir1.getAbsolutePath());
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2);
        this.logManager().maybeUpdatePreferredLogDir(tp, dir2.getAbsolutePath());
        LogManager qual$2 = this.logManager();
        None$ x$7 = None$.MODULE$;
        boolean x$8 = qual$2.getOrCreateLog$default$2();
        qual$2.getOrCreateLog(tp, x$8, true, (Option)x$7);
        LogManagerTest.verifyMetrics$2(2, metricTag, topicName);
        this.logManager().replaceCurrentWithFutureLog(tp);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
        this.time().sleep(Predef$.MODULE$.Long2long(this.logConfig().fileDeleteDelayMs()) + 1L);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
    }

    @Test
    public void testWaitForAllToComplete() {
        IntRef invokedCount = IntRef.create((int)0);
        Future success = (Future)Mockito.mock(Future.class);
        Mockito.when(success.get()).thenAnswer(x$19 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testWaitForAllToComplete$1(invokedCount, x$19)));
        Future failure = (Future)Mockito.mock(Future.class);
        Mockito.when(failure.get()).thenAnswer(x$20 -> {
            ++invokedCount$1.elem;
            throw new RuntimeException();
        });
        IntRef failureCount = IntRef.create((int)0);
        boolean bl = ((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[]{success, failure}))).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$21 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$3(failureCount, x$21);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl);
        Assertions.assertEquals((int)2, (int)invokedCount.elem);
        Assertions.assertEquals((int)1, (int)failureCount.elem);
        boolean bl2 = ((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[]{failure, success}))).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$22 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$4(failureCount, x$22);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl2);
        Assertions.assertEquals((int)4, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        boolean bl3 = ((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[]{success, success}))).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$23 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$5(failureCount, x$23);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0;
        Assertions.assertTrue((boolean)bl3);
        Assertions.assertEquals((int)6, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        boolean bl4 = ((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[]{failure, failure}))).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$24 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$6(failureCount, x$24);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl4);
        Assertions.assertEquals((int)8, (int)invokedCount.elem);
        Assertions.assertEquals((int)4, (int)failureCount.elem);
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$2(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
            LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$testCreateLogWithLogDirFallback$1(int x$1) {
        return Integer.toString(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateLogWithLogDirFallback$4(LogManagerTest $this, File dir) {
        return new File(dir, new StringBuilder(2).append($this.name()).append("-0").toString()).exists();
    }

    public static final /* synthetic */ boolean $anonfun$testCleanupExpiredSegments$2(LogManagerTest $this, LogSegment x$4) {
        return x$4.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ boolean $anonfun$testDoesntCleanLogs$2(LogManagerTest $this, LogSegment x$7) {
        return x$7.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$1(UnifiedLog log$4, int x$8) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
        return log$4.appendAsLeader(set, 0, log$4.appendAsLeader$default$3(), log$4.appendAsLeader$default$4(), log$4.appendAsLeader$default$5());
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$2(UnifiedLog log) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable)x$12 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$4(Map checkpoints$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            UnifiedLog log = (UnifiedLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$1(File x$13) {
        return x$13.getName().endsWith("index");
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$3(File fileBeforeDelete$1, File x$14) {
        String string = x$14.getName();
        String string2 = fileBeforeDelete$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testFileReferencesAfterAsyncDelete$2(scala.collection.immutable.Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        Option fileInIndex = indexFilesAfterDelete$1.find((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3(fileBeforeDelete, x$14)));
        Assertions.assertEquals((Object)new Some((Object)fileBeforeDelete.getName()), (Object)fileInIndex.map((Function1 & Serializable)x$15 -> x$15.getName()), (String)new StringBuilder(51).append("Could not find index file ").append(fileBeforeDelete.getName()).append(" in indexFilesAfterDelete").toString());
        Assertions.assertNotEquals((Object)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (String)((File)fileInIndex.get()).getAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$2(UnifiedLog log) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable)x$17 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$4(Map checkpoints$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            UnifiedLog log = (UnifiedLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$2.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            return;
        }
        throw new MatchError(null);
    }

    private static final MemoryRecords createRecord$1(MockTime time$1) {
        CompressionType compressionType;
        byte[] x$1 = "test".getBytes();
        long x$2 = time$1.milliseconds();
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$4 = compressionType2;
        byte by = 2;
        return TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, by);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$verifyRemainingLogsToRecoverMetric$1(String spyLogManagerClassName$1, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        MetricName metric = (MetricName)x0$1._1();
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$1);
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = metric.getName();
        String string4 = "remainingLogsToRecover";
        if (string3 == null) return false;
        if (!string3.equals(string4)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingLogsToRecoverMetric$3(List paths$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String path = (String)x0$3._1();
            Assertions.assertEquals((int)x0$3._2$mcI$sp(), (int)Collections.frequency(paths$1, path));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingLogsToRecoverMetric$4(Gauge gauge) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$verifyRemainingSegmentsToRecoverMetric$1(String spyLogManagerClassName$2, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        MetricName metric = (MetricName)x0$1._1();
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$2);
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = metric.getName();
        String string4 = "remainingSegmentsToRecover";
        if (string3 == null) return false;
        if (!string3.equals(string4)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingSegmentsToRecoverMetric$4(Gauge gauge) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingSegmentsToRecoverMetric$5(List threadNames$1, List numRemainingSegments$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String threadName = (String)x0$3._1();
            IntRef expectedCurRemainingSegments = IntRef.create((int)(x0$3._2$mcI$sp() + 1));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), threadNames$1.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                if (((String)threadNames$1.get(i)).contains(threadName)) {
                    --expectedCurRemainingSegments$1.elem;
                    Assertions.assertEquals((int)expectedCurRemainingSegments$1.elem, (int)BoxesRunTime.unboxToInt(numRemainingSegments$1.get(i)));
                }
            });
            Assertions.assertEquals((int)0, (int)expectedCurRemainingSegments.elem);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogRecoverMetricsRemoved$1(String spyLogManagerClassName$3, MetricName metric) {
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$3);
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = metric.getName();
            String string4 = "remainingLogsToRecover";
            if (string3 != null && string3.equals(string4)) {
                return true;
            }
        }
        return false;
    }

    private static final scala.collection.mutable.Set logMetrics$1(String spyLogManagerClassName$3) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyLogRecoverMetricsRemoved$1(spyLogManagerClassName$3, metric)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogRecoverMetricsRemoved$2(String spyLogManagerClassName$3, MetricName metric) {
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$3);
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = metric.getName();
            String string4 = "remainingSegmentsToRecover";
            if (string3 != null && string3.equals(string4)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(String topicName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$1);
    }

    private static final scala.collection.mutable.Set logMetrics$2(String topicName$1) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(topicName$1, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(String metricTag$1, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$1));
    }

    private static final void verifyMetrics$1(String metricTag$1, String topicName$1) {
        Assertions.assertEquals((int)LogMetricNames$.MODULE$.allMetricNames().size(), (int)LogManagerTest.logMetrics$2(topicName$1).size());
        LogManagerTest.logMetrics$2(topicName$1).foreach((Function1 & Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(metricTag$1, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(String topicName$2, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$2);
    }

    private static final scala.collection.mutable.Set logMetrics$3(String topicName$2) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(topicName$2, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(String metricTag$2, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$2));
    }

    private static final void verifyMetrics$2(int logCount, String metricTag$2, String topicName$2) {
        Assertions.assertEquals((int)(LogMetricNames$.MODULE$.allMetricNames().size() * logCount), (int)LogManagerTest.logMetrics$3(topicName$2).size());
        LogManagerTest.logMetrics$3(topicName$2).foreach((Function1 & Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(metricTag$2, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testWaitForAllToComplete$1(IntRef invokedCount$1, InvocationOnMock x$19) {
        ++invokedCount$1.elem;
        return true;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$3(IntRef failureCount$1, Throwable x$21) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$4(IntRef failureCount$1, Throwable x$22) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$5(IntRef failureCount$1, Throwable x$23) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$6(IntRef failureCount$1, Throwable x$24) {
        ++failureCount$1.elem;
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(4096));
        this.logProps().put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), Long.toString(Long.MAX_VALUE));
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.logDir = null;
        this.logManager = null;
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
    }
}

