/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Array$;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015a\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001A\u0002\u0013\u0005!\bC\u0004Y\u0001\u0001\u0007I\u0011A-\t\r}\u0003\u0001\u0015)\u0003<\u0011\u001d\u0001\u0007A1A\u0005\u0002\u0005Da!\u001a\u0001!\u0002\u0013\u0011\u0007b\u00024\u0001\u0005\u0004%\ta\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011B)\t\u000f%\u0004!\u0019!C\u0001O\"1!\u000e\u0001Q\u0001\nECqa\u001b\u0001C\u0002\u0013\u0005\u0011\r\u0003\u0004m\u0001\u0001\u0006IA\u0019\u0005\b[\u0002\u0011\r\u0011\"\u0001o\u0011\u00199\b\u0001)A\u0005_\"9\u0001\u0010\u0001b\u0001\n\u0003I\bB\u0002@\u0001A\u0003%!\u0010\u0003\u0005\u0000\u0001\t\u0007I\u0011AA\u0001\u0011!\ti\u0001\u0001Q\u0001\n\u0005\r\u0001\"CA\b\u0001\t\u0007I\u0011AA\t\u0011!\ty\u0002\u0001Q\u0001\n\u0005M\u0001\"CA\u0011\u0001\t\u0007I\u0011AA\u0012\u0011!\ti\u0004\u0001Q\u0001\n\u0005\u0015\u0002\"CA \u0001\u0001\u0007I\u0011AA!\u0011%\tI\u0006\u0001a\u0001\n\u0003\tY\u0006\u0003\u0005\u0002`\u0001\u0001\u000b\u0015BA\"\u0011%\t\t\u0007\u0001a\u0001\n\u0003\t\u0019\u0007C\u0005\u0002l\u0001\u0001\r\u0011\"\u0001\u0002n!A\u0011\u0011\u000f\u0001!B\u0013\t)\u0007C\u0006\u0002t\u0001\u0001\r\u00111A\u0005\u0002\u0005U\u0004bCAE\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0017C1\"a$\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002x!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005bBAV\u0001\u0011\u0005\u00111\u0013\u0005\b\u0003k\u0003A\u0011AAJ\u0011\u001d\ty\f\u0001C\u0001\u0003'Cq!a1\u0001\t\u0003\t\u0019\nC\u0004\u0002H\u0002!\t!a%\t\u000f\u0005-\u0007\u0001\"\u0003\u0002N\"9!\u0011\u0001\u0001\u0005\n\t\r!!E%te\u0016C\b/\u001b:bi&|g\u000eV3ti*\u0011!fK\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00031\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001c\u0011\u0005a\u0002Q\"A\u0015\u0002#Q|\u0007/[2QCJ$\u0018\u000e^5p]&\u001b(/F\u0001<!\u0011a\u0014i\u0011+\u000e\u0003uR!AP \u0002\u000f5,H/\u00192mK*\u0011\u0001)M\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\">\u0005\ri\u0015\r\u001d\t\u0005a\u00113\u0015+\u0003\u0002Fc\t1A+\u001e9mKJ\u0002\"a\u0012(\u000f\u0005!c\u0005CA%2\u001b\u0005Q%BA&.\u0003\u0019a$o\\8u}%\u0011Q*M\u0001\u0007!J,G-\u001a4\n\u0005=\u0003&AB*ue&twM\u0003\u0002NcA\u0011\u0001GU\u0005\u0003'F\u00121!\u00138u!\r)f+U\u0007\u0002\u007f%\u0011qk\u0010\u0002\u0004'\u0016\f\u0018!\u0006;pa&\u001c\u0007+\u0019:uSRLwN\\%te~#S-\u001d\u000b\u00035v\u0003\"\u0001M.\n\u0005q\u000b$\u0001B+oSRDqAX\u0002\u0002\u0002\u0003\u00071(A\u0002yIE\n!\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|g.S:sA\u0005\u0019\"/\u001a9mS\u000e\fG*Y4US6,W*\u0019=NgV\t!\r\u0005\u00021G&\u0011A-\r\u0002\u0005\u0019>tw-\u0001\u000bsKBd\u0017nY1MC\u001e$\u0016.\\3NCbl5\u000fI\u0001\u0016e\u0016\u0004H.[2b\r\u0016$8\r[,bSRl\u0015\r_'t+\u0005\t\u0016A\u0006:fa2L7-\u0019$fi\u000eDw+Y5u\u001b\u0006DXj\u001d\u0011\u0002%1,\u0017\rZ3s\u0019><WI\u001c3PM\u001a\u001cX\r^\u0001\u0014Y\u0016\fG-\u001a:M_\u001e,e\u000eZ(gMN,G\u000fI\u0001\u0017Y\u0016\fG-\u001a:M_\u001eD\u0015n\u001a5XCR,'/\\1sW\u00069B.Z1eKJdun\u001a%jO\"<\u0016\r^3s[\u0006\u00148\u000eI\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\tq\u000e\u0005\u0002qk6\t\u0011O\u0003\u0002sg\u0006!Q\u000f^5m\u0015\u0005!\u0018\u0001\u00026bm\u0006L!A^9\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\tpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9tA\u000591m\u001c8gS\u001e\u001cX#\u0001>\u0011\u0007U36\u0010\u0005\u00029y&\u0011Q0\u000b\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0005d_:4\u0017nZ:!\u0003\u0015!x\u000e]5d+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIa]\u0001\u0005Y\u0006tw-C\u0002P\u0003\u000f\ta\u0001^8qS\u000e\u0004\u0013\u0001\u0002;j[\u0016,\"!a\u0005\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u0007,\u0003\u0015)H/\u001b7t\u0013\u0011\ti\"a\u0006\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nq!\\3ue&\u001c7/\u0006\u0002\u0002&A!\u0011qEA\u001d\u001b\t\tIC\u0003\u0003\u0002\"\u0005-\"\u0002BA\u0017\u0003_\taaY8n[>t'b\u0001\u0017\u00022)!\u00111GA\u001b\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qG\u0001\u0004_J<\u0017\u0002BA\u001e\u0003S\u0011q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u00031\tXo\u001c;b\u001b\u0006t\u0017mZ3s+\t\t\u0019\u0005\u0005\u0003\u0002F\u0005Mc\u0002BA$\u0003\u001frA!!\u0013\u0002N9\u0019\u0011*a\u0013\n\u00031J!AK\u0016\n\u0007\u0005E\u0013&\u0001\u0007Rk>$\u0018MR1di>\u0014\u00180\u0003\u0003\u0002V\u0005]#!D)v_R\fW*\u00198bO\u0016\u00148OC\u0002\u0002R%\n\u0001#];pi\u0006l\u0015M\\1hKJ|F%Z9\u0015\u0007i\u000bi\u0006\u0003\u0005_1\u0005\u0005\t\u0019AA\"\u00035\tXo\u001c;b\u001b\u0006t\u0017mZ3sA\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014XCAA3!\rA\u0014qM\u0005\u0004\u0003SJ#A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0013e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000fF\u0002[\u0003_B\u0001BX\u000e\u0002\u0002\u0003\u0007\u0011QM\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005y\u0011\r\u001c;fe&\u001b(/T1oC\u001e,'/\u0006\u0002\u0002xA!\u0011\u0011PAB\u001d\u0011\tY(a \u000f\t\u0005%\u0013QP\u0005\u0004\u00033Y\u0013\u0002BAA\u0003/\t\u0011\u0002V3tiV#\u0018\u000e\\:\n\t\u0005\u0015\u0015q\u0011\u0002\u001a\u001b>\u001c7.\u00117uKJ\u0004\u0016M\u001d;ji&|g.T1oC\u001e,'O\u0003\u0003\u0002\u0002\u0006]\u0011aE1mi\u0016\u0014\u0018j\u001d:NC:\fw-\u001a:`I\u0015\fHc\u0001.\u0002\u000e\"AaLHA\u0001\u0002\u0004\t9(\u0001\tbYR,'/S:s\u001b\u0006t\u0017mZ3sA\u0005)1/\u001a;VaR\t!\fK\u0002!\u0003/\u0003B!!'\u0002(6\u0011\u00111\u0014\u0006\u0005\u0003;\u000by*A\u0002ba&TA!!)\u0002$\u00069!.\u001e9ji\u0016\u0014(\u0002BAS\u0003k\tQA[;oSRLA!!+\u0002\u001c\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3!IAX!\u0011\tI*!-\n\t\u0005M\u00161\u0014\u0002\n\u0003\u001a$XM]#bG\"\f!\u0005^3ti&\u001b(/\u0012=qSJ\fG/[8o\r>\u00148\u000b^;dW\u001a{G\u000e\\8xKJ\u001c\bf\u0001\u0012\u0002:B!\u0011\u0011TA^\u0013\u0011\ti,a'\u0003\tQ+7\u000f^\u0001&i\u0016\u001cH/S:s\u000bb\u0004\u0018N]1uS>t\u0017J\u001a(p\r\u0016$8\r\u001b*fcV,7\u000f^'bI\u0016D3aIA]\u0003\u0005\"Xm\u001d;JgJ,\u0005\u0010]5sCRLwN\u001c$peNcwn\u001e$pY2|w/\u001a:tQ\r!\u0013\u0011X\u0001&i\u0016\u001cH/S:s\u000bb\u0004\u0018N]1uS>tgi\u001c:DCV<\u0007\u000e^+q\r>dGn\\<feND3!JA]\u0003\u0001:W\r\u001e)beRLG/[8o/&$\b.\u00117m%\u0016\u0004H.[2bg&s\u0017j\u001d:\u0015\u0019\u0005=\u00171\\Ao\u0003C\fi/!=\u0011\t\u0005E\u0017q[\u0007\u0003\u0003'T1!!6,\u0003\u001d\u0019G.^:uKJLA!!7\u0002T\nI\u0001+\u0019:uSRLwN\u001c\u0005\u0006\u007f\u001a\u0002\rA\u0012\u0005\u0007\u0003?4\u0003\u0019A)\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\b\u0003\u001f1\u0003\u0019AAr!\u0011\t)/!;\u000e\u0005\u0005\u001d(\u0002BA\r\u0003WIA!a;\u0002h\n!A+[7f\u0011\u0019\tyO\na\u0001w\u000611m\u001c8gS\u001eDq!a='\u0001\u0004\t)0\u0001\u0005m_\u000e\fG\u000eT8h!\u0011\t90!@\u000e\u0005\u0005e(bAA~W\u0005\u0019An\\4\n\t\u0005}\u0018\u0011 \u0002\u000b+:Lg-[3e\u0019><\u0017a\u00027pO6{7m[\u000b\u0003\u0003k\u0004")
public class IsrExpirationTest {
    private scala.collection.mutable.Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr = new HashMap();
    private final long replicaLagTimeMaxMs;
    private final int replicaFetchWaitMaxMs;
    private final int leaderLogEndOffset;
    private final long leaderLogHighWatermark;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final String topic;
    private final MockTime time;
    private final Metrics metrics;
    private QuotaFactory.QuotaManagers quotaManager;
    private ReplicaManager replicaManager;
    private TestUtils.MockAlterPartitionManager alterIsrManager;

    public scala.collection.mutable.Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr() {
        return this.topicPartitionIsr;
    }

    public void topicPartitionIsr_$eq(scala.collection.mutable.Map<Tuple2<String, Object>, Seq<Object>> x$1) {
        this.topicPartitionIsr = x$1;
    }

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int leaderLogEndOffset() {
        return this.leaderLogEndOffset;
    }

    public long leaderLogHighWatermark() {
        return this.leaderLogHighWatermark;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public TestUtils.MockAlterPartitionManager alterIsrManager() {
        return this.alterIsrManager;
    }

    public void alterIsrManager_$eq(TestUtils.MockAlterPartitionManager x$1) {
        this.alterIsrManager = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @BeforeEach
    public void setUp() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        None$ none$5;
        None$ none$6;
        AtomicBoolean atomicBoolean;
        BrokerTopicStats brokerTopicStats;
        void zkMetadataCache_brokerFeatures;
        void zkMetadataCache_metadataVersion;
        ZkMetadataCache zkMetadataCache;
        BrokerFeatures brokerFeatures;
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        this.alterIsrManager_$eq(new TestUtils.MockAlterPartitionManager());
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = (KafkaConfig)this.configs().head();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        BrokerFeatures brokerFeatures2 = brokerFeatures = BrokerFeatures$.MODULE$.createEmpty();
        brokerFeatures = null;
        BrokerFeatures brokerFeatures3 = brokerFeatures2;
        MetadataVersion metadataVersion = ((KafkaConfig)this.configs().head()).interBrokerProtocolVersion();
        int zkMetadataCache_brokerId = ((KafkaConfig)this.configs().head()).brokerId();
        ZkMetadataCache zkMetadataCache2 = zkMetadataCache = new ZkMetadataCache(zkMetadataCache_brokerId, (MetadataVersion)zkMetadataCache_metadataVersion, (BrokerFeatures)zkMetadataCache_brokerFeatures);
        metadataVersion = null;
        brokerFeatures3 = null;
        zkMetadataCache = null;
        ZkMetadataCache x$7 = zkMetadataCache2;
        LogDirFailureChannel x$8 = new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size());
        TestUtils.MockAlterPartitionManager x$9 = this.alterIsrManager();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = new BrokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$10 = brokerTopicStats2;
        AtomicBoolean atomicBoolean2 = atomicBoolean = new AtomicBoolean(false);
        atomicBoolean = null;
        AtomicBoolean x$11 = atomicBoolean2;
        None$ none$7 = none$6 = None$.MODULE$;
        none$6 = null;
        None$ x$12 = none$7;
        None$ none$8 = none$5 = None$.MODULE$;
        none$5 = null;
        None$ x$13 = none$8;
        None$ none$9 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$14 = none$9;
        None$ none$10 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$15 = none$10;
        None$ none$11 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$16 = none$11;
        None$ none$12 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$17 = none$12;
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, null, logManager, x$6, (MetadataCache)x$7, x$8, (AlterPartitionManager)x$9, x$10, x$11, (Option)x$12, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17));
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable)x$3 -> {
            x$3.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    @Test
    public void testIsrExpirationForStuckFollowers() {
        UnifiedLog log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.brokerId()))).toSet(), (Object)partition0.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition0.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 1), UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR, (String)"Replica 1 should be out of sync");
        ((UnifiedLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    @Test
    public void testIsrExpirationIfNoFetchRequestMade() {
        UnifiedLog log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.brokerId()))).toSet(), (Object)partition0.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        this.time().sleep(150L);
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR, (String)"Replica 1 should be out of sync");
        ((UnifiedLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    @Test
    public void testIsrExpirationForSlowFollowers() {
        UnifiedLog log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.brokerId()))).toSet(), (Object)partition0.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition0.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 2), UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        this.time().sleep(75L);
        partition0.remoteReplicas().foreach((Function1 & Serializable)r -> {
            r.updateFetchState(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 1), UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        this.time().sleep(75L);
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR, (String)"Replica 1 should be out of sync");
        partition0.remoteReplicas().foreach((Function1 & Serializable)r -> {
            r.updateFetchState(new LogOffsetMetadata((long)this.leaderLogEndOffset(), UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        ((UnifiedLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    @Test
    public void testIsrExpirationForCaughtUpFollowers() {
        UnifiedLog log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.brokerId()))).toSet(), (Object)partition0.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition0.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata((long)this.leaderLogEndOffset(), UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        ((UnifiedLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    private Partition getPartitionWithAllReplicasInIsr(String topic, int partitionId, Time time, KafkaConfig config, UnifiedLog localLog) {
        int leaderId = config.brokerId();
        TopicPartition tp = new TopicPartition(topic, partitionId);
        Partition partition = this.replicaManager().createPartition(tp);
        partition.setLog(localLog, false);
        partition.updateAssignmentAndIsr((Seq)this.configs().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.brokerId())), true, ((IterableOnceOps)this.configs().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.brokerId()))).toSet(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), LeaderRecoveryState.RECOVERED);
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata(0L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, time.milliseconds(), 0L);
            return BoxedUnit.UNIT;
        });
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderId)));
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private UnifiedLog logMock() {
        void var1_1;
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(this.leaderLogEndOffset())));
        return var1_1;
    }

    public IsrExpirationTest() {
        this.replicaLagTimeMaxMs = 100L;
        this.replicaFetchWaitMaxMs = 100;
        this.leaderLogEndOffset = 20;
        this.leaderLogHighWatermark = 20L;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), Long.toString(this.replicaLagTimeMaxMs()));
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), Integer.toString(this.replicaFetchWaitMaxMs()));
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
        this.topic = "foo";
        this.time = new MockTime();
        this.metrics = new Metrics();
        this.quotaManager = null;
        this.replicaManager = null;
    }
}

