/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.LogAppendInfo;
import kafka.log.UnifiedLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001B\n\u0015\u0001eA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\nY\u0001\u0011\t\u0011)A\u0005[AB\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A\u0011\b\u0001B\u0001B\u0003%!\bC\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0003\"A!\t\u0001B\u0001B\u0003%1\tC\u0003H\u0001\u0011\u0005\u0001\nC\u0003R\u0001\u0011E#\u000bC\u0003d\u0001\u0011EC\rC\u0003j\u0001\u0011E#\u000eC\u0003m\u0001\u0011ES\u000eC\u0003v\u0001\u0011\u0005c\u000fC\u0004\u0002\u0010\u0001!\t%!\u0005\t\u0013\u0005=\u0002A1A\u0005R\u0005E\u0002\u0002CA\u001d\u0001\u0001\u0006I!a\r\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>!9\u0011\u0011\u000b\u0001\u0005R\u0005M#!\u0007*fa2L7-Y!mi\u0016\u0014Hj\\4ESJ\u001cH\u000b\u001b:fC\u0012T!!\u0006\f\u0002\rM,'O^3s\u0015\u00059\u0012!B6bM.\f7\u0001A\n\u0003\u0001i\u0001\"a\u0007\u000f\u000e\u0003QI!!\b\u000b\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI\u0006!a.Y7f!\t\u0001\u0013F\u0004\u0002\"OA\u0011!%J\u0007\u0002G)\u0011A\u0005G\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0002\rA\u0013X\rZ3g\u0013\tQ3F\u0001\u0004TiJLgn\u001a\u0006\u0003Q\u0015\na\u0001\\3bI\u0016\u0014\bCA\u000e/\u0013\tyCC\u0001\bMK\u0006$WM]#oIB{\u0017N\u001c;\n\u00051b\u0012\u0001\u00054bS2,G\rU1si&$\u0018n\u001c8t!\tY2'\u0003\u00025)\t\u0001b)Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u0001\u000be\u0016\u0004H.[2b\u001b\u001e\u0014\bCA\u000e8\u0013\tADC\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u000bE,x\u000e^1\u0011\u0005mY\u0014B\u0001\u001f\u0015\u0005]\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'/\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugB\u00111dP\u0005\u0003\u0001R\u0011\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\n\u0005ub\u0012A\u00044fi\u000eD')Y2l\u001f\u001a4Wj\u001d\t\u0003\t\u0016k\u0011!J\u0005\u0003\r\u0016\u00121!\u00138u\u0003\u0019a\u0014N\\5u}QA\u0011JS&M\u001b:{\u0005\u000b\u0005\u0002\u001c\u0001!)a\u0004\u0003a\u0001?!)A\u0006\u0003a\u0001[!)\u0011\u0007\u0003a\u0001e!)Q\u0007\u0003a\u0001m!)\u0011\b\u0003a\u0001u!)Q\b\u0003a\u0001}!)!\t\u0003a\u0001\u0007\u0006YA.\u0019;fgR,\u0005o\\2i)\t\u0019f\u000bE\u0002E)\u000eK!!V\u0013\u0003\r=\u0003H/[8o\u0011\u00159\u0016\u00021\u0001Y\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"!W1\u000e\u0003iS!a\u0017/\u0002\r\r|W.\\8o\u0015\t9RL\u0003\u0002_?\u00061\u0011\r]1dQ\u0016T\u0011\u0001Y\u0001\u0004_J<\u0017B\u00012[\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fa\u0002\\8h'R\f'\u000f^(gMN,G\u000f\u0006\u0002fQB\u0011AIZ\u0005\u0003O\u0016\u0012A\u0001T8oO\")qK\u0003a\u00011\u0006aAn\\4F]\u0012|eMZ:fiR\u0011Qm\u001b\u0005\u0006/.\u0001\r\u0001W\u0001\u0012K:$wJ\u001a4tKR4uN]#q_\u000eDGc\u00018sgB\u0019A\tV8\u0011\u0005m\u0001\u0018BA9\u0015\u00059yeMZ:fi\u0006sG-\u00129pG\"DQa\u0016\u0007A\u0002aCQ\u0001\u001e\u0007A\u0002\r\u000bQ!\u001a9pG\"\fA\u0003\u001d:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8ECR\fG#B<\u007f\u007f\u0006\r\u0001c\u0001#UqB\u0011\u0011\u0010`\u0007\u0002u*\u00111PF\u0001\u0004Y><\u0017BA?{\u00055aunZ!qa\u0016tG-\u00138g_\")q+\u0004a\u00011\"1\u0011\u0011A\u0007A\u0002\u0015\f1BZ3uG\"|eMZ:fi\"9\u0011QA\u0007A\u0002\u0005\u001d\u0011!\u00049beRLG/[8o\t\u0006$\u0018\r\u0005\u0003\u0002\n\u0005-Q\"\u0001\u0001\n\u0007\u00055ADA\u0005GKR\u001c\u0007\u000eR1uC\u0006i\u0011\r\u001a3QCJ$\u0018\u000e^5p]N$B!a\u0005\u0002 A)\u0011QCA\u000e16\u0011\u0011q\u0003\u0006\u0004\u00033)\u0013AC2pY2,7\r^5p]&!\u0011QDA\f\u0005\r\u0019V\r\u001e\u0005\b\u0003Cq\u0001\u0019AA\u0012\u0003IIg.\u001b;jC24U\r^2i'R\fG/Z:\u0011\u000f\u0005U\u0011Q\u0005-\u0002*%!\u0011qEA\f\u0005\ri\u0015\r\u001d\t\u00047\u0005-\u0012bAA\u0017)\t\t\u0012J\\5uS\u0006dg)\u001a;dQN#\u0018\r^3\u0002?%\u001cxJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u001cV\u000f\u001d9peR,G-\u0006\u0002\u00024A\u0019A)!\u000e\n\u0007\u0005]REA\u0004C_>dW-\u00198\u0002A%\u001cxJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u001cV\u000f\u001d9peR,G\rI\u0001\tiJ,hnY1uKR1\u0011qHA#\u0003\u000f\u00022\u0001RA!\u0013\r\t\u0019%\n\u0002\u0005+:LG\u000fC\u0003X#\u0001\u0007\u0001\fC\u0004\u0002JE\u0001\r!a\u0013\u0002\u001fQ\u0014XO\\2bi&|gn\u0015;bi\u0016\u00042aGA'\u0013\r\ty\u0005\u0006\u0002\u0016\u001f\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f\u0003]!(/\u001e8dCR,g)\u001e7ms\u0006sGm\u0015;beR\fE\u000f\u0006\u0004\u0002@\u0005U\u0013q\u000b\u0005\u0006/J\u0001\r\u0001\u0017\u0005\u0007\u00033\u0012\u0002\u0019A3\u0002\r=4gm]3u\u0001")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final boolean isOffsetForLeaderEpochSupported;

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        UnifiedLog futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureLog.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark());
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset(), LeaderOffsetIncremented$.MODULE$);
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            set = super.addPartitions((Map<TopicPartition, InitialFetchState>)filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateFullyAndStartAt(offset, true);
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)x0$1._1();
        boolean bl = $this.replicaMgr.futureLogExists(tp);
        return bl;
    }

    public ReplicaAlterLogDirsThread(String name, LeaderEndPoint leader, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats, int fetchBackOffMs) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, leader, failedPartitions, fetchBackOffMs, false, brokerTopicStats);
        this.isOffsetForLeaderEpochSupported = true;
    }
}

