/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kafka.log.LogConcurrencyTest$FetchedBatch$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.utils.KafkaScheduler;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\t-e\u0001\u0002\u001d:\u0001yBQ!\u0012\u0001\u0005\u0002\u0019Cq!\u0013\u0001C\u0002\u0013%!\n\u0003\u0004R\u0001\u0001\u0006Ia\u0013\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u0011\u0019Q\u0006\u0001)A\u0005)\"91\f\u0001b\u0001\n\u0013a\u0006BB2\u0001A\u0003%Q\fC\u0004e\u0001\t\u0007I\u0011B3\t\r9\u0004\u0001\u0015!\u0003g\u0011\u001dy\u0007A1A\u0005\n\u0015Da\u0001\u001d\u0001!\u0002\u00131\u0007\"B9\u0001\t\u0003\u0011\bBBA\u0004\u0001\u0011\u0005!\u000f\u0003\u0004\u0002\u0012\u0001!\tA\u001d\u0005\u0007\u00037\u0001A\u0011\u0001:\t\u000f\u0005E\u0001\u0001\"\u0001\u0002 \u00191\u0011\u0011\u0006\u0001\u0005\u0003WA\u0011BO\t\u0003\u0002\u0003\u0006I!a\t\t\u0015\u0005\u001d\u0013C!A!\u0002\u0013\tI\u0005\u0003\u0004F#\u0011\u0005\u0011q\n\u0005\n\u00033\n\"\u0019!C\u0001\u00037B\u0001Ba\t\u0012A\u0003%\u0011Q\f\u0005\u0007\u0005K\tB\u0011\t:\u0007\r\t\u001d\u0002\u0001\u0002B\u0015\u0011%Q\u0004D!A!\u0002\u0013\t\u0019\u0003\u0003\u0006\u0002Ha\u0011\t\u0011)A\u0005\u0003+Ca!\u0012\r\u0005\u0002\t-\u0002B\u0002B\u00131\u0011\u0005#\u000fC\u0004\u00034\u0001!IA!\u000e\t\u0013\t\u0005\u0003!%A\u0005\n\t\r\u0003b\u0002B$\u0001\u0011%!\u0011\n\u0004\u0007\u0003_\u0002A)!\u001d\t\u0015\u0005E\u0005E!f\u0001\n\u0003\t\u0019\n\u0003\u0006\u0002\u001c\u0002\u0012\t\u0012)A\u0005\u0003+C!\"!(!\u0005+\u0007I\u0011AAP\u0011)\t\t\u000b\tB\tB\u0003%\u0011\u0011\n\u0005\u0007\u000b\u0002\"\t!a)\t\u000f\u0005%\u0006\u0005\"\u0011\u0002,\"I\u0011Q\u0018\u0011\u0002\u0002\u0013\u0005\u0011q\u0018\u0005\n\u0003\u000b\u0004\u0013\u0013!C\u0001\u0003\u000fD\u0011\"!8!#\u0003%\t!a8\t\u0013\u0005\r\b%!A\u0005B\u0005\u0015\b\"CAvA\u0005\u0005I\u0011AAP\u0011%\ti\u000fIA\u0001\n\u0003\ty\u000fC\u0005\u0002|\u0002\n\t\u0011\"\u0011\u0002~\"I!q\u0001\u0011\u0002\u0002\u0013\u0005!\u0011\u0002\u0005\n\u0005'\u0001\u0013\u0011!C!\u0005+A\u0011B!\u0007!\u0003\u0003%\tEa\u0007\t\u0013\tu\u0001%!A\u0005B\t}q!\u0003B+\u0001\u0005\u0005\t\u0012\u0002B,\r%\ty\u0007AA\u0001\u0012\u0013\u0011I\u0006\u0003\u0004Fg\u0011\u0005!1\u000e\u0005\n\u0003S\u001b\u0014\u0011!C#\u0005[B\u0011Ba\u001c4\u0003\u0003%\tI!\u001d\t\u0013\t]4'!A\u0005\u0002\ne$A\u0005'pO\u000e{gnY;se\u0016t7-\u001f+fgRT!AO\u001e\u0002\u00071|wMC\u0001=\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A \u0011\u0005\u0001\u001bU\"A!\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R!\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\t\u0005\u0002I\u00015\t\u0011(\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugV\t1\n\u0005\u0002M\u001f6\tQJ\u0003\u0002Ow\u000511/\u001a:wKJL!\u0001U'\u0003!\t\u0013xn[3s)>\u0004\u0018nY*uCR\u001c\u0018!\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;tA\u00051!/\u00198e_6,\u0012\u0001\u0016\t\u0003+bk\u0011A\u0016\u0006\u0003/\u0006\u000bA!\u001e;jY&\u0011\u0011L\u0016\u0002\u0007%\u0006tGm\\7\u0002\u000fI\fg\u000eZ8nA\u0005I1o\u00195fIVdWM]\u000b\u0002;B\u0011a,Y\u0007\u0002?*\u0011\u0001mO\u0001\u0006kRLGn]\u0005\u0003E~\u0013abS1gW\u0006\u001c6\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002\na\u0001^7q\t&\u0014X#\u00014\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017AA5p\u0015\u0005Y\u0017\u0001\u00026bm\u0006L!!\u001c5\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003\u0019awn\u001a#je\u00069An\\4ESJ\u0004\u0013!B:fiV\u0004H#A:\u0011\u0005\u0001#\u0018BA;B\u0005\u0011)f.\u001b;)\u000519\bc\u0001=\u0002\u00045\t\u0011P\u0003\u0002{w\u0006\u0019\u0011\r]5\u000b\u0005ql\u0018a\u00026va&$XM\u001d\u0006\u0003}~\fQA[;oSRT!!!\u0001\u0002\u0007=\u0014x-C\u0002\u0002\u0006e\u0014!BQ3g_J,W)Y2i\u0003!\u0019\b.\u001e;e_^t\u0007fA\u0007\u0002\fA\u0019\u00010!\u0004\n\u0007\u0005=\u0011PA\u0005BMR,'/R1dQ\u0006qB/Z:u+:\u001cw.\\7jiR,G\rR1uC:{GoQ8ogVlW\r\u001a\u0015\u0004\u001d\u0005U\u0001c\u0001=\u0002\u0018%\u0019\u0011\u0011D=\u0003\tQ+7\u000f^\u00013i\u0016\u001cH/\u00168d_6l\u0017\u000e\u001e;fI\u0012\u000bG/\u0019(pi\u000e{gn];nK\u00124%/Z9vK:$8+Z4nK:$(k\u001c7mg\"\u001aq\"!\u0006\u0015\u0007M\f\t\u0003\u0003\u0004;!\u0001\u0007\u00111\u0005\t\u0004\u0011\u0006\u0015\u0012bAA\u0014s\tQQK\\5gS\u0016$Gj\\4\u0003\u0019\r{gn];nKJ$\u0016m]6\u0014\u000bE\ti#!\u000f\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\rk\u0003\u0011a\u0017M\\4\n\t\u0005]\u0012\u0011\u0007\u0002\u0007\u001f\nTWm\u0019;\u0011\u000b\u0005m\u00121I:\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\n!bY8oGV\u0014(/\u001a8u\u0015\t9&.\u0003\u0003\u0002F\u0005u\"\u0001C\"bY2\f'\r\\3\u0002\u00151\f7\u000f^(gMN,G\u000fE\u0002A\u0003\u0017J1!!\u0014B\u0005\rIe\u000e\u001e\u000b\u0007\u0003#\n)&a\u0016\u0011\u0007\u0005M\u0013#D\u0001\u0001\u0011\u0019QD\u00031\u0001\u0002$!9\u0011q\t\u000bA\u0002\u0005%\u0013aD2p]N,X.\u001a3CCR\u001c\u0007.Z:\u0016\u0005\u0005u\u0003CBA0\u0003S\ni'\u0004\u0002\u0002b)!\u00111MA3\u0003\u001diW\u000f^1cY\u0016T1!a\u001aB\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003W\n\tG\u0001\u0006MSN$()\u001e4gKJ\u00042!a\u0015!\u000511U\r^2iK\u0012\u0014\u0015\r^2i'\u0019\u0001s(a\u001d\u0002zA\u0019\u0001)!\u001e\n\u0007\u0005]\u0014IA\u0004Qe>$Wo\u0019;\u0011\t\u0005m\u00141\u0012\b\u0005\u0003{\n9I\u0004\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\r\t\u0019)P\u0001\u0007yI|w\u000e\u001e \n\u0003\tK1!!#B\u0003\u001d\u0001\u0018mY6bO\u0016LA!!$\u0002\u0010\na1+\u001a:jC2L'0\u00192mK*\u0019\u0011\u0011R!\u0002\u0015\t\f7/Z(gMN,G/\u0006\u0002\u0002\u0016B\u0019\u0001)a&\n\u0007\u0005e\u0015I\u0001\u0003M_:<\u0017a\u00032bg\u0016|eMZ:fi\u0002\nQ!\u001a9pG\",\"!!\u0013\u0002\r\u0015\u0004xn\u00195!)\u0019\ti'!*\u0002(\"9\u0011\u0011S\u0013A\u0002\u0005U\u0005bBAOK\u0001\u0007\u0011\u0011J\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\u0016\t\u0005\u0003_\u000b9L\u0004\u0003\u00022\u0006M\u0006cAA@\u0003&\u0019\u0011QW!\u0002\rA\u0013X\rZ3g\u0013\u0011\tI,a/\u0003\rM#(/\u001b8h\u0015\r\t),Q\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002n\u0005\u0005\u00171\u0019\u0005\n\u0003#;\u0003\u0013!a\u0001\u0003+C\u0011\"!((!\u0003\u0005\r!!\u0013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u001a\u0016\u0005\u0003+\u000bYm\u000b\u0002\u0002NB!\u0011qZAm\u001b\t\t\tN\u0003\u0003\u0002T\u0006U\u0017!C;oG\",7m[3e\u0015\r\t9.Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAn\u0003#\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!9+\t\u0005%\u00131Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u001d\b\u0003BA\u0018\u0003SLA!!/\u00022\u0005a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAy\u0003o\u00042\u0001QAz\u0013\r\t)0\u0011\u0002\u0004\u0003:L\b\"CA}Y\u0005\u0005\t\u0019AA%\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q \t\u0007\u0005\u0003\u0011\u0019!!=\u000e\u0005\u0005\u0015\u0014\u0002\u0002B\u0003\u0003K\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!1\u0002B\t!\r\u0001%QB\u0005\u0004\u0005\u001f\t%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003st\u0013\u0011!a\u0001\u0003c\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011q\u001dB\f\u0011%\tIpLA\u0001\u0002\u0004\tI%\u0001\u0005iCND7i\u001c3f)\t\tI%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005\u0017\u0011\t\u0003C\u0005\u0002zF\n\t\u00111\u0001\u0002r\u0006\u00012m\u001c8tk6,GMQ1uG\",7\u000fI\u0001\u0005G\u0006dGNA\u0007M_\u001e\f\u0005\u000f]3oIR\u000b7o[\n\u00061\u00055\u0012\u0011\b\u000b\u0007\u0005[\u0011yC!\r\u0011\u0007\u0005M\u0003\u0004\u0003\u0004;7\u0001\u0007\u00111\u0005\u0005\b\u0003\u000fZ\u0002\u0019AAK\u0003%\u0019'/Z1uK2{w\r\u0006\u0003\u0002$\t]\u0002\"\u0003B\u001d;A\u0005\t\u0019\u0001B\u001e\u0003\u0019\u0019wN\u001c4jOB\u0019\u0001J!\u0010\n\u0007\t}\u0012HA\u0005M_\u001e\u001cuN\u001c4jO\u0006\u00192M]3bi\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q\t\u0016\u0005\u0005w\tY-\u0001\u000bwC2LG-\u0019;f\u0007>t7/^7fI\u0012\u000bG/\u0019\u000b\u0006g\n-#Q\n\u0005\u0007u}\u0001\r!a\t\t\u000f\u0005es\u00041\u0001\u0003PA1\u00111\u0010B)\u0003[JAAa\u0015\u0002\u0010\nA\u0011\n^3sC\ndW-\u0001\u0007GKR\u001c\u0007.\u001a3CCR\u001c\u0007\u000eE\u0002\u0002TM\u001aRa\rB.\u0005O\u0002\"B!\u0018\u0003d\u0005U\u0015\u0011JA7\u001b\t\u0011yFC\u0002\u0003b\u0005\u000bqA];oi&lW-\u0003\u0003\u0003f\t}#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA\u0019qM!\u001b\n\u0007\u00055\u0005\u000e\u0006\u0002\u0003XQ\u0011\u0011q]\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003[\u0012\u0019H!\u001e\t\u000f\u0005Ee\u00071\u0001\u0002\u0016\"9\u0011Q\u0014\u001cA\u0002\u0005%\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0005w\u00129\tE\u0003A\u0005{\u0012\t)C\u0002\u0003\u0000\u0005\u0013aa\u00149uS>t\u0007c\u0002!\u0003\u0004\u0006U\u0015\u0011J\u0005\u0004\u0005\u000b\u000b%A\u0002+va2,'\u0007C\u0005\u0003\n^\n\t\u00111\u0001\u0002n\u0005\u0019\u0001\u0010\n\u0019")
public class LogConcurrencyTest {
    private volatile LogConcurrencyTest$FetchedBatch$ FetchedBatch$module;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Random kafka$log$LogConcurrencyTest$$random = new Random();
    private final KafkaScheduler scheduler = new KafkaScheduler(1, "kafka-scheduler-", true);
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());

    private LogConcurrencyTest$FetchedBatch$ FetchedBatch() {
        if (this.FetchedBatch$module == null) {
            this.FetchedBatch$lzycompute$1();
        }
        return this.FetchedBatch$module;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Random kafka$log$LogConcurrencyTest$$random() {
        return this.kafka$log$LogConcurrencyTest$$random;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private File logDir() {
        return this.logDir;
    }

    @BeforeEach
    public void setup() {
        this.scheduler().startup();
    }

    @AfterEach
    public void shutdown() {
        this.scheduler().shutdown();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testUncommittedDataNotConsumed() {
        this.testUncommittedDataNotConsumed(this.createLog(this.createLog$default$1()));
    }

    @Test
    public void testUncommittedDataNotConsumedFrequentSegmentRolls() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(237));
        LogConfig logConfig = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        this.testUncommittedDataNotConsumed(this.createLog(logConfig));
    }

    public void testUncommittedDataNotConsumed(UnifiedLog log) {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            int maxOffset = 5000;
            ConsumerTask consumer = new ConsumerTask(this, log, maxOffset);
            LogAppendTask appendTask = new LogAppendTask(this, log, maxOffset);
            Future<BoxedUnit> consumerFuture = executor.submit(consumer);
            executor.submit(appendTask).get();
            consumerFuture.get();
            this.validateConsumedData(log, (Iterable<FetchedBatch>)consumer.consumedBatches());
        }
        finally {
            executor.shutdownNow();
        }
    }

    private UnifiedLog createLog(LogConfig config) {
        ConcurrentHashMap concurrentHashMap;
        File x$1 = this.logDir();
        KafkaScheduler x$5 = this.scheduler();
        BrokerTopicStats x$6 = this.brokerTopicStats();
        Time x$7 = Time.SYSTEM;
        int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean bl = true;
        ConcurrentHashMap concurrentHashMap2 = concurrentHashMap = new ConcurrentHashMap();
        concurrentHashMap = null;
        ConcurrentHashMap x$15 = concurrentHashMap2;
        return UnifiedLog$.MODULE$.apply(x$1, config, 0L, 0L, (Scheduler)x$5, x$6, x$7, 300000, 3600000, x$10, x$11, bl, (Option)x$12, true, x$15);
    }

    private LogConfig createLog$default$1() {
        return new LogConfig((Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
    }

    private void validateConsumedData(UnifiedLog log, Iterable<FetchedBatch> consumedBatches) {
        Iterator iter = consumedBatches.iterator();
        log.logSegments().foreach((Function1 & Serializable)segment -> {
            LogConcurrencyTest.$anonfun$validateConsumedData$1(iter, segment);
            return BoxedUnit.UNIT;
        });
    }

    private final void FetchedBatch$lzycompute$1() {
        synchronized (this) {
            if (this.FetchedBatch$module == null) {
                this.FetchedBatch$module = new LogConcurrencyTest$FetchedBatch$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$validateConsumedData$1(Iterator iter$1, LogSegment segment) {
        segment.log().batches().forEach(batch -> {
            if (iter$1.hasNext()) {
                FetchedBatch consumedBatch = (FetchedBatch)iter$1.next();
                try {
                    Assertions.assertEquals((int)batch.partitionLeaderEpoch(), (int)consumedBatch.epoch(), (String)"Consumed batch with unexpected leader epoch");
                    Assertions.assertEquals((long)batch.baseOffset(), (long)consumedBatch.baseOffset(), (String)"Consumed batch with unexpected base offset");
                    return;
                }
                catch (Throwable t) {
                    throw new AssertionError(new StringBuilder(0).append(new StringBuilder(16).append("Consumed batch ").append(consumedBatch).append(" ").toString()).append(new StringBuilder(42).append("does not match next expected batch in log ").append(batch).toString()).toString(), t);
                }
            }
        });
    }

    private class ConsumerTask
    implements Callable<BoxedUnit> {
        private final UnifiedLog log;
        private final int lastOffset;
        private final ListBuffer<FetchedBatch> consumedBatches;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public ListBuffer<FetchedBatch> consumedBatches() {
            return this.consumedBatches;
        }

        @Override
        public void call() {
            LongRef fetchOffset = LongRef.create((long)0L);
            while (this.log.highWatermark() < (long)this.lastOffset) {
                this.log.read(fetchOffset.elem, 1, (FetchIsolation)FetchHighWatermark$.MODULE$, true).records().batches().forEach(batch -> {
                    this.consumedBatches().$plus$eq((Object)new FetchedBatch(this.kafka$log$LogConcurrencyTest$ConsumerTask$$$outer(), batch.baseOffset(), batch.partitionLeaderEpoch()));
                    fetchOffset$1.elem = batch.lastOffset() + 1L;
                });
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$ConsumerTask$$$outer() {
            return this.$outer;
        }

        public ConsumerTask(LogConcurrencyTest $outer, UnifiedLog log, int lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.consumedBatches = ListBuffer$.MODULE$.empty();
        }
    }

    private class FetchedBatch
    implements Product,
    Serializable {
        private final long baseOffset;
        private final int epoch;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long baseOffset() {
            return this.baseOffset;
        }

        public int epoch() {
            return this.epoch;
        }

        public String toString() {
            return new StringBuilder(33).append("FetchedBatch(baseOffset=").append(this.baseOffset()).append(", epoch=").append(this.epoch()).append(")").toString();
        }

        public FetchedBatch copy(long baseOffset, int epoch) {
            return new FetchedBatch(this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer(), baseOffset, epoch);
        }

        public long copy$default$1() {
            return this.baseOffset();
        }

        public int copy$default$2() {
            return this.epoch();
        }

        public String productPrefix() {
            return "FetchedBatch";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.baseOffset());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.epoch());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FetchedBatch;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "baseOffset";
                }
                case 1: {
                    return "epoch";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.longHash((long)this.baseOffset())), (int)this.epoch()), (int)2);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof FetchedBatch && ((FetchedBatch)x$1).kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() == this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer();
                    if (!bl) break block3;
                    FetchedBatch fetchedBatch = (FetchedBatch)x$1;
                    if (!(this.baseOffset() == fetchedBatch.baseOffset() && this.epoch() == fetchedBatch.epoch() && fetchedBatch.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() {
            return this.$outer;
        }

        public FetchedBatch(LogConcurrencyTest $outer, long baseOffset, int epoch) {
            this.baseOffset = baseOffset;
            this.epoch = epoch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    private class LogAppendTask
    implements Callable<BoxedUnit> {
        private final UnifiedLog log;
        private final long lastOffset;
        public final /* synthetic */ LogConcurrencyTest $outer;

        @Override
        public void call() {
            int leaderEpoch = 1;
            boolean isLeader = true;
            block4: while (this.log.highWatermark() < this.lastOffset) {
                int n = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(2);
                switch (n) {
                    case 0: {
                        CompressionType compressionType;
                        LogOffsetMetadata logEndOffsetMetadata = this.log.logEndOffsetMetadata();
                        long logEndOffset = logEndOffsetMetadata.messageOffset();
                        int batchSize = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(9) + 1;
                        IndexedSeq records = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), batchSize).map((Function1 & Serializable)i -> LogAppendTask.$anonfun$call$2(BoxesRunTime.unboxToInt((Object)i)));
                        if (isLeader) {
                            this.log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1), leaderEpoch, this.log.appendAsLeader$default$3(), this.log.appendAsLeader$default$4(), this.log.appendAsLeader$default$5());
                            this.log.maybeIncrementHighWatermark(logEndOffsetMetadata);
                            continue block4;
                        }
                        byte by = 2;
                        CompressionType compressionType2 = compressionType = CompressionType.NONE;
                        compressionType = null;
                        CompressionType x$5 = compressionType2;
                        long l = -1L;
                        short s = -1;
                        int n2 = -1;
                        this.log.appendAsFollower(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, by, x$5, l, s, n2, logEndOffset, leaderEpoch));
                        this.log.updateHighWatermark(logEndOffset);
                        continue block4;
                    }
                    case 1: {
                        isLeader = !isLeader;
                        ++leaderEpoch;
                        if (isLeader) continue block4;
                        this.log.truncateTo(this.log.highWatermark());
                        continue block4;
                    }
                }
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$LogAppendTask$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ SimpleRecord $anonfun$call$2(int i) {
            return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        }

        public LogAppendTask(LogConcurrencyTest $outer, UnifiedLog log, long lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

