/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import kafka.network.RequestChannel;
import kafka.network.RequestConvertToJson$;
import kafka.server.EnvelopeUtils$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%h\u0001\u0002\u000b\u0016\u0001iAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u0004/\u0001\u0001\u0006Ia\n\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0011\u0019!\u0004\u0001)A\u0005c!)A\n\u0001C\u0001\u001b\")A\f\u0001C\u0001\u001b\")a\f\u0001C\u0001\u001b\")\u0001\r\u0001C\u0001\u001b\")!\r\u0001C\u0001G\"9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0001bBA\u001a\u0001\u0011%\u0011Q\u0007\u0005\b\u0003\u0003\u0002A\u0011BA\"\u0011\u001d\t)\u0006\u0001C\u0005\u0003/Bq!!\u0014\u0001\t\u0003\t\u0019\u0007C\u0004\u0002j\u0001!I!a\u001b\t\u000f\u0005\r\u0005\u0001\"\u0003\u0002\u0006\"9\u00111\u0011\u0001\u0005\n\u0005e\u0006bBAi\u0001\u0011%\u00111\u001b\u0002\u0013%\u0016\fX/Z:u\u0007\"\fgN\\3m)\u0016\u001cHO\u0003\u0002\u0017/\u00059a.\u001a;x_J\\'\"\u0001\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0007\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0019\u0003C\u0001\u0013\u0001\u001b\u0005)\u0012!\u0006:fcV,7\u000f^\"iC:tW\r\\'fiJL7m]\u000b\u0002OA\u0011\u0001f\u000b\b\u0003I%J!AK\u000b\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&\u0011A&\f\u0002\b\u001b\u0016$(/[2t\u0015\tQS#\u0001\fsKF,Xm\u001d;DQ\u0006tg.\u001a7NKR\u0014\u0018nY:!\u00039\u0001(/\u001b8dSB\fGnU3sI\u0016,\u0012!\r\n\u0004eUjd\u0001B\u001a\u0006\u0001E\u0012A\u0002\u0010:fM&tW-\\3oiz\nq\u0002\u001d:j]\u000eL\u0007/\u00197TKJ$W\r\t\t\u0003mmj\u0011a\u000e\u0006\u0003qe\nA\u0001\\1oO*\t!(\u0001\u0003kCZ\f\u0017B\u0001\u001f8\u0005\u0019y%M[3diB\u0011aHS\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0005CV$\bN\u0003\u0002C\u0007\u0006A1/Z2ve&$\u0018P\u0003\u0002E\u000b\u000611m\\7n_:T!\u0001\u0007$\u000b\u0005\u001dC\u0015AB1qC\u000eDWMC\u0001J\u0003\ry'oZ\u0005\u0003\u0017~\u00121cS1gW\u0006\u0004&/\u001b8dSB\fGnU3sI\u0016\f\u0011\u0003^3ti\u0006cG/\u001a:SKF,Xm\u001d;t)\u0005q\u0005C\u0001\u000fP\u0013\t\u0001VD\u0001\u0003V]&$\bF\u0001\u0004S!\t\u0019&,D\u0001U\u0015\t)f+A\u0002ba&T!a\u0016-\u0002\u000f),\b/\u001b;fe*\u0011\u0011\fS\u0001\u0006UVt\u0017\u000e^\u0005\u00037R\u0013A\u0001V3ti\u0006aB/Z:u\u0013:\u001c'/Z7f]R\fG.\u00117uKJ\u0014V-];fgR\u001c\bFA\u0004S\u0003\t\"Xm\u001d;O_:\fE\u000e^3s%\u0016\fX/Z:ug:{G\u000f\u0016:b]N4wN]7fI\"\u0012\u0001BU\u0001\u0011i\u0016\u001cHOS:p]J+\u0017/^3tiND#!\u0003*\u00023Q,7\u000f\u001e\"vS2$WI\u001c<fY>\u0004XMU3ta>t7/\u001a\u000b\u0003\u001d\u0012DQ!\u001a\u0006A\u0002\u0019\fQ!\u001a:s_J\u0004\"a\u001a6\u000e\u0003!T!![\"\u0002\u0011A\u0014x\u000e^8d_2L!a\u001b5\u0003\r\u0015\u0013(o\u001c:tQ\u0019QQ.\u001e<xqB\u0011an]\u0007\u0002_*\u0011\u0001/]\u0001\taJ|g/\u001b3fe*\u0011!OV\u0001\u0007a\u0006\u0014\u0018-\\:\n\u0005Q|'AC#ok6\u001cv.\u001e:dK\u0006)a/\u00197vK\u000e\na-A\u0003oC6,7\u000fL\u0002zwv\f\u0013A_\u0001\u0005\u001d>sU)I\u0001}\u0003q\u0019E*V*U\u000bJ{\u0016)\u0016+I\u001fJK%,\u0011+J\u001f:{f)Q%M\u000b\u0012\u000b\u0013A`\u0001\u000f\u001d>#vlQ(O)J{E\nT#SQ\rQ\u0011\u0011\u0001\t\u0005\u0003\u0007\t)!D\u0001r\u0013\r\t9!\u001d\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018a\u00062vS2$7I]3bi\u0016$v\u000e]5d%\u0016\fX/Z:u)\u0011\ti!!\u0007\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005D\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\f\u0003#\u00111c\u0011:fCR,Gk\u001c9jGN\u0014V-];fgRDq!a\u0007\f\u0001\u0004\ti\"A\u0003u_BL7\r\u0005\u0003\u0002 \u00055b\u0002BA\u0011\u0003S\u00012!a\t\u001e\u001b\t\t)CC\u0002\u0002(e\ta\u0001\u0010:p_Rt\u0014bAA\u0016;\u00051\u0001K]3eK\u001aLA!a\f\u00022\t11\u000b\u001e:j]\u001eT1!a\u000b\u001e\u0003a\u0011W/\u001b7e\u0007J,\u0017\r^3U_BL7MU3ta>t7/\u001a\u000b\u0007\u0003o\ti$a\u0010\u0011\t\u0005=\u0011\u0011H\u0005\u0005\u0003w\t\tB\u0001\u000bDe\u0016\fG/\u001a+pa&\u001c7OU3ta>t7/\u001a\u0005\b\u00037a\u0001\u0019AA\u000f\u0011\u0015)G\u00021\u0001g\u0003u\u0011W/\u001b7e+:<(/\u00199qK\u0012,eN^3m_B,'+Z9vKN$H\u0003BA#\u0003\u0017\u00022\u0001KA$\u0013\r\tI%\f\u0002\b%\u0016\fX/Z:u\u0011\u001d\ti%\u0004a\u0001\u0003\u001f\nqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002\u0010\u0005E\u0013\u0002BA*\u0003#\u0011q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f^\u0001\fSN4\u0016\r\\5e\u0015N|g\u000e\u0006\u0003\u0002Z\u0005}\u0003c\u0001\u000f\u0002\\%\u0019\u0011QL\u000f\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\r\bA\u0002\u0005u\u0011aA:ueR!\u0011QIA3\u0011\u001d\t9g\u0004a\u0001\u0003\u001f\n1A]3r\u0003EqWm\u001e*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u000b\u0005\u0003[\n\u0019\b\u0005\u0003\u0002\u0010\u0005=\u0014\u0002BA9\u0003#\u0011aBU3rk\u0016\u001cHoQ8oi\u0016DH\u000fC\u0004\u0002vA\u0001\r!a\u001e\u0002\r\t,hMZ3s!\u0011\tI(a \u000e\u0005\u0005m$bAA?s\u0005\u0019a.[8\n\t\u0005\u0005\u00151\u0010\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018!\u0002;p\u001b\u0006\u0004H\u0003BAD\u0003'\u0003\u0002\"!#\u0002\u0010\u0006u\u0011QD\u0007\u0003\u0003\u0017S1!!$\u001e\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003#\u000bYIA\u0002NCBDq!!&\u0012\u0001\u0004\t9*\u0001\u0004d_:4\u0017n\u001a\t\u0005\u00033\u000b\u0019L\u0004\u0003\u0002\u001c\u0006=f\u0002BAO\u0003[sA!a(\u0002,:!\u0011\u0011UAU\u001d\u0011\t\u0019+a*\u000f\t\u0005\r\u0012QU\u0005\u0002\u0013&\u0011q\tS\u0005\u00031\u0019K!\u0001R#\n\u0007\u0005M1)\u0003\u0003\u00022\u0006E\u0011aE!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z9vKN$\u0018\u0002BA[\u0003o\u0013aaQ8oM&<'\u0002BAY\u0003#!B!a\"\u0002<\"9\u0011Q\u0013\nA\u0002\u0005u\u0006\u0003BA`\u0003\u0017tA!!1\u0002H6\u0011\u00111\u0019\u0006\u0004\u0003\u000b\u001c\u0015aB7fgN\fw-Z\u0005\u0005\u0003\u0013\f\u0019-\u0001\u0012J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hgJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0003\u001b\fyMA\rBYR,'/\u00192mK\u000e{gNZ5h\u0007>dG.Z2uS>t'\u0002BAe\u0003\u0007\fQCY;jY\u0012,eN^3m_B,'+Z:q_:\u001cX\r\u0006\u0004\u0002V\u0006m\u0017q\u001c\t\u0005\u0003\u001f\t9.\u0003\u0003\u0002Z\u0006E!\u0001E#om\u0016dw\u000e]3SKN\u0004xN\\:f\u0011\u001d\tin\u0005a\u0001\u0003\u000b\n\u0011\"\u001e8xe\u0006\u0004\b/\u001a3\t\u000f\u0005\u00058\u00031\u0001\u0002d\u0006A!/Z:q_:\u001cX\r\u0005\u0003\u0002\u0010\u0005\u0015\u0018\u0002BAt\u0003#\u0011\u0001#\u00112tiJ\f7\r\u001e*fgB|gn]3")
public class RequestChannelTest {
    private final RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
    private final KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null){

        public byte[] serialize(KafkaPrincipal principal) {
            return principal.toString().getBytes(StandardCharsets.UTF_8);
        }

        public KafkaPrincipal deserialize(byte[] bytes) {
            return SecurityUtils.parseKafkaPrincipal((String)new String(bytes, StandardCharsets.UTF_8));
        }
    };

    private RequestChannel.Metrics requestChannelMetrics() {
        return this.requestChannelMetrics;
    }

    private KafkaPrincipalSerde principalSerde() {
        return this.principalSerde;
    }

    @Test
    public void testAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry keystoreLocation = new AlterConfigsRequest.ConfigEntry("ssl.keystore.location", "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystoreLocation, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")})), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystoreLocation, (List)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$)), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeyPassword = new AlterConfigsRequest.ConfigEntry(new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString(), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)listenerKeyPassword, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeyPassword.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeystore = new AlterConfigsRequest.ConfigEntry(new StringBuilder(44).append("listener.name.internal.").append("ssl.keystore.location").toString(), "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)listenerKeystore, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeystore.name()), (Object)"/path/to/keystore")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainJaasConfig = new AlterConfigsRequest.ConfigEntry(new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString(), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)plainJaasConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainJaasConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainLoginCallback = new AlterConfigsRequest.ConfigEntry(new StringBuilder(62).append("listener.name.internal.plain.").append("sasl.login.callback.handler.class").toString(), "test.LoginClass");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)plainLoginCallback, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainLoginCallback.name()), (Object)plainLoginCallback.value())})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry customConfig = new AlterConfigsRequest.ConfigEntry("custom.config", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)customConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        AlterConfigsRequest.ConfigEntry compressionType = new AlterConfigsRequest.ConfigEntry("compression.type", "lz4");
        this.verifyConfig$1(topicResource, (Seq)new .colon.colon((Object)compressionType, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")})), sensitiveValue);
        this.verifyConfig$1(topicResource, (Seq)new .colon.colon((Object)customConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.emptyMap(), true).build());
        Assertions.assertEquals(Collections.emptyMap(), (Object)((AlterConfigsRequest)alterConfigs.loggableRequest()).configs());
    }

    @Test
    public void testIncrementalAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        Map keystorePassword = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystorePassword, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map keystoreLocation = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystoreLocation, keystoreLocation, sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, (Map)keystoreLocation.$plus$plus((IterableOnce)keystorePassword), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeyPassword = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString()), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeyPassword, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString()), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeystore = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(44).append("listener.name.internal.").append("ssl.keystore.location").toString()), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeystore, listenerKeystore, sensitiveValue);
        Map plainJaasConfig = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString()), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainJaasConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString()), (Object)"[hidden]")})), sensitiveValue);
        Map plainLoginCallback = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(62).append("listener.name.internal.plain.").append("sasl.login.callback.handler.class").toString()), (Object)"test.LoginClass")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainLoginCallback, plainLoginCallback, sensitiveValue);
        Map sslProtocols = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.APPEND, sslProtocols, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SUBTRACT, sslProtocols, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        Map cipherSuites = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.cipher.suites"), null)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.DELETE, cipherSuites, cipherSuites, sensitiveValue);
        Map customConfig = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        Map compressionType = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")}));
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, compressionType, compressionType, sensitiveValue);
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
    }

    @Test
    public void testNonAlterRequestsNotTransformed() {
        RequestChannel.Request metadataRequest = this.request(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"topic"}))).asJava(), true).build());
        Assertions.assertSame((Object)metadataRequest.body(ClassTag$.MODULE$.apply(MetadataRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl())), (Object)metadataRequest.loggableRequest());
    }

    @Test
    public void testJsonRequests() {
        String sensitiveValue = "secret";
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        .colon.colon entries = new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(resource, new AlterConfigsRequest.Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)entries).asJavaCollection())), true).build());
        Assertions.assertTrue((boolean)this.isValidJson(RequestConvertToJson$.MODULE$.request(alterConfigs.loggableRequest()).toString()));
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"NONE", "CLUSTER_AUTHORIZATION_FAILED", "NOT_CONTROLLER"})
    public void testBuildEnvelopeResponse(Errors error) {
        String topic = "foo";
        CreateTopicsRequest createTopicRequest = this.buildCreateTopicRequest(topic);
        RequestChannel.Request unwrapped = this.buildUnwrappedEnvelopeRequest((AbstractRequest)createTopicRequest);
        CreateTopicsResponse createTopicResponse = this.buildCreateTopicResponse(topic, error);
        EnvelopeResponse envelopeResponse = this.buildEnvelopeResponse(unwrapped, (AbstractResponse)createTopicResponse);
        if (Errors.NOT_CONTROLLER.equals(error)) {
            Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)envelopeResponse.error());
            Assertions.assertNull((Object)envelopeResponse.responseData());
            return;
        }
        Assertions.assertEquals((Object)Errors.NONE, (Object)envelopeResponse.error());
        AbstractResponse unwrappedResponse = AbstractResponse.parseResponse((ByteBuffer)envelopeResponse.responseData(), (RequestHeader)unwrapped.header());
        Assertions.assertEquals((Object)createTopicResponse.data(), (Object)unwrappedResponse.data());
    }

    private CreateTopicsRequest buildCreateTopicRequest(String topic) {
        CreateTopicsRequestData requestData = new CreateTopicsRequestData();
        requestData.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName(topic).setReplicationFactor((short)-1).setNumPartitions(-1));
        return (CreateTopicsRequest)new CreateTopicsRequest.Builder(requestData).build();
    }

    private CreateTopicsResponse buildCreateTopicResponse(String topic, Errors error) {
        CreateTopicsResponseData responseData = new CreateTopicsResponseData();
        responseData.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(topic).setErrorCode(error.code()));
        return new CreateTopicsResponse(responseData);
    }

    private RequestChannel.Request buildUnwrappedEnvelopeRequest(AbstractRequest request2) {
        RequestChannel.Request wrappedRequest = TestUtils$.MODULE$.buildEnvelopeRequest(request2, this.principalSerde(), this.requestChannelMetrics(), System.nanoTime(), -1L, true);
        AtomicReference unwrappedRequest = new AtomicReference();
        EnvelopeUtils$.MODULE$.handleEnvelopeRequest(wrappedRequest, this.requestChannelMetrics(), (Function1 & Serializable)request -> {
            unwrappedRequest.set(request);
            return BoxedUnit.UNIT;
        });
        return (RequestChannel.Request)unwrappedRequest.get();
    }

    private boolean isValidJson(String str) {
        try {
            new ObjectMapper().readTree(str);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public RequestChannel.Request request(AbstractRequest req) {
        ByteBuffer buffer = req.serializeWithHeader(new RequestHeader(req.apiKey(), req.version(), "client-id", 1));
        RequestContext requestContext = this.newRequestContext(buffer);
        return new RequestChannel.Request(1, requestContext, 0L, (MemoryPool)Mockito.mock(MemoryPool.class), buffer, (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class), (Option)None$.MODULE$);
    }

    private RequestContext newRequestContext(ByteBuffer buffer) {
        return new RequestContext(RequestHeader.parse((ByteBuffer)buffer), "connection-id", InetAddress.getLoopbackAddress(), new KafkaPrincipal("User", "user"), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, new ClientInformation("name", "version"), false);
    }

    private Map<String, String> toMap(AlterConfigsRequest.Config config) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(config.entries()).asScala().map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, String> toMap(IncrementalAlterConfigsRequestData.AlterableConfigCollection config) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)config).asScala().map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private EnvelopeResponse buildEnvelopeResponse(RequestChannel.Request unwrapped, AbstractResponse response) {
        Assertions.assertTrue((boolean)unwrapped.envelope().isDefined());
        RequestChannel.Request envelope = (RequestChannel.Request)unwrapped.envelope().get();
        ByteBuffer sendBytes = TestUtils.toBuffer((Send)unwrapped.buildResponseSend(response));
        Assertions.assertEquals((int)sendBytes.getInt(), (int)sendBytes.remaining());
        AbstractResponse envelopeResponse = AbstractResponse.parseResponse((ByteBuffer)sendBytes, (RequestHeader)envelope.header());
        Assertions.assertTrue((boolean)(envelopeResponse instanceof EnvelopeResponse));
        return (EnvelopeResponse)envelopeResponse;
    }

    private final void verifyConfig$1(ConfigResource resource, Seq entries, Map expectedValues, String sensitiveValue$1) {
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(resource, new AlterConfigsRequest.Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)entries).asJavaCollection())), true).build());
        AlterConfigsRequest.Config loggedConfig = (AlterConfigsRequest.Config)((AlterConfigsRequest)alterConfigs.loggableRequest()).configs().get(resource);
        Assertions.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = RequestConvertToJson$.MODULE$.requestDesc(alterConfigs.header(), alterConfigs.requestLog(), alterConfigs.isForwarded()).toString();
        Assertions.assertFalse((boolean)alterConfigsDesc.contains(sensitiveValue$1), (String)new StringBuilder(24).append("Sensitive config logged ").append(alterConfigsDesc).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterRequests$1(IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs$1, AlterConfigOp.OpType op$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String name = (String)x0$1._1();
        String value = (String)x0$1._2();
        boolean bl = alterableConfigs$1.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName(name).setValue(value).setConfigOperation(op$1.id()));
        return bl;
    }

    private static final IncrementalAlterConfigsRequest incrementalAlterConfigs$1(ConfigResource resource, Map entries, AlterConfigOp.OpType op) {
        IncrementalAlterConfigsRequestData data = new IncrementalAlterConfigsRequestData();
        IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
        entries.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RequestChannelTest.$anonfun$testIncrementalAlterRequests$1(alterableConfigs, op, x0$1)));
        data.resources().add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName(resource.name()).setResourceType(resource.type().id()).setConfigs(alterableConfigs));
        return (IncrementalAlterConfigsRequest)new IncrementalAlterConfigsRequest.Builder(data).build();
    }

    private final void verifyConfig$2(ConfigResource resource, AlterConfigOp.OpType op, Map entries, Map expectedValues, String sensitiveValue$2) {
        RequestChannel.Request alterConfigs = this.request((AbstractRequest)RequestChannelTest.incrementalAlterConfigs$1(resource, entries, op));
        IncrementalAlterConfigsRequestData.AlterableConfigCollection loggedConfig = ((IncrementalAlterConfigsRequest)alterConfigs.loggableRequest()).data().resources().find(resource.type().id(), resource.name()).configs();
        Assertions.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = RequestConvertToJson$.MODULE$.requestDesc(alterConfigs.header(), alterConfigs.requestLog(), alterConfigs.isForwarded()).toString();
        Assertions.assertFalse((boolean)alterConfigsDesc.contains(sensitiveValue$2), (String)new StringBuilder(24).append("Sensitive config logged ").append(alterConfigsDesc).toString());
    }
}

