/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.raft.KafkaRaftManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetaProperties;
import kafka.tools.TestRaftServer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005a3A\u0001C\u0005\u0001\u001d!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00055!)\u0001\t\u0001C\u0001\u0003\")\u0001\u000b\u0001C\u0001\u0003\")!\u000b\u0001C\u0001\u0003\")A\u000b\u0001C\u0001\u0003\")a\u000b\u0001C\u0001\u0003\ny!+\u00194u\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u000b\u0017\u0005!!/\u00194u\u0015\u0005a\u0011!B6bM.\f7\u0001A\n\u0003\u0001=\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\n\u0003\u0005Jgn\u001d;b]RL\u0017\r^3SC\u001a$X*\u00198bO\u0016\u0014x+\u001b;i\u0007>tg-[4t)\u0011YB%\r \u0011\u0007aab$\u0003\u0002\u001e\u0013\t\u00012*\u00194lCJ\u000bg\r^'b]\u0006<WM\u001d\t\u0004!}\t\u0013B\u0001\u0011\u0012\u0005\u0015\t%O]1z!\t\u0001\"%\u0003\u0002$#\t!!)\u001f;f\u0011\u0015)#\u00011\u0001'\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"aJ\u0018\u000e\u0003!R!!\u000b\u0016\u0002\r\r|W.\\8o\u0015\ta1F\u0003\u0002-[\u00051\u0011\r]1dQ\u0016T\u0011AL\u0001\u0004_J<\u0017B\u0001\u0019)\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DQA\r\u0002A\u0002M\nA\u0002\u001d:pG\u0016\u001c8OU8mKN\u0004\"\u0001N\u001e\u000f\u0005UJ\u0004C\u0001\u001c\u0012\u001b\u00059$B\u0001\u001d\u000e\u0003\u0019a$o\\8u}%\u0011!(E\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;#!)qH\u0001a\u0001g\u00051an\u001c3f\u0013\u0012\f\u0011\u0005^3ti:{G-Z%e!J,7/\u001a8u\u0013\u001a\u0014%o\\6feJ{G.Z(oYf$\u0012A\u0011\t\u0003!\rK!\u0001R\t\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0007\u0019\u0003\"a\u0012(\u000e\u0003!S!!\u0013&\u0002\u0007\u0005\u0004\u0018N\u0003\u0002L\u0019\u00069!.\u001e9ji\u0016\u0014(BA'.\u0003\u0015QWO\\5u\u0013\ty\u0005J\u0001\u0003UKN$\u0018!\n;fgRtu\u000eZ3JIB\u0013Xm]3oi&37i\u001c8ue>dG.\u001a:S_2,wJ\u001c7zQ\t!a)\u0001\u000fuKN$hj\u001c3f\u0013\u0012\u0004&/Z:f]RLemQ8m_\u000e\fG/\u001a3)\u0005\u00151\u0015\u0001\u0006;fgR\u001c\u0006.\u001e;e_^t\u0017j\u001c+ie\u0016\fG\r\u000b\u0002\u0007\r\u0006yB/Z:u+:\u001c\u0017-^4ii\u0016C8-\u001a9uS>t\u0017J\\%p)\"\u0014X-\u00193)\u0005\u001d1\u0005")
public class RaftManagerTest {
    private KafkaRaftManager<byte[]> instantiateRaftManagerWithConfigs(TopicPartition topicPartition, String processRoles, String nodeId) {
        File file;
        File file2;
        File file3 = file2 = TestUtils.tempDirectory(null, null);
        file2 = null;
        File file4 = file = file3;
        file = null;
        File logDir = file4;
        KafkaConfig config = RaftManagerTest.configWithProcessRolesAndNodeId$1(processRoles, nodeId, logDir);
        Uuid topicId = new Uuid(0L, 2L);
        MetaProperties metaProperties = new MetaProperties(Uuid.randomUuid().toString(), config.nodeId());
        return new KafkaRaftManager(metaProperties, config, (RecordSerde)new TestRaftServer.ByteArraySerde(), topicPartition, topicId, Time.SYSTEM, new Metrics(Time.SYSTEM), Option$.MODULE$.empty(), CompletableFuture.completedFuture(RaftConfig.parseVoterConnections((List)config.quorumVoters())));
    }

    @Test
    public void testNodeIdPresentIfBrokerRoleOnly() {
        KafkaRaftManager<byte[]> raftManager = this.instantiateRaftManagerWithConfigs(new TopicPartition("__raft_id_test", 0), "broker", "1");
        Assertions.assertEquals((int)1, (int)raftManager.client().nodeId().getAsInt());
        raftManager.shutdown();
    }

    @Test
    public void testNodeIdPresentIfControllerRoleOnly() {
        KafkaRaftManager<byte[]> raftManager = this.instantiateRaftManagerWithConfigs(new TopicPartition("__raft_id_test", 0), "controller", "1");
        Assertions.assertEquals((int)1, (int)raftManager.client().nodeId().getAsInt());
        raftManager.shutdown();
    }

    @Test
    public void testNodeIdPresentIfColocated() {
        KafkaRaftManager<byte[]> raftManager = this.instantiateRaftManagerWithConfigs(new TopicPartition("__raft_id_test", 0), "controller,broker", "1");
        Assertions.assertEquals((int)1, (int)raftManager.client().nodeId().getAsInt());
        raftManager.shutdown();
    }

    @Test
    public void testShutdownIoThread() {
        KafkaRaftClient raftClient = (KafkaRaftClient)Mockito.mock(KafkaRaftClient.class);
        KafkaRaftManager.RaftIoThread ioThread = new KafkaRaftManager.RaftIoThread(raftClient, "test-raft");
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)raftClient.isRunning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertTrue((boolean)ioThread.isRunning());
        CompletableFuture<Object> shutdownFuture = new CompletableFuture<Object>();
        Mockito.when((Object)raftClient.shutdown(5000)).thenReturn(shutdownFuture);
        ioThread.initiateShutdown();
        Assertions.assertTrue((boolean)ioThread.isRunning());
        Assertions.assertTrue((boolean)ioThread.isShutdownInitiated());
        ((KafkaRaftClient)Mockito.verify((Object)raftClient)).shutdown(5000);
        shutdownFuture.complete(null);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)raftClient.isRunning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        ioThread.run();
        Assertions.assertFalse((boolean)ioThread.isRunning());
        Assertions.assertTrue((boolean)ioThread.isShutdownComplete());
    }

    @Test
    public void testUncaughtExceptionInIoThread() {
        KafkaRaftClient raftClient = (KafkaRaftClient)Mockito.mock(KafkaRaftClient.class);
        KafkaRaftManager.RaftIoThread ioThread = new KafkaRaftManager.RaftIoThread(raftClient, "test-raft");
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)raftClient.isRunning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertTrue((boolean)ioThread.isRunning());
        raftClient.poll();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new RuntimeException()});
        ioThread.run();
        Assertions.assertTrue((boolean)ioThread.isShutdownComplete());
        Assertions.assertTrue((boolean)ioThread.isThreadFailed());
        Assertions.assertFalse((boolean)ioThread.isRunning());
    }

    private static final KafkaConfig configWithProcessRolesAndNodeId$1(String processRoles, String nodeId, File logDir) {
        Properties props = new Properties();
        props.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), logDir.getPath());
        props.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), processRoles);
        props.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), nodeId);
        props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        if (processRoles.contains("broker")) {
            props.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "PLAINTEXT");
            if (processRoles.contains("controller")) {
                props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://localhost:9092,SSL://localhost:9093");
                props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
            } else {
                int voterId = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(nodeId)) + 1;
                props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(voterId).append("@localhost:9093").toString());
            }
        } else if (processRoles.contains("controller")) {
            props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:9093");
            props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
        }
        return new KafkaConfig((Map)props);
    }
}

