/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.network.RequestChannel;
import kafka.raft.RaftManager;
import kafka.server.ApiVersionManager;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ControllerApis;
import kafka.server.ControllerMutationQuotaManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetaProperties;
import kafka.server.QuotaFactory;
import kafka.server.ReplicationQuotaManager;
import kafka.server.RequestLocal$;
import kafka.server.SimpleApiVersionManager;
import kafka.test.MockController;
import kafka.utils.MockTime;
import kafka.utils.NotNothing;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.message.AlterClientQuotasRequestData;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeQuorumRequestData;
import org.apache.kafka.common.message.ElectLeadersRequestData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.EndQuorumEpochRequestData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.UnregisterBrokerRequestData;
import org.apache.kafka.common.message.VoteRequestData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.ElectLeadersResponse;
import org.apache.kafka.common.requests.EndQuorumEpochRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchSnapshotRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.UnregisterBrokerRequest;
import org.apache.kafka.common.requests.VoteRequest;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.controller.ControllerRequestContextUtil;
import org.apache.kafka.controller.ResultOrError;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\rmb\u0001B#G\u0001-CQA\u0015\u0001\u0005\u0002MCqA\u0016\u0001C\u0002\u0013%q\u000b\u0003\u0004\\\u0001\u0001\u0006I\u0001\u0017\u0005\b9\u0002\u0011\r\u0011\"\u0003^\u0011\u00191\u0007\u0001)A\u0005=\"9q\r\u0001b\u0001\n\u0013i\u0006B\u00025\u0001A\u0003%a\fC\u0004j\u0001\t\u0007I\u0011\u00026\t\rU\u0004\u0001\u0015!\u0003l\u0011\u001d1\bA1A\u0005\n]Daa\u001f\u0001!\u0002\u0013A\bb\u0002?\u0001\u0005\u0004%I! \u0005\b\u0003\u0013\u0001\u0001\u0015!\u0003\u007f\u0011%\tY\u0001\u0001b\u0001\n\u0013\ti\u0001\u0003\u0005\u0002\u0016\u0001\u0001\u000b\u0011BA\b\u0011%\t9\u0002\u0001b\u0001\n\u0013\tI\u0002\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\u000e\u0011%\t\u0019\u0003\u0001b\u0001\n\u0013\t)\u0003\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\u0014\u0011%\ty\u0003\u0001b\u0001\n\u0013\t\t\u0004\u0003\u0005\u0002:\u0001\u0001\u000b\u0011BA\u001a\u0011%\tY\u0004\u0001b\u0001\n\u0013\ti\u0004\u0003\u0005\u0002d\u0001\u0001\u000b\u0011BA \u0011%\t)\u0007\u0001b\u0001\n\u0013\t9\u0007\u0003\u0005\u0002\u0006\u0002\u0001\u000b\u0011BA5\u0011\u001d\t9\t\u0001C\u0005\u0003\u0013C\u0011\"a1\u0001#\u0003%I!!2\t\u000f\u0005m\u0007\u0001\"\u0003\u0002^\"I!1\u0003\u0001\u0012\u0002\u0013%!Q\u0003\u0005\b\u0005;\u0001A\u0011\u0001B\u0010\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0005GAqA!\u0011\u0001\t\u0003\u0011\u0019\u0003C\u0004\u0003F\u0001!\tAa\t\t\u000f\t%\u0003\u0001\"\u0001\u0003$!9!Q\n\u0001\u0005\u0002\t\r\u0002b\u0002B)\u0001\u0011\u0005!1\u0005\u0005\b\u0005+\u0002A\u0011\u0001B\u0012\u0011\u001d\u0011I\u0006\u0001C\u0001\u0005GAqA!\u0018\u0001\t\u0003\u0011\u0019\u0003C\u0004\u0003b\u0001!\tAa\t\t\u000f\t\u0015\u0004\u0001\"\u0001\u0003$!9!\u0011\u000e\u0001\u0005\u0002\t\r\u0002b\u0002B7\u0001\u0011\u0005!1\u0005\u0005\b\u0005c\u0002A\u0011\u0001B\u0012\u0011\u001d\u0011)\b\u0001C\u0001\u0005GAqA!\u001f\u0001\t\u0003\u0011\u0019\u0003C\u0004\u0003~\u0001!\tAa\t\t\u000f\t\u0005\u0005\u0001\"\u0001\u0003$!9!Q\u0011\u0001\u0005\u0002\t\r\u0002b\u0002BE\u0001\u0011\u0005!1\u0005\u0005\b\u0005\u001b\u0003A\u0011\u0001B\u0012\u0011\u001d\u0011\t\n\u0001C\u0001\u0005GAqA!&\u0001\t\u0003\u0011\u0019\u0003C\u0004\u0003\u001a\u0002!\tAa\t\t\u000f\tu\u0005\u0001\"\u0001\u0003$!9!\u0011\u0015\u0001\u0005\u0002\t\r\u0002b\u0002BS\u0001\u0011\u0005!1\u0005\u0005\b\u0005S\u0003A\u0011\u0001B\u0012\u0011\u001d\u0011i\u000b\u0001C\u0001\u0005GAqA!-\u0001\t\u0003\u0011\u0019\fC\u0004\u0003d\u0002!\tAa\t\t\u000f\t\u001d\b\u0001\"\u0001\u0003$!9!1\u001e\u0001\u0005\u0002\t\r\u0002b\u0002Bx\u0001\u0011\u0005!1\u0005\u0005\b\u0005g\u0004A\u0011\u0001B\u0012\u0011\u001d\u00119\u0010\u0001C\u0005\u0005sDqa!\f\u0001\t\u0003\u0011\u0019\u0003C\u0004\u00042\u0001!\tAa\t\u0003%\r{g\u000e\u001e:pY2,'/\u00119jgR+7\u000f\u001e\u0006\u0003\u000f\"\u000baa]3sm\u0016\u0014(\"A%\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0014\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0006CA+\u0001\u001b\u00051\u0015A\u00028pI\u0016LE-F\u0001Y!\ti\u0015,\u0003\u0002[\u001d\n\u0019\u0011J\u001c;\u0002\u000f9|G-Z%eA\u0005Q!M]8lKJ\u0014\u0016mY6\u0016\u0003y\u0003\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\t1\fgn\u001a\u0006\u0002G\u0006!!.\u0019<b\u0013\t)\u0007M\u0001\u0004TiJLgnZ\u0001\fEJ|7.\u001a:SC\u000e\\\u0007%\u0001\u0005dY&,g\u000e^%E\u0003%\u0019G.[3oi&#\u0005%A\u000bsKF,Xm\u001d;DQ\u0006tg.\u001a7NKR\u0014\u0018nY:\u0016\u0003-\u0004\"\u0001\u001c:\u000f\u00055\u0004X\"\u00018\u000b\u0005=D\u0015a\u00028fi^|'o[\u0005\u0003c:\faBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0002ti\n9Q*\u001a;sS\u000e\u001c(BA9o\u0003Y\u0011X-];fgR\u001c\u0005.\u00198oK2lU\r\u001e:jGN\u0004\u0013A\u0004:fcV,7\u000f^\"iC:tW\r\\\u000b\u0002qB\u0011Q._\u0005\u0003u:\u0014aBU3rk\u0016\u001cHo\u00115b]:,G.A\bsKF,Xm\u001d;DQ\u0006tg.\u001a7!\u0003\u0011!\u0018.\\3\u0016\u0003y\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004!\u000bQ!\u001e;jYNLA!a\u0002\u0002\u0002\tAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\ndY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014XCAA\b!\r)\u0016\u0011C\u0005\u0004\u0003'1%AE\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\f1c\u00197jK:$\u0018+^8uC6\u000bg.Y4fe\u0002\n\u0011d\u00197jK:$(+Z9vKN$\u0018+^8uC6\u000bg.Y4feV\u0011\u00111\u0004\t\u0004+\u0006u\u0011bAA\u0010\r\nI2\t\\5f]R\u0014V-];fgR\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003i\u0019G.[3oiJ+\u0017/^3tiF+x\u000e^1NC:\fw-\u001a:!\u0003q\u0019G.[3oi\u000e{g\u000e\u001e:pY2,'/U;pi\u0006l\u0015M\\1hKJ,\"!a\n\u0011\u0007U\u000bI#C\u0002\u0002,\u0019\u0013adQ8oiJ|G\u000e\\3s\u001bV$\u0018\r^5p]F+x\u000e^1NC:\fw-\u001a:\u0002;\rd\u0017.\u001a8u\u0007>tGO]8mY\u0016\u0014\u0018+^8uC6\u000bg.Y4fe\u0002\n1C]3qY&\u001c\u0017-U;pi\u0006l\u0015M\\1hKJ,\"!a\r\u0011\u0007U\u000b)$C\u0002\u00028\u0019\u0013qCU3qY&\u001c\u0017\r^5p]F+x\u000e^1NC:\fw-\u001a:\u0002)I,\u0007\u000f\\5dCF+x\u000e^1NC:\fw-\u001a:!\u0003-\u0011\u0018M\u001a;NC:\fw-\u001a:\u0016\u0005\u0005}\u0002CBA!\u0003\u000f\nY%\u0004\u0002\u0002D)\u0019\u0011Q\t%\u0002\tI\fg\r^\u0005\u0005\u0003\u0013\n\u0019EA\u0006SC\u001a$X*\u00198bO\u0016\u0014\b\u0003BA'\u0003?j!!a\u0014\u000b\t\u0005E\u00131K\u0001\u0007G>lWn\u001c8\u000b\u0007\u001d\u000b)FC\u0002J\u0003/RA!!\u0017\u0002\\\u00051\u0011\r]1dQ\u0016T!!!\u0018\u0002\u0007=\u0014x-\u0003\u0003\u0002b\u0005=#\u0001F!qS6+7o]1hK\u0006sGMV3sg&|g.\u0001\u0007sC\u001a$X*\u00198bO\u0016\u0014\b%\u0001\u0004rk>$\u0018m]\u000b\u0003\u0003S\u0002B!a\u001b\u0002\u00009!\u0011QNA>\u001d\u0011\ty'!\u001f\u000f\t\u0005E\u0014qO\u0007\u0003\u0003gR1!!\u001eK\u0003\u0019a$o\\8u}%\t\u0011*\u0003\u0002H\u0011&\u0019\u0011Q\u0010$\u0002\u0019E+x\u000e^1GC\u000e$xN]=\n\t\u0005\u0005\u00151\u0011\u0002\u000e#V|G/Y'b]\u0006<WM]:\u000b\u0007\u0005ud)A\u0004rk>$\u0018m\u001d\u0011\u0002)\r\u0014X-\u0019;f\u0007>tGO]8mY\u0016\u0014\u0018\t]5t)!\tY)!%\u0002&\u0006M\u0006cA+\u0002\u000e&\u0019\u0011q\u0012$\u0003\u001d\r{g\u000e\u001e:pY2,'/\u00119jg\"9\u00111\u0013\u000eA\u0002\u0005U\u0015AC1vi\"|'/\u001b>feB)Q*a&\u0002\u001c&\u0019\u0011\u0011\u0014(\u0003\r=\u0003H/[8o!\u0011\ti*!)\u000e\u0005\u0005}%\u0002BAJ\u0003'JA!a)\u0002 \nQ\u0011)\u001e;i_JL'0\u001a:\t\u000f\u0005\u001d&\u00041\u0001\u0002*\u0006Q1m\u001c8ue>dG.\u001a:\u0011\t\u0005-\u0016qV\u0007\u0003\u0003[SA!a*\u0002V%!\u0011\u0011WAW\u0005)\u0019uN\u001c;s_2dWM\u001d\u0005\n\u0003kS\u0002\u0013!a\u0001\u0003o\u000bQ\u0001\u001d:paN\u0004B!!/\u0002@6\u0011\u00111\u0018\u0006\u0004\u0003{\u0013\u0017\u0001B;uS2LA!!1\u0002<\nQ\u0001K]8qKJ$\u0018.Z:\u0002=\r\u0014X-\u0019;f\u0007>tGO]8mY\u0016\u0014\u0018\t]5tI\u0011,g-Y;mi\u0012\u001aTCAAdU\u0011\t9,!3,\u0005\u0005-\u0007\u0003BAg\u0003/l!!a4\u000b\t\u0005E\u00171[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!6O\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\fyMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fABY;jY\u0012\u0014V-];fgR,B!a8\u0003\bQ1\u0011\u0011]At\u0003s\u00042\u0001\\Ar\u0013\r\t)\u000f\u001e\u0002\b%\u0016\fX/Z:u\u0011\u001d\tI\u000f\ba\u0001\u0003W\fqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002n\u0006UXBAAx\u0015\u0011\t\t0a=\u0002\u0011I,\u0017/^3tiNTA!!\u0015\u0002V%!\u0011q_Ax\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\b\"CA~9A\u0005\t\u0019AA\u007f\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f!\u0011\tyPa\u0001\u000e\u0005\t\u0005!bA8\u0002t&!!Q\u0001B\u0001\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\t\u001d\u0011I\u0001\bb\u0001\u0005\u0017\u0011\u0011\u0001V\t\u0005\u0005\u001b\tY\u000fE\u0002N\u0005\u001fI1A!\u0005O\u0005\u001dqu\u000e\u001e5j]\u001e\faCY;jY\u0012\u0014V-];fgR$C-\u001a4bk2$HEM\u000b\u0005\u0005/\u0011Y\"\u0006\u0002\u0003\u001a)\"\u0011Q`Ae\t\u001d\u0011I!\bb\u0001\u0005\u0017\tqc\u0019:fCR,G)\u001a8z\u00032d\u0017)\u001e;i_JL'0\u001a:\u0015\u0005\u0005m\u0015!\u0006;fgR,f.Y;uQ>\u0014\u0018N_3e\r\u0016$8\r\u001b\u000b\u0003\u0005K\u00012!\u0014B\u0014\u0013\r\u0011IC\u0014\u0002\u0005+:LG\u000fK\u0002 \u0005[\u0001BAa\f\u0003>5\u0011!\u0011\u0007\u0006\u0005\u0005g\u0011)$A\u0002ba&TAAa\u000e\u0003:\u00059!.\u001e9ji\u0016\u0014(\u0002\u0002B\u001e\u00037\nQA[;oSRLAAa\u0010\u00032\t!A+Z:u\u0003Q!Xm\u001d;GKR\u001c\u0007nU3oiR{7JU1gi\"\u001a\u0001E!\f\u0002GQ,7\u000f\u001e$fi\u000eDGj\\2bYRKW.Z\"p[B,H/\u001a3D_J\u0014Xm\u0019;ms\"\u001a\u0011E!\f\u0002;Q,7\u000f^+oCV$\bn\u001c:ju\u0016$g)\u001a;dQNs\u0017\r]:i_RD3A\tB\u0017\u0003q!Xm\u001d;GKR\u001c\u0007n\u00158baNDw\u000e^*f]R$vn\u0013*bMRD3a\tB\u0017\u0003Q!Xm\u001d;V]\u0006,H\u000f[8sSj,GMV8uK\"\u001aAE!\f\u0002EQ,7\u000f\u001e%b]\u0012dW\rT3hC\u000eL\u0018\t\u001c;fe\u000e{gNZ5hg\u0016\u0013(o\u001c:tQ\r)#QF\u0001!i\u0016\u001cH/\u00168bkRDwN]5{K\u0012\u0014UmZ5o#V|'/^7Fa>\u001c\u0007\u000eK\u0002'\u0005[\ta\u0004^3tiVs\u0017-\u001e;i_JL'0\u001a3F]\u0012\fVo\u001c:v[\u0016\u0003xn\u00195)\u0007\u001d\u0012i#\u0001\u0010uKN$XK\\1vi\"|'/\u001b>fI\u0012+7o\u0019:jE\u0016\fVo\u001c:v[\"\u001a\u0001F!\f\u0002WQ,7\u000f^+oCV$\bn\u001c:ju\u0016$\u0007*\u00198eY\u0016\fE\u000e^3s!\u0006\u0014H/\u001b;j_:\u0014V-];fgRD3!\u000bB\u0017\u00031\"Xm\u001d;V]\u0006,H\u000f[8sSj,G\rS1oI2,'I]8lKJDU-\u0019:u\u0005\u0016\fGOU3rk\u0016\u001cH\u000fK\u0002+\u0005[\ta\u0005^3tiVs\u0017-\u001e;i_JL'0\u001a3IC:$G.Z+oe\u0016<\u0017n\u001d;fe\n\u0013xn[3sQ\rY#QF\u0001\ni\u0016\u001cHo\u00117pg\u0016D3\u0001\fB\u0017\u0003\t\"Xm\u001d;V]\u0006,H\u000f[8sSj,GM\u0011:pW\u0016\u0014(+Z4jgR\u0014\u0018\r^5p]\"\u001aQF!\f\u0002OQ,7\u000f^+oCV$\bn\u001c:ju\u0016$\u0007*\u00198eY\u0016\fE\u000e^3s\u00072LWM\u001c;Rk>$\u0018m\u001d\u0015\u0004]\t5\u0012!\f;fgR,f.Y;uQ>\u0014\u0018N_3e\u0011\u0006tG\r\\3J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hg\"\u001aqF!\f\u0002WQ,7\u000f^%om\u0006d\u0017\u000eZ%oGJ,W.\u001a8uC2\fE\u000e^3s\u0007>tg-[4t%\u0016\u001cx.\u001e:dKND3\u0001\rB\u0017\u0003E\"Xm\u001d;V]\u0006,H\u000f[8sSj,G\rS1oI2,\u0017\t\u001c;feB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oiND3!\rB\u0017\u0003%\"Xm\u001d;V]\u0006,H\u000f[8sSj,G\rS1oI2,\u0017\t\u001c7pG\u0006$X\r\u0015:pIV\u001cWM]%eg\"\u001a!G!\f\u0002aQ,7\u000f^+oCV$\bn\u001c:ju\u0016$\u0007*\u00198eY\u0016d\u0015n\u001d;QCJ$\u0018\u000e^5p]J+\u0017m]:jO:lWM\u001c;tQ\r\u0019$QF\u0001\u0011i\u0016\u001cHo\u0011:fCR,Gk\u001c9jGND3\u0001\u000eB\u0017\u0003Y!Xm\u001d;EK2,G/\u001a+pa&\u001c7OQ=OC6,\u0007fA\u001b\u0003.\u0005!B/Z:u\t\u0016dW\r^3U_BL7m\u001d\"z\u0013\u0012D3A\u000eB\u0017\u0003y!Xm\u001d;J]Z\fG.\u001b3EK2,G/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000fK\u00028\u0005[\t!\u0006^3ti:{G/Q;uQ>\u0014\u0018N_3e)>$U\r\\3uK^KG\u000f\u001b+pa&\u001cW\t_5ti&tw\rK\u00029\u0005[\tQ\u0006^3ti:{G/Q;uQ>\u0014\u0018N_3e)>$U\r\\3uK^KG\u000f\u001b+pa&\u001cgj\u001c;Fq&\u001cH/\u001b8hQ\rI$QF\u0001-i\u0016\u001cHOT8u\u0007>tGO]8mY\u0016\u0014XI\u001d:peB\u0013XM^3oiN$U\r\\3uS:<Gk\u001c9jGND3A\u000fB\u0017\u0003a!Xm\u001d;EK2,G/\u001a+pa&\u001c7\u000fR5tC\ndW\r\u001a\u0015\u0004w\t5\u0012a\u0007;fgR\u001c%/Z1uKB\u000b'\u000f^5uS>t7OU3rk\u0016\u001cH\u000f\u0006\u0003\u0003&\tU\u0006b\u0002B\\y\u0001\u0007!\u0011X\u0001\rm\u0006d\u0017\u000eZ1uK>sG.\u001f\t\u0004\u001b\nm\u0016b\u0001B_\u001d\n9!i\\8mK\u0006t\u0007f\u0002\u001f\u0003B\nE'1\u001b\t\u0005\u0005\u0007\u0014i-\u0004\u0002\u0003F*!!q\u0019Be\u0003!\u0001(o\u001c<jI\u0016\u0014(\u0002\u0002Bf\u0005k\ta\u0001]1sC6\u001c\u0018\u0002\u0002Bh\u0005\u000b\u00141BV1mk\u0016\u001cv.\u001e:dK\u0006A!m\\8mK\u0006t7\u000f\f\u0003\u0003V\n]\u0017$A\u0001\u001a\u0003\u0001A3\u0001\u0010Bn!\u0011\u0011iNa8\u000e\u0005\t%\u0017\u0002\u0002Bq\u0005\u0013\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0005\"Xm\u001d;De\u0016\fG/\u001a)beRLG/[8og\u0006+H\u000f[8sSj\fG/[8oQ\ri$QF\u0001\u001ei\u0016\u001cH/\u00127fGRdU-\u00193feN\fU\u000f\u001e5pe&T\u0018\r^5p]\"\u001aaH!\f\u0002GQ,7\u000f^#mK\u000e$H*Z1eKJ\u001c\b*\u00198eY\u0016$')_\"p]R\u0014x\u000e\u001c7fe\"\u001aqH!\f\u0002IQ,7\u000f\u001e#fY\u0016$X\rV8qS\u000e\u001c(+\u001a;ve:\u001chj\u001c;D_:$(o\u001c7mKJD3\u0001\u0011B\u0017\u0003-\"Xm\u001d;BY2|7-\u0019;f!J|G-^2fe&#7OU3ukJt7OT8u\u0007>tGO]8mY\u0016\u0014\bfA!\u0003.\u0005i\u0001.\u00198eY\u0016\u0014V-];fgR,BAa?\u0004\u0004Q1!Q`B\u0014\u0007S!bAa@\u0004\u000e\ru\u0001\u0003BB\u0001\u0007\u0007a\u0001\u0001B\u0004\u0003\n\t\u0013\ra!\u0002\u0012\t\t51q\u0001\t\u0005\u0003[\u001cI!\u0003\u0003\u0004\f\u0005=(\u0001E!cgR\u0014\u0018m\u0019;SKN\u0004xN\\:f\u0011\u001d\u0019yA\u0011a\u0002\u0007#\t\u0001b\u00197bgN$\u0016m\u001a\t\u0007\u0007'\u0019IBa@\u000e\u0005\rU!bAB\f\u001d\u00069!/\u001a4mK\u000e$\u0018\u0002BB\u000e\u0007+\u0011\u0001b\u00117bgN$\u0016m\u001a\u0005\b\u0007?\u0011\u00059AB\u0011\u0003\tqg\u000eE\u0003\u0000\u0007G\u0011y0\u0003\u0003\u0004&\u0005\u0005!A\u0003(pi:{G\u000f[5oO\"9\u0011\u0011\u001e\"A\u0002\u0005-\bbBB\u0016\u0005\u0002\u0007\u00111R\u0001\u000fG>tGO]8mY\u0016\u0014\u0018\t]5t\u0003}!Xm\u001d;D_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016,\u0005pY3qi&|gn\u001d\u0015\u0004\u0007\n5\u0012\u0001\u0003;fCJ$un\u001e8)\u0007\u0011\u001b)\u0004\u0005\u0003\u00030\r]\u0012\u0002BB\u001d\u0005c\u0011\u0011\"\u00114uKJ,\u0015m\u00195")
public class ControllerApisTest {
    private final int nodeId;
    private final String brokerRack;
    private final String clientID;
    private final RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
    private final RequestChannel requestChannel = (RequestChannel)Mockito.mock(RequestChannel.class);
    private final MockTime time = new MockTime();
    private final ClientQuotaManager clientQuotaManager = (ClientQuotaManager)Mockito.mock(ClientQuotaManager.class);
    private final ClientRequestQuotaManager clientRequestQuotaManager = (ClientRequestQuotaManager)Mockito.mock(ClientRequestQuotaManager.class);
    private final ControllerMutationQuotaManager clientControllerQuotaManager = (ControllerMutationQuotaManager)Mockito.mock(ControllerMutationQuotaManager.class);
    private final ReplicationQuotaManager replicaQuotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
    private final RaftManager<ApiMessageAndVersion> raftManager = (RaftManager)Mockito.mock(RaftManager.class);
    private final QuotaFactory.QuotaManagers quotas = new QuotaFactory.QuotaManagers(this.clientQuotaManager(), this.clientQuotaManager(), this.clientRequestQuotaManager(), this.clientControllerQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), (Option)None$.MODULE$);

    private int nodeId() {
        return this.nodeId;
    }

    private String brokerRack() {
        return this.brokerRack;
    }

    private String clientID() {
        return this.clientID;
    }

    private RequestChannel.Metrics requestChannelMetrics() {
        return this.requestChannelMetrics;
    }

    private RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private MockTime time() {
        return this.time;
    }

    private ClientQuotaManager clientQuotaManager() {
        return this.clientQuotaManager;
    }

    private ClientRequestQuotaManager clientRequestQuotaManager() {
        return this.clientRequestQuotaManager;
    }

    private ControllerMutationQuotaManager clientControllerQuotaManager() {
        return this.clientControllerQuotaManager;
    }

    private ReplicationQuotaManager replicaQuotaManager() {
        return this.replicaQuotaManager;
    }

    private RaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    private QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private ControllerApis createControllerApis(Option<Authorizer> authorizer, Controller controller, Properties props) {
        props.put(KafkaConfig$.MODULE$.NodeIdProp(), Predef$.MODULE$.int2Integer(this.nodeId()));
        props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        props.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(this.nodeId()).append("@localhost:9092").toString());
        return new ControllerApis(this.requestChannel(), authorizer, this.quotas(), (Time)this.time(), controller, this.raftManager(), new KafkaConfig((Map)props), new MetaProperties("JgxuGe9URy-E-ceaL04lEw", this.nodeId()), (Seq)package$.MODULE$.Seq().empty(), (ApiVersionManager)new SimpleApiVersionManager(ApiMessageType.ListenerType.CONTROLLER));
    }

    private Properties createControllerApis$default$3() {
        return new Properties();
    }

    private <T extends AbstractRequest> RequestChannel.Request buildRequest(AbstractRequest request, ListenerName listenerName) {
        ByteBuffer buffer = request.serializeWithHeader(new RequestHeader(request.apiKey(), request.version(), this.clientID(), 0));
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false);
        return new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, this.requestChannelMetrics(), (Option)None$.MODULE$);
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    /*
     * WARNING - void declaration
     */
    public Authorizer createDenyAllAuthorizer() {
        void var1_1;
        Authorizer authorizer = (Authorizer)Mockito.mock(Authorizer.class);
        Mockito.when((Object)authorizer.authorize((AuthorizableRequestContext)ArgumentMatchers.any(AuthorizableRequestContext.class), (List)ArgumentMatchers.any(List.class))).thenReturn(Collections.singletonList(AuthorizationResult.DENIED));
        return var1_1;
    }

    @Test
    public void testUnauthorizedFetch() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), new Properties()).handleFetch(this.buildRequest((AbstractRequest)new FetchRequest(new FetchRequestData(), 12), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT))));
    }

    @Test
    public void testFetchSentToKRaft() {
        Mockito.when((Object)this.raftManager().handleRequest((RequestHeader)ArgumentMatchers.any(RequestHeader.class), (ApiMessage)ArgumentMatchers.any(ApiMessage.class), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn(new CompletableFuture());
        this.createControllerApis((Option<Authorizer>)None$.MODULE$, new MockController.Builder().build(), new Properties()).handleFetch(this.buildRequest((AbstractRequest)new FetchRequest(new FetchRequestData(), 12), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT)));
        ((RaftManager)Mockito.verify(this.raftManager())).handleRequest((RequestHeader)ArgumentMatchers.any(), (ApiMessage)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testFetchLocalTimeComputedCorrectly() {
        int localTimeDurationMs = 5;
        long initialTimeNanos = this.time().nanoseconds();
        long initialTimeMs = this.time().milliseconds();
        Mockito.when((Object)this.raftManager().handleRequest((RequestHeader)ArgumentMatchers.any(RequestHeader.class), (ApiMessage)ArgumentMatchers.any(ApiMessage.class), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenAnswer(x$1 -> {
            this.time().sleep(localTimeDurationMs);
            return new CompletableFuture();
        });
        FetchRequestData fetchRequestData = new FetchRequestData();
        RequestChannel.Request request = this.buildRequest((AbstractRequest)new FetchRequest(fetchRequestData, ApiKeys.FETCH.latestVersion()), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        this.createControllerApis((Option<Authorizer>)None$.MODULE$, new MockController.Builder().build(), new Properties()).handle(request, RequestLocal$.MODULE$.NoCaching());
        ((RaftManager)Mockito.verify(this.raftManager())).handleRequest((RequestHeader)ArgumentMatchers.eq((Object)request.header()), (ApiMessage)ArgumentMatchers.eq((Object)fetchRequestData), ArgumentMatchers.eq((long)initialTimeMs));
        Assertions.assertEquals((long)localTimeDurationMs, (long)TimeUnit.MILLISECONDS.convert(request.apiLocalCompleteTimeNanos() - initialTimeNanos, TimeUnit.NANOSECONDS));
    }

    @Test
    public void testUnauthorizedFetchSnapshot() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), new Properties()).handleFetchSnapshot(this.buildRequest((AbstractRequest)new FetchSnapshotRequest(new FetchSnapshotRequestData(), 0), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT))));
    }

    @Test
    public void testFetchSnapshotSentToKRaft() {
        Mockito.when((Object)this.raftManager().handleRequest((RequestHeader)ArgumentMatchers.any(RequestHeader.class), (ApiMessage)ArgumentMatchers.any(ApiMessage.class), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn(new CompletableFuture());
        this.createControllerApis((Option<Authorizer>)None$.MODULE$, new MockController.Builder().build(), new Properties()).handleFetchSnapshot(this.buildRequest((AbstractRequest)new FetchSnapshotRequest(new FetchSnapshotRequestData(), 0), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT)));
        ((RaftManager)Mockito.verify(this.raftManager())).handleRequest((RequestHeader)ArgumentMatchers.any(), (ApiMessage)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testUnauthorizedVote() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), new Properties()).handleVote(this.buildRequest((AbstractRequest)new VoteRequest.Builder(new VoteRequestData()).build((short)0), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT))));
    }

    @Test
    public void testHandleLegacyAlterConfigsErrors() {
        AlterConfigsRequestData requestData = new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(new AlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new AlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000")).iterator())), new AlterConfigsRequestData.AlterConfigsResource().setResourceName("2").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new AlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000")).iterator())), new AlterConfigsRequestData.AlterConfigsResource().setResourceName("2").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new AlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000")).iterator())), new AlterConfigsRequestData.AlterConfigsResource().setResourceName("baz").setResourceType((byte)123).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new AlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar")).iterator()))).iterator()));
        RequestChannel.Request request = this.buildRequest((AbstractRequest)new AlterConfigsRequest(requestData, 0), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), new Properties()).handleLegacyAlterConfigs(request);
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Assertions.assertNotNull((Object)capturedResponse.getValue());
        AlterConfigsResponse response = (AlterConfigsResponse)capturedResponse.getValue();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigsResponseData.AlterConfigsResourceResponse[]{new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName("2").setResourceType(ConfigResource.Type.BROKER.id()), new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage("Unknown resource type 123.").setResourceName("baz").setResourceType((byte)123), new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage("Cluster authorization failed.").setResourceName("1").setResourceType(ConfigResource.Type.BROKER.id())})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(response.data().responses()).asScala().toSet());
    }

    @Test
    public void testUnauthorizedBeginQuorumEpoch() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), new Properties()).handleBeginQuorumEpoch(this.buildRequest((AbstractRequest)new BeginQuorumEpochRequest.Builder(new BeginQuorumEpochRequestData()).build((short)0), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT))));
    }

    @Test
    public void testUnauthorizedEndQuorumEpoch() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), new Properties()).handleEndQuorumEpoch(this.buildRequest((AbstractRequest)new EndQuorumEpochRequest.Builder(new EndQuorumEpochRequestData()).build((short)0), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT))));
    }

    @Test
    public void testUnauthorizedDescribeQuorum() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), new Properties()).handleDescribeQuorum(this.buildRequest((AbstractRequest)new DescribeQuorumRequest.Builder(new DescribeQuorumRequestData()).build((short)0), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT))));
    }

    @Test
    public void testUnauthorizedHandleAlterPartitionRequest() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), new Properties()).handleAlterPartitionRequest(this.buildRequest((AbstractRequest)new AlterPartitionRequest.Builder(new AlterPartitionRequestData(), false).build((short)0), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT))));
    }

    @Test
    public void testUnauthorizedHandleBrokerHeartBeatRequest() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), new Properties()).handleBrokerHeartBeatRequest(this.buildRequest((AbstractRequest)new BrokerHeartbeatRequest.Builder(new BrokerHeartbeatRequestData()).build((short)0), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT))));
    }

    @Test
    public void testUnauthorizedHandleUnregisterBroker() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), new Properties()).handleUnregisterBroker(this.buildRequest((AbstractRequest)new UnregisterBrokerRequest.Builder(new UnregisterBrokerRequestData()).build((short)0), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT))));
    }

    @Test
    public void testClose() {
        ControllerApis apis = this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), (Controller)Mockito.mock(Controller.class), new Properties());
        apis.close();
        Assertions.assertTrue((boolean)apis.isClosed());
    }

    @Test
    public void testUnauthorizedBrokerRegistration() {
        BrokerRegistrationRequest brokerRegistrationRequest = (BrokerRegistrationRequest)new BrokerRegistrationRequest.Builder(new BrokerRegistrationRequestData().setBrokerId(this.nodeId()).setRack(this.brokerRack())).build();
        RequestChannel.Request request = this.buildRequest((AbstractRequest)brokerRegistrationRequest, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), (Controller)Mockito.mock(Controller.class), new Properties()).handle(request, RequestLocal$.MODULE$.withThreadConfinedCaching());
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Assertions.assertNotNull((Object)capturedResponse.getValue());
        BrokerRegistrationResponse brokerRegistrationResponse = (BrokerRegistrationResponse)capturedResponse.getValue();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.CLUSTER_AUTHORIZATION_FAILED), (Object)BoxesRunTime.boxToInteger((int)1))})), (Object)CollectionConverters$.MODULE$.MapHasAsScala(brokerRegistrationResponse.errorCounts()).asScala());
    }

    @Test
    public void testUnauthorizedHandleAlterClientQuotas() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), new Properties()).handleAlterClientQuotas(this.buildRequest((AbstractRequest)new AlterClientQuotasRequest(new AlterClientQuotasRequestData(), 0), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT))));
    }

    @Test
    public void testUnauthorizedHandleIncrementalAlterConfigs() {
        IncrementalAlterConfigsRequestData requestData = new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new IncrementalAlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000").setConfigOperation(AlterConfigOp.OpType.SET.id())).iterator())), new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("foo").setResourceType(ConfigResource.Type.TOPIC.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new IncrementalAlterConfigsRequestData.AlterableConfig().setName("flush.ms").setValue("1000").setConfigOperation(AlterConfigOp.OpType.SET.id())).iterator()))).iterator()));
        RequestChannel.Request request = this.buildRequest((AbstractRequest)new IncrementalAlterConfigsRequest.Builder(requestData).build((short)0), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), new Properties()).handleIncrementalAlterConfigs(request);
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Assertions.assertNotNull((Object)capturedResponse.getValue());
        IncrementalAlterConfigsResponse response = (IncrementalAlterConfigsResponse)capturedResponse.getValue();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.CLUSTER_AUTHORIZATION_FAILED.message()).setResourceName("1").setResourceType(ConfigResource.Type.BROKER.id()), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()).setResourceName("foo").setResourceType(ConfigResource.Type.TOPIC.id())})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(response.data().responses()).asScala().toSet());
    }

    @Test
    public void testInvalidIncrementalAlterConfigsResources() {
        IncrementalAlterConfigsRequestData requestData = new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new IncrementalAlterConfigsRequestData.AlterableConfig().setName("kafka.server.KafkaConfig").setValue("TRACE").setConfigOperation(AlterConfigOp.OpType.SET.id())).iterator())), new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("3").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new IncrementalAlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000").setConfigOperation(AlterConfigOp.OpType.SET.id())).iterator())), new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("3").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new IncrementalAlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000").setConfigOperation(AlterConfigOp.OpType.SET.id())).iterator())), new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("foo").setResourceType((byte)124).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new IncrementalAlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar").setConfigOperation(AlterConfigOp.OpType.SET.id())).iterator()))).iterator()));
        RequestChannel.Request request = this.buildRequest((AbstractRequest)new IncrementalAlterConfigsRequest.Builder(requestData).build((short)0), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), new Properties()).handleIncrementalAlterConfigs(request);
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Assertions.assertNotNull((Object)capturedResponse.getValue());
        IncrementalAlterConfigsResponse response = (IncrementalAlterConfigsResponse)capturedResponse.getValue();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Unexpected resource type BROKER_LOGGER.").setResourceName("1").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName("3").setResourceType(ConfigResource.Type.BROKER.id()), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage("Unknown resource type 124.").setResourceName("foo").setResourceType((byte)124)})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(response.data().responses()).asScala().toSet());
    }

    @Test
    public void testUnauthorizedHandleAlterPartitionReassignments() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), new Properties()).handleAlterPartitionReassignments(this.buildRequest(new AlterPartitionReassignmentsRequest.Builder(new AlterPartitionReassignmentsRequestData()).build(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT))));
    }

    @Test
    public void testUnauthorizedHandleAllocateProducerIds() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), new Properties()).handleAllocateProducerIdsRequest(this.buildRequest(new AllocateProducerIdsRequest.Builder(new AllocateProducerIdsRequestData()).build(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT))));
    }

    @Test
    public void testUnauthorizedHandleListPartitionReassignments() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), new Properties()).handleListPartitionReassignments(this.buildRequest(new ListPartitionReassignmentsRequest.Builder(new ListPartitionReassignmentsRequestData()).build(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT))));
    }

    @Test
    public void testCreateTopics() {
        MockController controller = new MockController.Builder().build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, new Properties());
        CreateTopicsRequestData request = new CreateTopicsRequestData().setTopics(new CreateTopicsRequestData.CreatableTopicCollection(Arrays.asList(new CreateTopicsRequestData.CreatableTopic().setName("foo").setNumPartitions(1).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("foo").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("bar").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("bar").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("bar").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("baz").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("indescribable").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("quux").setNumPartitions(2).setReplicationFactor((short)3)).iterator()));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CreateTopicsResponseData.CreatableTopicResult[]{new CreateTopicsResponseData.CreatableTopicResult().setName("foo").setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new CreateTopicsResponseData.CreatableTopicResult().setName("bar").setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new CreateTopicsResponseData.CreatableTopicResult().setName("baz").setErrorCode(Errors.NONE.code()).setTopicId(new Uuid(0L, 1L)).setNumPartitions(2).setReplicationFactor((short)3).setTopicConfigErrorCode(Errors.NONE.code()), new CreateTopicsResponseData.CreatableTopicResult().setName("indescribable").setErrorCode(Errors.NONE.code()).setTopicId(new Uuid(0L, 2L)).setTopicConfigErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()), new CreateTopicsResponseData.CreatableTopicResult().setName("quux").setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage("Authorization failed.")}))), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)((CreateTopicsResponseData)controllerApis.createTopics(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, request, false, (Function1 & Serializable)x$2 -> (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "indescribable"})), (Function1 & Serializable)x$3 -> (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz"}))).get()).topics()).asScala().toSet());
    }

    @Test
    public void testDeleteTopicsByName() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, new Properties());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData().setTopicNames(Arrays.asList("foo", "bar", "quux", "quux"));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName("quux").setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new DeleteTopicsResponseData.DeletableTopicResult().setName("bar").setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setErrorMessage("This server does not host this topic-partition."), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId)}))), (Object)CollectionConverters$.MODULE$.ListHasAsScala((List)controllerApis.deleteTopics(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), true, (Function1 & Serializable)x$4 -> Predef$.MODULE$.Set().empty(), (Function1 & Serializable)x$5 -> Predef$.MODULE$.Set().empty()).get()).asScala().toSet());
    }

    @Test
    public void testDeleteTopicsById() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        Uuid quuxId = Uuid.fromString((String)"ObXkLhL_S5W62FAE67U3MQ");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, new Properties());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(quuxId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(quuxId));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(quuxId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic id."), new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(barId).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()).setErrorMessage("This server does not host this topic ID."), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId)}))), (Object)CollectionConverters$.MODULE$.ListHasAsScala((List)controllerApis.deleteTopics(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), true, (Function1 & Serializable)x$6 -> Predef$.MODULE$.Set().empty(), (Function1 & Serializable)x$7 -> Predef$.MODULE$.Set().empty()).get()).asScala().toSet());
    }

    @Test
    public void testInvalidDeleteTopicsRequest() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        Uuid bazId = Uuid.fromString((String)"YOS4oQ3UT9eSAZahN1ysSA");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).newInitialTopic("bar", barId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, new Properties());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("foo").setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("bar").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(bazId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(bazId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(bazId));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Neither topic name nor id were specified."), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("You may not specify both topic name and topic id."), new DeleteTopicsResponseData.DeletableTopicResult().setName("bar").setTopicId(barId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("The provided topic name maps to an ID that was already supplied."), new DeleteTopicsResponseData.DeletableTopicResult().setName("quux").setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(bazId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic id.")}))), (Object)CollectionConverters$.MODULE$.ListHasAsScala((List)controllerApis.deleteTopics(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable)names -> names.toSet(), (Function1 & Serializable)names -> names.toSet()).get()).asScala().toSet());
    }

    @Test
    public void testNotAuthorizedToDeleteWithTopicExisting() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        Uuid bazId = Uuid.fromString((String)"hr4TVh3YQiu3p16Awkka6w");
        Uuid quuxId = Uuid.fromString((String)"5URoQzW_RJiERVZXJgUVLg");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).newInitialTopic("bar", barId).newInitialTopic("baz", bazId).newInitialTopic("quux", quuxId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, new Properties());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("baz").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(barId).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("quux").setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("baz").setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message())}))), (Object)CollectionConverters$.MODULE$.ListHasAsScala((List)controllerApis.deleteTopics(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable)x$8 -> (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "baz"})), (Function1 & Serializable)x$9 -> Predef$.MODULE$.Set().empty()).get()).asScala().toSet());
    }

    @Test
    public void testNotAuthorizedToDeleteWithTopicNotExisting() {
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        MockController controller = new MockController.Builder().build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, new Properties());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("foo").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("bar").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setErrorMessage(Errors.UNKNOWN_TOPIC_OR_PARTITION.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("bar").setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(barId).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()).setErrorMessage(Errors.UNKNOWN_TOPIC_ID.message())}))), (Object)CollectionConverters$.MODULE$.ListHasAsScala((List)controllerApis.deleteTopics(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable)x$10 -> (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Function1 & Serializable)x$11 -> Predef$.MODULE$.Set().empty()).get()).asScala().toSet());
    }

    @Test
    public void testNotControllerErrorPreventsDeletingTopics() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        controller.setActive(false);
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, new Properties());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        Assertions.assertEquals(NotControllerException.class, Assertions.assertThrows(ExecutionException.class, () -> controllerApis.deleteTopics(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable)x$12 -> (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Function1 & Serializable)x$13 -> (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))).get()).getCause().getClass());
    }

    @Test
    public void testDeleteTopicsDisabled() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "false");
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, props);
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("foo").setTopicId(Uuid.ZERO_UUID));
        Assertions.assertThrows(TopicDeletionDisabledException.class, () -> controllerApis.deleteTopics(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable)x$14 -> (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Function1 & Serializable)x$15 -> (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        Assertions.assertThrows(InvalidRequestException.class, () -> controllerApis.deleteTopics(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, request, 1, false, (Function1 & Serializable)x$16 -> (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Function1 & Serializable)x$17 -> (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCreatePartitionsRequest(boolean validateOnly) {
        Controller controller = (Controller)Mockito.mock(Controller.class);
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, new Properties());
        CreatePartitionsRequestData request = new CreatePartitionsRequestData();
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("foo").setAssignments(null).setCount(5));
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("bar").setAssignments(null).setCount(5));
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("bar").setAssignments(null).setCount(5));
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("bar").setAssignments(null).setCount(5));
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("baz").setAssignments(null).setCount(5));
        request.setValidateOnly(validateOnly);
        Mockito.when((Object)controller.createPartitions((ControllerRequestContext)ArgumentMatchers.any(), (List)ArgumentMatchers.eq(Collections.singletonList(new CreatePartitionsRequestData.CreatePartitionsTopic().setName("foo").setAssignments(null).setCount(5))), ArgumentMatchers.eq((boolean)validateOnly))).thenReturn(CompletableFuture.completedFuture(Collections.singletonList(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("foo").setErrorCode(Errors.NONE.code()).setErrorMessage(null))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CreatePartitionsResponseData.CreatePartitionsTopicResult[]{new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("foo").setErrorCode(Errors.NONE.code()).setErrorMessage(null), new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("bar").setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("baz").setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(null)})), (Object)CollectionConverters$.MODULE$.ListHasAsScala((List)controllerApis.createPartitions(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, request, (Function1 & Serializable)x$18 -> (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))).get()).asScala().toSet());
    }

    @Test
    public void testCreatePartitionsAuthorization() {
        MockController controller = new MockController.Builder().newInitialTopic("foo", Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q")).build();
        Authorizer authorizer = (Authorizer)Mockito.mock(Authorizer.class);
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)new Some((Object)authorizer), controller, new Properties());
        CreatePartitionsRequestData requestData = new CreatePartitionsRequestData();
        requestData.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("foo").setAssignments(null).setCount(2));
        requestData.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("bar").setAssignments(null).setCount(10));
        CreatePartitionsRequest request = (CreatePartitionsRequest)new CreatePartitionsRequest.Builder(requestData).build();
        ResourcePattern fooResource = new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL);
        Action fooAction = new Action(AclOperation.ALTER, fooResource, 1, true, true);
        ResourcePattern barResource = new ResourcePattern(ResourceType.TOPIC, "bar", PatternType.LITERAL);
        Action barAction = new Action(AclOperation.ALTER, barResource, 1, true, true);
        Mockito.when((Object)authorizer.authorize((AuthorizableRequestContext)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Buffer results = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala((List)invocation.getArgument(1)).asScala().map((Function1 & Serializable)action -> {
                Action action2 = action;
                if (!(action2 != null ? !action2.equals(fooAction) : fooAction != null)) {
                    return AuthorizationResult.ALLOWED;
                }
                Action action3 = action;
                if (!(action3 != null ? !action3.equals(barAction) : barAction != null)) {
                    return AuthorizationResult.DENIED;
                }
                throw new AssertionError((Object)new StringBuilder(18).append("Unexpected action ").append(action).toString());
            });
            return new ArrayList(CollectionConverters$.MODULE$.BufferHasAsJava(results).asJava());
        });
        CreatePartitionsResponse response = (CreatePartitionsResponse)this.handleRequest((AbstractRequest)request, controllerApis, ClassTag$.MODULE$.apply(CreatePartitionsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Buffer results = CollectionConverters$.MODULE$.ListHasAsScala(response.data().results()).asScala();
        Assertions.assertEquals((Object)new Some((Object)Errors.NONE), (Object)results.find((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)ControllerApisTest.$anonfun$testCreatePartitionsAuthorization$3(x$19))).map((Function1 & Serializable)result -> Errors.forCode((short)result.errorCode())));
        Assertions.assertEquals((Object)new Some((Object)Errors.TOPIC_AUTHORIZATION_FAILED), (Object)results.find((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)ControllerApisTest.$anonfun$testCreatePartitionsAuthorization$5(x$20))).map((Function1 & Serializable)result -> Errors.forCode((short)result.errorCode())));
    }

    @Test
    public void testElectLeadersAuthorization() {
        Authorizer authorizer = (Authorizer)Mockito.mock(Authorizer.class);
        Controller controller = (Controller)Mockito.mock(Controller.class);
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)new Some((Object)authorizer), controller, new Properties());
        ElectLeadersRequest request = (ElectLeadersRequest)new ElectLeadersRequest.Builder(ElectionType.PREFERRED, null, 30000).build();
        ResourcePattern resource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        List<Action> actions = Collections.singletonList(new Action(AclOperation.ALTER, resource, 1, true, true));
        Mockito.when((Object)authorizer.authorize((AuthorizableRequestContext)ArgumentMatchers.any(), (List)ArgumentMatchers.eq(actions))).thenReturn(Collections.singletonList(AuthorizationResult.DENIED));
        ElectLeadersResponse response = (ElectLeadersResponse)this.handleRequest((AbstractRequest)request, controllerApis, ClassTag$.MODULE$.apply(ElectLeadersResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((Object)Errors.CLUSTER_AUTHORIZATION_FAILED, (Object)Errors.forCode((short)response.data().errorCode()));
    }

    @Test
    public void testElectLeadersHandledByController() {
        Controller controller = (Controller)Mockito.mock(Controller.class);
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, new Properties());
        ElectLeadersRequest request = (ElectLeadersRequest)new ElectLeadersRequest.Builder(ElectionType.PREFERRED, null, 30000).build();
        ElectLeadersResponseData responseData = new ElectLeadersResponseData().setErrorCode(Errors.NOT_CONTROLLER.code());
        Mockito.when((Object)controller.electLeaders((ControllerRequestContext)ArgumentMatchers.any(), (ElectLeadersRequestData)ArgumentMatchers.eq((Object)request.data()))).thenReturn(CompletableFuture.completedFuture(responseData));
        ElectLeadersResponse response = (ElectLeadersResponse)this.handleRequest((AbstractRequest)request, controllerApis, ClassTag$.MODULE$.apply(ElectLeadersResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)Errors.forCode((short)response.data().errorCode()));
    }

    @Test
    public void testDeleteTopicsReturnsNotController() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "foo";
        Controller controller = (Controller)Mockito.mock(Controller.class);
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, new Properties());
        CompletableFuture<Map<Uuid, ResultOrError>> findNamesFuture = CompletableFuture.completedFuture(Collections.singletonMap(topicId, new ResultOrError((Object)topicName)));
        Mockito.when((Object)controller.findTopicNames((ControllerRequestContext)ArgumentMatchers.any(), (Collection)ArgumentMatchers.eq(Collections.singleton(topicId)))).thenReturn(findNamesFuture);
        CompletableFuture findIdsFuture = CompletableFuture.completedFuture(Collections.emptyMap());
        Mockito.when((Object)controller.findTopicIds((ControllerRequestContext)ArgumentMatchers.any(), (Collection)ArgumentMatchers.eq(Collections.emptySet()))).thenReturn(findIdsFuture);
        CompletableFuture deleteFuture = new CompletableFuture();
        deleteFuture.completeExceptionally((Throwable)new NotControllerException("Controller has moved"));
        Mockito.when((Object)controller.deleteTopics((ControllerRequestContext)ArgumentMatchers.any(), (Collection)ArgumentMatchers.eq(Collections.singleton(topicId)))).thenReturn(deleteFuture);
        DeleteTopicsRequest request = (DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopics(Collections.singletonList(new DeleteTopicsRequestData.DeleteTopicState().setTopicId(topicId)))).build();
        DeleteTopicsResponse response = (DeleteTopicsResponse)this.handleRequest((AbstractRequest)request, controllerApis, ClassTag$.MODULE$.apply(DeleteTopicsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        DeleteTopicsResponseData.DeletableTopicResult topicIdResponse = (DeleteTopicsResponseData.DeletableTopicResult)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().responses()).asScala().find((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)ControllerApisTest.$anonfun$testDeleteTopicsReturnsNotController$1(topicId, x$21))).get();
        Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)Errors.forCode((short)topicIdResponse.errorCode()));
    }

    @Test
    public void testAllocateProducerIdsReturnsNotController() {
        Controller controller = (Controller)Mockito.mock(Controller.class);
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, new Properties());
        CompletableFuture future = new CompletableFuture();
        CompletionStage thenApplyFuture = future.thenApply(result -> new AllocateProducerIdsResponseData().setProducerIdStart(result.firstProducerId()).setProducerIdLen(result.size()));
        future.completeExceptionally((Throwable)new NotControllerException("Controller has moved"));
        AllocateProducerIdsRequest request = (AllocateProducerIdsRequest)new AllocateProducerIdsRequest.Builder(new AllocateProducerIdsRequestData().setBrokerId(4).setBrokerEpoch(93234L)).build();
        Mockito.when((Object)controller.allocateProducerIds((ControllerRequestContext)ArgumentMatchers.any(), (AllocateProducerIdsRequestData)ArgumentMatchers.eq((Object)request.data()))).thenReturn((Object)thenApplyFuture);
        AllocateProducerIdsResponse response = (AllocateProducerIdsResponse)this.handleRequest((AbstractRequest)request, controllerApis, ClassTag$.MODULE$.apply(AllocateProducerIdsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)response.error());
    }

    private <T extends AbstractResponse> T handleRequest(AbstractRequest request, ControllerApis controllerApis, ClassTag<T> classTag, NotNothing<T> nn) {
        Option option;
        RequestChannel.Request req = this.buildRequest(request, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        controllerApis.handle(req, RequestLocal$.MODULE$.NoCaching());
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)req), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        AbstractResponse abstractResponse = (AbstractResponse)capturedResponse.getValue();
        if (abstractResponse == null || (option = classTag.unapply((Object)abstractResponse)).isEmpty() || option.get() == null) {
            throw new ClassCastException(new StringBuilder(0).append(new StringBuilder(30).append("Expected response with type ").append(classTag.runtimeClass()).append(", ").toString()).append(new StringBuilder(10).append("but found ").append(abstractResponse.getClass()).toString()).toString());
        }
        return (T)abstractResponse;
    }

    @Test
    public void testCompletableFutureExceptions() {
        RequestChannel.Request request = this.buildRequest((AbstractRequest)new FetchRequest(new FetchRequestData(), 12), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        FetchResponseData response = new FetchResponseData();
        CompletableFuture<FetchResponseData> responseFuture = new CompletableFuture<FetchResponseData>();
        AtomicReference errorResponseFuture = new AtomicReference();
        Mockito.when((Object)this.raftManager().handleRequest((RequestHeader)ArgumentMatchers.any(), (ApiMessage)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(responseFuture);
        this.requestChannel().sendResponse((RequestChannel.Request)ArgumentMatchers.any(), (AbstractResponse)ArgumentMatchers.any(), (Option)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$22 -> {
            throw new UnsupportedVersionException("Something went wrong");
        }).thenAnswer(invocation -> {
            ControllerApisTest.$anonfun$testCompletableFutureExceptions$2(errorResponseFuture, invocation);
            return BoxedUnit.UNIT;
        });
        this.createControllerApis((Option<Authorizer>)None$.MODULE$, new MockController.Builder().build(), new Properties()).handle(request, null);
        responseFuture.complete(response);
        AbstractResponse errorResponse = (AbstractResponse)errorResponseFuture.get();
        Assertions.assertEquals((int)1, (Integer)errorResponse.errorCounts().getOrDefault(Errors.UNSUPPORTED_VERSION, Predef$.MODULE$.int2Integer(0)));
    }

    @AfterEach
    public void tearDown() {
        this.quotas().shutdown();
    }

    public static final /* synthetic */ boolean $anonfun$testCreatePartitionsAuthorization$3(CreatePartitionsResponseData.CreatePartitionsTopicResult x$19) {
        String string = x$19.name();
        String string2 = "foo";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testCreatePartitionsAuthorization$5(CreatePartitionsResponseData.CreatePartitionsTopicResult x$20) {
        String string = x$20.name();
        String string2 = "bar";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicsReturnsNotController$1(Uuid topicId$1, DeleteTopicsResponseData.DeletableTopicResult x$21) {
        Uuid uuid = x$21.topicId();
        return !(uuid != null ? !uuid.equals(topicId$1) : topicId$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testCompletableFutureExceptions$2(AtomicReference errorResponseFuture$1, InvocationOnMock invocation) {
        AbstractResponse resp = (AbstractResponse)invocation.getArgument(1, AbstractResponse.class);
        errorResponseFuture$1.set(resp);
    }

    public ControllerApisTest() {
        this.nodeId = 1;
        this.brokerRack = "Rack1";
        this.clientID = "Client1";
    }
}

