/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.DefaultAlterPartitionManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.QuorumTestHarness;
import kafka.server.ZkAlterPartitionManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005I3AAC\u0006\u0001!!)Q\u0003\u0001C\u0001-!)\u0001\u0004\u0001C\u00013!)Q\u0006\u0001C\u00013!)q\u0006\u0001C\u00013!)\u0011\u0007\u0001C\u00013!)1\u0007\u0001C\u00013!)Q\u0007\u0001C\u00013!)q\u0007\u0001C\u00013!)\u0011\b\u0001C\u0001u\ty1*\u00194lCN+'O^3s)\u0016\u001cHO\u0003\u0002\r\u001b\u000511/\u001a:wKJT\u0011AD\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0002\u0013'5\t1\"\u0003\u0002\u0015\u0017\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\n\u0001\u0003!\"Xm\u001d;BYJ,\u0017\rZ=SK\u001eL7\u000f^3sK\u0012\fEM^3si&\u001cX\r\u001a'jgR,g.\u001a:t)\u0005Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"\u0001B+oSRD#AA\u0011\u0011\u0005\tZS\"A\u0012\u000b\u0005\u0011*\u0013aA1qS*\u0011aeJ\u0001\bUV\u0004\u0018\u000e^3s\u0015\tA\u0013&A\u0003kk:LGOC\u0001+\u0003\ry'oZ\u0005\u0003Y\r\u0012A\u0001V3ti\u0006IC/Z:u\u0007J,\u0017\r^3t!J|\u0007/\u001a:[W\u000e{gNZ5h/\",gnU1tY\u0012K7/\u00192mK\u0012D#aA\u0011\u0002QQ,7\u000f^\"sK\u0006$Xm\u001d)s_B,'OW6UYN\u001cuN\u001c4jO^CWM\u001c#jg\u0006\u0014G.\u001a3)\u0005\u0011\t\u0013A\u000b;fgR\u001c%/Z1uKN\u0004&o\u001c9fej[G\u000b\\:D_:4\u0017nZ,ji\"$&/^3WC2,Xm\u001d\u0015\u0003\u000b\u0005\n!\u0007^3ti\u000e\u0013X-\u0019;fgB\u0013x\u000e]3s5.$Fn]\"p]\u001aLwmV5uQ\u001a\u000bGn]3B]\u0012d\u0015n\u001d;WC2,Xm\u001d\u0015\u0003\r\u0005\n\u0001\u0003^3tij[\u0017j\u001d:NC:\fw-\u001a:)\u0005\u001d\t\u0013a\u0005;fgR\fE\u000e^3s\u0013N\u0014X*\u00198bO\u0016\u0014\bF\u0001\u0005\"\u00031\u0019'/Z1uKN+'O^3s)\u0011Ydh\u0011)\u0011\u0005Ia\u0014BA\u001f\f\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\u000b}J\u0001\u0019\u0001!\u0002\r9|G-Z%e!\tY\u0012)\u0003\u0002C9\t\u0019\u0011J\u001c;\t\u000b\u0011K\u0001\u0019A#\u0002\u0011!|7\u000f\u001e(b[\u0016\u0004\"AR'\u000f\u0005\u001d[\u0005C\u0001%\u001d\u001b\u0005I%B\u0001&\u0010\u0003\u0019a$o\\8u}%\u0011A\nH\u0001\u0007!J,G-\u001a4\n\u00059{%AB*ue&twM\u0003\u0002M9!)\u0011+\u0003a\u0001\u0001\u0006!\u0001o\u001c:u\u0001")
public class KafkaServerTest
extends QuorumTestHarness {
    @Test
    public void testAlreadyRegisteredAdvertisedListeners() {
        KafkaServer server1 = this.createServer(1, "myhost", TestUtils$.MODULE$.RandomPort());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createServer(2, "myhost", TestUtils$.MODULE$.boundPort((KafkaBroker)server1, SecurityProtocol.PLAINTEXT)));
        KafkaServer server2 = this.createServer(2, "myhost", TestUtils$.MODULE$.RandomPort());
        TestUtils$.MODULE$.shutdownServers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1, server2})), true);
    }

    @Test
    public void testCreatesProperZkConfigWhenSaslDisabled() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        Assertions.assertEquals((Object)"false", (Object)zkClientConfig.getProperty("zookeeper.sasl.client"));
    }

    @Test
    public void testCreatesProperZkTlsConfigWhenDisabled() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        props.put(KafkaConfig$.MODULE$.ZkSslClientEnableProp(), "false");
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)propName -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(zkClientConfig, propName);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithTrueValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$1(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithFalseAndListValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$2(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkIsrManager() {
        void createServer_time;
        void createServer_config;
        Time time;
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.7-IV1");
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        Object var6_6 = null;
        Object var3_5 = null;
        kafkaConfig = null;
        time3 = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, true);
        if (!(server.replicaManager().alterPartitionManager() instanceof ZkAlterPartitionManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use ZK for ISR manager in versions before 2.7-IV2");
        }
        server.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterIsrManager() {
        void createServer_time;
        void createServer_config;
        Time time;
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), MetadataVersion.latest().toString());
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        Object var6_6 = null;
        Object var3_5 = null;
        kafkaConfig = null;
        time3 = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, true);
        if (!(server.replicaManager().alterPartitionManager() instanceof DefaultAlterPartitionManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use AlterIsr for ISR manager in versions after 2.7-IV2");
        }
        server.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    public KafkaServer createServer(int nodeId, String hostName, int port) {
        void createServer_time;
        Time time;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), new StringBuilder(13).append("PLAINTEXT://").append(hostName).append(":").append(port).toString());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        return createServer_this.createServer(kafkaConfig, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, true);
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(ZKClientConfig zkClientConfig$1, String propName) {
        Assertions.assertNull((Object)zkClientConfig$1.getProperty(propName));
    }

    private static final String kafkaConfigValueToSet$1(String kafkaProp, String someValue$1) {
        String string;
        boolean bl;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
        }
        if (bl) {
            string = "true";
        } else {
            String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            string = !(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null) ? "HTTPS" : someValue$1;
        }
        return string;
    }

    private static final String zkClientValueToExpect$1(String kafkaProp, String someValue$1) {
        String string;
        boolean bl;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
        }
        if (bl) {
            string = "true";
        } else {
            String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            string = !(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null) ? "true" : someValue$1;
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(ZKClientConfig zkClientConfig$2, String someValue$1, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$1(kafkaProp, someValue$1), (Object)zkClientConfig$2.getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
    }

    private static final String kafkaConfigValueToSet$2(String kafkaProp, String someValue$2) {
        String string;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            string = "true";
        } else {
            boolean bl;
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
            if (bl) {
                string = "false";
            } else {
                String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
                if (!(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null)) {
                    string = "";
                } else {
                    boolean bl2;
                    String string6 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
                    if (!(string6 != null ? !string6.equals(kafkaProp) : kafkaProp != null)) {
                        bl2 = true;
                    } else {
                        String string7 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
                        bl2 = !(string7 != null ? !string7.equals(kafkaProp) : kafkaProp != null);
                    }
                    string = bl2 ? "A,B" : someValue$2;
                }
            }
        }
        return string;
    }

    private static final String zkClientValueToExpect$2(String kafkaProp, String someValue$2) {
        String string;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            string = "true";
        } else {
            boolean bl;
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
            if (bl) {
                string = "false";
            } else {
                String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
                if (!(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null)) {
                    string = "false";
                } else {
                    boolean bl2;
                    String string6 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
                    if (!(string6 != null ? !string6.equals(kafkaProp) : kafkaProp != null)) {
                        bl2 = true;
                    } else {
                        String string7 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
                        bl2 = !(string7 != null ? !string7.equals(kafkaProp) : kafkaProp != null);
                    }
                    string = bl2 ? "A,B" : someValue$2;
                }
            }
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(ZKClientConfig zkClientConfig$3, String someValue$2, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$2(kafkaProp, someValue$2), (Object)zkClientConfig$3.getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
    }
}

