/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.metadata.BrokerMetadataListener;
import kafka.server.metadata.BrokerServerMetrics;
import kafka.server.metadata.MetadataPublisher;
import kafka.server.metadata.MetadataSnapshotter;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Range;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t5e\u0001\u0002\u001c8\u0001yBQ!\u0012\u0001\u0005\u0002\u0019Cq!\u0013\u0001C\u0002\u0013%!\n\u0003\u0004X\u0001\u0001\u0006Ia\u0013\u0005\u00061\u0002!\t!\u0017\u0005\u0006Q\u0002!I!\u001b\u0005\n\u0003\u0013\u0001\u0011\u0013!C\u0005\u0003\u0017A\u0011\"!\t\u0001#\u0003%I!a\t\t\u0013\u0005\u001d\u0002!%A\u0005\n\u0005%\u0002\"CA\u0017\u0001E\u0005I\u0011BA\u0018\u0011\u0019\t\u0019\u0004\u0001C\u00013\"1\u0011Q\b\u0001\u0005\u0002e3a!!\u0011\u0001\u0001\u0005\r\u0003BB#\r\t\u0003\t)\u0005C\u0005\u0002L1\u0001\r\u0011\"\u0001\u0002N!I\u0011\u0011\f\u0007A\u0002\u0013\u0005\u00111\f\u0005\t\u0003Cb\u0001\u0015)\u0003\u0002P!I\u00111\r\u0007C\u0002\u0013\u0005\u0011Q\r\u0005\t\u0003/c\u0001\u0015!\u0003\u0002h!I\u0011\u0011\u0014\u0007A\u0002\u0013\u0005\u00111\u0014\u0005\n\u0003;c\u0001\u0019!C\u0001\u0003?Cq!a)\rA\u0003&A\u0010C\u0005\u0002&2\u0001\r\u0011\"\u0001\u0002\u001c\"I\u0011q\u0015\u0007A\u0002\u0013\u0005\u0011\u0011\u0016\u0005\b\u0003[c\u0001\u0015)\u0003}\u0011%\ty\u000b\u0004a\u0001\n\u0003\t\t\fC\u0005\u0002:2\u0001\r\u0011\"\u0001\u0002<\"A\u0011q\u0018\u0007!B\u0013\t\u0019\fC\u0005\u0002B2\u0001\r\u0011\"\u0001\u0002\u001c\"I\u00111\u0019\u0007A\u0002\u0013\u0005\u0011Q\u0019\u0005\b\u0003\u0013d\u0001\u0015)\u0003}\u0011\u001d\tY\r\u0004C!\u0003\u001b4a!!8\u0001\u0001\u0005}\u0007BB#!\t\u0003\t9\u000fC\u0005\u0002L\u0001\u0002\r\u0011\"\u0001\u0002N!I\u0011\u0011\f\u0011A\u0002\u0013\u0005\u00111\u001e\u0005\t\u0003C\u0002\u0003\u0015)\u0003\u0002P!9\u0011q\u001e\u0011\u0005B\u0005E\bbBA\u0000A\u0011\u0005\u00131\u0014\u0005\n\u0005\u0003\u0001!\u0019!C\u0005\u0005\u0007A\u0001B!\u0005\u0001A\u0003%!Q\u0001\u0005\n\u0005'\u0001!\u0019!C\u0005\u0005\u0007A\u0001B!\u0006\u0001A\u0003%!Q\u0001\u0005\b\u0005/\u0001A\u0011\u0002B\r\u0011\u001d\u0011\u0019\u0003\u0001C\u0005\u0005KAaAa\u000b\u0001\t\u0003I\u0006B\u0002B\u0018\u0001\u0011\u0005\u0011\f\u0003\u0004\u00034\u0001!\t!\u0017\u0005\u0007\u0005o\u0001A\u0011A-\t\r\tm\u0002\u0001\"\u0001Z\u0011\u0019\u0011y\u0004\u0001C\u00013\"9!1\t\u0001\u0005\n\t\u0015\u0003b\u0002B+\u0001\u0011%!q\u000b\u0005\b\u0005O\u0002A\u0011\u0002B5\u0005i\u0011%o\\6fe6+G/\u00193bi\u0006d\u0015n\u001d;f]\u0016\u0014H+Z:u\u0015\tA\u0014(\u0001\u0005nKR\fG-\u0019;b\u0015\tQ4(\u0001\u0004tKJ4XM\u001d\u0006\u0002y\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001@!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0012\t\u0003\u0011\u0002i\u0011aN\u0001\u001c[\u0016$\u0018\rZ1uC2{\u0017\rZ5oO\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0016\u0003-\u0003\"\u0001T+\u000e\u00035S!AT(\u0002\u000b\u0019\fW\u000f\u001c;\u000b\u0005i\u0002&B\u0001\u001fR\u0015\t\u00116+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002)\u0006\u0019qN]4\n\u0005Yk%\u0001E'pG.4\u0015-\u001e7u\u0011\u0006tG\r\\3s\u0003qiW\r^1eCR\fGj\\1eS:<g)Y;mi\"\u000bg\u000e\u001a7fe\u0002\naB^3sS\u001aLhj\u001c$bk2$8\u000fF\u0001[!\t\u00015,\u0003\u0002]\u0003\n!QK\\5uQ\t!a\f\u0005\u0002`M6\t\u0001M\u0003\u0002bE\u0006\u0019\u0011\r]5\u000b\u0005\r$\u0017a\u00026va&$XM\u001d\u0006\u0003KN\u000bQA[;oSRL!a\u001a1\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!\u00078fo\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uC2K7\u000f^3oKJ$RA[7su~\u0004\"\u0001S6\n\u00051<$A\u0006\"s_.,'/T3uC\u0012\fG/\u0019'jgR,g.\u001a:\t\u000f9,\u0001\u0013!a\u0001_\u00069Q.\u001a;sS\u000e\u001c\bC\u0001%q\u0013\t\txGA\nCe>\\WM]*feZ,'/T3ue&\u001c7\u000fC\u0004t\u000bA\u0005\t\u0019\u0001;\u0002\u0017Mt\u0017\r]:i_R$XM\u001d\t\u0004\u0001V<\u0018B\u0001<B\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001\n_\u0005\u0003s^\u00121#T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;uKJDqa_\u0003\u0011\u0002\u0003\u0007A0\u0001\rnCb\u0014\u0015\u0010^3t\u0005\u0016$x/Z3o':\f\u0007o\u001d5piN\u0004\"\u0001Q?\n\u0005y\f%\u0001\u0002'p]\u001eD\u0011\"!\u0001\u0006!\u0003\u0005\r!a\u0001\u0002\u0019\u0019\fW\u000f\u001c;IC:$G.\u001a:\u0011\u00071\u000b)!C\u0002\u0002\b5\u0013ABR1vYRD\u0015M\u001c3mKJ\f1E\\3x\u0005J|7.\u001a:NKR\fG-\u0019;b\u0019&\u001cH/\u001a8fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u000e)\u001aq.a\u0004,\u0005\u0005E\u0001\u0003BA\n\u0003;i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0007B\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\t)BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1E\\3x\u0005J|7.\u001a:NKR\fG-\u0019;b\u0019&\u001cH/\u001a8fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002&)\u001aA/a\u0004\u0002G9,wO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\rT5ti\u0016tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0006\u0016\u0004y\u0006=\u0011a\t8fo\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uC2K7\u000f^3oKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003cQC!a\u0001\u0002\u0010\u0005\u0011B/Z:u\u0007J,\u0017\r^3B]\u0012\u001cEn\\:fQ\rQ\u0011q\u0007\t\u0004?\u0006e\u0012bAA\u001eA\n!A+Z:u\u0003-!Xm\u001d;Qk\nd\u0017n\u001d5)\u0007-\t9DA\fN_\u000e\\W*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e\u001e;feN\u0019AbP<\u0015\u0005\u0005\u001d\u0003cAA%\u00195\t\u0001!A\u0003j[\u0006<W-\u0006\u0002\u0002PA!\u0011\u0011KA+\u001b\t\t\u0019FC\u0002\u0002LAKA!a\u0016\u0002T\tiQ*\u001a;bI\u0006$\u0018-S7bO\u0016\f\u0011\"[7bO\u0016|F%Z9\u0015\u0007i\u000bi\u0006C\u0005\u0002`=\t\t\u00111\u0001\u0002P\u0005\u0019\u0001\u0010J\u0019\u0002\r%l\u0017mZ3!\u0003\u001d1\u0017-\u001b7ve\u0016,\"!a\u001a\u0011\r\u0005%\u00141PA@\u001b\t\tYG\u0003\u0003\u0002n\u0005=\u0014AB1u_6L7M\u0003\u0003\u0002r\u0005M\u0014AC2p]\u000e,(O]3oi*!\u0011QOA<\u0003\u0011)H/\u001b7\u000b\u0005\u0005e\u0014\u0001\u00026bm\u0006LA!! \u0002l\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0003\u0002\u0002\u0006Ee\u0002BAB\u0003\u001bsA!!\"\u0002\f6\u0011\u0011q\u0011\u0006\u0004\u0003\u0013k\u0014A\u0002\u001fs_>$h(C\u0001C\u0013\r\ty)Q\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019*!&\u0003\u0013QC'o\\<bE2,'bAAH\u0003\u0006Aa-Y5mkJ,\u0007%\u0001\u000bbGRLg/Z*oCB\u001c\bn\u001c;PM\u001a\u001cX\r^\u000b\u0002y\u0006A\u0012m\u0019;jm\u0016\u001cf.\u00199tQ>$xJ\u001a4tKR|F%Z9\u0015\u0007i\u000b\t\u000b\u0003\u0005\u0002`Q\t\t\u00111\u0001}\u0003U\t7\r^5wKNs\u0017\r]:i_R|eMZ:fi\u0002\n1\u0003\u001d:fm\u000e{W.\\5ui\u0016$wJ\u001a4tKR\fq\u0003\u001d:fm\u000e{W.\\5ui\u0016$wJ\u001a4tKR|F%Z9\u0015\u0007i\u000bY\u000b\u0003\u0005\u0002`]\t\t\u00111\u0001}\u0003Q\u0001(/\u001a<D_6l\u0017\u000e\u001e;fI>3gm]3uA\u0005\u0011\u0002O]3w\u0007>lW.\u001b;uK\u0012,\u0005o\\2i+\t\t\u0019\fE\u0002A\u0003kK1!a.B\u0005\rIe\u000e^\u0001\u0017aJ,goQ8n[&$H/\u001a3Fa>\u001c\u0007n\u0018\u0013fcR\u0019!,!0\t\u0013\u0005}#$!AA\u0002\u0005M\u0016a\u00059sKZ\u001cu.\\7jiR,G-\u00129pG\"\u0004\u0013\u0001\u00079sKZd\u0015m\u001d;D_:$\u0018-\u001b8fI2{w\rV5nK\u0006a\u0002O]3w\u0019\u0006\u001cHoQ8oi\u0006Lg.\u001a3M_\u001e$\u0016.\\3`I\u0015\fHc\u0001.\u0002H\"A\u0011qL\u000f\u0002\u0002\u0003\u0007A0A\rqe\u00164H*Y:u\u0007>tG/Y5oK\u0012dun\u001a+j[\u0016\u0004\u0013AE7bs\n,7\u000b^1siNs\u0017\r]:i_R$b!a4\u0002V\u0006e\u0007c\u0001!\u0002R&\u0019\u00111[!\u0003\u000f\t{w\u000e\\3b]\"1\u0011q[\u0010A\u0002q\fA\u0003\\1ti\u000e{g\u000e^1j]\u0016$Gj\\4US6,\u0007bBAn?\u0001\u0007\u0011qJ\u0001\t]\u0016<\u0018*\\1hK\n)Rj\\2l\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u00148\u0003\u0002\u0011@\u0003C\u00042\u0001SAr\u0013\r\t)o\u000e\u0002\u0012\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014HCAAu!\r\tI\u0005\t\u000b\u00045\u00065\b\"CA0G\u0005\u0005\t\u0019AA(\u0003\u001d\u0001XO\u00197jg\"$RAWAz\u0003{Dq!!>&\u0001\u0004\t90A\u0003eK2$\u0018\r\u0005\u0003\u0002R\u0005e\u0018\u0002BA~\u0003'\u0012Q\"T3uC\u0012\fG/\u0019#fYR\f\u0007bBAnK\u0001\u0007\u0011qJ\u0001\u0010aV\u0014G.[:iK\u0012|eMZ:fi\u00061aiT(`\u0013\u0012+\"A!\u0002\u0011\t\t\u001d!QB\u0007\u0003\u0005\u0013Q1Aa\u0003Q\u0003\u0019\u0019w.\\7p]&!!q\u0002B\u0005\u0005\u0011)V/\u001b3\u0002\u000f\u0019{ujX%EA\u00051!)\u0011*`\u0013\u0012\u000bqAQ!S?&#\u0005%A\nhK:,'/\u0019;f\u001b\u0006t\u0017PU3d_J$7\u000fF\u0003[\u00057\u0011y\u0002\u0003\u0004\u0003\u001e-\u0002\rA[\u0001\tY&\u001cH/\u001a8fe\"1!\u0011E\u0016A\u0002q\f\u0011\"\u001a8e\u001f\u001a47/\u001a;\u0002%\u001d,g.\u001a:bi\u0016\u0014\u0015\r\u001a*fG>\u0014Hm\u001d\u000b\u00065\n\u001d\"\u0011\u0006\u0005\u0007\u0005;a\u0003\u0019\u00016\t\r\t\u0005B\u00061\u0001}\u0003%\"Xm\u001d;IC:$G.Z\"p[6LGo],ji\"tun\u00158baNDw\u000e\u001e;fe\u0012+g-\u001b8fI\"\u001aQ&a\u000e\u0002%Q,7\u000f^\"sK\u0006$Xm\u00158baNDw\u000e\u001e\u0015\u0004]\u0005]\u0012!\u000f;fgRtu\u000e^*oCB\u001c\bn\u001c;BMR,'/T3uC\u0012\fG/\u0019,feNLwN\\\"iC:<WMQ3g_J,\u0007+\u001e2mSND\u0017N\\4)\u0007=\n9$\u0001\u001auKN$8K\\1qg\"|G/\u00114uKJlU\r^1eCR\fg+\u001a:tS>t7\t[1oO\u0016<\u0006.\u001a8Ti\u0006\u0014H/\u001b8hQ\r\u0001\u0014qG\u0001'i\u0016\u001cHo\u00158baNDw\u000e^!gi\u0016\u0014X*\u001a;bI\u0006$\u0018MV3sg&|gn\u00115b]\u001e,\u0007fA\u0019\u00028\u0005AB/Z:u\u001d>\u001cf.\u00199tQ>$\u0018I\u001a;fe\u0016\u0013(o\u001c:)\u0007I\n9$A\bsK\u001eL7\u000f^3s\u0005J|7.\u001a:t)\u001dQ&q\tB%\u0005'BaA!\b4\u0001\u0004Q\u0007b\u0002B&g\u0001\u0007!QJ\u0001\nEJ|7.\u001a:JIN\u0004b!!!\u0003P\u0005M\u0016\u0002\u0002B)\u0003+\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\u0007\u0005C\u0019\u0004\u0019\u0001?\u00027\r\u0014X-\u0019;f)>\u0004\u0018nY,ji\"|e.\u001a)beRLG/[8o)\u001dQ&\u0011\fB.\u0005KBaA!\b5\u0001\u0004Q\u0007b\u0002B/i\u0001\u0007!qL\u0001\te\u0016\u0004H.[2bgB1\u0011\u0011\u0011B1\u0003gKAAa\u0019\u0002\u0016\n\u00191+Z9\t\r\t\u0005B\u00071\u0001}\u00035)\b\u000fZ1uK\u001a+\u0017\r^;sKRI!La\u001b\u0003n\t\u0005%1\u0012\u0005\u0007\u0005;)\u0004\u0019\u00016\t\u000f\t=T\u00071\u0001\u0003r\u00059a-Z1ukJ,\u0007\u0003\u0002B:\u0005wrAA!\u001e\u0003xA\u0019\u0011QQ!\n\u0007\te\u0014)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005{\u0012yH\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005s\n\u0005b\u0002BBk\u0001\u0007!QQ\u0001\bm\u0016\u00148/[8o!\r\u0001%qQ\u0005\u0004\u0005\u0013\u000b%!B*i_J$\bB\u0002B\u0011k\u0001\u0007A\u0010")
public class BrokerMetadataListenerTest {
    private final MockFaultHandler metadataLoadingFaultHandler = new MockFaultHandler("metadata loading");
    private final Uuid FOO_ID = Uuid.fromString((String)"jj1G9utnTuCegi_gpnRgYw");
    private final Uuid BAR_ID = Uuid.fromString((String)"SzN5j0LvSEaRIJHrxfMAlg");

    private MockFaultHandler metadataLoadingFaultHandler() {
        return this.metadataLoadingFaultHandler;
    }

    @AfterEach
    public void verifyNoFaults() {
        this.metadataLoadingFaultHandler().maybeRethrowFirstException();
    }

    private BrokerMetadataListener newBrokerMetadataListener(BrokerServerMetrics metrics, Option<MetadataSnapshotter> snapshotter, long maxBytesBetweenSnapshots, FaultHandler faultHandler) {
        return new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, maxBytesBetweenSnapshots, snapshotter, metrics, faultHandler);
    }

    private BrokerServerMetrics newBrokerMetadataListener$default$1() {
        Metrics apply_metrics = new Metrics();
        return new BrokerServerMetrics(apply_metrics);
    }

    private Option<MetadataSnapshotter> newBrokerMetadataListener$default$2() {
        return None$.MODULE$;
    }

    private long newBrokerMetadataListener$default$3() {
        return 1000000L;
    }

    private FaultHandler newBrokerMetadataListener$default$4() {
        return this.metadataLoadingFaultHandler();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateAndClose() {
        void newBrokerMetadataListener_faultHandler;
        long l = 1000000L;
        FaultHandler faultHandler = this.newBrokerMetadataListener$default$4();
        None$ newBrokerMetadataListener_snapshotter = None$.MODULE$;
        BrokerServerMetrics newBrokerMetadataListener_metrics = this.newBrokerMetadataListener$default$1();
        Object var1_4 = null;
        Object var2_3 = null;
        faultHandler = null;
        new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, l, (Option)newBrokerMetadataListener_snapshotter, newBrokerMetadataListener_metrics, (FaultHandler)newBrokerMetadataListener_faultHandler).close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPublish() {
        void newBrokerMetadataListener_faultHandler;
        BrokerMetadataListener brokerMetadataListener;
        BrokerServerMetrics brokerServerMetrics;
        Metrics apply_metrics = new Metrics();
        BrokerServerMetrics brokerServerMetrics2 = brokerServerMetrics = new BrokerServerMetrics(apply_metrics);
        Object var11_1 = null;
        brokerServerMetrics = null;
        BrokerServerMetrics metrics = brokerServerMetrics2;
        long l = 1000000L;
        FaultHandler faultHandler = this.newBrokerMetadataListener$default$4();
        None$ newBrokerMetadataListener_snapshotter = None$.MODULE$;
        BrokerMetadataListener brokerMetadataListener2 = brokerMetadataListener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, l, (Option)newBrokerMetadataListener_snapshotter, metrics, (FaultHandler)newBrokerMetadataListener_faultHandler);
        Object var13_6 = null;
        faultHandler = null;
        brokerMetadataListener = null;
        try (BrokerMetadataListener listener = brokerMetadataListener2;){
            long unfencedTimestamp = 300L;
            listener.handleCommit(RecordTestUtils.mockBatchReader((long)100L, (long)unfencedTimestamp, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(false).setRack(null).setIncarnationId(Uuid.fromString((String)"GFBwlTcpQUuLYQ2ig05CSg")), (short)0))));
            List imageRecords = (List)listener.getImageRecords().get();
            Assertions.assertEquals((int)0, (int)imageRecords.size());
            Assertions.assertEquals((long)100L, (long)listener.highestMetadataOffset());
            Assertions.assertEquals((long)0L, (long)metrics.lastAppliedRecordOffset().get());
            Assertions.assertEquals((long)0L, (long)metrics.lastAppliedRecordTimestamp().get());
            Assertions.assertEquals((long)0L, (long)metrics.metadataLoadErrorCount().get());
            Assertions.assertEquals((long)0L, (long)metrics.metadataApplyErrorCount().get());
            long fencedTimestamp = 500L;
            long fencedLastOffset = 200L;
            listener.handleCommit(RecordTestUtils.mockBatchReader((long)fencedLastOffset, (long)fencedTimestamp, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(200L).setFenced(true).setRack(null).setIncarnationId(Uuid.fromString((String)"QkOQtNKVTYatADcaJ28xDg")), (short)0))));
            listener.startPublishing(new MetadataPublisher(null){

                public void publish(MetadataDelta delta, MetadataImage newImage) {
                    Assertions.assertEquals((long)200L, (long)newImage.highestOffsetAndEpoch().offset);
                    Assertions.assertEquals((Object)new BrokerRegistration(0, 100L, Uuid.fromString((String)"GFBwlTcpQUuLYQ2ig05CSg"), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), false, false), (Object)delta.clusterDelta().broker(0));
                    Assertions.assertEquals((Object)new BrokerRegistration(1, 200L, Uuid.fromString((String)"QkOQtNKVTYatADcaJ28xDg"), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), true, false), (Object)delta.clusterDelta().broker(1));
                }

                public long publishedOffset() {
                    return -1L;
                }
            }).get();
            Assertions.assertEquals((long)fencedLastOffset, (long)metrics.lastAppliedRecordOffset().get());
            Assertions.assertEquals((long)fencedTimestamp, (long)metrics.lastAppliedRecordTimestamp().get());
            Assertions.assertEquals((long)0L, (long)metrics.metadataLoadErrorCount().get());
            Assertions.assertEquals((long)0L, (long)metrics.metadataApplyErrorCount().get());
        }
    }

    private Uuid FOO_ID() {
        return this.FOO_ID;
    }

    private Uuid BAR_ID() {
        return this.BAR_ID;
    }

    private void generateManyRecords(BrokerMetadataListener listener, long endOffset) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 10000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, (long)0L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setRemovingReplicas(Collections.singletonList(Predef$.MODULE$.int2Integer(1))), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setRemovingReplicas(Collections.emptyList()), (short)0)))));
        listener.getImageRecords().get();
    }

    private void generateBadRecords(BrokerMetadataListener listener, long endOffset) {
        listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, (long)0L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.BAR_ID()).setRemovingReplicas(Collections.singletonList(Predef$.MODULE$.int2Integer(1))), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.BAR_ID()).setRemovingReplicas(Collections.emptyList()), (short)0))));
        listener.getImageRecords().get();
    }

    @Test
    public void testHandleCommitsWithNoSnapshotterDefined() {
        BrokerMetadataListener brokerMetadataListener;
        None$ none$;
        BrokerServerMetrics x$2 = this.newBrokerMetadataListener$default$1();
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$3 = none$2;
        FaultHandler x$4 = this.newBrokerMetadataListener$default$4();
        long newBrokerMetadataListener_maxBytesBetweenSnapshots = 1000L;
        BrokerMetadataListener brokerMetadataListener2 = brokerMetadataListener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, newBrokerMetadataListener_maxBytesBetweenSnapshots, (Option)x$3, x$2, x$4);
        brokerMetadataListener = null;
        try (BrokerMetadataListener listener = brokerMetadataListener2;){
            Range.Inclusive brokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3);
            this.registerBrokers(listener, (Iterable<Object>)brokerIds, 100L);
            this.createTopicWithOnePartition(listener, (scala.collection.immutable.Seq<Object>)brokerIds, 200L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)200L, (long)listener.highestMetadataOffset());
            this.generateManyRecords(listener, 1000L);
            Assertions.assertEquals((long)1000L, (long)listener.highestMetadataOffset());
        }
    }

    @Test
    public void testCreateSnapshot() {
        BrokerMetadataListener brokerMetadataListener;
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        Some x$1 = new Some((Object)snapshotter);
        BrokerServerMetrics x$3 = this.newBrokerMetadataListener$default$1();
        FaultHandler x$4 = this.newBrokerMetadataListener$default$4();
        long newBrokerMetadataListener_maxBytesBetweenSnapshots = 1000L;
        BrokerMetadataListener brokerMetadataListener2 = brokerMetadataListener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, newBrokerMetadataListener_maxBytesBetweenSnapshots, (Option)x$1, x$3, x$4);
        brokerMetadataListener = null;
        try (BrokerMetadataListener listener = brokerMetadataListener2;){
            Range.Inclusive brokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3);
            this.registerBrokers(listener, (Iterable<Object>)brokerIds, 100L);
            this.createTopicWithOnePartition(listener, (scala.collection.immutable.Seq<Object>)brokerIds, 200L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)200L, (long)listener.highestMetadataOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.prevCommittedOffset());
            this.generateManyRecords(listener, 1000L);
            Assertions.assertEquals((long)1000L, (long)snapshotter.prevCommittedOffset());
            Assertions.assertEquals((long)1000L, (long)snapshotter.activeSnapshotOffset());
            snapshotter.activeSnapshotOffset_$eq(-1L);
            MockMetadataPublisher publisher = new MockMetadataPublisher();
            listener.startPublishing((MetadataPublisher)publisher).get();
            this.generateManyRecords(listener, 2000L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            Assertions.assertEquals((long)2000L, (long)snapshotter.prevCommittedOffset());
            this.generateManyRecords(listener, 3000L);
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            this.generateManyRecords(listener, 4000L);
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            snapshotter.activeSnapshotOffset_$eq(-1L);
            this.generateManyRecords(listener, 5000L);
            Assertions.assertEquals((long)5000L, (long)snapshotter.activeSnapshotOffset());
            Assertions.assertEquals(null, (Object)snapshotter.failure().get());
        }
    }

    @Test
    public void testNotSnapshotAfterMetadataVersionChangeBeforePublishing() {
        BrokerMetadataListener brokerMetadataListener;
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        Some x$1 = new Some((Object)snapshotter);
        BrokerServerMetrics x$3 = this.newBrokerMetadataListener$default$1();
        FaultHandler x$4 = this.newBrokerMetadataListener$default$4();
        long newBrokerMetadataListener_maxBytesBetweenSnapshots = 1000L;
        BrokerMetadataListener brokerMetadataListener2 = brokerMetadataListener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, newBrokerMetadataListener_maxBytesBetweenSnapshots, (Option)x$1, x$3, x$4);
        brokerMetadataListener = null;
        BrokerMetadataListener listener = brokerMetadataListener2;
        this.updateFeature(listener, "metadata.version", MetadataVersion.latest().featureLevel(), 100L);
        listener.getImageRecords().get();
        Assertions.assertEquals((long)-1L, (long)snapshotter.activeSnapshotOffset(), (String)"We won't generate snapshot on metadata version change before starting publishing");
    }

    @Test
    public void testSnapshotAfterMetadataVersionChangeWhenStarting() {
        BrokerMetadataListener brokerMetadataListener;
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        Some x$1 = new Some((Object)snapshotter);
        BrokerServerMetrics x$3 = this.newBrokerMetadataListener$default$1();
        FaultHandler x$4 = this.newBrokerMetadataListener$default$4();
        long newBrokerMetadataListener_maxBytesBetweenSnapshots = 1000L;
        BrokerMetadataListener brokerMetadataListener2 = brokerMetadataListener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, newBrokerMetadataListener_maxBytesBetweenSnapshots, (Option)x$1, x$3, x$4);
        brokerMetadataListener = null;
        BrokerMetadataListener listener = brokerMetadataListener2;
        long endOffset = 100L;
        this.updateFeature(listener, "metadata.version", MetadataVersion.latest().featureLevel(), endOffset);
        listener.startPublishing((MetadataPublisher)new MockMetadataPublisher()).get();
        Assertions.assertEquals((long)endOffset, (long)snapshotter.activeSnapshotOffset(), (String)"We should try to generate snapshot when starting publishing");
    }

    @Test
    public void testSnapshotAfterMetadataVersionChange() {
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        Some x$1 = new Some((Object)snapshotter);
        BrokerServerMetrics x$3 = this.newBrokerMetadataListener$default$1();
        FaultHandler x$4 = this.newBrokerMetadataListener$default$4();
        long newBrokerMetadataListener_maxBytesBetweenSnapshots = 1000L;
        BrokerMetadataListener listener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, newBrokerMetadataListener_maxBytesBetweenSnapshots, (Option)x$1, x$3, x$4);
        listener.startPublishing((MetadataPublisher)new MockMetadataPublisher()).get();
        long endOffset = 100L;
        this.updateFeature(listener, "metadata.version", (short)(MetadataVersion.latest().featureLevel() - 1), endOffset);
        listener.getImageRecords().get();
        Assertions.assertEquals((long)endOffset, (long)snapshotter.activeSnapshotOffset(), (String)"We should generate snapshot on feature update");
    }

    @Test
    public void testNoSnapshotAfterError() {
        BrokerMetadataListener brokerMetadataListener;
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        MockFaultHandler faultHandler = new MockFaultHandler("metadata loading");
        Some x$1 = new Some((Object)snapshotter);
        BrokerServerMetrics x$4 = this.newBrokerMetadataListener$default$1();
        long newBrokerMetadataListener_maxBytesBetweenSnapshots = 1000L;
        BrokerMetadataListener brokerMetadataListener2 = brokerMetadataListener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, newBrokerMetadataListener_maxBytesBetweenSnapshots, (Option)x$1, x$4, (FaultHandler)faultHandler);
        brokerMetadataListener = null;
        try (BrokerMetadataListener listener = brokerMetadataListener2;){
            Range.Inclusive brokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3);
            this.registerBrokers(listener, (Iterable<Object>)brokerIds, 100L);
            this.createTopicWithOnePartition(listener, (scala.collection.immutable.Seq<Object>)brokerIds, 200L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)200L, (long)listener.highestMetadataOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.prevCommittedOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.activeSnapshotOffset());
            this.generateBadRecords(listener, 1000L);
            Assertions.assertEquals((long)-1L, (long)snapshotter.prevCommittedOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.activeSnapshotOffset());
            this.generateManyRecords(listener, 2000L);
            Assertions.assertEquals((long)-1L, (long)snapshotter.prevCommittedOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.activeSnapshotOffset());
        }
    }

    private void registerBrokers(BrokerMetadataListener listener, Iterable<Object> brokerIds, long endOffset) {
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, (long)0L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(brokerId).setBrokerEpoch(100L).setFenced(false).setRack(null).setIncarnationId(Uuid.fromString((String)new StringBuilder(21).append("GFBwlTcpQUuLYQ2ig05CS").append(brokerId).toString())), (short)0)))));
    }

    private void createTopicWithOnePartition(BrokerMetadataListener listener, scala.collection.immutable.Seq<Object> replicas, long endOffset) {
        listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, (long)0L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("foo").setTopicId(this.FOO_ID()), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> BrokerMetadataListenerTest.$anonfun$createTopicWithOnePartition$1(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setLeader(0).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> BrokerMetadataListenerTest.$anonfun$createTopicWithOnePartition$2(BoxesRunTime.unboxToInt((Object)x)))).asJava()), (short)0))));
    }

    private void updateFeature(BrokerMetadataListener listener, String feature, short version, long endOffset) {
        listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, (long)0L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName(feature).setFeatureLevel(version), (short)0))));
    }

    public static final /* synthetic */ Integer $anonfun$createTopicWithOnePartition$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$createTopicWithOnePartition$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public class MockMetadataPublisher
    implements MetadataPublisher {
        private MetadataImage image;

        public MetadataImage image() {
            return this.image;
        }

        public void image_$eq(MetadataImage x$1) {
            this.image = x$1;
        }

        public void publish(MetadataDelta delta, MetadataImage newImage) {
            this.image_$eq(newImage);
        }

        public long publishedOffset() {
            return -1L;
        }

        public /* synthetic */ BrokerMetadataListenerTest kafka$server$metadata$BrokerMetadataListenerTest$MockMetadataPublisher$$$outer() {
            return BrokerMetadataListenerTest.this;
        }

        public MockMetadataPublisher() {
            if (BrokerMetadataListenerTest.this == null) {
                throw null;
            }
            this.image = MetadataImage.EMPTY;
        }
    }

    public class MockMetadataSnapshotter
    implements MetadataSnapshotter {
        private MetadataImage image;
        private final AtomicReference<Throwable> failure;
        private long activeSnapshotOffset;
        private long prevCommittedOffset;
        private int prevCommittedEpoch;
        private long prevLastContainedLogTime;

        public MetadataImage image() {
            return this.image;
        }

        public void image_$eq(MetadataImage x$1) {
            this.image = x$1;
        }

        public AtomicReference<Throwable> failure() {
            return this.failure;
        }

        public long activeSnapshotOffset() {
            return this.activeSnapshotOffset;
        }

        public void activeSnapshotOffset_$eq(long x$1) {
            this.activeSnapshotOffset = x$1;
        }

        public long prevCommittedOffset() {
            return this.prevCommittedOffset;
        }

        public void prevCommittedOffset_$eq(long x$1) {
            this.prevCommittedOffset = x$1;
        }

        public int prevCommittedEpoch() {
            return this.prevCommittedEpoch;
        }

        public void prevCommittedEpoch_$eq(int x$1) {
            this.prevCommittedEpoch = x$1;
        }

        public long prevLastContainedLogTime() {
            return this.prevLastContainedLogTime;
        }

        public void prevLastContainedLogTime_$eq(long x$1) {
            this.prevLastContainedLogTime = x$1;
        }

        public boolean maybeStartSnapshot(long lastContainedLogTime, MetadataImage newImage) {
            boolean bl;
            try {
                if (this.activeSnapshotOffset() != -1L) {
                    return false;
                }
                Assertions.assertTrue((this.prevCommittedOffset() <= newImage.highestOffsetAndEpoch().offset ? 1 : 0) != 0);
                Assertions.assertTrue((this.prevCommittedEpoch() <= newImage.highestOffsetAndEpoch().epoch ? 1 : 0) != 0);
                Assertions.assertTrue((this.prevLastContainedLogTime() <= lastContainedLogTime ? 1 : 0) != 0);
                this.prevCommittedOffset_$eq(newImage.highestOffsetAndEpoch().offset);
                this.prevCommittedEpoch_$eq(newImage.highestOffsetAndEpoch().epoch);
                this.prevLastContainedLogTime_$eq(lastContainedLogTime);
                this.image_$eq(newImage);
                this.activeSnapshotOffset_$eq(newImage.highestOffsetAndEpoch().offset);
                bl = true;
            }
            catch (Throwable t) {
                bl = this.failure().compareAndSet(null, t);
            }
            return bl;
        }

        public /* synthetic */ BrokerMetadataListenerTest kafka$server$metadata$BrokerMetadataListenerTest$MockMetadataSnapshotter$$$outer() {
            return BrokerMetadataListenerTest.this;
        }

        public MockMetadataSnapshotter() {
            if (BrokerMetadataListenerTest.this == null) {
                throw null;
            }
            this.image = MetadataImage.EMPTY;
            this.failure = new AtomicReference<Object>(null);
            this.activeSnapshotOffset = -1L;
            this.prevCommittedOffset = -1L;
            this.prevCommittedEpoch = -1;
            this.prevLastContainedLogTime = -1L;
        }
    }
}

