/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.cluster.EndPoint;
import kafka.network.DataPlaneAcceptor$;
import kafka.network.SocketServer$;
import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicListenerConfig$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.authenticator.LoginManager;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0005\u0005-q!\u0002\b\u0010\u0011\u0003!b!\u0002\f\u0010\u0011\u00039\u0002\"\u0002\u0010\u0002\t\u0003y\u0002b\u0002\u0011\u0002\u0005\u0004%\t!\t\u0005\u0007a\u0005\u0001\u000b\u0011\u0002\u0012\u0007\tYy\u0001!\r\u0005\t!\u0015\u0011\t\u0011)A\u0005w!)a$\u0002C\u0001}!)\u0011)\u0002C!\u0005\")a*\u0002C\u0005\u001f\")Q.\u0002C\u0005]\")!/\u0002C\u0001g\")\u00110\u0002C\u0001u\")a0\u0002C\u0005\u007f\u0006)B)\u001f8b[&\u001cG*[:uK:,'oQ8oM&<'B\u0001\t\u0012\u0003\u0019\u0019XM\u001d<fe*\t!#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005U\tQ\"A\b\u0003+\u0011Kh.Y7jG2K7\u000f^3oKJ\u001cuN\u001c4jON\u0011\u0011\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0012!\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0002EA\u00191E\n\u0015\u000e\u0003\u0011R!!\n\u000e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002(I\t\u00191+\u001a;\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013\u0001\u00027b]\u001eT\u0011!L\u0001\u0005U\u00064\u0018-\u0003\u00020U\t11\u000b\u001e:j]\u001e\faCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000fI\n\u0005\u000ba\u0011T\u0007\u0005\u0002\u0016g%\u0011Ag\u0004\u0002\u0015\u0005J|7.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u0011\u0005YJT\"A\u001c\u000b\u0005a\n\u0012!B;uS2\u001c\u0018B\u0001\u001e8\u0005\u001daunZ4j]\u001e\u0004\"!\u0006\u001f\n\u0005uz!aC&bM.\f'I]8lKJ$\"a\u0010!\u0011\u0005U)\u0001\"\u0002\t\b\u0001\u0004Y\u0014!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0002\u0007B\u00191E\n#\u0011\u0005\u0015ceB\u0001$K!\t9%$D\u0001I\u0015\tI5#\u0001\u0004=e>|GOP\u0005\u0003\u0017j\ta\u0001\u0015:fI\u00164\u0017BA\u0018N\u0015\tY%$\u0001\u000fmSN$XM\\3s%\u0016<\u0017n\u001d;sCRLwN\\:BYR,'/\u001a3\u0015\u0007A\u001b6\u000e\u0005\u0002\u001a#&\u0011!K\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015!\u0016\u00021\u0001V\u0003YyG\u000eZ!em\u0016\u0014H/[:fI2K7\u000f^3oKJ\u001c\b\u0003B\u0012W1\u0016L!a\u0016\u0013\u0003\u00075\u000b\u0007\u000f\u0005\u0002ZG6\t!L\u0003\u0002\\9\u00069a.\u001a;x_J\\'BA/_\u0003\u0019\u0019w.\\7p]*\u0011!c\u0018\u0006\u0003A\u0006\fa!\u00199bG\",'\"\u00012\u0002\u0007=\u0014x-\u0003\u0002e5\naA*[:uK:,'OT1nKB\u0011a-[\u0007\u0002O*\u0011\u0001.E\u0001\bG2,8\u000f^3s\u0013\tQwM\u0001\u0005F]\u0012\u0004v.\u001b8u\u0011\u0015a\u0017\u00021\u0001V\u0003YqWm^!em\u0016\u0014H/[:fI2K7\u000f^3oKJ\u001c\u0018!\f<fe&4\u0017\u0010T5ti\u0016tWM\u001d*fO&\u001cHO]1uS>t\u0017\t\u001c;fe\u0006$\u0018n\u001c8TkB\u0004xN\u001d;fIR\tq\u000e\u0005\u0002\u001aa&\u0011\u0011O\u0007\u0002\u0005+:LG/A\fwC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R\u0011q\u000e\u001e\u0005\u0006k.\u0001\rA^\u0001\n]\u0016<8i\u001c8gS\u001e\u0004\"!F<\n\u0005a|!aC&bM.\f7i\u001c8gS\u001e\f1B]3d_:4\u0017nZ;sKR\u0019qn_?\t\u000bqd\u0001\u0019\u0001<\u0002\u0013=dGmQ8oM&<\u0007\"B;\r\u0001\u00041\u0018A\u00047jgR,g.\u001a:t)>l\u0015\r\u001d\u000b\u0004+\u0006\u0005\u0001bBA\u0002\u001b\u0001\u0007\u0011QA\u0001\nY&\u001cH/\u001a8feN\u0004BaIA\u0004K&\u0019\u0011\u0011\u0002\u0013\u0003\u0007M+\u0017\u000f")
public class DynamicListenerConfig
implements BrokerReconfigurable,
Logging {
    private final KafkaBroker server;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Set<String> ReconfigurableConfigs() {
        return DynamicListenerConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return DynamicListenerConfig$.MODULE$.ReconfigurableConfigs();
    }

    private boolean listenerRegistrationsAltered(Map<ListenerName, EndPoint> oldAdvertisedListeners, Map<ListenerName, EndPoint> newAdvertisedListeners) {
        Object object = new Object();
        try {
            if (oldAdvertisedListeners.size() != newAdvertisedListeners.size()) {
                return true;
            }
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(x0$1, x1$1) -> {
                DynamicListenerConfig.$anonfun$listenerRegistrationsAltered$1(newAdvertisedListeners, object, x0$1, x1$1);
                return BoxedUnit.UNIT;
            };
            oldAdvertisedListeners.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
            return false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private void verifyListenerRegistrationAlterationSupported() {
        if (!this.server.config().requiresZookeeper()) {
            throw new ConfigException("Advertised listeners cannot be altered when using a Raft-based metadata quorum.");
        }
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        KafkaConfig oldConfig = this.server.config();
        Map<ListenerName, EndPoint> newListeners = this.listenersToMap(newConfig.listeners());
        Map<ListenerName, EndPoint> newAdvertisedListeners = this.listenersToMap(newConfig.effectiveAdvertisedListeners());
        Map<ListenerName, EndPoint> oldListeners = this.listenersToMap(oldConfig.listeners());
        if (!newAdvertisedListeners.keySet().subsetOf(newListeners.keySet())) {
            throw new ConfigException(new StringBuilder(56).append("Advertised listeners '").append(newAdvertisedListeners).append("' must be a subset of listeners '").append(newListeners).append("'").toString());
        }
        if (!newListeners.keySet().subsetOf(newConfig.effectiveListenerSecurityProtocolMap().keySet())) {
            throw new ConfigException(new StringBuilder(46).append("Listeners '").append(newListeners).append("' must be subset of listener map '").append(newConfig.effectiveListenerSecurityProtocolMap()).append("'").toString());
        }
        newListeners.keySet().intersect(oldListeners.keySet()).foreach((Function1 & Serializable)listenerName -> {
            DynamicListenerConfig.$anonfun$validateReconfiguration$5(newConfig, oldConfig, listenerName);
            return BoxedUnit.UNIT;
        });
        if (!newAdvertisedListeners.contains((Object)newConfig.interBrokerListenerName())) {
            throw new ConfigException(new StringBuilder(64).append("Advertised listener must be specified for inter-broker listener ").append(newConfig.interBrokerListenerName()).toString());
        }
        if (this.listenerRegistrationsAltered(this.listenersToMap(oldConfig.effectiveAdvertisedListeners()), this.listenersToMap(newConfig.effectiveAdvertisedListeners()))) {
            this.verifyListenerRegistrationAlterationSupported();
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Seq<EndPoint> newListeners = newConfig.listeners();
        Map<ListenerName, EndPoint> newListenerMap = this.listenersToMap(newListeners);
        Seq<EndPoint> oldListeners = oldConfig.listeners();
        Map<ListenerName, EndPoint> oldListenerMap = this.listenersToMap(oldListeners);
        Seq listenersRemoved = (Seq)oldListeners.filterNot((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)newListenerMap.contains((Object)e.listenerName())));
        Seq listenersAdded = (Seq)newListeners.filterNot((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)oldListenerMap.contains((Object)e.listenerName())));
        if (listenersRemoved.nonEmpty() || listenersAdded.nonEmpty()) {
            LoginManager.closeAll();
            if (listenersRemoved.nonEmpty()) {
                this.server.socketServer().removeListeners((Seq<EndPoint>)listenersRemoved);
            }
            if (listenersAdded.nonEmpty()) {
                this.server.socketServer().addListeners((Seq<EndPoint>)listenersAdded);
            }
        }
        if (this.listenerRegistrationsAltered(this.listenersToMap(oldConfig.effectiveAdvertisedListeners()), this.listenersToMap(newConfig.effectiveAdvertisedListeners()))) {
            this.verifyListenerRegistrationAlterationSupported();
            KafkaBroker kafkaBroker = this.server;
            if (kafkaBroker instanceof KafkaServer) {
                KafkaServer kafkaServer = (KafkaServer)kafkaBroker;
                kafkaServer.kafkaController().updateBrokerInfo(kafkaServer.createBrokerInfo());
                return;
            }
            throw new RuntimeException("Unable to handle non-kafkaServer");
        }
    }

    private Map<ListenerName, EndPoint> listenersToMap(Seq<EndPoint> listeners) {
        return ((IterableOnceOps)listeners.map((Function1 & Serializable)e -> new Tuple2((Object)e.listenerName(), e))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ void $anonfun$listenerRegistrationsAltered$1(Map newAdvertisedListeners$1, Object nonLocalReturnKey1$1, ListenerName x0$1, EndPoint x1$1) {
        Option option = newAdvertisedListeners$1.get((Object)x0$1);
        if (None$.MODULE$.equals(option)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
        if (option instanceof Some) {
            if (!((EndPoint)((Some)option).value()).equals(x1$1)) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateReconfiguration$6(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String key = (String)x0$1._1();
        boolean bl = !DynamicBrokerConfig$.MODULE$.DynamicSecurityConfigs().contains((Object)key) && !SocketServer$.MODULE$.ListenerReconfigurableConfigs().contains((Object)key) && !DataPlaneAcceptor$.MODULE$.ListenerReconfigurableConfigs().contains((Object)key);
        return bl;
    }

    private static final Map immutableListenerConfigs$1(KafkaConfig kafkaConfig, String prefix) {
        return (Map)CollectionConverters$.MODULE$.MapHasAsScala(kafkaConfig.originalsWithPrefix(prefix, true)).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicListenerConfig.$anonfun$validateReconfiguration$6(x0$1)));
    }

    public static final /* synthetic */ void $anonfun$validateReconfiguration$5(KafkaConfig newConfig$4, KafkaConfig oldConfig$3, ListenerName listenerName) {
        Map map = DynamicListenerConfig.immutableListenerConfigs$1(newConfig$4, listenerName.configPrefix());
        Map map2 = DynamicListenerConfig.immutableListenerConfigs$1(oldConfig$3, listenerName.configPrefix());
        if (map == null ? map2 != null : !map.equals(map2)) {
            throw new ConfigException(new StringBuilder(50).append(new StringBuilder(62).append("Configs cannot be updated dynamically for existing listener ").append(listenerName).append(", ").toString()).append("restart broker or create a new listener for update").toString());
        }
        if (!BoxesRunTime.equals((Object)oldConfig$3.effectiveListenerSecurityProtocolMap().apply((Object)listenerName), (Object)newConfig$4.effectiveListenerSecurityProtocolMap().apply((Object)listenerName))) {
            throw new ConfigException(new StringBuilder(58).append("Security protocol cannot be updated for existing listener ").append(listenerName).toString());
        }
    }

    public DynamicListenerConfig(KafkaBroker server) {
        this.server = server;
    }
}

