/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.GroupAuthorizerIntegrationTest$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005]x!B\u0011#\u0011\u00039c!B\u0015#\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004bB\u001a\u0002\u0005\u0004%\t\u0001\u000e\u0005\u0007\t\u0006\u0001\u000b\u0011B\u001b\t\u000f\u0015\u000b!\u0019!C\u0001i!1a)\u0001Q\u0001\nUBqaR\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004R\u0003\u0001\u0006I!\u0013\u0005\b%\u0006\u0011\r\u0011\"\u0001I\u0011\u0019\u0019\u0016\u0001)A\u0005\u0013\"9A+\u0001b\u0001\n\u0003A\u0005BB+\u0002A\u0003%\u0011J\u0002\u0003W\u0003\u00019\u0006\"B\u0019\u000e\t\u0003q\u0006\"B1\u000e\t\u0003\u0012g\u0001B\u0015#\u0001!DQ!\r\t\u0005\u0002=Dq!\u001d\tC\u0002\u0013\u0005!\u000f\u0003\u0004w!\u0001\u0006Ia\u001d\u0005\u0006oB!\t\u0005\u001f\u0005\u0006yB!\t% \u0005\u0007\u0003\u0013\u0001B\u0011I?\t\r\u0005-\u0001\u0003\"\u00015\u0011\u0019\ti\u0001\u0005C\u0001i!9\u0011q\u0002\t\u0005B\u0005E\u0001bBA\u0016!\u0011\u0005\u0013Q\u0006\u0005\b\u0003s\u0001B\u0011BA\u001e\u0011\u001d\ty\u0004\u0005C!\u0003\u0003Bq!!\u0019\u0011\t\u0013\t\u0019\u0007C\u0005\u0002\nB\t\n\u0011\"\u0003\u0002\f\"9\u0011\u0011\u0015\t\u0005\u0002\u0005\r\u0006bBAv!\u0011\u0005\u0011Q^\u0001\u001f\u000fJ|W\u000f]!vi\"|'/\u001b>fe&sG/Z4sCRLwN\u001c+fgRT!a\t\u0013\u0002\u0007\u0005\u0004\u0018NC\u0001&\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001K\u0001\u000e\u0003\t\u0012ad\u0012:pkB\fU\u000f\u001e5pe&TXM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0014\u0005\u0005Y\u0003C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002O\u0005y!I]8lKJ\u0004&/\u001b8dSB\fG.F\u00016!\t1$)D\u00018\u0015\tA\u0014(\u0001\u0003bkRD'B\u0001\u001e<\u0003!\u0019XmY;sSRL(B\u0001\u001f>\u0003\u0019\u0019w.\\7p]*\u0011QE\u0010\u0006\u0003\u007f\u0001\u000ba!\u00199bG\",'\"A!\u0002\u0007=\u0014x-\u0003\u0002Do\tq1*\u00194lCB\u0013\u0018N\\2ja\u0006d\u0017\u0001\u0005\"s_.,'\u000f\u0015:j]\u000eL\u0007/\u00197!\u0003=\u0019E.[3oiB\u0013\u0018N\\2ja\u0006d\u0017\u0001E\"mS\u0016tG\u000f\u0015:j]\u000eL\u0007/\u00197!\u0003I\u0011%o\\6fe2K7\u000f^3oKJt\u0015-\\3\u0016\u0003%\u0003\"AS(\u000e\u0003-S!\u0001T'\u0002\t1\fgn\u001a\u0006\u0002\u001d\u0006!!.\u0019<b\u0013\t\u00016J\u0001\u0004TiJLgnZ\u0001\u0014\u0005J|7.\u001a:MSN$XM\\3s\u001d\u0006lW\rI\u0001\u0013\u00072LWM\u001c;MSN$XM\\3s\u001d\u0006lW-A\nDY&,g\u000e\u001e'jgR,g.\u001a:OC6,\u0007%\u0001\fD_:$(o\u001c7mKJd\u0015n\u001d;f]\u0016\u0014h*Y7f\u0003]\u0019uN\u001c;s_2dWM\u001d'jgR,g.\u001a:OC6,\u0007EA\u000bHe>,\b\u000f\u0015:j]\u000eL\u0007/\u00197Ck&dG-\u001a:\u0014\u00055A\u0006CA-]\u001b\u0005Q&BA.:\u00035\tW\u000f\u001e5f]RL7-\u0019;pe&\u0011QL\u0017\u0002\u001d\t\u00164\u0017-\u001e7u\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0005VLG\u000eZ3s)\u0005y\u0006C\u00011\u000e\u001b\u0005\t\u0011!\u00022vS2$GCA\u001bd\u0011\u0015!w\u00021\u0001f\u0003\u001d\u0019wN\u001c;fqR\u0004\"A\u000e4\n\u0005\u001d<$!F!vi\",g\u000e^5dCRLwN\\\"p]R,\u0007\u0010^\n\u0003!%\u0004\"A[7\u000e\u0003-T!\u0001\u001c\u0013\u0002\rM,'O^3s\u0013\tq7NA\bCCN,'+Z9vKN$H+Z:u)\u0005\u0001\bC\u0001\u0015\u0011\u0003!\u0011'o\\6fe&#W#A:\u0011\u0005)#\u0018BA;L\u0005\u001dIe\u000e^3hKJ\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002sB\u0011AF_\u0005\u0003w6\u00121!\u00138u\u0003]Ig\u000e^3s\u0005J|7.\u001a:MSN$XM\\3s\u001d\u0006lW-F\u0001\u007f!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001<\u0003\u001dqW\r^<pe.LA!a\u0002\u0002\u0002\taA*[:uK:,'OT1nK\u0006aA.[:uK:,'OT1nK\u0006y!M]8lKJ\u0004&/\u001b8dSB\fG.A\bdY&,g\u000e\u001e)sS:\u001c\u0017\u000e]1m\u0003YY'/\u00194u\u0007>tGO]8mY\u0016\u00148i\u001c8gS\u001e\u001cHCAA\n!\u0019\t)\"a\u0007\u0002 5\u0011\u0011q\u0003\u0006\u0004\u00033i\u0013AC2pY2,7\r^5p]&!\u0011QDA\f\u0005\r\u0019V-\u001d\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011QE'\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003S\t\u0019C\u0001\u0006Qe>\u0004XM\u001d;jKN\fqC\u0019:pW\u0016\u0014\bK]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\t\u0005=\u0012Q\u0007\t\u0004Y\u0005E\u0012bAA\u001a[\t!QK\\5u\u0011\u001d\t9D\u0007a\u0001\u0003?\t!\u0002\u001d:pa\u0016\u0014H/[3t\u0003E\tG\r\u001a(pI\u0016\u0004&o\u001c9feRLWm\u001d\u000b\u0005\u0003_\ti\u0004C\u0004\u00028m\u0001\r!a\b\u0002\u000bM,G/\u00169\u0015\t\u0005=\u00121\t\u0005\b\u0003\u000bb\u0002\u0019AA$\u0003!!Xm\u001d;J]\u001a|\u0007\u0003BA%\u0003+j!!a\u0013\u000b\u0007\r\niE\u0003\u0003\u0002P\u0005E\u0013a\u00026va&$XM\u001d\u0006\u0004\u0003'\u0002\u0015!\u00026v]&$\u0018\u0002BA,\u0003\u0017\u0012\u0001\u0002V3ti&sgm\u001c\u0015\u00049\u0005m\u0003\u0003BA%\u0003;JA!a\u0018\u0002L\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0013\r\u0014X-\u0019;f\u0003\u000edG\u0003CA3\u0003c\nY(!\"\u0011\t\u0005\u001d\u0014QN\u0007\u0003\u0003SR1!a\u001b<\u0003\r\t7\r\\\u0005\u0005\u0003_\nIG\u0001\nBG\u000e,7o]\"p]R\u0014x\u000e\\#oiJL\bbBA:;\u0001\u0007\u0011QO\u0001\rC\u000edw\n]3sCRLwN\u001c\t\u0005\u0003O\n9(\u0003\u0003\u0002z\u0005%$\u0001D!dY>\u0003XM]1uS>t\u0007bBA?;\u0001\u0007\u0011qP\u0001\u0012C\u000ed\u0007+\u001a:nSN\u001c\u0018n\u001c8UsB,\u0007\u0003BA4\u0003\u0003KA!a!\u0002j\t\t\u0012i\u00197QKJl\u0017n]:j_:$\u0016\u0010]3\t\u0011\u0005\u001dU\u0004%AA\u0002U\n\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0002'\r\u0014X-\u0019;f\u0003\u000edG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u00055%fA\u001b\u0002\u0010.\u0012\u0011\u0011\u0013\t\u0005\u0003'\u000bi*\u0004\u0002\u0002\u0016*!\u0011qSAM\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001c6\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty*!&\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0011uKN$XK\\1vi\"|'/\u001b>fIB\u0013x\u000eZ;dK\u0006sGmQ8ogVlW\r\u0006\u0003\u00020\u0005\u0015\u0006bBAT?\u0001\u0007\u0011\u0011V\u0001\u0007cV|'/^7\u0011\t\u0005-\u0016\u0011\u0018\b\u0005\u0003[\u000b)\fE\u0002\u000206j!!!-\u000b\u0007\u0005Mf%\u0001\u0004=e>|GOP\u0005\u0004\u0003ok\u0013A\u0002)sK\u0012,g-C\u0002Q\u0003wS1!a..Q\u001dy\u0012qXAh\u0003#\u0004B!!1\u0002L6\u0011\u00111\u0019\u0006\u0005\u0003\u000b\f9-\u0001\u0005qe>4\u0018\u000eZ3s\u0015\u0011\tI-!\u0014\u0002\rA\f'/Y7t\u0013\u0011\ti-a1\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011\t\u0019.a6\"\u0005\u0005U\u0017A\u0001>lC\t\tI.A\u0003le\u00064G\u000fK\u0004 \u0003;\f)/a:\u0011\t\u0005}\u0017\u0011]\u0007\u0003\u0003\u000fLA!a9\u0002H\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0003\u0003S\f\u0001d\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~\u0003}!Xm\u001d;BkRDwN]5{K\u0012\u0004&o\u001c3vG\u0016\fe\u000eZ\"p]N,X.\u001a\u000b\u0005\u0003_\ty\u000fC\u0004\u0002(\u0002\u0002\r!!+)\u000f\u0001\ny,a4\u0002t2\"\u00111[AlQ\u001d\u0001\u0013Q\\As\u0003O\u0004")
public class GroupAuthorizerIntegrationTest
extends BaseRequestTest {
    private final Integer brokerId = Predef$.MODULE$.int2Integer(0);

    public static String ControllerListenerName() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ControllerListenerName();
    }

    public static String ClientListenerName() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientListenerName();
    }

    public static String BrokerListenerName() {
        return GroupAuthorizerIntegrationTest$.MODULE$.BrokerListenerName();
    }

    public static KafkaPrincipal ClientPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
    }

    public static KafkaPrincipal BrokerPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal();
    }

    public Integer brokerId() {
        return this.brokerId;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public ListenerName interBrokerListenerName() {
        return new ListenerName(GroupAuthorizerIntegrationTest$.MODULE$.BrokerListenerName());
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName(GroupAuthorizerIntegrationTest$.MODULE$.ClientListenerName());
    }

    public KafkaPrincipal brokerPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal();
    }

    public KafkaPrincipal clientPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
    }

    @Override
    public Seq<Properties> kraftControllerConfigs() {
        Seq<Properties> controllerConfigs = super.kraftControllerConfigs();
        controllerConfigs.foreach((Function1 & Serializable)properties -> {
            this.addNodeProperties(properties);
            return BoxedUnit.UNIT;
        });
        return controllerConfigs;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.BrokerIdProp(), this.brokerId().toString());
        this.addNodeProperties(properties);
    }

    private void addNodeProperties(Properties properties) {
        if (this.isKRaftTest()) {
            properties.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), StandardAuthorizer.class.getName());
            properties.put("super.users", GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal().toString());
        } else {
            properties.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), AclAuthorizer.class.getName());
        }
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        properties.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), "1");
        properties.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), "1");
        properties.put("principal.builder.class", GroupPrincipalBuilder.class.getName());
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, false);
        this.addAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.CLUSTER_ACTION, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal())}))), new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL));
        this.createOffsetsTopic(this.interBrokerListenerName(), this.createOffsetsTopic$default$2());
    }

    private AccessControlEntry createAcl(AclOperation aclOperation, AclPermissionType aclPermissionType, KafkaPrincipal principal) {
        return new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), aclOperation, aclPermissionType);
    }

    private KafkaPrincipal createAcl$default$3() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUnauthorizedProduceAndConsume(String quorum) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        ListenerName x$2 = this.interBrokerListenerName();
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        Properties x$5 = this.createTopic$default$4();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(topic, x$3, x$4, x$5, x$2, x$6);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Throwable produceException = Assertions.assertThrows(ExecutionException.class, () -> producer.send(new ProducerRecord(topic, (Object)"message".getBytes())).get()).getCause();
        Assertions.assertTrue((boolean)(produceException instanceof TopicAuthorizationException));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(((TopicAuthorizationException)produceException).unauthorizedTopics()).asScala());
        .colon.colon x$7 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$8 = this.createConsumer$default$1();
        ByteArrayDeserializer x$9 = this.createConsumer$default$2();
        Properties x$10 = this.createConsumer$default$3();
        KafkaConsumer consumer = this.createConsumer(x$8, x$9, x$10, (List<String>)x$7);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$)).asJava());
        TopicAuthorizationException consumeException = (TopicAuthorizationException)Assertions.assertThrows(TopicAuthorizationException.class, () -> TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(consumeException.unauthorizedTopics()).asScala());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAuthorizedProduceAndConsume(String quorum) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        ListenerName x$2 = this.interBrokerListenerName();
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        Properties x$5 = this.createTopic$default$4();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(topic, x$3, x$4, x$5, x$2, x$6);
        this.addAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.WRITE, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal())}))), new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL));
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(new ProducerRecord(topic, (Object)"message".getBytes())).get();
        this.addAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.READ, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal())}))), new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL));
        .colon.colon x$7 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$8 = this.createConsumer$default$1();
        ByteArrayDeserializer x$9 = this.createConsumer$default$2();
        Properties x$10 = this.createConsumer$default$3();
        KafkaConsumer consumer = this.createConsumer(x$8, x$9, x$10, (List<String>)x$7);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$)).asJava());
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L);
    }

    public static class GroupPrincipalBuilder
    extends DefaultKafkaPrincipalBuilder {
        public KafkaPrincipal build(AuthenticationContext context) {
            boolean bl;
            String string = context.listenerName();
            String string2 = GroupAuthorizerIntegrationTest$.MODULE$.BrokerListenerName();
            if (!(string2 != null ? !string2.equals(string) : string != null)) {
                bl = true;
            } else {
                String string3 = GroupAuthorizerIntegrationTest$.MODULE$.ControllerListenerName();
                bl = !(string3 != null ? !string3.equals(string) : string != null);
            }
            if (bl) {
                return GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal();
            }
            String string4 = GroupAuthorizerIntegrationTest$.MODULE$.ClientListenerName();
            if (!(string4 != null ? !string4.equals(string) : string != null)) {
                return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
            }
            throw new IllegalArgumentException(new StringBuilder(32).append("No principal mapped to listener ").append(string).toString());
        }

        public GroupPrincipalBuilder() {
            super(null, null);
        }
    }
}

