/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.Serializable;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.Defaults$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.network.ListenerName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001B\b\u0011\u0001UAQ\u0001\b\u0001\u0005\u0002uAQ\u0001\t\u0001\u0005B\u0005Bq\u0001\u000b\u0001C\u0002\u0013\u0005\u0011\u0006\u0003\u00043\u0001\u0001\u0006IA\u000b\u0005\bg\u0001\u0011\r\u0011\"\u0001*\u0011\u0019!\u0004\u0001)A\u0005U!)Q\u0007\u0001C!m!)!\t\u0001C!\u0007\")a\u000b\u0001C\u0001/\")A\r\u0001C\u0001K\")!\u000e\u0001C\u0005W\")1\u000f\u0001C\u0005i\"9\u0011\u0011\u0001\u0001\u0005\n\u0005\r\u0001\"CA\f\u0001E\u0005I\u0011BA\r\u0005q!\u0015P\\1nS\u000etU/\u001c(fi^|'o\u001b+ie\u0016\fGm\u001d+fgRT!!\u0005\n\u0002\u000f9,Go^8sW*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"BA\r\u0013\u0003\u0019\u0019XM\u001d<fe&\u00111\u0004\u0007\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012A\b\t\u0003?\u0001i\u0011\u0001E\u0001\fEJ|7.\u001a:D_VtG/F\u0001#!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\rIe\u000e^\u0001\tS:$XM\u001d8bYV\t!\u0006\u0005\u0002,a5\tAF\u0003\u0002.]\u0005!A.\u00198h\u0015\u0005y\u0013\u0001\u00026bm\u0006L!!\r\u0017\u0003\rM#(/\u001b8h\u0003%Ig\u000e^3s]\u0006d\u0007%\u0001\u0005fqR,'O\\1m\u0003%)\u0007\u0010^3s]\u0006d\u0007%A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011qG\u000f\t\u0003GaJ!!\u000f\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006w\u001d\u0001\r\u0001P\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bCA\u001fA\u001b\u0005q$BA /\u0003\u0011)H/\u001b7\n\u0005\u0005s$A\u0003)s_B,'\u000f^5fg\u0006)1/\u001a;VaR\u0011q\u0007\u0012\u0005\u0006\u000b\"\u0001\rAR\u0001\ti\u0016\u001cH/\u00138g_B\u0011q\tU\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0004CBL'BA&M\u0003\u001dQW\u000f]5uKJT!!\u0014(\u0002\u000b),h.\u001b;\u000b\u0003=\u000b1a\u001c:h\u0013\t\t\u0006J\u0001\u0005UKN$\u0018J\u001c4pQ\tA1\u000b\u0005\u0002H)&\u0011Q\u000b\u0013\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001F4fi:+XNT3uo>\u00148\u000e\u00165sK\u0006$7\u000f\u0006\u0002#1\")\u0011,\u0003a\u00015\u0006AA.[:uK:,'\u000f\u0005\u0002\\E:\u0011A\f\u0019\t\u0003;\u0012j\u0011A\u0018\u0006\u0003?R\ta\u0001\u0010:p_Rt\u0014BA1%\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011g\u0019\u0006\u0003C\u0012\nA\u0004^3ti\u0012Kh.Y7jG:+XNT3uo>\u00148\u000e\u00165sK\u0006$7\u000fF\u00018Q\tQq\r\u0005\u0002HQ&\u0011\u0011\u000e\u0013\u0002\u0005)\u0016\u001cH/\u0001\nsK\u000e|gNZ5hkJ,7+\u001a:wKJ\u001cHcA\u001cm]\")Qn\u0003a\u0001y\u0005Aa.Z<Qe>\u00048\u000fC\u0003p\u0017\u0001\u0007\u0001/A\u0007b!J|\u0007\u000fV8WKJLg-\u001f\t\u0005GET&,\u0003\u0002sI\t1A+\u001e9mKJ\n\u0011c\u0019:fCR,\u0017\tZ7j]\u000ec\u0017.\u001a8u)\u0005)\bC\u0001<\u007f\u001b\u00059(B\u0001=z\u0003\u0015\tG-\\5o\u0015\tQ80A\u0004dY&,g\u000e^:\u000b\u0005Ma(BA?O\u0003\u0019\t\u0007/Y2iK&\u0011qp\u001e\u0002\u0006\u0003\u0012l\u0017N\\\u0001\u0016o\u0006LGOR8s\u0007>tg-[4P]N+'O^3s)\u001d9\u0014QAA\u0005\u0003\u001bAa!a\u0002\u000e\u0001\u0004Q\u0016\u0001\u00039s_Bt\u0015-\\3\t\r\u0005-Q\u00021\u0001[\u0003%\u0001(o\u001c9WC2,X\rC\u0005\u0002\u00105\u0001\n\u00111\u0001\u0002\u0012\u0005IQ.\u0019=XC&$Xj\u001d\t\u0004G\u0005M\u0011bAA\u000bI\t!Aj\u001c8h\u0003}9\u0018-\u001b;G_J\u001cuN\u001c4jO>s7+\u001a:wKJ$C-\u001a4bk2$HeM\u000b\u0003\u00037QC!!\u0005\u0002\u001e-\u0012\u0011q\u0004\t\u0005\u0003C\tY#\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003%)hn\u00195fG.,GMC\u0002\u0002*\u0011\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti#a\t\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class DynamicNumNetworkThreadsTest
extends BaseRequestTest {
    private final String internal;
    private final String external;

    @Override
    public int brokerCount() {
        return 1;
    }

    public String internal() {
        return this.internal;
    }

    public String external() {
        return this.external;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(30).append(this.internal()).append("://localhost:0, ").append(this.external()).append("://localhost:0").toString());
        properties.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(22).append(this.internal()).append(":PLAINTEXT, ").append(this.external()).append(":PLAINTEXT").toString());
        properties.put(new StringBuilder(15).append("listener.name.").append(this.internal().toLowerCase()).append(".").append(KafkaConfig$.MODULE$.NumNetworkThreadsProp()).toString(), "2");
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        TestUtils$.MODULE$.createTopic(this.zkClient(), "test", this.brokerCount(), this.brokerCount(), (Seq<KafkaBroker>)this.servers(), new Properties());
        Assertions.assertEquals((int)2, (int)this.getNumNetworkThreads(this.internal()));
        Assertions.assertEquals((int)Defaults$.MODULE$.NumNetworkThreads(), (int)this.getNumNetworkThreads(this.external()));
    }

    public int getNumNetworkThreads(String listener) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(((KafkaBroker)this.brokers().head()).metrics().metrics().keySet()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicNumNetworkThreadsTest.$anonfun$getNumNetworkThreads$1(x$1)))).count((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicNumNetworkThreadsTest.$anonfun$getNumNetworkThreads$2(listener, x$2)));
    }

    @Test
    public void testDynamicNumNetworkThreads() {
        int newBaseNetworkThreadsCount = Defaults$.MODULE$.NumNetworkThreads() + 1;
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.NumNetworkThreadsProp(), Integer.toString(newBaseNetworkThreadsCount));
        this.reconfigureServers(props, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.NumNetworkThreadsProp(), (Object)Integer.toString(newBaseNetworkThreadsCount)));
        Assertions.assertEquals((int)2, (int)this.getNumNetworkThreads(this.internal()));
        Assertions.assertEquals((int)newBaseNetworkThreadsCount, (int)this.getNumNetworkThreads(this.external()));
        int newInternalNetworkThreadsCount = 3;
        props = new Properties();
        props.put(new StringBuilder(15).append("listener.name.").append(this.internal().toLowerCase()).append(".").append(KafkaConfig$.MODULE$.NumNetworkThreadsProp()).toString(), Integer.toString(newInternalNetworkThreadsCount));
        this.reconfigureServers(props, (Tuple2<String, String>)new Tuple2((Object)new StringBuilder(15).append("listener.name.").append(this.internal().toLowerCase()).append(".").append(KafkaConfig$.MODULE$.NumNetworkThreadsProp()).toString(), (Object)Integer.toString(newInternalNetworkThreadsCount)));
        Assertions.assertEquals((int)newInternalNetworkThreadsCount, (int)this.getNumNetworkThreads(this.internal()));
        Assertions.assertEquals((int)newBaseNetworkThreadsCount, (int)this.getNumNetworkThreads(this.external()));
    }

    private void reconfigureServers(Properties newProps, Tuple2<String, String> aPropToVerify) {
        Admin adminClient = this.createAdminClient();
        TestUtils$.MODULE$.incrementalAlterConfigs(this.servers(), adminClient, newProps, false, AlterConfigOp.OpType.SET).all().get();
        this.waitForConfigOnServer((String)aPropToVerify._1(), (String)aPropToVerify._2(), 10000L);
        adminClient.close();
    }

    private Admin createAdminClient() {
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers(this.servers(), new ListenerName(this.securityProtocol().name));
        Properties config = new Properties();
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return Admin.create((Properties)config);
    }

    private void waitForConfigOnServer(String propName, String propValue, long maxWaitMs) {
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicNumNetworkThreadsTest.$anonfun$waitForConfigOnServer$1(this, propValue, propName);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var9_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    private long waitForConfigOnServer$default$3() {
        return 10000L;
    }

    public static final /* synthetic */ boolean $anonfun$getNumNetworkThreads$1(MetricName x$1) {
        String string = x$1.name();
        String string2 = "request-rate";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$getNumNetworkThreads$2(String listener$1, MetricName x$2) {
        String string = listener$1;
        Object v = x$2.tags().get("listener");
        return !(string != null ? !string.equals(v) : v != null);
    }

    public static final /* synthetic */ void $anonfun$waitForConfigOnServer$1(DynamicNumNetworkThreadsTest $this, String propValue$1, String propName$1) {
        Assertions.assertEquals((Object)propValue$1, ((KafkaServer)$this.servers().head()).config().originals().get(propName$1));
    }

    public DynamicNumNetworkThreadsTest() {
        this.internal = "PLAINTEXT";
        this.external = "EXTERNAL";
    }
}

