/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.DescribeCredentialsTest;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.$less$colon$less$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u001d4AAC\u0006\u0001!!)Q\u0003\u0001C\u0001-!)\u0001\u0004\u0001C!3!)!\u0006\u0001C\u0001W!)\u0011\b\u0001C\u0001W!)1\b\u0001C\u0001W!)Q\b\u0001C\u0001W!)q\b\u0001C\u0001W!)\u0011\t\u0001C\u0005\u0005\"91\fAI\u0001\n\u0013a&a\n#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e+fgRT!\u0001D\u0007\u0002\rM,'O^3s\u0015\u0005q\u0011!B6bM.\f7\u0001A\n\u0003\u0001E\u0001\"AE\n\u000e\u0003-I!\u0001F\u0006\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#A\f\u0011\u0005I\u0001\u0011a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\tQ\u0002\u0005\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0003V]&$\b\"B\u0011\u0003\u0001\u0004\u0011\u0013A\u00039s_B,'\u000f^5fgB\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0005kRLGNC\u0001(\u0003\u0011Q\u0017M^1\n\u0005%\"#A\u0003)s_B,'\u000f^5fg\u0006\u0019B/Z:u\t\u0016\u001c8M]5cK:{G\u000f[5oOR\t!\u0004\u000b\u0002\u0004[A\u0011afN\u0007\u0002_)\u0011\u0001'M\u0001\u0004CBL'B\u0001\u001a4\u0003\u001dQW\u000f]5uKJT!\u0001N\u001b\u0002\u000b),h.\u001b;\u000b\u0003Y\n1a\u001c:h\u0013\tAtF\u0001\u0003UKN$\u0018\u0001\u0006;fgR$Um]2sS\n,w+\u001b;i\u001dVdG\u000e\u000b\u0002\u0005[\u0005IB/Z:u\t\u0016\u001c8M]5cK:{GoQ8oiJ|G\u000e\\3sQ\t)Q&A\ruKN$H)Z:de&\u0014WmU1nKV\u001bXM\u001d+xS\u000e,\u0007F\u0001\u0004.\u0003=!Xm\u001d;V].twn\u001e8Vg\u0016\u0014\bFA\u0004.\u0003\u001d\u001aXM\u001c3EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;\u0015\u0007\rs5\u000b\u0005\u0002E\u00196\tQI\u0003\u0002G\u000f\u0006A!/Z9vKN$8O\u0003\u0002I\u0013\u000611m\\7n_:T!A\u0004&\u000b\u0005-+\u0014AB1qC\u000eDW-\u0003\u0002N\u000b\n!C)Z:de&\u0014W-V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z:q_:\u001cX\rC\u0003P\u0011\u0001\u0007\u0001+A\u0004sKF,Xm\u001d;\u0011\u0005\u0011\u000b\u0016B\u0001*F\u0005\r\"Um]2sS\n,Wk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014V-];fgRDq\u0001\u0016\u0005\u0011\u0002\u0003\u0007Q+\u0001\u0007t_\u000e\\W\r^*feZ,'\u000f\u0005\u0002W36\tqK\u0003\u0002Y\u001b\u00059a.\u001a;x_J\\\u0017B\u0001.X\u00051\u0019vnY6fiN+'O^3s\u0003E\u001aXM\u001c3EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;%I\u00164\u0017-\u001e7uII*\u0012!\u0018\u0016\u0003+z[\u0013a\u0018\t\u0003A\u0016l\u0011!\u0019\u0006\u0003E\u000e\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\u0011d\u0012AC1o]>$\u0018\r^5p]&\u0011a-\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class DescribeUserScramCredentialsRequestTest
extends BaseRequestTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        properties.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), DescribeCredentialsTest.TestAuthorizer.class.getName());
        properties.put(KafkaConfig$.MODULE$.PrincipalBuilderClassProp(), DescribeCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
    }

    @Test
    public void testDescribeNothing() {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.controllerSocketServer());
        short error = response.data().errorCode();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)error, (String)"Expected no error when describing everything and there are no credentials");
        Assertions.assertEquals((int)0, (int)response.data().results().size(), (String)"Expected no credentials when describing everything and there are no credentials");
    }

    @Test
    public void testDescribeWithNull() {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(null)).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.controllerSocketServer());
        short error = response.data().errorCode();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)error, (String)"Expected no error when describing everything and there are no credentials");
        Assertions.assertEquals((int)0, (int)response.data().results().size(), (String)"Expected no credentials when describing everything and there are no credentials");
    }

    @Test
    public void testDescribeNotController() {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build();
        short error = this.sendDescribeUserScramCredentialsRequest(request, this.notControllerSocketServer()).data().errorCode();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)error, (String)"Did not expect controller error when routed to non-controller");
    }

    @Test
    public void testDescribeSameUserTwice() {
        String user = "user1";
        DescribeUserScramCredentialsRequestData.UserName userName = new DescribeUserScramCredentialsRequestData.UserName().setName(user);
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)userName, (List)new .colon.colon((Object)userName, (List)Nil$.MODULE$))).asJava())).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.controllerSocketServer());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode(), (String)"Expected no top-level error");
        Assertions.assertEquals((int)1, (int)response.data().results().size());
        DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result = (DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult)response.data().results().get(0);
        Assertions.assertEquals((short)Errors.DUPLICATE_RESOURCE.code(), (short)result.errorCode(), (String)new StringBuilder(38).append("Expected duplicate resource error for ").append(user).toString());
        Assertions.assertEquals((Object)new StringBuilder(79).append("Cannot describe SCRAM credentials for the same user twice in a single request: ").append(user).toString(), (Object)result.errorMessage());
    }

    @Test
    public void testUnknownUser() {
        String unknownUser = "unknownUser";
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new DescribeUserScramCredentialsRequestData.UserName().setName(unknownUser), (List)Nil$.MODULE$)).asJava())).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.controllerSocketServer());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode(), (String)"Expected no top-level error");
        Assertions.assertEquals((int)1, (int)response.data().results().size());
        DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result = (DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult)response.data().results().get(0);
        Assertions.assertEquals((short)Errors.RESOURCE_NOT_FOUND.code(), (short)result.errorCode(), (String)new StringBuilder(38).append("Expected duplicate resource error for ").append(unknownUser).toString());
        Assertions.assertEquals((Object)new StringBuilder(59).append("Attempt to describe a user credential that does not exist: ").append(unknownUser).toString(), (Object)result.errorMessage());
    }

    private DescribeUserScramCredentialsResponse sendDescribeUserScramCredentialsRequest(DescribeUserScramCredentialsRequest request, SocketServer socketServer) {
        return (DescribeUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeUserScramCredentialsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private SocketServer sendDescribeUserScramCredentialsRequest$default$2() {
        return this.controllerSocketServer();
    }
}

