/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.server.ConfigType$;
import kafka.server.ControllerServer;
import kafka.server.KafkaConfig$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.ZkClusterInvocationContext;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import kafka.zk.ZkMigrationClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005\u0005=h\u0001\u0002\f\u0018\u0001qAQa\t\u0001\u0005\u0002\u0011Bqa\n\u0001C\u0002\u0013\u0005\u0001\u0006\u0003\u00042\u0001\u0001\u0006I!\u000b\u0004\u0005e\u0001\u00011\u0007C\u0003$\t\u0011\u0005A\u0007C\u00048\t\t\u0007I\u0011\u0001\u001d\t\r\t#\u0001\u0015!\u0003:\u0011\u001d\u0019E\u00011A\u0005\u0002\u0011Cq\u0001\u0013\u0003A\u0002\u0013\u0005\u0011\n\u0003\u0004P\t\u0001\u0006K!\u0012\u0005\u0006!\u0012!\t!\u0015\u0005\u0006I\u0012!\t!\u001a\u0005\u0006]\u0002!\ta\u001c\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\t9\u0006\u0001C\u0001\u00033Bq!!\u001e\u0001\t\u0003\t9\bC\u0004\u0002\n\u0002!\t!a#\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002(\"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0006bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003{\u0003A\u0011AA`\u0005iQ6.T5he\u0006$\u0018n\u001c8J]R,wM]1uS>tG+Z:u\u0015\tA\u0012$\u0001\u0002{W*\t!$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002KA\u0011a\u0005A\u0007\u0002/\u0005\u0019An\\4\u0016\u0003%\u0002\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u000bMdg\r\u000e6\u000b\u00039\n1a\u001c:h\u0013\t\u00014F\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007EA\u000bNKR\fG-\u0019;b\t\u0016dG/\u0019,fe&4\u0017.\u001a:\u0014\u0005\u0011iB#A\u001b\u0011\u0005Y\"Q\"\u0001\u0001\u0002\u001b5,G/\u00193bi\u0006$U\r\u001c;b+\u0005I\u0004C\u0001\u001eA\u001b\u0005Y$B\u0001\u001f>\u0003\u0015IW.Y4f\u0015\tQbH\u0003\u0002@[\u00051\u0011\r]1dQ\u0016L!!Q\u001e\u0003\u001b5+G/\u00193bi\u0006$U\r\u001c;b\u00039iW\r^1eCR\fG)\u001a7uC\u0002\naa\u001c4gg\u0016$X#A#\u0011\u0005y1\u0015BA$ \u0005\rIe\u000e^\u0001\u000b_\u001a47/\u001a;`I\u0015\fHC\u0001&N!\tq2*\u0003\u0002M?\t!QK\\5u\u0011\u001dq\u0015\"!AA\u0002\u0015\u000b1\u0001\u001f\u00132\u0003\u001dygMZ:fi\u0002\na!Y2dKB$HC\u0001&S\u0011\u0015\u00196\u00021\u0001U\u0003\u0015\u0011\u0017\r^2i!\r)&\fX\u0007\u0002-*\u0011q\u000bW\u0001\u0005kRLGNC\u0001Z\u0003\u0011Q\u0017M^1\n\u0005m3&\u0001\u0002'jgR\u0004\"!\u00182\u000e\u0003yS!a\u00181\u0002\r\r|W.\\8o\u0015\t\tW(\u0001\u0004tKJ4XM]\u0005\u0003Gz\u0013A#\u00119j\u001b\u0016\u001c8/Y4f\u0003:$g+\u001a:tS>t\u0017A\u0002<fe&4\u0017\u0010\u0006\u0002KM\")q\r\u0004a\u0001Q\u0006Aa/\u001a:jM&,'\u000f\u0005\u0003\u001fS.T\u0015B\u00016 \u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002;Y&\u0011Qn\u000f\u0002\u000e\u001b\u0016$\u0018\rZ1uC&k\u0017mZ3\u0002\u0017Q,7\u000f^'jOJ\fG/\u001a\u000b\u0003\u0015BDQ!]\u0007A\u0002I\fqb\u00197vgR,'/\u00138ti\u0006t7-\u001a\t\u0003gZl\u0011\u0001\u001e\u0006\u0003kf\tA\u0001^3ti&\u0011q\u000f\u001e\u0002\u0010\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK\"jQ\"_@\u0002\u0002\u0005\r\u0011QAA\b\u0003#\u0001\"A_?\u000e\u0003mT!\u0001 ;\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002\u007fw\nY1\t\\;ti\u0016\u0014H+Z:u\u0003\u001d\u0011'o\\6feNl\u0012aA\u0001\fG2,8\u000f^3s)f\u0004X\r\n\u0002\u0002\b%!\u0011\u0011BA\u0006\u0003\tQ6JC\u0002\u0002\u000em\fA\u0001V=qK\u0006yQ.\u001a;bI\u0006$\u0018MV3sg&|g\u000e\n\u0002\u0002\u0014%!\u0011QCA\f\u0003-I%\tU04?Rz\u0016J\u0016\u0019\u000b\u0007\u0005ea,A\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u00035!Xm\u001d;Ek\u0006dwK]5uKR\u0019!*a\b\t\r\u0005\u0005b\u00021\u0001s\u0003%Q8n\u00117vgR,'\u000fK\t\u000fs\u0006\r\u0011QA@\u0002\u0002\u0005=\u0011\u0011CA\u0013\u0003O\t\u0001c]3sm\u0016\u0014\bK]8qKJ$\u0018.Z:-\u0011\u0005%\u0012QHA$\u0003\u001bZ#\"a\u000b\u00022\u0005M\u0012qGA\u001d!\rQ\u0018QF\u0005\u0004\u0003_Y(!F\"mkN$XM]\"p]\u001aLw\r\u0015:pa\u0016\u0014H/_\u0001\u0004W\u0016L\u0018EAA\u001b\u0003iIg\u000e^3s]\t\u0014xn[3s]1L7\u000f^3oKJtc.Y7f\u0003\u00151\u0018\r\\;fC\t\tY$\u0001\u0005F1R+%KT!MW)\tY#!\r\u0002@\u0005]\u00121I\u0011\u0003\u0003\u0003\n\u0011\u0002\\5ti\u0016tWM]:\"\u0005\u0005\u0015\u0013A\f)M\u0003&sE+\u0012-Uu=zCn\\2bY\"|7\u000f\u001e\u001e1Y\u0015CF+\u0012*O\u00032Stf\f7pG\u0006d\u0007n\\:uuAZ#\"a\u000b\u00022\u0005%\u0013qGA\"C\t\tY%\u0001\u000bbIZ,'\u000f^5tK\u0012tC.[:uK:,'o]\u0016\u000b\u0003W\t\t$a\u0014\u00028\u0005M\u0013EAA)\u0003ya\u0017n\u001d;f]\u0016\u0014hf]3dkJLG/\u001f\u0018qe>$xnY8m]5\f\u0007/\t\u0002\u0002V\u00051S\t\u0017+F%:\u000bEJ\u000f)M\u0003&sE+\u0012-UYAc\u0015)\u0013(U\u000bb#&\b\u0015'B\u0013:#V\t\u0017+\u0002%\u0005dGn\\2bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u000b\u0004\u0015\u0006m\u0003bBA/\u001f\u0001\u0007\u0011qL\u0001\u0011E>|Go\u001d;sCB\u001cVM\u001d<feN\u0004B!!\u0019\u0002p9!\u00111MA6!\r\t)gH\u0007\u0003\u0003OR1!!\u001b\u001c\u0003\u0019a$o\\8u}%\u0019\u0011QN\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t(a\u001d\u0003\rM#(/\u001b8h\u0015\r\tigH\u0001\u0014e\u0016\fG\r\u0015:pIV\u001cWM]%e\u00052|7m\u001b\u000b\u0005\u0003s\ny\bE\u0002^\u0003wJ1!! _\u0005A\u0001&o\u001c3vG\u0016\u0014\u0018\nZ:CY>\u001c7\u000eC\u0004\u0002\u0002B\u0001\r!a!\u0002\u0011i\\7\t\\5f]R\u00042AJAC\u0013\r\t9i\u0006\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002!\u0005dG/\u001a:U_BL7mQ8oM&<G\u0003BAG\u0003;\u0003B!a$\u0002\u001a6\u0011\u0011\u0011\u0013\u0006\u0005\u0003'\u000b)*A\u0003bI6LgNC\u0002\u0002\u0018v\nqa\u00197jK:$8/\u0003\u0003\u0002\u001c\u0006E%AE!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z:vYRDq!a%\u0012\u0001\u0004\ty\n\u0005\u0003\u0002\u0010\u0006\u0005\u0016\u0002BAR\u0003#\u0013Q!\u00113nS:\f\u0011#\u00197uKJ\u001cE.[3oiF+x\u000e^1t)\u0011\tI+a,\u0011\t\u0005=\u00151V\u0005\u0005\u0003[\u000b\tJA\fBYR,'o\u00117jK:$\u0018+^8uCN\u0014Vm];mi\"9\u00111\u0013\nA\u0002\u0005}\u0015A\u0005<fe&4\u0017\u0010V8qS\u000e\u001cuN\u001c4jON$2ASA[\u0011\u001d\t\ti\u0005a\u0001\u0003\u0007\u000b!C^3sS\u001aL8\t\\5f]R\fVo\u001c;bgR\u0019!*a/\t\u000f\u0005\u0005E\u00031\u0001\u0002\u0004\u0006\u0001b/\u001a:jMf\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u000b\u0006\u0015\u0006\u0005\u0017Q\u0019\u0005\b\u0003\u0007,\u0002\u0019AA=\u0003Q1\u0017N]:u!J|G-^2fe&#'\t\\8dW\"9\u0011\u0011Q\u000bA\u0002\u0005\r\u0005f\u0002\u0001\u0002J\u0006]\u0012\u0011\u001d\t\u0005\u0003\u0017\fi.\u0004\u0002\u0002N*!\u0011qZAi\u0003%)\u0007\u0010^3og&|gN\u0003\u0003\u0002T\u0006U\u0017aA1qS*!\u0011q[Am\u0003\u001dQW\u000f]5uKJT1!a7.\u0003\u0015QWO\\5u\u0013\u0011\ty.!4\u0003\u0015\u0015CH/\u001a8e/&$\b\u000e\f\u0002\u0002d\u000e\u0012\u0011Q\u001d\t\u0005\u0003O\fY/\u0004\u0002\u0002j*\u0019\u00111\u001c;\n\t\u00055\u0018\u0011\u001e\u0002\u0016\u00072,8\u000f^3s)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8t\u0001")
public class ZkMigrationIntegrationTest {
    private final Logger log = LoggerFactory.getLogger(ZkMigrationIntegrationTest.class);

    public Logger log() {
        return this.log;
    }

    @ClusterTest(brokers=3, clusterType=Type.ZK, metadataVersion=MetadataVersion.IBP_3_4_IV0)
    public void testMigrate(ClusterInstance clusterInstance) {
        Admin admin = clusterInstance.createAdminClient();
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic("test-topic-1", 2, (short)3).configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"102400"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"300000")}))).asJava()));
        newTopics.add(new NewTopic("test-topic-2", 1, (short)3));
        newTopics.add(new NewTopic("test-topic-3", 10, (short)3));
        admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
        ArrayList<ClientQuotaAlteration> quotas = new ArrayList<ClientQuotaAlteration>();
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), (List)Nil$.MODULE$)).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(800.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(100.0)), (List)Nil$.MODULE$))).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"8.8.8.8")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)), (List)Nil$.MODULE$)).asJava()));
        admin.alterClientQuotas(quotas);
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().zkClient();
        ZkMigrationClient migrationClient = new ZkMigrationClient(zkClient);
        ZkMigrationLeadershipState migrationState = migrationClient.getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState.EMPTY);
        migrationState = migrationState.withNewKRaftController(3000, 42);
        migrationState = migrationClient.claimControllerLeadership(migrationState);
        HashSet brokers = new HashSet();
        MetadataDeltaVerifier verifier = new MetadataDeltaVerifier();
        migrationClient.readAllMetadata(batch -> verifier.accept((java.util.List<ApiMessageAndVersion>)batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(brokers).asScala().toSeq());
        verifier.verify((Function1<MetadataImage, BoxedUnit>)(Function1 & Serializable)image -> {
            ZkMigrationIntegrationTest.$anonfun$testMigrate$3(image);
            return BoxedUnit.UNIT;
        });
        migrationClient.releaseControllerLeadership(migrationState);
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDualWrite(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic("test", 2, (short)3).configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"102400"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"300000")}))).asJava()));
        admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        Properties propsBefore = zkClient.getEntityConfigs(ConfigType$.MODULE$.Topic(), "test");
        Assertions.assertEquals((Object)"102400", (Object)propsBefore.getProperty("segment.bytes"));
        Assertions.assertEquals((Object)"300000", (Object)propsBefore.getProperty("segment.ms"));
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.allocateProducerId(zkCluster.bootstrapServers());
            ProducerIdsBlock producerIdBlock = this.readProducerIdBlock(zkClient);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWrite$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterTopicConfig(admin).all().get(60L, TimeUnit.SECONDS);
            this.alterClientQuotas(admin).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyTopicConfigs(zkClient);
            this.verifyClientQuotas(zkClient);
            this.allocateProducerId(zkCluster.bootstrapServers());
            this.verifyProducerId(producerIdBlock, zkClient);
        }
        finally {
            zkCluster.stop();
            kraftCluster.close();
        }
    }

    public void allocateProducerId(String bootstrapServers) {
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrapServers);
        props.put("transactional.id", "some-transaction-id");
        KafkaProducer producer = new KafkaProducer(props, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(new ProducerRecord("test", (Object)"", (Object)"one"));
        producer.commitTransaction();
        producer.flush();
        producer.close();
    }

    /*
     * WARNING - void declaration
     */
    public ProducerIdsBlock readProducerIdBlock(KafkaZkClient zkClient) {
        void var3_3;
        Tuple2 tuple2 = zkClient.getDataAndVersion("/latest_producer_id_block");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option dataOpt = (Option)tuple2._1();
        return (ProducerIdsBlock)var3_3.map((Function1 & Serializable)jsonData -> ProducerIdBlockZNode$.MODULE$.parseProducerIdBlockData(jsonData)).get();
    }

    public AlterConfigsResult alterTopicConfig(Admin admin) {
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "test");
        Collection alterConfigs = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.bytes", "204800"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.ms", null), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))).asJavaCollection();
        return admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource), (Object)alterConfigs)}))).asJava());
    }

    public AlterClientQuotasResult alterClientQuotas(Admin admin) {
        ArrayList<ClientQuotaAlteration> quotas = new ArrayList<ClientQuotaAlteration>();
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), (List)Nil$.MODULE$)).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(800.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(100.0)), (List)Nil$.MODULE$))).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"8.8.8.8")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)), (List)Nil$.MODULE$)).asJava()));
        return admin.alterClientQuotas(quotas);
    }

    public void verifyTopicConfigs(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyTopicConfigs$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public void verifyClientQuotas(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyClientQuotas$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void verifyProducerId(ProducerIdsBlock firstProducerIdBlock, KafkaZkClient zkClient) {
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyProducerId$1(this, zkClient, firstProducerIdBlock);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var9_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testMigrate$3(MetadataImage image) {
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-1"));
        Assertions.assertEquals((int)2, (int)image.topics().getTopic("test-topic-1").partitions().size());
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-2"));
        Assertions.assertEquals((int)1, (int)image.topics().getTopic("test-topic-2").partitions().size());
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-3"));
        Assertions.assertEquals((int)10, (int)image.topics().getTopic("test-topic-3").partitions().size());
        java.util.Map clientQuotas = image.clientQuotas().entities();
        Assertions.assertEquals((int)3, (int)clientQuotas.size());
    }

    public static final /* synthetic */ boolean $anonfun$testDualWrite$1(KafkaZkClient zkClient$1) {
        return zkClient$1.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWrite$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ void $anonfun$verifyTopicConfigs$1(KafkaZkClient zkClient$2) {
        Properties propsAfter = zkClient$2.getEntityConfigs(ConfigType$.MODULE$.Topic(), "test");
        Assertions.assertEquals((Object)"204800", (Object)propsAfter.getProperty("segment.bytes"));
        Assertions.assertFalse((boolean)propsAfter.containsKey("segment.ms"));
    }

    public static final /* synthetic */ void $anonfun$verifyClientQuotas$1(KafkaZkClient zkClient$3) {
        Assertions.assertEquals((Object)"1000.0", (Object)zkClient$3.getEntityConfigs(ConfigType$.MODULE$.User(), "user1").getProperty("consumer_byte_rate"));
        Assertions.assertEquals((Object)"800.0", (Object)zkClient$3.getEntityConfigs("users/user1/clients", "clientA").getProperty("consumer_byte_rate"));
        Assertions.assertEquals((Object)"100.0", (Object)zkClient$3.getEntityConfigs("users/user1/clients", "clientA").getProperty("producer_byte_rate"));
        Assertions.assertEquals((Object)"10.0", (Object)zkClient$3.getEntityConfigs(ConfigType$.MODULE$.Ip(), "8.8.8.8").getProperty("connection_creation_rate"));
    }

    public static final /* synthetic */ void $anonfun$verifyProducerId$1(ZkMigrationIntegrationTest $this, KafkaZkClient zkClient$4, ProducerIdsBlock firstProducerIdBlock$1) {
        ProducerIdsBlock producerIdBlock = $this.readProducerIdBlock(zkClient$4);
        Assertions.assertTrue((firstProducerIdBlock$1.firstProducerId() < producerIdBlock.firstProducerId() ? 1 : 0) != 0);
    }

    public class MetadataDeltaVerifier {
        private final MetadataDelta metadataDelta;
        private int offset;

        public MetadataDelta metadataDelta() {
            return this.metadataDelta;
        }

        public int offset() {
            return this.offset;
        }

        public void offset_$eq(int x$1) {
            this.offset = x$1;
        }

        public void accept(java.util.List<ApiMessageAndVersion> batch) {
            batch.forEach(message -> {
                this.metadataDelta().replay(message.message());
                this.offset_$eq(this.offset() + 1);
            });
        }

        public void verify(Function1<MetadataImage, BoxedUnit> verifier) {
            MetadataImage image = this.metadataDelta().apply(new MetadataProvenance((long)this.offset(), 0, 0L));
            verifier.apply((Object)image);
        }

        public /* synthetic */ ZkMigrationIntegrationTest kafka$zk$ZkMigrationIntegrationTest$MetadataDeltaVerifier$$$outer() {
            return ZkMigrationIntegrationTest.this;
        }

        public MetadataDeltaVerifier() {
            if (ZkMigrationIntegrationTest.this == null) {
                throw null;
            }
            this.metadataDelta = new MetadataDelta(MetadataImage.EMPTY);
            this.offset = 0;
        }
    }
}

