/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.concurrent.CompletableFuture;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.group.GroupCoordinatorAdapter;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.LeaveGroupResult;
import kafka.coordinator.group.LeaveMemberResponse;
import kafka.coordinator.group.SyncGroupResult;
import kafka.server.RequestLocal;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005!4Aa\u0002\u0005\u0001\u001f!)a\u0003\u0001C\u0001/!)!\u0004\u0001C\u00057!)a\u0007\u0001C\u0001o!)a\u000b\u0001C\u0001/\")a\f\u0001C\u0001?\")q\r\u0001C\u0001?\nYrI]8va\u000e{wN\u001d3j]\u0006$xN]!eCB$XM\u001d+fgRT!!\u0003\u0006\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0005-a\u0011aC2p_J$\u0017N\\1u_JT\u0011!D\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\u0001\"!\u0007\u0001\u000e\u0003!\t1\"\\1lK\u000e{g\u000e^3yiR\u0019A$K\u0019\u0011\u0005u9S\"\u0001\u0010\u000b\u0005}\u0001\u0013\u0001\u0003:fcV,7\u000f^:\u000b\u0005\u0005\u0012\u0013AB2p[6|gN\u0003\u0002\u000eG)\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0013\tAcD\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\t\u000b)\u0012\u0001\u0019A\u0016\u0002\r\u0005\u0004\u0018nS3z!\tas&D\u0001.\u0015\tq\u0003%\u0001\u0005qe>$xnY8m\u0013\t\u0001TFA\u0004Ba&\\U-_:\t\u000bI\u0012\u0001\u0019A\u001a\u0002\u0015\u0005\u0004\u0018NV3sg&|g\u000e\u0005\u0002\u0012i%\u0011QG\u0005\u0002\u0006'\"|'\u000f^\u0001\u000ei\u0016\u001cHOS8j]\u001e\u0013x.\u001e9\u0015\u0005aZ\u0004CA\t:\u0013\tQ$C\u0001\u0003V]&$\b\"\u0002\u001f\u0004\u0001\u0004\u0019\u0014a\u0002<feNLwN\u001c\u0015\u0005\u0007yRc\t\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\r\u0003\u0013!B;uS2\u001c\u0018BA#A\u0005Q\t\u0005/[&fsZ+'o]5p]N\u001cv.\u001e:dK\u0012\nq)\u0003\u0002I\u0013\u0006Q!jT%O?\u001e\u0013v*\u0016)\u000b\u0005)k\u0013aB!qS.+\u0017p\u001d\u0015\u0003\u00071\u0003\"!\u0014+\u000e\u00039S!a\u0014)\u0002\rA\f'/Y7t\u0015\t\t&+A\u0004kkBLG/\u001a:\u000b\u0005M+\u0013!\u00026v]&$\u0018BA+O\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u000ei\u0016\u001cHoU=oG\u001e\u0013x.\u001e9\u0015\u0005aB\u0006\"\u0002\u001f\u0005\u0001\u0004\u0019\u0004\u0006\u0002\u0003?Ui#\u0013aW\u0005\u00039&\u000b!bU-O\u0007~;%kT+QQ\t!A*A\u0007uKN$\b*Z1si\n,\u0017\r\u001e\u000b\u0002q!\u0012Q!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003IB\u000b1!\u00199j\u0013\t17M\u0001\u0003UKN$\u0018A\u0004;fgRdU-\u0019<f\u000fJ|W\u000f\u001d")
public class GroupCoordinatorAdapterTest {
    private RequestContext makeContext(ApiKeys apiKey, short apiVersion) {
        return new RequestContext(new RequestHeader(apiKey, apiVersion, "client", 0), "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false);
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.JOIN_GROUP)
    public void testJoinGroup(short version) {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator);
        RequestContext ctx = this.makeContext(ApiKeys.JOIN_GROUP, version);
        JoinGroupRequestData request = new JoinGroupRequestData().setGroupId("group").setMemberId("member").setProtocolType("consumer").setRebalanceTimeoutMs(1000).setSessionTimeoutMs(2000).setReason("reason").setProtocols(new JoinGroupRequestData.JoinGroupRequestProtocolCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("first").setMetadata("first".getBytes()), (List)new .colon.colon((Object)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("second").setMetadata("second".getBytes()), (List)Nil$.MODULE$)).iterator()).asJava()));
        BufferSupplier bufferSupplier = BufferSupplier.create();
        CompletableFuture future = adapter.joinGroup(ctx, request, bufferSupplier);
        Assertions.assertFalse((boolean)future.isDone());
        ArgumentCaptor capturedProtocols = ArgumentCaptor.forClass(List.class);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleJoinGroup((String)ArgumentMatchers.eq((Object)request.groupId()), (String)ArgumentMatchers.eq((Object)request.memberId()), (Option)ArgumentMatchers.eq((Object)None$.MODULE$), ArgumentMatchers.eq((version >= 4 ? 1 : 0) != 0), ArgumentMatchers.eq((version >= 9 ? 1 : 0) != 0), (String)ArgumentMatchers.eq((Object)ctx.clientId()), (String)ArgumentMatchers.eq((Object)InetAddress.getLocalHost().toString()), ArgumentMatchers.eq((int)request.rebalanceTimeoutMs()), ArgumentMatchers.eq((int)request.sessionTimeoutMs()), (String)ArgumentMatchers.eq((Object)request.protocolType()), (List)capturedProtocols.capture(), (Function1)capturedCallback.capture(), (Option)ArgumentMatchers.eq((Object)new Some((Object)"reason")), (RequestLocal)ArgumentMatchers.eq((Object)new RequestLocal(bufferSupplier)));
        Assertions.assertEquals((Object)new .colon.colon((Object)new Tuple2((Object)"first", (Object)"first"), (List)new .colon.colon((Object)new Tuple2((Object)"second", (Object)"second"), (List)Nil$.MODULE$)), (Object)((List)capturedProtocols.getValue()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String name = (String)x0$1._1();
                byte[] metadata = (byte[])x0$1._2();
                return new Tuple2((Object)name, (Object)new String(metadata));
            }
            throw new MatchError(null);
        }));
        ((Function1)capturedCallback.getValue()).apply((Object)new JoinGroupResult((List)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("member").setMetadata("member".getBytes()).setGroupInstanceId("instance"), (List)Nil$.MODULE$), "member", 10, (Option)new Some((Object)"consumer"), (Option)new Some((Object)"range"), "leader", true, Errors.UNKNOWN_MEMBER_ID));
        JoinGroupResponseData expectedData = new JoinGroupResponseData().setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("member").setMetadata("member".getBytes()).setGroupInstanceId("instance"), (List)Nil$.MODULE$)).asJava()).setMemberId("member").setGenerationId(10).setProtocolType("consumer").setProtocolName("range").setLeader("leader").setSkipAssignment(true).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedData, future.get());
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.SYNC_GROUP)
    public void testSyncGroup(short version) {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator);
        RequestContext ctx = this.makeContext(ApiKeys.SYNC_GROUP, version);
        SyncGroupRequestData data = new SyncGroupRequestData().setGroupId("group").setMemberId("member1").setGroupInstanceId("instance").setProtocolType("consumer").setProtocolName("range").setGenerationId(10).setAssignments(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId("member1").setAssignment("member1".getBytes()), (List)new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId("member2").setAssignment("member2".getBytes()), (List)Nil$.MODULE$))).asJava());
        BufferSupplier bufferSupplier = BufferSupplier.create();
        CompletableFuture future = adapter.syncGroup(ctx, data, bufferSupplier);
        Assertions.assertFalse((boolean)future.isDone());
        ArgumentCaptor capturedAssignment = ArgumentCaptor.forClass(scala.collection.immutable.Map.class);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleSyncGroup((String)ArgumentMatchers.eq((Object)data.groupId()), ArgumentMatchers.eq((int)data.generationId()), (String)ArgumentMatchers.eq((Object)data.memberId()), (Option)ArgumentMatchers.eq((Object)new Some((Object)data.protocolType())), (Option)ArgumentMatchers.eq((Object)new Some((Object)data.protocolName())), (Option)ArgumentMatchers.eq((Object)new Some((Object)data.groupInstanceId())), (Map)capturedAssignment.capture(), (Function1)capturedCallback.capture(), (RequestLocal)ArgumentMatchers.eq((Object)new RequestLocal(bufferSupplier)));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"member1"), (Object)"member1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"member2"), (Object)"member2")})), (Object)((MapOps)capturedAssignment.getValue()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String member = (String)x0$1._1();
                byte[] metadata = (byte[])x0$1._2();
                return new Tuple2((Object)member, (Object)new String(metadata));
            }
            throw new MatchError(null);
        }));
        Some x$2 = new Some((Object)"consumer");
        Some x$3 = new Some((Object)"range");
        byte[] x$4 = "member1".getBytes();
        ((Function1)capturedCallback.getValue()).apply((Object)new SyncGroupResult((Option)x$2, (Option)x$3, x$4, Errors.NONE));
        SyncGroupResponseData expectedResponseData = new SyncGroupResponseData().setErrorCode(Errors.NONE.code()).setProtocolType("consumer").setProtocolName("range").setAssignment("member1".getBytes());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedResponseData, future.get());
    }

    @Test
    public void testHeartbeat() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator);
        RequestContext ctx = this.makeContext(ApiKeys.HEARTBEAT, ApiKeys.HEARTBEAT.latestVersion());
        HeartbeatRequestData data = new HeartbeatRequestData().setGroupId("group").setMemberId("member1").setGenerationId(0);
        CompletableFuture future = adapter.heartbeat(ctx, data);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleHeartbeat((String)ArgumentMatchers.eq((Object)data.groupId()), (String)ArgumentMatchers.eq((Object)data.memberId()), (Option)ArgumentMatchers.eq((Object)None$.MODULE$), ArgumentMatchers.eq((int)data.generationId()), (Function1)capturedCallback.capture());
        Assertions.assertFalse((boolean)future.isDone());
        ((Function1)capturedCallback.getValue()).apply((Object)Errors.NONE);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)new HeartbeatResponseData(), future.get());
    }

    public void testLeaveGroup() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator);
        RequestContext ctx = this.makeContext(ApiKeys.LEAVE_GROUP, ApiKeys.LEAVE_GROUP.latestVersion());
        LeaveGroupRequestData data = new LeaveGroupRequestData().setGroupId("group").setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new LeaveGroupRequestData.MemberIdentity().setMemberId("member-1").setGroupInstanceId("instance-1"), (List)new .colon.colon((Object)new LeaveGroupRequestData.MemberIdentity().setMemberId("member-2").setGroupInstanceId("instance-2"), (List)Nil$.MODULE$))).asJava());
        CompletableFuture future = adapter.leaveGroup(ctx, data);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleLeaveGroup((String)ArgumentMatchers.eq((Object)data.groupId()), (List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.ListHasAsScala(data.members()).asScala().toList()), (Function1)capturedCallback.capture());
        Assertions.assertFalse((boolean)future.isDone());
        ((Function1)capturedCallback.getValue()).apply((Object)new LeaveGroupResult(Errors.NONE, (List)new .colon.colon((Object)new LeaveMemberResponse("member-1", (Option)new Some((Object)"instance-1"), Errors.NONE), (List)new .colon.colon((Object)new LeaveMemberResponse("member-2", (Option)new Some((Object)"instance-2"), Errors.NONE), (List)Nil$.MODULE$))));
        LeaveGroupResponseData expectedData = new LeaveGroupResponseData().setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new LeaveGroupResponseData.MemberResponse().setMemberId("member-1").setGroupInstanceId("instance-1"), (List)new .colon.colon((Object)new LeaveGroupResponseData.MemberResponse().setMemberId("member-2").setGroupInstanceId("instance-2"), (List)Nil$.MODULE$))).asJava());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedData, future.get());
    }
}

