/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.log.Defaults$;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LocalLogTest;
import kafka.log.LocalLogTest$KeyValue$;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogSegments;
import kafka.log.LogTestUtils$;
import kafka.log.LogTruncation;
import kafka.log.SegmentDeletionReason;
import kafka.server.FetchDataInfo;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011eb\u0001\u00026l\u0001ADQa\u001e\u0001\u0005\u0002aD\u0011b\u001f\u0001A\u0002\u0003\u0007I\u0011\u0001?\t\u0017\u0005\u001d\u0001\u00011AA\u0002\u0013\u0005\u0011\u0011\u0002\u0005\u000b\u0003+\u0001\u0001\u0019!A!B\u0013i\b\"CA\f\u0001\t\u0007I\u0011AA\r\u0011!\tY\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0017\u0001\t\u0007I\u0011AA\r\u0011!\ty\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0019\u0001\t\u0007I\u0011AA\u001a\u0011!\tY\u0005\u0001Q\u0001\n\u0005U\u0002\"CA'\u0001\t\u0007I\u0011AA(\u0011!\t9\u0006\u0001Q\u0001\n\u0005E\u0003\"CA-\u0001\t\u0007I\u0011AA.\u0011!\tI\u0007\u0001Q\u0001\n\u0005u\u0003\u0002\u00037\u0001\u0005\u0004%\t!a\u001b\t\u0011\u0005M\u0004\u0001)A\u0005\u0003[Bq!!\u001e\u0001\t\u0003\t9\bC\u0004\u0002\u0010\u0002!\t!a\u001e\u0007\r\u0005e\u0005\u0001QAN\u0011)\tYl\u0005BK\u0002\u0013\u0005\u0011Q\u0018\u0005\u000b\u0003\u001f\u001c\"\u0011#Q\u0001\n\u0005}\u0006BCAi'\tU\r\u0011\"\u0001\u0002>\"Q\u00111[\n\u0003\u0012\u0003\u0006I!a0\t\r]\u001cB\u0011AAk\u0011\u001d\tyn\u0005C\u0001\u0003CD\u0011\"a@\u0014#\u0003%\tA!\u0001\t\u0013\t]1#!A\u0005\u0002\te\u0001\"\u0003B\u0010'E\u0005I\u0011\u0001B\u0011\u0011%\u0011)cEI\u0001\n\u0003\u0011\t\u0003C\u0005\u0003(M\t\t\u0011\"\u0011\u0003*!I!QG\n\u0002\u0002\u0013\u0005!q\u0007\u0005\n\u0005\u007f\u0019\u0012\u0011!C\u0001\u0005\u0003B\u0011Ba\u0013\u0014\u0003\u0003%\tE!\u0014\t\u0013\tm3#!A\u0005\u0002\tu\u0003\"\u0003B4'\u0005\u0005I\u0011\tB5\u0011%\u0011igEA\u0001\n\u0003\u0012y\u0007C\u0005\u0003rM\t\t\u0011\"\u0011\u0003t!I!QO\n\u0002\u0002\u0013\u0005#qO\u0004\b\u0005w\u0002\u0001\u0012\u0001B?\r\u001d\tI\n\u0001E\u0001\u0005\u007fBaa\u001e\u0015\u0005\u0002\t\u0015\u0005b\u0002BDQ\u0011\u0005!\u0011\u0012\u0005\n\u0005'C\u0013\u0011!CA\u0005+C\u0011Ba')\u0003\u0003%\tI!(\t\u000f\t=\u0006\u0001\"\u0003\u00032\"9!q\u0018\u0001\u0005\n\t\u0005\u0007b\u0002Be\u0001\u0011%!1\u001a\u0005\n\u0005+\u0004\u0011\u0013!C\u0005\u0005/D\u0011Ba7\u0001#\u0003%IA!\u0001\t\u000f\tu\u0007\u0001\"\u0003\u0003`\"I1q\u0001\u0001\u0012\u0002\u0013%!q\u001b\u0005\n\u0007\u0013\u0001\u0011\u0013!C\u0005\u0005\u0003A\u0011ba\u0003\u0001#\u0003%Ia!\u0004\t\u0013\rE\u0001!%A\u0005\n\rM\u0001\"CB\f\u0001E\u0005I\u0011BB\r\u0011%\u0019i\u0002AI\u0001\n\u0013\u0019\u0019\u0002C\u0004\u0004 \u0001!\t!a\u001e\t\u000f\r%\u0002\u0001\"\u0001\u0002x!91Q\u0006\u0001\u0005\u0002\u0005]\u0004bBB\u0019\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0007k\u0001A\u0011AA<\u0011\u001d\u0019I\u0004\u0001C\u0001\u0003oBqa!\u0010\u0001\t\u0003\t9\bC\u0004\u0004B\u0001!\t!a\u001e\t\u000f\r\u0015\u0003\u0001\"\u0001\u0002x!91\u0011\n\u0001\u0005\u0002\u0005]\u0004bBB'\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0007#\u0002A\u0011AA<\u0011\u001d\u0019)\u0006\u0001C\u0001\u0003oBqa!\u0017\u0001\t\u0013\u0019Y\u0006C\u0004\u0004b\u0001!\t!a\u001e\t\u000f\r\u0015\u0004\u0001\"\u0001\u0002x!91\u0011\u000e\u0001\u0005\n\r-\u0004bBB8\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0007g\u0002A\u0011AA<\u0011\u001d\u00199\b\u0001C\u0001\u0003oBqaa\u001f\u0001\t\u0003\t9\bC\u0004\u0004\u0000\u0001!\t!a\u001e\t\u000f\r\r\u0005\u0001\"\u0001\u0002x!91q\u0011\u0001\u0005\u0002\u0005]\u0004bBBF\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0007\u001f\u0003A\u0011BBI\u0011\u001d\u0019Y\n\u0001C\u0001\u0003oBqaa(\u0001\t\u0003\t9\bC\u0004\u0004$\u0002!\t!a\u001e\t\u000f\r\u001d\u0006\u0001\"\u0001\u0002x!911\u0016\u0001\u0005\u0002\u0005]\u0004bBBX\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0007g\u0003A\u0011AA<\u0011\u001d\u00199\f\u0001C\u0001\u0003oBqaa/\u0001\t\u0003\t9\bC\u0004\u0004@\u0002!\t!a\u001e\t\u000f\r\r\u0007\u0001\"\u0001\u0002x!91q\u0019\u0001\u0005\u0002\u0005]\u0004bBBf\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0007\u001f\u0004A\u0011AA<\u0011\u001d\u0019\u0019\u000e\u0001C\u0005\u0007+D\u0011\u0002\"\u0005\u0001#\u0003%I\u0001b\u0005\t\u0013\u0011]\u0001!%A\u0005\n\u0011e\u0001\"\u0003C\u000f\u0001E\u0005I\u0011\u0002B\u0001\u0011%!y\u0002AI\u0001\n\u0013\u0019I\u0002C\u0005\u0005\"\u0001\t\n\u0011\"\u0003\u0005$!IAq\u0005\u0001\u0012\u0002\u0013%A\u0011\u0006\u0005\n\t[\u0001\u0011\u0013!C\u0005\t_A\u0011\u0002b\r\u0001#\u0003%I\u0001\"\u000e\u0003\u00191{7-\u00197M_\u001e$Vm\u001d;\u000b\u00051l\u0017a\u00017pO*\ta.A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\bC\u0001:v\u001b\u0005\u0019(\"\u0001;\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001c(AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002sB\u0011!\u0010A\u0007\u0002W\u000611m\u001c8gS\u001e,\u0012! \t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005Q.\u0001\u0004tKJ4XM]\u0005\u0004\u0003\u000by(aC&bM.\f7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\u0011\tY!!\u0005\u0011\u0007I\fi!C\u0002\u0002\u0010M\u0014A!\u00168ji\"A\u00111C\u0002\u0002\u0002\u0003\u0007Q0A\u0002yIE\nqaY8oM&<\u0007%\u0001\u0004u[B$\u0015N]\u000b\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#\u0001\u0002j_*\u0011\u0011QE\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002*\u0005}!\u0001\u0002$jY\u0016\fq\u0001^7q\t&\u0014\b%\u0001\u0004m_\u001e$\u0015N]\u0001\bY><G)\u001b:!\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\"!!\u000e\u0011\t\u0005]\u0012qI\u0007\u0003\u0003sQA!a\u000f\u0002>\u000511m\\7n_:T1A\\A \u0015\u0011\t\t%a\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t)%A\u0002pe\u001eLA!!\u0013\u0002:\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\t\t\t\u0006E\u0002\u007f\u0003'J1!!\u0016\u0000\u0005Qaun\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0006)Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u0004\u0013\u0001C7pG.$\u0016.\\3\u0016\u0005\u0005u\u0003\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\rT.A\u0003vi&d7/\u0003\u0003\u0002h\u0005\u0005$\u0001C'pG.$\u0016.\\3\u0002\u00135|7m\u001b+j[\u0016\u0004SCAA7!\rQ\u0018qN\u0005\u0004\u0003cZ'\u0001\u0003'pG\u0006dGj\\4\u0002\t1|w\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003\u0017A3!EA>!\u0011\ti(a#\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b1!\u00199j\u0015\u0011\t))a\"\u0002\u000f),\b/\u001b;fe*!\u0011\u0011RA\"\u0003\u0015QWO\\5u\u0013\u0011\ti)a \u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r\u0011\u00121\u0013\t\u0005\u0003{\n)*\u0003\u0003\u0002\u0018\u0006}$!C!gi\u0016\u0014X)Y2i\u0005!YU-\u001f,bYV,7CB\nr\u0003;\u000b\u0019\u000bE\u0002s\u0003?K1!!)t\u0005\u001d\u0001&o\u001c3vGR\u0004B!!*\u00026:!\u0011qUAY\u001d\u0011\tI+a,\u000e\u0005\u0005-&bAAW_\u00061AH]8pizJ\u0011\u0001^\u0005\u0004\u0003g\u001b\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003o\u000bIL\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u00024N\f1a[3z+\t\ty\f\u0005\u0003\u0002B\u0006%g\u0002BAb\u0003\u000b\u00042!!+t\u0013\r\t9m]\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0017Q\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001d7/\u0001\u0003lKf\u0004\u0013!\u0002<bYV,\u0017A\u0002<bYV,\u0007\u0005\u0006\u0004\u0002X\u0006m\u0017Q\u001c\t\u0004\u00033\u001cR\"\u0001\u0001\t\u000f\u0005m\u0006\u00041\u0001\u0002@\"9\u0011\u0011\u001b\rA\u0002\u0005}\u0016\u0001\u0003;p%\u0016\u001cwN\u001d3\u0015\t\u0005\r\u0018q\u001e\t\u0005\u0003K\fY/\u0004\u0002\u0002h*!\u0011\u0011^A\u001d\u0003\u0019\u0011XmY8sI&!\u0011Q^At\u00051\u0019\u0016.\u001c9mKJ+7m\u001c:e\u0011%\t\t0\u0007I\u0005\u0002\u0004\t\u00190A\u0005uS6,7\u000f^1naB)!/!>\u0002z&\u0019\u0011q_:\u0003\u0011q\u0012\u0017P\\1nKz\u00022A]A~\u0013\r\tip\u001d\u0002\u0005\u0019>tw-\u0001\nu_J+7m\u001c:eI\u0011,g-Y;mi\u0012\nTC\u0001B\u0002U\u0011\tIP!\u0002,\u0005\t\u001d\u0001\u0003\u0002B\u0005\u0005'i!Aa\u0003\u000b\t\t5!qB\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0005t\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005+\u0011YAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAaY8qsR1\u0011q\u001bB\u000e\u0005;A\u0011\"a/\u001c!\u0003\u0005\r!a0\t\u0013\u0005E7\u0004%AA\u0002\u0005}\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005GQC!a0\u0003\u0006\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003,A!!Q\u0006B\u001a\u001b\t\u0011yC\u0003\u0003\u00032\u0005\r\u0012\u0001\u00027b]\u001eLA!a3\u00030\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!\u0011\b\t\u0004e\nm\u0012b\u0001B\u001fg\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\tB%!\r\u0011(QI\u0005\u0004\u0005\u000f\u001a(aA!os\"I\u00111\u0003\u0011\u0002\u0002\u0003\u0007!\u0011H\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\n\t\u0007\u0005#\u00129Fa\u0011\u000e\u0005\tM#b\u0001B+g\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\te#1\u000b\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003`\t\u0015\u0004c\u0001:\u0003b%\u0019!1M:\u0003\u000f\t{w\u000e\\3b]\"I\u00111\u0003\u0012\u0002\u0002\u0003\u0007!1I\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003,\t-\u0004\"CA\nG\u0005\u0005\t\u0019\u0001B\u001d\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B\u001d\u0003!!xn\u0015;sS:<GC\u0001B\u0016\u0003\u0019)\u0017/^1mgR!!q\fB=\u0011%\t\u0019BJA\u0001\u0002\u0004\u0011\u0019%\u0001\u0005LKf4\u0016\r\\;f!\r\tI\u000eK\n\u0005QE\u0014\t\t\u0005\u0003\u0002\u001e\t\r\u0015\u0002BA\\\u0003?!\"A! \u0002\u0015\u0019\u0014x.\u001c*fG>\u0014H\r\u0006\u0003\u0002X\n-\u0005bBAuU\u0001\u0007!Q\u0012\t\u0005\u0003K\u0014y)\u0003\u0003\u0003\u0012\u0006\u001d(A\u0002*fG>\u0014H-A\u0003baBd\u0017\u0010\u0006\u0004\u0002X\n]%\u0011\u0014\u0005\b\u0003w[\u0003\u0019AA`\u0011\u001d\t\tn\u000ba\u0001\u0003\u007f\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003 \n-\u0006#\u0002:\u0003\"\n\u0015\u0016b\u0001BRg\n1q\n\u001d;j_:\u0004rA\u001dBT\u0003\u007f\u000by,C\u0002\u0003*N\u0014a\u0001V;qY\u0016\u0014\u0004\"\u0003BWY\u0005\u0005\t\u0019AAl\u0003\rAH\u0005M\u0001\rWZ\u001cHk\u001c*fG>\u0014Hm\u001d\u000b\u0005\u0005g\u0013I\f\u0005\u0004\u0002&\nU\u00161]\u0005\u0005\u0005o\u000bIL\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\u0011Y,\fa\u0001\u0005{\u000b\u0011b[3z-\u0006dW/Z:\u0011\r\u0005\u0015&QWAl\u00031\u0011XmY8sIN$vn\u0013<t)\u0011\u0011iLa1\t\u000f\t\u0015g\u00061\u0001\u0003H\u00069!/Z2pe\u0012\u001c\bCBAS\u0005k\u0013i)A\u0007baB,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\t\u0003\u0017\u0011iMa4\u0003R\"9!QY\u0018A\u0002\tM\u0006\u0002\u000370!\u0003\u0005\r!!\u001c\t\u0013\tMw\u0006%AA\u0002\u0005e\u0018!D5oSRL\u0017\r\\(gMN,G/A\fbaB,g\u000e\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u001c\u0016\u0005\u0003[\u0012)!A\fbaB,g\u000e\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005Y!/Z1e%\u0016\u001cwN\u001d3t)9\u0011\tOa:\u0003j\n5(1\u001fB|\u0007\u0007\u00012A Br\u0013\r\u0011)o \u0002\u000e\r\u0016$8\r\u001b#bi\u0006LeNZ8\t\u00111\u0014\u0004\u0013!a\u0001\u0003[B\u0011Ba;3!\u0003\u0005\r!!?\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\n\u0005_\u0014\u0004\u0013\"a\u0001\u0005c\f\u0011\"\\1y\u0019\u0016tw\r\u001e5\u0011\u000bI\f)P!\u000f\t\u0013\tU(\u0007%AA\u0002\t}\u0013!D7j]>sW-T3tg\u0006<W\rC\u0005\u0003zJ\u0002J\u00111\u0001\u0003|\u0006\tR.\u0019=PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0011\u000bI\f)P!@\u0011\u0007y\u0014y0C\u0002\u0004\u0002}\u0014\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011%\u0019)A\rI\u0001\u0002\u0004\u0011y&\u0001\nj]\u000edW\u000fZ3BE>\u0014H/\u001a3Uq:\u001c\u0018!\u0006:fC\u0012\u0014VmY8sIN$C-\u001a4bk2$H%M\u0001\u0016e\u0016\fGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003U\u0011X-\u00193SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIM*\"aa\u0004+\t\te\"QA\u0001\u0016e\u0016\fGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019)B\u000b\u0003\u0003`\t\u0015\u0011!\u0006:fC\u0012\u0014VmY8sIN$C-\u001a4bk2$H%N\u000b\u0003\u00077QCA!@\u0003\u0006\u0005)\"/Z1e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u00122\u0014\u0001\b;fgRdun\u001a#fY\u0016$XmU3h[\u0016tGo]*vG\u000e,7o\u001d\u0015\u0004s\r\r\u0002\u0003BA?\u0007KIAaa\n\u0002\u0000\t!A+Z:u\u0003i!Xm\u001d;S_2dW)\u001c9us\u0006\u001bG/\u001b<f'\u0016<W.\u001a8uQ\rQ41E\u00017i\u0016\u001cH\u000fT8h\t\u0016dW\r^3ESJ\u001cVoY2fgN<\u0006.\u001a8F[B$\u00180\u00118e\r\u0006LG.\u001e:f/\",gNT8o\u000b6\u0004H/\u001f\u0015\u0004w\r\r\u0012\u0001\u0005;fgR,\u0006\u000fZ1uK\u000e{gNZ5hQ\ra41E\u0001\u0019i\u0016\u001cH\u000fT8h\t&\u0014(+\u001a8b[\u0016$vNT3x\t&\u0014\bfA\u001f\u0004$\u0005iB/Z:u\u0019><G)\u001b:SK:\fW.\u001a+p\u000bbL7\u000f^5oO\u0012K'\u000fK\u0002?\u0007G\tA\u0002^3ti2{wM\u00127vg\"D3aPB\u0012\u00035!Xm\u001d;M_\u001e\f\u0005\u000f]3oI\"\u001a\u0001ia\t\u0002'Q,7\u000f\u001e'pO\u000ecwn]3Tk\u000e\u001cWm]:)\u0007\u0005\u001b\u0019#\u0001\fuKN$Hj\\4DY>\u001cX-\u00133f[B|G/\u001a8uQ\r\u001151E\u0001,i\u0016\u001cH\u000fT8h\u00072|7/\u001a$bS2,(/Z,iK:Le.T3n_JL()\u001e4gKJ\u001cEn\\:fI\"\u001a1ia\t\u0002)Q,7\u000f\u001e'pO\u000ecwn]3IC:$G.\u001a:tQ\r!51E\u0001\u001fi\u0016\u001cH\u000fT8h\u00072|7/\u001a%b]\u0012dWM]:JI\u0016l\u0007o\u001c;f]RD3!RB\u0012\u0003m!Xm\u001d;SK6|g/Z!oI\u0012+G.\u001a;f'\u0016<W.\u001a8ugR!\u00111BB/\u0011\u001d\u0019yF\u0012a\u0001\u0005?\n1\"Y:z]\u000e$U\r\\3uK\u0006yB/Z:u%\u0016lwN^3B]\u0012$U\r\\3uKN+w-\\3oiN\u001c\u0016P\\2)\u0007\u001d\u001b\u0019#\u0001\u0011uKN$(+Z7pm\u0016\fe\u000e\u001a#fY\u0016$XmU3h[\u0016tGo]!ts:\u001c\u0007f\u0001%\u0004$\u00051B/Z:u\t\u0016dW\r^3TK\u001elWM\u001c;GS2,7\u000f\u0006\u0003\u0002\f\r5\u0004bBB0\u0013\u0002\u0007!qL\u0001\u001bi\u0016\u001cH\u000fR3mKR,7+Z4nK:$h)\u001b7fgNKhn\u0019\u0015\u0004\u0015\u000e\r\u0012a\u0007;fgR$U\r\\3uKN+w-\\3oi\u001aKG.Z:Bgft7\rK\u0002L\u0007G\t1\u0004^3ti\u0012+G.\u001a;bE2,7+Z4nK:$8OR5mi\u0016\u0014\bf\u0001'\u0004$\u0005qB/Z:u\t\u0016dW\r^1cY\u0016\u001cVmZ7f]R\u001c\u0018\n^3sCRLwN\u001c\u0015\u0004\u001b\u000e\r\u0012A\u0007;fgR\u001c%/Z1uK\u0006sG\rR3mKR,7+Z4nK:$\bf\u0001(\u0004$\u0005YB/Z:u)J,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003RD3aTB\u0012\u00039!Xm\u001d;UeVt7-\u0019;f)>D3\u0001UB\u0012\u0003e!Xm\u001d;O_:\f5\r^5wKN+w-\\3oiN4%o\\7)\u0007E\u001b\u0019#\u0001\nu_BL7\rU1si&$\u0018n\u001c8OC6,GCBA`\u0007'\u001b9\nC\u0004\u0004\u0016J\u0003\r!a0\u0002\u000bQ|\u0007/[2\t\u000f\re%\u000b1\u0001\u0002@\u0006I\u0001/\u0019:uSRLwN\\\u0001\u001ci\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3)\u0007M\u001b\u0019#\u0001\u001buKN$\b+\u0019:tKR{\u0007/[2QCJ$\u0018\u000e^5p]:\u000bW.Z,ji\"\u0004VM]5pI\u001a{'\u000fR3mKR,G\rV8qS\u000eD3\u0001VB\u0012\u0003\u001d\"Xm\u001d;QCJ\u001cX\rV8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nK\u001a{'/R7qift\u0015-\\3)\u0007U\u001b\u0019#\u0001\u0012uKN$\b+\u0019:tKR{\u0007/[2QCJ$\u0018\u000e^5p]:\u000bW.\u001a$pe:+H\u000e\u001c\u0015\u0004-\u000e\r\u0012A\f;fgR\u0004\u0016M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lWMR8s\u001b&\u001c8/\u001b8h'\u0016\u0004\u0018M]1u_JD3aVB\u0012\u0003)\"Xm\u001d;QCJ\u001cX\rV8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nK\u001a{'/T5tg&tw\rV8qS\u000eD3\u0001WB\u0012\u00039\"Xm\u001d;QCJ\u001cX\rV8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nK\u001a{'/T5tg&tw\rU1si&$\u0018n\u001c8)\u0007e\u001b\u0019#\u0001\u0018uKN$\b+\u0019:tKR{\u0007/[2QCJ$\u0018\u000e^5p]:\u000bW.\u001a$pe&sg/\u00197jIB\u000b'\u000f^5uS>t\u0007f\u0001.\u0004$\u0005\u0001D/Z:u!\u0006\u00148/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c(b[\u00164uN]#ySN$\u0018N\\4J]Z\fG.\u001b3ESJD3aWB\u0012\u0003Q!Xm\u001d;M_\u001e$U\r\\3uK\u0012K'OT1nK\"\u001aAla\t\u0002%Q,7\u000f^(gMN,GO\u0012:p[\u001aKG.\u001a\u0015\u0004;\u000e\r\u0012\u0001\t;fgR\u0014v\u000e\u001c7TK\u001elWM\u001c;UQ\u0006$\u0018\t\u001c:fC\u0012LX\t_5tiND3AXB\u0012\u0003a!Xm\u001d;OK^\u001cVmZ7f]R\u001c\u0018I\u001a;feJ{G\u000e\u001c\u0015\u0004?\u000e\r\u0012a\u000b;fgR\u0014v\u000e\u001c7TK\u001elWM\u001c;FeJ|'o\u00165f]:+\u0007\u0010^(gMN,G/S:JY2,w-\u00197)\u0007\u0001\u001c\u0019#A\u0010de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$B#!\u001c\u0004X\u000em71]Bw\u0007c\u001c)pa@\u0005\u000e\u0011=\u0001\"CBmCB\u0005\t\u0019AA\u000e\u0003\r!\u0017N\u001d\u0005\u0007w\u0006\u0004\ra!8\u0011\u0007i\u001cy.C\u0002\u0004b.\u0014\u0011\u0002T8h\u0007>tg-[4\t\u0013\r\u0015\u0018\r%AA\u0002\r\u001d\u0018\u0001C:fO6,g\u000e^:\u0011\u0007i\u001cI/C\u0002\u0004l.\u00141\u0002T8h'\u0016<W.\u001a8ug\"I1q^1\u0011\u0002\u0003\u0007\u0011\u0011`\u0001\u000ee\u0016\u001cwN^3ssB{\u0017N\u001c;\t\u0013\rM\u0018\r%AA\u0002\tu\u0018A\u00058fqR|eMZ:fi6+G/\u00193bi\u0006D\u0011ba>b!\u0003\u0005\ra!?\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\b\u0003BA0\u0007wLAa!@\u0002b\tI1k\u00195fIVdWM\u001d\u0005\n\t\u0003\t\u0007\u0013!a\u0001\t\u0007\tA\u0001^5nKB!AQ\u0001C\u0005\u001b\t!9A\u0003\u0003\u0002d\u0005e\u0012\u0002\u0002C\u0006\t\u000f\u0011A\u0001V5nK\"I\u0011\u0011G1\u0011\u0002\u0003\u0007\u0011Q\u0007\u0005\n\u0003\u001b\n\u0007\u0013!a\u0001\u0003#\n\u0011f\u0019:fCR,Gj\\2bY2{wmV5uQ\u0006\u001bG/\u001b<f'\u0016<W.\u001a8uI\u0011,g-Y;mi\u0012\nTC\u0001C\u000bU\u0011\tYB!\u0002\u0002S\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\u001c'pO^KG\u000f[!di&4XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t!YB\u000b\u0003\u0004h\n\u0015\u0011!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$C'A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$H%N\u0001*GJ,\u0017\r^3M_\u000e\fG\u000eT8h/&$\b.Q2uSZ,7+Z4nK:$H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0011\u0015\"\u0006BB}\u0005\u000b\t\u0011f\u0019:fCR,Gj\\2bY2{wmV5uQ\u0006\u001bG/\u001b<f'\u0016<W.\u001a8uI\u0011,g-Y;mi\u0012:TC\u0001C\u0016U\u0011!\u0019A!\u0002\u0002S\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\u001c'pO^KG\u000f[!di&4XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t!\tD\u000b\u0003\u00026\t\u0015\u0011!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u00058)\"\u0011\u0011\u000bB\u0003\u0001")
public class LocalLogTest {
    private volatile LocalLogTest$KeyValue$ KeyValue$module;
    private KafkaConfig config;
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final TopicPartition topicPartition = new TopicPartition("test_topic", 1);
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
    private final MockTime mockTime = new MockTime();
    private final LocalLog log;

    public LocalLogTest$KeyValue$ KeyValue() {
        if (this.KeyValue$module == null) {
            this.KeyValue$lzycompute$1();
        }
        return this.KeyValue$module;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public LocalLog log() {
        return this.log;
    }

    @BeforeEach
    public void setUp() {
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var20_8 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var21_11 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var22_14 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "127.0.0.1:1", x$4, x$5, -1, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @AfterEach
    public void tearDown() {
        try {
            this.log().close();
        }
        catch (KafkaStorageException kafkaStorageException) {}
        Utils.delete((File)this.tmpDir());
    }

    private Iterable<SimpleRecord> kvsToRecords(Iterable<KeyValue> keyValues) {
        return (Iterable)keyValues.map((Function1 & Serializable)kv -> kv.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> kv.toRecord$default$1()));
    }

    private Iterable<KeyValue> recordsToKvs(Iterable<Record> records) {
        return (Iterable)records.map((Function1 & Serializable)r -> this.KeyValue().fromRecord((Record)r));
    }

    /*
     * WARNING - void declaration
     */
    private void appendRecords(Iterable<SimpleRecord> records, LocalLog log, long initialOffset) {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toList().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        boolean bl = false;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        Object var5_6 = null;
        simpleRecordArray = null;
        log.append(initialOffset + (long)records.size() - 1L, ((SimpleRecord)records.head()).timestamp(), initialOffset, MemoryRecords.withRecords((byte)2, (long)initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
    }

    private LocalLog appendRecords$default$2() {
        return this.log();
    }

    private long appendRecords$default$3() {
        return 0L;
    }

    private FetchDataInfo readRecords(LocalLog log, long startOffset, Function0<Object> maxLength, boolean minOneMessage, Function0<LogOffsetMetadata> maxOffsetMetadata, boolean includeAbortedTxns) {
        return log.read(startOffset, maxLength.apply$mcI$sp(), minOneMessage, (LogOffsetMetadata)maxOffsetMetadata.apply(), includeAbortedTxns);
    }

    private LocalLog readRecords$default$1() {
        return this.log();
    }

    private long readRecords$default$2() {
        return 0L;
    }

    private int readRecords$default$3() {
        return this.log().segments().activeSegment().size();
    }

    private boolean readRecords$default$4() {
        return false;
    }

    private LogOffsetMetadata readRecords$default$5() {
        return this.log().logEndOffsetMetadata();
    }

    private boolean readRecords$default$6() {
        return false;
    }

    @Test
    public void testLogDeleteSegmentsSuccess() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())));
        List segmentsBeforeDelete = (List)Nil$.MODULE$.$plus$plus((IterableOnce)this.log().segments().values());
        Iterable deletedSegments = this.log().deleteAllSegments();
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)segmentsBeforeDelete, (Object)deletedSegments);
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().checkIfMemoryMappedBufferClosed());
        Assertions.assertTrue((boolean)this.logDir().exists());
    }

    @Test
    public void testRollEmptyActiveSegment() {
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())));
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    @Test
    public void testLogDeleteDirSuccessWhenEmptyAndFailureWhenNonEmpty() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())));
        Assertions.assertThrows(IllegalStateException.class, () -> this.log().deleteEmptyDir());
        Assertions.assertTrue((boolean)this.logDir().exists());
        this.log().deleteAllSegments();
        this.log().deleteEmptyDir();
        Assertions.assertFalse((boolean)this.logDir().exists());
    }

    @Test
    public void testUpdateConfig() {
        LogConfig oldConfig = this.log().config();
        Assertions.assertEquals((Object)oldConfig, (Object)this.log().config());
        int x$1 = Predef$.MODULE$.Integer2int(oldConfig.segmentSize()) + 1;
        long x$2 = Defaults$.MODULE$.SegmentMs();
        long x$3 = Defaults$.MODULE$.RetentionMs();
        long x$4 = Defaults$.MODULE$.RetentionSize();
        long x$5 = Defaults$.MODULE$.SegmentJitterMs();
        String x$6 = Defaults$.MODULE$.CleanupPolicy();
        int x$7 = Defaults$.MODULE$.MaxMessageSize();
        int x$8 = Defaults$.MODULE$.IndexInterval();
        int x$9 = Defaults$.MODULE$.MaxIndexSize();
        long x$10 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig newConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        this.log().updateConfig(newConfig);
        Assertions.assertEquals((Object)newConfig, (Object)this.log().config());
    }

    @Test
    public void testLogDirRenameToNewDir() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        File newLogDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        Assertions.assertTrue((boolean)this.log().renameDir(newLogDir.getName()));
        Assertions.assertFalse((boolean)this.logDir().exists());
        Assertions.assertTrue((boolean)newLogDir.exists());
        Assertions.assertEquals((Object)newLogDir, (Object)this.log().dir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().parentDir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().dir().getParent());
        this.log().segments().values().foreach((Function1 & Serializable)segment -> {
            LocalLogTest.$anonfun$testLogDirRenameToNewDir$1(newLogDir, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
    }

    @Test
    public void testLogDirRenameToExistingDir() {
        Assertions.assertFalse((boolean)this.log().renameDir(this.log().dir().getName()));
    }

    @Test
    public void testLogFlush() {
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        this.log().flush(newSegment.baseOffset());
        this.log().markFlushed(newSegment.baseOffset());
        Assertions.assertEquals((long)1L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogAppend() {
        void readRecords_includeAbortedTxns;
        void readRecords_minOneMessage;
        void readRecords_startOffset;
        LocalLog x$2 = this.log();
        long x$3 = 0L;
        boolean x$4 = false;
        boolean x$6 = false;
        FetchDataInfo fetchDataInfoBeforeAppend = x$2.read(x$3, 1, x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfoBeforeAppend.records().records()).asScala().isEmpty());
        this.mockTime().sleep(1L);
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        boolean bl = false;
        boolean bl2 = false;
        long l = 0L;
        LocalLog readRecords_log = this.log();
        Object var9_10 = null;
        FetchDataInfo fetchDataInfo = readRecords_log.read((long)readRecords_startOffset, this.readRecords$default$3(), (boolean)readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records().records()).asScala().size());
        Assertions.assertEquals((Object)keyValues, this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records().records()).asScala()));
    }

    @Test
    public void testLogCloseSuccess() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().close();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseSuccess$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseIdempotent() {
        this.log().close();
        this.log().close();
    }

    @Test
    public void testLogCloseFailureWhenInMemoryBufferClosed() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().closeHandlers();
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().close());
    }

    @Test
    public void testLogCloseHandlers() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().closeHandlers();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseHandlers$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseHandlersIdempotent() {
        this.log().closeHandlers();
        this.log().closeHandlers();
    }

    private void testRemoveAndDeleteSegments(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testRemoveAndDeleteSegments$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        public class Kafka_log_LocalLogTest$TestDeletionReason$1
        implements SegmentDeletionReason {
            private Iterable<LogSegment> _deletedSegments;

            private Iterable<LogSegment> _deletedSegments() {
                return this._deletedSegments;
            }

            private void _deletedSegments_$eq(Iterable<LogSegment> x$1) {
                this._deletedSegments = x$1;
            }

            public void logReason(List<LogSegment> toDelete) {
                this._deletedSegments_$eq((Iterable<LogSegment>)((Iterable)Nil$.MODULE$.$plus$plus(toDelete)));
            }

            public Iterable<LogSegment> deletedSegments() {
                return this._deletedSegments();
            }

            public Kafka_log_LocalLogTest$TestDeletionReason$1(LocalLogTest $outer) {
                this._deletedSegments = Nil$.MODULE$;
            }
        }
        Kafka_log_LocalLogTest$TestDeletionReason$1 reason = new Kafka_log_LocalLogTest$TestDeletionReason$1(null);
        List toDelete = (List)Nil$.MODULE$.$plus$plus((IterableOnce)this.log().segments().values());
        this.log().removeAndDeleteSegments((Iterable)toDelete, asyncDelete, (SegmentDeletionReason)reason);
        if (asyncDelete) {
            this.mockTime().sleep(Predef$.MODULE$.Long2long(this.log().config().fileDeleteDelayMs()) + 1L);
        }
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)toDelete, reason.deletedSegments());
        toDelete.foreach((Function1 & Serializable)segment -> {
            LocalLogTest.$anonfun$testRemoveAndDeleteSegments$2(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRemoveAndDeleteSegmentsSync() {
        this.testRemoveAndDeleteSegments(false);
    }

    @Test
    public void testRemoveAndDeleteSegmentsAsync() {
        this.testRemoveAndDeleteSegments(true);
    }

    private void testDeleteSegmentFiles(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testDeleteSegmentFiles$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        List toDelete = (List)Nil$.MODULE$.$plus$plus((IterableOnce)this.log().segments().values());
        LocalLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable)toDelete, asyncDelete, this.log().dir(), this.log().topicPartition(), this.log().config(), this.log().scheduler(), this.log().logDirFailureChannel(), "");
        if (asyncDelete) {
            toDelete.foreach((Function1 & Serializable)segment -> {
                LocalLogTest.$anonfun$testDeleteSegmentFiles$2(segment);
                return BoxedUnit.UNIT;
            });
            this.mockTime().sleep(Predef$.MODULE$.Long2long(this.log().config().fileDeleteDelayMs()) + 1L);
        }
        toDelete.foreach((Function1 & Serializable)segment -> {
            LocalLogTest.$anonfun$testDeleteSegmentFiles$3(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDeleteSegmentFilesSync() {
        this.testDeleteSegmentFiles(false);
    }

    @Test
    public void testDeleteSegmentFilesAsync() {
        this.testDeleteSegmentFiles(true);
    }

    @Test
    public void testDeletableSegmentsFilter() {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testDeletableSegmentsFilter$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)10, (int)this.log().segments().numberOfSegments());
        Iterable deletable = this.log().deletableSegments((Function2 & Serializable)(segment, x$2) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$2(segment, x$2)));
        List expected = ((IterableOnceOps)this.log().segments().nonActiveLogSegmentsFrom(0L).filter((Function1 & Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$3(segment)))).toList();
        Assertions.assertEquals((int)6, (int)expected.length());
        Assertions.assertEquals((Object)expected, (Object)deletable.toList());
        Iterable deletable2 = this.log().deletableSegments((Function2 & Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$4(x$3, x$4)));
        List expected2 = this.log().segments().nonActiveLogSegmentsFrom(0L).toList();
        Assertions.assertEquals((int)9, (int)expected2.length());
        Assertions.assertEquals((Object)expected2, (Object)deletable2.toList());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$42 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        LocalLog x$62 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$42, x$62, 9L);
        Iterable deletable3 = this.log().deletableSegments((Function2 & Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$5(x$5, x$6)));
        List expected3 = this.log().segments().values().toList();
        Assertions.assertEquals((int)10, (int)expected3.length());
        Assertions.assertEquals((Object)expected3, (Object)deletable3.toList());
    }

    @Test
    public void testDeletableSegmentsIteration() {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testDeletableSegmentsIteration$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        IntRef offset2 = IntRef.create((int)0);
        Iterable deletableSegments = this.log().deletableSegments((Function2 & Serializable)(segment, nextSegmentOpt) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsIteration$2(this, offset2, segment, nextSegmentOpt)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)this.log().segments().nonActiveLogSegmentsFrom(0L).toSeq(), (Object)deletableSegments.toSeq());
    }

    @Test
    public void testCreateAndDeleteSegment() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        long newOffset = this.log().segments().activeSegment().baseOffset() + 1L;
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        LogSegment newActiveSegment = this.log().createAndDeleteSegment(newOffset, this.log().segments().activeSegment(), true, (SegmentDeletionReason)new LogTruncation(this.log()));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)newActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
        Assertions.assertEquals((long)newOffset, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)newOffset, (long)this.log().logEndOffset());
        LocalLog x$2 = this.log();
        boolean x$4 = false;
        boolean x$6 = false;
        FetchDataInfo fetchDataInfo = x$2.read(newOffset, this.readRecords$default$3(), x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records().records()).asScala().isEmpty());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testTruncateFullyAndStartAt$1(this, record, BoxesRunTime.unboxToInt((Object)offset)));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(8), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)offset -> {
            SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
            .colon.colon x$4 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
            long x$5 = offset;
            LocalLog x$6 = this.log();
            this.appendRecords((Iterable<SimpleRecord>)x$4, x$6, x$5);
        });
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        List expected = (List)Nil$.MODULE$.$plus$plus((IterableOnce)this.log().segments().values());
        Iterable deleted = this.log().truncateFullyAndStartAt(10L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)10L, (long)this.log().logEndOffset());
        LocalLog x$8 = this.log();
        boolean x$10 = false;
        boolean x$12 = false;
        long readRecords_startOffset = 10L;
        FetchDataInfo fetchDataInfo = x$8.read(readRecords_startOffset, this.readRecords$default$3(), x$10, this.readRecords$default$5(), x$12);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records().records()).asScala().isEmpty());
    }

    @Test
    public void testTruncateTo() {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 11).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testTruncateTo$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)12L, (long)this.log().logEndOffset());
        List expected = (List)Nil$.MODULE$.$plus$plus((IterableOnce)this.log().segments().values(9L, this.log().logEndOffset() + 1L));
        Iterable deleted = this.log().truncateTo(7L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)6L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)7L, (long)this.log().logEndOffset());
        LocalLog x$5 = this.log();
        boolean x$7 = false;
        boolean x$9 = false;
        long readRecords_startOffset = 6L;
        FetchDataInfo fetchDataInfo = x$5.read(readRecords_startOffset, this.readRecords$default$3(), x$7, this.readRecords$default$5(), x$9);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records().records()).asScala().size());
        Assertions.assertEquals((Object)new .colon.colon((Object)new KeyValue(this, "", "a"), (List)Nil$.MODULE$), this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records().records()).asScala()));
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$10 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        LocalLog x$12 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$10, x$12, 7L);
        Assertions.assertEquals((long)8L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNonActiveSegmentsFrom() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable)i -> LocalLogTest.$anonfun$testNonActiveSegmentsFrom$1(this, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)5L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5), (Object)this.nonActiveBaseOffsetsFrom$1(0L));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)this.nonActiveBaseOffsetsFrom$1(5L));
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(2), 5), (Object)this.nonActiveBaseOffsetsFrom$1(2L));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)this.nonActiveBaseOffsetsFrom$1(6L));
    }

    private String topicPartitionName(String topic, String partition) {
        return new StringBuilder(1).append(topic).append("-").append(partition).toString();
    }

    @Test
    public void testParseTopicPartitionName() {
        String topic = "test_topic";
        String partition = "143";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic());
        Assertions.assertEquals((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)), (int)topicPartition.partition());
    }

    @Test
    public void testParseTopicPartitionNameWithPeriodForDeletedTopic() {
        String topic = "foo.bar-testtopic";
        String partition = "42";
        File dir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)))));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic(), (String)"Unexpected topic name parsed");
        Assertions.assertEquals((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)), (int)topicPartition.partition(), (String)"Unexpected partition number parsed");
    }

    @Test
    public void testParseTopicPartitionNameForEmptyName() {
        File dir = new File("");
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForNull() {
        Assertions.assertThrows(KafkaException.class, () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$1(null), () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$2(null));
    }

    @Test
    public void testParseTopicPartitionNameForMissingSeparator() {
        String topic = "test_topic";
        String partition = "1999";
        File dir = new File(this.logDir(), new StringBuilder(0).append(topic).append(partition).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingTopic() {
        String topic = "";
        String partition = "1999";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)))));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingPartition() {
        String topic = "test_topic";
        String partition = "";
        File dir = new File(new StringBuilder(0).append(this.logDir().getPath()).append(this.topicPartitionName(topic, partition)).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(this.topicPartitionName(topic, partition)).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForInvalidPartition() {
        String topic = "test_topic";
        String partition = "1999a";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForExistingInvalidDir() {
        File dir1 = new File(new StringBuilder(14).append(this.logDir().getPath()).append("/non_kafka_dir").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir1), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir1.getCanonicalPath()).toString());
        File dir2 = new File(new StringBuilder(21).append(this.logDir().getPath()).append("/non_kafka_dir-delete").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir2), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir2.getCanonicalPath()).toString());
    }

    @Test
    public void testLogDeleteDirName() {
        String name1 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition("foo", 3));
        Assertions.assertTrue((name1.length() <= 255 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("foo-3\\.[0-9a-z]{32}-delete").matcher(name1).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name1).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name1).matches());
        String name2 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(new StringBuilder(1).append("n").append(String.join((CharSequence)"", Collections.nCopies(248, "o"))).toString(), 5));
        Assertions.assertEquals((int)255, (int)name2.length());
        Assertions.assertTrue((boolean)Pattern.compile("n[o]{212}-5\\.[0-9a-z]{32}-delete").matcher(name2).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name2).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name2).matches());
    }

    @Test
    public void testOffsetFromFile() {
        long offset = 23423423L;
        File logFile = LocalLog$.MODULE$.logFile(this.tmpDir(), offset, "");
        Assertions.assertEquals((long)offset, (long)LocalLog$.MODULE$.offsetFromFile(logFile));
        File offsetIndexFile = LocalLog$.MODULE$.offsetIndexFile(this.tmpDir(), offset, "");
        Assertions.assertEquals((long)offset, (long)LocalLog$.MODULE$.offsetFromFile(offsetIndexFile));
        File timeIndexFile = LocalLog$.MODULE$.timeIndexFile(this.tmpDir(), offset, "");
        Assertions.assertEquals((long)offset, (long)LocalLog$.MODULE$.offsetFromFile(timeIndexFile));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRollSegmentThatAlreadyExists() {
        void readRecords_includeAbortedTxns;
        void readRecords_minOneMessage;
        void readRecords_startOffset;
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Expect 1 segment after roll() empty segment with base offset.");
        .colon.colon keyValues1 = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)Nil$.MODULE$);
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues1), this.log(), 0L);
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        .colon.colon keyValues2 = new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)Nil$.MODULE$);
        List x$1 = keyValues2.map((Function1 & Serializable)x$8 -> x$8.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> this.mockTime().milliseconds() + 10L));
        LocalLog x$3 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, 1L);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        boolean bl = false;
        boolean bl2 = false;
        long l = 0L;
        LocalLog readRecords_log = this.log();
        Object var6_8 = null;
        FetchDataInfo readResult = readRecords_log.read((long)readRecords_startOffset, this.readRecords$default$3(), (boolean)readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)CollectionConverters$.MODULE$.IterableHasAsScala(readResult.records().records()).asScala().size());
        Assertions.assertEquals((Object)keyValues1.$plus$plus((IterableOnce)keyValues2), this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(readResult.records().records()).asScala()));
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)2L, (long)this.log().segments().activeSegment().baseOffset(), (String)"Expect base offset of active segment to be LEO");
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments(), (String)"Expect two segments.");
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNewSegmentsAfterRoll() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)0L, (long)newSegment.baseOffset());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)0L, (long)this.log().logEndOffset());
        KeyValue qual$1 = new KeyValue(this, "k1", "v1");
        JFunction0.mcJ.sp & Serializable x$1 = (JFunction0.mcJ.sp & Serializable)() -> qual$1.toRecord$default$1();
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)qual$1.toRecord((Function0<Object>)x$1), (List)Nil$.MODULE$), this.log(), 0L);
        LogSegment newSegment2 = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)1L, (long)newSegment2.baseOffset());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)1L, (long)this.log().logEndOffset());
        KeyValue qual$2 = new KeyValue(this, "k2", "v2");
        JFunction0.mcJ.sp & Serializable x$2 = (JFunction0.mcJ.sp & Serializable)() -> qual$2.toRecord$default$1();
        .colon.colon x$3 = new .colon.colon((Object)qual$2.toRecord((Function0<Object>)x$2), (List)Nil$.MODULE$);
        LocalLog x$5 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$3, x$5, 1L);
        LogSegment newSegment3 = this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertEquals((long)2L, (long)newSegment3.baseOffset());
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testRollSegmentErrorWhenNextOffsetIsIllegal() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)new .colon.colon((Object)new KeyValue(this, "k3", "v3"), (List)Nil$.MODULE$)));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)3L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)3L, (long)this.log().segments().activeSegment().baseOffset());
        this.log().updateLogEndOffset(1L);
        Assertions.assertThrows(KafkaException.class, () -> this.log().roll(this.log().roll$default$1()));
    }

    private LocalLog createLocalLogWithActiveSegment(File dir, LogConfig config, LogSegments segments, long recoveryPoint, LogOffsetMetadata nextOffsetMetadata, Scheduler scheduler, Time time, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel) {
        int x$5 = config.initFileSize();
        boolean x$6 = Predef$.MODULE$.Boolean2boolean(config.preallocate());
        boolean x$7 = false;
        String x$8 = "";
        segments.add(LogSegment$.MODULE$.open(dir, 0L, config, time, x$7, x$5, x$6, x$8));
        return new LocalLog(dir, config, segments, recoveryPoint, nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel);
    }

    private File createLocalLogWithActiveSegment$default$1() {
        return this.logDir();
    }

    private LogSegments createLocalLogWithActiveSegment$default$3() {
        return new LogSegments(this.topicPartition());
    }

    private long createLocalLogWithActiveSegment$default$4() {
        return 0L;
    }

    private LogOffsetMetadata createLocalLogWithActiveSegment$default$5() {
        return new LogOffsetMetadata(0L, 0L, 0);
    }

    private Scheduler createLocalLogWithActiveSegment$default$6() {
        return this.mockTime().scheduler();
    }

    private Time createLocalLogWithActiveSegment$default$7() {
        return this.mockTime();
    }

    private TopicPartition createLocalLogWithActiveSegment$default$8() {
        return this.topicPartition();
    }

    private LogDirFailureChannel createLocalLogWithActiveSegment$default$9() {
        return this.logDirFailureChannel();
    }

    private final void KeyValue$lzycompute$1() {
        synchronized (this) {
            if (this.KeyValue$module == null) {
                this.KeyValue$module = new LocalLogTest$KeyValue$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testLogDirRenameToNewDir$1(File newLogDir$1, LogSegment segment) {
        Assertions.assertEquals((Object)newLogDir$1.getPath(), (Object)segment.log().file().getParentFile().getPath());
    }

    public static final /* synthetic */ int $anonfun$testLogAppend$1() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$testLogCloseSuccess$1(LocalLogTest $this, Seq keyValues$1) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$1);
        LocalLog x$3 = $this.log();
        $this.appendRecords(x$1, x$3, 2L);
    }

    public static final /* synthetic */ void $anonfun$testLogCloseHandlers$1(LocalLogTest $this, Seq keyValues$2) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$2);
        LocalLog x$3 = $this.log();
        $this.appendRecords(x$1, x$3, 2L);
    }

    public static final /* synthetic */ LogSegment $anonfun$testRemoveAndDeleteSegments$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testRemoveAndDeleteSegments$2(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeleteSegmentFiles$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$2(LogSegment segment) {
        Assertions.assertFalse((boolean)segment.deleted());
        Assertions.assertTrue((boolean)segment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$3(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeletableSegmentsFilter$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$2(LogSegment segment, Option x$2) {
        return segment.baseOffset() <= 5L;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$3(LogSegment segment) {
        return segment.baseOffset() <= 5L;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$4(LogSegment x$3, Option x$4) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$5(LogSegment x$5, Option x$6) {
        return true;
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeletableSegmentsIteration$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsIteration$2(LocalLogTest $this, IntRef offset$1, LogSegment segment, Option nextSegmentOpt) {
        Assertions.assertEquals((long)offset$1.elem, (long)segment.baseOffset());
        Option floorSegmentOpt = $this.log().segments().floorSegment((long)offset$1.elem);
        Assertions.assertTrue((boolean)floorSegmentOpt.isDefined());
        Assertions.assertEquals((Object)floorSegmentOpt.get(), (Object)segment);
        if ((long)offset$1.elem == $this.log().logEndOffset()) {
            Assertions.assertFalse((boolean)nextSegmentOpt.isDefined());
        } else {
            Assertions.assertTrue((boolean)nextSegmentOpt.isDefined());
            Option higherSegmentOpt = $this.log().segments().higherSegment(segment.baseOffset());
            Assertions.assertTrue((boolean)higherSegmentOpt.isDefined());
            Assertions.assertEquals((long)(segment.baseOffset() + 1L), (long)((LogSegment)higherSegmentOpt.get()).baseOffset());
            Assertions.assertEquals((Object)higherSegmentOpt.get(), (Object)nextSegmentOpt.get());
        }
        ++offset$1.elem;
        return true;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyAndStartAt$1(LocalLogTest $this, SimpleRecord record$1, int offset) {
        .colon.colon x$1 = new .colon.colon((Object)record$1, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 2 != 0) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateTo$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 3 == 2) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LogSegment $anonfun$testNonActiveSegmentsFrom$1(LocalLogTest $this, int i) {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue($this, Integer.toString(i), Integer.toString(i)), (List)Nil$.MODULE$);
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues);
        long x$2 = i;
        LocalLog x$3 = $this.log();
        $this.appendRecords(x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    private final Seq nonActiveBaseOffsetsFrom$1(long startOffset) {
        return ((IterableOnceOps)this.log().segments().nonActiveLogSegmentsFrom(startOffset).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.baseOffset()))).toSeq();
    }

    public static final /* synthetic */ void $anonfun$testParseTopicPartitionNameForNull$1(File dir$2) {
        LocalLog$.MODULE$.parseTopicPartitionName(dir$2);
    }

    public static final /* synthetic */ String $anonfun$testParseTopicPartitionNameForNull$2(File dir$2) {
        return new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir$2).toString();
    }

    public LocalLogTest() {
        LogConfig x$1 = LogTestUtils$.MODULE$.createLogConfig(Defaults$.MODULE$.SegmentMs(), Defaults$.MODULE$.SegmentSize(), Defaults$.MODULE$.RetentionMs(), Defaults$.MODULE$.RetentionSize(), Defaults$.MODULE$.SegmentJitterMs(), Defaults$.MODULE$.CleanupPolicy(), Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.IndexInterval(), Defaults$.MODULE$.MaxIndexSize(), Defaults$.MODULE$.FileDeleteDelayMs());
        File x$2 = this.logDir();
        LogSegments x$3 = this.createLocalLogWithActiveSegment$default$3();
        long x$4 = 0L;
        LogOffsetMetadata x$5 = this.createLocalLogWithActiveSegment$default$5();
        Scheduler x$6 = this.createLocalLogWithActiveSegment$default$6();
        MockTime x$7 = this.mockTime();
        TopicPartition x$8 = this.topicPartition();
        LogDirFailureChannel x$9 = this.logDirFailureChannel();
        this.log = this.createLocalLogWithActiveSegment(x$2, x$1, x$3, x$4, x$5, x$6, (Time)x$7, x$8, x$9);
    }

    public class KeyValue
    implements Product,
    Serializable {
        private final String key;
        private final String value;
        public final /* synthetic */ LocalLogTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public SimpleRecord toRecord(Function0<Object> timestamp) {
            return new SimpleRecord(timestamp.apply$mcJ$sp(), this.key().getBytes(), this.value().getBytes());
        }

        public long toRecord$default$1() {
            return this.kafka$log$LocalLogTest$KeyValue$$$outer().mockTime().milliseconds();
        }

        public KeyValue copy(String key, String value) {
            return new KeyValue(this.kafka$log$LocalLogTest$KeyValue$$$outer(), key, value);
        }

        public String copy$default$1() {
            return this.key();
        }

        public String copy$default$2() {
            return this.value();
        }

        public String productPrefix() {
            return "KeyValue";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.key();
                }
                case 1: {
                    return this.value();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyValue;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "value";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof KeyValue && ((KeyValue)x$1).kafka$log$LocalLogTest$KeyValue$$$outer() == this.kafka$log$LocalLogTest$KeyValue$$$outer())) break block3;
                    KeyValue keyValue = (KeyValue)x$1;
                    String string = this.key();
                    String string2 = keyValue.key();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    String string3 = this.value();
                    String string4 = keyValue.value();
                    if ((string3 != null ? !string3.equals(string4) : string4 != null) || !keyValue.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LocalLogTest kafka$log$LocalLogTest$KeyValue$$$outer() {
            return this.$outer;
        }

        public KeyValue(LocalLogTest $outer, String key, String value) {
            this.key = key;
            this.value = value;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

