/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import kafka.network.RequestChannel;
import kafka.raft.RaftManager;
import kafka.server.AclApis;
import kafka.server.ApiRequestHandler;
import kafka.server.ApiVersionManager;
import kafka.server.AuthHelper;
import kafka.server.EnvelopeUtils$;
import kafka.server.KafkaConfig;
import kafka.server.MetaProperties;
import kafka.server.QuotaFactory;
import kafka.server.RequestHandlerHelper;
import kafka.server.RequestLocal;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.SaslAuthenticateResponseData;
import org.apache.kafka.common.message.SaslHandshakeResponseData;
import org.apache.kafka.common.message.UnregisterBrokerResponseData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.ElectLeadersResponse;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.ListPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.SaslAuthenticateResponse;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.UnregisterBrokerRequest;
import org.apache.kafka.common.requests.UnregisterBrokerResponse;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r%f\u0001B\u001f?\u0001\rC\u0001\u0002\u0016\u0001\u0003\u0006\u0004%\t!\u0016\u0005\t9\u0002\u0011\t\u0011)A\u0005-\"AQ\f\u0001BC\u0002\u0013\u0005a\f\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003`\u0011!q\u0007A!b\u0001\n\u0003y\u0007\u0002\u0003@\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0013}\u0004!Q1A\u0005\u0002\u0005\u0005\u0001BCA\t\u0001\t\u0005\t\u0015!\u0003\u0002\u0004!Q\u00111\u0003\u0001\u0003\u0006\u0004%\t!!\u0006\t\u0015\u0005\u0005\u0002A!A!\u0002\u0013\t9\u0002\u0003\u0006\u0002$\u0001\u0011)\u0019!C\u0001\u0003KA!\"!\u0010\u0001\u0005\u0003\u0005\u000b\u0011BA\u0014\u0011)\ty\u0004\u0001BC\u0002\u0013\u0005\u0011\u0011\t\u0005\u000b\u0003\u0013\u0002!\u0011!Q\u0001\n\u0005\r\u0003BCA&\u0001\t\u0015\r\u0011\"\u0001\u0002N!Q\u0011Q\u000b\u0001\u0003\u0002\u0003\u0006I!a\u0014\t\u0015\u0005]\u0003A!b\u0001\n\u0003\tI\u0006\u0003\u0006\u0002v\u0001\u0011\t\u0011)A\u0005\u00037B!\"a\u001e\u0001\u0005\u000b\u0007I\u0011AA=\u0011)\t\t\t\u0001B\u0001B\u0003%\u00111\u0010\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011%\ti\n\u0001b\u0001\n\u0003\ty\n\u0003\u0005\u0002(\u0002\u0001\u000b\u0011BAQ\u0011%\tI\u000b\u0001b\u0001\n\u0003\tY\u000b\u0003\u0005\u00024\u0002\u0001\u000b\u0011BAW\u0011%\t)\f\u0001b\u0001\n\u0013\t9\f\u0003\u0005\u0002@\u0002\u0001\u000b\u0011BA]\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007Dq!a3\u0001\t\u0003\ti\rC\u0004\u0002V\u0002!\t%a6\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9!\u0011\u0003\u0001\u0005\u0002\tM\u0001b\u0002B\f\u0001\u0011\u0005!\u0011\u0004\u0005\b\u0005;\u0001A\u0011\u0001B\u0010\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0005KAqA!\u000b\u0001\t\u0003\u0011Y\u0003C\u0004\u00030\u0001!\tA!\r\t\u000f\t=\u0006\u0001\"\u0001\u00032\"9!Q\u0017\u0001\u0005\u0002\t]\u0006b\u0002Bj\u0001\u0011\u0005!Q\u001b\u0005\b\u00053\u0004A\u0011\u0001Bn\u0011\u001d\u0019\t\u0001\u0001C\u0001\u0007\u0007Aqaa\u0002\u0001\t\u0003\u0019I\u0001C\u0004\u0004\u000e\u0001!\taa\u0004\t\u000f\rM\u0001\u0001\"\u0001\u0004\u0016!91\u0011\u0004\u0001\u0005\u0002\rm\u0001bBB\u0010\u0001\u0011\u00051\u0011\u0005\u0005\b\u0007K\u0001A\u0011AB\u0014\u0011\u001d\u0019Y\u0003\u0001C\u0001\u0007[Aqa!\r\u0001\t\u0003\u0019\u0019\u0004C\u0004\u00048\u0001!\ta!\u000f\t\u000f\ru\u0002\u0001\"\u0003\u0004@!911\f\u0001\u0005\u0002\ru\u0003bBB1\u0001\u0011\u000511\r\u0005\b\u0007O\u0002A\u0011AB5\u0011\u001d\u0019i\u0007\u0001C\u0001\u0007_Bqa!%\u0001\t\u0003\u0019\u0019\nC\u0004\u0004\u0018\u0002!\ta!'\t\u000f\ru\u0005\u0001\"\u0001\u0004 \"911\u0015\u0001\u0005\u0002\r\u0015&AD\"p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018n\u001d\u0006\u0003\u007f\u0001\u000baa]3sm\u0016\u0014(\"A!\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0012&O!\t)\u0005*D\u0001G\u0015\u00059\u0015!B:dC2\f\u0017BA%G\u0005\u0019\te.\u001f*fMB\u00111\nT\u0007\u0002}%\u0011QJ\u0010\u0002\u0012\u0003BL'+Z9vKN$\b*\u00198eY\u0016\u0014\bCA(S\u001b\u0005\u0001&BA)A\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0006KA\u0004M_\u001e<\u0017N\\4\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYV\ta\u000b\u0005\u0002X56\t\u0001L\u0003\u0002Z\u0001\u00069a.\u001a;x_J\\\u0017BA.Y\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\fqB]3rk\u0016\u001cHo\u00115b]:,G\u000eI\u0001\u000bCV$\bn\u001c:ju\u0016\u0014X#A0\u0011\u0007\u0015\u0003'-\u0003\u0002b\r\n1q\n\u001d;j_:\u0004\"aY6\u000e\u0003\u0011T!!X3\u000b\u0005}2'BA!h\u0015\tA\u0017.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0006\u0019qN]4\n\u00051$'AC!vi\"|'/\u001b>fe\u0006Y\u0011-\u001e;i_JL'0\u001a:!\u0003\u0019\tXo\u001c;bgV\t\u0001\u000f\u0005\u0002rw:\u0011!/\u001f\b\u0003gbt!\u0001^<\u000e\u0003UT!A\u001e\"\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0015BA A\u0013\tQh(\u0001\u0007Rk>$\u0018MR1di>\u0014\u00180\u0003\u0002}{\ni\u0011+^8uC6\u000bg.Y4feNT!A\u001f \u0002\u000fE,x\u000e^1tA\u0005!A/[7f+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u00055QBAA\u0004\u0015\r\t\u0016\u0011\u0002\u0006\u0004\u0003\u00171\u0017AB2p[6|g.\u0003\u0003\u0002\u0010\u0005\u001d!\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\n!bY8oiJ|G\u000e\\3s+\t\t9\u0002\u0005\u0003\u0002\u001a\u0005uQBAA\u000e\u0015\r\t\u0019BZ\u0005\u0005\u0003?\tYB\u0001\u0006D_:$(o\u001c7mKJ\f1bY8oiJ|G\u000e\\3sA\u0005Y!/\u00194u\u001b\u0006t\u0017mZ3s+\t\t9\u0003\u0005\u0004\u0002*\u0005=\u00121G\u0007\u0003\u0003WQ1!!\fA\u0003\u0011\u0011\u0018M\u001a;\n\t\u0005E\u00121\u0006\u0002\f%\u00064G/T1oC\u001e,'\u000f\u0005\u0003\u00026\u0005eRBAA\u001c\u0015\r\tY!Z\u0005\u0005\u0003w\t9D\u0001\u000bBa&lUm]:bO\u0016\fe\u000e\u001a,feNLwN\\\u0001\re\u00064G/T1oC\u001e,'\u000fI\u0001\u0007G>tg-[4\u0016\u0005\u0005\r\u0003cA&\u0002F%\u0019\u0011q\t \u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u00039iW\r^1Qe>\u0004XM\u001d;jKN,\"!a\u0014\u0011\u0007-\u000b\t&C\u0002\u0002Ty\u0012a\"T3uCB\u0013x\u000e]3si&,7/A\bnKR\f\u0007K]8qKJ$\u0018.Z:!\u0003=\u0019wN\u001c;s_2dWM\u001d(pI\u0016\u001cXCAA.!\u0019\ti&a\u001a\u0002n9!\u0011qLA2\u001d\r!\u0018\u0011M\u0005\u0002\u000f&\u0019\u0011Q\r$\u0002\u000fA\f7m[1hK&!\u0011\u0011NA6\u0005\r\u0019V-\u001d\u0006\u0004\u0003K2\u0005\u0003BA8\u0003cj!!!\u0003\n\t\u0005M\u0014\u0011\u0002\u0002\u0005\u001d>$W-\u0001\td_:$(o\u001c7mKJtu\u000eZ3tA\u0005\t\u0012\r]5WKJ\u001c\u0018n\u001c8NC:\fw-\u001a:\u0016\u0005\u0005m\u0004cA&\u0002~%\u0019\u0011q\u0010 \u0003#\u0005\u0003\u0018NV3sg&|g.T1oC\u001e,'/\u0001\nba&4VM]:j_:l\u0015M\\1hKJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\f\u0002\b\u0006%\u00151RAG\u0003\u001f\u000b\t*a%\u0002\u0016\u0006]\u0015\u0011TAN!\tY\u0005\u0001C\u0003U+\u0001\u0007a\u000bC\u0003^+\u0001\u0007q\fC\u0003o+\u0001\u0007\u0001\u000f\u0003\u0004\u0000+\u0001\u0007\u00111\u0001\u0005\b\u0003')\u0002\u0019AA\f\u0011\u001d\t\u0019#\u0006a\u0001\u0003OAq!a\u0010\u0016\u0001\u0004\t\u0019\u0005C\u0004\u0002LU\u0001\r!a\u0014\t\u000f\u0005]S\u00031\u0001\u0002\\!9\u0011qO\u000bA\u0002\u0005m\u0014AC1vi\"DU\r\u001c9feV\u0011\u0011\u0011\u0015\t\u0004\u0017\u0006\r\u0016bAAS}\tQ\u0011)\u001e;i\u0011\u0016d\u0007/\u001a:\u0002\u0017\u0005,H\u000f\u001b%fYB,'\u000fI\u0001\u000ee\u0016\fX/Z:u\u0011\u0016d\u0007/\u001a:\u0016\u0005\u00055\u0006cA&\u00020&\u0019\u0011\u0011\u0017 \u0003)I+\u0017/^3ti\"\u000bg\u000e\u001a7fe\"+G\u000e]3s\u00039\u0011X-];fgRDU\r\u001c9fe\u0002\nq!Y2m\u0003BL7/\u0006\u0002\u0002:B\u00191*a/\n\u0007\u0005ufHA\u0004BG2\f\u0005/[:\u0002\u0011\u0005\u001cG.\u00119jg\u0002\n\u0001\"[:DY>\u001cX\rZ\u000b\u0003\u0003\u000b\u00042!RAd\u0013\r\tIM\u0012\u0002\b\u0005>|G.Z1o\u0003\u0015\u0019Gn\\:f)\t\ty\rE\u0002F\u0003#L1!a5G\u0005\u0011)f.\u001b;\u0002\r!\fg\u000e\u001a7f)\u0019\ty-!7\u0002l\"9\u00111\u001c\u0010A\u0002\u0005u\u0017a\u0002:fcV,7\u000f\u001e\t\u0005\u0003?\f)OD\u0002X\u0003CL1!a9Y\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2LA!a:\u0002j\n9!+Z9vKN$(bAAr1\"9\u0011Q\u001e\u0010A\u0002\u0005=\u0018\u0001\u0004:fcV,7\u000f\u001e'pG\u0006d\u0007cA&\u0002r&\u0019\u00111\u001f \u0003\u0019I+\u0017/^3ti2{7-\u00197\u0002+!\fg\u000e\u001a7f\u000b:4X\r\\8qKJ+\u0017/^3tiR1\u0011\u0011 B\u0007\u0005\u001f\u0001b!a?\u0003\n\u0005=WBAA\u007f\u0015\u0011\tyP!\u0001\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0003\u0004\t\u0015\u0011\u0001B;uS2T!Aa\u0002\u0002\t)\fg/Y\u0005\u0005\u0005\u0017\tiPA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016Dq!a7 \u0001\u0004\ti\u000eC\u0004\u0002n~\u0001\r!a<\u00025!\fg\u000e\u001a7f'\u0006\u001cH\u000eS1oIND\u0017m[3SKF,Xm\u001d;\u0015\t\u0005e(Q\u0003\u0005\b\u00037\u0004\u0003\u0019AAo\u0003uA\u0017M\u001c3mKN\u000b7\u000f\\!vi\",g\u000e^5dCR,'+Z9vKN$H\u0003BA}\u00057Aq!a7\"\u0001\u0004\ti.A\u0006iC:$G.\u001a$fi\u000eDG\u0003BA}\u0005CAq!a7#\u0001\u0004\ti.A\niC:$G.\u001a$fi\u000eD7K\\1qg\"|G\u000f\u0006\u0003\u0002z\n\u001d\u0002bBAnG\u0001\u0007\u0011Q\\\u0001\u0013Q\u0006tG\r\\3EK2,G/\u001a+pa&\u001c7\u000f\u0006\u0003\u0002z\n5\u0002bBAnI\u0001\u0007\u0011Q\\\u0001\rI\u0016dW\r^3U_BL7m\u001d\u000b\u000f\u0005g\u0011\u0019G!\u001c\u0003x\t\u0005%Q\u0011BV!\u0019\tYP!\u0003\u00036A1!q\u0007B\u001d\u0005{i!A!\u0001\n\t\tm\"\u0011\u0001\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0003@\tuc\u0002\u0002B!\u0005/rAAa\u0011\u0003T9!!Q\tB)\u001d\u0011\u00119Ea\u0014\u000f\t\t%#Q\n\b\u0004i\n-\u0013\"\u00016\n\u0005!L\u0017BA!h\u0013\r\tYAZ\u0005\u0005\u0005+\nI!A\u0004nKN\u001c\u0018mZ3\n\t\te#1L\u0001\u0019\t\u0016dW\r^3U_BL7m\u001d*fgB|gn]3ECR\f'\u0002\u0002B+\u0003\u0013IAAa\u0018\u0003b\t!B)\u001a7fi\u0006\u0014G.\u001a+pa&\u001c'+Z:vYRTAA!\u0017\u0003\\!9!QM\u0013A\u0002\t\u001d\u0014aB2p]R,\u0007\u0010\u001e\t\u0005\u00033\u0011I'\u0003\u0003\u0003l\u0005m!\u0001G\"p]R\u0014x\u000e\u001c7feJ+\u0017/^3ti\u000e{g\u000e^3yi\"9\u00111\\\u0013A\u0002\t=\u0004\u0003\u0002B9\u0005gj!Aa\u0017\n\t\tU$1\f\u0002\u0018\t\u0016dW\r^3U_BL7m\u001d*fcV,7\u000f\u001e#bi\u0006DqA!\u001f&\u0001\u0004\u0011Y(\u0001\u0006ba&4VM]:j_:\u00042!\u0012B?\u0013\r\u0011yH\u0012\u0002\u0004\u0013:$\bb\u0002BBK\u0001\u0007\u0011QY\u0001\u000fQ\u0006\u001c8\t\\;ti\u0016\u0014\u0018)\u001e;i\u0011\u001d\u00119)\na\u0001\u0005\u0013\u000bAcZ3u\t\u0016\u001c8M]5cC\ndW\rV8qS\u000e\u001c\bcB#\u0003\f\n=%QU\u0005\u0004\u0005\u001b3%!\u0003$v]\u000e$\u0018n\u001c82!\u0019\tiF!%\u0003\u0016&!!1SA6\u0005!IE/\u001a:bE2,\u0007\u0003\u0002BL\u0005?sAA!'\u0003\u001cB\u0011AOR\u0005\u0004\u0005;3\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0003\"\n\r&AB*ue&twMC\u0002\u0003\u001e\u001a\u0003bAa&\u0003(\nU\u0015\u0002\u0002BU\u0005G\u00131aU3u\u0011\u001d\u0011i+\na\u0001\u0005\u0013\u000b!cZ3u\t\u0016dW\r^1cY\u0016$v\u000e]5dg\u0006\u0011\u0002.\u00198eY\u0016\u001c%/Z1uKR{\u0007/[2t)\u0011\tIPa-\t\u000f\u0005mg\u00051\u0001\u0002^\u0006a1M]3bi\u0016$v\u000e]5dgRa!\u0011\u0018Ba\u0005\u0007\u0014YM!4\u0003RB1\u00111 B\u0005\u0005w\u0003BA!\u001d\u0003>&!!q\u0018B.\u0005a\u0019%/Z1uKR{\u0007/[2t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\b\u0005K:\u0003\u0019\u0001B4\u0011\u001d\tYn\na\u0001\u0005\u000b\u0004BA!\u001d\u0003H&!!\u0011\u001aB.\u0005]\u0019%/Z1uKR{\u0007/[2t%\u0016\fX/Z:u\t\u0006$\u0018\rC\u0004\u0003\u0004\u001e\u0002\r!!2\t\u000f\t=w\u00051\u0001\u0003\n\u0006\u0011r-\u001a;De\u0016\fG/\u00192mKR{\u0007/[2t\u0011\u001d\u00119i\na\u0001\u0005\u0013\u000b\u0001\u0004[1oI2,\u0017\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\u0011\tIPa6\t\u000f\u0005m\u0007\u00061\u0001\u0002^\u00061\u0012-\u001e;i_JL'0Z!mi\u0016\u0014(+Z:pkJ\u001cW\r\u0006\u0004\u0003^\n%(1\u001f\t\u0005\u0005?\u0014)/\u0004\u0002\u0003b*!!1]A\u0005\u0003!\u0011X-];fgR\u001c\u0018\u0002\u0002Bt\u0005C\u0014\u0001\"\u00119j\u000bJ\u0014xN\u001d\u0005\b\u0005WL\u0003\u0019\u0001Bw\u00039\u0011X-];fgR\u001cuN\u001c;fqR\u0004BAa8\u0003p&!!\u0011\u001fBq\u00059\u0011V-];fgR\u001cuN\u001c;fqRDqA!>*\u0001\u0004\u001190\u0001\u0005sKN|WO]2f!\u0011\u0011IP!@\u000e\u0005\tm(\u0002BA \u0003\u0013IAAa@\u0003|\nq1i\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0017\u0001\u00075b]\u0012dW\rT3hC\u000eL\u0018\t\u001c;fe\u000e{gNZ5hgR!\u0011\u0011`B\u0003\u0011\u001d\tYN\u000ba\u0001\u0003;\f!\u0002[1oI2,gk\u001c;f)\u0011\tIpa\u0003\t\u000f\u0005m7\u00061\u0001\u0002^\u00061\u0002.\u00198eY\u0016\u0014UmZ5o#V|'/^7Fa>\u001c\u0007\u000e\u0006\u0003\u0002z\u000eE\u0001bBAnY\u0001\u0007\u0011Q\\\u0001\u0015Q\u0006tG\r\\3F]\u0012\fVo\u001c:v[\u0016\u0003xn\u00195\u0015\t\u0005e8q\u0003\u0005\b\u00037l\u0003\u0019AAo\u0003QA\u0017M\u001c3mK\u0012+7o\u0019:jE\u0016\fVo\u001c:v[R!\u0011\u0011`B\u000f\u0011\u001d\tYN\fa\u0001\u0003;\f!\u0003[1oI2,W\t\\3di2+\u0017\rZ3sgR!\u0011\u0011`B\u0012\u0011\u001d\tYn\fa\u0001\u0003;\f1\u0004[1oI2,\u0017\t\u001c;feB\u000b'\u000f^5uS>t'+Z9vKN$H\u0003BA}\u0007SAq!a71\u0001\u0004\ti.\u0001\u000fiC:$G.\u001a\"s_.,'\u000fS3beR\u0014U-\u0019;SKF,Xm\u001d;\u0015\t\u0005e8q\u0006\u0005\b\u00037\f\u0004\u0019AAo\u0003YA\u0017M\u001c3mKVs'/Z4jgR,'O\u0011:pW\u0016\u0014H\u0003BA}\u0007kAq!a73\u0001\u0004\ti.\u0001\riC:$G.\u001a\"s_.,'OU3hSN$(/\u0019;j_:$B!!?\u0004<!9\u00111\\\u001aA\u0002\u0005u\u0017!\u00055b]\u0012dWMU1giJ+\u0017/^3tiR1\u0011\u0011`B!\u0007\u0007Bq!a75\u0001\u0004\ti\u000eC\u0004\u0004FQ\u0002\raa\u0012\u0002\u001b\t,\u0018\u000e\u001c3SKN\u0004xN\\:f!\u001d)%1RB%\u0007+\u0002Baa\u0013\u0004R5\u00111Q\n\u0006\u0005\u0007\u001f\nI!\u0001\u0005qe>$xnY8m\u0013\u0011\u0019\u0019f!\u0014\u0003\u0015\u0005\u0003\u0018.T3tg\u0006<W\r\u0005\u0003\u0003`\u000e]\u0013\u0002BB-\u0005C\u0014\u0001#\u00112tiJ\f7\r\u001e*fgB|gn]3\u0002/!\fg\u000e\u001a7f\u00032$XM]\"mS\u0016tG/U;pi\u0006\u001cH\u0003BA}\u0007?Bq!a76\u0001\u0004\ti.A\u000fiC:$G.Z%oGJ,W.\u001a8uC2\fE\u000e^3s\u0007>tg-[4t)\u0011\tIp!\u001a\t\u000f\u0005mg\u00071\u0001\u0002^\u00061\u0002.\u00198eY\u0016\u001c%/Z1uKB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0002z\u000e-\u0004bBAno\u0001\u0007\u0011Q\\\u0001\u0011GJ,\u0017\r^3QCJ$\u0018\u000e^5p]N$\u0002b!\u001d\u0004\u0004\u000e\u00155Q\u0012\t\u0007\u0003w\u0014Iaa\u001d\u0011\r\t]\"\u0011HB;!\u0011\u00199h! \u000f\t\t\u00053\u0011P\u0005\u0005\u0007w\u0012Y&\u0001\u000fDe\u0016\fG/\u001a)beRLG/[8ogJ+7\u000f]8og\u0016$\u0015\r^1\n\t\r}4\u0011\u0011\u0002\u001c\u0007J,\u0017\r^3QCJ$\u0018\u000e^5p]N$v\u000e]5d%\u0016\u001cX\u000f\u001c;\u000b\t\rm$1\f\u0005\b\u0005KB\u0004\u0019\u0001B4\u0011\u001d\tY\u000e\u000fa\u0001\u0007\u000f\u0003BA!\u001d\u0004\n&!11\u0012B.\u0005m\u0019%/Z1uKB\u000b'\u000f^5uS>t7OU3rk\u0016\u001cH\u000fR1uC\"91q\u0012\u001dA\u0002\t%\u0015\u0001G4fi\u0006cG/\u001a:BkRDwN]5{K\u0012$v\u000e]5dg\u0006\t\u0003.\u00198eY\u0016\fE\u000e^3s!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8ugR!\u0011\u0011`BK\u0011\u001d\tY.\u000fa\u0001\u0003;\f\u0001\u0005[1oI2,G*[:u!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8ugR!\u0011\u0011`BN\u0011\u001d\tYN\u000fa\u0001\u0003;\f\u0001\u0005[1oI2,\u0017\t\u001c7pG\u0006$X\r\u0015:pIV\u001cWM]%egJ+\u0017/^3tiR!\u0011\u0011`BQ\u0011\u001d\tYn\u000fa\u0001\u0003;\fA\u0003[1oI2,W\u000b\u001d3bi\u00164U-\u0019;ve\u0016\u001cH\u0003BA}\u0007OCq!a7=\u0001\u0004\ti\u000e")
public class ControllerApis
implements ApiRequestHandler,
Logging {
    private final RequestChannel requestChannel;
    private final Option<Authorizer> authorizer;
    private final QuotaFactory.QuotaManagers quotas;
    private final Time time;
    private final Controller controller;
    private final RaftManager<ApiMessageAndVersion> raftManager;
    private final KafkaConfig config;
    private final MetaProperties metaProperties;
    private final Seq<Node> controllerNodes;
    private final ApiVersionManager apiVersionManager;
    private final AuthHelper authHelper;
    private final RequestHandlerHelper requestHelper;
    private final AclApis aclApis;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    public Time time() {
        return this.time;
    }

    public Controller controller() {
        return this.controller;
    }

    public RaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public MetaProperties metaProperties() {
        return this.metaProperties;
    }

    public Seq<Node> controllerNodes() {
        return this.controllerNodes;
    }

    public ApiVersionManager apiVersionManager() {
        return this.apiVersionManager;
    }

    public AuthHelper authHelper() {
        return this.authHelper;
    }

    public RequestHandlerHelper requestHelper() {
        return this.requestHelper;
    }

    private AclApis aclApis() {
        return this.aclApis;
    }

    public boolean isClosed() {
        return this.aclApis().isClosed();
    }

    public void close() {
        this.aclApis().close();
    }

    @Override
    public void handle(RequestChannel.Request request, RequestLocal requestLocal) {
        try {
            try {
                CompletableFuture<BoxedUnit> completableFuture;
                ApiKeys apiKeys = request.header().apiKey();
                if (ApiKeys.FETCH.equals(apiKeys)) {
                    completableFuture = this.handleFetch(request);
                } else if (ApiKeys.FETCH_SNAPSHOT.equals(apiKeys)) {
                    completableFuture = this.handleFetchSnapshot(request);
                } else if (ApiKeys.CREATE_TOPICS.equals(apiKeys)) {
                    completableFuture = this.handleCreateTopics(request);
                } else if (ApiKeys.DELETE_TOPICS.equals(apiKeys)) {
                    completableFuture = this.handleDeleteTopics(request);
                } else if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
                    completableFuture = this.handleApiVersionsRequest(request);
                } else if (ApiKeys.ALTER_CONFIGS.equals(apiKeys)) {
                    completableFuture = this.handleLegacyAlterConfigs(request);
                } else if (ApiKeys.VOTE.equals(apiKeys)) {
                    completableFuture = this.handleVote(request);
                } else if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(apiKeys)) {
                    completableFuture = this.handleBeginQuorumEpoch(request);
                } else if (ApiKeys.END_QUORUM_EPOCH.equals(apiKeys)) {
                    completableFuture = this.handleEndQuorumEpoch(request);
                } else if (ApiKeys.DESCRIBE_QUORUM.equals(apiKeys)) {
                    completableFuture = this.handleDescribeQuorum(request);
                } else if (ApiKeys.ALTER_PARTITION.equals(apiKeys)) {
                    completableFuture = this.handleAlterPartitionRequest(request);
                } else if (ApiKeys.BROKER_REGISTRATION.equals(apiKeys)) {
                    completableFuture = this.handleBrokerRegistration(request);
                } else if (ApiKeys.BROKER_HEARTBEAT.equals(apiKeys)) {
                    completableFuture = this.handleBrokerHeartBeatRequest(request);
                } else if (ApiKeys.UNREGISTER_BROKER.equals(apiKeys)) {
                    completableFuture = this.handleUnregisterBroker(request);
                } else if (ApiKeys.ALTER_CLIENT_QUOTAS.equals(apiKeys)) {
                    completableFuture = this.handleAlterClientQuotas(request);
                } else if (ApiKeys.INCREMENTAL_ALTER_CONFIGS.equals(apiKeys)) {
                    completableFuture = this.handleIncrementalAlterConfigs(request);
                } else if (ApiKeys.ALTER_PARTITION_REASSIGNMENTS.equals(apiKeys)) {
                    completableFuture = this.handleAlterPartitionReassignments(request);
                } else if (ApiKeys.LIST_PARTITION_REASSIGNMENTS.equals(apiKeys)) {
                    completableFuture = this.handleListPartitionReassignments(request);
                } else if (ApiKeys.ENVELOPE.equals(apiKeys)) {
                    completableFuture = this.handleEnvelopeRequest(request, requestLocal);
                } else if (ApiKeys.SASL_HANDSHAKE.equals(apiKeys)) {
                    completableFuture = this.handleSaslHandshakeRequest(request);
                } else if (ApiKeys.SASL_AUTHENTICATE.equals(apiKeys)) {
                    completableFuture = this.handleSaslAuthenticateRequest(request);
                } else if (ApiKeys.ALLOCATE_PRODUCER_IDS.equals(apiKeys)) {
                    completableFuture = this.handleAllocateProducerIdsRequest(request);
                } else if (ApiKeys.CREATE_PARTITIONS.equals(apiKeys)) {
                    completableFuture = this.handleCreatePartitions(request);
                } else if (ApiKeys.DESCRIBE_ACLS.equals(apiKeys)) {
                    completableFuture = this.aclApis().handleDescribeAcls(request);
                } else if (ApiKeys.CREATE_ACLS.equals(apiKeys)) {
                    completableFuture = this.aclApis().handleCreateAcls(request);
                } else if (ApiKeys.DELETE_ACLS.equals(apiKeys)) {
                    completableFuture = this.aclApis().handleDeleteAcls(request);
                } else if (ApiKeys.ELECT_LEADERS.equals(apiKeys)) {
                    completableFuture = this.handleElectLeaders(request);
                } else if (ApiKeys.UPDATE_FEATURES.equals(apiKeys)) {
                    completableFuture = this.handleUpdateFeatures(request);
                } else {
                    throw new ApiException(new StringBuilder(19).append("Unsupported ApiKey ").append(request.context().header.apiKey()).toString());
                }
                completableFuture.whenComplete((x$1, exception) -> {
                    if (exception != null) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Unexpected error handling request ").append(request.requestDesc(true)).append(" ").append("with context ").append(request.context()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> exception);
                        this.requestHelper().handleError(request, (Throwable)exception);
                        return;
                    }
                });
            }
            catch (FatalExitError fatalExitError) {
                throw fatalExitError;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Unexpected error handling request ").append(request.requestDesc(true)).append(" ").append("with context ").append(request.context()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                this.requestHelper().handleError(request, t);
            }
        }
        finally {
            if (request.apiLocalCompleteTimeNanos() < 0L) {
                request.apiLocalCompleteTimeNanos_$eq(this.time().nanoseconds());
            }
        }
    }

    public CompletableFuture<BoxedUnit> handleEnvelopeRequest(RequestChannel.Request request, RequestLocal requestLocal) {
        if (!this.authHelper().authorize(request.context(), AclOperation.CLUSTER_ACTION, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
            this.requestHelper().sendErrorResponseMaybeThrottle(request, (Throwable)new ClusterAuthorizationException(new StringBuilder(61).append("Principal ").append(request.context().principal).append(" does not have required CLUSTER_ACTION for envelope").toString()));
        } else {
            EnvelopeUtils$.MODULE$.handleEnvelopeRequest(request, this.requestChannel().metrics(), (Function1<RequestChannel.Request, BoxedUnit>)(Function1 & Serializable)x$2 -> {
                this.handle(x$2, requestLocal);
                return BoxedUnit.UNIT;
            });
        }
        return CompletableFuture.completedFuture(BoxedUnit.UNIT);
    }

    public CompletableFuture<BoxedUnit> handleSaslHandshakeRequest(RequestChannel.Request request) {
        SaslHandshakeResponseData responseData = new SaslHandshakeResponseData().setErrorCode(Errors.ILLEGAL_SASL_STATE.code());
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)x$3 -> ControllerApis.$anonfun$handleSaslHandshakeRequest$1(responseData, BoxesRunTime.unboxToInt((Object)x$3)));
        return CompletableFuture.completedFuture(BoxedUnit.UNIT);
    }

    public CompletableFuture<BoxedUnit> handleSaslAuthenticateRequest(RequestChannel.Request request) {
        SaslAuthenticateResponseData responseData = new SaslAuthenticateResponseData().setErrorCode(Errors.ILLEGAL_SASL_STATE.code()).setErrorMessage("SaslAuthenticate request received after successful authentication");
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)x$4 -> ControllerApis.$anonfun$handleSaslAuthenticateRequest$1(responseData, BoxesRunTime.unboxToInt((Object)x$4)));
        return CompletableFuture.completedFuture(BoxedUnit.UNIT);
    }

    public CompletableFuture<BoxedUnit> handleFetch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new FetchResponse((FetchResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            ControllerApis.$anonfun$handleRaftRequest$1(this, handleRaftRequest_requestBody, handleRaftRequest_buildResponse, request, responseData, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleFetchSnapshot(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new FetchSnapshotResponse((FetchSnapshotResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            ControllerApis.$anonfun$handleRaftRequest$1(this, handleRaftRequest_requestBody, handleRaftRequest_buildResponse, request, responseData, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleDeleteTopics(RequestChannel.Request request) {
        DeleteTopicsRequest deleteTopicsRequest = (DeleteTopicsRequest)request.body(ClassTag$.MODULE$.apply(DeleteTopicsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)deleteTopicsRequest.data().timeoutMs()));
        RequestContext x$1 = request.context();
        boolean x$6 = this.authHelper().authorize$default$5();
        int x$7 = this.authHelper().authorize$default$7();
        return this.deleteTopics(context, deleteTopicsRequest.data(), request.context().apiVersion(), this.authHelper().authorize(x$1, AclOperation.DELETE, ResourceType.CLUSTER, "kafka-cluster", x$6, false, x$7), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.DESCRIBE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable)n -> n), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.DELETE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable)n -> n)).handle((results, exception) -> {
            ControllerApis.$anonfun$handleDeleteTopics$5(this, request, deleteTopicsRequest, results, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<List<DeleteTopicsResponseData.DeletableTopicResult>> deleteTopics(ControllerRequestContext context, DeleteTopicsRequestData request, int apiVersion, boolean hasClusterAuth, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getDescribableTopics, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getDeletableTopics) {
        if (!Predef$.MODULE$.Boolean2boolean(this.config().deleteTopicEnable())) {
            if (apiVersion < 3) {
                throw new InvalidRequestException("Topic deletion is disabled.");
            }
            throw new TopicDeletionDisabledException();
        }
        ArrayList responses = new ArrayList();
        HashSet providedNames = new HashSet();
        HashSet duplicateProvidedNames = new HashSet();
        HashSet providedIds = new HashSet();
        HashSet duplicateProvidedIds = new HashSet();
        request.topicNames().forEach(name -> ControllerApis.addProvidedName$1(name, duplicateProvidedNames, providedNames));
        request.topics().forEach(topic -> {
            if (topic.name() == null) {
                if (topic.topicId().equals((Object)Uuid.ZERO_UUID)) {
                    ControllerApis.appendResponse$1(null, Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Neither topic name nor id were specified."), responses);
                    return;
                }
                if (duplicateProvidedIds.contains(topic.topicId()) || !providedIds.add(topic.topicId())) {
                    duplicateProvidedIds.add(topic.topicId());
                    providedIds.remove(topic.topicId());
                    return;
                }
                return;
            }
            if (topic.topicId().equals((Object)Uuid.ZERO_UUID)) {
                ControllerApis.addProvidedName$1(topic.name(), duplicateProvidedNames, providedNames);
                return;
            }
            ControllerApis.appendResponse$1(topic.name(), topic.topicId(), new ApiError(Errors.INVALID_REQUEST, "You may not specify both topic name and topic id."), responses);
        });
        duplicateProvidedNames.forEach(name -> ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Duplicate topic name."), responses));
        duplicateProvidedIds.forEach(id -> ControllerApis.appendResponse$1(null, id, new ApiError(Errors.INVALID_REQUEST, "Duplicate topic id."), responses));
        HashSet toAuthenticate = new HashSet();
        toAuthenticate.addAll(providedNames);
        HashMap idToName = new HashMap();
        return this.controller().findTopicNames(context, providedIds).thenCompose(topicNames -> {
            void var12_13;
            void var13_14;
            Object object;
            Object object2;
            topicNames.forEach((id, nameOrError) -> {
                if (nameOrError.isError()) {
                    ControllerApis.appendResponse$1(null, id, nameOrError.error(), responses);
                    return;
                }
                toAuthenticate.add(nameOrError.result());
                idToName.put(id, nameOrError.result());
            });
            scala.collection.mutable.Set topicsToAuthenticate = CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)toAuthenticate).asScala();
            if (hasClusterAuth) {
                object2 = topicsToAuthenticate.toSet();
                object = topicsToAuthenticate.toSet();
            } else {
                object2 = getDescribableTopics.apply((Object)topicsToAuthenticate);
                object = getDeletableTopics.apply((Object)topicsToAuthenticate);
            }
            scala.collection.immutable.Set set = object;
            Object describeable = object2;
            scala.collection.immutable.Set deletable = set;
            Iterator iterator = idToName.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Uuid id2 = (Uuid)entry.getKey();
                String name = (String)entry.getValue();
                if (var13_14.contains((Object)name)) continue;
                if (var12_13.contains((Object)name)) {
                    ControllerApis.appendResponse$1(name, id2, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                } else {
                    ControllerApis.appendResponse$1(null, id2, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                }
                iterator.remove();
            }
            return this.controller().findTopicIds(context, (Collection)providedNames).thenCompose(arg_0 -> ControllerApis.$anonfun$deleteTopics$7(this, (scala.collection.immutable.Set)var12_13, (scala.collection.immutable.Set)var13_14, duplicateProvidedIds, idToName, context, responses, arg_0));
        });
    }

    public CompletableFuture<BoxedUnit> handleCreateTopics(RequestChannel.Request request) {
        CreateTopicsRequest createTopicsRequest = (CreateTopicsRequest)request.body(ClassTag$.MODULE$.apply(CreateTopicsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)createTopicsRequest.data().timeoutMs()));
        RequestContext x$1 = request.context();
        boolean x$6 = this.authHelper().authorize$default$5();
        int x$7 = this.authHelper().authorize$default$7();
        return this.createTopics(context, createTopicsRequest.data(), this.authHelper().authorize(x$1, AclOperation.CREATE, ResourceType.CLUSTER, "kafka-cluster", x$6, false, x$7), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.CREATE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x)), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)names -> {
            RequestContext x$8 = request.context();
            boolean x$13 = this.authHelper().filterByAuthorized$default$5();
            Function1 & Serializable x$14 = (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
            return this.authHelper().filterByAuthorized(x$8, AclOperation.DESCRIBE_CONFIGS, ResourceType.TOPIC, names, x$13, false, x$14);
        }).handle((result, exception) -> {
            ControllerApis.$anonfun$handleCreateTopics$5(this, request, createTopicsRequest, result, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<CreateTopicsResponseData> createTopics(ControllerRequestContext context, CreateTopicsRequestData request, boolean hasClusterAuth, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getCreatableTopics, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getDescribableTopics) {
        HashSet topicNames = new HashSet();
        HashSet duplicateTopicNames = new HashSet();
        request.topics().forEach(topicData -> {
            if (!duplicateTopicNames.contains(topicData.name())) {
                if (!topicNames.add(topicData.name())) {
                    topicNames.remove(topicData.name());
                    duplicateTopicNames.add(topicData.name());
                    return;
                }
                return;
            }
        });
        if (topicNames.contains("__cluster_metadata")) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Rejecting creation of internal topic ").append("__cluster_metadata").toString());
        }
        scala.collection.mutable.Set allowedTopicNames = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(topicNames).asScala().diff((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"__cluster_metadata"})));
        scala.collection.mutable.Set authorizedTopicNames = hasClusterAuth ? allowedTopicNames : (Set)getCreatableTopics.apply((Object)allowedTopicNames);
        java.util.Set describableTopicNames = CollectionConverters$.MODULE$.SetHasAsJava((Set)getDescribableTopics.apply((Object)allowedTopicNames)).asJava();
        CreateTopicsRequestData effectiveRequest = request.duplicate();
        Iterator iterator = effectiveRequest.topics().iterator();
        while (iterator.hasNext()) {
            CreateTopicsRequestData.CreatableTopic creatableTopic = (CreateTopicsRequestData.CreatableTopic)iterator.next();
            if (!duplicateTopicNames.contains(creatableTopic.name()) && authorizedTopicNames.contains((Object)creatableTopic.name())) continue;
            iterator.remove();
        }
        return this.controller().createTopics(context, effectiveRequest, describableTopicNames).thenApply(arg_0 -> ControllerApis.$anonfun$createTopics$3(duplicateTopicNames, topicNames, (Set)authorizedTopicNames, arg_0));
    }

    public CompletableFuture<BoxedUnit> handleApiVersionsRequest(RequestChannel.Request request) {
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> this.createResponseCallback$1(BoxesRunTime.unboxToInt((Object)requestThrottleMs), request));
        return CompletableFuture.completedFuture(BoxedUnit.UNIT);
    }

    public ApiError authorizeAlterResource(RequestContext requestContext, ConfigResource resource) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.BROKER.equals(type)) {
            if (this.authHelper().authorize(requestContext, AclOperation.ALTER_CONFIGS, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
                return new ApiError(Errors.NONE);
            }
            return new ApiError(Errors.CLUSTER_AUTHORIZATION_FAILED);
        }
        if (ConfigResource.Type.TOPIC.equals(type)) {
            if (this.authHelper().authorize(requestContext, AclOperation.ALTER_CONFIGS, ResourceType.TOPIC, resource.name(), this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
                return new ApiError(Errors.NONE);
            }
            return new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED);
        }
        return new ApiError(Errors.INVALID_REQUEST, new StringBuilder(26).append("Unexpected resource type ").append(type).append(".").toString());
    }

    public CompletableFuture<BoxedUnit> handleLegacyAlterConfigs(RequestChannel.Request request) {
        AlterConfigsResponseData response = new AlterConfigsResponseData();
        AlterConfigsRequest alterConfigsRequest = (AlterConfigsRequest)request.body(ClassTag$.MODULE$.apply(AlterConfigsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        HashSet duplicateResources = new HashSet();
        HashMap configChanges = new HashMap();
        alterConfigsRequest.data().resources().forEach(resource -> {
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId((byte)resource.resourceType()), resource.resourceName());
            if (configResource.type().equals((Object)ConfigResource.Type.UNKNOWN)) {
                response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage(new StringBuilder(23).append("Unknown resource type ").append(resource.resourceType()).append(".").toString()).setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                return;
            }
            if (!duplicateResources.contains(configResource)) {
                HashMap configs = new HashMap();
                resource.configs().forEach(config -> configs.put(config.name(), config.value()));
                if (configChanges.put(configResource, configs) != null) {
                    duplicateResources.add(configResource);
                    configChanges.remove(configResource);
                    response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                    return;
                }
                return;
            }
        });
        Iterator iterator = configChanges.keySet().iterator();
        while (iterator.hasNext()) {
            ConfigResource resource2 = (ConfigResource)iterator.next();
            ApiError apiError = this.authorizeAlterResource(request.context(), resource2);
            if (!apiError.isFailure()) continue;
            response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setResourceName(resource2.name()).setResourceType(resource2.type().id()));
            iterator.remove();
        }
        return this.controller().legacyAlterConfigs(context, configChanges, alterConfigsRequest.data().validateOnly()).handle((controllerResults, exception) -> {
            ControllerApis.$anonfun$handleLegacyAlterConfigs$3(this, request, response, controllerResults, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleVote(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new VoteResponse((VoteResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            ControllerApis.$anonfun$handleRaftRequest$1(this, handleRaftRequest_requestBody, handleRaftRequest_buildResponse, request, responseData, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleBeginQuorumEpoch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new BeginQuorumEpochResponse((BeginQuorumEpochResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            ControllerApis.$anonfun$handleRaftRequest$1(this, handleRaftRequest_requestBody, handleRaftRequest_buildResponse, request, responseData, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleEndQuorumEpoch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new EndQuorumEpochResponse((EndQuorumEpochResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            ControllerApis.$anonfun$handleRaftRequest$1(this, handleRaftRequest_requestBody, handleRaftRequest_buildResponse, request, responseData, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleDescribeQuorum(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.DESCRIBE);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new DescribeQuorumResponse((DescribeQuorumResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            ControllerApis.$anonfun$handleRaftRequest$1(this, handleRaftRequest_requestBody, handleRaftRequest_buildResponse, request, responseData, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleElectLeaders(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        ElectLeadersRequest electLeadersRequest = (ElectLeadersRequest)request.body(ClassTag$.MODULE$.apply(ElectLeadersRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)electLeadersRequest.data().timeoutMs()));
        return this.controller().electLeaders(context, electLeadersRequest.data()).handle((responseData, exception) -> {
            ControllerApis.$anonfun$handleElectLeaders$1(this, request, electLeadersRequest, responseData, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleAlterPartitionRequest(RequestChannel.Request request) {
        AlterPartitionRequest alterPartitionRequest = (AlterPartitionRequest)request.body(ClassTag$.MODULE$.apply(AlterPartitionRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        return this.controller().alterPartition(context, alterPartitionRequest.data()).handle((result, exception) -> {
            ControllerApis.$anonfun$handleAlterPartitionRequest$1(this, alterPartitionRequest, request, result, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleBrokerHeartBeatRequest(RequestChannel.Request request) {
        BrokerHeartbeatRequest heartbeatRequest = (BrokerHeartbeatRequest)request.body(ClassTag$.MODULE$.apply(BrokerHeartbeatRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)(this.config().brokerHeartbeatIntervalMs() / 2)));
        return this.controller().processBrokerHeartbeat(context, heartbeatRequest.data()).handle((reply, e) -> {
            ControllerApis.$anonfun$handleBrokerHeartBeatRequest$1(this, request, reply, e);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleUnregisterBroker(RequestChannel.Request request) {
        UnregisterBrokerRequest decommissionRequest = (UnregisterBrokerRequest)request.body(ClassTag$.MODULE$.apply(UnregisterBrokerRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().unregisterBroker(context, decommissionRequest.data().brokerId()).handle((x$6, e) -> {
            ControllerApis.$anonfun$handleUnregisterBroker$1(this, request, x$6, e);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleBrokerRegistration(RequestChannel.Request request) {
        BrokerRegistrationRequest registrationRequest = (BrokerRegistrationRequest)request.body(ClassTag$.MODULE$.apply(BrokerRegistrationRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().registerBroker(context, registrationRequest.data()).handle((reply, e) -> {
            ControllerApis.$anonfun$handleBrokerRegistration$1(this, request, reply, e);
            return BoxedUnit.UNIT;
        });
    }

    private CompletableFuture<BoxedUnit> handleRaftRequest(RequestChannel.Request request, Function1<ApiMessage, AbstractResponse> buildResponse) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return this.raftManager().handleRequest(request.header(), requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            ControllerApis.$anonfun$handleRaftRequest$1(this, handleRaftRequest_requestBody, handleRaftRequest_buildResponse, request, responseData, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleAlterClientQuotas(RequestChannel.Request request) {
        AlterClientQuotasRequest quotaRequest = (AlterClientQuotasRequest)request.body(ClassTag$.MODULE$.apply(AlterClientQuotasRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER_CONFIGS);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().alterClientQuotas(context, (Collection)quotaRequest.entries(), quotaRequest.validateOnly()).handle((results, exception) -> {
            ControllerApis.$anonfun$handleAlterClientQuotas$1(this, request, results, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleIncrementalAlterConfigs(RequestChannel.Request request) {
        IncrementalAlterConfigsResponseData response = new IncrementalAlterConfigsResponseData();
        IncrementalAlterConfigsRequest alterConfigsRequest = (IncrementalAlterConfigsRequest)request.body(ClassTag$.MODULE$.apply(IncrementalAlterConfigsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        HashSet duplicateResources = new HashSet();
        HashMap configChanges = new HashMap();
        alterConfigsRequest.data().resources().forEach(resource -> {
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId((byte)resource.resourceType()), resource.resourceName());
            if (configResource.type().equals((Object)ConfigResource.Type.UNKNOWN)) {
                response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage(new StringBuilder(23).append("Unknown resource type ").append(resource.resourceType()).append(".").toString()).setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                return;
            }
            if (!duplicateResources.contains(configResource)) {
                HashMap altersByName = new HashMap();
                resource.configs().forEach(config -> altersByName.put(config.name(), new AbstractMap.SimpleEntry<AlterConfigOp.OpType, String>(AlterConfigOp.OpType.forId((byte)config.configOperation()), config.value())));
                if (configChanges.put(configResource, altersByName) != null) {
                    duplicateResources.add(configResource);
                    configChanges.remove(configResource);
                    response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                    return;
                }
                return;
            }
        });
        Iterator iterator = configChanges.keySet().iterator();
        while (iterator.hasNext()) {
            ConfigResource resource2 = (ConfigResource)iterator.next();
            ApiError apiError = this.authorizeAlterResource(request.context(), resource2);
            if (!apiError.isFailure()) continue;
            response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setResourceName(resource2.name()).setResourceType(resource2.type().id()));
            iterator.remove();
        }
        return this.controller().incrementalAlterConfigs(context, configChanges, alterConfigsRequest.data().validateOnly()).handle((controllerResults, exception) -> {
            ControllerApis.$anonfun$handleIncrementalAlterConfigs$3(this, request, response, controllerResults, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleCreatePartitions(RequestChannel.Request request) {
        CreatePartitionsRequest createPartitionsRequest = (CreatePartitionsRequest)request.body(ClassTag$.MODULE$.apply(CreatePartitionsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)createPartitionsRequest.data().timeoutMs()));
        return this.createPartitions(context, createPartitionsRequest.data(), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)topics -> this.filterAlterAuthorizedTopics$1((Iterable)topics, request)).handle((responses, exception) -> {
            ControllerApis.$anonfun$handleCreatePartitions$3(this, request, responses, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<List<CreatePartitionsResponseData.CreatePartitionsTopicResult>> createPartitions(ControllerRequestContext context, CreatePartitionsRequestData request, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getAlterAuthorizedTopics) {
        ArrayList responses = new ArrayList();
        HashSet duplicateTopicNames = new HashSet();
        HashSet topicNames = new HashSet();
        request.topics().forEach(topic -> {
            if (!topicNames.add(topic.name())) {
                duplicateTopicNames.add(topic.name());
                return;
            }
        });
        duplicateTopicNames.forEach(topicName -> {
            responses.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topicName).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."));
            topicNames.remove(topicName);
        });
        scala.collection.immutable.Set authorizedTopicNames = (scala.collection.immutable.Set)getAlterAuthorizedTopics.apply((Object)CollectionConverters$.MODULE$.SetHasAsScala(topicNames).asScala());
        ArrayList topics = new ArrayList();
        topicNames.forEach(topicName -> {
            if (authorizedTopicNames.contains(topicName)) {
                topics.add(request.topics().find(topicName));
                return;
            }
            responses.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topicName).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()));
        });
        return this.controller().createPartitions(context, topics, request.validateOnly()).thenApply(results -> {
            results.forEach(response -> responses.add(response));
            return responses;
        });
    }

    public CompletableFuture<BoxedUnit> handleAlterPartitionReassignments(RequestChannel.Request request) {
        AlterPartitionReassignmentsRequest alterRequest = (AlterPartitionReassignmentsRequest)request.body(ClassTag$.MODULE$.apply(AlterPartitionReassignmentsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)alterRequest.data().timeoutMs()));
        return this.controller().alterPartitionReassignments(context, alterRequest.data()).thenApply(response -> {
            ControllerApis.$anonfun$handleAlterPartitionReassignments$1(this, request, response);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleListPartitionReassignments(RequestChannel.Request request) {
        ListPartitionReassignmentsRequest listRequest = (ListPartitionReassignmentsRequest)request.body(ClassTag$.MODULE$.apply(ListPartitionReassignmentsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.DESCRIBE);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().listPartitionReassignments(context, listRequest.data()).thenApply(response -> {
            ControllerApis.$anonfun$handleListPartitionReassignments$1(this, request, response);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleAllocateProducerIdsRequest(RequestChannel.Request request) {
        AllocateProducerIdsRequest allocatedProducerIdsRequest = (AllocateProducerIdsRequest)request.body(ClassTag$.MODULE$.apply(AllocateProducerIdsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().allocateProducerIds(context, allocatedProducerIdsRequest.data()).handle((results, exception) -> {
            ControllerApis.$anonfun$handleAllocateProducerIdsRequest$1(this, request, results, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleUpdateFeatures(RequestChannel.Request request) {
        UpdateFeaturesRequest updateFeaturesRequest = (UpdateFeaturesRequest)request.body(ClassTag$.MODULE$.apply(UpdateFeaturesRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().updateFeatures(context, updateFeaturesRequest.data()).handle((response, exception) -> {
            ControllerApis.$anonfun$handleUpdateFeatures$1(this, request, response, exception);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SaslHandshakeResponse $anonfun$handleSaslHandshakeRequest$1(SaslHandshakeResponseData responseData$1, int x$3) {
        return new SaslHandshakeResponse(responseData$1);
    }

    public static final /* synthetic */ SaslAuthenticateResponse $anonfun$handleSaslAuthenticateRequest$1(SaslAuthenticateResponseData responseData$2, int x$4) {
        return new SaslAuthenticateResponse(responseData$2);
    }

    public static final /* synthetic */ AbstractResponse $anonfun$handleDeleteTopics$6(Throwable exception$2, DeleteTopicsRequest deleteTopicsRequest$1, List results$1, int throttleTimeMs) {
        if (exception$2 != null) {
            return deleteTopicsRequest$1.getErrorResponse(throttleTimeMs, exception$2);
        }
        DeleteTopicsResponseData responseData = new DeleteTopicsResponseData().setResponses(new DeleteTopicsResponseData.DeletableTopicResultCollection(results$1.iterator())).setThrottleTimeMs(throttleTimeMs);
        return new DeleteTopicsResponse(responseData);
    }

    public static final /* synthetic */ void $anonfun$handleDeleteTopics$5(ControllerApis $this, RequestChannel.Request request$2, DeleteTopicsRequest deleteTopicsRequest$1, List results, Throwable exception) {
        $this.requestHelper().sendResponseMaybeThrottle(request$2, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleTimeMs -> ControllerApis.$anonfun$handleDeleteTopics$6(exception, deleteTopicsRequest$1, results, BoxesRunTime.unboxToInt((Object)throttleTimeMs)));
    }

    private static final void appendResponse$1(String name, Uuid id, ApiError error, ArrayList responses$1) {
        responses$1.add(new DeleteTopicsResponseData.DeletableTopicResult().setName(name).setTopicId(id).setErrorCode(error.error().code()).setErrorMessage(error.message()));
    }

    private static final void addProvidedName$1(String name, HashSet duplicateProvidedNames$1, HashSet providedNames$1) {
        if (duplicateProvidedNames$1.contains(name) || !providedNames$1.add(name)) {
            duplicateProvidedNames$1.add(name);
            providedNames$1.remove(name);
            return;
        }
    }

    public static final /* synthetic */ CompletableFuture $anonfun$deleteTopics$7(ControllerApis $this, scala.collection.immutable.Set describeable$1, scala.collection.immutable.Set deletable$1, HashSet duplicateProvidedIds$1, HashMap idToName$1, ControllerRequestContext context$1, ArrayList responses$1, Map topicIds) {
        topicIds.forEach((name, idOrError) -> {
            if (!describeable$1.contains(name)) {
                ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses$1);
                return;
            }
            if (idOrError.isError()) {
                ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, idOrError.error(), responses$1);
                return;
            }
            if (deletable$1.contains(name)) {
                Uuid id = (Uuid)idOrError.result();
                if (duplicateProvidedIds$1.contains(id) || idToName$1.put(id, name) != null) {
                    duplicateProvidedIds$1.add(id);
                    idToName$1.remove(id);
                    ControllerApis.appendResponse$1(name, id, new ApiError(Errors.INVALID_REQUEST, "The provided topic name maps to an ID that was already supplied."), responses$1);
                    return;
                }
                return;
            }
            ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses$1);
        });
        return $this.controller().deleteTopics(context$1, idToName$1.keySet()).thenApply(idToError -> {
            idToError.forEach((id, error) -> ControllerApis.appendResponse$1((String)idToName$1.get(id), id, error, responses$1));
            Collections.shuffle(responses$1);
            return responses$1;
        });
    }

    public static final /* synthetic */ AbstractResponse $anonfun$handleCreateTopics$6(Throwable exception$3, CreateTopicsRequest createTopicsRequest$1, CreateTopicsResponseData result$1, int throttleTimeMs) {
        if (exception$3 != null) {
            return createTopicsRequest$1.getErrorResponse(throttleTimeMs, exception$3);
        }
        result$1.setThrottleTimeMs(throttleTimeMs);
        return new CreateTopicsResponse(result$1);
    }

    public static final /* synthetic */ void $anonfun$handleCreateTopics$5(ControllerApis $this, RequestChannel.Request request$3, CreateTopicsRequest createTopicsRequest$1, CreateTopicsResponseData result, Throwable exception) {
        $this.requestHelper().sendResponseMaybeThrottle(request$3, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleTimeMs -> ControllerApis.$anonfun$handleCreateTopics$6(exception, createTopicsRequest$1, result, BoxesRunTime.unboxToInt((Object)throttleTimeMs)));
    }

    public static final /* synthetic */ CreateTopicsResponseData $anonfun$createTopics$3(HashSet duplicateTopicNames$1, HashSet topicNames$1, Set authorizedTopicNames$1, CreateTopicsResponseData response) {
        duplicateTopicNames$1.forEach(name -> response.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(name).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name.")));
        topicNames$1.forEach(name -> {
            if (!authorizedTopicNames$1.contains(name)) {
                response.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(name).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage("Authorization failed."));
                return;
            }
        });
        return response;
    }

    private final ApiVersionsResponse createResponseCallback$1(int requestThrottleMs, RequestChannel.Request request$4) {
        ApiVersionsRequest apiVersionRequest = (ApiVersionsRequest)request$4.body(ClassTag$.MODULE$.apply(ApiVersionsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        if (apiVersionRequest.hasUnsupportedRequestVersion()) {
            return apiVersionRequest.getErrorResponse(requestThrottleMs, (Throwable)Errors.UNSUPPORTED_VERSION.exception());
        }
        if (!apiVersionRequest.isValid()) {
            return apiVersionRequest.getErrorResponse(requestThrottleMs, (Throwable)Errors.INVALID_REQUEST.exception());
        }
        return this.apiVersionManager().apiVersionResponse(requestThrottleMs);
    }

    public static final /* synthetic */ AlterConfigsResponse $anonfun$handleLegacyAlterConfigs$5(AlterConfigsResponseData response$2, int throttleMs) {
        return new AlterConfigsResponse(response$2.setThrottleTimeMs(throttleMs));
    }

    public static final /* synthetic */ void $anonfun$handleLegacyAlterConfigs$3(ControllerApis $this, RequestChannel.Request request$5, AlterConfigsResponseData response$2, Map controllerResults, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$5, exception);
            return;
        }
        controllerResults.entrySet().forEach(entry -> response$2.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(((ApiError)entry.getValue()).error().code()).setErrorMessage(((ApiError)entry.getValue()).message()).setResourceName(((ConfigResource)entry.getKey()).name()).setResourceType(((ConfigResource)entry.getKey()).type().id())));
        $this.requestHelper().sendResponseMaybeThrottle(request$5, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleMs -> ControllerApis.$anonfun$handleLegacyAlterConfigs$5(response$2, BoxesRunTime.unboxToInt((Object)throttleMs)));
    }

    public static final /* synthetic */ ElectLeadersResponse $anonfun$handleElectLeaders$3(ElectLeadersResponseData responseData$3, int throttleMs) {
        return new ElectLeadersResponse(responseData$3.setThrottleTimeMs(throttleMs));
    }

    public static final /* synthetic */ void $anonfun$handleElectLeaders$1(ControllerApis $this, RequestChannel.Request request$6, ElectLeadersRequest electLeadersRequest$1, ElectLeadersResponseData responseData, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().sendResponseMaybeThrottle(request$6, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleMs -> electLeadersRequest$1.getErrorResponse(BoxesRunTime.unboxToInt((Object)throttleMs), exception));
            return;
        }
        $this.requestHelper().sendResponseMaybeThrottle(request$6, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleMs -> ControllerApis.$anonfun$handleElectLeaders$3(responseData, BoxesRunTime.unboxToInt((Object)throttleMs)));
    }

    public static final /* synthetic */ void $anonfun$handleAlterPartitionRequest$1(ControllerApis $this, AlterPartitionRequest alterPartitionRequest$1, RequestChannel.Request request$7, AlterPartitionResponseData result, Throwable exception) {
        AlterPartitionResponse response = exception != null ? alterPartitionRequest$1.getErrorResponse(exception) : new AlterPartitionResponse(result);
        $this.requestHelper().sendResponseExemptThrottle(request$7, (AbstractResponse)response, $this.requestHelper().sendResponseExemptThrottle$default$3());
    }

    private static final BrokerHeartbeatResponse createResponseCallback$2(int requestThrottleMs, BrokerHeartbeatReply reply, Throwable e) {
        if (e != null) {
            return new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.NONE.code()).setIsCaughtUp(reply.isCaughtUp()).setIsFenced(reply.isFenced()).setShouldShutDown(reply.shouldShutDown()));
    }

    public static final /* synthetic */ void $anonfun$handleBrokerHeartBeatRequest$1(ControllerApis $this, RequestChannel.Request request$8, BrokerHeartbeatReply reply, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$8, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$2(BoxesRunTime.unboxToInt((Object)requestThrottleMs), reply, e));
    }

    private static final UnregisterBrokerResponse createResponseCallback$3(int requestThrottleMs, Throwable e) {
        if (e != null) {
            return new UnregisterBrokerResponse(new UnregisterBrokerResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new UnregisterBrokerResponse(new UnregisterBrokerResponseData().setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleUnregisterBroker$1(ControllerApis $this, RequestChannel.Request request$9, Void x$6, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$9, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$3(BoxesRunTime.unboxToInt((Object)requestThrottleMs), e));
    }

    private static final BrokerRegistrationResponse createResponseCallback$4(int requestThrottleMs, BrokerRegistrationReply reply, Throwable e) {
        if (e != null) {
            return new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.NONE.code()).setBrokerEpoch(reply.epoch()));
    }

    public static final /* synthetic */ void $anonfun$handleBrokerRegistration$1(ControllerApis $this, RequestChannel.Request request$10, BrokerRegistrationReply reply, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$10, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$4(BoxesRunTime.unboxToInt((Object)requestThrottleMs), reply, e));
    }

    public static final /* synthetic */ void $anonfun$handleRaftRequest$1(ControllerApis $this, AbstractRequest requestBody$1, Function1 buildResponse$1, RequestChannel.Request request$11, ApiMessage responseData, Throwable exception) {
        AbstractResponse response = exception != null ? requestBody$1.getErrorResponse(exception) : (AbstractResponse)buildResponse$1.apply((Object)responseData);
        $this.requestHelper().sendResponseExemptThrottle(request$11, response, $this.requestHelper().sendResponseExemptThrottle$default$3());
    }

    public static final /* synthetic */ AlterClientQuotasResponse $anonfun$handleAlterClientQuotas$2(Map results$2, int requestThrottleMs) {
        return AlterClientQuotasResponse.fromQuotaEntities((Map)results$2, (int)requestThrottleMs);
    }

    public static final /* synthetic */ void $anonfun$handleAlterClientQuotas$1(ControllerApis $this, RequestChannel.Request request$12, Map results, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$12, exception);
            return;
        }
        $this.requestHelper().sendResponseMaybeThrottle(request$12, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAlterClientQuotas$2(results, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ IncrementalAlterConfigsResponse $anonfun$handleIncrementalAlterConfigs$5(IncrementalAlterConfigsResponseData response$3, int throttleMs) {
        return new IncrementalAlterConfigsResponse(response$3.setThrottleTimeMs(throttleMs));
    }

    public static final /* synthetic */ void $anonfun$handleIncrementalAlterConfigs$3(ControllerApis $this, RequestChannel.Request request$13, IncrementalAlterConfigsResponseData response$3, Map controllerResults, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$13, exception);
            return;
        }
        controllerResults.entrySet().forEach(entry -> response$3.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(((ApiError)entry.getValue()).error().code()).setErrorMessage(((ApiError)entry.getValue()).message()).setResourceName(((ConfigResource)entry.getKey()).name()).setResourceType(((ConfigResource)entry.getKey()).type().id())));
        $this.requestHelper().sendResponseMaybeThrottle(request$13, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleMs -> ControllerApis.$anonfun$handleIncrementalAlterConfigs$5(response$3, BoxesRunTime.unboxToInt((Object)throttleMs)));
    }

    private final scala.collection.immutable.Set filterAlterAuthorizedTopics$1(Iterable topics, RequestChannel.Request request$14) {
        return this.authHelper().filterByAuthorized(request$14.context(), AclOperation.ALTER, ResourceType.TOPIC, topics, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable)n -> n);
    }

    public static final /* synthetic */ CreatePartitionsResponse $anonfun$handleCreatePartitions$4(List responses$2, int requestThrottleMs) {
        CreatePartitionsResponseData responseData = new CreatePartitionsResponseData().setResults(responses$2).setThrottleTimeMs(requestThrottleMs);
        return new CreatePartitionsResponse(responseData);
    }

    public static final /* synthetic */ void $anonfun$handleCreatePartitions$3(ControllerApis $this, RequestChannel.Request request$14, List responses, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$14, exception);
            return;
        }
        $this.requestHelper().sendResponseMaybeThrottle(request$14, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleCreatePartitions$4(responses, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ AlterPartitionReassignmentsResponse $anonfun$handleAlterPartitionReassignments$2(AlterPartitionReassignmentsResponseData response$4, int requestThrottleMs) {
        return new AlterPartitionReassignmentsResponse(response$4.setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleAlterPartitionReassignments$1(ControllerApis $this, RequestChannel.Request request$16, AlterPartitionReassignmentsResponseData response) {
        $this.requestHelper().sendResponseMaybeThrottle(request$16, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAlterPartitionReassignments$2(response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ ListPartitionReassignmentsResponse $anonfun$handleListPartitionReassignments$2(ListPartitionReassignmentsResponseData response$5, int requestThrottleMs) {
        return new ListPartitionReassignmentsResponse(response$5.setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleListPartitionReassignments$1(ControllerApis $this, RequestChannel.Request request$17, ListPartitionReassignmentsResponseData response) {
        $this.requestHelper().sendResponseMaybeThrottle(request$17, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleListPartitionReassignments$2(response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ AllocateProducerIdsResponse $anonfun$handleAllocateProducerIdsRequest$2(AllocateProducerIdsResponseData results$3, int requestThrottleMs) {
        results$3.setThrottleTimeMs(requestThrottleMs);
        return new AllocateProducerIdsResponse(results$3);
    }

    public static final /* synthetic */ void $anonfun$handleAllocateProducerIdsRequest$1(ControllerApis $this, RequestChannel.Request request$18, AllocateProducerIdsResponseData results, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$18, exception);
            return;
        }
        $this.requestHelper().sendResponseMaybeThrottle(request$18, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAllocateProducerIdsRequest$2(results, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ UpdateFeaturesResponse $anonfun$handleUpdateFeatures$2(UpdateFeaturesResponseData response$6, int requestThrottleMs) {
        return new UpdateFeaturesResponse(response$6.setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleUpdateFeatures$1(ControllerApis $this, RequestChannel.Request request$19, UpdateFeaturesResponseData response, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$19, exception);
            return;
        }
        $this.requestHelper().sendResponseMaybeThrottle(request$19, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleUpdateFeatures$2(response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public ControllerApis(RequestChannel requestChannel, Option<Authorizer> authorizer, QuotaFactory.QuotaManagers quotas, Time time, Controller controller, RaftManager<ApiMessageAndVersion> raftManager, KafkaConfig config, MetaProperties metaProperties, Seq<Node> controllerNodes, ApiVersionManager apiVersionManager) {
        this.requestChannel = requestChannel;
        this.authorizer = authorizer;
        this.quotas = quotas;
        this.time = time;
        this.controller = controller;
        this.raftManager = raftManager;
        this.config = config;
        this.metaProperties = metaProperties;
        this.controllerNodes = controllerNodes;
        this.apiVersionManager = apiVersionManager;
        this.logIdent_$eq(new StringBuilder(25).append("[ControllerApis nodeId=").append(config.nodeId()).append("] ").toString());
        this.authHelper = new AuthHelper(authorizer);
        this.requestHelper = new RequestHandlerHelper(requestChannel, quotas, time);
        this.aclApis = new AclApis(this.authHelper(), authorizer, this.requestHelper(), "controller", config);
    }
}

