/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.BrokerReconfigurable;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicClientQuotaCallback;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicThreadPool;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.EncryptingPasswordEncoder;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.NoOpPasswordEncoder;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0011eq!\u0002+V\u0011\u0003Qf!\u0002/V\u0011\u0003i\u0006\"\u00023\u0002\t\u0003)\u0007\u0002\u00034\u0002\u0005\u0004%\t!V4\t\ra\f\u0001\u0015!\u0003i\u0011\u001dI\u0018A1A\u0005\u0002\u001dDaA_\u0001!\u0002\u0013A\u0007bB>\u0002\u0005\u0004%I\u0001 \u0005\b\u0003\u0003\t\u0001\u0015!\u0003~\u0011!\t\u0019!\u0001b\u0001\n\u00139\u0007bBA\u0003\u0003\u0001\u0006I\u0001\u001b\u0005\t\u0003\u000f\t!\u0019!C\u0005y\"9\u0011\u0011B\u0001!\u0002\u0013i\b\u0002CA\u0006\u0003\t\u0007I\u0011\u0002?\t\u000f\u00055\u0011\u0001)A\u0005{\"I\u0011qB\u0001C\u0002\u0013\u0005\u0011\u0011\u0003\u0005\t\u0003G\t\u0001\u0015!\u0003\u0002\u0014!A\u0011QE\u0001C\u0002\u0013%q\rC\u0004\u0002(\u0005\u0001\u000b\u0011\u00025\t\u000f\u0005%\u0012\u0001\"\u0001\u0002,!9\u00111J\u0001\u0005\u0002\u00055\u0003bBA4\u0003\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003\u0007\u000bA\u0011BAC\u0011\u001d\tY)\u0001C\u0005\u0003\u001bCq!!%\u0002\t\u0013\t\u0019\nC\u0004\u0002\u0018\u0006!I!!'\t\u0011\u0005u\u0015\u0001\"\u0001V\u0003?C\u0001\"a0\u0002\t\u0003)\u0016\u0011\u0019\u0005\t\u0003\u0013\fA\u0011A+\u0002L\u001a)A,\u0016\u0001\u0002R\"Q\u0011q\\\u000f\u0003\u0006\u0004%I!!9\t\u0015\u0005%XD!A!\u0002\u0013\t\u0019\u000f\u0003\u0004e;\u0011\u0005\u00111\u001e\u0005\u000b\u0003cl\"\u0019!C\u0001+\u0006M\b\u0002CA};\u0001\u0006I!!>\t\u0015\u0005mXD1A\u0005\u0002U\u000b\u0019\u0010\u0003\u0005\u0002~v\u0001\u000b\u0011BA{\u0011%\ty0\bb\u0001\n\u0013\u0011\t\u0001\u0003\u0005\u0003\u0006u\u0001\u000b\u0011\u0002B\u0002\u0011%\u00119!\bb\u0001\n\u0013\u0011\t\u0001\u0003\u0005\u0003\nu\u0001\u000b\u0011\u0002B\u0002\u0011)\u0011Y!\bb\u0001\n\u0003)&Q\u0002\u0005\t\u0005Gi\u0002\u0015!\u0003\u0003\u0010!I!QE\u000fC\u0002\u0013%!q\u0005\u0005\t\u0005ci\u0002\u0015!\u0003\u0003*!I!1G\u000fC\u0002\u0013%!Q\u0007\u0005\t\u0005\u0007j\u0002\u0015!\u0003\u00038!Y!QI\u000fA\u0002\u0003\u0007I\u0011BAq\u0011-\u00119%\ba\u0001\u0002\u0004%IA!\u0013\t\u0017\t=S\u00041A\u0001B\u0003&\u00111\u001d\u0005\n\u0005#j\"\u0019!C\u0005\u0005'B\u0001B!\u0019\u001eA\u0003%!Q\u000b\u0005\t\u0005GjB\u0011A+\u0003f!A!\u0011P\u000f\u0005\u0002U\u0013Y\bC\u0004\u0003~u!\tAa \t\u000f\t-U\u0004\"\u0001\u0003\u000e\"9!1S\u000f\u0005\u0002\tU\u0005b\u0002BM;\u0011\u0005!1\u0014\u0005\b\u0005?kB\u0011\u0002BQ\u0011!\u00119+\bC\u0001+\u0006\u0005\b\u0002\u0003BU;\u0011\u0005QKa+\t\u0011\tEV\u0004\"\u0001V\u0005WC\u0001Ba-\u001e\t\u0003)&Q\u0017\u0005\u000b\u0005\u0013l\u0012\u0013!C\u0001+\n-\u0007\u0002\u0003Bq;\u0011\u0005QKa9\t\u0015\t%X$%A\u0005\u0002U\u0013Y\r\u0003\u0005\u0003lv!\t!\u0016Bw\u0011\u001d\u0011\u00190\bC\u0005\u0005kDqa!\u0003\u001e\t\u0013\u0019Y\u0001\u0003\u0005\u0004\u000eu!\t!VB\b\u0011!\u00199\"\bC\u0001+\u000ee\u0001bBB\u0010;\u0011%1\u0011\u0005\u0005\b\u0007_iB\u0011BB\u0019\u0011!\u0019I$\bC\u0001+\u000em\u0002bBB!;\u0011%11\t\u0005\t\u0007\u0013jB\u0011A+\u0004L!91\u0011O\u000f\u0005\n\rM\u0004bBBP;\u0011%1\u0011\u0015\u0005\b\u0007OkB\u0011BBU\u0011\u001d\u0019i+\bC\u0005\u0007_C\u0011b!0\u001e#\u0003%IAa3\t\u000f\r}V\u0004\"\u0003\u0004B\"911[\u000f\u0005\n\rU\u0007bBB~;\u0011%1Q`\u0001\u0014\tft\u0017-\\5d\u0005J|7.\u001a:D_:4\u0017n\u001a\u0006\u0003-^\u000baa]3sm\u0016\u0014(\"\u0001-\u0002\u000b-\fgm[1\u0004\u0001A\u00111,A\u0007\u0002+\n\u0019B)\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jON\u0011\u0011A\u0018\t\u0003?\nl\u0011\u0001\u0019\u0006\u0002C\u0006)1oY1mC&\u00111\r\u0019\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Q\u0016A\u0006#z]\u0006l\u0017nY*fGV\u0014\u0018\u000e^=D_:4\u0017nZ:\u0016\u0003!\u00042!\u001b8q\u001b\u0005Q'BA6m\u0003\u001diW\u000f^1cY\u0016T!!\u001c1\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002pU\n\u00191+\u001a;\u0011\u0005E4X\"\u0001:\u000b\u0005M$\u0018\u0001\u00027b]\u001eT\u0011!^\u0001\u0005U\u00064\u0018-\u0003\u0002xe\n11\u000b\u001e:j]\u001e\fq\u0003R=oC6L7mU3dkJLG/_\"p]\u001aLwm\u001d\u0011\u0002#\u0005cG\u000eR=oC6L7mQ8oM&<7/\u0001\nBY2$\u0015P\\1nS\u000e\u001cuN\u001c4jON\u0004\u0013aG\"mkN$XM\u001d'fm\u0016dG*[:uK:,'oQ8oM&<7/F\u0001~!\rqx\u0010]\u0007\u0002Y&\u0011q\u000e\\\u0001\u001d\u00072,8\u000f^3s\u0019\u00164X\r\u001c'jgR,g.\u001a:D_:4\u0017nZ:!\u0003A\u0001VM\u001d\"s_.,'oQ8oM&<7/A\tQKJ\u0014%o\\6fe\u000e{gNZ5hg\u0002\n\u0001\u0004T5ti\u0016tWM]'fG\"\fg.[:n\u0007>tg-[4t\u0003ea\u0015n\u001d;f]\u0016\u0014X*Z2iC:L7/\\\"p]\u001aLwm\u001d\u0011\u0002+I+Gn\\1eC\ndWMR5mK\u000e{gNZ5hg\u00061\"+\u001a7pC\u0012\f'\r\\3GS2,7i\u001c8gS\u001e\u001c\b%A\nMSN$XM\\3s\u0007>tg-[4SK\u001e,\u00070\u0006\u0002\u0002\u0014A!\u0011QCA\u0010\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011\u0001C7bi\u000eD\u0017N\\4\u000b\u0007\u0005u\u0001-\u0001\u0003vi&d\u0017\u0002BA\u0011\u0003/\u0011QAU3hKb\fA\u0003T5ti\u0016tWM]\"p]\u001aLwMU3hKb\u0004\u0013A\u0006#z]\u0006l\u0017n\u0019)bgN<xN\u001d3D_:4\u0017nZ:\u0002/\u0011Kh.Y7jGB\u000b7o]<pe\u0012\u001cuN\u001c4jON\u0004\u0013\u0001E5t!\u0006\u001c8o^8sI\u000e{gNZ5h)\u0011\ti#a\r\u0011\u0007}\u000by#C\u0002\u00022\u0001\u0014qAQ8pY\u0016\fg\u000eC\u0004\u00026M\u0001\r!a\u000e\u0002\t9\fW.\u001a\t\u0005\u0003s\t9E\u0004\u0003\u0002<\u0005\r\u0003cAA\u001fA6\u0011\u0011q\b\u0006\u0004\u0003\u0003J\u0016A\u0002\u001fs_>$h(C\u0002\u0002F\u0001\fa\u0001\u0015:fI\u00164\u0017bA<\u0002J)\u0019\u0011Q\t1\u0002)\t\u0014xn[3s\u0007>tg-[4Ts:|g._7t)\u0019\ty%!\u0019\u0002dA1\u0011\u0011KA.\u0003oqA!a\u0015\u0002X9!\u0011QHA+\u0013\u0005\t\u0017bAA-A\u00069\u0001/Y2lC\u001e,\u0017\u0002BA/\u0003?\u0012A\u0001T5ti*\u0019\u0011\u0011\f1\t\u000f\u0005UB\u00031\u0001\u00028!9\u0011Q\r\u000bA\u0002\u00055\u0012!F7bi\u000eDG*[:uK:,'o\u0014<feJLG-Z\u0001\u0010m\u0006d\u0017\u000eZ1uK\u000e{gNZ5hgR1\u00111NA9\u0003\u007f\u00022aXA7\u0013\r\ty\u0007\u0019\u0002\u0005+:LG\u000fC\u0004\u0002tU\u0001\r!!\u001e\u0002\u000bA\u0014x\u000e]:\u0011\t\u0005]\u00141P\u0007\u0003\u0003sR1!!\bu\u0013\u0011\ti(!\u001f\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u0002\u0002V\u0001\r!!\f\u0002\u001fA,'O\u0011:pW\u0016\u00148i\u001c8gS\u001e\f\u0001\u0003]3s\u0005J|7.\u001a:D_:4\u0017nZ:\u0015\t\u0005\u001d\u0015\u0011\u0012\t\u0005}~\f9\u0004C\u0004\u0002tY\u0001\r!!\u001e\u0002#9|g\u000eR=oC6L7mQ8oM&<7\u000f\u0006\u0003\u0002\b\u0006=\u0005bBA:/\u0001\u0007\u0011QO\u0001%g\u0016\u001cWO]5us\u000e{gNZ5hg^KG\u000f[8vi2K7\u000f^3oKJ\u0004&/\u001a4jqR!\u0011qQAK\u0011\u001d\t\u0019\b\u0007a\u0001\u0003k\n1C^1mS\u0012\fG/Z\"p]\u001aLw\rV=qKN$B!a\u001b\u0002\u001c\"9\u00111O\rA\u0002\u0005U\u0014!E1eI\u0012Kh.Y7jG\u000e{gNZ5hgR!\u00111NAQ\u0011\u001d\t\u0019K\u0007a\u0001\u0003K\u000b\u0011bY8oM&<G)\u001a4\u0011\t\u0005\u001d\u00161X\u0007\u0003\u0003SSA!a+\u0002.\u000611m\u001c8gS\u001eTA!a,\u00022\u000611m\\7n_:T1\u0001WAZ\u0015\u0011\t),a.\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tI,A\u0002pe\u001eLA!!0\u0002*\nI1i\u001c8gS\u001e$UMZ\u0001\u0019Ift\u0017-\\5d\u0007>tg-[4Va\u0012\fG/Z'pI\u0016\u001cXCAAb!!\t9(!2\u00028\u0005]\u0012\u0002BAd\u0003s\u00121!T1q\u0003Y\u0011Xm]8mm\u00164\u0016M]5bE2,7i\u001c8gS\u001e\u001cH\u0003BA;\u0003\u001bDq!a4\u001d\u0001\u0004\t)(A\u0007qe>\u00048o\u0014:jO&t\u0017\r\\\n\u0005;y\u000b\u0019\u000e\u0005\u0003\u0002V\u0006mWBAAl\u0015\r\tInV\u0001\u0006kRLGn]\u0005\u0005\u0003;\f9NA\u0004M_\u001e<\u0017N\\4\u0002\u0017-\fgm[1D_:4\u0017nZ\u000b\u0003\u0003G\u00042aWAs\u0013\r\t9/\u0016\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0007lC\u001a\\\u0017mQ8oM&<\u0007\u0005\u0006\u0003\u0002n\u0006=\bCA.\u001e\u0011\u001d\ty\u000e\ta\u0001\u0003G\f1c\u001d;bi&\u001c'I]8lKJ\u001cuN\u001c4jON,\"!!>\u0011\u000b%\f9\u0010\u001d9\n\u0007\u0005\u001d'.\u0001\u000bti\u0006$\u0018n\u0019\"s_.,'oQ8oM&<7\u000fI\u0001\u0015gR\fG/[2EK\u001a\fW\u000f\u001c;D_:4\u0017nZ:\u0002+M$\u0018\r^5d\t\u00164\u0017-\u001e7u\u0007>tg-[4tA\u0005!B-\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jON,\"Aa\u0001\u0011\u000f%\f90a\u000e\u00028\u0005)B-\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jON\u0004\u0013!\u00063z]\u0006l\u0017n\u0019#fM\u0006,H\u000e^\"p]\u001aLwm]\u0001\u0017Ift\u0017-\\5d\t\u00164\u0017-\u001e7u\u0007>tg-[4tA\u0005y!/Z2p]\u001aLw-\u001e:bE2,7/\u0006\u0002\u0003\u0010A1!\u0011\u0003B\f\u00057i!Aa\u0005\u000b\t\tU\u0011\u0011P\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002\u0002B\r\u0005'\u0011AcQ8qs>swK]5uK\u0006\u0013(/Y=MSN$\b\u0003\u0002B\u000f\u0005?i!!!,\n\t\t\u0005\u0012Q\u0016\u0002\u000f%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0003A\u0011XmY8oM&<WO]1cY\u0016\u001c\b%A\u000bce>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z:\u0016\u0005\t%\u0002C\u0002B\t\u0005/\u0011Y\u0003E\u0002\\\u0005[I1Aa\fV\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mK\u00061\"M]8lKJ\u0014VmY8oM&<WO]1cY\u0016\u001c\b%\u0001\u0003m_\u000e\\WC\u0001B\u001c!\u0011\u0011IDa\u0010\u000e\u0005\tm\"\u0002\u0002B\u001f\u0005'\tQ\u0001\\8dWNLAA!\u0011\u0003<\t1\"+Z3oiJ\fg\u000e\u001e*fC\u0012<&/\u001b;f\u0019>\u001c7.A\u0003m_\u000e\\\u0007%A\u0007dkJ\u0014XM\u001c;D_:4\u0017nZ\u0001\u0012GV\u0014(/\u001a8u\u0007>tg-[4`I\u0015\fH\u0003BA6\u0005\u0017B\u0011B!\u00141\u0003\u0003\u0005\r!a9\u0002\u0007a$\u0013'\u0001\bdkJ\u0014XM\u001c;D_:4\u0017n\u001a\u0011\u00029\u0011Lh.Y7jG\u000e{gNZ5h!\u0006\u001c8o^8sI\u0016s7m\u001c3feV\u0011!Q\u000b\t\u0006?\n]#1L\u0005\u0004\u00053\u0002'AB(qi&|g\u000e\u0005\u0003\u0002V\nu\u0013\u0002\u0002B0\u0003/\u0014q\u0002U1tg^|'\u000fZ#oG>$WM]\u0001\u001eIft\u0017-\\5d\u0007>tg-[4QCN\u001cxo\u001c:e\u000b:\u001cw\u000eZ3sA\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\t\u0005-$q\r\u0005\b\u0005S\"\u0004\u0019\u0001B6\u0003-Q8n\u00117jK:$x\n\u001d;\u0011\u000b}\u00139F!\u001c\u0011\t\t=$QO\u0007\u0003\u0005cR1Aa\u001dX\u0003\tQ8.\u0003\u0003\u0003x\tE$!D&bM.\f'l[\"mS\u0016tG/A\u0003dY\u0016\f'\u000f\u0006\u0002\u0002l\u0005\u0011\u0012\r\u001a3SK\u000e|gNZ5hkJ\f'\r\\3t)\u0011\tYG!!\t\u000f\t\re\u00071\u0001\u0003\u0006\u0006Y1.\u00194lCN+'O^3s!\rY&qQ\u0005\u0004\u0005\u0013+&aC&bM.\f'I]8lKJ\f\u0011#\u00193e%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f)\u0011\tYGa$\t\u000f\tEu\u00071\u0001\u0003\u001c\u0005q!/Z2p]\u001aLw-\u001e:bE2,\u0017aF1eI\n\u0013xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f)\u0011\tYGa&\t\u000f\tE\u0005\b1\u0001\u0003,\u0005!\"/Z7pm\u0016\u0014VmY8oM&<WO]1cY\u0016$B!a\u001b\u0003\u001e\"9!\u0011S\u001dA\u0002\tm\u0011a\u0007<fe&4\u0017PU3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000f\u0006\u0003\u0002l\t\r\u0006b\u0002BSu\u0001\u0007\u0011qQ\u0001\fG>tg-[4OC6,7/\u0001\ndkJ\u0014XM\u001c;LC\u001a\\\u0017mQ8oM&<\u0017aG2veJ,g\u000e\u001e#z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<7/\u0006\u0002\u0003.B9aPa,\u00028\u0005]\u0012bAAdY\u0006a2-\u001e:sK:$H)\u001f8b[&\u001cG)\u001a4bk2$8i\u001c8gS\u001e\u001c\u0018AE;qI\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e$\u0002\"a\u001b\u00038\n\u0005'Q\u0019\u0005\b\u0005ss\u0004\u0019\u0001B^\u0003!\u0011'o\\6fe&#\u0007cA0\u0003>&\u0019!q\u00181\u0003\u0007%sG\u000fC\u0004\u0003Dz\u0002\r!!\u001e\u0002\u001fA,'o]5ti\u0016tG\u000f\u0015:paND\u0011Ba2?!\u0003\u0005\r!!\f\u0002\u000b\u0011|Gj\\4\u00029U\u0004H-\u0019;f\u0005J|7.\u001a:D_:4\u0017n\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u001a\u0016\u0005\u0003[\u0011ym\u000b\u0002\u0003RB!!1\u001bBo\u001b\t\u0011)N\u0003\u0003\u0003X\ne\u0017!C;oG\",7m[3e\u0015\r\u0011Y\u000eY\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bp\u0005+\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003M)\b\u000fZ1uK\u0012+g-Y;mi\u000e{gNZ5h)\u0019\tYG!:\u0003h\"9!1\u0019!A\u0002\u0005U\u0004\"\u0003Bd\u0001B\u0005\t\u0019AA\u0017\u0003u)\b\u000fZ1uK\u0012+g-Y;mi\u000e{gNZ5hI\u0011,g-Y;mi\u0012\u0012\u0014!\n:fY>\fG-\u00169eCR,GMR5mKN<\u0016\u000e\u001e5pkR\u001cuN\u001c4jO\u000eC\u0017M\\4f)\u0011\tYGa<\t\u000f\tE(\t1\u0001\u0002v\u0005Aa.Z<Qe>\u00048/\u0001\u000enCf\u0014Wm\u0011:fCR,\u0007+Y:to>\u0014H-\u00128d_\u0012,'\u000f\u0006\u0003\u0003V\t]\bb\u0002B}\u0007\u0002\u0007!1`\u0001\u0007g\u0016\u001c'/\u001a;\u0011\u000b}\u00139F!@\u0011\t\t}8QA\u0007\u0003\u0007\u0003QAaa\u0001\u0002*\u0006)A/\u001f9fg&!1qAB\u0001\u0005!\u0001\u0016m]:x_J$\u0017a\u00049bgN<xN\u001d3F]\u000e|G-\u001a:\u0016\u0005\tm\u0013!\u0005;p!\u0016\u00148/[:uK:$\bK]8qgR1\u0011QOB\t\u0007+Aqaa\u0005F\u0001\u0004\t)(A\u0006d_:4\u0017n\u001a)s_B\u001c\bbBAA\u000b\u0002\u0007\u0011QF\u0001\u0014MJ|W\u000eU3sg&\u001cH/\u001a8u!J|\u0007o\u001d\u000b\u0007\u0003k\u001aYb!\b\t\u000f\t\rg\t1\u0001\u0002v!9\u0011\u0011\u0011$A\u0002\u00055\u0012AF7bs\n,'+Z#oG>$W\rU1tg^|'\u000fZ:\u0015\r\u0005U41EB\u0013\u0011\u001d\u0011\u0019m\u0012a\u0001\u0003kBqaa\nH\u0001\u0004\u0019I#A\u0007bI6LgNW6DY&,g\u000e\u001e\t\u0005\u0005_\u001aY#\u0003\u0003\u0004.\tE$!D!e[&t'l[\"mS\u0016tG/A\nwC2LG-\u0019;fI.\u000bgm[1Qe>\u00048\u000f\u0006\u0004\u0003.\u000eM2q\u0007\u0005\b\u0007kA\u0005\u0019AA;\u00035\u0001(o\u001c9t\u001fZ,'O]5eK\"9\u0011\u0011\u0011%A\u0002\u00055\u0012\u0001\u0003<bY&$\u0017\r^3\u0015\r\u0005-4QHB \u0011\u001d\t\u0019(\u0013a\u0001\u0003kBq!!!J\u0001\u0004\ti#\u0001\u000bsK6|g/Z%om\u0006d\u0017\u000eZ\"p]\u001aLwm\u001d\u000b\u0007\u0003W\u001a)ea\u0012\t\u000f\u0005M$\n1\u0001\u0002v!9\u0011\u0011\u0011&A\u0002\u00055\u0012\u0001E7bs\n,'+Z2p]\u001aLw-\u001e:f)!\tYg!\u0014\u0004P\rM\u0003b\u0002BI\u0017\u0002\u0007!1\u0004\u0005\b\u0007#Z\u0005\u0019AAr\u0003%yG\u000eZ\"p]\u001aLw\rC\u0004\u0004V-\u0003\raa\u0016\u0002\u00139,woQ8oM&<\u0007\u0007BB-\u0007?\u0002\u0002\"a\u001e\u0002F\u0006]21\f\t\u0005\u0007;\u001ay\u0006\u0004\u0001\u0005\u0019\r\u000541KA\u0001\u0002\u0003\u0015\taa\u0019\u0003\u0007}#\u0013'\u0005\u0003\u0004f\r-\u0004cA0\u0004h%\u00191\u0011\u000e1\u0003\u000f9{G\u000f[5oOB\u0019ql!\u001c\n\u0007\r=\u0004MA\u0002B]f\fa\"\u001e9eCR,GmQ8oM&<7\u000f\u0006\u0004\u0004v\r\u00155\u0011\u0013\t\b?\u000e]41PAD\u0013\r\u0019I\b\u0019\u0002\u0007)V\u0004H.\u001a\u001a1\t\ru4\u0011\u0011\t\bS\u0006]\u0018qGB@!\u0011\u0019if!!\u0005\u0017\r\rE*!A\u0001\u0002\u000b\u000511\r\u0002\u0004?\u0012\"\u0004b\u0002By\u0019\u0002\u00071q\u0011\u0019\u0005\u0007\u0013\u001bi\t\u0005\u0005\u0002x\u0005\u0015\u0017qGBF!\u0011\u0019if!$\u0005\u0019\r=5QQA\u0001\u0002\u0003\u0015\taa\u0019\u0003\u0007}##\u0007C\u0004\u0004\u00142\u0003\ra!&\u0002\u0019\r,(O]3oiB\u0013x\u000e]:1\t\r]51\u0014\t\t\u0003o\n)-a\u000e\u0004\u001aB!1QLBN\t1\u0019ij!%\u0002\u0002\u0003\u0005)\u0011AB2\u0005\ryFeM\u0001\u000e_Z,'O]5eKB\u0013x\u000e]:\u0015\r\u0005-41UBS\u0011\u001d\t\u0019(\u0014a\u0001\u0005\u0007Aqa!\u000eN\u0001\u0004\u0011\u0019!A\nva\u0012\fG/Z\"veJ,g\u000e^\"p]\u001aLw\r\u0006\u0003\u0002l\r-\u0006b\u0002Bd\u001d\u0002\u0007\u0011QF\u0001\u0017aJ|7-Z:t%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]RA1\u0011WB[\u0007o\u001bY\fE\u0004`\u0007o\n\u0019oa-\u0011\r\u0005E\u00131\fB\u0016\u0011\u001d\u0011\tp\u0014a\u0001\u0005[Cqa!/P\u0001\u0004\ti#\u0001\u0007wC2LG-\u0019;f\u001f:d\u0017\u0010C\u0005\u0003H>\u0003\n\u00111\u0001\u0002.\u0005\u0001\u0003O]8dKN\u001c(+Z2p]\u001aLw-\u001e:bi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0003QqW-\u001a3t%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]RA\u0011QFBb\u0007\u0017\u001cy\rC\u0004\u0004FF\u0003\raa2\u0002+I,7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgB1\u0011qOBe\u0003oI1a\\A=\u0011\u001d\u0019i-\u0015a\u0001\u0003\u000f\u000b1\"\u001e9eCR,GmS3zg\"91\u0011[)A\u0002\u0005\u001d\u0015a\u00033fY\u0016$X\rZ&fsN\fQ\u0004\u001d:pG\u0016\u001c8\u000fT5ti\u0016tWM\u001d*fG>tg-[4ve\u0006\u0014G.\u001a\u000b\r\u0003W\u001a9na:\u0004j\u000eU8q\u001f\u0005\b\u00073\u0014\u0006\u0019ABn\u0003Ya\u0017n\u001d;f]\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,\u0007\u0003BBo\u0007Gl!aa8\u000b\t\r\u0005\u0018QV\u0001\b]\u0016$xo\u001c:l\u0013\u0011\u0019)oa8\u0003-1K7\u000f^3oKJ\u0014VmY8oM&<WO]1cY\u0016Dqa!\u0016S\u0001\u0004\t\u0019\u000fC\u0004\u0004lJ\u0003\ra!<\u0002\u001b\r,8\u000f^8n\u0007>tg-[4t!!\t9(!2\u00028\r=\bcA9\u0004r&\u001911\u001f:\u0003\r=\u0013'.Z2u\u0011\u001d\u0019IL\u0015a\u0001\u0003[Aqa!?S\u0001\u0004\ti#\u0001\u0006sK2|\u0017\rZ(oYf\fQ\u0003\u001d:pG\u0016\u001c8OU3d_:4\u0017nZ;sC\ndW\r\u0006\u0007\u0002l\r}H\u0011\u0001C\u0003\t'!9\u0002C\u0004\u0003\u0012N\u0003\rAa\u0007\t\u000f\u0011\r1\u000b1\u0001\u0002\b\u0006\u0011R\u000f\u001d3bi\u0016$7i\u001c8gS\u001et\u0015-\\3t\u0011\u001d!9a\u0015a\u0001\t\u0013\tQ\"\u00197m\u001d\u0016<8i\u001c8gS\u001e\u001c\b\u0007\u0002C\u0006\t\u001f\u0001\u0002\"a\u001e\u0002F\u0006]BQ\u0002\t\u0005\u0007;\"y\u0001\u0002\u0007\u0005\u0012\u0011\u0015\u0011\u0011!A\u0001\u0006\u0003\u0019\u0019GA\u0002`IUBq\u0001\"\u0006T\u0001\u0004\u0019i/\u0001\toK^\u001cUo\u001d;p[\u000e{gNZ5hg\"91\u0011X*A\u0002\u00055\u0002")
public class DynamicBrokerConfig
implements Logging {
    private final KafkaConfig kafkaConfig;
    private final scala.collection.mutable.Map<String, String> staticBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> staticDefaultConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicDefaultConfigs;
    private final CopyOnWriteArrayList<Reconfigurable> reconfigurables;
    private final CopyOnWriteArrayList<BrokerReconfigurable> brokerReconfigurables;
    private final ReentrantReadWriteLock lock;
    private KafkaConfig currentConfig;
    private final Option<PasswordEncoder> dynamicConfigPasswordEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void validateConfigs(Properties props, boolean perBrokerConfig) {
        DynamicBrokerConfig$.MODULE$.validateConfigs(props, perBrokerConfig);
    }

    public static List<String> brokerConfigSynonyms(String name, boolean matchListenerOverride) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, matchListenerOverride);
    }

    public static boolean isPasswordConfig(String name) {
        return DynamicBrokerConfig$.MODULE$.isPasswordConfig(name);
    }

    public static Regex ListenerConfigRegex() {
        return DynamicBrokerConfig$.MODULE$.ListenerConfigRegex();
    }

    public static scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public scala.collection.mutable.Map<String, String> staticBrokerConfigs() {
        return this.staticBrokerConfigs;
    }

    public scala.collection.mutable.Map<String, String> staticDefaultConfigs() {
        return this.staticDefaultConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicBrokerConfigs() {
        return this.dynamicBrokerConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicDefaultConfigs() {
        return this.dynamicDefaultConfigs;
    }

    public CopyOnWriteArrayList<Reconfigurable> reconfigurables() {
        return this.reconfigurables;
    }

    private CopyOnWriteArrayList<BrokerReconfigurable> brokerReconfigurables() {
        return this.brokerReconfigurables;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private KafkaConfig currentConfig() {
        return this.currentConfig;
    }

    private void currentConfig_$eq(KafkaConfig x$1) {
        this.currentConfig = x$1;
    }

    private Option<PasswordEncoder> dynamicConfigPasswordEncoder() {
        return this.dynamicConfigPasswordEncoder;
    }

    public void initialize(Option<KafkaZkClient> zkClientOpt) {
        this.currentConfig_$eq(new KafkaConfig(this.kafkaConfig().props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$));
        zkClientOpt.foreach((Function1 & Serializable)zkClient -> {
            DynamicBrokerConfig.$anonfun$initialize$1(this, zkClient);
            return BoxedUnit.UNIT;
        });
    }

    public void clear() {
        this.dynamicBrokerConfigs().clear();
        this.dynamicDefaultConfigs().clear();
        this.reconfigurables().clear();
        this.brokerReconfigurables().clear();
    }

    public void addReconfigurables(KafkaBroker kafkaServer) {
        Authorizer authz;
        Option<Authorizer> option = kafkaServer.authorizer();
        if (option instanceof Some && (authz = (Authorizer)((Some)option).value()) instanceof Reconfigurable) {
            this.addReconfigurable((Reconfigurable)authz);
        }
        this.addReconfigurable((Reconfigurable)kafkaServer.kafkaYammerMetrics());
        this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().brokerId(), kafkaServer.config(), kafkaServer.metrics(), kafkaServer.clusterId()));
        this.addReconfigurable(new DynamicClientQuotaCallback(kafkaServer));
        this.addBrokerReconfigurable(new DynamicThreadPool(kafkaServer));
        this.addBrokerReconfigurable(new DynamicLogConfig(kafkaServer.logManager(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicListenerConfig(kafkaServer));
        this.addBrokerReconfigurable(kafkaServer.socketServer());
        this.addBrokerReconfigurable(kafkaServer.logManager().producerStateManagerConfig());
    }

    public void addReconfigurable(Reconfigurable reconfigurable) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void addBrokerReconfigurable(BrokerReconfigurable reconfigurable) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addBrokerReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void removeReconfigurable(Reconfigurable reconfigurable) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$removeReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private void verifyReconfigurableConfigs(Set<String> configNames) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$1(configNames);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public KafkaConfig currentKafkaConfig() {
        KafkaConfig kafkaConfig;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            kafkaConfig = this.currentConfig();
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return kafkaConfig;
    }

    public Map<String, String> currentDynamicBrokerConfigs() {
        scala.collection.mutable.Map map;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicBrokerConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    public Map<String, String> currentDynamicDefaultConfigs() {
        scala.collection.mutable.Map map;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicDefaultConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    public void updateBrokerConfig(int brokerId, Properties persistentProps, boolean doLog) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateBrokerConfig$1(this, persistentProps, doLog, brokerId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public boolean updateBrokerConfig$default$3() {
        return true;
    }

    public void updateDefaultConfig(Properties persistentProps, boolean doLog) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateDefaultConfig$1(this, persistentProps, doLog);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public boolean updateDefaultConfig$default$2() {
        return true;
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties newProps) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$1(this, newProps);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private Option<PasswordEncoder> maybeCreatePasswordEncoder(Option<Password> secret2) {
        return secret2.map((Function1 & Serializable)secret -> {
            void encrypting_iterations;
            void encrypting_keyLength;
            int n = Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderIterations());
            int n2 = Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderKeyLength());
            String encrypting_cipherAlgorithm = this.kafkaConfig().passwordEncoderCipherAlgorithm();
            Option<String> encrypting_keyFactoryAlgorithm = this.kafkaConfig().passwordEncoderKeyFactoryAlgorithm();
            return new EncryptingPasswordEncoder((Password)secret, encrypting_keyFactoryAlgorithm, encrypting_cipherAlgorithm, (int)encrypting_keyLength, (int)encrypting_iterations);
        });
    }

    private PasswordEncoder passwordEncoder() {
        return (PasswordEncoder)this.dynamicConfigPasswordEncoder().getOrElse((Function0 & Serializable)() -> {
            throw new ConfigException("Password encoder secret not configured");
        });
    }

    public Properties toPersistentProps(Properties configProps, boolean perBrokerConfig) {
        Properties props = (Properties)configProps.clone();
        CollectionConverters$.MODULE$.PropertiesHasAsScala(configProps).asScala().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$toPersistentProps$1(this, perBrokerConfig, props, name, value);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        return props;
    }

    public Properties fromPersistentProps(Properties persistentProps, boolean perBrokerConfig) {
        Properties props = (Properties)persistentProps.clone();
        this.removeInvalidConfigs(props, perBrokerConfig);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Non-dynamic configs configured in ZooKeeper will be ignored", props);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "Security configs can be dynamically updated only using listener prefix, base configs will be ignored", props);
        if (!perBrokerConfig) {
            this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Per-broker configs defined at default cluster level will be ignored", props);
        }
        CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$fromPersistentProps$5(this, props, name, value);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        return props;
    }

    private Properties maybeReEncodePasswords(Properties persistentProps, AdminZkClient adminZkClient) {
        Properties props = (Properties)persistentProps.clone();
        if (CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().keySet().exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)))) {
            this.maybeCreatePasswordEncoder(this.kafkaConfig().passwordEncoderOldSecret()).foreach((Function1 & Serializable)passwordDecoder -> {
                DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$2(this, persistentProps, props, adminZkClient, passwordDecoder);
                return BoxedUnit.UNIT;
            });
        }
        return props;
    }

    private Map<String, String> validatedKafkaProps(Properties propsOverride, boolean perBrokerConfig) {
        Properties propsResolved = DynamicBrokerConfig$.MODULE$.resolveVariableConfigs(propsOverride);
        DynamicBrokerConfig$.MODULE$.validateConfigs(propsResolved, perBrokerConfig);
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        if (perBrokerConfig) {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(propsResolved).asScala());
        } else {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(propsResolved).asScala());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        }
        return newProps;
    }

    public void validate(Properties props, boolean perBrokerConfig) {
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$validate$1(this, props, perBrokerConfig);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void removeInvalidConfigs(Properties props, boolean perBrokerConfig) {
        try {
            DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
            CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala();
            return;
        }
        catch (Exception e) {
            scala.collection.mutable.Map invalidProps = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$removeInvalidConfigs$1(x0$1)));
            invalidProps.keys().foreach((Function1 & Serializable)x$1 -> props.remove(x$1));
            String configSource = perBrokerConfig ? "broker" : "default cluster";
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Dynamic ").append(configSource).append(" config contains invalid values in: ").append(invalidProps.keys()).append(", these configs will be ignored").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public void maybeReconfigure(Reconfigurable reconfigurable, KafkaConfig oldConfig, java.util.Map<String, ?> newConfig) {
        if (CollectionConverters$.MODULE$.SetHasAsScala(reconfigurable.reconfigurableConfigs()).asScala().exists((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$maybeReconfigure$1(oldConfig, newConfig, key)))) {
            reconfigurable.reconfigure(newConfig);
            return;
        }
    }

    private Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> updatedConfigs(java.util.Map<String, ?> newProps, java.util.Map<String, ?> currentProps) {
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(newProps).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$1(currentProps, x0$1)));
        Set deletedKeySet = ((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(currentProps).asScala().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$2(newProps, x0$2)))).keySet();
        return new Tuple2((Object)changeMap, (Object)deletedKeySet);
    }

    private void overrideProps(scala.collection.mutable.Map<String, String> props, scala.collection.mutable.Map<String, String> propsOverride) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(k, v) -> {
            DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms((String)k, false).foreach((Function1 & Serializable)key -> props.remove(key));
            return props.put(k, v);
        };
        propsOverride.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private void updateCurrentConfig(boolean doLog) {
        void var5_5;
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        KafkaConfig oldConfig = this.currentConfig();
        Tuple2<KafkaConfig, List<BrokerReconfigurable>> tuple2 = this.processReconfiguration((Map<String, String>)newProps, false, doLog);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig newConfig = (KafkaConfig)tuple2._1();
        List brokerReconfigurablesToUpdate = (List)tuple2._2();
        if (var5_5 != this.currentConfig()) {
            void var6_6;
            this.currentConfig_$eq((KafkaConfig)var5_5);
            this.kafkaConfig().updateCurrentConfig((KafkaConfig)var5_5);
            var6_6.foreach(arg_0 -> DynamicBrokerConfig.$anonfun$updateCurrentConfig$1$adapted(oldConfig, (KafkaConfig)var5_5, arg_0));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<KafkaConfig, List<BrokerReconfigurable>> processReconfiguration(Map<String, String> newProps, boolean validateOnly, boolean doLog) {
        void var7_7;
        void var6_6;
        KafkaConfig newConfig = new KafkaConfig(CollectionConverters$.MODULE$.MapHasAsJava(newProps).asJava(), doLog, (Option<DynamicBrokerConfig>)None$.MODULE$);
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newConfig.originalsFromThisConfig(), this.currentConfig().originals());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeySet = (Set)tuple2._2();
        if (var6_6.nonEmpty() || var7_7.nonEmpty()) {
            try {
                HashMap<String, Object> customConfigs = new HashMap<String, Object>(newConfig.originalsFromThisConfig());
                newConfig.valuesFromThisConfig().keySet().forEach(k -> customConfigs.remove(k));
                this.reconfigurables().forEach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$2(this, newConfig, customConfigs, validateOnly, (scala.collection.mutable.Map)var6_6, (Set)var7_7, arg_0));
                Buffer brokerReconfigurablesToUpdate = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.brokerReconfigurables().forEach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$3(this, (scala.collection.mutable.Map)var6_6, (Set)var7_7, newConfig, validateOnly, brokerReconfigurablesToUpdate, arg_0));
                return new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate.toList());
            }
            catch (Exception e) {
                if (!validateOnly) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Failed to update broker configuration with configs : ").append(ConfigUtils.configMapToRedactedString(newConfig.originalsFromThisConfig(), (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
                throw new ConfigException("Invalid dynamic configuration", (Object)e);
            }
        }
        return new Tuple2((Object)this.currentConfig(), (Object)package$.MODULE$.List().empty());
    }

    private boolean processReconfiguration$default$3() {
        return false;
    }

    private boolean needsReconfiguration(java.util.Set<String> reconfigurableConfigs, Set<String> updatedKeys, Set<String> deletedKeys) {
        return CollectionConverters$.MODULE$.SetHasAsScala(reconfigurableConfigs).asScala().intersect(updatedKeys).nonEmpty() || CollectionConverters$.MODULE$.SetHasAsScala(reconfigurableConfigs).asScala().intersect(deletedKeys).nonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private void processListenerReconfigurable(ListenerReconfigurable listenerReconfigurable, KafkaConfig newConfig, java.util.Map<String, Object> customConfigs, boolean validateOnly, boolean reloadOnly) {
        void var11_11;
        void var10_10;
        ListenerName listenerName = listenerReconfigurable.listenerName();
        java.util.Map<String, Object> oldValues = this.currentConfig().valuesWithPrefixOverride(listenerName.configPrefix());
        java.util.Map<String, Object> newValues = newConfig.valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newValues, oldValues);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeys = (Set)tuple2._2();
        Set updatedKeys = var10_10.keySet();
        boolean configsChanged = this.needsReconfiguration(listenerReconfigurable.reconfigurableConfigs(), (Set<String>)updatedKeys, (Set<String>)var11_11);
        if (reloadOnly != configsChanged) {
            this.processReconfigurable((Reconfigurable)listenerReconfigurable, (Set<String>)updatedKeys, newValues, customConfigs, validateOnly);
            return;
        }
    }

    private void processReconfigurable(Reconfigurable reconfigurable, Set<String> updatedConfigNames, java.util.Map<String, ?> allNewConfigs, java.util.Map<String, Object> newCustomConfigs, boolean validateOnly) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>();
        allNewConfigs.forEach((k, v) -> newConfigs.put((String)k, v));
        newConfigs.putAll(newCustomConfigs);
        try {
            reconfigurable.validateReconfiguration(newConfigs);
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            throw new ConfigException(new StringBuilder(58).append("Validation of dynamic config update of ").append(updatedConfigNames).append(" failed with class ").append(reconfigurable.getClass()).toString());
        }
        if (!validateOnly) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Reconfiguring ").append(reconfigurable).append(", updated configs: ").append(updatedConfigNames).append(" ").append("custom configs: ").append(ConfigUtils.configMapToRedactedString((java.util.Map)newCustomConfigs, (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString());
            reconfigurable.reconfigure(newConfigs);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$initialize$1(DynamicBrokerConfig $this, KafkaZkClient zkClient) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        $this.updateDefaultConfig(adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default()), false);
        Properties props = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString($this.kafkaConfig().brokerId()));
        Properties brokerConfig = $this.maybeReEncodePasswords(props, adminZkClient);
        $this.updateBrokerConfig($this.kafkaConfig().brokerId(), brokerConfig, $this.updateBrokerConfig$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$addReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$1) {
        $this.verifyReconfigurableConfigs((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(reconfigurable$1.reconfigurableConfigs()).asScala());
        return $this.reconfigurables().add(reconfigurable$1);
    }

    public static final /* synthetic */ boolean $anonfun$addBrokerReconfigurable$1(DynamicBrokerConfig $this, BrokerReconfigurable reconfigurable$2) {
        $this.verifyReconfigurableConfigs(reconfigurable$2.reconfigurableConfigs());
        return $this.brokerReconfigurables().add(reconfigurable$2);
    }

    public static final /* synthetic */ boolean $anonfun$removeReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$3) {
        return $this.reconfigurables().remove(reconfigurable$3);
    }

    public static final /* synthetic */ boolean $anonfun$verifyReconfigurableConfigs$2(String elem) {
        return DynamicConfig$Broker$.MODULE$.nonDynamicProps().contains((Object)elem);
    }

    public static final /* synthetic */ void $anonfun$verifyReconfigurableConfigs$1(Set configNames$1) {
        Set nonDynamic = (Set)configNames$1.filter((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$2(elem)));
        Predef$.MODULE$.require(nonDynamic.isEmpty(), (Function0 & Serializable)() -> new StringBuilder(44).append("Reconfigurable contains non-dynamic configs ").append(nonDynamic).toString());
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicBrokerConfigs$1(DynamicBrokerConfig $this) {
        return (scala.collection.mutable.Map)$this.dynamicBrokerConfigs().clone();
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicDefaultConfigs$1(DynamicBrokerConfig $this) {
        return (scala.collection.mutable.Map)$this.dynamicDefaultConfigs().clone();
    }

    public static final /* synthetic */ void $anonfun$updateBrokerConfig$1(DynamicBrokerConfig $this, Properties persistentProps$1, boolean doLog$1, int brokerId$1) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$1, true);
            $this.dynamicBrokerConfigs().clear();
            $this.dynamicBrokerConfigs().$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala());
            $this.updateCurrentConfig(doLog$1);
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Per-broker configs of ").append(brokerId$1).append(" could not be applied: ").append(persistentProps$1.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateDefaultConfig$1(DynamicBrokerConfig $this, Properties persistentProps$2, boolean doLog$2) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$2, false);
            $this.dynamicDefaultConfigs().clear();
            $this.dynamicDefaultConfigs().$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala());
            $this.updateCurrentConfig(doLog$2);
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Cluster default configs could not be applied: ").append(persistentProps$2.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$reloadUpdatedFilesWithoutConfigChange$2(Reconfigurable reconfigurable) {
        return DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs().exists(arg_0 -> DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(reconfigurable.reconfigurableConfigs(), arg_0));
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$4(DynamicBrokerConfig $this, Properties newProps$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            Map<String, String> kafkaProps = $this.validatedKafkaProps(newProps$1, true);
            KafkaConfig newConfig = new KafkaConfig(CollectionConverters$.MODULE$.MapHasAsJava(kafkaProps).asJava(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig, Collections.emptyMap(), false, true);
            return;
        }
        $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Files will not be reloaded without config change for ").append(x0$1).toString());
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$1(DynamicBrokerConfig $this, Properties newProps$1) {
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala($this.reconfigurables()).asScala().filter((Function1 & Serializable)reconfigurable -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$2(reconfigurable)))).foreach((Function1 & Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$4($this, newProps$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void encodePassword$1(String configName, String value, boolean perBrokerConfig$1, Properties props$3) {
        if (value != null) {
            if (!perBrokerConfig$1) {
                throw new ConfigException("Password config can be defined only at broker level");
            }
            props$3.setProperty(configName, this.passwordEncoder().encode(new Password(value)));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$toPersistentProps$1(DynamicBrokerConfig $this, boolean perBrokerConfig$1, Properties props$3, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.encodePassword$1(name, value, perBrokerConfig$1, props$3);
            return;
        }
    }

    private final void removeInvalidProps$1(Set invalidPropNames, String errorMessage, Properties props$4) {
        if (invalidPropNames.nonEmpty()) {
            invalidPropNames.foreach((Function1 & Serializable)x$1 -> props$4.remove(x$1));
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
            return;
        }
    }

    private final void decodePassword$1(String configName, String value, Properties props$4) {
        if (value != null) {
            try {
                props$4.setProperty(configName, this.passwordEncoder().decode(value).value());
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Dynamic password config ").append(configName).append(" could not be decoded, ignoring.").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                props$4.remove(configName);
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$fromPersistentProps$5(DynamicBrokerConfig $this, Properties props$4, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.decodePassword$1(name, value, props$4);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$3(DynamicBrokerConfig $this, PasswordEncoder passwordDecoder$1, Properties props$5, String configName, String value2) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(configName) && value2 != null) {
            Some some;
            try {
                some = new Some((Object)passwordDecoder$1.decode(value2).value());
            }
            catch (Exception exception) {
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(88).append("Dynamic password config ").append(configName).append(" could not be decoded using old secret, new secret will be used.").toString());
                some = None$.MODULE$;
            }
            some.foreach((Function1 & Serializable)value -> props$5.put(configName, $this.passwordEncoder().encode(new Password(value))));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$2(DynamicBrokerConfig $this, Properties persistentProps$3, Properties props$5, AdminZkClient adminZkClient$1, PasswordEncoder passwordDecoder) {
        CollectionConverters$.MODULE$.PropertiesHasAsScala(persistentProps$3).asScala().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(configName, value) -> {
            DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$3($this, passwordDecoder, props$5, configName, value);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        adminZkClient$1.changeBrokerConfig((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)$this.kafkaConfig().brokerId())), props$5);
    }

    public static final /* synthetic */ Tuple2 $anonfun$validate$1(DynamicBrokerConfig $this, Properties props$6, boolean perBrokerConfig$2) {
        Map<String, String> newProps = $this.validatedKafkaProps(props$6, perBrokerConfig$2);
        return $this.processReconfiguration(newProps, true, false);
    }

    public static final /* synthetic */ boolean $anonfun$removeInvalidConfigs$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Properties props1 = new Properties();
            props1.put(k, v);
            try {
                DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props1);
                return false;
            }
            catch (Exception exception) {
                return true;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$maybeReconfigure$1(KafkaConfig oldConfig$1, java.util.Map newConfig$1, String key) {
        return !BoxesRunTime.equals((Object)oldConfig$1.originals().get(key), newConfig$1.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$1(java.util.Map currentProps$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            return !BoxesRunTime.equals((Object)x0$1._2(), currentProps$1.get(k));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$2(java.util.Map newProps$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            String k = (String)x0$2._1();
            return !newProps$2.containsKey(k);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$2(DynamicBrokerConfig $this, KafkaConfig newConfig$3, HashMap customConfigs$1, boolean validateOnly$1, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig$3, customConfigs$1, validateOnly$1, false);
            return;
        }
        if ($this.needsReconfiguration(x0$1.reconfigurableConfigs(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            $this.processReconfigurable(x0$1, (Set<String>)changeMap$1.keySet(), newConfig$3.valuesFromThisConfig(), customConfigs$1, validateOnly$1);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$3(DynamicBrokerConfig $this, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, KafkaConfig newConfig$3, boolean validateOnly$1, Buffer brokerReconfigurablesToUpdate$1, BrokerReconfigurable reconfigurable) {
        if ($this.needsReconfiguration(CollectionConverters$.MODULE$.SetHasAsJava(reconfigurable.reconfigurableConfigs()).asJava(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            reconfigurable.validateReconfiguration(newConfig$3);
            if (!validateOnly$1) {
                brokerReconfigurablesToUpdate$1.$plus$eq((Object)reconfigurable);
                return;
            }
            return;
        }
    }

    public DynamicBrokerConfig(KafkaConfig kafkaConfig) {
        Option<PasswordEncoder> option;
        this.kafkaConfig = kafkaConfig;
        this.staticBrokerConfigs = CollectionConverters$.MODULE$.MapHasAsScala(ConfigDef.convertToStringMapWithPasswordValues(kafkaConfig.originalsFromThisConfig())).asScala();
        this.staticDefaultConfigs = CollectionConverters$.MODULE$.MapHasAsScala(ConfigDef.convertToStringMapWithPasswordValues((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(KafkaConfig$.MODULE$.defaultValues()).asJava())).asScala();
        this.dynamicBrokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dynamicDefaultConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.reconfigurables = new CopyOnWriteArrayList();
        this.brokerReconfigurables = new CopyOnWriteArrayList();
        this.lock = new ReentrantReadWriteLock();
        if (kafkaConfig.processRoles().isEmpty()) {
            option = this.maybeCreatePasswordEncoder(kafkaConfig.passwordEncoderSecret());
        } else {
            Option<PasswordEncoder> option2;
            option = option2;
            super((Object)new NoOpPasswordEncoder());
        }
        this.dynamicConfigPasswordEncoder = option;
    }

    public static final /* synthetic */ Object $anonfun$updateCurrentConfig$1$adapted(KafkaConfig oldConfig$2, KafkaConfig newConfig$2, BrokerReconfigurable x$4) {
        x$4.reconfigure(oldConfig$2, newConfig$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(java.util.Set eta$0$1$1, Object x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains(x$1));
    }
}

