/*
 * Decompiled with CFR 0.152.
 */
package kafka.api.test;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001\u0002\b\u0010\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013%!\u0005\u0003\u0004*\u0001\u0001\u0006Ia\t\u0005\bU\u0001\u0011\r\u0011\"\u0003,\u0011\u0019!\u0004\u0001)A\u0005Y!9Q\u0007\u0001b\u0001\n\u0013\u0011\u0003B\u0002\u001c\u0001A\u0003%1\u0005C\u00058\u0001\u0001\u0007\t\u0019!C\u0005q!IA\b\u0001a\u0001\u0002\u0004%I!\u0010\u0005\n\u0007\u0002\u0001\r\u0011!Q!\neBQ\u0001\u0012\u0001\u0005B\u0015CQa\u0016\u0001\u0005BaCQ!\u0018\u0001\u0005\u0002y\u0013q\u0003\u0015:pIV\u001cWM]\"p[B\u0014Xm]:j_:$Vm\u001d;\u000b\u0005A\t\u0012\u0001\u0002;fgRT!AE\n\u0002\u0007\u0005\u0004\u0018NC\u0001\u0015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\f\u0011\u0005aYR\"A\r\u000b\u0005i\u0019\u0012AB:feZ,'/\u0003\u0002\u001d3\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005y\u0011\u0001\u00032s_.,'/\u00133\u0016\u0003\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u00121!\u00138u\u0003%\u0011'o\\6fe&#\u0007%A\u0003u_BL7-F\u0001-!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0003mC:<'\"A\u0019\u0002\t)\fg/Y\u0005\u0003g9\u0012aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\u0006ok6\u0014VmY8sIN\f1B\\;n%\u0016\u001cwN\u001d3tA\u00051!M]8lKJ,\u0012!\u000f\t\u00031iJ!aO\r\u0003\u0017-\u000bgm[1Ce>\\WM]\u0001\u000bEJ|7.\u001a:`I\u0015\fHC\u0001 B!\t!s(\u0003\u0002AK\t!QK\\5u\u0011\u001d\u0011\u0015\"!AA\u0002e\n1\u0001\u001f\u00132\u0003\u001d\u0011'o\\6fe\u0002\nQa]3u+B$\"A\u0010$\t\u000b\u001d[\u0001\u0019\u0001%\u0002\u0011Q,7\u000f^%oM>\u0004\"!S)\u000e\u0003)S!AE&\u000b\u00051k\u0015a\u00026va&$XM\u001d\u0006\u0003\u001d>\u000bQA[;oSRT\u0011\u0001U\u0001\u0004_J<\u0017B\u0001*K\u0005!!Vm\u001d;J]\u001a|\u0007FA\u0006U!\tIU+\u0003\u0002W\u0015\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:$\u0012A\u0010\u0015\u0003\u0019i\u0003\"!S.\n\u0005qS%!C!gi\u0016\u0014X)Y2i\u0003=!Xm\u001d;D_6\u0004(/Z:tS>tGc\u0001 `W\")\u0001-\u0004a\u0001C\u00061\u0011/^8sk6\u0004\"AY5\u000f\u0005\r<\u0007C\u00013&\u001b\u0005)'B\u00014\u0016\u0003\u0019a$o\\8u}%\u0011\u0001.J\u0001\u0007!J,G-\u001a4\n\u0005MR'B\u00015&\u0011\u0015aW\u00021\u0001b\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8)\t5qgo\u001e\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\f\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003g.\u000ba\u0001]1sC6\u001c\u0018BA;q\u0005%\u00195O^*pkJ\u001cW-A\u0003wC2,X\r\f\u0005yurt\u0018\u0011AA\u0003C\u0005I\u0018AC6sC\u001a$HF\\8oK\u0006\n10\u0001\u0006le\u00064G\u000fL4{SB\f\u0013!`\u0001\rWJ\fg\r\u001e\u0017t]\u0006\u0004\b/_\u0011\u0002\u007f\u0006I1N]1gi2b'\u0010N\u0011\u0003\u0003\u0007\t!b\u001b:bMRd#p\u001d;eC\t\t9!A\u0004{W2:'0\u001b9)\u00075\tY\u0001\u0005\u0003\u0002\u000e\u0005=Q\"\u0001:\n\u0007\u0005E!OA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\u0004")
public class ProducerCompressionTest
extends QuorumTestHarness {
    private final int brokerId;
    private final String topic;
    private final int numRecords;
    private KafkaBroker broker;

    private int brokerId() {
        return this.brokerId;
    }

    private String topic() {
        return this.topic;
    }

    private int numRecords() {
        return this.numRecords;
    }

    private KafkaBroker broker() {
        return this.broker;
    }

    private void broker_$eq(KafkaBroker x$1) {
        this.broker = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        this.broker_$eq(this.createBroker(new KafkaConfig((java.util.Map)props), this.createBroker$default$2(), this.createBroker$default$3(), this.createBroker$default$4()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), true);
        super.tearDown();
    }

    @ParameterizedTest
    @CsvSource(value={"kraft,none", "kraft,gzip", "kraft,snappy", "kraft,lz4", "kraft,zstd", "zk,gzip"})
    public void testCompression(String quorum, String compression) {
        Properties producerProps = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.plaintextBootstrapServers(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$));
        producerProps.put("bootstrap.servers", bootstrapServers);
        producerProps.put("compression.type", compression);
        producerProps.put("batch.size", "66000");
        producerProps.put("linger.ms", "200");
        KafkaProducer producer = new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(bootstrapServers, "group", "earliest", true, false, 500, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArrayDeserializer(), new ByteArrayDeserializer());
        try {
            try (Admin admin = TestUtils$.MODULE$.createAdminClient(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), new Properties());){
                TestUtils$.MODULE$.createTopicWithAdmin(admin, this.topic(), new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), 1, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            }
            int partition = 0;
            IndexedSeq messageValues = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numRecords()).map((Function1 & Serializable)i -> ProducerCompressionTest.$anonfun$testCompression$1(BoxesRunTime.unboxToInt((Object)i)));
            long now = System.currentTimeMillis();
            ((IterableOps)((IndexedSeq)messageValues.map((Function1 & Serializable)message -> producer.send(new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(now), null, (Object)message.getBytes())))).zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ProducerCompressionTest.$anonfun$testCompression$3(check$ifrefutable$1))).foreach((Function1 & Serializable)x$2 -> {
                ProducerCompressionTest.$anonfun$testCompression$4(x$2);
                return BoxedUnit.UNIT;
            });
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            consumer.assign(Collections.singleton(tp));
            consumer.seek(tp, 0L);
            Seq records = TestUtils$.MODULE$.consumeRecords(consumer, this.numRecords(), 15000L);
            ((IterableOps)((IterableOps)messageValues.zip(records)).zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ProducerCompressionTest.$anonfun$testCompression$5(check$ifrefutable$2))).foreach((Function1 & Serializable)x$3 -> {
                ProducerCompressionTest.$anonfun$testCompression$6(now, x$3);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            producer.close();
            consumer.close();
        }
    }

    public static final /* synthetic */ String $anonfun$testCompression$1(int i) {
        return new StringBuilder(5).append("value").append(i).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testCompression$3(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$testCompression$4(Tuple2 x$2) {
        if (x$2 != null) {
            Future future = (Future)x$2._1();
            Assertions.assertEquals((long)x$2._2$mcI$sp(), (long)((RecordMetadata)future.get()).offset());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testCompression$5(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null && (Tuple2)check$ifrefutable$2._1() != null;
    }

    public static final /* synthetic */ void $anonfun$testCompression$6(long now$1, Tuple2 x$3) {
        if (x$3 != null) {
            Tuple2 tuple2 = (Tuple2)x$3._1();
            int index = x$3._2$mcI$sp();
            if (tuple2 != null) {
                String messageValue = (String)tuple2._1();
                ConsumerRecord record = (ConsumerRecord)tuple2._2();
                Assertions.assertEquals((Object)messageValue, (Object)new String((byte[])record.value()));
                Assertions.assertEquals((long)now$1, (long)record.timestamp());
                Assertions.assertEquals((long)index, (long)record.offset());
                return;
            }
        }
        throw new MatchError((Object)x$3);
    }

    public ProducerCompressionTest() {
        this.brokerId = 0;
        this.topic = "topic";
        this.numRecords = 2000;
    }
}

