/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.security.authorizer.TestableDigestLoginModule$;
import kafka.security.authorizer.TestableJaasSection;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuorumTestHarness;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zookeeper.ZooKeeperClient$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001\u0002\u0010 \u0001\u0019BQa\r\u0001\u0005\u0002QBqa\u000e\u0001C\u0002\u0013%\u0001\b\u0003\u0004=\u0001\u0001\u0006I!\u000f\u0005\b{\u0001\u0011\r\u0011\"\u00039\u0011\u0019q\u0004\u0001)A\u0005s!9q\b\u0001b\u0001\n\u0013\u0001\u0005BB'\u0001A\u0003%\u0011\tC\u0004O\u0001\t\u0007I\u0011B(\t\ra\u0003\u0001\u0015!\u0003Q\u0011\u001dI\u0006A1A\u0005\niCaA\u0019\u0001!\u0002\u0013Y\u0006bB2\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007W\u0002\u0001\u000b\u0011B3\t\u000f1\u0004!\u0019!C\u0005[\"1a\u000f\u0001Q\u0001\n9D\u0011b\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002=\t\u0013q\u0004\u0001\u0019!a\u0001\n\u0013i\bBCA\u0007\u0001\u0001\u0007\t\u0011)Q\u0005s\"9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\b\u0003{\u0001A\u0011AA\u001a\u0011\u001d\t9\u0005\u0001C\u0001\u0003gAq!a\u0013\u0001\t\u0013\t\u0019\u0004C\u0004\u0002N\u0001!I!a\r\t\u000f\u0005=\u0003\u0001\"\u0003\u0002R!9\u0011\u0011\r\u0001\u0005\n\u0005\r\u0004bBAI\u0001\u0011%\u00111\u0013\u0005\b\u00033\u0003A\u0011BAN\u0011%\ty\fAI\u0001\n\u0013\t\tMA\u000eBG2\fU\u000f\u001e5pe&TXM],ji\"T6nU1tYR+7\u000f\u001e\u0006\u0003A\u0005\n!\"Y;uQ>\u0014\u0018N_3s\u0015\t\u00113%\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0005!\u0013!B6bM.\f7\u0001A\n\u0004\u0001\u001dj\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016$\u0003\u0019\u0019XM\u001d<fe&\u0011A&\u000b\u0002\u0012#V|'/^7UKN$\b*\u0019:oKN\u001c\bC\u0001\u00182\u001b\u0005y#B\u0001\u0019$\u0003\r\t\u0007/[\u0005\u0003e=\u0012\u0011bU1tYN+G/\u001e9\u0002\rqJg.\u001b;?)\u0005)\u0004C\u0001\u001c\u0001\u001b\u0005y\u0012!D1dY\u0006+H\u000f[8sSj,'/F\u0001:!\t1$(\u0003\u0002<?\ti\u0011i\u00197BkRDwN]5{KJ\fa\"Y2m\u0003V$\bn\u001c:ju\u0016\u0014\b%\u0001\bbG2\fU\u000f\u001e5pe&TXM\u001d\u001a\u0002\u001f\u0005\u001cG.Q;uQ>\u0014\u0018N_3se\u0001\n\u0001B]3t_V\u00148-Z\u000b\u0002\u0003B\u0011!iS\u0007\u0002\u0007*\u0011q\b\u0012\u0006\u0003\u000b\u001a\u000baaY8n[>t'B\u0001\u0013H\u0015\tA\u0015*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0015\u0006\u0019qN]4\n\u00051\u001b%a\u0004*fg>,(oY3QCR$XM\u001d8\u0002\u0013I,7o\\;sG\u0016\u0004\u0013\u0001C;tKJt\u0017-\\3\u0016\u0003A\u0003\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\t1\fgn\u001a\u0006\u0002+\u0006!!.\u0019<b\u0013\t9&K\u0001\u0004TiJLgnZ\u0001\nkN,'O\\1nK\u0002\n\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0016\u0003m\u0003\"\u0001\u00181\u000e\u0003uS!AX0\u0002\t\u0005,H\u000f\u001b\u0006\u0003E\u0011K!!Y/\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\u0006Q\u0001O]5oG&\u0004\u0018\r\u001c\u0011\u0002\u001dI,\u0017/^3ti\u000e{g\u000e^3yiV\tQ\r\u0005\u0002gS6\tqM\u0003\u0002i\t\u0006A!/Z9vKN$8/\u0003\u0002kO\nq!+Z9vKN$8i\u001c8uKb$\u0018a\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0011\u0002\u0011\u0015DXmY;u_J,\u0012A\u001c\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\f!bY8oGV\u0014(/\u001a8u\u0015\t\u0019H+\u0001\u0003vi&d\u0017BA;q\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\nKb,7-\u001e;pe\u0002\naaY8oM&<W#A=\u0011\u0005!R\u0018BA>*\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000fF\u0002\u007f\u0003\u0013\u00012a`A\u0003\u001b\t\t\tA\u0003\u0002\u0002\u0004\u0005)1oY1mC&!\u0011qAA\u0001\u0005\u0011)f.\u001b;\t\u0011\u0005-\u0011#!AA\u0002e\f1\u0001\u001f\u00132\u0003\u001d\u0019wN\u001c4jO\u0002\nQa]3u+B$2A`A\n\u0011\u001d\t)b\u0005a\u0001\u0003/\t\u0001\u0002^3ti&sgm\u001c\t\u0005\u00033\t)#\u0004\u0002\u0002\u001c)\u0019\u0001'!\b\u000b\t\u0005}\u0011\u0011E\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t\u0019#S\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003O\tYB\u0001\u0005UKN$\u0018J\u001c4pQ\r\u0019\u00121\u0006\t\u0005\u00033\ti#\u0003\u0003\u00020\u0005m!A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eF\u0001\u007fQ\r!\u0012q\u0007\t\u0005\u00033\tI$\u0003\u0003\u0002<\u0005m!!C!gi\u0016\u0014X)Y2i\u0003\t\"Xm\u001d;BG2,\u0006\u000fZ1uK^KG\u000f[*fgNLwN\\#ya&\u0014\u0018\r^5p]\"\u001aQ#!\u0011\u0011\t\u0005e\u00111I\u0005\u0005\u0003\u000b\nYB\u0001\u0003UKN$\u0018\u0001\b;fgR\f5\r\\+qI\u0006$XmV5uQ\u0006+H\u000f\u001b$bS2,(/\u001a\u0015\u0004-\u0005\u0005\u0013\u0001J5oU\u0016\u001cG\u000f\u0016:b]NLWM\u001c;BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3\u0002\u001fY,'/\u001b4z\u0003\u000edW\u000b\u001d3bi\u0016\f\u0001B_6DY&,g\u000e\u001e\u000b\u0005\u0003'\ny\u0006\u0005\u0003\u0002V\u0005mSBAA,\u0015\r\tIfI\u0001\u0003u.LA!!\u0018\u0002X\ti1*\u00194lCj[7\t\\5f]RDQ\u0001I\rA\u0002e\nq!\u00193e\u0003\u000ed7\u000fF\u0004\u007f\u0003K\n9'!$\t\u000b\u0001R\u0002\u0019A\u001d\t\u000f\u0005%$\u00041\u0001\u0002l\u0005!\u0011mY3t!\u0019\ti'a\u001f\u0002\u0002:!\u0011qNA<!\u0011\t\t(!\u0001\u000e\u0005\u0005M$bAA;K\u00051AH]8pizJA!!\u001f\u0002\u0002\u00051\u0001K]3eK\u001aLA!! \u0002\u0000\t\u00191+\u001a;\u000b\t\u0005e\u0014\u0011\u0001\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*\u0019\u0011q\u0011#\u0002\u0007\u0005\u001cG.\u0003\u0003\u0002\f\u0006\u0015%AE!dG\u0016\u001c8oQ8oiJ|G.\u00128uefDa!a$\u001b\u0001\u0004\t\u0015a\u0004:fg>,(oY3QCR$XM\u001d8\u0002\u000f\u001d,G/Q2mgR1\u00111NAK\u0003/CQ\u0001I\u000eA\u0002eBa!a$\u001c\u0001\u0004\t\u0015!\u00058foJ+\u0017/^3ti\u000e{g\u000e^3yiR9Q-!(\u0002 \u0006=\u0006\"B-\u001d\u0001\u0004Y\u0006bBAQ9\u0001\u0007\u00111U\u0001\u000eG2LWM\u001c;BI\u0012\u0014Xm]:\u0011\t\u0005\u0015\u00161V\u0007\u0003\u0003OS1!!+U\u0003\rqW\r^\u0005\u0005\u0003[\u000b9KA\u0006J]\u0016$\u0018\t\u001a3sKN\u001c\b\"CAY9A\u0005\t\u0019AAZ\u0003\u0019\t\u0007/[&fsB!\u0011QWA^\u001b\t\t9LC\u0002\u0002:\u0012\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003{\u000b9LA\u0004Ba&\\U-_:\u000279,wOU3rk\u0016\u001cHoQ8oi\u0016DH\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019M\u000b\u0003\u00024\u0006\u00157FAAd!\u0011\tI-a5\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\u0005E\u0017\u0011A\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAk\u0003\u0017\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class AclAuthorizerWithZkSaslTest
extends QuorumTestHarness
implements SaslSetup {
    private final AclAuthorizer aclAuthorizer;
    private final AclAuthorizer aclAuthorizer2;
    private final ResourcePattern resource;
    private final String username;
    private final KafkaPrincipal principal;
    private final RequestContext requestContext;
    private final ScheduledExecutorService executor;
    private KafkaConfig config;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasAdminLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasAdminLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasAdminLoginModule$default$2() {
        return SaslSetup.jaasAdminLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    private AclAuthorizer aclAuthorizer() {
        return this.aclAuthorizer;
    }

    private AclAuthorizer aclAuthorizer2() {
        return this.aclAuthorizer2;
    }

    private ResourcePattern resource() {
        return this.resource;
    }

    private String username() {
        return this.username;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private RequestContext requestContext() {
        return this.requestContext;
    }

    private ScheduledExecutorService executor() {
        return this.executor;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        System.setProperty("zookeeper.allowSaslFailedClients", "true");
        TestableDigestLoginModule$.MODULE$.injectedPassword_$eq((Option<String>)None$.MODULE$);
        Seq<JaasTestUtils.JaasSection> jaasSections = JaasTestUtils$.MODULE$.zkSections();
        Seq serverJaas = (Seq)jaasSections.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerWithZkSaslTest.$anonfun$setUp$1(x$2)));
        Seq clientJaas = (Seq)((IterableOps)jaasSections.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerWithZkSaslTest.$anonfun$setUp$2(x$3)))).map((Function1 & Serializable)section -> new TestableJaasSection(section.contextName(), section.modules()));
        this.startSasl((Seq<JaasTestUtils.JaasSection>)((Seq)serverJaas.$plus$plus((IterableOnce)clientJaas)));
        this.aclAuthorizer().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        this.aclAuthorizer2().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        super.setUp(testInfo);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false)));
        this.aclAuthorizer().configure(this.config().originals());
        this.aclAuthorizer2().configure(this.config().originals());
    }

    @Override
    @AfterEach
    public void tearDown() {
        System.clearProperty("zookeeper.allowSaslFailedClients");
        TestableDigestLoginModule$.MODULE$.injectedPassword_$eq((Option<String>)None$.MODULE$);
        this.executor().shutdownNow();
        this.aclAuthorizer().close();
        this.aclAuthorizer2().close();
        super.tearDown();
    }

    @Test
    public void testAclUpdateWithSessionExpiration() {
        ((KafkaZkClient)TestUtils.fieldValue((Object)this.aclAuthorizer(), AclAuthorizer.class, (String)"zkClient")).currentZooKeeper().getTestable().injectSessionExpiration();
        ((KafkaZkClient)TestUtils.fieldValue((Object)this.aclAuthorizer2(), AclAuthorizer.class, (String)"zkClient")).currentZooKeeper().getTestable().injectSessionExpiration();
        this.verifyAclUpdate();
    }

    @Test
    public void testAclUpdateWithAuthFailure() {
        this.injectTransientAuthenticationFailure();
        this.verifyAclUpdate();
    }

    private void injectTransientAuthenticationFailure() {
        TestableDigestLoginModule$.MODULE$.injectInvalidCredentials();
        ((KafkaZkClient)TestUtils.fieldValue((Object)this.aclAuthorizer(), AclAuthorizer.class, (String)"zkClient")).currentZooKeeper().getTestable().injectSessionExpiration();
        ((KafkaZkClient)TestUtils.fieldValue((Object)this.aclAuthorizer2(), AclAuthorizer.class, (String)"zkClient")).currentZooKeeper().getTestable().injectSessionExpiration();
        this.executor().schedule(() -> TestableDigestLoginModule$.MODULE$.reset(), (long)(ZooKeeperClient$.MODULE$.RetryBackoffMs() * 2), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyAclUpdate() {
        void var5_16;
        Tuple2 tuple2;
        AccessControlEntry allowReadAcl = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry allowWriteAcl = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowReadAcl, allowWriteAcl}));
        long l = 15000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                AclAuthorizerWithZkSaslTest.$anonfun$verifyAclUpdate$1(this, acls);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var19_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var6_5 = null;
        Object var11_10 = null;
        long l3 = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Set computeUntilTrue_result;
            if (AclAuthorizerWithZkSaslTest.$anonfun$verifyAclUpdate$3(acls, computeUntilTrue_result = this.getAcls(this.aclAuthorizer2(), this.resource()))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var18_14 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Set acls2 = (Set)tuple22._1();
        Assertions.assertEquals((Object)acls, (Object)var5_16);
    }

    private KafkaZkClient zkClient(AclAuthorizer authorizer) {
        return (KafkaZkClient)TestUtils.fieldValue((Object)authorizer, AclAuthorizer.class, (String)"zkClient");
    }

    private void addAcls(AclAuthorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = (Set)aces.map((Function1 & Serializable)ace -> new AclBinding(resourcePattern, ace));
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(authorizer.createAcls((AuthorizableRequestContext)this.requestContext(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)bindings.toList()).asJava())).asScala().map((Function1 & Serializable)x$5 -> (AclCreateResult)x$5.toCompletableFuture().get())).foreach((Function1 & Serializable)result -> {
            AclAuthorizerWithZkSaslTest.$anonfun$addAcls$3(result);
            return BoxedUnit.UNIT;
        });
    }

    private Set<AccessControlEntry> getAcls(AclAuthorizer authorizer, ResourcePattern resourcePattern) {
        return (Set)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY))).asScala().toSet().map((Function1 & Serializable)x$6 -> x$6.entry());
    }

    private RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        RequestHeader header = new RequestHeader(apiKey, 2, "", 1);
        return new RequestContext(header, "", clientAddress, principal, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol, ClientInformation.EMPTY, false);
    }

    private ApiKeys newRequestContext$default$3() {
        return ApiKeys.PRODUCE;
    }

    public static final /* synthetic */ boolean $anonfun$setUp$1(JaasTestUtils.JaasSection x$2) {
        String string = x$2.contextName();
        String string2 = "Server";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$setUp$2(JaasTestUtils.JaasSection x$3) {
        String string = x$3.contextName();
        String string2 = "Client";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$verifyAclUpdate$1(AclAuthorizerWithZkSaslTest $this, Set acls$1) {
        try {
            $this.addAcls($this.aclAuthorizer(), (Set<AccessControlEntry>)acls$1, $this.resource());
        }
        catch (Exception exception) {}
        Assertions.assertEquals((Object)acls$1, $this.getAcls($this.aclAuthorizer(), $this.resource()));
    }

    public static final /* synthetic */ boolean $anonfun$verifyAclUpdate$3(Set acls$1, Set x$4) {
        Set set = x$4;
        return !(set != null ? !set.equals(acls$1) : acls$1 != null);
    }

    public static final /* synthetic */ void $anonfun$addAcls$3(AclCreateResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
    }

    public AclAuthorizerWithZkSaslTest() {
        SaslSetup.$init$(this);
        this.aclAuthorizer = new AclAuthorizer();
        this.aclAuthorizer2 = new AclAuthorizer();
        this.resource = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        this.username = "alice";
        this.principal = new KafkaPrincipal("User", this.username());
        this.requestContext = this.newRequestContext(this.principal(), InetAddress.getByName("192.168.0.1"), ApiKeys.PRODUCE);
        this.executor = Executors.newSingleThreadScheduledExecutor();
        Statics.releaseFence();
    }

    public static final /* synthetic */ Object $anonfun$verifyAclUpdate$3$adapted(Set acls$1, Set x$4) {
        return BoxesRunTime.boxToBoolean((boolean)AclAuthorizerWithZkSaslTest.$anonfun$verifyAclUpdate$3(acls$1, x$4));
    }
}

