/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.security.authorizer.AclEntry$;
import kafka.server.ConfigType$;
import kafka.server.ControllerServer;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.test.ClusterInstance;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.ZkClusterInvocationContext;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.EncryptingPasswordEncoder;
import kafka.utils.Logging;
import kafka.utils.NoOpPasswordEncoder;
import kafka.utils.PasswordEncoder;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import kafka.zk.TopicZNode;
import kafka.zk.ZkMigrationClient;
import kafka.zk.ZkMigrationClient$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ExtendWith(value={ClusterTestExtensions.class})
@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0005\t5f\u0001B\u0010!\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u0004;\u0001\u0001\u0006IA\r\u0004\u0005w\u0001\u0001A\bC\u0003-\t\u0011\u0005Q\bC\u0004A\t\t\u0007I\u0011A!\t\r-#\u0001\u0015!\u0003C\u0011\u001daE\u00011A\u0005\u00025Cq!\u0015\u0003A\u0002\u0013\u0005!\u000b\u0003\u0004Y\t\u0001\u0006KA\u0014\u0005\u00063\u0012!\tA\u0017\u0005\u0006[\u0012!\tA\u001c\u0005\u0006o\u0002!\t\u0001\u001f\u0005\b\u00037\u0002A\u0011AA/\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003KBq!!'\u0001\t\u0003\tY\nC\u0004\u0002$\u0002!\t!!*\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0006bBA}\u0001\u0011\u0005\u00111 \u0005\b\u0005\u0003\u0001A\u0011\u0001B\u0002\u0011\u001d\u0011i\u0001\u0001C\u0001\u0005\u001fAqA!\u000b\u0001\t\u0003\u0011Y\u0003C\u0004\u00036\u0001!\tAa\u000e\t\u000f\t\u0005\u0003\u0001\"\u0001\u0003D!9!q\t\u0001\u0005\u0002\t%\u0003b\u0002B'\u0001\u0011\u0005!q\n\u0005\b\u0005'\u0002A\u0011\u0001B+\u0011\u001d\u0011I\u0006\u0001C\u0001\u00057BqAa\u0019\u0001\t\u0003\u0011)G\u0001\u000e[W6KwM]1uS>t\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\"E\u0005\u0011!p\u001b\u0006\u0002G\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001'!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\f\t\u0003_\u0001i\u0011\u0001I\u0001\u0004Y><W#\u0001\u001a\u0011\u0005MBT\"\u0001\u001b\u000b\u0005U2\u0014!B:mMRR'\"A\u001c\u0002\u0007=\u0014x-\u0003\u0002:i\t1Aj\\4hKJ\fA\u0001\\8hA\t)R*\u001a;bI\u0006$\u0018\rR3mi\u00064VM]5gS\u0016\u00148C\u0001\u0003')\u0005q\u0004CA \u0005\u001b\u0005\u0001\u0011!D7fi\u0006$\u0017\r^1EK2$\u0018-F\u0001C!\t\u0019\u0015*D\u0001E\u0015\t)e)A\u0003j[\u0006<WM\u0003\u0002$\u000f*\u0011\u0001JN\u0001\u0007CB\f7\r[3\n\u0005)#%!D'fi\u0006$\u0017\r^1EK2$\u0018-\u0001\bnKR\fG-\u0019;b\t\u0016dG/\u0019\u0011\u0002\r=4gm]3u+\u0005q\u0005CA\u0014P\u0013\t\u0001\u0006FA\u0002J]R\f!b\u001c4gg\u0016$x\fJ3r)\t\u0019f\u000b\u0005\u0002()&\u0011Q\u000b\u000b\u0002\u0005+:LG\u000fC\u0004X\u0013\u0005\u0005\t\u0019\u0001(\u0002\u0007a$\u0013'A\u0004pM\u001a\u001cX\r\u001e\u0011\u0002\r\u0005\u001c7-\u001a9u)\t\u00196\fC\u0003]\u0017\u0001\u0007Q,A\u0003cCR\u001c\u0007\u000eE\u0002_G\u0016l\u0011a\u0018\u0006\u0003A\u0006\fA!\u001e;jY*\t!-\u0001\u0003kCZ\f\u0017B\u00013`\u0005\u0011a\u0015n\u001d;\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017AB2p[6|gN\u0003\u0002k\r\u000611/\u001a:wKJL!\u0001\\4\u0003)\u0005\u0003\u0018.T3tg\u0006<W-\u00118e-\u0016\u00148/[8o\u0003\u00191XM]5gsR\u00111k\u001c\u0005\u0006a2\u0001\r!]\u0001\tm\u0016\u0014\u0018NZ5feB!qE\u001d;T\u0013\t\u0019\bFA\u0005Gk:\u001cG/[8ocA\u00111)^\u0005\u0003m\u0012\u0013Q\"T3uC\u0012\fG/Y%nC\u001e,\u0017a\u0004;fgRl\u0015n\u001a:bi\u0016\f5\r\\:\u0015\u0005MK\b\"\u0002>\u000e\u0001\u0004Y\u0018aD2mkN$XM]%ogR\fgnY3\u0011\u0005q|X\"A?\u000b\u0005y\u0014\u0013\u0001\u0002;fgRL1!!\u0001~\u0005=\u0019E.^:uKJLen\u001d;b]\u000e,\u0007fF\u0007\u0002\u0006\u0005E\u00111CA\u000b\u0003/\t\t#a\t\u0002.\u0005=\u0012\u0011HA\u001e!\u0011\t9!!\u0004\u000e\u0005\u0005%!bAA\u0006{\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0011\u0011\u0002\u0002\f\u00072,8\u000f^3s)\u0016\u001cH/A\u0004ce>\\WM]:\u001e\u0003\r\t1b\u00197vgR,'\u000fV=qK\u0012\u0012\u0011\u0011D\u0005\u0005\u00037\ti\"\u0001\u0002[\u0017*!\u0011qDA\u0005\u0003\u0011!\u0016\u0010]3\u0002\u0013\u0005,Ho\\*uCJ$HEAA\u0013\u0013\u0011\t9#!\u000b\u0002\u0007e+5K\u0003\u0003\u0002,\u0005%\u0011!C!vi>\u001cF/\u0019:u\u0003=iW\r^1eCR\fg+\u001a:tS>tGEAA\u0019\u0013\u0011\t\u0019$!\u000e\u0002\u0017%\u0013\u0005kX\u001a`i}Ke\u000b\r\u0006\u0004\u0003o9\u0017aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0002!M,'O^3s!J|\u0007/\u001a:uS\u0016\u001cH\u0006BA\u001f\u0003#Z#\"a\u0010\u0002F\u0005\u001d\u00131JA'!\u0011\t9!!\u0011\n\t\u0005\r\u0013\u0011\u0002\u0002\u0016\u00072,8\u000f^3s\u0007>tg-[4Qe>\u0004XM\u001d;z\u0003\rYW-_\u0011\u0003\u0003\u0013\nQ#Y;uQ>\u0014\u0018N_3s]\rd\u0017m]:/]\u0006lW-A\u0003wC2,X-\t\u0002\u0002P\u000593.\u00194lC:\u001aXmY;sSRLh&Y;uQ>\u0014\u0018N_3s]\u0005\u001bG.Q;uQ>\u0014\u0018N_3sW)\ty$!\u0012\u0002T\u0005-\u0013qK\u0011\u0003\u0003+\n1b];qKJtSo]3sg\u0006\u0012\u0011\u0011L\u0001\u000f+N,'OO!O\u001f:KVjT+T\u0003-!Xm\u001d;NS\u001e\u0014\u0018\r^3\u0015\u0007M\u000by\u0006C\u0003{\u001d\u0001\u00071\u0010K\b\u000f\u0003\u000b\t\t\"a\u0005\u0002\u0016\u0005]\u0011QFA\u0018\u0003I!Xm\u001d;Ek\u0006dwK]5uKN\u001b'/Y7\u0015\u0007M\u000b9\u0007\u0003\u0004\u0002j=\u0001\ra_\u0001\nu.\u001cE.^:uKJD3cDA\u0003\u0003+\t9\"!\u0005\u0002\u0014\u00055\u0012QNA\u001d\u0003g\"#!a\u001c\n\t\u0005E\u0014QG\u0001\f\u0013\n\u0003vlM06?&3&\u0007\f\u0005\u0002v\u0005}\u0014\u0011RAHW)\ty$!\u0012\u0002x\u0005-\u00131P\u0011\u0003\u0003s\n!$\u001b8uKJt#M]8lKJtC.[:uK:,'O\f8b[\u0016\f#!! \u0002\u0011\u0015CF+\u0012*O\u00032[#\"a\u0010\u0002F\u0005\u0005\u00151JACC\t\t\u0019)A\u0005mSN$XM\\3sg\u0006\u0012\u0011qQ\u0001/!2\u000b\u0015J\u0014+F1RStf\f7pG\u0006d\u0007n\\:uuAbS\t\u0017+F%:\u000bEJO\u00180Y>\u001c\u0017\r\u001c5pgRT\u0004g\u000b\u0006\u0002@\u0005\u0015\u00131RA&\u0003\u000b\u000b#!!$\u0002)\u0005$g/\u001a:uSN,GM\f7jgR,g.\u001a:tW)\ty$!\u0012\u0002\u0012\u0006-\u0013QS\u0011\u0003\u0003'\u000ba\u0004\\5ti\u0016tWM\u001d\u0018tK\u000e,(/\u001b;z]A\u0014x\u000e^8d_2tS.\u00199\"\u0005\u0005]\u0015AJ#Y)\u0016\u0013f*\u0011';!2\u000b\u0015J\u0014+F1Rc\u0003\u000bT!J\u001dR+\u0005\f\u0016\u001eQ\u0019\u0006Ke\nV#Y)\u0006iA/Z:u\tV\fGn\u0016:ji\u0016$2aUAO\u0011\u0019\tI\u0007\u0005a\u0001w\"\u001a\u0002#!\u0002\u0002\u0016\u0005]\u0011\u0011CA\n\u0003[\ty#!\u000f\u0002\"2B\u0011QOA@\u0003\u0013\u000by)\u0001\u000euKN$H)^1m/JLG/Z)v_R\f\u0017I\u001c3TGJ\fW\u000eF\u0002T\u0003OCa!!\u001b\u0012\u0001\u0004Y\bfE\t\u0002\u0006\u0005U\u0011qCA\t\u0003'\ti#!\u001c\u0002:\u0005-F\u0006CA;\u0003\u007f\nI)a$\u0002EQ,7\u000f\u001e(fo\u0006sGm\u00115b]\u001e,G\rV8qS\u000e\u001c\u0018J\u001c#vC2<&/\u001b;f)\r\u0019\u0016\u0011\u0017\u0005\u0007\u0003S\u0012\u0002\u0019A>)'I\t)!!\u0006\u0002\u0018\u0005E\u00111CA\u0017\u0003_\tI$!.-\u0011\u0005U\u0014qPAE\u0003\u001f\u000bAD^3sS\u001aLHk\u001c9jGB\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\rF\u0004T\u0003w\u000b).a<\t\u000f\u0005u6\u00031\u0001\u0002@\u0006IAo\u001c9jG:\u000bW.\u001a\t\u0005\u0003\u0003\fyM\u0004\u0003\u0002D\u0006-\u0007cAAcQ5\u0011\u0011q\u0019\u0006\u0004\u0003\u0013$\u0013A\u0002\u001fs_>$h(C\u0002\u0002N\"\na\u0001\u0015:fI\u00164\u0017\u0002BAi\u0003'\u0014aa\u0015;sS:<'bAAgQ!9\u0011q[\nA\u0002\u0005e\u0017A\u00039beRLG/[8ogB1\u00111\\Aq\u0003Kl!!!8\u000b\u0007\u0005}\u0007&\u0001\u0006d_2dWm\u0019;j_:LA!a9\u0002^\n\u00191+Z9\u0011\t\u0005\u001d\u00181^\u0007\u0003\u0003ST!\u0001\u001b$\n\t\u00055\u0018\u0011\u001e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t\tp\u0005a\u0001\u0003g\f\u0001B_6DY&,g\u000e\u001e\t\u0004_\u0005U\u0018bAA|A\ti1*\u00194lCj[7\t\\5f]R\f!#\u00197m_\u000e\fG/\u001a)s_\u0012,8-\u001a:JIR\u00191+!@\t\u000f\u0005}H\u00031\u0001\u0002@\u0006\u0001\"m\\8ugR\u0014\u0018\r]*feZ,'o]\u0001\u0014e\u0016\fG\r\u0015:pIV\u001cWM]%e\u00052|7m\u001b\u000b\u0005\u0005\u000b\u0011Y\u0001E\u0002g\u0005\u000fI1A!\u0003h\u0005A\u0001&o\u001c3vG\u0016\u0014\u0018\nZ:CY>\u001c7\u000eC\u0004\u0002rV\u0001\r!a=\u0002!\u0005dG/\u001a:U_BL7mQ8oM&<G\u0003\u0002B\t\u0005C\u0001BAa\u0005\u0003\u001e5\u0011!Q\u0003\u0006\u0005\u0005/\u0011I\"A\u0003bI6LgNC\u0002\u0003\u001c\u0019\u000bqa\u00197jK:$8/\u0003\u0003\u0003 \tU!AE!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z:vYRDqAa\u0006\u0017\u0001\u0004\u0011\u0019\u0003\u0005\u0003\u0003\u0014\t\u0015\u0012\u0002\u0002B\u0014\u0005+\u0011Q!\u00113nS:\f\u0011#\u00197uKJ\u001cE.[3oiF+x\u000e^1t)\u0011\u0011iCa\r\u0011\t\tM!qF\u0005\u0005\u0005c\u0011)BA\fBYR,'o\u00117jK:$\u0018+^8uCN\u0014Vm];mi\"9!qC\fA\u0002\t\r\u0012AG2sK\u0006$X-V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001cH\u0003\u0002B\u001d\u0005\u007f\u0001BAa\u0005\u0003<%!!Q\bB\u000b\u0005}\tE\u000e^3s+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKN,H\u000e\u001e\u0005\b\u0005/A\u0002\u0019\u0001B\u0012\u0003e\tG\u000e^3s+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:\u0015\t\te\"Q\t\u0005\b\u0005/I\u0002\u0019\u0001B\u0012\u0003I1XM]5gsR{\u0007/[2D_:4\u0017nZ:\u0015\u0007M\u0013Y\u0005C\u0004\u0002rj\u0001\r!a=\u0002%Y,'/\u001b4z\u00072LWM\u001c;Rk>$\u0018m\u001d\u000b\u0004'\nE\u0003bBAy7\u0001\u0007\u00111_\u0001\u001bm\u0016\u0014\u0018NZ=Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0004'\n]\u0003bBAy9\u0001\u0007\u00111_\u0001\u0011m\u0016\u0014\u0018NZ=Qe>$WoY3s\u0013\u0012$Ra\u0015B/\u0005CBqAa\u0018\u001e\u0001\u0004\u0011)!\u0001\u000bgSJ\u001cH\u000f\u0015:pIV\u001cWM]%e\u00052|7m\u001b\u0005\b\u0003cl\u0002\u0019AAz\u0003I\u0019\b.\u001e;e_^t\u0017J\\*fcV,gnY3\u0015\u000bM\u00139G!\u001b\t\r\u0005%d\u00041\u0001|\u0011\u001d\u0011YG\ba\u0001\u0005[\nAb\u001b:bMR\u001cE.^:uKJ\u0004BAa\u001c\u0003v5\u0011!\u0011\u000f\u0006\u0004\u0005g\u0012\u0013a\u0002;fgR\\\u0017\u000e^\u0005\u0005\u0005o\u0012\tHA\nLC\u001a\\\u0017m\u00117vgR,'\u000fV3ti.KG\u000fK\u0004\u0001\u0005w\nYEa$\u0011\t\tu$1R\u0007\u0003\u0005\u007fRAA!!\u0003\u0004\u0006\u0019\u0011\r]5\u000b\t\t\u0015%qQ\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\u0011IIN\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005\u001b\u0013yHA\u0004US6,w.\u001e;\u001f\u0005\u0005a\u0003f\u0002\u0001\u0003\u0014\u0006-#q\u0014\t\u0005\u0005+\u0013Y*\u0004\u0002\u0003\u0018*!!\u0011\u0014B@\u0003%)\u0007\u0010^3og&|g.\u0003\u0003\u0003\u001e\n]%AC#yi\u0016tGmV5uQ2\u0012!\u0011U\u0012\u0003\u0005G\u0003BA!*\u0003*6\u0011!q\u0015\u0006\u0004\u0005\u0013k\u0018\u0002\u0002BV\u0005O\u0013Qc\u00117vgR,'\u000fV3ti\u0016CH/\u001a8tS>t7\u000f")
public class ZkMigrationIntegrationTest {
    private final Logger log = LoggerFactory.getLogger(ZkMigrationIntegrationTest.class);

    public Logger log() {
        return this.log;
    }

    @ClusterTest(brokers=3, clusterType=Type.ZK, autoStart=AutoStart.YES, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="authorizer.class.name", value="kafka.security.authorizer.AclAuthorizer"), @ClusterConfigProperty(key="super.users", value="User:ANONYMOUS")})
    public void testMigrateAcls(ClusterInstance clusterInstance) {
        Admin admin = clusterInstance.createAdminClient();
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        String username = "alice";
        KafkaPrincipal principal = new KafkaPrincipal("User", username);
        KafkaPrincipal wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry$.MODULE$.WildcardPrincipalString());
        AclBinding acl1 = new AclBinding(resource1, new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding acl2 = new AclBinding(resource1, new AccessControlEntry(principal.toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(wildcardPrincipal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        admin.createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)new .colon.colon((Object)acl3, (List)new .colon.colon((Object)acl4, (List)Nil$.MODULE$))))).asJava()).all().get();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().zkClient();
        ZkMigrationClient migrationClient = ZkMigrationClient$.MODULE$.apply(zkClient, (PasswordEncoder)new NoOpPasswordEncoder());
        MetadataDeltaVerifier verifier = new MetadataDeltaVerifier();
        migrationClient.readAllMetadata(batch -> verifier.accept((java.util.List<ApiMessageAndVersion>)batch), x$1 -> {});
        verifier.verify((Function1<MetadataImage, BoxedUnit>)(Function1 & Serializable)image -> {
            ZkMigrationIntegrationTest.$anonfun$testMigrateAcls$3(acl1, acl2, acl3, acl4, image);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(brokers=3, clusterType=Type.ZK, metadataVersion=MetadataVersion.IBP_3_4_IV0)
    public void testMigrate(ClusterInstance clusterInstance) {
        NoOpPasswordEncoder noOpPasswordEncoder;
        Admin admin = clusterInstance.createAdminClient();
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic("test-topic-1", 2, (short)3).configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"102400"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"300000")}))).asJava()));
        newTopics.add(new NewTopic("test-topic-2", 1, (short)3));
        newTopics.add(new NewTopic("test-topic-3", 10, (short)3));
        admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
        ArrayList<ClientQuotaAlteration> quotas = new ArrayList<ClientQuotaAlteration>();
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), (List)Nil$.MODULE$)).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(800.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(100.0)), (List)Nil$.MODULE$))).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"8.8.8.8")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)), (List)Nil$.MODULE$)).asJava()));
        admin.alterClientQuotas(quotas).all().get(60L, TimeUnit.SECONDS);
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().zkClient();
        KafkaConfig kafkaConfig = ((KafkaServer)((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().servers().head()).config();
        Option option = kafkaConfig.passwordEncoderSecret();
        if (option instanceof Some) {
            void encrypting_iterations;
            void encrypting_keyLength;
            void encrypting_cipherAlgorithm;
            Password secret = (Password)((Some)option).value();
            int n = Predef$.MODULE$.Integer2int(kafkaConfig.passwordEncoderIterations());
            int n2 = Predef$.MODULE$.Integer2int(kafkaConfig.passwordEncoderKeyLength());
            String string = kafkaConfig.passwordEncoderCipherAlgorithm();
            Option encrypting_keyFactoryAlgorithm = kafkaConfig.passwordEncoderKeyFactoryAlgorithm();
            noOpPasswordEncoder = new EncryptingPasswordEncoder(secret, encrypting_keyFactoryAlgorithm, (String)encrypting_cipherAlgorithm, (int)encrypting_keyLength, (int)encrypting_iterations);
            Object var14_12 = null;
            string = null;
        } else if (None$.MODULE$.equals(option)) {
            noOpPasswordEncoder = new NoOpPasswordEncoder();
        } else {
            throw new MatchError((Object)option);
        }
        NoOpPasswordEncoder zkConfigEncoder = noOpPasswordEncoder;
        ZkMigrationClient migrationClient = ZkMigrationClient$.MODULE$.apply(zkClient, (PasswordEncoder)zkConfigEncoder);
        ZkMigrationLeadershipState migrationState = migrationClient.getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState.EMPTY);
        migrationState = migrationState.withNewKRaftController(3000, 42);
        migrationState = migrationClient.claimControllerLeadership(migrationState);
        HashSet brokers = new HashSet();
        MetadataDeltaVerifier verifier = new MetadataDeltaVerifier();
        migrationClient.readAllMetadata(batch -> verifier.accept((java.util.List<ApiMessageAndVersion>)batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(brokers).asScala().toSeq());
        verifier.verify((Function1<MetadataImage, BoxedUnit>)(Function1 & Serializable)image -> {
            ZkMigrationIntegrationTest.$anonfun$testMigrate$3(image);
            return BoxedUnit.UNIT;
        });
        migrationClient.releaseControllerLeadership(migrationState);
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_5_IV2, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDualWriteScram(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        this.createUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_5_IV2).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWriteScram$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyUserScramCredentials(zkClient);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDualWrite(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic("test", 2, (short)3).configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"102400"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"300000")}))).asJava()));
        admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        Properties propsBefore = zkClient.getEntityConfigs(ConfigType$.MODULE$.Topic(), "test");
        Assertions.assertEquals((Object)"102400", (Object)propsBefore.getProperty("segment.bytes"));
        Assertions.assertEquals((Object)"300000", (Object)propsBefore.getProperty("segment.ms"));
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.allocateProducerId(zkCluster.bootstrapServers());
            ProducerIdsBlock producerIdBlock = this.readProducerIdBlock(zkClient);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWrite$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterTopicConfig(admin).all().get(60L, TimeUnit.SECONDS);
            this.alterClientQuotas(admin).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyTopicConfigs(zkClient);
            this.verifyClientQuotas(zkClient);
            this.allocateProducerId(zkCluster.bootstrapServers());
            this.verifyProducerId(producerIdBlock, zkClient);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_5_IV2, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDualWriteQuotaAndScram(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        this.createUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_5_IV2).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWriteQuotaAndScram$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
            this.alterClientQuotas(admin).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyUserScramCredentials(zkClient);
            this.verifyClientQuotas(zkClient);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testNewAndChangedTopicsInDualWrite(ClusterInstance zkCluster) {
        String topicName = "test";
        zkCluster.createAdminClient();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testNewAndChangedTopicsInDualWrite$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Create new topic with AdminClient");
            Admin admin = zkCluster.createAdminClient();
            ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
            newTopics.add(new NewTopic(topicName, 2, (short)3));
            admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
            .colon.colon existingPartitions = new .colon.colon((Object)new TopicPartition(topicName, 0), (List)new .colon.colon((Object)new TopicPartition(topicName, 1), (List)Nil$.MODULE$));
            this.verifyTopicPartitionMetadata(topicName, (Seq<TopicPartition>)existingPartitions, zkClient);
            this.log().info("Create new partitions with AdminClient");
            admin.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)NewPartitions.increaseTo((int)3))}))).asJava()).all().get(60L, TimeUnit.SECONDS);
            this.verifyTopicPartitionMetadata(topicName, (Seq<TopicPartition>)((Seq)existingPartitions.$plus$plus((IterableOnce)new .colon.colon((Object)new TopicPartition(topicName, 2), (List)Nil$.MODULE$))), zkClient);
        }
        finally {
            zkCluster.stop();
            kraftCluster.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void verifyTopicPartitionMetadata(String topicName, Seq<TopicPartition> partitions, KafkaZkClient zkClient) {
        void var5_9;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Option computeUntilTrue_result;
            if ((computeUntilTrue_result = ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$1(zkClient, topicName)).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$3(partitions$1, x$2)))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Option topicIdReplicaAssignment = (Option)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)"Unable to find topic metadata in Zk");
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$4(zkClient, partitions, (Option)var5_9)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Unable to find topic partition metadata");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public void allocateProducerId(String bootstrapServers) {
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrapServers);
        props.put("transactional.id", "some-transaction-id");
        KafkaProducer producer = new KafkaProducer(props, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(new ProducerRecord("test", (Object)"", (Object)"one"));
        producer.commitTransaction();
        producer.flush();
        producer.close();
    }

    /*
     * WARNING - void declaration
     */
    public ProducerIdsBlock readProducerIdBlock(KafkaZkClient zkClient) {
        void var3_3;
        Tuple2 tuple2 = zkClient.getDataAndVersion("/latest_producer_id_block");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option dataOpt = (Option)tuple2._1();
        return (ProducerIdsBlock)var3_3.map((Function1 & Serializable)jsonData -> ProducerIdBlockZNode$.MODULE$.parseProducerIdBlockData(jsonData)).get();
    }

    public AlterConfigsResult alterTopicConfig(Admin admin) {
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "test");
        Collection alterConfigs = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.bytes", "204800"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.ms", null), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))).asJavaCollection();
        return admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource), (Object)alterConfigs)}))).asJava());
    }

    public AlterClientQuotasResult alterClientQuotas(Admin admin) {
        ArrayList<ClientQuotaAlteration> quotas = new ArrayList<ClientQuotaAlteration>();
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), (List)Nil$.MODULE$)).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(800.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(100.0)), (List)Nil$.MODULE$))).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"8.8.8.8")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)), (List)Nil$.MODULE$)).asJava()));
        return admin.alterClientQuotas(quotas);
    }

    public AlterUserScramCredentialsResult createUserScramCredentials(Admin admin) {
        ArrayList<UserScramCredentialUpsertion> alterations = new ArrayList<UserScramCredentialUpsertion>();
        alterations.add(new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8190), "password0"));
        return admin.alterUserScramCredentials(alterations);
    }

    public AlterUserScramCredentialsResult alterUserScramCredentials(Admin admin) {
        ArrayList<UserScramCredentialUpsertion> alterations = new ArrayList<UserScramCredentialUpsertion>();
        alterations.add(new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8191), "password1"));
        alterations.add(new UserScramCredentialUpsertion("user2", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8192), "password2"));
        return admin.alterUserScramCredentials(alterations);
    }

    public void verifyTopicConfigs(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyTopicConfigs$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public void verifyClientQuotas(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyClientQuotas$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public void verifyUserScramCredentials(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyUserScramCredentials$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void verifyProducerId(ProducerIdsBlock firstProducerIdBlock, KafkaZkClient zkClient) {
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyProducerId$1(this, zkClient, firstProducerIdBlock);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var9_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    public void shutdownInSequence(ClusterInstance zkCluster, KafkaClusterTestKit kraftCluster) {
        zkCluster.brokerIds().forEach(x$5 -> zkCluster.shutdownBroker(Predef$.MODULE$.Integer2int(x$5)));
        kraftCluster.close();
        zkCluster.stop();
    }

    public static final /* synthetic */ void $anonfun$testMigrateAcls$3(AclBinding acl1$1, AclBinding acl2$1, AclBinding acl3$1, AclBinding acl4$1, MetadataImage image) {
        java.util.Map aclMap = image.acls().acls();
        Assertions.assertEquals((int)4, (int)aclMap.size());
        Assertions.assertTrue((boolean)aclMap.values().containsAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl1$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl2$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl3$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl4$1), (List)Nil$.MODULE$))))).asJava()));
    }

    public static final /* synthetic */ void $anonfun$testMigrate$3(MetadataImage image) {
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-1"));
        Assertions.assertEquals((int)2, (int)image.topics().getTopic("test-topic-1").partitions().size());
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-2"));
        Assertions.assertEquals((int)1, (int)image.topics().getTopic("test-topic-2").partitions().size());
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-3"));
        Assertions.assertEquals((int)10, (int)image.topics().getTopic("test-topic-3").partitions().size());
        java.util.Map clientQuotas = image.clientQuotas().entities();
        Assertions.assertEquals((int)3, (int)clientQuotas.size());
    }

    public static final /* synthetic */ boolean $anonfun$testDualWriteScram$1(KafkaZkClient zkClient$1) {
        return zkClient$1.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWriteScram$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testDualWrite$1(KafkaZkClient zkClient$2) {
        return zkClient$2.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWrite$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testDualWriteQuotaAndScram$1(KafkaZkClient zkClient$3) {
        return zkClient$3.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWriteQuotaAndScram$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testNewAndChangedTopicsInDualWrite$1(KafkaZkClient zkClient$4) {
        return zkClient$4.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testNewAndChangedTopicsInDualWrite$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ Option $anonfun$verifyTopicPartitionMetadata$1(KafkaZkClient zkClient$5, String topicName$1) {
        return zkClient$5.getReplicaAssignmentAndTopicIdForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName$1}))).headOption();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicPartitionMetadata$3(Seq partitions$1, TopicZNode.TopicIdReplicaAssignment x$2) {
        return x$2.assignment().size() == partitions$1.size();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicPartitionMetadata$6(TopicPartition tp$1, LeaderIsrAndControllerEpoch lisr$1, TopicZNode.TopicIdReplicaAssignment x$4) {
        Seq seq = ((ReplicaAssignment)x$4.assignment().apply((Object)tp$1)).replicas();
        List list = lisr$1.leaderAndIsr().isr();
        return !(seq != null ? !seq.equals(list) : list != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicPartitionMetadata$5(Option topicIdReplicaAssignment$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            LeaderIsrAndControllerEpoch lisr = (LeaderIsrAndControllerEpoch)x0$1._2();
            return lisr.leaderAndIsr().leader() >= 0 && topicIdReplicaAssignment$1.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$6(tp, lisr, x$4)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicPartitionMetadata$4(KafkaZkClient zkClient$5, Seq partitions$1, Option topicIdReplicaAssignment$1) {
        Map lisrMap = zkClient$5.getTopicPartitionStates((Seq)partitions$1.toSeq());
        return lisrMap.size() == partitions$1.size() && lisrMap.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$5(topicIdReplicaAssignment$1, x0$1)));
    }

    public static final /* synthetic */ String $anonfun$verifyTopicPartitionMetadata$7() {
        return "Unable to find topic partition metadata";
    }

    public static final /* synthetic */ void $anonfun$verifyTopicConfigs$1(KafkaZkClient zkClient$6) {
        Properties propsAfter = zkClient$6.getEntityConfigs(ConfigType$.MODULE$.Topic(), "test");
        Assertions.assertEquals((Object)"204800", (Object)propsAfter.getProperty("segment.bytes"));
        Assertions.assertFalse((boolean)propsAfter.containsKey("segment.ms"));
    }

    public static final /* synthetic */ void $anonfun$verifyClientQuotas$1(KafkaZkClient zkClient$7) {
        Assertions.assertEquals((Object)"1000", (Object)zkClient$7.getEntityConfigs(ConfigType$.MODULE$.User(), "user1").getProperty("consumer_byte_rate"));
        Assertions.assertEquals((Object)"800", (Object)zkClient$7.getEntityConfigs("users/user1/clients", "clientA").getProperty("consumer_byte_rate"));
        Assertions.assertEquals((Object)"100", (Object)zkClient$7.getEntityConfigs("users/user1/clients", "clientA").getProperty("producer_byte_rate"));
        Assertions.assertEquals((Object)"10", (Object)zkClient$7.getEntityConfigs(ConfigType$.MODULE$.Ip(), "8.8.8.8").getProperty("connection_creation_rate"));
    }

    public static final /* synthetic */ void $anonfun$verifyUserScramCredentials$1(KafkaZkClient zkClient$8) {
        ScramCredential scramCredentials1 = ScramCredentialUtils.credentialFromString((String)zkClient$8.getEntityConfigs(ConfigType$.MODULE$.User(), "user1").getProperty("SCRAM-SHA-256"));
        Assertions.assertEquals((int)8191, (int)scramCredentials1.iterations());
        String propertyValue2 = zkClient$8.getEntityConfigs(ConfigType$.MODULE$.User(), "user2").getProperty("SCRAM-SHA-256");
        Assertions.assertNotNull((Object)propertyValue2);
        ScramCredential scramCredentials2 = ScramCredentialUtils.credentialFromString((String)propertyValue2);
        Assertions.assertEquals((int)8192, (int)scramCredentials2.iterations());
    }

    public static final /* synthetic */ void $anonfun$verifyProducerId$1(ZkMigrationIntegrationTest $this, KafkaZkClient zkClient$9, ProducerIdsBlock firstProducerIdBlock$1) {
        ProducerIdsBlock producerIdBlock = $this.readProducerIdBlock(zkClient$9);
        Assertions.assertTrue((firstProducerIdBlock$1.firstProducerId() < producerIdBlock.firstProducerId() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ Object $anonfun$verifyTopicPartitionMetadata$2$adapted(Seq partitions$1, Option x) {
        return BoxesRunTime.boxToBoolean((boolean)x.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$3(partitions$1, x$2))));
    }

    public class MetadataDeltaVerifier {
        private final MetadataDelta metadataDelta;
        private int offset;

        public MetadataDelta metadataDelta() {
            return this.metadataDelta;
        }

        public int offset() {
            return this.offset;
        }

        public void offset_$eq(int x$1) {
            this.offset = x$1;
        }

        public void accept(java.util.List<ApiMessageAndVersion> batch) {
            batch.forEach(message -> {
                this.metadataDelta().replay(message.message());
                this.offset_$eq(this.offset() + 1);
            });
        }

        public void verify(Function1<MetadataImage, BoxedUnit> verifier) {
            MetadataImage image = this.metadataDelta().apply(new MetadataProvenance((long)this.offset(), 0, 0L));
            verifier.apply((Object)image);
        }

        public /* synthetic */ ZkMigrationIntegrationTest kafka$zk$ZkMigrationIntegrationTest$MetadataDeltaVerifier$$$outer() {
            return ZkMigrationIntegrationTest.this;
        }

        public MetadataDeltaVerifier() {
            if (ZkMigrationIntegrationTest.this == null) {
                throw null;
            }
            this.metadataDelta = new MetadataDelta(MetadataImage.EMPTY);
            this.offset = 0;
        }
    }
}

