/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import java.io.Serializable;
import java.util.Collection;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry;
import kafka.security.authorizer.AclEntry$;
import kafka.zk.migration.ZkMigrationTestHarness;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.migration.KRaftMigrationZkWriter;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005=4Aa\u0002\u0005\u0001\u001f!)A\u0003\u0001C\u0001+!)q\u0003\u0001C\u00011!)1\t\u0001C\u0001\t\")A\f\u0001C\u0001;\")\u0001\r\u0001C\u0001C\")Q\u000e\u0001C\u0001C\nA\"l[!dY6KwM]1uS>t7\t\\5f]R$Vm\u001d;\u000b\u0005%Q\u0011!C7jOJ\fG/[8o\u0015\tYA\"\u0001\u0002{W*\tQ\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u0005A\u0011BA\n\t\u0005YQ6.T5he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u0017!\t\t\u0002!\u0001\u000bnS\u001e\u0014\u0018\r^3BG2\u001c\u0018I\u001c3WKJLg-\u001f\u000b\u00043}A\u0003C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"\u0001B+oSRDQ\u0001\t\u0002A\u0002\u0005\n!\"Y;uQ>\u0014\u0018N_3s!\t\u0011c%D\u0001$\u0015\t\u0001CE\u0003\u0002&\u0019\u0005A1/Z2ve&$\u00180\u0003\u0002(G\ti\u0011i\u00197BkRDwN]5{KJDQ!\u000b\u0002A\u0002)\nA!Y2mgB\u00191f\r\u001c\u000f\u00051\ndBA\u00171\u001b\u0005q#BA\u0018\u000f\u0003\u0019a$o\\8u}%\tA$\u0003\u000237\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001b6\u0005\r\u0019V-\u001d\u0006\u0003em\u0001\"aN!\u000e\u0003aR!!\u000f\u001e\u0002\u0007\u0005\u001cGN\u0003\u0002<y\u000511m\\7n_:T!!D\u001f\u000b\u0005yz\u0014AB1qC\u000eDWMC\u0001A\u0003\ry'oZ\u0005\u0003\u0005b\u0012!\"Q2m\u0005&tG-\u001b8h\u0003\u0001\u0012X\r\u001d7bG\u0016\f5\r\\:B]\u0012\u0014V-\u00193XSRD\u0017)\u001e;i_JL'0\u001a:\u0015\u000b)*eI\u0014+\t\u000b\u0001\u001a\u0001\u0019A\u0011\t\u000b\u001d\u001b\u0001\u0019\u0001%\u0002\u001fI,7o\\;sG\u0016\u0004\u0016\r\u001e;fe:\u0004\"!\u0013'\u000e\u0003)S!a\u0013\u001e\u0002\u0011I,7o\\;sG\u0016L!!\u0014&\u0003\u001fI+7o\\;sG\u0016\u0004\u0016\r\u001e;fe:DQaT\u0002A\u0002A\u000bA!Y2fgB\u00191fM)\u0011\u0005]\u0012\u0016BA*9\u0005I\t5mY3tg\u000e{g\u000e\u001e:pY\u0016sGO]=\t\u000bU\u001b\u0001\u0019\u0001,\u0002\tA\u0014X\r\u001a\t\u00055]S\u0013,\u0003\u0002Y7\tIa)\u001e8di&|g.\r\t\u00035iK!aW\u000e\u0003\u000f\t{w\u000e\\3b]\u0006\u0019C-\u001a7fi\u0016\u0014Vm]8ve\u000e,\u0017I\u001c3SK\u0006$w+\u001b;i\u0003V$\bn\u001c:ju\u0016\u0014HcA\r_?\")\u0001\u0005\u0002a\u0001C!)q\t\u0002a\u0001\u0011\u0006YB/Z:u\u0003\u000ed7/T5he\u0006$X-\u00118e\tV\fGn\u0016:ji\u0016$\u0012!\u0007\u0015\u0003\u000b\r\u0004\"\u0001Z6\u000e\u0003\u0015T!AZ4\u0002\u0007\u0005\u0004\u0018N\u0003\u0002iS\u00069!.\u001e9ji\u0016\u0014(B\u00016@\u0003\u0015QWO\\5u\u0013\taWM\u0001\u0003UKN$\u0018!\u0007;fgR\f5\r\\:DQ\u0006tw-Z:J]Ns\u0017\r]:i_RD#AB2")
public class ZkAclMigrationClientTest
extends ZkMigrationTestHarness {
    public void migrateAclsAndVerify(AclAuthorizer authorizer, Seq<AclBinding> acls) {
        authorizer.createAcls(null, CollectionConverters$.MODULE$.SeqHasAsJava(acls).asJava());
        ArrayBuffer batches = new ArrayBuffer();
        this.migrationClient().migrateAcls(batch -> batches.append((Object)CollectionConverters$.MODULE$.ListHasAsScala(batch).asScala()));
        ArrayBuffer records = (ArrayBuffer)((StrictOptimizedIterableOps)batches.flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$1 -> (AccessControlEntryRecord)x$1.message());
        Assertions.assertEquals((int)acls.size(), (int)records.size(), (String)"Expected one record for each ACLBinding");
    }

    /*
     * WARNING - void declaration
     */
    public Seq<AclBinding> replaceAclsAndReadWithAuthorizer(AclAuthorizer authorizer, ResourcePattern resourcePattern, Seq<AccessControlEntry> aces, Function1<Seq<AclBinding>, Object> pred) {
        void var7_11;
        Tuple2 tuple2;
        AclBindingFilter resourceFilter = new AclBindingFilter(new ResourcePatternFilter(resourcePattern.resourceType(), resourcePattern.name(), resourcePattern.patternType()), AclBindingFilter.ANY.entryFilter());
        this.migrationState_$eq(this.migrationClient().aclClient().writeResourceAcls(resourcePattern, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(aces).asJava(), this.migrationState()));
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Seq computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)pred.apply((Object)(computeUntilTrue_result = ZkAclMigrationClientTest.$anonfun$replaceAclsAndReadWithAuthorizer$1(authorizer, resourceFilter))))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var14_9 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Seq acls = (Seq)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp());
        return var7_11;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteResourceAndReadWithAuthorizer(AclAuthorizer authorizer, ResourcePattern resourcePattern) {
        void var5_9;
        Tuple2 tuple2;
        AclBindingFilter resourceFilter = new AclBindingFilter(new ResourcePatternFilter(resourcePattern.resourceType(), resourcePattern.name(), resourcePattern.patternType()), AclBindingFilter.ANY.entryFilter());
        this.migrationState_$eq(this.migrationClient().aclClient().deleteResource(resourcePattern, this.migrationState()));
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Seq computeUntilTrue_result;
            if ((computeUntilTrue_result = ZkAclMigrationClientTest.$anonfun$deleteResourceAndReadWithAuthorizer$1(authorizer, resourceFilter)).isEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean ok = tuple22._2$mcZ$sp();
        Assertions.assertTrue((boolean)var5_9);
    }

    @Test
    public void testAclsMigrateAndDualWrite() {
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(Uuid.randomUuid()).toString(), PatternType.PREFIXED);
        String username = "alice";
        KafkaPrincipal principal = new KafkaPrincipal("User", username);
        KafkaPrincipal wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry$.MODULE$.WildcardPrincipalString());
        AccessControlEntry ace1 = new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding acl1 = new AclBinding(resource1, ace1);
        AccessControlEntry ace2 = new AccessControlEntry(principal.toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW);
        AclBinding acl2 = new AclBinding(resource1, ace2);
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(wildcardPrincipal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        try (AclAuthorizer authorizer = new AclAuthorizer();){
            authorizer.configure(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)this.zkConnect())}))).asJava());
            this.migrateAclsAndVerify(authorizer, (Seq<AclBinding>)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)new .colon.colon((Object)acl3, (List)new .colon.colon((Object)acl4, (List)Nil$.MODULE$)))));
            Seq<AclBinding> resource1Acls = this.replaceAclsAndReadWithAuthorizer(authorizer, resource1, (Seq<AccessControlEntry>)new .colon.colon((Object)ace1, (List)Nil$.MODULE$), (Function1<Seq<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$1(acls)));
            Assertions.assertEquals((Object)acl1, (Object)resource1Acls.head());
            this.deleteResourceAndReadWithAuthorizer(authorizer, resource1);
            AccessControlEntry newAce1 = new AccessControlEntry(principal.toString(), "10.0.0.1", AclOperation.WRITE, AclPermissionType.ALLOW);
            resource1Acls = this.replaceAclsAndReadWithAuthorizer(authorizer, resource1, (Seq<AccessControlEntry>)new .colon.colon((Object)newAce1, (List)Nil$.MODULE$), (Function1<Seq<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$2(acls)));
            Assertions.assertEquals((Object)newAce1, (Object)((AclBinding)resource1Acls.head()).entry());
            AccessControlEntry newAce2 = new AccessControlEntry(principal.toString(), "10.0.0.1", AclOperation.WRITE, AclPermissionType.ALLOW);
            Seq<AclBinding> resource2Acls = this.replaceAclsAndReadWithAuthorizer(authorizer, resource2, (Seq<AccessControlEntry>)new .colon.colon((Object)acl3.entry(), (List)new .colon.colon((Object)newAce2, (List)Nil$.MODULE$)), (Function1<Seq<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$3(acls)));
            Assertions.assertEquals((Object)acl3, (Object)resource2Acls.head());
            Assertions.assertEquals((Object)newAce2, (Object)((AclBinding)resource2Acls.last()).entry());
        }
    }

    @Test
    public void testAclsChangesInSnapshot() {
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern resource3 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("baz-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        String username1 = "alice";
        String username2 = "blah";
        KafkaPrincipal principal1 = new KafkaPrincipal("User", username1);
        KafkaPrincipal principal2 = new KafkaPrincipal("User", username2);
        AclEntry acl1Resource1 = new AclEntry(new AccessControlEntry(principal1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW));
        AclEntry acl1Resource2 = new AclEntry(new AccessControlEntry(principal2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.zkClient().createAclPaths();
        this.zkClient().createAclsForResourceIfNotExists(resource1, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclEntry[]{acl1Resource1})));
        this.zkClient().createAclsForResourceIfNotExists(resource2, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclEntry[]{acl1Resource2})));
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY);
        AccessControlEntryRecord acl1Resource3 = new AccessControlEntryRecord().setId(Uuid.randomUuid()).setHost("192.168.10.1").setOperation(AclOperation.READ.code()).setPrincipal(AclEntry$.MODULE$.WildcardPrincipalString()).setPermissionType(AclPermissionType.ALLOW.code()).setPatternType(resource3.patternType().code()).setResourceName(resource3.name()).setResourceType(resource3.resourceType().code());
        delta.replay(acl1Resource3);
        AccessControlEntryRecord acl2Resource1 = new AccessControlEntryRecord().setId(Uuid.randomUuid()).setHost("192.168.15.1").setOperation(AclOperation.WRITE.code()).setPrincipal(principal1.toString()).setPermissionType(AclPermissionType.ALLOW.code()).setPatternType(resource1.patternType().code()).setResourceName(resource1.name()).setResourceType(resource1.resourceType().code());
        delta.replay(acl2Resource1);
        MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
        new KRaftMigrationZkWriter((MigrationClient)this.migrationClient()).handleSnapshot(image, (x$4, x$5, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        Set resource1AclsInZk = this.zkClient().getVersionedAclsForResource(resource1).acls();
        Assertions.assertEquals((int)1, (int)resource1AclsInZk.size());
        Assertions.assertEquals((Object)new AccessControlEntry(acl2Resource1.principal(), acl2Resource1.host(), AclOperation.fromCode((byte)acl2Resource1.operation()), AclPermissionType.fromCode((byte)acl2Resource1.permissionType())), (Object)((AclEntry)resource1AclsInZk.head()).ace());
        Assertions.assertTrue((boolean)this.zkClient().getVersionedAclsForResource(resource2).acls().isEmpty());
        Set resource3AclsInZk = this.zkClient().getVersionedAclsForResource(resource3).acls();
        Assertions.assertEquals((Object)new AccessControlEntry(acl1Resource3.principal(), acl1Resource3.host(), AclOperation.fromCode((byte)acl1Resource3.operation()), AclPermissionType.fromCode((byte)acl1Resource3.permissionType())), (Object)((AclEntry)resource3AclsInZk.head()).ace());
    }

    public static final /* synthetic */ Seq $anonfun$replaceAclsAndReadWithAuthorizer$1(AclAuthorizer authorizer$1, AclBindingFilter resourceFilter$1) {
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$1.acls(resourceFilter$1)).asScala().toSeq();
    }

    public static final /* synthetic */ Seq $anonfun$deleteResourceAndReadWithAuthorizer$1(AclAuthorizer authorizer$2, AclBindingFilter resourceFilter$2) {
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$2.acls(resourceFilter$2)).asScala().toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$1(Seq acls) {
        return acls.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$2(Seq acls) {
        return acls.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$3(Seq acls) {
        return acls.size() == 2;
    }

    public static final /* synthetic */ Object $anonfun$deleteResourceAndReadWithAuthorizer$2$adapted(Seq x$3) {
        return BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty());
    }
}

