/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.log.OffsetsToClean;
import kafka.log.PreCleanStats;
import kafka.log.UnifiedLog;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rEc!\u0002 @\u0001}\u001a\u0005\u0002\u0003)\u0001\u0005\u000b\u0007I\u0011\u0001*\t\u0011\u0005\u0004!\u0011!Q\u0001\nMC\u0001B\u0019\u0001\u0003\u0006\u0004%\ta\u0019\u0005\tm\u0002\u0011\t\u0011)A\u0005I\"Aq\u000f\u0001BC\u0002\u0013\u0005\u0001\u0010C\u0005\u0002\u0006\u0001\u0011\t\u0011)A\u0005s\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001\"CA\n\u0001\t\u0007I\u0011BA\u000b\u0011!\t9\u0003\u0001Q\u0001\n\u0005]\u0001bBA\u0015\u0001\u0011E\u00131\u0006\u0005\u000b\u0003\u0007\u0002!\u0019!C\u0001\u007f\u0005\u0015\u0003\u0002CA)\u0001\u0001\u0006I!a\u0012\t\u0013\u0005M\u0003\u00011A\u0005\n\u0005U\u0003\"CA8\u0001\u0001\u0007I\u0011BA9\u0011!\ti\b\u0001Q!\n\u0005]\u0003\"CAD\u0001\t\u0007I\u0011BAE\u0011!\ti\n\u0001Q\u0001\n\u0005-\u0005\"CAP\u0001\t\u0007I\u0011BAQ\u0011!\tY\u000b\u0001Q\u0001\n\u0005\r\u0006\"CAW\u0001\t\u0007I\u0011BAX\u0011!\t)\r\u0001Q\u0001\n\u0005E\u0006\"CAd\u0001\t\u0007I\u0011BAe\u0011!\t\t\u000e\u0001Q\u0001\n\u0005-\u0007\"CAj\u0001\u0001\u0007I\u0011BAk\u0011%\ti\u000e\u0001a\u0001\n\u0013\ty\u000e\u0003\u0005\u0002d\u0002\u0001\u000b\u0015BAl\u0011%\t9\u000f\u0001a\u0001\n\u0013\tI\u000fC\u0005\u0002r\u0002\u0001\r\u0011\"\u0003\u0002t\"A\u0011q\u001f\u0001!B\u0013\tY\u000fC\u0004\u0002|\u0002!\t!!@\t\u0011\t\r\u0001\u0001\"\u0001@\u0005\u000bA\u0001B!\u0005\u0001\t\u0003y$1\u0003\u0005\b\u00057\u0001A\u0011\u0001B\u000f\u0011%\u0011y\u0004AI\u0001\n\u0003\u0011\t\u0005C\u0004\u0003X\u0001!\tA!\u0017\t\u000f\t\u001d\u0004\u0001\"\u0001\u0003Z!9!\u0011\u000e\u0001\u0005\u0002\t-\u0004b\u0002B9\u0001\u0011\u0005!1\u000f\u0005\b\u0005o\u0002A\u0011\u0001B=\u0011\u001d\u0011\t\t\u0001C\u0005\u0005\u0007CqA!%\u0001\t\u0013\u0011\u0019\nC\u0004\u0003\u0018\u0002!\tA!'\t\u000f\tu\u0005\u0001\"\u0001\u0003 \"I!1\u0017\u0001\u0012\u0002\u0013\u0005!Q\u0017\u0005\n\u0005s\u0003\u0011\u0013!C\u0001\u0005wCqAa0\u0001\t\u0003\u0011\t\rC\u0004\u0003N\u0002!\tAa4\t\u000f\tU\u0007\u0001\"\u0001\u0003X\"9!\u0011\u001d\u0001\u0005\u0002\t\r\bb\u0002Bw\u0001\u0011\u0005!q\u001e\u0005\t\u0003?\u0003A\u0011A \u0003t\"9!Q \u0001\u0005\u0002\t}\bbBB\u0004\u0001\u0011%1\u0011\u0002\u0005\b\u0007\u001f\u0001A\u0011AB\t\u000f!\u0019\u0019b\u0010E\u0001\u007f\rUaa\u0002 @\u0011\u0003y4q\u0003\u0005\b\u0003\u000fAD\u0011AB\r\u0011\u001d\u0019Y\u0002\u000fC\u0001\u0007;Aqa!\t9\t\u0003\u0019\u0019\u0003C\u0004\u00040a\"\ta!\r\t\u000f\r\r\u0003\b\"\u0001\u0004F\t\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\u000b\u0005\u0001\u000b\u0015a\u00017pO*\t!)A\u0003lC\u001a\\\u0017mE\u0002\u0001\t*\u0003\"!\u0012%\u000e\u0003\u0019S\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\u001a\u0013a!\u00118z%\u00164\u0007CA&O\u001b\u0005a%BA'B\u0003\u0015)H/\u001b7t\u0013\tyEJA\u0004M_\u001e<\u0017N\\4\u0002\u000f1|w\rR5sg\u000e\u0001Q#A*\u0011\u0007Q;\u0016,D\u0001V\u0015\t1f)\u0001\u0006d_2dWm\u0019;j_:L!\u0001W+\u0003\u0007M+\u0017\u000f\u0005\u0002[?6\t1L\u0003\u0002];\u0006\u0011\u0011n\u001c\u0006\u0002=\u0006!!.\u0019<b\u0013\t\u00017L\u0001\u0003GS2,\u0017\u0001\u00037pO\u0012K'o\u001d\u0011\u0002\t1|wm]\u000b\u0002IB!1*Z4s\u0013\t1GJ\u0001\u0003Q_>d\u0007C\u00015q\u001b\u0005I'B\u00016l\u0003\u0019\u0019w.\\7p]*\u0011!\t\u001c\u0006\u0003[:\fa!\u00199bG\",'\"A8\u0002\u0007=\u0014x-\u0003\u0002rS\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007CA:u\u001b\u0005y\u0014BA;@\u0005))f.\u001b4jK\u0012dunZ\u0001\u0006Y><7\u000fI\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0016\u0003e\u00042A_A\u0001\u001b\u0005Y(B\u0001!}\u0015\tih0A\u0005j]R,'O\\1mg*\u0011qp[\u0001\bgR|'/Y4f\u0013\r\t\u0019a\u001f\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0002+1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3mA\u00051A(\u001b8jiz\"\u0002\"a\u0003\u0002\u000e\u0005=\u0011\u0011\u0003\t\u0003g\u0002AQ\u0001U\u0004A\u0002MCQAY\u0004A\u0002\u0011DQa^\u0004A\u0002e\fA\"\\3ue&\u001c7o\u0012:pkB,\"!a\u0006\u0011\t\u0005e\u00111E\u0007\u0003\u00037QA!!\b\u0002 \u00059Q.\u001a;sS\u000e\u001c(bAA\u0011W\u000611/\u001a:wKJLA!!\n\u0002\u001c\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u001b5,GO]5dg\u001e\u0013x.\u001e9!\u0003)awnZ4fe:\u000bW.Z\u000b\u0003\u0003[\u0001B!a\f\u0002>9!\u0011\u0011GA\u001d!\r\t\u0019DR\u0007\u0003\u0003kQ1!a\u000eR\u0003\u0019a$o\\8u}%\u0019\u00111\b$\u0002\rA\u0013X\rZ3g\u0013\u0011\ty$!\u0011\u0003\rM#(/\u001b8h\u0015\r\tYDR\u0001\u0015_\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055S,\u0001\u0003mC:<\u0017\u0002BA \u0003\u0017\nQc\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0007%A\u0006dQ\u0016\u001c7\u000e]8j]R\u001cXCAA,!\u001d\tI&a\u0018Z\u0003Gj!!a\u0017\u000b\u0007\u0005uS+A\u0005j[6,H/\u00192mK&!\u0011\u0011MA.\u0005\ri\u0015\r\u001d\t\u0005\u0003K\nY'\u0004\u0002\u0002h)!\u00111KA5\u0015\r\t\t#Q\u0005\u0005\u0003[\n9G\u0001\u000bPM\u001a\u001cX\r^\"iK\u000e\\\u0007o\\5oi\u001aKG.Z\u0001\u0010G\",7m\u001b9pS:$8o\u0018\u0013fcR!\u00111OA=!\r)\u0015QO\u0005\u0004\u0003o2%\u0001B+oSRD\u0011\"a\u001f\u000f\u0003\u0003\u0005\r!a\u0016\u0002\u0007a$\u0013'\u0001\u0007dQ\u0016\u001c7\u000e]8j]R\u001c\b\u0005K\u0002\u0010\u0003\u0003\u00032!RAB\u0013\r\t)I\u0012\u0002\tm>d\u0017\r^5mK\u0006Q\u0011N\u001c)s_\u001e\u0014Xm]:\u0016\u0005\u0005-\u0005cBAG\u0003';\u0017qS\u0007\u0003\u0003\u001fS1!!%V\u0003\u001diW\u000f^1cY\u0016LA!!&\u0002\u0010\n9\u0001*Y:i\u001b\u0006\u0004\bcA:\u0002\u001a&\u0019\u00111T \u0003!1{wm\u00117fC:LgnZ*uCR,\u0017aC5o!J|wM]3tg\u0002\nQ#\u001e8dY\u0016\fg.\u00192mKB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002$BA\u0011QRAJ\u0003[\t)\u000bE\u0003\u0002\u000e\u0006\u001dv-\u0003\u0003\u0002*\u0006=%aA*fi\u00061RO\\2mK\u0006t\u0017M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0003m_\u000e\\WCAAY!\u0011\t\u0019,!1\u000e\u0005\u0005U&\u0002BA\\\u0003s\u000bQ\u0001\\8dWNTA!a/\u0002>\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005}V,\u0001\u0003vi&d\u0017\u0002BAb\u0003k\u0013QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0017!\u00027pG.\u0004\u0013A\u00059bkN,Gm\u00117fC:LgnZ\"p]\u0012,\"!a3\u0011\t\u0005M\u0016QZ\u0005\u0005\u0003\u001f\f)LA\u0005D_:$\u0017\u000e^5p]\u0006\u0019\u0002/Y;tK\u0012\u001cE.Z1oS:<7i\u001c8eA\u0005IB-\u001b:uS\u0016\u001cH\u000fT8h\u00072,\u0017M\\1cY\u0016\u0014\u0016\r^5p+\t\t9\u000eE\u0002F\u00033L1!a7G\u0005\u0019!u.\u001e2mK\u0006iB-\u001b:uS\u0016\u001cH\u000fT8h\u00072,\u0017M\\1cY\u0016\u0014\u0016\r^5p?\u0012*\u0017\u000f\u0006\u0003\u0002t\u0005\u0005\b\"CA>3\u0005\u0005\t\u0019AAl\u0003i!\u0017N\u001d;jKN$Hj\\4DY\u0016\fg.\u00192mKJ\u000bG/[8!Q\rQ\u0012\u0011Q\u0001\u000ei&lWm\u00144MCN$(+\u001e8\u0016\u0005\u0005-\bcA#\u0002n&\u0019\u0011q\u001e$\u0003\t1{gnZ\u0001\u0012i&lWm\u00144MCN$(+\u001e8`I\u0015\fH\u0003BA:\u0003kD\u0011\"a\u001f\u001d\u0003\u0003\u0005\r!a;\u0002\u001dQLW.Z(g\u0019\u0006\u001cHOU;oA!\u001aQ$!!\u0002+\u0005dGn\u00117fC:,'o\u00115fG.\u0004x.\u001b8ugV\u0011\u0011q \t\b\u0003_\u0011\taZAv\u0013\u0011\t\t'!\u0011\u0002\u001b\rdW-\u00198j]\u001e\u001cF/\u0019;f)\u0011\u00119A!\u0004\u0011\u000b\u0015\u0013I!a&\n\u0007\t-aI\u0001\u0004PaRLwN\u001c\u0005\u0007\u0005\u001fy\u0002\u0019A4\u0002\u0005Q\u0004\u0018\u0001E:fi\u000ecW-\u00198j]\u001e\u001cF/\u0019;f)\u0019\t\u0019H!\u0006\u0003\u0018!1!q\u0002\u0011A\u0002\u001dDqA!\u0007!\u0001\u0004\t9*A\u0003ti\u0006$X-A\rhe\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><GC\u0002B\u0010\u0005O\u0011)\u0004E\u0003F\u0005\u0013\u0011\t\u0003E\u0002t\u0005GI1A!\n@\u0005)aun\u001a+p\u00072,\u0017M\u001c\u0005\b\u0005S\t\u0003\u0019\u0001B\u0016\u0003\u0011!\u0018.\\3\u0011\t\t5\"\u0011G\u0007\u0003\u0005_Q!!T5\n\t\tM\"q\u0006\u0002\u0005)&lW\rC\u0005\u00038\u0005\u0002\n\u00111\u0001\u0003:\u0005i\u0001O]3DY\u0016\fgn\u0015;biN\u00042a\u001dB\u001e\u0013\r\u0011id\u0010\u0002\u000e!J,7\t\\3b]N#\u0018\r^:\u0002G\u001d\u0014\u0018M\u0019$jYRD\u0017.Z:u\u0007>l\u0007/Y2uK\u0012dun\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\t\u0016\u0005\u0005s\u0011)e\u000b\u0002\u0003HA!!\u0011\nB*\u001b\t\u0011YE\u0003\u0003\u0003N\t=\u0013!C;oG\",7m[3e\u0015\r\u0011\tFR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B+\u0005\u0017\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0019\u0002\u0018-^:f\u00072,\u0017M\\5oO\u001a{'OT8o\u0007>l\u0007/Y2uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003\u00057\u0002R\u0001\u0016B/\u0005CJ1Aa\u0018V\u0005!IE/\u001a:bE2,\u0007#B#\u0003d\u001d\u0014\u0018b\u0001B3\r\n1A+\u001e9mKJ\nQ\u0002Z3mKR\f'\r\\3M_\u001e\u001c\u0018!D1c_J$8\t\\3b]&tw\r\u0006\u0003\u0002t\t5\u0004B\u0002B8K\u0001\u0007q-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0002+\u0005\u0014wN\u001d;B]\u0012\u0004\u0016-^:f\u00072,\u0017M\\5oOR!\u00111\u000fB;\u0011\u0019\u0011yG\na\u0001O\u0006q!/Z:v[\u0016\u001cE.Z1oS:<G\u0003BA:\u0005wBqA! (\u0001\u0004\u0011y(A\bu_BL7\rU1si&$\u0018n\u001c8t!\u0011!&QL4\u0002#%\u001c8\t\\3b]&tw-\u00138Ti\u0006$X\r\u0006\u0004\u0003\u0006\n-%Q\u0012\t\u0004\u000b\n\u001d\u0015b\u0001BE\r\n9!i\\8mK\u0006t\u0007B\u0002B8Q\u0001\u0007q\rC\u0004\u0003\u0010\"\u0002\r!a&\u0002\u001b\u0015D\b/Z2uK\u0012\u001cF/\u0019;f\u0003]I7o\u00117fC:LgnZ%o'R\fG/\u001a)bkN,G\r\u0006\u0003\u0003\u0006\nU\u0005B\u0002B8S\u0001\u0007q-\u0001\u000bdQ\u0016\u001c7n\u00117fC:LgnZ!c_J$X\r\u001a\u000b\u0005\u0003g\u0012Y\n\u0003\u0004\u0003p)\u0002\raZ\u0001\u0012kB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001cH\u0003CA:\u0005C\u0013)K!,\t\r\t\r6\u00061\u0001Z\u0003\u001d!\u0017\r^1ESJD\u0011Ba*,!\u0003\u0005\rA!+\u0002-A\f'\u000f^5uS>tGk\\+qI\u0006$Xm\u0014:BI\u0012\u0004R!\u0012B\u0005\u0005W\u0003b!\u0012B2O\u0006-\b\"\u0003BXWA\u0005\t\u0019\u0001BY\u0003E\u0001\u0018M\u001d;ji&|g\u000eV8SK6|g/\u001a\t\u0005\u000b\n%q-A\u000eva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$C-\u001a4bk2$HEM\u000b\u0003\u0005oSCA!+\u0003F\u0005YR\u000f\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:%I\u00164\u0017-\u001e7uIM*\"A!0+\t\tE&QI\u0001\u0013C2$XM]\"iK\u000e\\\u0007o\\5oi\u0012K'\u000f\u0006\u0005\u0002t\t\r'Q\u0019Be\u0011\u0019\u0011yG\fa\u0001O\"1!q\u0019\u0018A\u0002e\u000bAb]8ve\u000e,Gj\\4ESJDaAa3/\u0001\u0004I\u0016A\u00033fgRdun\u001a#je\u0006\u0019\u0002.\u00198eY\u0016dun\u001a#je\u001a\u000b\u0017\u000e\\;sKR!\u00111\u000fBi\u0011\u001d\u0011\u0019n\fa\u0001\u0003[\t1\u0001Z5s\u0003]i\u0017-\u001f2f)J,hnY1uK\u000eCWmY6q_&tG\u000f\u0006\u0005\u0002t\te'1\u001cBo\u0011\u0019\u0011\u0019\u000b\ra\u00013\"1!q\u000e\u0019A\u0002\u001dDqAa81\u0001\u0004\tY/\u0001\u0004pM\u001a\u001cX\r^\u0001\rI>tWm\u00117fC:Lgn\u001a\u000b\t\u0003g\u0012)Oa:\u0003j\"1!qN\u0019A\u0002\u001dDaAa)2\u0001\u0004I\u0006b\u0002Bvc\u0001\u0007\u00111^\u0001\nK:$wJ\u001a4tKR\fA\u0002Z8oK\u0012+G.\u001a;j]\u001e$B!a\u001d\u0003r\"9!Q\u0010\u001aA\u0002\t}D\u0003\u0002B{\u0005s\u0004R!a\f\u0003x\u001eLA!!+\u0002B!9!1`\u001aA\u0002\u00055\u0012A\u00027pO\u0012K'/\u0001\rnCJ\\\u0007+\u0019:uSRLwN\\+oG2,\u0017M\\1cY\u0016$b!a\u001d\u0004\u0002\r\r\u0001b\u0002B~i\u0001\u0007\u0011Q\u0006\u0005\u0007\u0007\u000b!\u0004\u0019A4\u0002\u0013A\f'\u000f^5uS>t\u0017AF5t+:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8\u0015\r\t\u001551BB\u0007\u0011\u0015\u0001U\u00071\u0001s\u0011\u0019\u0011y'\u000ea\u0001O\u0006iR.Y5oi\u0006Lg.\u00168dY\u0016\fg.\u00192mKB\u000b'\u000f^5uS>t7\u000f\u0006\u0002\u0002t\u0005\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\u0011\u0005MD4c\u0001\u001dE\u0015R\u00111QC\u0001\u0013SN\u001cu.\u001c9bGR\fe\u000e\u001a#fY\u0016$X\r\u0006\u0003\u0003\u0006\u000e}\u0001\"\u0002!;\u0001\u0004\u0011\u0018AE7bq\u000e{W\u000e]1di&|g\u000eR3mCf$\u0002\"a;\u0004&\r\u001d21\u0006\u0005\u0006\u0001n\u0002\rA\u001d\u0005\b\u0007SY\u0004\u0019AAv\u0003A1\u0017N]:u\t&\u0014H/_(gMN,G\u000fC\u0004\u0004.m\u0002\r!a;\u0002\u00079|w/\u0001\tdY\u0016\fg.\u00192mK>3gm]3ugRA11GB\u001d\u0007w\u0019\t\u0005E\u0002t\u0007kI1aa\u000e@\u00059yeMZ:fiN$vn\u00117fC:DQ\u0001\u0011\u001fA\u0002IDqa!\u0010=\u0001\u0004\u0019y$A\bmCN$8\t\\3b]>3gm]3u!\u0015)%\u0011BAv\u0011\u001d\u0019i\u0003\u0010a\u0001\u0003W\fqcY1mGVd\u0017\r^3DY\u0016\fg.\u00192mK\nKH/Z:\u0015\u0011\r\u001d3\u0011JB&\u0007\u001b\u0002r!\u0012B2\u0003W\fY\u000fC\u0003A{\u0001\u0007!\u000fC\u0004\u0004*u\u0002\r!a;\t\u000f\r=S\b1\u0001\u0002l\u0006\tRO\\2mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;")
public class LogCleanerManager
implements Logging {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, UnifiedLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    private final KafkaMetricsGroup metricsGroup;
    private final String offsetCheckpointFile;
    private volatile scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> inProgress;
    private final HashMap<String, Set<TopicPartition>> uncleanablePartitions;
    private final ReentrantLock lock;
    private final Condition pausedCleaningCond;
    private volatile double dirtiestLogCleanableRatio;
    private volatile long timeOfLastRun;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> calculateCleanableBytes(UnifiedLog log, long firstDirtyOffset, long uncleanableOffset) {
        return LogCleanerManager$.MODULE$.calculateCleanableBytes(log, firstDirtyOffset, uncleanableOffset);
    }

    public static OffsetsToClean cleanableOffsets(UnifiedLog log, Option<Object> lastCleanOffset, long now) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, lastCleanOffset, now);
    }

    public static long maxCompactionDelay(UnifiedLog log, long firstDirtyOffset, long now) {
        return LogCleanerManager$.MODULE$.maxCompactionDelay(log, firstDirtyOffset, now);
    }

    public static boolean isCompactAndDelete(UnifiedLog log) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(log);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, UnifiedLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints() {
        return this.checkpoints;
    }

    private void checkpoints_$eq(scala.collection.immutable.Map<File, OffsetCheckpointFile> x$1) {
        this.checkpoints = x$1;
    }

    private HashMap<TopicPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    private HashMap<String, Set<TopicPartition>> uncleanablePartitions() {
        return this.uncleanablePartitions;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    private double dirtiestLogCleanableRatio() {
        return this.dirtiestLogCleanableRatio;
    }

    private void dirtiestLogCleanableRatio_$eq(double x$1) {
        this.dirtiestLogCleanableRatio = x$1;
    }

    private long timeOfLastRun() {
        return this.timeOfLastRun;
    }

    private void timeOfLastRun_$eq(long x$1) {
        this.timeOfLastRun = x$1;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        scala.collection.immutable.Map map;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            map = LogCleanerManager.$anonfun$allCleanerCheckpoints$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return map;
    }

    public Option<LogCleaningState> cleaningState(TopicPartition tp) {
        Option option;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            option = LogCleanerManager.$anonfun$cleaningState$1(this, tp);
        }
        finally {
            inLock_lock.unlock();
        }
        return option;
    }

    public void setCleaningState(TopicPartition tp, LogCleaningState state) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$setCleaningState$1(this, tp, state);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time, PreCleanStats preCleanStats) {
        Option option;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            option = LogCleanerManager.$anonfun$grabFilthiestCompactedLog$1(this, time, preCleanStats);
        }
        finally {
            inLock_lock.unlock();
        }
        return option;
    }

    public PreCleanStats grabFilthiestCompactedLog$default$2() {
        return new PreCleanStats();
    }

    public Iterable<Tuple2<TopicPartition, UnifiedLog>> pauseCleaningForNonCompactedPartitions() {
        Iterable iterable;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            iterable = LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return iterable;
    }

    public Iterable<Tuple2<TopicPartition, UnifiedLog>> deletableLogs() {
        Iterable iterable;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            iterable = LogCleanerManager.$anonfun$deletableLogs$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return iterable;
    }

    public void abortCleaning(TopicPartition topicPartition) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$abortCleaning$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$abortAndPauseCleaning$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            topicPartitions.foreach((Function1 & Serializable)topicPartition -> {
                Option option = $this.inProgress().get(topicPartition);
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringBuilder(67).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is not paused.").toString());
                }
                if (option instanceof Some) {
                    int count;
                    LogCleaningState state = (LogCleaningState)((Some)option).value();
                    boolean bl = false;
                    LogCleaningPaused logCleaningPaused = null;
                    if (state instanceof LogCleaningPaused) {
                        bl = true;
                        logCleaningPaused = (LogCleaningPaused)state;
                        if (logCleaningPaused.pausedCount() == 1) {
                            return $this.inProgress().remove(topicPartition);
                        }
                    }
                    if (bl && (count = logCleaningPaused.pausedCount()) > 1) {
                        return $this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(count - 1));
                    }
                    throw new IllegalStateException(new StringBuilder(66).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is in ").append(state).append(" state.").toString());
                }
                throw new MatchError((Object)option);
            });
        }
        finally {
            inLock_lock.unlock();
        }
    }

    private boolean isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            LogCleaningState logCleaningState = (LogCleaningState)((Some)option).value();
            return !(logCleaningState != null ? !logCleaningState.equals(expectedState) : expectedState != null);
        }
        throw new MatchError((Object)option);
    }

    private boolean isCleaningInStatePaused(TopicPartition topicPartition) {
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return (LogCleaningState)((Some)option).value() instanceof LogCleaningPaused;
        }
        throw new MatchError((Object)option);
    }

    public void checkCleaningAborted(TopicPartition topicPartition) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$checkCleaningAborted$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$updateCheckpoints$1(this, dataDir, partitionToRemove, partitionToUpdateOrAdd);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public Option<Tuple2<TopicPartition, Object>> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public Option<TopicPartition> updateCheckpoints$default$3() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$alterCheckpointDir$1(this, sourceLogDir, topicPartition, destLogDir);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public void handleLogDirFailure(String dir) {
        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Stopping cleaning logs in dir ").append(dir).toString());
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            this.checkpoints_$eq((scala.collection.immutable.Map<File, OffsetCheckpointFile>)((scala.collection.immutable.Map)this.checkpoints().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$handleLogDirFailure$3(dir$3, x0$1)))));
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$maybeTruncateCheckpoint$1(this, topicPartition, dataDir, offset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$doneCleaning$1(this, topicPartition, dataDir, endOffset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public void doneDeleting(Iterable<TopicPartition> topicPartitions) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            topicPartitions.foreach((Function1 & Serializable)topicPartition -> {
                LogCleaningState logCleaningState;
                boolean bl = false;
                Some some = null;
                Option option = $this.inProgress().get(topicPartition);
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                    if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                        return $this.inProgress().remove(topicPartition);
                    }
                }
                if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                    $this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(1));
                    $this.pausedCleaningCond().signalAll();
                    return BoxedUnit.UNIT;
                }
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
                }
                throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
            });
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public scala.collection.immutable.Set<TopicPartition> uncleanablePartitions(String logDir) {
        ObjectRef partitions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            partitions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)partitions.elem).$plus$plus((IterableOnce)this.uncleanablePartitions().getOrElse((Object)logDir, (Function0 & Serializable)() -> (scala.collection.immutable.Set)partitions$1.elem));
        }
        finally {
            inLock_lock.unlock();
        }
        return (scala.collection.immutable.Set)partitions.elem;
    }

    public void markPartitionUncleanable(String logDir, TopicPartition partition) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$markPartitionUncleanable$1(this, logDir, partition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    private boolean isUncleanablePartition(UnifiedLog log, TopicPartition topicPartition) {
        boolean bl;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            bl = LogCleanerManager.$anonfun$isUncleanablePartition$1(this, log, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
        return bl;
    }

    public void maintainUncleanablePartitions() {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$maintainUncleanablePartitions$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public static final /* synthetic */ int $anonfun$new$3(LogCleanerManager $this, File dir$1) {
        return BoxesRunTime.unboxToInt((Object)$this.uncleanablePartitions().get((Object)dir$1.getAbsolutePath()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public final /* synthetic */ int kafka$log$LogCleanerManager$$$anonfun$new$2(File dir$1) {
        int n;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            n = LogCleanerManager.$anonfun$new$3(this, dir$1);
        }
        finally {
            inLock_lock.unlock();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$new$10(scala.collection.immutable.Map lastClean$1, TopicPartition tp$1, long now$1, UnifiedLog log) {
        void var8_7;
        Option lastCleanOffset = lastClean$1.get((Object)tp$1);
        OffsetsToClean offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)lastCleanOffset, now$1);
        Tuple2<Object, Object> tuple2 = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, offsetsToClean.firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long uncleanableBytes = tuple2._2$mcJ$sp();
        return (long)var8_7;
    }

    public static final /* synthetic */ long $anonfun$new$9(LogCleanerManager $this, scala.collection.immutable.Map lastClean$1, long now$1, TopicPartition tp) {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)$this.logs().get(tp)).map((Function1 & Serializable)log -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$10(lastClean$1, tp, now$1, log))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ long $anonfun$new$8(LogCleanerManager $this, File dir$2) {
        Option option = $this.uncleanablePartitions().get((Object)dir$2.getAbsolutePath());
        if (option instanceof Some) {
            Set partitions = (Set)((Some)option).value();
            scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.allCleanerCheckpoints();
            long now = Time.SYSTEM.milliseconds();
            return BoxesRunTime.unboxToLong((Object)partitions.iterator().map((Function1 & Serializable)tp -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$9($this, lastClean, now, tp))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }
        if (None$.MODULE$.equals(option)) {
            return 0L;
        }
        throw new MatchError((Object)option);
    }

    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$7(File dir$2) {
        long l;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            l = LogCleanerManager.$anonfun$new$8(this, dir$2);
        }
        finally {
            inLock_lock.unlock();
        }
        return l;
    }

    public final /* synthetic */ int kafka$log$LogCleanerManager$$$anonfun$new$12() {
        return (int)((double)100 * this.dirtiestLogCleanableRatio());
    }

    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$13() {
        return Time.SYSTEM.milliseconds() - this.timeOfLastRun();
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$allCleanerCheckpoints$1(LogCleanerManager $this) {
        return ((IterableOnceOps)$this.checkpoints().values().flatMap((Function1 & Serializable)checkpoint -> {
            try {
                return checkpoint.read();
            }
            catch (KafkaStorageException e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return Predef$.MODULE$.Map().empty();
            }
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ Option $anonfun$cleaningState$1(LogCleanerManager $this, TopicPartition tp$2) {
        return $this.inProgress().get((Object)tp$2);
    }

    public static final /* synthetic */ Option $anonfun$setCleaningState$1(LogCleanerManager $this, TopicPartition tp$3, LogCleaningState state$1) {
        return $this.inProgress().put((Object)tp$3, (Object)state$1);
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((UnifiedLog)x0$1._2()).config().compact;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$2._1();
            UnifiedLog log = (UnifiedLog)x0$2._2();
            return $this.inProgress().contains((Object)topicPartition) || $this.isUncleanablePartition(log, topicPartition);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$5(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.needCompactionNow() && ltc.cleanableBytes() > 0L || ltc.cleanableRatio() > ltc.log().config().minCleanableRatio;
    }

    public static final /* synthetic */ Option $anonfun$grabFilthiestCompactedLog$1(LogCleanerManager $this, Time time$1, PreCleanStats preCleanStats$1) {
        long now = time$1.milliseconds();
        $this.timeOfLastRun_$eq(now);
        scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.allCleanerCheckpoints();
        Iterable dirtyLogs = (Iterable)((IterableOps)((IterableOps)((IterableOps)$this.logs().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3($this, x0$2)))).map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$3._1();
                UnifiedLog log = (UnifiedLog)x0$3._2();
                try {
                    Option lastCleanOffset = lastClean.get((Object)topicPartition);
                    OffsetsToClean offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)lastCleanOffset, now);
                    if (offsetsToClean.forceUpdateCheckpoint()) {
                        $this.updateCheckpoints(log.parentDirFile(), (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)offsetsToClean.firstDirtyOffset()))), $this.updateCheckpoints$default$3());
                    }
                    long compactionDelayMs = LogCleanerManager$.MODULE$.maxCompactionDelay(log, offsetsToClean.firstDirtyOffset(), now);
                    preCleanStats$1.updateMaxCompactionDelay(compactionDelayMs);
                    return new LogToClean(topicPartition, log, offsetsToClean.firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset(), compactionDelayMs > 0L);
                }
                catch (Throwable e) {
                    throw new LogCleaningException(log, new StringBuilder(53).append("Failed to calculate log cleaning stats for partition ").append(topicPartition).toString(), e);
                }
            }
            throw new MatchError(null);
        })).filter((Function1 & Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$5(ltc)));
        $this.dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
        Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1 & Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
        if (cleanableLogs.isEmpty()) {
            return None$.MODULE$;
        }
        preCleanStats$1.recordCleanablePartitions(cleanableLogs.size());
        LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        $this.inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
        return new Some((Object)filthiest);
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            return !((UnifiedLog)x0$1._2()).config().compact;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$2._1();
            return $this.inProgress().contains((Object)topicPartition);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Iterable $anonfun$pauseCleaningForNonCompactedPartitions$1(LogCleanerManager $this) {
        Iterable deletableLogs = (Iterable)((IterableOps)$this.logs().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$2(x0$1)))).filterNot((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$3($this, x0$2)));
        deletableLogs.foreach((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$3._1();
                return $this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(1));
            }
            throw new MatchError(null);
        });
        return deletableLogs;
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            UnifiedLog log = (UnifiedLog)x0$1._2();
            return !$this.inProgress().contains((Object)topicPartition) && log.config().compact && !$this.isUncleanablePartition(log, topicPartition);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Iterable $anonfun$deletableLogs$1(LogCleanerManager $this) {
        Iterable toClean = (Iterable)$this.logs().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$2($this, x0$1)));
        toClean.foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition tp = (TopicPartition)x0$2._1();
                return $this.inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
            }
            throw new MatchError(null);
        });
        return toClean;
    }

    public static final /* synthetic */ void $anonfun$abortCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$1) {
        $this.abortAndPauseCleaning(topicPartition$1);
        $this.resumeCleaning((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition$1, (List)Nil$.MODULE$));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$abortAndPauseCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$2) {
        block7: {
            block6: {
                var2_2 = false;
                var3_3 = null;
                var4_4 = $this.inProgress().get((Object)topicPartition$2);
                if (!None$.MODULE$.equals(var4_4)) break block6;
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(1));
                break block7;
            }
            if (!(var4_4 instanceof Some)) ** GOTO lbl-1000
            var2_2 = true;
            var3_3 = (Some)var4_4;
            var5_5 = (LogCleaningState)var3_3.value();
            if (LogCleaningInProgress$.MODULE$.equals(var5_5)) {
                $this.inProgress().put((Object)topicPartition$2, (Object)LogCleaningAborted$.MODULE$);
            } else if (var2_2 && (var6_6 = (LogCleaningState)var3_3.value()) instanceof LogCleaningPaused) {
                count = ((LogCleaningPaused)var6_6).pausedCount();
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(count + 1));
            } else {
                if (var2_2) {
                    s = (LogCleaningState)var3_3.value();
                    throw new IllegalStateException(new StringBuilder(77).append("Compaction for partition ").append(topicPartition$2).append(" cannot be aborted and paused since it is in ").append(s).append(" state.").toString());
                }
                throw new MatchError((Object)var4_4);
            }
        }
        while (!$this.isCleaningInStatePaused(topicPartition$2)) {
            $this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
        }
    }

    public static final /* synthetic */ void $anonfun$checkCleaningAborted$1(LogCleanerManager $this, TopicPartition topicPartition$3) {
        if ($this.isCleaningInState(topicPartition$3, LogCleaningAborted$.MODULE$)) {
            throw new LogCleaningAbortedException();
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateCheckpoints$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            return $this.logs().keys().contains((Object)tp);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$updateCheckpoints$1(LogCleanerManager $this, File dataDir$1, Option partitionToRemove$1, Option partitionToUpdateOrAdd$1) {
        OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)$this.checkpoints().apply((Object)dataDir$1);
        if (checkpoint != null) {
            try {
                scala.collection.immutable.Map map;
                scala.collection.immutable.Map map2;
                scala.collection.immutable.Map currentCheckpoint = ((IterableOnceOps)checkpoint.read().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$updateCheckpoints$2($this, x0$1)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                if (partitionToRemove$1 instanceof Some) {
                    TopicPartition topicPartition = (TopicPartition)((Some)partitionToRemove$1).value();
                    map2 = (scala.collection.immutable.Map)currentCheckpoint.$minus((Object)topicPartition);
                } else if (None$.MODULE$.equals(partitionToRemove$1)) {
                    map2 = currentCheckpoint;
                } else {
                    throw new MatchError((Object)partitionToRemove$1);
                }
                scala.collection.immutable.Map updatedCheckpoint = map2;
                if (partitionToUpdateOrAdd$1 instanceof Some) {
                    Tuple2 updatedOffset = (Tuple2)((Some)partitionToUpdateOrAdd$1).value();
                    map = (scala.collection.immutable.Map)updatedCheckpoint.$plus(updatedOffset);
                } else if (None$.MODULE$.equals(partitionToUpdateOrAdd$1)) {
                    map = updatedCheckpoint;
                } else {
                    throw new MatchError((Object)partitionToUpdateOrAdd$1);
                }
                updatedCheckpoint = map;
                checkpoint.write((Map<TopicPartition, Object>)updatedCheckpoint);
                return;
            }
            catch (KafkaStorageException e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$alterCheckpointDir$1(LogCleanerManager $this, File sourceLogDir$1, TopicPartition topicPartition$4, File destLogDir$1) {
        try {
            Option option = $this.checkpoints().get((Object)sourceLogDir$1).flatMap((Function1 & Serializable)x$2 -> x$2.read().get((Object)topicPartition$4));
            if (option instanceof Some) {
                long offset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Removing the partition offset data in checkpoint file for '").append(topicPartition$4).append("' ").append("from ").append(sourceLogDir$1.getAbsoluteFile()).append(" directory.").toString());
                Option x$22 = Option$.MODULE$.apply((Object)topicPartition$4);
                Option<Tuple2<TopicPartition, Object>> x$3 = $this.updateCheckpoints$default$2();
                $this.updateCheckpoints(sourceLogDir$1, x$3, (Option<TopicPartition>)x$22);
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("Adding the partition offset data in checkpoint file for '").append(topicPartition$4).append("' ").append("to ").append(destLogDir$1.getAbsoluteFile()).append(" directory.").toString());
                $this.updateCheckpoints(destLogDir$1, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition$4, (Object)BoxesRunTime.boxToLong((long)offset))), $this.updateCheckpoints$default$3());
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError((Object)option);
            }
        }
        catch (KafkaStorageException e) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Failed to access checkpoint file in dir ").append(sourceLogDir$1.getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
        }
        Set logUncleanablePartitions = (Set)$this.uncleanablePartitions().getOrElse((Object)sourceLogDir$1.toString(), (Function0 & Serializable)() -> (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$));
        if (logUncleanablePartitions.contains((Object)topicPartition$4)) {
            logUncleanablePartitions.remove((Object)topicPartition$4);
            $this.markPartitionUncleanable(destLogDir$1.toString(), topicPartition$4);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$handleLogDirFailure$3(String dir$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((File)x0$1._1()).getAbsolutePath();
            return string == null ? dir$3 != null : !string.equals(dir$3);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeTruncateCheckpoint$1(LogCleanerManager $this, TopicPartition topicPartition$5, File dataDir$2, long offset$1) {
        if ($this.logs().get((TopicPartition)topicPartition$5).config().compact) {
            OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)$this.checkpoints().apply((Object)dataDir$2);
            if (checkpoint != null) {
                Map<TopicPartition, Object> existing = checkpoint.read();
                if (BoxesRunTime.unboxToLong((Object)existing.getOrElse((Object)topicPartition$5, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) > offset$1) {
                    checkpoint.write((Map<TopicPartition, Object>)((Map)((Growable)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)).$plus$plus$eq(existing).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$5), (Object)BoxesRunTime.boxToLong((long)offset$1)))));
                    return;
                }
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ Object $anonfun$doneCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$6, File dataDir$3, long endOffset$1) {
        LogCleaningState logCleaningState;
        boolean bl = false;
        Some some = null;
        Option option = $this.inProgress().get((Object)topicPartition$6);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
            if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                $this.updateCheckpoints(dataDir$3, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition$6, (Object)BoxesRunTime.boxToLong((long)endOffset$1))), $this.updateCheckpoints$default$3());
                return $this.inProgress().remove((Object)topicPartition$6);
            }
        }
        if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
            $this.inProgress().put((Object)topicPartition$6, (Object)new LogCleaningPaused(1));
            $this.pausedCleaningCond().signalAll();
            return BoxedUnit.UNIT;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition$6).append(" should exist.").toString());
        }
        throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition$6).append(" cannot be in ").append(option).append(" state.").toString());
    }

    public static final /* synthetic */ void $anonfun$uncleanablePartitions$1(LogCleanerManager $this, ObjectRef partitions$1, String logDir$1) {
        partitions$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)partitions$1.elem).$plus$plus((IterableOnce)$this.uncleanablePartitions().getOrElse((Object)logDir$1, (Function0 & Serializable)() -> (scala.collection.immutable.Set)partitions$1.elem));
    }

    public static final /* synthetic */ Object $anonfun$markPartitionUncleanable$1(LogCleanerManager $this, String logDir$2, TopicPartition partition$1) {
        Option option = $this.uncleanablePartitions().get((Object)logDir$2);
        if (option instanceof Some) {
            return BoxesRunTime.boxToBoolean((boolean)((Set)((Some)option).value()).add((Object)partition$1));
        }
        if (None$.MODULE$.equals(option)) {
            return $this.uncleanablePartitions().put((Object)logDir$2, Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition$1})));
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$isUncleanablePartition$1(LogCleanerManager $this, UnifiedLog log$1, TopicPartition topicPartition$7) {
        return $this.uncleanablePartitions().get((Object)log$1.parentDir()).exists((Function1 & Serializable)partitions -> BoxesRunTime.boxToBoolean((boolean)partitions.contains((Object)topicPartition$7)));
    }

    public static final /* synthetic */ boolean $anonfun$maintainUncleanablePartitions$3(LogCleanerManager $this, TopicPartition id) {
        return $this.logs().contains(id);
    }

    public static final /* synthetic */ void $anonfun$maintainUncleanablePartitions$2(LogCleanerManager $this, Set partitions) {
        ((IterableOnceOps)partitions.filterNot((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$maintainUncleanablePartitions$3($this, id)))).toList().foreach((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitions.remove((Object)elem)));
    }

    public static final /* synthetic */ boolean $anonfun$maintainUncleanablePartitions$5(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((Set)x0$1._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maintainUncleanablePartitions$1(LogCleanerManager $this) {
        $this.uncleanablePartitions().values().foreach((Function1 & Serializable)partitions -> {
            LogCleanerManager.$anonfun$maintainUncleanablePartitions$2($this, partitions);
            return BoxedUnit.UNIT;
        });
        ((MapOps)$this.uncleanablePartitions().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$maintainUncleanablePartitions$5(x0$1)))).keys().toList().foreach((Function1 & Serializable)key -> $this.uncleanablePartitions().remove(key));
    }

    public LogCleanerManager(Seq<File> logDirs, Pool<TopicPartition, UnifiedLog> logs, LogDirFailureChannel logDirFailureChannel) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = ((IterableOnceOps)logDirs.map((Function1 & Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpointFile(new File((File)dir, this.offsetCheckpointFile()), this.logDirFailureChannel())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.inProgress = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.uncleanablePartitions = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.pausedCleaningCond = this.lock().newCondition();
        logDirs.foreach((Function1 & Serializable)dir -> this.metricsGroup().newGauge("uncleanable-partitions-count", (Gauge)new Gauge<Object>(this, dir){
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dir$1;

            public final int value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$2(this.dir$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$1 = dir$1;
            }
        }, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())}))).asJava()));
        logDirs.foreach((Function1 & Serializable)dir -> this.metricsGroup().newGauge("uncleanable-bytes", (Gauge)new Gauge<Object>(this, dir){
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dir$2;

            public final long value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$7(this.dir$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$2 = dir$2;
            }
        }, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())}))).asJava()));
        this.dirtiestLogCleanableRatio = 0.0;
        this.metricsGroup().newGauge("max-dirty-percent", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$12();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.timeOfLastRun = Time.SYSTEM.milliseconds();
        this.metricsGroup().newGauge("time-since-last-run-ms", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$13();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

