/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.EndPoint;
import kafka.server.BrokerLifecycleManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MockBrokerToControllerChannelManager;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatResponse;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Timeout(value=12L)
@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBQ!\u000f\u0001\u0005\u0002i2Aa\u0011\u0001\u0001\t\")Qg\u0001C\u0001\u0011\"91j\u0001b\u0001\n\u0003a\u0005B\u00021\u0004A\u0003%Q\nC\u0003b\u0007\u0011\u0005!\rC\u0003j\u0007\u0011\u0005!\u000eC\u0003t\u0007\u0011\u0005A\u000fC\u0004\u0002\u0002\r!\t%a\u0001\u0007\r\u0005-\u0001\u0001AA\u0007\u0011%\tya\u0003B\u0001B\u0003%1\b\u0003\u00046\u0017\u0011\u0005\u0011\u0011\u0003\u0005\n\u0003/Y!\u0019!C\u0001\u00033A\u0001\"!\t\fA\u0003%\u00111\u0004\u0005\n\u0003GY!\u0019!C\u0001\u0003KA\u0001\"a\r\fA\u0003%\u0011q\u0005\u0005\n\u0003kY!\u0019!C\u0001\u0003oA\u0001\"a\u0010\fA\u0003%\u0011\u0011\b\u0005\n\u0003\u0003Z!\u0019!C\u0001\u0003\u0007B\u0001\"!\u0015\fA\u0003%\u0011Q\t\u0005\n\u0003'Z!\u0019!C\u0001\u0003+B\u0001\"!\u0018\fA\u0003%\u0011q\u000b\u0005\n\u0003?Z!\u0019!C\u0001\u0003CBq!a\u0019\fA\u0003%\u0011\nC\u0005\u0002f-\u0011\r\u0011\"\u0001\u0002h!A\u0011qN\u0006!\u0002\u0013\tI\u0007C\u0005\u0002r-\u0011\r\u0011\"\u0001\u0002t!A\u00111P\u0006!\u0002\u0013\t)\bC\u0005\u0002~-\u0011\r\u0011\"\u0001\u0002\u0000!A\u00111R\u0006!\u0002\u0013\t\t\tC\u0005\u0002\u000e.\u0011\r\u0011\"\u0001\u0002\u0010\"A\u0011qW\u0006!\u0002\u0013\t\t\nC\u0004\u0002:.!\t!a/\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002<\"9\u00111\u001c\u0001\u0005\u0002\u0005m\u0006bBAp\u0001\u0011\u0005\u00111\u0018\u0005\b\u0003G\u0004A\u0011AA^\u0011\u001d\t9\u000f\u0001C\u0001\u0003w\u0013!D\u0011:pW\u0016\u0014H*\u001b4fGf\u001cG.Z'b]\u0006<WM\u001d+fgRT!AK\u0016\u0002\rM,'O^3s\u0015\u0005a\u0013!B6bM.\f7\u0001A\n\u0003\u0001=\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00018!\tA\u0004!D\u0001*\u0003A\u0019wN\u001c4jOB\u0013x\u000e]3si&,7/F\u0001<!\ta\u0014)D\u0001>\u0015\tqt(\u0001\u0003vi&d'\"\u0001!\u0002\t)\fg/Y\u0005\u0003\u0005v\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0005q\u0019\u0016.\u001c9mK\u000e{g\u000e\u001e:pY2,'OT8eKB\u0013xN^5eKJ\u001c2aA\u0018F!\tAd)\u0003\u0002HS\t12i\u001c8ue>dG.\u001a:O_\u0012,\u0007K]8wS\u0012,'\u000fF\u0001J!\tQ5!D\u0001\u0001\u0003\u0011qw\u000eZ3\u0016\u00035\u00032AT*V\u001b\u0005y%B\u0001)R\u0003\u0019\tGo\\7jG*\u0011!+P\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001+P\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007C\u0001,_\u001b\u00059&B\u0001-Z\u0003\u0019\u0019w.\\7p]*\u0011AF\u0017\u0006\u00037r\u000ba!\u00199bG\",'\"A/\u0002\u0007=\u0014x-\u0003\u0002`/\n!aj\u001c3f\u0003\u0015qw\u000eZ3!\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f+\u0005\u0019\u0007C\u00013h\u001b\u0005)'B\u00014X\u0003\u001dqW\r^<pe.L!\u0001[3\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>dW#A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017\u0001B1vi\"T!\u0001],\u0002\u0011M,7-\u001e:jifL!A]7\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0017!D:bg2lUm\u00195b]&\u001cX.F\u0001v!\t1XP\u0004\u0002xwB\u0011\u00010M\u0007\u0002s*\u0011!0L\u0001\u0007yI|w\u000e\u001e \n\u0005q\f\u0014A\u0002)sK\u0012,g-\u0003\u0002\u007f\u007f\n11\u000b\u001e:j]\u001eT!\u0001`\u0019\u0002#\u001d,GoQ8oiJ|G\u000e\\3s\u0013:4w\u000e\u0006\u0002\u0002\u0006A\u0019\u0001(a\u0002\n\u0007\u0005%\u0011FA\u000bD_:$(o\u001c7mKJLeNZ8s[\u0006$\u0018n\u001c8\u0003C\t\u0013xn[3s\u0019&4WmY=dY\u0016l\u0015M\\1hKJ$Vm\u001d;D_:$X\r\u001f;\u0014\u0005-y\u0013A\u00039s_B,'\u000f^5fgR!\u00111CA\u000b!\tQ5\u0002\u0003\u0004\u0002\u00105\u0001\raO\u0001\u0007G>tg-[4\u0016\u0005\u0005m\u0001c\u0001\u001d\u0002\u001e%\u0019\u0011qD\u0015\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u000552&A\u0003vi&d7/\u0003\u0003\u00022\u0005-\"\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002+!Lw\r[3ti6+G/\u00193bi\u0006|eMZ:fiV\u0011\u0011\u0011\b\t\u0004\u001d\u0006m\u0012bAA\u001f\u001f\nQ\u0011\t^8nS\u000eduN\\4\u0002-!Lw\r[3ti6+G/\u00193bi\u0006|eMZ:fi\u0002\n\u0001\"\\3uC\u0012\fG/Y\u000b\u0003\u0003\u000b\u0002B!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0004\u0003\u0017J\u0016aB2mS\u0016tGo]\u0005\u0005\u0003\u001f\nIE\u0001\u0005NKR\fG-\u0019;b\u0003%iW\r^1eCR\f\u0007%\u0001\u0006n_\u000e\\7\t\\5f]R,\"!a\u0016\u0011\t\u0005\u001d\u0013\u0011L\u0005\u0005\u00037\nIE\u0001\u0006N_\u000e\\7\t\\5f]R\f1\"\\8dW\u000ec\u0017.\u001a8uA\u000512m\u001c8ue>dG.\u001a:O_\u0012,\u0007K]8wS\u0012,'/F\u0001J\u0003]\u0019wN\u001c;s_2dWM\u001d(pI\u0016\u0004&o\u001c<jI\u0016\u0014\b%A\bo_\u0012,\u0017\t]5WKJ\u001c\u0018n\u001c8t+\t\tI\u0007\u0005\u0003\u0002H\u0005-\u0014\u0002BA7\u0003\u0013\u0012qBT8eK\u0006\u0003\u0018NV3sg&|gn]\u0001\u0011]>$W-\u00119j-\u0016\u00148/[8og\u0002\n!#\\8dW\u000eC\u0017M\u001c8fY6\u000bg.Y4feV\u0011\u0011Q\u000f\t\u0004q\u0005]\u0014bAA=S\t!Sj\\2l\u0005J|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'/A\nn_\u000e\\7\t[1o]\u0016dW*\u00198bO\u0016\u0014\b%A\u0005dYV\u001cH/\u001a:JIV\u0011\u0011\u0011\u0011\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*\u0019\u0011qQ \u0002\t1\fgnZ\u0005\u0004}\u0006\u0015\u0015AC2mkN$XM]%eA\u0005\u0019\u0012\r\u001a<feRL7/\u001a3MSN$XM\\3sgV\u0011\u0011\u0011\u0013\t\u0005\u0003'\u000b\tL\u0004\u0003\u0002\u0016\u0006-f\u0002BAL\u0003OsA!!'\u0002&:!\u00111TAR\u001d\u0011\ti*!)\u000f\u0007a\fy*C\u0001^\u0013\tYF,\u0003\u0002-5&\u0011\u0001,W\u0005\u0004\u0003S;\u0016aB7fgN\fw-Z\u0005\u0005\u0003[\u000by+A\u000fCe>\\WM\u001d*fO&\u001cHO]1uS>t'+Z9vKN$H)\u0019;b\u0015\r\tIkV\u0005\u0005\u0003g\u000b)L\u0001\nMSN$XM\\3s\u0007>dG.Z2uS>t'\u0002BAW\u0003_\u000bA#\u00193wKJ$\u0018n]3e\u0019&\u001cH/\u001a8feN\u0004\u0013\u0001\u00029pY2$\"!!0\u0011\u0007A\ny,C\u0002\u0002BF\u0012A!\u00168ji\u0006\u0011B/Z:u\u0007J,\u0017\r^3B]\u0012\u001cEn\\:fQ\r\u0019\u0013q\u0019\t\u0005\u0003\u0013\f9.\u0004\u0002\u0002L*!\u0011QZAh\u0003\r\t\u0007/\u001b\u0006\u0005\u0003#\f\u0019.A\u0004kkBLG/\u001a:\u000b\u0007\u0005UG,A\u0003kk:LG/\u0003\u0003\u0002Z\u0006-'\u0001\u0002+fgR\fq\u0003^3ti\u000e\u0013X-\u0019;f'R\f'\u000f^!oI\u000ecwn]3)\u0007\u0011\n9-\u0001\u000euKN$8+^2dKN\u001ch-\u001e7SK\u001eL7\u000f\u001e:bi&|g\u000eK\u0002&\u0003\u000f\fq\u0003^3tiJ+w-[:ue\u0006$\u0018n\u001c8US6,w.\u001e;)\u0007\u0019\n9-\u0001\fuKN$8i\u001c8ue>dG.\u001a3TQV$Hm\\<oQ\r9\u0013q\u0019\u0015\b\u0001\u00055\u00181_A{!\u0011\tI-a<\n\t\u0005E\u00181\u001a\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\u0005a\u0001")
public class BrokerLifecycleManagerTest {
    public Properties configProperties() {
        Properties properties = new Properties();
        properties.setProperty(KafkaConfig$.MODULE$.LogDirsProp(), "/tmp/foo");
        properties.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        properties.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "2@localhost:9093");
        properties.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        properties.setProperty(KafkaConfig$.MODULE$.InitialBrokerRegistrationTimeoutMsProp(), "300000");
        return properties;
    }

    @Test
    public void testCreateAndClose() {
        BrokerLifecycleManagerTestContext context = new BrokerLifecycleManagerTestContext(this.configProperties());
        new BrokerLifecycleManager(context.config(), (Time)context.time(), "create-and-close-", false).close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateStartAndClose() {
        BrokerLifecycleManagerTestContext context = new BrokerLifecycleManagerTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "create-start-and-close-", false);
        Assertions.assertEquals((Object)BrokerState.NOT_RUNNING, (Object)manager.state());
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (BrokerToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap());
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testCreateStartAndClose$2(manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var9_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var3_4 = null;
        Object var8_8 = null;
        manager.close();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)manager.state());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulRegistration() {
        BrokerLifecycleManagerTestContext context = new BrokerLifecycleManagerTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "successful-registration-", false);
        Node controllerNode = new Node(3000, "localhost", 8021);
        context.controllerNodeProvider().node().set(controllerNode);
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)), controllerNode);
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (BrokerToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap());
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testSuccessfulRegistration$2(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var10_10 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var4_5 = null;
        Object var9_9 = null;
        manager.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRegistrationTimeout() {
        BrokerLifecycleManagerTestContext context = new BrokerLifecycleManagerTestContext(this.configProperties());
        Node controllerNode = new Node(3000, "localhost", 8021);
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "registration-timeout-", false);
        context.controllerNodeProvider().node().set(controllerNode);
        BrokerLifecycleManagerTest.newDuplicateRegistrationResponse$1(context, controllerNode);
        Assertions.assertEquals((int)1, (int)context.mockClient().futureResponses().size());
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (BrokerToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap());
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$2(context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var22_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var4_5 = null;
        Object var9_10 = null;
        BrokerLifecycleManagerTest.newDuplicateRegistrationResponse$1(context, controllerNode);
        long l3 = 60000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$3(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var23_17 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var10_12 = null;
        Object var15_16 = null;
        context.time().sleep(300000L);
        long l5 = 60000L;
        TestUtils$ retry_this3 = TestUtils$.MODULE$;
        long l6 = 1L;
        long retry_startTime3 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$4(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this3.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l6).append(", and then retrying.").toString();
                    Object var24_24 = null;
                    retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l6);
                l6 += package$.MODULE$.min(l6, 1000L);
                continue;
            }
            break;
        }
        Object var16_19 = null;
        Object var21_23 = null;
        manager.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControlledShutdown() {
        BrokerLifecycleManagerTestContext context = new BrokerLifecycleManagerTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "controlled-shutdown-", false);
        Node controllerNode = new Node(3000, "localhost", 8021);
        context.controllerNodeProvider().node().set(controllerNode);
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)), controllerNode);
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setIsCaughtUp(true)), controllerNode);
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (BrokerToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap());
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$2(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var28_10 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var4_5 = null;
        Object var9_9 = null;
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setIsFenced(false)), controllerNode);
        context.time().sleep(20L);
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$3(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var29_17 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var10_12 = null;
        Object var15_16 = null;
        manager.beginControlledShutdown();
        long l5 = 10000L;
        TestUtils$ retry_this3 = TestUtils$.MODULE$;
        long l6 = 1L;
        long retry_startTime3 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$4(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this3.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l6).append(", and then retrying.").toString();
                    Object var30_24 = null;
                    retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l6);
                l6 += package$.MODULE$.min(l6, 1000L);
                continue;
            }
            break;
        }
        Object var16_19 = null;
        Object var21_23 = null;
        context.mockClient().respond(body -> {
            if (body instanceof BrokerHeartbeatRequest) {
                Assertions.assertTrue((boolean)((BrokerHeartbeatRequest)body).data().wantShutDown());
                return true;
            }
            return false;
        }, (AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setShouldShutDown(true)));
        long l7 = 10000L;
        TestUtils$ retry_this4 = TestUtils$.MODULE$;
        long l8 = 1L;
        long retry_startTime4 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$6(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime4 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this4.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l8).append(", and then retrying.").toString();
                    Object var31_31 = null;
                    retry_this4.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this4, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l8);
                l8 += package$.MODULE$.min(l8, 1000L);
                continue;
            }
            break;
        }
        Object var22_26 = null;
        Object var27_30 = null;
        manager.controlledShutdownFuture().get();
        manager.close();
    }

    public static final /* synthetic */ void $anonfun$testCreateStartAndClose$2(BrokerLifecycleManager manager$1) {
        Assertions.assertEquals((Object)BrokerState.STARTING, (Object)manager$1.state());
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulRegistration$2(BrokerLifecycleManagerTestContext context$2, BrokerLifecycleManager manager$2) {
        context$2.poll();
        Assertions.assertEquals((long)1000L, (long)manager$2.brokerEpoch());
    }

    private static final void newDuplicateRegistrationResponse$1(BrokerLifecycleManagerTestContext context$3, Node controllerNode$1) {
        context$3.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setErrorCode(Errors.DUPLICATE_BROKER_REGISTRATION.code())), controllerNode$1);
        context$3.mockChannelManager().poll();
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$2(BrokerLifecycleManagerTestContext context$3) {
        context$3.poll();
        Assertions.assertEquals((int)0, (int)context$3.mockClient().futureResponses().size());
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$3(BrokerLifecycleManagerTestContext context$3, BrokerLifecycleManager manager$3) {
        context$3.time().sleep(100L);
        context$3.poll();
        manager$3.eventQueue().wakeup();
        Assertions.assertEquals((int)0, (int)context$3.mockClient().futureResponses().size());
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$4(BrokerLifecycleManagerTestContext context$3, BrokerLifecycleManager manager$3) {
        context$3.poll();
        manager$3.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)manager$3.state());
        Assertions.assertTrue((boolean)manager$3.initialCatchUpFuture().isCompletedExceptionally());
        Assertions.assertEquals((long)-1L, (long)manager$3.brokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$2(BrokerLifecycleManagerTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.RECOVERY, (Object)manager$4.state());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$3(BrokerLifecycleManagerTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)manager$4.state());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$4(BrokerLifecycleManagerTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.PENDING_CONTROLLED_SHUTDOWN, (Object)manager$4.state());
        Assertions.assertTrue((boolean)context$4.mockClient().hasInFlightRequests());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$6(BrokerLifecycleManagerTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)manager$4.state());
    }

    public class BrokerLifecycleManagerTestContext {
        private final KafkaConfig config;
        private final MockTime time;
        private final AtomicLong highestMetadataOffset;
        private final Metadata metadata;
        private final MockClient mockClient;
        private final SimpleControllerNodeProvider controllerNodeProvider;
        private final NodeApiVersions nodeApiVersions;
        private final MockBrokerToControllerChannelManager mockChannelManager;
        private final String clusterId;
        private final BrokerRegistrationRequestData.ListenerCollection advertisedListeners;

        public KafkaConfig config() {
            return this.config;
        }

        public MockTime time() {
            return this.time;
        }

        public AtomicLong highestMetadataOffset() {
            return this.highestMetadataOffset;
        }

        public Metadata metadata() {
            return this.metadata;
        }

        public MockClient mockClient() {
            return this.mockClient;
        }

        public SimpleControllerNodeProvider controllerNodeProvider() {
            return this.controllerNodeProvider;
        }

        public NodeApiVersions nodeApiVersions() {
            return this.nodeApiVersions;
        }

        public MockBrokerToControllerChannelManager mockChannelManager() {
            return this.mockChannelManager;
        }

        public String clusterId() {
            return this.clusterId;
        }

        public BrokerRegistrationRequestData.ListenerCollection advertisedListeners() {
            return this.advertisedListeners;
        }

        public void poll() {
            this.mockClient().wakeup();
            this.mockChannelManager().poll();
        }

        public /* synthetic */ BrokerLifecycleManagerTest kafka$server$BrokerLifecycleManagerTest$BrokerLifecycleManagerTestContext$$$outer() {
            return BrokerLifecycleManagerTest.this;
        }

        public static final /* synthetic */ boolean $anonfun$new$1(BrokerLifecycleManagerTestContext $this, EndPoint ep) {
            return $this.advertisedListeners().add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Listener().setHost(ep.host()).setName(ep.listenerName().value()).setPort((int)((short)ep.port())).setSecurityProtocol(ep.securityProtocol().id));
        }

        public BrokerLifecycleManagerTestContext(Properties properties) {
            if (BrokerLifecycleManagerTest.this == null) {
                throw null;
            }
            this.config = new KafkaConfig((Map)properties);
            this.time = new MockTime(1L, 1L);
            this.highestMetadataOffset = new AtomicLong(0L);
            this.metadata = new Metadata(1000L, 1000L, new LogContext(), new ClusterResourceListeners());
            this.mockClient = new MockClient((Time)this.time(), this.metadata());
            this.controllerNodeProvider = new SimpleControllerNodeProvider();
            this.nodeApiVersions = NodeApiVersions.create((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)new .colon.colon((Object)ApiKeys.BROKER_REGISTRATION, (List)new .colon.colon((Object)ApiKeys.BROKER_HEARTBEAT, (List)Nil$.MODULE$)).map((Function1 & Serializable)apiKey -> new ApiVersionsResponseData.ApiVersion().setApiKey(apiKey.id).setMinVersion(apiKey.oldestVersion()).setMaxVersion(apiKey.latestVersion()))).toList()).asJava());
            this.mockChannelManager = new MockBrokerToControllerChannelManager(this.mockClient(), this.time(), this.controllerNodeProvider(), this.nodeApiVersions(), 60000, 30000);
            this.clusterId = "x4AJGXQSRnephtTZzujw4w";
            this.advertisedListeners = new BrokerRegistrationRequestData.ListenerCollection();
            this.config().effectiveAdvertisedListeners().foreach((Function1 & Serializable)ep -> BoxesRunTime.boxToBoolean((boolean)BrokerLifecycleManagerTestContext.$anonfun$new$1(this, ep)));
        }
    }

    public class SimpleControllerNodeProvider
    implements ControllerNodeProvider {
        private final AtomicReference<Node> node;

        public AtomicReference<Node> node() {
            return this.node;
        }

        public ListenerName listenerName() {
            return new ListenerName("PLAINTEXT");
        }

        public SecurityProtocol securityProtocol() {
            return SecurityProtocol.PLAINTEXT;
        }

        public String saslMechanism() {
            return "GSSAPI";
        }

        public ControllerInformation getControllerInfo() {
            return new ControllerInformation(Option$.MODULE$.apply((Object)this.node().get()), this.listenerName(), this.securityProtocol(), this.saslMechanism(), false);
        }

        public /* synthetic */ BrokerLifecycleManagerTest kafka$server$BrokerLifecycleManagerTest$SimpleControllerNodeProvider$$$outer() {
            return BrokerLifecycleManagerTest.this;
        }

        public SimpleControllerNodeProvider() {
            if (BrokerLifecycleManagerTest.this == null) {
                throw null;
            }
            this.node = new AtomicReference<Object>(null);
        }
    }
}

