/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSpec;
import kafka.admin.ConsumerGroupCommand;
import kafka.utils.Logging;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ConsumerGroupCommand$
implements Logging {
    public static final ConsumerGroupCommand$ MODULE$ = new ConsumerGroupCommand$();
    private static final String MISSING_COLUMN_VALUE = "-";
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(args);
        try {
            opts.checkArgs();
            CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)opts, (String)"This tool helps to list all consumer groups, describe a consumer group, delete consumer group info, or reset consumer group offsets.");
            if (new .colon.colon((Object)opts.listOpt(), (List)new .colon.colon((Object)opts.describeOpt(), (List)new .colon.colon((Object)opts.deleteOpt(), (List)new .colon.colon((Object)opts.resetOffsetsOpt(), (List)new .colon.colon((Object)opts.deleteOffsetsOpt(), (List)Nil$.MODULE$))))).count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)opts.options.has(x$1))) != 1) {
                CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)"Command must include exactly one action: --list, --describe, --delete, --reset-offsets, --delete-offsets");
            }
            this.run(opts);
            return;
        }
        catch (OptionException e) {
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)e.getMessage());
            return;
        }
    }

    public void run(ConsumerGroupCommand.ConsumerGroupCommandOptions opts) {
        try (ConsumerGroupCommand.ConsumerGroupService consumerGroupService = new ConsumerGroupCommand.ConsumerGroupService(opts, (Map<String, String>)((Map)Map$.MODULE$.empty()));){
            try {
                if (opts.options.has((OptionSpec)opts.listOpt())) {
                    consumerGroupService.listGroups();
                } else if (opts.options.has((OptionSpec)opts.describeOpt())) {
                    consumerGroupService.describeGroups();
                } else if (opts.options.has((OptionSpec)opts.deleteOpt())) {
                    consumerGroupService.deleteGroups();
                } else if (opts.options.has((OptionSpec)opts.resetOffsetsOpt())) {
                    Map<String, Map<TopicPartition, OffsetAndMetadata>> offsetsToReset = consumerGroupService.resetOffsets();
                    if (opts.options.has((OptionSpec)opts.exportOpt())) {
                        String exported = consumerGroupService.exportOffsetsToCsv(offsetsToReset);
                        Predef$.MODULE$.println((Object)exported);
                    } else {
                        this.printOffsetsToReset(offsetsToReset);
                    }
                } else if (opts.options.has((OptionSpec)opts.deleteOffsetsOpt())) {
                    consumerGroupService.deleteOffsets();
                }
            }
            catch (IllegalArgumentException e) {
                CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)e.getMessage());
            }
            catch (Throwable e) {
                this.printError(new StringBuilder(47).append("Executing consumer group command failed due to ").append(e.getMessage()).toString(), (Option<Throwable>)new Some((Object)e));
            }
        }
    }

    public Set<ConsumerGroupState> consumerGroupStatesFromString(String input) {
        Set parsedStates = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(input), ',')), (Function1 & Serializable)s -> ConsumerGroupState.parse((String)s.trim()), ClassTag$.MODULE$.apply(ConsumerGroupState.class))).toSet();
        if (parsedStates.contains((Object)ConsumerGroupState.UNKNOWN)) {
            Object[] validStates = (ConsumerGroupState[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ConsumerGroupState.values()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConsumerGroupCommand$.$anonfun$consumerGroupStatesFromString$2(x$1)));
            throw new IllegalArgumentException(new StringBuilder(41).append("Invalid state list '").append(input).append("'. Valid states are: ").append(Predef$.MODULE$.wrapRefArray(validStates).mkString(", ")).toString());
        }
        return parsedStates;
    }

    public String MISSING_COLUMN_VALUE() {
        return MISSING_COLUMN_VALUE;
    }

    public void printError(String msg, Option<Throwable> e) {
        Predef$.MODULE$.println((Object)new StringBuilder(8).append("\nError: ").append(msg).toString());
        e.foreach((Function1 & Serializable)x$2 -> {
            x$2.printStackTrace();
            return BoxedUnit.UNIT;
        });
    }

    public Option<Throwable> printError$default$2() {
        return None$.MODULE$;
    }

    public void printOffsetsToReset(Map<String, Map<TopicPartition, OffsetAndMetadata>> groupAssignmentsToReset) {
        if (groupAssignmentsToReset.nonEmpty()) {
            Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\n%-30s %-30s %-10s %-15s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"GROUP", "TOPIC", "PARTITION", "NEW-OFFSET"})));
        }
        groupAssignmentsToReset.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ConsumerGroupCommand$.$anonfun$printOffsetsToReset$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$4 -> {
            ConsumerGroupCommand$.$anonfun$printOffsetsToReset$2(x$4);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$consumerGroupStatesFromString$2(ConsumerGroupState x$1) {
        ConsumerGroupState consumerGroupState = x$1;
        ConsumerGroupState consumerGroupState2 = ConsumerGroupState.UNKNOWN;
        return consumerGroupState == null ? consumerGroupState2 != null : !consumerGroupState.equals(consumerGroupState2);
    }

    public static final /* synthetic */ boolean $anonfun$printOffsetsToReset$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$printOffsetsToReset$3(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ void $anonfun$printOffsetsToReset$4(String groupId$1, Tuple2 x$3) {
        if (x$3 != null) {
            TopicPartition consumerAssignment = (TopicPartition)x$3._1();
            OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)x$3._2();
            Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%-30s %-30s %-10s %-15s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{groupId$1, consumerAssignment.topic(), BoxesRunTime.boxToInteger((int)consumerAssignment.partition()), BoxesRunTime.boxToLong((long)offsetAndMetadata.offset())})));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$printOffsetsToReset$2(Tuple2 x$4) {
        if (x$4 != null) {
            String groupId = (String)x$4._1();
            ((Map)x$4._2()).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ConsumerGroupCommand$.$anonfun$printOffsetsToReset$3(check$ifrefutable$2))).foreach((Function1 & Serializable)x$3 -> {
                ConsumerGroupCommand$.$anonfun$printOffsetsToReset$4(groupId, x$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    private ConsumerGroupCommand$() {
    }
}

