/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LogLoader;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogSegments$;
import kafka.log.SplitSegmentResult;
import kafka.log.UnifiedLog;
import kafka.log.remote.RemoteLogManager;
import kafka.server.BrokerTopicMetrics;
import kafka.server.BrokerTopicStats;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpoint;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpointFile;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CompletedTxn;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogValidator;
import org.apache.kafka.storage.internals.log.ProducerAppendInfo;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class UnifiedLog$
implements Logging {
    public static final UnifiedLog$ MODULE$ = new UnifiedLog$();
    private static final String LogFileSuffix = ".log";
    private static final String IndexFileSuffix = ".index";
    private static final String TimeIndexFileSuffix = ".timeindex";
    private static final String TxnIndexFileSuffix = ".txnindex";
    private static final String CleanedFileSuffix = LocalLog$.MODULE$.CleanedFileSuffix();
    private static final String SwapFileSuffix = LocalLog$.MODULE$.SwapFileSuffix();
    private static final String DeleteDirSuffix = LocalLog$.MODULE$.DeleteDirSuffix();
    private static final String FutureDirSuffix = LocalLog$.MODULE$.FutureDirSuffix();
    private static final Pattern DeleteDirPattern = LocalLog$.MODULE$.DeleteDirPattern();
    private static final Pattern FutureDirPattern = LocalLog$.MODULE$.FutureDirPattern();
    private static final long UnknownOffset = LocalLog$.MODULE$.UnknownOffset();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public boolean $lessinit$greater$default$9() {
        return false;
    }

    public Option<RemoteLogManager> $lessinit$greater$default$10() {
        return None$.MODULE$;
    }

    public LogOffsetsListener $lessinit$greater$default$11() {
        return LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
    }

    public String LogFileSuffix() {
        return LogFileSuffix;
    }

    public String IndexFileSuffix() {
        return IndexFileSuffix;
    }

    public String TimeIndexFileSuffix() {
        return TimeIndexFileSuffix;
    }

    public String TxnIndexFileSuffix() {
        return TxnIndexFileSuffix;
    }

    public String CleanedFileSuffix() {
        return CleanedFileSuffix;
    }

    public String SwapFileSuffix() {
        return SwapFileSuffix;
    }

    public String DeleteDirSuffix() {
        return DeleteDirSuffix;
    }

    public String FutureDirSuffix() {
        return FutureDirSuffix;
    }

    public Pattern DeleteDirPattern() {
        return DeleteDirPattern;
    }

    public Pattern FutureDirPattern() {
        return FutureDirPattern;
    }

    public long UnknownOffset() {
        return UnknownOffset;
    }

    public UnifiedLog apply(File dir, LogConfig config, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Time time, int maxTransactionTimeoutMs, ProducerStateManagerConfig producerStateManagerConfig, int producerIdExpirationCheckIntervalMs, LogDirFailureChannel logDirFailureChannel, boolean lastShutdownClean, Option<Uuid> topicId, boolean keepPartitionMetadataFile, ConcurrentMap<String, Object> numRemainingSegments, boolean remoteStorageSystemEnable, Option<RemoteLogManager> remoteLogManager, LogOffsetsListener logOffsetsListener) {
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        LogSegments segments = new LogSegments(topicPartition);
        Option<LeaderEpochFileCache> leaderEpochCache = this.maybeCreateLeaderEpochCache(dir, topicPartition, logDirFailureChannel, config.recordVersion(), new StringBuilder(30).append("[UnifiedLog partition=").append(topicPartition).append(", dir=").append(dir.getParent()).append("] ").toString());
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, dir, maxTransactionTimeoutMs, producerStateManagerConfig, time);
        LoadedLogOffsets offsets = new LogLoader(dir, topicPartition, config, scheduler, time, logDirFailureChannel, lastShutdownClean, segments, logStartOffset, recoveryPoint, leaderEpochCache, producerStateManager, numRemainingSegments).load();
        LocalLog localLog = new LocalLog(dir, config, segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel);
        return new UnifiedLog(offsets.logStartOffset, localLog, brokerTopicStats, producerIdExpirationCheckIntervalMs, leaderEpochCache, producerStateManager, topicId, keepPartitionMetadataFile, remoteStorageSystemEnable, remoteLogManager, logOffsetsListener);
    }

    public boolean apply$default$12() {
        return true;
    }

    public ConcurrentMap<String, Object> apply$default$15() {
        return new ConcurrentHashMap<String, Object>();
    }

    public boolean apply$default$16() {
        return false;
    }

    public Option<RemoteLogManager> apply$default$17() {
        return None$.MODULE$;
    }

    public LogOffsetsListener apply$default$18() {
        return LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
    }

    public File logFile(File dir, long offset, String suffix) {
        return LogFileUtils.logFile((File)dir, (long)offset, (String)suffix);
    }

    public String logFile$default$3() {
        return "";
    }

    public String logDeleteDirName(TopicPartition topicPartition) {
        return LocalLog$.MODULE$.logDeleteDirName(topicPartition);
    }

    public String logFutureDirName(TopicPartition topicPartition) {
        return LocalLog$.MODULE$.logFutureDirName(topicPartition);
    }

    public String logDirName(TopicPartition topicPartition) {
        return LocalLog$.MODULE$.logDirName(topicPartition);
    }

    public File offsetIndexFile(File dir, long offset, String suffix) {
        return LogFileUtils.offsetIndexFile((File)dir, (long)offset, (String)suffix);
    }

    public String offsetIndexFile$default$3() {
        return "";
    }

    public File timeIndexFile(File dir, long offset, String suffix) {
        return LogFileUtils.timeIndexFile((File)dir, (long)offset, (String)suffix);
    }

    public String timeIndexFile$default$3() {
        return "";
    }

    public void deleteFileIfExists(File file, String suffix) {
        Files.deleteIfExists(new File(new StringBuilder(0).append(file.getPath()).append(suffix).toString()).toPath());
    }

    public String deleteFileIfExists$default$2() {
        return "";
    }

    public File transactionIndexFile(File dir, long offset, String suffix) {
        return LogFileUtils.transactionIndexFile((File)dir, (long)offset, (String)suffix);
    }

    public String transactionIndexFile$default$3() {
        return "";
    }

    public long offsetFromFile(File file) {
        return Predef$.MODULE$.Long2long(LogFileUtils.offsetFromFile((File)file));
    }

    public long sizeInBytes(Iterable<LogSegment> segments) {
        return LogSegments$.MODULE$.sizeInBytes(segments);
    }

    public TopicPartition parseTopicPartitionName(File dir) {
        return LocalLog$.MODULE$.parseTopicPartitionName(dir);
    }

    public boolean isIndexFile(File file) {
        return LocalLog$.MODULE$.isIndexFile(file);
    }

    public boolean isLogFile(File file) {
        return LocalLog$.MODULE$.isLogFile(file);
    }

    private void loadProducersFromRecords(ProducerStateManager producerStateManager, Records records) {
        Map loadedProducers = (Map)Map$.MODULE$.empty();
        ListBuffer completedTxns = ListBuffer$.MODULE$.empty();
        records.batches().forEach(batch -> {
            if (batch.hasProducerId()) {
                MODULE$.kafka$log$UnifiedLog$$updateProducers(producerStateManager, (RecordBatch)batch, (Map<Object, ProducerAppendInfo>)loadedProducers, (Option<LogOffsetMetadata>)None$.MODULE$, AppendOrigin.REPLICATION).foreach((Function1 & Serializable)x$24 -> (ListBuffer)completedTxns.$plus$eq(x$24));
                return;
            }
        });
        loadedProducers.values().foreach((Function1 & Serializable)x$1 -> {
            producerStateManager.update(x$1);
            return BoxedUnit.UNIT;
        });
        completedTxns.foreach((Function1 & Serializable)x$1 -> {
            producerStateManager.completeTxn(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Option<CompletedTxn> kafka$log$UnifiedLog$$updateProducers(ProducerStateManager producerStateManager, RecordBatch batch, Map<Object, ProducerAppendInfo> producers, Option<LogOffsetMetadata> firstOffsetMetadata, AppendOrigin origin) {
        long producerId = batch.producerId();
        ProducerAppendInfo appendInfo = (ProducerAppendInfo)producers.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)producerId), (Function0 & Serializable)() -> producerStateManager.prepareUpdate(producerId, origin));
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(appendInfo.append(batch, OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(firstOffsetMetadata)))));
    }

    public Option<LeaderEpochFileCache> maybeCreateLeaderEpochCache(File dir, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel, RecordVersion recordVersion, String logPrefix) {
        File leaderEpochFile = new File(dir, "leader-epoch-checkpoint");
        if (recordVersion.precedes(RecordVersion.V2)) {
            if ((leaderEpochFile.exists() ? new Some((Object)UnifiedLog$.newLeaderEpochFileCache$1(leaderEpochFile, logDirFailureChannel, topicPartition)) : None$.MODULE$).exists((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)x$25.nonEmpty())) && this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = UnifiedLog$.$anonfun$maybeCreateLeaderEpochCache$2(logPrefix, recordVersion);
                Object var7_7 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            Files.deleteIfExists(leaderEpochFile.toPath());
            return None$.MODULE$;
        }
        return new Some((Object)UnifiedLog$.newLeaderEpochFileCache$1(leaderEpochFile, logDirFailureChannel, topicPartition));
    }

    public Iterable<LogSegment> replaceSegments(LogSegments existingSegments, Seq<LogSegment> newSegments, Seq<LogSegment> oldSegments, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix, boolean isRecoveredSwapFile) {
        return LocalLog$.MODULE$.replaceSegments(existingSegments, newSegments, oldSegments, dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix, isRecoveredSwapFile);
    }

    public boolean replaceSegments$default$10() {
        return false;
    }

    public void deleteSegmentFiles(scala.collection.immutable.Iterable<LogSegment> segmentsToDelete, boolean asyncDelete, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix) {
        LocalLog$.MODULE$.deleteSegmentFiles(segmentsToDelete, asyncDelete, dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix);
    }

    public void rebuildProducerState(ProducerStateManager producerStateManager, LogSegments segments, long logStartOffset, long lastOffset, RecordVersion recordVersion, Time time, boolean reloadFromCleanShutdown, String logPrefix) {
        .colon.colon offsetsToSnapshot;
        .colon.colon colon2;
        if (segments.nonEmpty()) {
            long lastSegmentBaseOffset = ((LogSegment)segments.lastSegment().get()).baseOffset();
            Option nextLatestSegmentBaseOffset = segments.lowerSegment(lastSegmentBaseOffset).map((Function1 & Serializable)x$26 -> BoxesRunTime.boxToLong((long)x$26.baseOffset()));
            colon2 = new .colon.colon((Object)nextLatestSegmentBaseOffset, (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToLong((long)lastSegmentBaseOffset)), (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToLong((long)lastOffset)), (List)Nil$.MODULE$)));
        } else {
            colon2 = offsetsToSnapshot = new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToLong((long)lastOffset)), (List)Nil$.MODULE$);
        }
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = UnifiedLog$.$anonfun$rebuildProducerState$2(logPrefix, lastOffset, recordVersion);
            Object var21_12 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        if (recordVersion.value < 2 || !producerStateManager.latestSnapshotOffset().isPresent() && reloadFromCleanShutdown) {
            ((IterableOnceOps)offsetsToSnapshot.flatten(Predef$.MODULE$.$conforms())).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)offset -> {
                producerStateManager.updateMapEndOffset(offset);
                producerStateManager.takeSnapshot();
            });
            return;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = UnifiedLog$.$anonfun$rebuildProducerState$4(logPrefix, lastOffset);
            Object var22_13 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        boolean isEmptyBeforeTruncation = producerStateManager.isEmpty() && producerStateManager.mapEndOffset() >= lastOffset;
        long producerStateLoadStart = time.milliseconds();
        producerStateManager.truncateAndReload(logStartOffset, lastOffset, time.milliseconds());
        long segmentRecoveryStart = time.milliseconds();
        if (lastOffset > producerStateManager.mapEndOffset() && !isEmptyBeforeTruncation) {
            Option<LogSegment> segmentOfLastOffset = segments.floorSegment(lastOffset);
            segments.values(producerStateManager.mapEndOffset(), lastOffset).foreach(arg_0 -> UnifiedLog$.$anonfun$rebuildProducerState$5$adapted(producerStateManager, logStartOffset, (Seq)offsetsToSnapshot, segmentOfLastOffset, lastOffset, arg_0));
        }
        producerStateManager.updateMapEndOffset(lastOffset);
        producerStateManager.takeSnapshot();
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = UnifiedLog$.$anonfun$rebuildProducerState$8(logPrefix, segmentRecoveryStart, producerStateLoadStart, time, lastOffset);
            Object var23_18 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            return;
        }
    }

    public SplitSegmentResult splitOverflowedSegment(LogSegment segment, LogSegments existingSegments, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix) {
        return LocalLog$.MODULE$.splitOverflowedSegment(segment, existingSegments, dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix);
    }

    public void deleteProducerSnapshots(Iterable<LogSegment> segments, ProducerStateManager producerStateManager, boolean asyncDelete, Scheduler scheduler, LogConfig config, LogDirFailureChannel logDirFailureChannel, String parentDir, TopicPartition topicPartition) {
        Iterable snapshotsToDelete = (Iterable)segments.flatMap((Function1 & Serializable)segment -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(producerStateManager.removeAndMarkSnapshotForDeletion(segment.baseOffset()))));
        if (asyncDelete) {
            scheduler.scheduleOnce("delete-producer-snapshot", () -> UnifiedLog$.deleteProducerSnapshots$1(logDirFailureChannel, parentDir, topicPartition, snapshotsToDelete), config.fileDeleteDelayMs);
            return;
        }
        UnifiedLog$.deleteProducerSnapshots$1(logDirFailureChannel, parentDir, topicPartition, snapshotsToDelete);
    }

    public LogSegment createNewCleanedSegment(File dir, LogConfig logConfig, long baseOffset) {
        return LocalLog$.MODULE$.createNewCleanedSegment(dir, logConfig, baseOffset);
    }

    public LogValidator.MetricsRecorder newValidatorMetricsRecorder(BrokerTopicMetrics allTopicsStats) {
        return new LogValidator.MetricsRecorder(allTopicsStats){
            private final BrokerTopicMetrics allTopicsStats$1;

            public void recordInvalidMagic() {
                this.allTopicsStats$1.invalidMagicNumberRecordsPerSec().mark();
            }

            public void recordInvalidOffset() {
                this.allTopicsStats$1.invalidOffsetOrSequenceRecordsPerSec().mark();
            }

            public void recordInvalidSequence() {
                this.allTopicsStats$1.invalidOffsetOrSequenceRecordsPerSec().mark();
            }

            public void recordInvalidChecksums() {
                this.allTopicsStats$1.invalidMessageCrcRecordsPerSec().mark();
            }

            public void recordNoKeyCompactedTopic() {
                this.allTopicsStats$1.noKeyCompactedTopicRecordsPerSec().mark();
            }
            {
                this.allTopicsStats$1 = allTopicsStats$1;
            }
        };
    }

    private static final LeaderEpochFileCache newLeaderEpochFileCache$1(File leaderEpochFile$1, LogDirFailureChannel logDirFailureChannel$1, TopicPartition topicPartition$1) {
        LeaderEpochCheckpointFile checkpointFile = new LeaderEpochCheckpointFile(leaderEpochFile$1, logDirFailureChannel$1);
        return new LeaderEpochFileCache(topicPartition$1, (LeaderEpochCheckpoint)checkpointFile);
    }

    public static final /* synthetic */ String $anonfun$maybeCreateLeaderEpochCache$2(String logPrefix$1, RecordVersion recordVersion$1) {
        return new StringBuilder(73).append(logPrefix$1).append("Deleting non-empty leader epoch cache due to incompatible message format ").append(recordVersion$1).toString();
    }

    public static final /* synthetic */ String $anonfun$rebuildProducerState$2(String logPrefix$2, long lastOffset$2, RecordVersion recordVersion$2) {
        return new StringBuilder(64).append(logPrefix$2).append("Loading producer state till offset ").append(lastOffset$2).append(" with message format version ").append(recordVersion$2.value).toString();
    }

    public static final /* synthetic */ String $anonfun$rebuildProducerState$4(String logPrefix$2, long lastOffset$2) {
        return new StringBuilder(75).append(logPrefix$2).append("Reloading from producer snapshot and rebuilding producer state from offset ").append(lastOffset$2).toString();
    }

    public static final /* synthetic */ void $anonfun$rebuildProducerState$5(ProducerStateManager producerStateManager$3, long logStartOffset$1, Seq offsetsToSnapshot$1, Option segmentOfLastOffset$1, long lastOffset$2, LogSegment segment) {
        int maxPosition;
        FetchDataInfo fetchDataInfo;
        long startOffset = Utils.max((long)segment.baseOffset(), (long[])new long[]{producerStateManager$3.mapEndOffset(), logStartOffset$1});
        producerStateManager$3.updateMapEndOffset(startOffset);
        if (offsetsToSnapshot$1.contains((Object)new Some((Object)BoxesRunTime.boxToLong((long)segment.baseOffset())))) {
            producerStateManager$3.takeSnapshot();
        }
        if ((fetchDataInfo = segment.read(startOffset, Integer.MAX_VALUE, maxPosition = segmentOfLastOffset$1.contains((Object)segment) ? BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)segment.translateOffset(lastOffset$2, segment.translateOffset$default$2())).map((Function1 & Serializable)x$27 -> BoxesRunTime.boxToInteger((int)x$27.position)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> segment.size())) : segment.size(), segment.read$default$4())) != null) {
            MODULE$.loadProducersFromRecords(producerStateManager$3, fetchDataInfo.records);
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$rebuildProducerState$8(String logPrefix$2, long segmentRecoveryStart$1, long producerStateLoadStart$1, Time time$1, long lastOffset$2) {
        return new StringBuilder(90).append(logPrefix$2).append("Producer state recovery took ").append(segmentRecoveryStart$1 - producerStateLoadStart$1).append("ms for snapshot load ").append("and ").append(time$1.milliseconds() - segmentRecoveryStart$1).append("ms for segment recovery from offset ").append(lastOffset$2).toString();
    }

    public static final /* synthetic */ String $anonfun$deleteProducerSnapshots$2(TopicPartition topicPartition$2, String parentDir$1) {
        return new StringBuilder(58).append("Error while deleting producer state snapshots for ").append(topicPartition$2).append(" in dir ").append(parentDir$1).toString();
    }

    private static final void deleteProducerSnapshots$1(LogDirFailureChannel logDirFailureChannel$2, String parentDir$1, TopicPartition topicPartition$2, Iterable snapshotsToDelete$1) {
        if (logDirFailureChannel$2.hasOfflineLogDir(parentDir$1)) {
            throw new KafkaStorageException(new StringBuilder(63).append("The log dir ").append(parentDir$1).append(" is already offline due to a previous IO exception.").toString());
        }
        try {
            snapshotsToDelete$1.foreach((Function1 & Serializable)snapshot -> BoxesRunTime.boxToBoolean((boolean)snapshot.deleteIfExists()));
            return;
        }
        catch (IOException maybeHandleIOException_e) {
            logDirFailureChannel$2.maybeAddOfflineLogDir(parentDir$1, UnifiedLog$.$anonfun$deleteProducerSnapshots$2(topicPartition$2, parentDir$1), maybeHandleIOException_e);
            throw new KafkaStorageException(UnifiedLog$.$anonfun$deleteProducerSnapshots$2(topicPartition$2, parentDir$1), (Throwable)maybeHandleIOException_e);
        }
    }

    private UnifiedLog$() {
    }

    public static final /* synthetic */ Object $anonfun$rebuildProducerState$5$adapted(ProducerStateManager producerStateManager$3, long logStartOffset$1, Seq offsetsToSnapshot$1, Option segmentOfLastOffset$1, long lastOffset$2, LogSegment segment) {
        UnifiedLog$.$anonfun$rebuildProducerState$5(producerStateManager$3, logStartOffset$1, offsetsToSnapshot$1, segmentOfLastOffset$1, lastOffset$2, segment);
        return BoxedUnit.UNIT;
    }
}

