/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.DelegationTokensZNode$;
import kafka.zk.FailedRegistrationResult;
import kafka.zk.KRaftRegistrationResult;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import kafka.zk.SuccessfulRegistrationResult;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkVersion$;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.SetDataRequest;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.metadata.DelegationTokenData;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.migration.AclMigrationClient;
import org.apache.kafka.metadata.migration.ConfigMigrationClient;
import org.apache.kafka.metadata.migration.DelegationTokenMigrationClient;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.TopicMigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t]q!B\u0011#\u0011\u00039c!B\u0015#\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004bB\u001a\u0002\u0005\u0004%\t\u0001\u000e\u0005\u0007q\u0005\u0001\u000b\u0011B\u001b\t\u000be\nA\u0011\u0001\u001e\t\u000f\u0005E\u0016\u0001\"\u0001\u00024\"9\u0011q]\u0001\u0005\u0002\u0005%h\u0001B\u0015#\u0001qB\u0001\u0002\u0017\u0005\u0003\u0002\u0003\u0006I!\u0017\u0005\t9\"\u0011\t\u0011)A\u0005;\"A\u0001\r\u0003B\u0001B\u0003%\u0011\r\u0003\u0005e\u0011\t\u0005\t\u0015!\u0003f\u0011!A\u0007B!A!\u0002\u0013I\u0007\"B\u0019\t\t\u0003a\u0007\"\u0002:\t\t\u0003\u001a\b\"B=\t\t\u0003R\b\"B?\t\t\u0003r\bbBA\u0001\u0011\u0011\u0005\u00131\u0001\u0005\b\u0003\u000fAA\u0011AA\u0005\u0011\u001d\tI\u0005\u0003C\u0001\u0003\u0017Bq!!\u0015\t\t\u0003\t\u0019\u0006C\u0004\u0002X!!\t!!\u0017\t\u000f\u0005u\u0003\u0002\"\u0001\u0002`!9\u00111\r\u0005\u0005\u0002\u0005\u0015\u0004bBA5\u0011\u0011\u0005\u00131\u000e\u0005\b\u0003gBA\u0011IA;\u0011\u001d\ti\b\u0003C!\u0003\u007fBq!!$\t\t\u0003\ny\t\u0003\u0004]\u0011\u0011\u0005\u0013Q\u0014\u0005\u0007A\"!\t%a(\t\r\u0011DA\u0011IAQ\u0011\u0019A\u0007\u0002\"\u0011\u0002$\u0006\t\"l['jOJ\fG/[8o\u00072LWM\u001c;\u000b\u0005\r\"\u0013A\u0001>l\u0015\u0005)\u0013!B6bM.\f7\u0001\u0001\t\u0003Q\u0005i\u0011A\t\u0002\u00125.l\u0015n\u001a:bi&|gn\u00117jK:$8CA\u0001,!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aJ\u0001\r\u001b\u0006D()\u0019;dQNK'0Z\u000b\u0002kA\u0011AFN\u0005\u0003o5\u00121!\u00138u\u00035i\u0015\r\u001f\"bi\u000eD7+\u001b>fA\u0005)\u0011\r\u001d9msR)1(!*\u0002(B\u0011\u0001\u0006C\n\u0005\u0011u*%\u000b\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u0006!A.\u00198h\u0015\u0005\u0011\u0015\u0001\u00026bm\u0006L!\u0001R \u0003\r=\u0013'.Z2u!\t1\u0005+D\u0001H\u0015\tA\u0015*A\u0005nS\u001e\u0014\u0018\r^5p]*\u0011!jS\u0001\t[\u0016$\u0018\rZ1uC*\u0011Q\u0005\u0014\u0006\u0003\u001b:\u000ba!\u00199bG\",'\"A(\u0002\u0007=\u0014x-\u0003\u0002R\u000f\nyQ*[4sCRLwN\\\"mS\u0016tG\u000f\u0005\u0002T-6\tAK\u0003\u0002VI\u0005)Q\u000f^5mg&\u0011q\u000b\u0016\u0002\b\u0019><w-\u001b8h\u0003!Q8n\u00117jK:$\bC\u0001\u0015[\u0013\tY&EA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\fi>\u0004\u0018nY\"mS\u0016tG\u000f\u0005\u0002G=&\u0011ql\u0012\u0002\u0015)>\u0004\u0018nY'jOJ\fG/[8o\u00072LWM\u001c;\u0002\u0019\r|gNZ5h\u00072LWM\u001c;\u0011\u0005\u0019\u0013\u0017BA2H\u0005U\u0019uN\u001c4jO6KwM]1uS>t7\t\\5f]R\f\u0011\"Y2m\u00072LWM\u001c;\u0011\u0005\u00193\u0017BA4H\u0005I\t5\r\\'jOJ\fG/[8o\u00072LWM\u001c;\u0002+\u0011,G.Z4bi&|g\u000eV8lK:\u001cE.[3oiB\u0011aI[\u0005\u0003W\u001e\u0013a\u0004R3mK\u001e\fG/[8o)>\\WM\\'jOJ\fG/[8o\u00072LWM\u001c;\u0015\rmjgn\u001c9r\u0011\u0015Af\u00021\u0001Z\u0011\u0015af\u00021\u0001^\u0011\u0015\u0001g\u00021\u0001b\u0011\u0015!g\u00021\u0001f\u0011\u0015Ag\u00021\u0001j\u0003\u0005:W\r^(s\u0007J,\u0017\r^3NS\u001e\u0014\u0018\r^5p]J+7m\u001c<fef\u001cF/\u0019;f)\t!x\u000f\u0005\u0002Gk&\u0011ao\u0012\u0002\u001b5.l\u0015n\u001a:bi&|g\u000eT3bI\u0016\u00148\u000f[5q'R\fG/\u001a\u0005\u0006q>\u0001\r\u0001^\u0001\rS:LG/[1m'R\fG/Z\u0001\u001ag\u0016$X*[4sCRLwN\u001c*fG>4XM]=Ti\u0006$X\r\u0006\u0002uw\")A\u0010\u0005a\u0001i\u0006)1\u000f^1uK\u0006I2\r\\1j[\u000e{g\u000e\u001e:pY2,'\u000fT3bI\u0016\u00148\u000f[5q)\t!x\u0010C\u0003}#\u0001\u0007A/A\u000esK2,\u0017m]3D_:$(o\u001c7mKJdU-\u00193feND\u0017\u000e\u001d\u000b\u0004i\u0006\u0015\u0001\"\u0002?\u0013\u0001\u0004!\u0018!D7jOJ\fG/\u001a+pa&\u001c7\u000f\u0006\u0004\u0002\f\u0005E\u0011Q\b\t\u0004Y\u00055\u0011bAA\b[\t!QK\\5u\u0011\u001d\t\u0019b\u0005a\u0001\u0003+\taB]3d_J$7i\u001c8tk6,'\u000f\u0005\u0004\u0002\u0018\u0005\u0005\u0012QE\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005Aa-\u001e8di&|gNC\u0002\u0002 \u0005\u000bA!\u001e;jY&!\u00111EA\r\u0005!\u0019uN\\:v[\u0016\u0014\bCBA\u0014\u0003S\ti#\u0004\u0002\u0002\u001e%!\u00111FA\u000f\u0005\u0011a\u0015n\u001d;\u0011\t\u0005=\u0012\u0011H\u0007\u0003\u0003cQA!a\r\u00026\u000511m\\7n_:T1!a\u000eL\u0003\u0019\u0019XM\u001d<fe&!\u00111HA\u0019\u0005Q\t\u0005/['fgN\fw-Z!oIZ+'o]5p]\"9\u0011qH\nA\u0002\u0005\u0005\u0013\u0001\u00052s_.,'/\u00133D_:\u001cX/\\3s!\u0019\t9\"!\t\u0002DA\u0019a(!\u0012\n\u0007\u0005\u001dsHA\u0004J]R,w-\u001a:\u0002)5LwM]1uK\n\u0013xn[3s\u0007>tg-[4t)\u0019\tY!!\u0014\u0002P!9\u00111\u0003\u000bA\u0002\u0005U\u0001bBA )\u0001\u0007\u0011\u0011I\u0001\u0014[&<'/\u0019;f\u00072LWM\u001c;Rk>$\u0018m\u001d\u000b\u0005\u0003\u0017\t)\u0006C\u0004\u0002\u0014U\u0001\r!!\u0006\u0002#5LwM]1uKB\u0013x\u000eZ;dKJLE\r\u0006\u0003\u0002\f\u0005m\u0003bBA\n-\u0001\u0007\u0011QC\u0001\f[&<'/\u0019;f\u0003\u000ed7\u000f\u0006\u0003\u0002\f\u0005\u0005\u0004bBA\n/\u0001\u0007\u0011QC\u0001\u0018[&<'/\u0019;f\t\u0016dWmZ1uS>tGk\\6f]N$B!a\u0003\u0002h!9\u00111\u0003\rA\u0002\u0005U\u0011a\u0004:fC\u0012\fE\u000e\\'fi\u0006$\u0017\r^1\u0015\r\u0005-\u0011QNA9\u0011\u001d\ty'\u0007a\u0001\u0003+\tQBY1uG\"\u001cuN\\:v[\u0016\u0014\bbBA 3\u0001\u0007\u0011\u0011I\u0001\u000ee\u0016\fGM\u0011:pW\u0016\u0014\u0018\nZ:\u0015\u0005\u0005]\u0004CBA\u0014\u0003s\n\u0019%\u0003\u0003\u0002|\u0005u!aA*fi\u0006q!/Z1e!J|G-^2fe&#GCAAA!\u0019\t9#a!\u0002\b&!\u0011QQA\u000f\u0005!y\u0005\u000f^5p]\u0006d\u0007\u0003BA\u0018\u0003\u0013KA!a#\u00022\t\u0001\u0002K]8ek\u000e,'/\u00133t\u00052|7m[\u0001\u0010oJLG/\u001a)s_\u0012,8-\u001a:JIR)A/!%\u0002\u001c\"9\u00111\u0013\u000fA\u0002\u0005U\u0015A\u00048fqR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\t\u0004Y\u0005]\u0015bAAM[\t!Aj\u001c8h\u0011\u0015aH\u00041\u0001u)\u0005iF#A1\u0015\u0003\u0015$\u0012!\u001b\u0005\u00061\u0016\u0001\r!\u0017\u0005\b\u0003S+\u0001\u0019AAV\u0003=Q8nQ8oM&<WI\\2pI\u0016\u0014\bcA*\u0002.&\u0019\u0011q\u0016+\u0003\u001fA\u000b7o]<pe\u0012,enY8eKJ\fqb\u001e:baj[W\t_2faRLwN\\\u000b\u0005\u0003k\u000bY\f\u0006\u0003\u00028\u00065\u0007\u0003BA]\u0003wc\u0001\u0001B\u0004\u0002>\u001a\u0011\r!a0\u0003\u0003Q\u000bB!!1\u0002HB\u0019A&a1\n\u0007\u0005\u0015WFA\u0004O_RD\u0017N\\4\u0011\u00071\nI-C\u0002\u0002L6\u00121!\u00118z\u0011!\tyM\u0002CA\u0002\u0005E\u0017A\u00014o!\u0015a\u00131[A\\\u0013\r\t).\f\u0002\ty\tLh.Y7f}!*a!!7\u0002fB)A&a7\u0002`&\u0019\u0011Q\\\u0017\u0003\rQD'o\\<t!\r1\u0015\u0011]\u0005\u0004\u0003G<%\u0001G'jOJ\fG/[8o\u00072LWM\u001c;Fq\u000e,\u0007\u000f^5p]\u000e\u0012\u0011q\\\u0001\u000eY><\u0017I\u001c3SKRD'o\\<\u0016\t\u0005-\u0018\u0011\u001f\u000b\u0007\u0003[\f90a?\u0015\t\u0005=\u00181\u001f\t\u0005\u0003s\u000b\t\u0010B\u0004\u0002>\u001e\u0011\r!a0\t\u0011\u0005=w\u0001\"a\u0001\u0003k\u0004R\u0001LAj\u0003_Da!!?\b\u0001\u0004\u0011\u0016A\u00027pO\u001e,'\u000fC\u0004\u0002~\u001e\u0001\r!a@\u0002\u00075\u001cx\r\u0005\u0003\u0003\u0002\t=a\u0002\u0002B\u0002\u0005\u0017\u00012A!\u0002.\u001b\t\u00119AC\u0002\u0003\n\u0019\na\u0001\u0010:p_Rt\u0014b\u0001B\u0007[\u00051\u0001K]3eK\u001aLAA!\u0005\u0003\u0014\t11\u000b\u001e:j]\u001eT1A!\u0004.Q\u00159\u0011\u0011\\As\u0001")
public class ZkMigrationClient
implements MigrationClient,
Logging {
    private final KafkaZkClient zkClient;
    private final TopicMigrationClient topicClient;
    public final ConfigMigrationClient kafka$zk$ZkMigrationClient$$configClient;
    private final AclMigrationClient aclClient;
    private final DelegationTokenMigrationClient delegationTokenClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <T> T logAndRethrow(Logging logger, String msg, Function0<T> fn) throws MigrationClientException {
        try {
            return (T)fn.apply();
        }
        catch (Throwable logAndRethrow_e) {
            logger.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
            throw logAndRethrow_e;
        }
    }

    public static <T> T wrapZkException(Function0<T> fn) throws MigrationClientException {
        try {
            return (T)fn.apply();
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public static ZkMigrationClient apply(KafkaZkClient zkClient, PasswordEncoder zkConfigEncoder) {
        return ZkMigrationClient$.MODULE$.apply(zkClient, zkConfigEncoder);
    }

    public static int MaxBatchSize() {
        return ZkMigrationClient$.MODULE$.MaxBatchSize();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ZkMigrationLeadershipState getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState initialState) {
        try {
            return ZkMigrationClient.$anonfun$getOrCreateMigrationRecoveryState$1(this, initialState);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState setMigrationRecoveryState(ZkMigrationLeadershipState state) {
        try {
            return this.zkClient.updateMigrationState(state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState claimControllerLeadership(ZkMigrationLeadershipState state) {
        try {
            return ZkMigrationClient.$anonfun$claimControllerLeadership$1(this, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState releaseControllerLeadership(ZkMigrationLeadershipState state) {
        try {
            return ZkMigrationClient.$anonfun$releaseControllerLeadership$1(this, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public void migrateTopics(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer, Consumer<Integer> brokerIdConsumer) {
        try {
            ObjectRef $anonfun$migrateTopics$1_topicBatch = ObjectRef.create(new ArrayList());
            this.topicClient.iterateTopics(EnumSet.allOf(TopicMigrationClient.TopicVisitorInterest.class), new TopicMigrationClient.TopicVisitor(this, $anonfun$migrateTopics$1_topicBatch, recordConsumer, brokerIdConsumer){
                private final /* synthetic */ ZkMigrationClient $outer;
                private final ObjectRef topicBatch$1;
                private final Consumer recordConsumer$1;
                private final Consumer brokerIdConsumer$1;

                public void visitTopic(String topicName, Uuid topicId, Map<Integer, java.util.List<Integer>> assignments) {
                    if (!((ArrayList)this.topicBatch$1.elem).isEmpty()) {
                        this.recordConsumer$1.accept((ArrayList)this.topicBatch$1.elem);
                        this.topicBatch$1.elem = new ArrayList<E>();
                    }
                    ((ArrayList)this.topicBatch$1.elem).add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName(topicName).setTopicId(topicId), (short)0));
                    this.$outer.kafka$zk$ZkMigrationClient$$configClient.readTopicConfigs(topicName, topicConfigs -> topicConfigs.forEach((key, value) -> ((ArrayList)$this.topicBatch$1.elem).add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName(topicName).setName(key.toString()).setValue(value.toString()), (short)0))));
                }

                public void visitPartition(TopicIdPartition topicIdPartition, PartitionRegistration partitionRegistration) {
                    PartitionRecord record = new PartitionRecord().setTopicId(topicIdPartition.topicId()).setPartitionId(topicIdPartition.partition()).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partitionRegistration.replicas), (Function1 & Serializable)x$1 -> $anon$1.$anonfun$visitPartition$1(BoxesRunTime.unboxToInt((Object)x$1)), ClassTag$.MODULE$.apply(Integer.class))).toList()).asJava()).setAddingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partitionRegistration.addingReplicas), (Function1 & Serializable)x$1 -> $anon$1.$anonfun$visitPartition$2(BoxesRunTime.unboxToInt((Object)x$1)), ClassTag$.MODULE$.apply(Integer.class))).toList()).asJava()).setRemovingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partitionRegistration.removingReplicas), (Function1 & Serializable)x$1 -> $anon$1.$anonfun$visitPartition$3(BoxesRunTime.unboxToInt((Object)x$1)), ClassTag$.MODULE$.apply(Integer.class))).toList()).asJava()).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partitionRegistration.isr), (Function1 & Serializable)x$1 -> $anon$1.$anonfun$visitPartition$4(BoxesRunTime.unboxToInt((Object)x$1)), ClassTag$.MODULE$.apply(Integer.class))).toList()).asJava()).setLeader(partitionRegistration.leader).setLeaderEpoch(partitionRegistration.leaderEpoch).setPartitionEpoch(partitionRegistration.partitionEpoch).setLeaderRecoveryState(partitionRegistration.leaderRecoveryState.value());
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partitionRegistration.replicas), (Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> $this.brokerIdConsumer$1.accept(Predef$.MODULE$.int2Integer(x$1)));
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partitionRegistration.addingReplicas), (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> $this.brokerIdConsumer$1.accept(Predef$.MODULE$.int2Integer(x$2)));
                    ((ArrayList)this.topicBatch$1.elem).add(new ApiMessageAndVersion((ApiMessage)record, (short)0));
                }

                public static final /* synthetic */ Integer $anonfun$visitPartition$1(int x$1) {
                    return x$1;
                }

                public static final /* synthetic */ Integer $anonfun$visitPartition$2(int x$1) {
                    return x$1;
                }

                public static final /* synthetic */ Integer $anonfun$visitPartition$3(int x$1) {
                    return x$1;
                }

                public static final /* synthetic */ Integer $anonfun$visitPartition$4(int x$1) {
                    return x$1;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topicBatch$1 = topicBatch$1;
                    this.recordConsumer$1 = recordConsumer$1;
                    this.brokerIdConsumer$1 = brokerIdConsumer$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$visitPartition$1$adapted(java.lang.Object ), $anonfun$visitPartition$2$adapted(java.lang.Object ), $anonfun$visitPartition$3$adapted(java.lang.Object ), $anonfun$visitPartition$4$adapted(java.lang.Object ), $anonfun$visitPartition$5(kafka.zk.ZkMigrationClient$$anon$1 int ), $anonfun$visitPartition$6(kafka.zk.ZkMigrationClient$$anon$1 int )}, serializedLambda);
                }
            });
            if (!((ArrayList)$anonfun$migrateTopics$1_topicBatch.elem).isEmpty()) {
                recordConsumer.accept((ArrayList)$anonfun$migrateTopics$1_topicBatch.elem);
            }
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public void migrateBrokerConfigs(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer, Consumer<Integer> brokerIdConsumer) {
        try {
            this.kafka$zk$ZkMigrationClient$$configClient.iterateBrokerConfigs((broker, props) -> {
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(broker))) {
                    brokerIdConsumer$2.accept(Integer.valueOf(broker));
                }
                ArrayList batch = new ArrayList();
                props.forEach((key, value) -> batch.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName(broker).setName(key).setValue(value), (short)0)));
                if (!batch.isEmpty()) {
                    recordConsumer$2.accept(batch);
                    return;
                }
            });
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public void migrateClientQuotas(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer) {
        try {
            this.kafka$zk$ZkMigrationClient$$configClient.iterateClientQuotas(new ConfigMigrationClient.ClientQuotaVisitor(null, recordConsumer){
                private final Consumer recordConsumer$3;

                public void visitClientQuota(java.util.List<ClientQuotaRecord.EntityData> entityDataList, Map<String, Double> quotas) {
                    ArrayList<E> batch = new ArrayList<E>();
                    quotas.forEach((key, value) -> batch.add(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(entityDataList).setKey(key).setValue(Predef$.MODULE$.Double2double(value)), (short)0)));
                    this.recordConsumer$3.accept(batch);
                }

                public void visitScramCredential(String userName, ScramMechanism scramMechanism, ScramCredential scramCredential) {
                    ArrayList<ApiMessageAndVersion> batch = new ArrayList<ApiMessageAndVersion>();
                    batch.add(new ApiMessageAndVersion((ApiMessage)new UserScramCredentialRecord().setName(userName).setMechanism(scramMechanism.type()).setSalt(scramCredential.salt()).setStoredKey(scramCredential.storedKey()).setServerKey(scramCredential.serverKey()).setIterations(scramCredential.iterations()), (short)0));
                    this.recordConsumer$3.accept(batch);
                }
                {
                    this.recordConsumer$3 = recordConsumer$3;
                }
            });
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void migrateProducerId(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer) {
        try {
            void var5_3;
            Tuple2<Option<byte[]>, Object> tuple2 = this.zkClient.getDataAndVersion("/latest_producer_id_block");
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Option $anonfun$migrateProducerId$1_dataOpt = (Option)tuple2._1();
            if (var5_3 instanceof Some) {
                byte[] $anonfun$migrateProducerId$1_data = (byte[])((Some)var5_3).value();
                ProducerIdsBlock $anonfun$migrateProducerId$1_producerIdBlock = ProducerIdBlockZNode$.MODULE$.parseProducerIdBlockData($anonfun$migrateProducerId$1_data);
                recordConsumer.accept(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new ProducerIdsRecord().setBrokerEpoch(-1L).setBrokerId($anonfun$migrateProducerId$1_producerIdBlock.assignedBrokerId()).setNextProducerId($anonfun$migrateProducerId$1_producerIdBlock.firstProducerId()), (short)0), (List)Nil$.MODULE$)).asJava());
            } else if (!None$.MODULE$.equals(var5_3)) {
                throw new MatchError((Object)var5_3);
            }
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public void migrateAcls(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer) {
        this.aclClient.iterateAcls((BiConsumer)new BiConsumer<ResourcePattern, java.util.Set<AccessControlEntry>>(null, recordConsumer){
            private final Consumer recordConsumer$5;

            public BiConsumer<ResourcePattern, java.util.Set<AccessControlEntry>> andThen(BiConsumer<? super ResourcePattern, ? super java.util.Set<AccessControlEntry>> x$1) {
                return BiConsumer.super.andThen(x$1);
            }

            public void accept(ResourcePattern resourcePattern, java.util.Set<AccessControlEntry> acls) {
                ArrayList<E> batch = new ArrayList<E>();
                CollectionConverters$.MODULE$.SetHasAsScala(acls).asScala().foreach((Function1 & Serializable)entry -> {
                    $anon$3.$anonfun$accept$1(this, batch, resourcePattern, entry);
                    return BoxedUnit.UNIT;
                });
                if (!batch.isEmpty()) {
                    this.recordConsumer$5.accept(batch);
                    return;
                }
            }

            public static final /* synthetic */ void $anonfun$accept$1($anon$3 $this, ArrayList batch$3, ResourcePattern resourcePattern$1, AccessControlEntry entry) {
                batch$3.add(new ApiMessageAndVersion((ApiMessage)new AccessControlEntryRecord().setId(Uuid.randomUuid()).setResourceType(resourcePattern$1.resourceType().code()).setResourceName(resourcePattern$1.name()).setPatternType(resourcePattern$1.patternType().code()).setPrincipal(entry.principal()).setHost(entry.host()).setOperation(entry.operation().code()).setPermissionType(entry.permissionType().code()), 0));
                if (batch$3.size() == ZkMigrationClient$.MODULE$.MaxBatchSize()) {
                    $this.recordConsumer$5.accept(batch$3);
                    batch$3.clear();
                    return;
                }
            }
            {
                this.recordConsumer$5 = recordConsumer$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accept$1$adapted(kafka.zk.ZkMigrationClient$$anon$3 java.util.ArrayList org.apache.kafka.common.resource.ResourcePattern org.apache.kafka.common.acl.AccessControlEntry )}, serializedLambda);
            }
        });
    }

    public void migrateDelegationTokens(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer) {
        try {
            ArrayList $anonfun$migrateDelegationTokens$1_batch = new ArrayList();
            this.zkClient.getChildren(DelegationTokensZNode$.MODULE$.path()).foreach((Function1 & Serializable)tokenId -> {
                Option<TokenInformation> option = $this.zkClient.getDelegationTokenInfo((String)tokenId);
                if (option instanceof Some) {
                    TokenInformation tokenInformation = (TokenInformation)((Some)option).value();
                    DelegationTokenData newDelegationTokenData = new DelegationTokenData(tokenInformation);
                    return BoxesRunTime.boxToBoolean((boolean)batch.add(new ApiMessageAndVersion((ApiMessage)newDelegationTokenData.toRecord(), (short)0)));
                }
                if (None$.MODULE$.equals(option)) {
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(option);
            });
            if (!$anonfun$migrateDelegationTokens$1_batch.isEmpty()) {
                recordConsumer.accept($anonfun$migrateDelegationTokens$1_batch);
            }
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public void readAllMetadata(Consumer<java.util.List<ApiMessageAndVersion>> batchConsumer, Consumer<Integer> brokerIdConsumer) {
        this.migrateTopics(batchConsumer, brokerIdConsumer);
        this.migrateBrokerConfigs(batchConsumer, brokerIdConsumer);
        this.migrateClientQuotas(batchConsumer);
        this.migrateProducerId(batchConsumer);
        this.migrateAcls(batchConsumer);
        this.migrateDelegationTokens(batchConsumer);
    }

    public java.util.Set<Integer> readBrokerIds() {
        try {
            return ZkMigrationClient.$anonfun$readBrokerIds$1(this);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Optional<ProducerIdsBlock> readProducerId() {
        void var2_2;
        Tuple2<Option<byte[]>, Object> tuple2 = this.zkClient.getDataAndVersion("/latest_producer_id_block");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option dataOpt = (Option)tuple2._1();
        return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(var2_2.map((Function1 & Serializable)jsonData -> ProducerIdBlockZNode$.MODULE$.parseProducerIdBlockData((byte[])jsonData))));
    }

    public ZkMigrationLeadershipState writeProducerId(long nextProducerId, ZkMigrationLeadershipState state) {
        try {
            return ZkMigrationClient.$anonfun$writeProducerId$1(this, nextProducerId, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public TopicMigrationClient topicClient() {
        return this.topicClient;
    }

    public ConfigMigrationClient configClient() {
        return this.kafka$zk$ZkMigrationClient$$configClient;
    }

    public AclMigrationClient aclClient() {
        return this.aclClient;
    }

    public DelegationTokenMigrationClient delegationTokenClient() {
        return this.delegationTokenClient;
    }

    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$getOrCreateMigrationRecoveryState$1(ZkMigrationClient $this, ZkMigrationLeadershipState initialState$1) {
        $this.zkClient.createTopLevelPaths();
        return $this.zkClient.getOrCreateMigrationState(initialState$1);
    }

    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$claimControllerLeadership$1(ZkMigrationClient $this, ZkMigrationLeadershipState state$2) {
        KRaftRegistrationResult kRaftRegistrationResult = $this.zkClient.tryRegisterKRaftControllerAsActiveController(state$2.kraftControllerId(), state$2.kraftControllerEpoch());
        if (kRaftRegistrationResult instanceof SuccessfulRegistrationResult) {
            SuccessfulRegistrationResult successfulRegistrationResult = (SuccessfulRegistrationResult)kRaftRegistrationResult;
            int controllerEpoch = successfulRegistrationResult.zkControllerEpoch();
            int controllerEpochZkVersion = successfulRegistrationResult.controllerEpochZkVersion();
            return state$2.withZkController(controllerEpoch, controllerEpochZkVersion);
        }
        if (kRaftRegistrationResult instanceof FailedRegistrationResult) {
            return state$2.withUnknownZkController();
        }
        throw new MatchError((Object)kRaftRegistrationResult);
    }

    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$releaseControllerLeadership$1(ZkMigrationClient $this, ZkMigrationLeadershipState state$3) {
        try {
            $this.zkClient.deleteController(state$3.zkControllerEpochZkVersion());
            return state$3.withUnknownZkController();
        }
        catch (ControllerMovedException controllerMovedException) {
            return state$3.withUnknownZkController();
        }
        catch (Throwable t) {
            throw new MigrationClientException("Could not release controller leadership due to underlying error", t);
        }
    }

    public static final /* synthetic */ void $anonfun$migrateTopics$1(ZkMigrationClient $this, Consumer recordConsumer$1, Consumer brokerIdConsumer$1) {
        ObjectRef topicBatch = ObjectRef.create(new ArrayList());
        $this.topicClient.iterateTopics(EnumSet.allOf(TopicMigrationClient.TopicVisitorInterest.class), new /* invalid duplicate definition of identical inner class */);
        if (!((ArrayList)topicBatch.elem).isEmpty()) {
            recordConsumer$1.accept((ArrayList)topicBatch.elem);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$migrateBrokerConfigs$1(ZkMigrationClient $this, Consumer brokerIdConsumer$2, Consumer recordConsumer$2) {
        $this.kafka$zk$ZkMigrationClient$$configClient.iterateBrokerConfigs((broker, props) -> {
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(broker))) {
                brokerIdConsumer$2.accept(Integer.valueOf(broker));
            }
            ArrayList batch = new ArrayList();
            props.forEach((key, value) -> batch.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName(broker).setName(key).setValue(value), (short)0)));
            if (!batch.isEmpty()) {
                recordConsumer$2.accept(batch);
                return;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$migrateClientQuotas$1(ZkMigrationClient $this, Consumer recordConsumer$3) {
        $this.kafka$zk$ZkMigrationClient$$configClient.iterateClientQuotas(new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$migrateProducerId$1(ZkMigrationClient $this, Consumer recordConsumer$4) {
        void var3_3;
        Tuple2<Option<byte[]>, Object> tuple2 = $this.zkClient.getDataAndVersion("/latest_producer_id_block");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option dataOpt = (Option)tuple2._1();
        if (var3_3 instanceof Some) {
            byte[] data = (byte[])((Some)var3_3).value();
            ProducerIdsBlock producerIdBlock = ProducerIdBlockZNode$.MODULE$.parseProducerIdBlockData(data);
            recordConsumer$4.accept(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new ProducerIdsRecord().setBrokerEpoch(-1L).setBrokerId(producerIdBlock.assignedBrokerId()).setNextProducerId(producerIdBlock.firstProducerId()), (short)0), (List)Nil$.MODULE$)).asJava());
            return;
        }
        if (None$.MODULE$.equals(var3_3)) {
            return;
        }
        throw new MatchError((Object)var3_3);
    }

    public static final /* synthetic */ void $anonfun$migrateDelegationTokens$1(ZkMigrationClient $this, Consumer recordConsumer$6) {
        ArrayList batch = new ArrayList();
        $this.zkClient.getChildren(DelegationTokensZNode$.MODULE$.path()).foreach((Function1 & Serializable)tokenId -> {
            Option<TokenInformation> option = $this.zkClient.getDelegationTokenInfo((String)tokenId);
            if (option instanceof Some) {
                TokenInformation tokenInformation = (TokenInformation)((Some)option).value();
                DelegationTokenData newDelegationTokenData = new DelegationTokenData(tokenInformation);
                return BoxesRunTime.boxToBoolean((boolean)batch.add(new ApiMessageAndVersion((ApiMessage)newDelegationTokenData.toRecord(), (short)0)));
            }
            if (None$.MODULE$.equals(option)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError(option);
        });
        if (!batch.isEmpty()) {
            recordConsumer$6.accept(batch);
            return;
        }
    }

    public static final /* synthetic */ HashSet $anonfun$readBrokerIds$1(ZkMigrationClient $this) {
        return new HashSet(CollectionConverters$.MODULE$.SetHasAsJava((Set)((IterableOnceOps)$this.zkClient.getSortedBrokerList().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).toSet()).asJava());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$writeProducerId$1(ZkMigrationClient $this, long nextProducerId$1, ZkMigrationLeadershipState state$4) {
        void var7_6;
        byte[] newProducerIdBlockData = ProducerIdBlockZNode$.MODULE$.generateProducerIdBlockJson(new ProducerIdsBlock(-1, nextProducerId$1, 1000));
        SetDataRequest request = new SetDataRequest("/latest_producer_id_block", newProducerIdBlockData, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$);
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(new .colon.colon((Object)request, (List)Nil$.MODULE$), state$4);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        return state$4.withMigrationZkVersion((int)var7_6);
    }

    public ZkMigrationClient(KafkaZkClient zkClient, TopicMigrationClient topicClient, ConfigMigrationClient configClient, AclMigrationClient aclClient, DelegationTokenMigrationClient delegationTokenClient) {
        this.zkClient = zkClient;
        this.topicClient = topicClient;
        this.kafka$zk$ZkMigrationClient$$configClient = configClient;
        this.aclClient = aclClient;
        this.delegationTokenClient = delegationTokenClient;
    }
}

