/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kafka.api.BaseProducerSendTest;
import kafka.api.PlaintextProducerSendTest$;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.BufferExhaustedException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ue\u0001B\t\u0013\u0001]AQ\u0001\b\u0001\u0005\u0002uAQa\b\u0001\u0005\u0002\u0001BQ!\u0015\u0001\u0005\u0002ICQa\u0016\u0001\u0005\u0002aCQ!\u001f\u0001\u0005\u0002iDaa \u0001\u0005\u0002\u0005\u0005\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\tY\u0004\u0001C\u0001\u0003{Aq!a\u0013\u0001\t\u0003\ti\u0005C\u0004\u0002\\\u0001!\t!!\u0018\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j\u001d9\u00111\u000f\n\t\u0002\u0005UdAB\t\u0013\u0011\u0003\t9\b\u0003\u0004\u001d\u001d\u0011\u0005\u0011q\u0010\u0005\b\u0003oqA\u0011AAA\u0005e\u0001F.Y5oi\u0016DH\u000f\u0015:pIV\u001cWM]*f]\u0012$Vm\u001d;\u000b\u0005M!\u0012aA1qS*\tQ#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0002CA\r\u001b\u001b\u0005\u0011\u0012BA\u000e\u0013\u0005Q\u0011\u0015m]3Qe>$WoY3s'\u0016tG\rV3ti\u00061A(\u001b8jiz\"\u0012A\b\t\u00033\u0001\t1\u0003^3ti^\u0013xN\\4TKJL\u0017\r\\5{KJ$\"!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006Q\t\u0001\r!K\u0001\u0007cV|'/^7\u0011\u0005)\ndBA\u00160!\ta3%D\u0001.\u0015\tqc#\u0001\u0004=e>|GOP\u0005\u0003a\r\na\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001g\t\u0015\u0005\u0005U\u001aE\t\u0005\u00027\u00036\tqG\u0003\u00029s\u0005A\u0001O]8wS\u0012,'O\u0003\u0002;w\u00051\u0001/\u0019:b[NT!\u0001P\u001f\u0002\u000f),\b/\u001b;fe*\u0011ahP\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0001\u0006\u0019qN]4\n\u0005\t;$a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0002F\u000f\u0006\na)\u0001\u0002{W\u0006\n\u0001*A\u0003le\u00064G\u000f\u000b\u0003\u0003\u0015:{\u0005CA&M\u001b\u0005I\u0014BA':\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-I\u0001Q\u0003aYH-[:qY\u0006Lh*Y7f{:\nXo\u001c:v[vZ\b'`\u0001\u0012i\u0016\u001cHOQ1uG\"\u001c\u0016N_3[KJ|GCA\u0011T\u0011\u0015A3\u00011\u0001*Q\u0011\u0019QgQ+-\u0005\u0015;\u0005\u0006B\u0002K\u001d>\u000bq\u0005^3ti\n\u000bGo\u00195TSj,',\u001a:p\u001d>\u0004\u0016M\u001d;ji&|gNT8SK\u000e|'\u000fZ&fsR\u0011\u0011%\u0017\u0005\u0006Q\u0011\u0001\r!\u000b\u0015\u0005\tU\u001a5\f\f\u0002F\u000f\"\"AA\u0013(PQ!!al\u00193fMF\u0014\bCA0b\u001b\u0005\u0001'BA\n<\u0013\t\u0011\u0007MA\u0004US6,w.\u001e;\u0002\u000bY\fG.^3\u001f\u0003=\tA!\u001e8ji\u0012\nq-\u0003\u0002iS\u000691+R\"P\u001d\u0012\u001b&B\u00016l\u0003!!\u0016.\\3V]&$(B\u00017n\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003]>\fA!\u001e;jY*\t\u0001/\u0001\u0003kCZ\f\u0017A\u0003;ie\u0016\fG-T8eK\u0012\n1/\u0003\u0002uk\u0006y1+\u0012)B%\u0006#Vi\u0018+I%\u0016\u000bEI\u0003\u0002wo\u0006QA\u000b\u001b:fC\u0012lu\u000eZ3\u000b\u0005a\u0004\u0017a\u0002+j[\u0016|W\u000f^\u0001+i\u0016\u001cHoU3oI\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<WmV5uQ2{w-\u00119qK:$G+[7f)\t\t3\u0010C\u0003)\u000b\u0001\u0007\u0011\u0006\u000b\u0003\u0006k\rkHFA#HQ\u0011)!JT(\u0002[Q,7\u000f^*f]\u0012tuN\\\"p[B\u0014Xm]:fI6+7o]1hK^KG\u000f\u001b'pO\u0006\u0003\b/\u001a8e)&lW\rF\u0002\"\u0003\u0007AQ\u0001\u000b\u0004A\u0002%BSAB\u001bD\u0003\u000fa#!R$)\t\u0019QejT\u0001\u0014i\u0016\u001cH/Q;u_\u000e\u0013X-\u0019;f)>\u0004\u0018n\u0019\u000b\u0004C\u0005=\u0001\"\u0002\u0015\b\u0001\u0004I\u0003&B\u00046\u0007\u0006MAFA#HQ\u00119!JT(\u0002UQ,7\u000f^*f]\u0012<\u0016\u000e\u001e5J]Z\fG.\u001b3CK\u001a|'/Z!oI\u00063G/\u001a:US6,7\u000f^1naR9\u0011%a\u0007\u0002\u001e\u0005\u0005\u0002\"\u0002\u0015\t\u0001\u0004I\u0003BBA\u0010\u0011\u0001\u0007\u0011&\u0001\fnKN\u001c\u0018mZ3US6,7\u000b^1na\u000e{gNZ5h\u0011\u001d\t\u0019\u0003\u0003a\u0001\u0003K\tqB]3d_J$G+[7fgR\fW\u000e\u001d\t\u0004E\u0005\u001d\u0012bAA\u0015G\t!Aj\u001c8hQ\u0019A\u0011QF2\u00024A\u0019a'a\f\n\u0007\u0005ErG\u0001\u0007NKRDw\u000eZ*pkJ\u001cW\r\f\u0002\u00026\u0005\u0012\u0011qG\u0001!cV|'/^7B]\u0012$\u0016.\\3ti\u0006l\u0007oQ8oM&<\u0007K]8wS\u0012,'\u000f\u000b\u0003\t\u0015:{\u0015\u0001\f;fgR4\u0016\r\\5e\u0005\u00164wN]3B]\u0012\fe\r^3s)&lWm\u001d;b[B\u001c\u0018\t\u001e+ie\u0016\u001c\bn\u001c7e)\u001d\t\u0013qHA!\u0003\u0007BQ\u0001K\u0005A\u0002%Ba!a\b\n\u0001\u0004I\u0003bBA\u0012\u0013\u0001\u0007\u0011Q\u0005\u0015\u0007\u0013\u000552-a\u0012-\u0005\u0005U\u0002FA\u0005K\u0003A\"Xm\u001d;WC2LGMQ3g_J,\u0017I\u001c3BMR,'\u000fV5nKN$\u0018-\u001c9t/&$\b.\u001b8UQJ,7\u000f[8mIR9\u0011%a\u0014\u0002R\u0005M\u0003\"\u0002\u0015\u000b\u0001\u0004I\u0003BBA\u0010\u0015\u0001\u0007\u0011\u0006C\u0004\u0002$)\u0001\r!!\n)\r)\ticYA,Y\t\t)\u0004\u000b\u0002\u000b\u0015\u00069B/Z:u\u001d>t'\t\\8dW&tw\r\u0015:pIV\u001cWM\u001d\u000b\u0004C\u0005}\u0003\"\u0002\u0015\f\u0001\u0004I\u0003&B\u00066\u0007\u0006\rDFA#HQ\u0011Y!JT(\u0002]Q,7\u000f^*f]\u0012\u0014VmY8sI\n\u000bGo\u00195XSRDW*\u0019=SKF,Xm\u001d;TSj,\u0017I\u001c3IS\u001eDWM\u001d\u000b\u0004C\u0005-\u0004\"\u0002\u0015\r\u0001\u0004I\u0003&\u0002\u00076\u0007\u0006=DFA#HQ\u0011a!JT(\u00023Ac\u0017-\u001b8uKb$\bK]8ek\u000e,'oU3oIR+7\u000f\u001e\t\u000339\u00192ADA=!\r\u0011\u00131P\u0005\u0004\u0003{\u001a#AB!osJ+g\r\u0006\u0002\u0002vU\u0011\u00111\u0011\t\u0007\u0003\u000b\u000bY)a$\u000e\u0005\u0005\u001d%bAAE[\u000611\u000f\u001e:fC6LA!!$\u0002\b\n11\u000b\u001e:fC6\u00042ANAI\u0013\r\t\u0019j\u000e\u0002\n\u0003J<W/\\3oiN\u0004")
public class PlaintextProducerSendTest
extends BaseProducerSendTest {
    public static Stream<Arguments> quorumAndTimestampConfigProvider() {
        return PlaintextProducerSendTest$.MODULE$.quorumAndTimestampConfigProvider();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testWrongSerializer(String quorum) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        KafkaProducer<byte[], byte[]> producer = this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps));
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions.assertThrows(SerializationException.class, () -> producer.send(record));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBatchSizeZero(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerify(producer, this.sendAndVerify$default$2(), this.sendAndVerify$default$3());
    }

    @Timeout(value=15L, unit=TimeUnit.SECONDS, threadMode=Timeout.ThreadMode.SEPARATE_THREAD)
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBatchSizeZeroNoPartitionNoRecordKey(String quorum) {
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        String x$4 = this.createProducer$default$4();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        int numRecords = 10;
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, 0, x$4, x$5, x$6);){
            TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), this.controllerServers(), 2, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            IndexedSeq futures = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numRecords).map((Function1 & Serializable)i -> PlaintextProducerSendTest.$anonfun$testBatchSizeZeroNoPartitionNoRecordKey$1(this, producer, BoxesRunTime.unboxToInt((Object)i)));
            producer.flush();
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(offset, future) -> BoxesRunTime.boxToInteger((int)PlaintextProducerSendTest.$anonfun$testBatchSizeZeroNoPartitionNoRecordKey$2(this, BoxesRunTime.unboxToInt((Object)offset), future))));
            Assertions.assertEquals((int)numRecords, (int)lastOffset);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendCompressedMessageWithLogAppendTime(String quorum) {
        int x$4 = this.createProducer$default$3();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, x$4, "gzip", x$5, x$6);
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendNonCompressedMessageWithLogAppendTime(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoCreateTopic(String quorum) {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            ProducerRecord record = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assertions.assertEquals((long)0L, (long)((RecordMetadata)producer.send(record).get()).offset(), (String)"Should have offset 0");
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic(), 0, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"quorumAndTimestampConfigProvider"})
    public void testSendWithInvalidBeforeAndAfterTimestamp(String quorum, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        long oneMinuteInMs = 3600000L;
        topicProps.setProperty(messageTimeStampConfig, Long.toString(oneMinuteInMs));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, 1, 2, (Map<Object, Seq<Object>>)x$8, topicProps);
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())).get()).getCause() instanceof InvalidTimestampException));
        }
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        try (KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, "gzip", x$13, x$14);){
            Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())).get()).getCause() instanceof InvalidTimestampException));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"quorumAndTimestampConfigProvider"})
    public void testValidBeforeAndAfterTimestampsAtThreshold(String quorum, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        topicProps.setProperty(messageTimeStampConfig, Long.toString(recordTimestamp));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, 1, 2, (Map<Object, Seq<Object>>)x$8, topicProps);
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        Assertions.assertDoesNotThrow(() -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        producer.close();
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, "gzip", x$13, x$14);
        Assertions.assertDoesNotThrow(() -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        compressedProducer.close();
    }

    @ParameterizedTest
    @MethodSource(value={"quorumAndTimestampConfigProvider"})
    public void testValidBeforeAndAfterTimestampsWithinThreshold(String quorum, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        long tenMinutesInMs = 36000000L;
        topicProps.setProperty(messageTimeStampConfig, Long.toString(tenMinutesInMs));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, 1, 2, (Map<Object, Seq<Object>>)x$8, topicProps);
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        Assertions.assertDoesNotThrow(() -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        producer.close();
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, "gzip", x$13, x$14);
        Assertions.assertDoesNotThrow(() -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        compressedProducer.close();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testNonBlockingProducer(String quorum) {
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        int x$4 = this.createProducer$default$3();
        String x$5 = this.createProducer$default$4();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$4, x$5, 0L, x$6);
        PlaintextProducerSendTest.verifyMetadataNotAvailable$1(this.send$1(producer));
        Future future = this.sendUntilQueued$1(producer);
        this.verifySendSuccess$1(future);
        int x$11 = this.createProducer$default$2();
        String x$12 = this.createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer2 = this.createProducer(15000, x$11, 1100, x$12, 0L, 1500L);
        Future future2 = this.sendUntilQueued$1(producer2);
        PlaintextProducerSendTest.verifyBufferExhausted$1(this.send$1(producer2));
        this.verifySendSuccess$1(future2);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendRecordBatchWithMaxRequestSizeAndHigher(String quorum) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        KafkaProducer<byte[], byte[]> producer = this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer()));
        int keyLengthSize = 1;
        int headerLengthSize = 1;
        int valueLengthSize = 3;
        int overhead = 94 + keyLengthSize + headerLengthSize + valueLengthSize;
        int valueSize = 0x10000C - overhead;
        ProducerRecord record0 = new ProducerRecord(this.topic(), (Object)new byte[0], (Object)new byte[valueSize]);
        Assertions.assertEquals((int)((byte[])record0.value()).length, (int)((RecordMetadata)producer.send(record0).get()).serializedValueSize());
        ProducerRecord record1 = new ProducerRecord(this.topic(), (Object)new byte[0], (Object)new byte[valueSize + 1]);
        Assertions.assertEquals(RecordTooLargeException.class, Assertions.assertThrows(ExecutionException.class, () -> producer.send(record1).get()).getCause().getClass());
    }

    public static final /* synthetic */ Future $anonfun$testBatchSizeZeroNoPartitionNoRecordKey$1(PlaintextProducerSendTest $this, KafkaProducer producer$2, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), null, (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return producer$2.send(record);
    }

    public static final /* synthetic */ int $anonfun$testBatchSizeZeroNoPartitionNoRecordKey$2(PlaintextProducerSendTest $this, int offset, Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get();
        Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        return offset + 1;
    }

    private final Future send$1(KafkaProducer producer) {
        return producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)new byte[1000]));
    }

    public static final /* synthetic */ boolean $anonfun$testNonBlockingProducer$2(Future future) {
        if (future.isDone()) {
            try {
                future.get();
                return true;
            }
            catch (ExecutionException executionException) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Future sendUntilQueued$1(KafkaProducer producer) {
        void var3_7;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Future computeUntilTrue_result;
            if (PlaintextProducerSendTest.$anonfun$testNonBlockingProducer$2(computeUntilTrue_result = this.send$1(producer))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var10_5 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Future future = (Future)tuple22._1();
        return var3_7;
    }

    private final void verifySendSuccess$1(Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get(30L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)this.topic(), (Object)recordMetadata.topic());
        Assertions.assertEquals((int)0, (int)recordMetadata.partition());
        Assertions.assertTrue((recordMetadata.offset() >= 0L ? 1 : 0) != 0, (String)new StringBuilder(15).append("Invalid offset ").append(recordMetadata).toString());
    }

    private static final void verifyMetadataNotAvailable$1(Future future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals(TimeoutException.class, Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause().getClass());
    }

    private static final void verifyBufferExhausted$1(Future future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals(BufferExhaustedException.class, Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause().getClass());
    }

    public static final /* synthetic */ Object $anonfun$testNonBlockingProducer$2$adapted(Future future) {
        return BoxesRunTime.boxToBoolean((boolean)PlaintextProducerSendTest.$anonfun$testNonBlockingProducer$2(future));
    }
}

