/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import kafka.log.LocalLog$;
import kafka.log.LogLoader$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogMetricNames$;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.log.remote.RemoteLogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.TestUtils$;
import org.apache.directory.api.util.FileUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileIntRef;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\tMh\u0001\u0002\"D\u0001!CQa\u0014\u0001\u0005\u0002ACqa\u0015\u0001C\u0002\u0013\u0005A\u000b\u0003\u0004c\u0001\u0001\u0006I!\u0016\u0005\bG\u0002\u0011\r\u0011\"\u0001e\u0011\u0019A\u0007\u0001)A\u0005K\"9\u0011\u000e\u0001b\u0001\n\u0003!\u0007B\u00026\u0001A\u0003%Q\rC\u0004l\u0001\t\u0007I\u0011\u00017\t\rQ\u0004\u0001\u0015!\u0003n\u0011\u001d)\bA1A\u0005\u0002YDq!!\u0001\u0001A\u0003%q\u000fC\u0006\u0002\u0004\u0001\u0001\r\u00111A\u0005\u0002\u0005\u0015\u0001bCA\n\u0001\u0001\u0007\t\u0019!C\u0001\u0003+A1\"!\t\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\b!Y\u00111\u0005\u0001A\u0002\u0003\u0007I\u0011AA\u0013\u0011-\ti\u0003\u0001a\u0001\u0002\u0004%\t!a\f\t\u0017\u0005M\u0002\u00011A\u0001B\u0003&\u0011q\u0005\u0005\n\u0003k\u0001!\u0019!C\u0001\u0003oA\u0001\"!\u0012\u0001A\u0003%\u0011\u0011\b\u0005\n\u0003\u000f\u0002!\u0019!C\u0001\u0003\u0013B\u0001\"!\u0015\u0001A\u0003%\u00111\n\u0005\b\u0003'\u0002A\u0011AA+\u0011\u001d\ti\u0007\u0001C\u0001\u0003+Bq!a\u001e\u0001\t\u0003\t)\u0006C\u0004\u0002\u0002\u0002!\t!!\u0016\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002V!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005U\u0003bBAG\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0003#\u0003A\u0011AA+\u0011\u001d\t)\n\u0001C\u0001\u0003+Bq!!'\u0001\t\u0003\t)\u0006C\u0004\u0002\u001e\u0002!\t!!\u0016\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002V!9\u0011Q\u0015\u0001\u0005\n\u0005\u001d\u0006bBAa\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0003\u000b\u0004A\u0011AA+\u0011\u001d\tI\r\u0001C\u0001\u0003+Bq!!4\u0001\t\u0003\t)\u0006C\u0004\u0002R\u0002!\t!!\u0016\t\u000f\u0005U\u0007\u0001\"\u0001\u0002V!9\u0011\u0011\u001c\u0001\u0005\u0002\u0005U\u0003bBAo\u0001\u0011%\u0011q\u001c\u0005\b\u0005\u000f\u0001A\u0011\u0002B\u0005\u0011%\u00119\u0003AI\u0001\n\u0013\u0011I\u0003C\u0005\u0003@\u0001\t\n\u0011\"\u0003\u0003B!I!Q\t\u0001\u0012\u0002\u0013%!q\t\u0005\b\u0005\u0017\u0002A\u0011AA+\u0011\u001d\u0011y\u0005\u0001C\u0001\u0003+BqAa\u0015\u0001\t\u0003\t)\u0006C\u0004\u0003X\u0001!IA!\u0017\t\u0013\tE\u0004!%A\u0005\n\t\u001d\u0003b\u0002B:\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0005o\u0002A\u0011AA+\u0011\u001d\u0011Y\b\u0001C\u0001\u0003+BqAa \u0001\t\u0003\t)\u0006C\u0004\u0003\u0004\u0002!\t!!\u0016\t\u000f\t\u001d\u0005\u0001\"\u0003\u0003\n\"9!Q\u0015\u0001\u0005\n\t\u001d\u0006b\u0002B_\u0001\u0011%!q\u0018\u0005\b\u00053\u0004A\u0011\u0002Bn\u0011\u001d\u0011y\u000e\u0001C\u0001\u0003+BqAa9\u0001\t\u0003\t)\u0006C\u0004\u0003h\u0002!\t!!\u0016\t\u000f\t-\b\u0001\"\u0001\u0002V!9!q\u001e\u0001\u0005\u0002\u0005U#A\u0004'pO6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\t\u0016\u000b1\u0001\\8h\u0015\u00051\u0015!B6bM.\f7\u0001A\n\u0003\u0001%\u0003\"AS'\u000e\u0003-S\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d.\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001R!\t\u0011\u0006!D\u0001D\u0003\u0011!\u0018.\\3\u0016\u0003U\u0003\"A\u00161\u000e\u0003]S!\u0001W-\u0002\tU$\u0018\u000e\u001c\u0006\u00035n\u000baa]3sm\u0016\u0014(B\u0001$]\u0015\tif,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002?\u0006\u0019qN]4\n\u0005\u0005<&\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u001f5\f\u0007PU8mY&sG/\u001a:wC2,\u0012!\u001a\t\u0003\u0015\u001aL!aZ&\u0003\u0007%sG/\u0001\tnCb\u0014v\u000e\u001c7J]R,'O^1mA\u0005YQ.\u0019=M_\u001e\fu-Z't\u00031i\u0017\r\u001f'pO\u0006;W-T:!\u0003!awn\u001a)s_B\u001cX#A7\u0011\u00059\u0014X\"A8\u000b\u0005a\u0003(\"A9\u0002\t)\fg/Y\u0005\u0003g>\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0003%awn\u001a)s_B\u001c\b%A\u0005m_\u001e\u001cuN\u001c4jOV\tq\u000f\u0005\u0002y}6\t\u0011P\u0003\u0002Eu*\u00111\u0010`\u0001\nS:$XM\u001d8bYNT!!`.\u0002\u000fM$xN]1hK&\u0011q0\u001f\u0002\n\u0019><7i\u001c8gS\u001e\f!\u0002\\8h\u0007>tg-[4!\u0003\u0019awn\u001a#jeV\u0011\u0011q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u00029\u0002\u0005%|\u0017\u0002BA\t\u0003\u0017\u0011AAR5mK\u0006QAn\\4ESJ|F%Z9\u0015\t\u0005]\u0011Q\u0004\t\u0004\u0015\u0006e\u0011bAA\u000e\u0017\n!QK\\5u\u0011%\ty\"DA\u0001\u0002\u0004\t9!A\u0002yIE\nq\u0001\\8h\t&\u0014\b%\u0001\u0006m_\u001el\u0015M\\1hKJ,\"!a\n\u0011\u0007I\u000bI#C\u0002\u0002,\r\u0013!\u0002T8h\u001b\u0006t\u0017mZ3s\u00039awnZ'b]\u0006<WM]0%KF$B!a\u0006\u00022!I\u0011q\u0004\t\u0002\u0002\u0003\u0007\u0011qE\u0001\fY><W*\u00198bO\u0016\u0014\b%\u0001\u0003oC6,WCAA\u001d!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA a\u0006!A.\u00198h\u0013\u0011\t\u0019%!\u0010\u0003\rM#(/\u001b8h\u0003\u0015q\u0017-\\3!\u0003e1XM]=MCJ<W\rT8h\r2,8\u000f[%oi\u0016\u0014h/\u00197\u0016\u0005\u0005-\u0003c\u0001&\u0002N%\u0019\u0011qJ&\u0003\t1{gnZ\u0001\u001bm\u0016\u0014\u0018\u0010T1sO\u0016dun\u001a$mkND\u0017J\u001c;feZ\fG\u000eI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003/A3AFA-!\u0011\tY&!\u001b\u000e\u0005\u0005u#\u0002BA0\u0003C\n1!\u00199j\u0015\u0011\t\u0019'!\u001a\u0002\u000f),\b/\u001b;fe*\u0019\u0011q\r0\u0002\u000b),h.\u001b;\n\t\u0005-\u0014Q\f\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007]\t\t\b\u0005\u0003\u0002\\\u0005M\u0014\u0002BA;\u0003;\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u001bQ,7\u000f^\"sK\u0006$X\rT8hQ\rA\u00121\u0010\t\u0005\u00037\ni(\u0003\u0003\u0002\u0000\u0005u#\u0001\u0002+fgR\fA\u0005^3ti\"\u000bg\u000e\u001a7j]\u001e,\u0005pY3qi&|gn\u001d#ve&twm\u00155vi\u0012|wO\u001c\u0015\u00043\u0005m\u0014\u0001\u0010;fgR\u001cE.Z1o'\",H\u000fZ8x]\u001aKG.Z,iK:\u001c\u0006.\u001e;e_^t7)\u00197mK\u0012\u0014UMZ8sKN#\u0018M\u001d;va\u000e{W\u000e\u001d7fi\u0016D3AGA>\u0003y!Xm\u001d;De\u0016\fG/\u001a'pO^KG\u000f[%om\u0006d\u0017\u000e\u001a'pO\u0012K'\u000fK\u0002\u001c\u0003w\nq\u0004^3ti\u000e\u0013X-\u0019;f\u0019><w+\u001b;i\u0019><G)\u001b:GC2d'-Y2lQ\ra\u00121P\u0001\u0016i\u0016\u001cHoR3u\u001d>tW\t_5ti\u0016tG\u000fT8hQ\ri\u00121P\u0001\u001bi\u0016\u001cHo\u00117fC:,\b/\u0012=qSJ,GmU3h[\u0016tGo\u001d\u0015\u0004=\u0005m\u0014!\t;fgR\u001cE.Z1okB\u001cVmZ7f]R\u001cHk\\'bS:$\u0018-\u001b8TSj,\u0007fA\u0010\u0002|\u0005QC/Z:u\t>,7O\u001c;DY\u0016\fg\u000eT8hg^KG\u000f[\"p[B\f7\r\u001e#fY\u0016$X\rU8mS\u000eL\bf\u0001\u0011\u0002|\u0005!C/Z:u\t>,7O\u001c;DY\u0016\fg\u000eT8hg^KG\u000f[\"p[B\f7\r\u001e)pY&\u001c\u0017\u0010K\u0002\"\u0003w\n1\u0003^3ti\u0012{Wm\u001d8u\u00072,\u0017M\u001c'pON$B!a\u0006\u0002*\"9\u00111\u0016\u0012A\u0002\u00055\u0016A\u00029pY&\u001c\u0017\u0010\u0005\u0003\u00020\u0006uf\u0002BAY\u0003s\u00032!a-L\u001b\t\t)LC\u0002\u00028\u001e\u000ba\u0001\u0010:p_Rt\u0014bAA^\u0017\u00061\u0001K]3eK\u001aLA!a\u0011\u0002@*\u0019\u00111X&\u0002%Q,7\u000f\u001e+j[\u0016\u0014\u0015m]3e\r2,8\u000f\u001b\u0015\u0004G\u0005m\u0014!\u0007;fgRdU-Y:u\u0019>\fG-\u001a3BgNLwM\\7f]RD3\u0001JA>\u0003\u0001\"Xm\u001d;M_\u0006$Gj\\4t'.L\u0007OU3n_R,\u0017J\u001c3fq\u000e\u000b7\r[3)\u0007\u0015\nY(A\u0012uKN$Hk^8M_\u001el\u0015M\\1hKJ\u001cXk]5oON\u000bW.\u001a#je\u001a\u000b\u0017\u000e\\:)\u0007\u0019\nY(\u0001\u000fuKN$8\t[3dWB|\u0017N\u001c;SK\u000e|g/\u001a:z!>Lg\u000e^:)\u0007\u001d\nY(A\u0017uKN$(+Z2pm\u0016\u0014\u0018\u0010R5sK\u000e$xN]=NCB\u0004\u0018N\\4XSRDGK]1jY&twm\u00157bg\"D3\u0001KA>\u0003E\"Xm\u001d;SK\u000e|g/\u001a:z\t&\u0014Xm\u0019;pefl\u0015\r\u001d9j]\u001e<\u0016\u000e\u001e5SK2\fG/\u001b<f\t&\u0014Xm\u0019;pefD3!KA>\u0003a1XM]5gs\u000eCWmY6q_&tGOU3d_Z,'/\u001f\u000b\t\u0003/\t\tOa\u0001\u0003\u0006!9\u00111\u001d\u0016A\u0002\u0005\u0015\u0018a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\r\u0005\u001d\u0018\u0011_A|\u001d\u0011\tI/!<\u000f\t\u0005M\u00161^\u0005\u0002\u0019&\u0019\u0011q^&\u0002\u000fA\f7m[1hK&!\u00111_A{\u0005\r\u0019V-\u001d\u0006\u0004\u0003_\\\u0005\u0003BA}\u0003\u007fl!!a?\u000b\u0007\u0005u8,\u0001\u0004d_6lwN\\\u0005\u0005\u0005\u0003\tYP\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005\r\"\u00061\u0001\u0002(!9\u00111\u0001\u0016A\u0002\u0005\u001d\u0011\u0001E2sK\u0006$X\rT8h\u001b\u0006t\u0017mZ3s)!\t9Ca\u0003\u0003\u0012\t\r\u0002\"\u0003B\u0007WA\u0005\t\u0019\u0001B\b\u0003\u001dawn\u001a#jeN\u0004b!a:\u0002r\u0006\u001d\u0001\"\u0003B\nWA\u0005\t\u0019\u0001B\u000b\u0003A\u0019wN\u001c4jOJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0003\u0018\t}QB\u0001B\r\u0015\u0011\u0011YB!\b\u0002\u00115,G/\u00193bi\u0006T!AW#\n\t\t\u0005\"\u0011\u0004\u0002\u0011\u0007>tg-[4SKB|7/\u001b;pefD\u0001B!\n,!\u0003\u0005\r!Z\u0001\u001ae\u0016\u001cwN^3ssRC'/Z1egB+'\u000fR1uC\u0012K'/\u0001\u000ede\u0016\fG/\u001a'pO6\u000bg.Y4fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003,)\"!q\u0002B\u0017W\t\u0011y\u0003\u0005\u0003\u00032\tmRB\u0001B\u001a\u0015\u0011\u0011)Da\u000e\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u001d\u0017\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tu\"1\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AG2sK\u0006$X\rT8h\u001b\u0006t\u0017mZ3sI\u0011,g-Y;mi\u0012\u0012TC\u0001B\"U\u0011\u0011)B!\f\u00025\r\u0014X-\u0019;f\u0019><W*\u00198bO\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t%#fA3\u0003.\u0005\u0011C/Z:u\r&dWMU3gKJ,gnY3t\u0003\u001a$XM]!ts:\u001cG)\u001a7fi\u0016D3aLA>\u0003\t\"Xm\u001d;De\u0016\fG/Z!oI\u0012+G.\u001a;f\u001fZ,'\u000f\\=M_:<Gk\u001c9jG\"\u001a\u0001'a\u001f\u0002CQ,7\u000f^\"iK\u000e\\\u0007o\\5oi\u001a{'o\u00148ms\u00063g-Z2uK\u0012dunZ:)\u0007E\nY(A\u0004sK\u0006$Gj\\4\u0015\u0011\tm#\u0011\rB5\u0005[\u00022\u0001\u001fB/\u0013\r\u0011y&\u001f\u0002\u000e\r\u0016$8\r\u001b#bi\u0006LeNZ8\t\r\u0011\u0013\u0004\u0019\u0001B2!\r\u0011&QM\u0005\u0004\u0005O\u001a%AC+oS\u001aLW\r\u001a'pO\"9!1\u000e\u001aA\u0002\u0005-\u0013AB8gMN,G\u000f\u0003\u0005\u0003pI\u0002\n\u00111\u0001f\u0003%i\u0017\r\u001f'f]\u001e$\b.A\tsK\u0006$Gj\\4%I\u00164\u0017-\u001e7uIM\nQ\u0005^3tiR{\u0007/[2D_:4\u0017nZ\"iC:<W-\u00169eCR,7\u000fT8h\u0007>tg-[4)\u0007Q\nY(A\u000fuKN$8i\u001c8gS\u001e\u001c\u0005.\u00198hK\u001e+Go]\"mK\u0006tW\rZ+qQ\r)\u00141P\u0001)i\u0016\u001cHO\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\u0005.\u00198hK\u0012+G.\u001b<fe\u0016$Gk\\!mY2{wm\u001d\u0015\u0004m\u0005m\u0014a\r;fgR$v\u000e]5d\u0007>tg-[4DQ\u0006tw-Z*u_B\u001cE.Z1oS:<\u0017JZ\"p[B\f7\r^%t%\u0016lwN^3eQ\r9\u00141P\u0001-i\u0016\u001cHoQ8oM&<7\t[1oO\u0016\u001cx+\u001b;i\u001d>dunZ$fiRLgnZ%oSRL\u0017\r\\5{K\u0012D3\u0001OA>\u0003I\t\u0007\u000f]3oIJ+7m\u001c:egR{Gj\\4\u0015\u0019\u0005]!1\u0012BG\u0005#\u0013)J!)\t\u000bMK\u0004\u0019A+\t\u000f\t=\u0015\b1\u0001\u0002\b\u0005a\u0001/\u0019:f]Rdun\u001a#je\"1!1S\u001dA\u0002\u0015\f1\u0002]1si&$\u0018n\u001c8JI\"9!qS\u001dA\u0002\te\u0015\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t!\u0011\u0011YJ!(\u000e\u0005\tu\u0011\u0002\u0002BP\u0005;\u0011\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\t\r\t\r\u0016\b1\u0001f\u0003Y)\u0007\u0010]3di\u0016$7+Z4nK:$8\u000fU3s\u0019><\u0017A\t<fe&4\u0017PU3nC&t\u0017N\\4M_\u001e\u001cHk\u001c*fG>4XM]'fiJL7\r\u0006\u0004\u0002\u0018\t%&Q\u0016\u0005\b\u0005WS\u0004\u0019AA\u0014\u00035\u0019\b/\u001f'pO6\u000bg.Y4fe\"9!q\u0016\u001eA\u0002\tE\u0016AD3ya\u0016\u001cG/\u001a3QCJ\fWn\u001d\t\b\u0005g\u0013I,!,f\u001b\t\u0011)LC\u0002\u00038.\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011YL!.\u0003\u00075\u000b\u0007/\u0001\u0014wKJLg-\u001f*f[\u0006Lg.\u001b8h'\u0016<W.\u001a8ugR{'+Z2pm\u0016\u0014X*\u001a;sS\u000e$B\"a\u0006\u0003B\n\r'Q\u0019Bd\u0005/DqAa+<\u0001\u0004\t9\u0003C\u0004\u0003\u000em\u0002\rAa\u0004\t\r\t\u00152\b1\u0001f\u0011\u001d\u0011Im\u000fa\u0001\u0005\u0017\fq!\\8dW6\u000b\u0007\u000fE\u0004\u0003N\nM\u0017QV3\u000e\u0005\t='b\u0001Bi_\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\tU'q\u001a\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bb\u0002BXw\u0001\u0007!\u0011W\u0001\u001fm\u0016\u0014\u0018NZ=M_\u001e\u0014VmY8wKJlU\r\u001e:jGN\u0014V-\\8wK\u0012$B!a\u0006\u0003^\"9!1\u0016\u001fA\u0002\u0005\u001d\u0012A\u0006;fgRdun\u001a*fG>4XM]=NKR\u0014\u0018nY:)\u0007u\nY(\u0001\u001cuKN$Hj\\4SK\u000e|g/\u001a:z\u001b\u0016$(/[2t'\"|W\u000f\u001c3CKJ+Wn\u001c<fI\u00063G/\u001a:M_\u001e\u0014VmY8wKJ,G\rK\u0002?\u0003w\n\u0001\u0007^3ti6+GO]5dg\u0016C\u0018n\u001d;XQ\u0016tGj\\4JgJ+7M]3bi\u0016$')\u001a4pe\u0016$U\r\\3uS>t\u0007fA \u0002|\u0005\tD/Z:u\u001b\u0016$(/[2t\u0003J,'+Z7pm\u0016$w\u000b[3o\u001b>4\u0018N\\4DkJ\u0014XM\u001c;U_\u001a+H/\u001e:f\u0019><\u0007f\u0001!\u0002|\u0005AB/Z:u/\u0006LGOR8s\u00032dGk\\\"p[BdW\r^3)\u0007\u0005\u000bY\b")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository(), 1));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
    }

    @AfterEach
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir());
        if (this.logManager() != null) {
            this.logManager().liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
                LogManagerTest.$anonfun$tearDown$1(x$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        Assertions.assertEquals((int)1, (int)this.logManager().liveLogDirs().size());
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    @Test
    public void testHandlingExceptionsDuringShutdown() {
        File logDir1 = TestUtils.tempDirectory(null, null);
        File logDir2 = TestUtils.tempDirectory(null, null);
        Option logManagerForTest = Option$.MODULE$.empty();
        try {
            logManagerForTest = new Some((Object)this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$)), new MockConfigRepository(), 1));
            Assertions.assertEquals((int)2, (int)((LogManager)logManagerForTest.get()).liveLogDirs().size());
            ((LogManager)logManagerForTest.get()).startup((Set)Predef$.MODULE$.Set().empty());
            LogManager qual$1 = (LogManager)logManagerForTest.get();
            TopicPartition x$1 = new TopicPartition(this.name(), 0);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            UnifiedLog log1 = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            LogManager qual$2 = (LogManager)logManagerForTest.get();
            TopicPartition x$5 = new TopicPartition(this.name(), 1);
            None$ x$6 = None$.MODULE$;
            boolean x$7 = qual$2.getOrCreateLog$default$2();
            boolean x$8 = qual$2.getOrCreateLog$default$3();
            UnifiedLog log2 = qual$2.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
            File logFile1 = new File(logDir1, new StringBuilder(2).append(this.name()).append("-0").toString());
            Assertions.assertTrue((boolean)logFile1.exists());
            Assertions.assertTrue((boolean)new File(logDir2, new StringBuilder(2).append(this.name()).append("-1").toString()).exists());
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5(), log1.appendAsLeader$default$6());
            log1.takeProducerSnapshot();
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5(), log1.appendAsLeader$default$6());
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5(), log2.appendAsLeader$default$6());
            log2.takeProducerSnapshot();
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5(), log2.appendAsLeader$default$6());
            FileUtils.deleteDirectory((File)logFile1);
            ((LogManager)logManagerForTest.get()).shutdown();
            Assertions.assertFalse((boolean)Files.exists(new File(logDir1, LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
            Assertions.assertTrue((boolean)Files.exists(new File(logDir2, LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
        }
        finally {
            logManagerForTest.foreach((Function1 & Serializable)manager -> {
                LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$1(manager);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete() {
        TopicPartition topicPartition0 = new TopicPartition(this.name(), 0);
        TopicPartition topicPartition1 = new TopicPartition(this.name(), 1);
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log0 = qual$1.getOrCreateLog(topicPartition0, x$3, x$4, (Option)x$2);
        LogManager qual$2 = this.logManager();
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$2.getOrCreateLog$default$2();
        boolean x$8 = qual$2.getOrCreateLog$default$3();
        UnifiedLog log1 = qual$2.getOrCreateLog(topicPartition1, x$7, x$8, (Option)x$6);
        File logFile0 = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString());
        File logFile1 = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-1").toString());
        Assertions.assertTrue((boolean)logFile0.exists());
        Assertions.assertTrue((boolean)logFile1.exists());
        log0.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log0.appendAsLeader$default$3(), log0.appendAsLeader$default$4(), log0.appendAsLeader$default$5(), log0.appendAsLeader$default$6());
        log0.takeProducerSnapshot();
        log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5(), log1.appendAsLeader$default$6());
        log1.takeProducerSnapshot();
        this.logManager().shutdown();
        Assertions.assertTrue((boolean)Files.deleteIfExists(new File(this.logDir(), LogLoader$.MODULE$.CleanShutdownFile()).toPath()));
        VolatileIntRef loadLogCalled = VolatileIntRef.create((int)0);
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository(), 1)));
        ((LogManager)Mockito.doAnswer(invocation -> {
            LogManagerTest.$anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$1(loadLogCalled, invocation);
            return BoxedUnit.UNIT;
        }).when((Object)this.logManager())).loadLog((File)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (LogConfig)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        new Thread(this){
            private final /* synthetic */ LogManagerTest $outer;

            public void run() {
                this.$outer.logManager().startup((Set)Predef$.MODULE$.Set().empty());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }.start();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(loadLogCalled.elem == 1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for only the first log to be loaded");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.logManager().shutdown();
        this.logManager_$eq(null);
        Assertions.assertFalse((boolean)Files.exists(new File(this.logDir(), LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        .colon.colon dirs = new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)new File("\u0000"), (List)Nil$.MODULE$));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$3 = None$.MODULE$;
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, true, x$4, (Option)x$3);
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    @Test
    public void testCreateLogWithLogDirFallback() {
        IndexedSeq dirs = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)x$3 -> LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$1(BoxesRunTime.unboxToInt((Object)x$3))).map((Function1 & Serializable)x$4 -> this.logDir().toPath().resolve((String)x$4).toFile());
        this.logManager().shutdown();
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1)));
        scala.collection.mutable.Set brokenDirs = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File logDir = (File)invocation.getArgument(0);
            if (brokenDirs.contains((Object)logDir) || brokenDirs.size() < dirs.length() / 2) {
                brokenDirs.add((Object)logDir);
                return new Failure(new Throwable("broken dir"));
            }
            return (Try)invocation.callRealMethod();
        }).when((Object)this.logManager())).createLogDirectory((File)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$32 = None$.MODULE$;
        boolean x$42 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$1, true, x$42, (Option)x$32);
        Assertions.assertEquals((int)(dirs.length() / 2), (int)brokenDirs.size());
        Function1 & Serializable containsLogFile = (Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$4(this, dir));
        Assertions.assertEquals((int)1, (int)dirs.count((Function1)containsLogFile), (String)"More than one log file created");
        Assertions.assertFalse((boolean)brokenDirs.exists((Function1)containsLogFile));
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log, (String)"No log should be found.");
        Assertions.assertFalse((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupExpiredSegments() {
        void readLog_maxLength;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
            offset$1.elem = info.lastOffset();
        });
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.updateHighWatermark(log.logEndOffset());
        log.logSegments().foreach((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCleanupExpiredSegments$2(this, x$6)));
        this.time().sleep((long)(this.maxLogAgeMs() + 1));
        Assertions.assertEquals((int)1, (int)log.numberOfSegments(), (String)"Now there should only be only one segment in the index.");
        this.time().sleep(log.config().fileDeleteDelayMs + 1L);
        log.logSegments().foreach((Function1 & Serializable)s -> {
            s.lazyOffsetIndex().get();
            return (TimeIndex)s.lazyTimeIndex().get();
        });
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        int n = 1024;
        long readLog_offset = offset.elem + 1L;
        Assertions.assertEquals((int)0, (int)log.read((long)readLog_offset, (int)readLog_maxLength, (FetchIsolation)FetchIsolation.LOG_END, (boolean)true).records.sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> {
            void readLog_maxLength;
            int n = 1024;
            long readLog_offset = 0L;
            log.read(readLog_offset, (int)readLog_maxLength, FetchIsolation.LOG_END, true);
        }, () -> "Should get exception from fetching earlier.");
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupSegmentsToMaintainSize() {
        void readLog_maxLength;
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes();
        this.logManager().shutdown();
        int segmentBytes = 10 * setSize;
        Properties properties = new Properties();
        properties.put("segment.bytes", Integer.toString(segmentBytes));
        properties.put("retention.bytes", Long.toString(50L * (long)setSize + 10L));
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), properties);
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = 1;
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$4 = new TopicPartition(this.name(), 0);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = qual$1.getOrCreateLog$default$2();
        boolean x$72 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$4, x$6, x$72, (Option)x$5);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
            offset$2.elem = ((LogOffsetMetadata)info.firstOffset().get()).messageOffset;
        });
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertEquals((int)(numMessages * setSize / segmentBytes), (int)log.numberOfSegments(), (String)"Check we have the expected number of segments.");
        this.time().sleep((long)this.logManager().InitialTaskDelayMs());
        Assertions.assertEquals((int)6, (int)log.numberOfSegments(), (String)"Now there should be exactly 6 segments");
        this.time().sleep(log.config().fileDeleteDelayMs + 1L);
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        int n = 1024;
        long readLog_offset = offset.elem + 1L;
        Assertions.assertEquals((int)0, (int)log.read((long)readLog_offset, (int)readLog_maxLength, (FetchIsolation)FetchIsolation.LOG_END, (boolean)true).records.sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> {
            void readLog_maxLength;
            int n = 1024;
            long readLog_offset = 0L;
            log.read(readLog_offset, (int)readLog_maxLength, FetchIsolation.LOG_END, true);
        });
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs("compact,delete");
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs("compact");
    }

    private void testDoesntCleanLogs(String policy) {
        this.logManager().shutdown();
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), "cleanup.policy", policy);
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = 1;
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3));
        LogManager qual$1 = this.logManager();
        TopicPartition x$4 = new TopicPartition(this.name(), 0);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = qual$1.getOrCreateLog$default$2();
        boolean x$7 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$4, x$6, x$7, (Option)x$5);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
            offset$3.elem = info.lastOffset();
        });
        int numSegments = log.numberOfSegments();
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.logSegments().foreach((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testDoesntCleanLogs$2(this, x$9)));
        this.time().sleep((long)(this.maxLogAgeMs() + 1));
        Assertions.assertEquals((int)numSegments, (int)log.numberOfSegments(), (String)"number of segments shouldn't have changed");
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), "flush.ms", "1000");
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = 1;
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$4 = new TopicPartition(this.name(), 0);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = qual$1.getOrCreateLog$default$2();
        boolean x$7 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$4, x$6, x$7, (Option)x$5);
        long lastFlush = log.lastFlushTime();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1 & Serializable)x$10 -> LogManagerTest.$anonfun$testTimeBasedFlush$1(log, BoxesRunTime.unboxToInt((Object)x$10)));
        this.time().sleep((long)this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((lastFlush != log.lastFlushTime() ? 1 : 0) != 0, (String)"Time based flush should have been triggered");
    }

    @Test
    public void testLeastLoadedAssignment() {
        .colon.colon dirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$)));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> {
            LogManager qual$1 = this.logManager();
            TopicPartition x$1 = new TopicPartition("test", partition);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            Assertions.assertEquals((int)(partition + 1), (int)this.logManager().allLogs().size(), (String)"We should have created the right number of logs");
            Iterable counts = (Iterable)this.logManager().allLogs().groupBy((Function1 & Serializable)x$11 -> x$11.dir().getParent()).values().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.size()));
            Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0, (String)"Load should balance evenly");
        });
    }

    @Test
    public void testLoadLogsSkipRemoteIndexCache() {
        File logDir = TestUtils.tempDirectory(null, null);
        new File(logDir, "remote-log-index-cache").mkdir();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)logDir, (List)Nil$.MODULE$), new MockConfigRepository(), 1));
        this.logManager().loadLogs(this.logConfig(), (Map)Map$.MODULE$.empty());
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        Assertions.assertThrows(KafkaException.class, () -> this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository(), 1));
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)new File(new StringBuilder(0).append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append(File.separator).toString()), (List)Nil$.MODULE$), TestUtils$.MODULE$.createLogManager$default$2(), new MockConfigRepository(), new CleanerConfig(false), new MockTime(), MetadataVersion.latest(), 4, false, (Option<UnifiedLog>)None$.MODULE$));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)new File("data", this.logDir().getName()).getAbsoluteFile(), (List)Nil$.MODULE$), new MockConfigRepository(), 1));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(scala.collection.immutable.Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        scala.collection.immutable.Seq logs = (scala.collection.immutable.Seq)topicPartitions.map((Function1 & Serializable)x$13 -> {
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            return logManager.getOrCreateLog(x$13, x$3, x$4, (Option)x$2);
        });
        logs.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$2(log);
            return BoxedUnit.UNIT;
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), null).read();
        ((IterableOnceOps)topicPartitions.zip((IterableOnce)logs)).foreach((Function1 & Serializable)x0$1 -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private LogManager createLogManager(scala.collection.immutable.Seq<File> logDirs, ConfigRepository configRepository, int recoveryThreadsPerDataDir) {
        LogConfig x$1 = this.logConfig();
        MockTime x$4 = this.time();
        CleanerConfig x$6 = new CleanerConfig(false);
        MetadataVersion x$7 = MetadataVersion.latest();
        boolean x$8 = false;
        None$ x$9 = None$.MODULE$;
        return TestUtils$.MODULE$.createLogManager((Seq<File>)logDirs, x$1, configRepository, x$6, x$4, x$7, recoveryThreadsPerDataDir, x$8, (Option<UnifiedLog>)x$9);
    }

    private scala.collection.immutable.Seq<File> createLogManager$default$1() {
        return new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$);
    }

    private ConfigRepository createLogManager$default$2() {
        return new MockConfigRepository();
    }

    private int createLogManager$default$3() {
        return 1;
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        LogSegment activeSegment = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2).activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        Object[] indexFilesOnDiskBeforeDelete = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])activeSegment.log().file().getParentFile().listFiles()), (Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$1(x$15)));
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        boolean x$8 = qual$2.asyncDelete$default$4();
        UnifiedLog removedLog = (UnifiedLog)qual$2.asyncDelete(x$5, x$6, x$7, x$8).get();
        LogSegment removedSegment = removedLog.activeSegment();
        .colon.colon indexFilesAfterDelete = new .colon.colon((Object)removedSegment.lazyOffsetIndex().file(), (List)new .colon.colon((Object)removedSegment.lazyTimeIndex().file(), (List)new .colon.colon((Object)removedSegment.txnIndex().file(), (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.lazyOffsetIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.lazyTimeIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(indexFilesOnDiskBeforeDelete), arg_0 -> LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2$adapted((scala.collection.immutable.Seq)indexFilesAfterDelete, arg_0));
        this.time().sleep((long)this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs deleted too early");
        this.time().sleep(this.logManager().currentDefaultConfig().fileDeleteDelayMs - (long)this.logManager().InitialTaskDelayMs());
        Assertions.assertFalse((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs not deleted");
    }

    @Test
    public void testCreateAndDeleteOverlyLongTopic() {
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(253, "x"));
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(invalidTopicName, 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(invalidTopicName, 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        boolean x$8 = qual$2.asyncDelete$default$4();
        qual$2.asyncDelete(x$5, x$6, x$7, x$8);
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        .colon.colon tps = new .colon.colon((Object)new TopicPartition("test-a", 0), (List)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-a", 2), (List)new .colon.colon((Object)new TopicPartition("test-b", 0), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)))));
        scala.collection.immutable.Seq allLogs = (scala.collection.immutable.Seq)tps.map((Function1 & Serializable)x$18 -> {
            LogManager qual$1 = this.logManager();
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            return qual$1.getOrCreateLog(x$18, x$3, x$4, (Option)x$2);
        });
        allLogs.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$2(log);
            return BoxedUnit.UNIT;
        });
        this.logManager().checkpointRecoveryOffsetsInDir(this.logDir());
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), null).read();
        ((IterableOnceOps)tps.zip((IterableOnce)allLogs)).foreach((Function1 & Serializable)x0$1 -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private FetchDataInfo readLog(UnifiedLog log, long offset, int maxLength) {
        return log.read(offset, maxLength, FetchIsolation.LOG_END, true);
    }

    private int readLog$default$3() {
        return 1024;
    }

    @Test
    public void testTopicConfigChangeUpdatesLogConfig() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = 1;
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        UnifiedLog mockLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.topicConfigUpdated(testTopicOne);
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicTwo);
    }

    @Test
    public void testConfigChangeGetsCleanedUp() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = 1;
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        TopicPartition testTopicPartition = new TopicPartition("test-topic", 1);
        spyLogManager.initializingLog(testTopicPartition);
        spyLogManager.finishedInitializingLog(testTopicPartition, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicPartition.topic());
    }

    @Test
    public void testBrokerConfigChangeDeliveredToAllLogs() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = 1;
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        UnifiedLog mockLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.brokerConfigUpdated();
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicTwo);
    }

    @Test
    public void testTopicConfigChangeStopCleaningIfCompactIsRemoved() {
        this.logManager().shutdown();
        MockConfigRepository x$1 = new MockConfigRepository();
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = 1;
        this.logManager_$eq(this.createLogManager(x$2, x$1, x$3));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        String topic = "topic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Properties oldProperties = new Properties();
        oldProperties.put("cleanup.policy", "compact");
        LogConfig oldLogConfig = LogConfig.fromProps((java.util.Map)this.logConfig().originals(), (Properties)oldProperties);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = spyLogManager.getOrCreateLog$default$2();
        boolean x$7 = spyLogManager.getOrCreateLog$default$3();
        UnifiedLog log0 = spyLogManager.getOrCreateLog(tp0, x$6, x$7, (Option)x$5);
        log0.updateConfig(oldLogConfig);
        None$ x$9 = None$.MODULE$;
        boolean x$10 = spyLogManager.getOrCreateLog$default$2();
        boolean x$11 = spyLogManager.getOrCreateLog$default$3();
        UnifiedLog log1 = spyLogManager.getOrCreateLog(tp1, x$10, x$11, (Option)x$9);
        log1.updateConfig(oldLogConfig);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnifiedLog[]{log0, log1})), (Object)spyLogManager.logsByTopic(topic).toSet());
        Properties newProperties = new Properties();
        newProperties.put("cleanup.policy", "delete");
        spyLogManager.updateTopicConfig(topic, newProperties, false);
        Assertions.assertTrue((boolean)log0.config().delete);
        Assertions.assertTrue((boolean)log1.config().delete);
        Assertions.assertFalse((boolean)log0.config().compact);
        Assertions.assertFalse((boolean)log1.config().compact);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).topicConfigUpdated(topic);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp0);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp1);
    }

    @Test
    public void testConfigChangesWithNoLogGettingInitialized() {
        this.logManager().brokerConfigUpdated();
        this.logManager().topicConfigUpdated("test-topic");
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
    }

    private void appendRecordsToLog(MockTime time, File parentLogDir, int partitionId, BrokerTopicStats brokerTopicStats, int expectedSegmentsPerLog) {
        File tpFile = new File(parentLogDir, new StringBuilder(1).append(this.name()).append("-").append(partitionId).toString());
        int segmentBytes = 1024;
        UnifiedLog log = LogTestUtils$.MODULE$.createLog(tpFile, this.logConfig(), brokerTopicStats, (Scheduler)time.scheduler, (Time)time, 0L, 0L, 300000, new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false), Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER);
        Assertions.assertTrue((expectedSegmentsPerLog > 0 ? 1 : 0) != 0);
        int numMessages = (int)Math.floor(segmentBytes * expectedSegmentsPerLog / LogManagerTest.createRecord$1(time).sizeInBytes());
        try {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable)x$20 -> log.appendAsLeader(LogManagerTest.createRecord$1(time), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
            Assertions.assertEquals((int)expectedSegmentsPerLog, (int)log.numberOfSegments());
        }
        finally {
            log.close();
        }
    }

    private void verifyRemainingLogsToRecoverMetric(LogManager spyLogManager, Map<String, Object> expectedParams) {
        String logManagerClassName = LogManager.class.getSimpleName();
        ArrayBuffer logMetrics = (ArrayBuffer)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$1(logManagerClassName, x0$1)))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                return (Metric)x0$2._2();
            }
            throw new MatchError(null);
        });
        Assertions.assertEquals((int)expectedParams.size(), (int)logMetrics.size());
        ArgumentCaptor capturedPath = ArgumentCaptor.forClass(String.class);
        int expectedCallTimes = BoxesRunTime.unboxToInt((Object)expectedParams.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)expectedCallTimes))).decNumRemainingLogs((ConcurrentMap)ArgumentMatchers.any(), (String)capturedPath.capture());
        java.util.List paths = capturedPath.getAllValues();
        expectedParams.foreach((Function1 & Serializable)x0$3 -> {
            LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$3(paths, x0$3);
            return BoxedUnit.UNIT;
        });
        logMetrics.foreach((Function1 & Serializable)gauge -> {
            LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$4(gauge);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyRemainingSegmentsToRecoverMetric(LogManager spyLogManager, scala.collection.immutable.Seq<File> logDirs, int recoveryThreadsPerDataDir, ConcurrentHashMap<String, Object> mockMap, Map<String, Object> expectedParams) {
        String logManagerClassName = LogManager.class.getSimpleName();
        ArrayBuffer logSegmentMetrics = (ArrayBuffer)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$1(logManagerClassName, x0$1)))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                return (Metric)x0$2._2();
            }
            throw new MatchError(null);
        });
        Assertions.assertEquals((int)(recoveryThreadsPerDataDir * logDirs.size()), (int)logSegmentMetrics.size());
        ArgumentCaptor capturedThreadName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor capturedNumRemainingSegments = ArgumentCaptor.forClass(Integer.TYPE);
        int expectedCallTimes = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)expectedParams.values().map((Function1)(JFunction1.mcII.sp & Serializable)num -> num + 1)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ((ConcurrentHashMap)Mockito.verify(mockMap, (VerificationMode)Mockito.times((int)expectedCallTimes))).put(capturedThreadName.capture(), capturedNumRemainingSegments.capture());
        logSegmentMetrics.foreach((Function1 & Serializable)gauge -> {
            LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$4(gauge);
            return BoxedUnit.UNIT;
        });
        java.util.List threadNames = capturedThreadName.getAllValues();
        java.util.List numRemainingSegments = capturedNumRemainingSegments.getAllValues();
        expectedParams.foreach((Function1 & Serializable)x0$3 -> {
            LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$5(threadNames, numRemainingSegments, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyLogRecoverMetricsRemoved(LogManager spyLogManager) {
        String spyLogManagerClassName = spyLogManager.getClass().getSimpleName();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$1(spyLogManagerClassName).isEmpty());
        Assertions.assertTrue((boolean)((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyLogRecoverMetricsRemoved$2(spyLogManagerClassName, metric)))).isEmpty());
    }

    @Test
    public void testLogRecoveryMetrics() {
        this.logManager().shutdown();
        File logDir1 = TestUtils.tempDirectory(null, null);
        File logDir2 = TestUtils.tempDirectory(null, null);
        .colon.colon logDirs = new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$));
        int recoveryThreadsPerDataDir = 2;
        MockConfigRepository x$3 = new MockConfigRepository();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)logDirs, x$3, recoveryThreadsPerDataDir));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Assertions.assertEquals((int)2, (int)spyLogManager.liveLogDirs().size());
        MockTime mockTime = new MockTime();
        ConcurrentHashMap mockMap = (ConcurrentHashMap)Mockito.mock(ConcurrentHashMap.class);
        BrokerTopicStats mockBrokerTopicStats = (BrokerTopicStats)Mockito.mock(BrokerTopicStats.class);
        int expectedSegmentsPerLog = 2;
        this.appendRecordsToLog(mockTime, logDir1, 0, mockBrokerTopicStats, expectedSegmentsPerLog);
        this.appendRecordsToLog(mockTime, logDir2, 1, mockBrokerTopicStats, expectedSegmentsPerLog);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File dir = (File)invocation.getArgument(0);
            scala.collection.mutable.Map topicConfigOverrides = (scala.collection.mutable.Map)invocation.getArgument(5);
            TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
            LogConfig config = (LogConfig)topicConfigOverrides.getOrElse((Object)topicPartition.topic(), (Function0 & Serializable)() -> this.logConfig());
            ProducerStateManagerConfig x$9 = new ProducerStateManagerConfig(300000, false);
            int x$10 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
            MockScheduler x$11 = mockTime$1.scheduler;
            LogDirFailureChannel x$14 = (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class);
            None$ x$16 = None$.MODULE$;
            boolean x$19 = false;
            LogOffsetsListener x$20 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
            return UnifiedLog$.MODULE$.apply(dir, config, 0L, 0L, (Scheduler)x$11, mockBrokerTopicStats, (Time)mockTime, 300000, x$9, x$10, x$14, false, (Option)x$16, false, (ConcurrentMap)mockMap, x$19, x$20);
        }).when((Object)spyLogManager)).loadLog((File)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (LogConfig)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.doNothing().when((Object)spyLogManager)).removeLogRecoveryMetrics();
        spyLogManager.startup((Set)Predef$.MODULE$.Set().empty());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).addLogRecoveryMetrics((ConcurrentMap)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).removeLogRecoveryMetrics();
        Map expectedRemainingLogsParams = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir1.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir2.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)1))}));
        this.verifyRemainingLogsToRecoverMetric(spyLogManager, (Map<String, Object>)expectedRemainingLogsParams);
        Map expectedRemainingSegmentsParams = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir1.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)expectedSegmentsPerLog)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir2.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)expectedSegmentsPerLog))}));
        this.verifyRemainingSegmentsToRecoverMetric(spyLogManager, (scala.collection.immutable.Seq<File>)logDirs, recoveryThreadsPerDataDir, mockMap, (Map<String, Object>)expectedRemainingSegmentsParams);
    }

    @Test
    public void testLogRecoveryMetricsShouldBeRemovedAfterLogRecovered() {
        this.logManager().shutdown();
        File logDir1 = TestUtils.tempDirectory(null, null);
        File logDir2 = TestUtils.tempDirectory(null, null);
        .colon.colon logDirs = new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$));
        int recoveryThreadsPerDataDir = 2;
        MockConfigRepository x$3 = new MockConfigRepository();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)logDirs, x$3, recoveryThreadsPerDataDir));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Assertions.assertEquals((int)2, (int)spyLogManager.liveLogDirs().size());
        spyLogManager.startup((Set)Predef$.MODULE$.Set().empty());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).addLogRecoveryMetrics((ConcurrentMap)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).removeLogRecoveryMetrics();
        this.verifyLogRecoverMetricsRemoved(spyLogManager);
    }

    @Test
    public void testMetricsExistWhenLogIsRecreatedBeforeDeletion() {
        String topicName = "metric-test";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        LogManager qual$2 = this.logManager();
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        boolean x$8 = qual$2.asyncDelete$default$4();
        UnifiedLog removedLog = (UnifiedLog)qual$2.asyncDelete(tp, x$6, x$7, x$8).get();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$2(topicName).isEmpty());
        LogManager qual$3 = this.logManager();
        None$ x$10 = None$.MODULE$;
        boolean x$11 = qual$3.getOrCreateLog$default$2();
        boolean x$12 = qual$3.getOrCreateLog$default$3();
        qual$3.getOrCreateLog(tp, x$11, x$12, (Option)x$10);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        this.time().sleep(this.logConfig().fileDeleteDelayMs + 1L);
        Assertions.assertTrue((boolean)removedLog.logSegments().isEmpty());
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
    }

    @Test
    public void testMetricsAreRemovedWhenMovingCurrentToFutureLog() {
        File dir1 = TestUtils.tempDirectory(null, null);
        File dir2 = TestUtils.tempDirectory(null, null);
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)dir1, (List)new .colon.colon((Object)dir2, (List)Nil$.MODULE$)), new MockConfigRepository(), 1));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        String topicName = "future-log";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        this.logManager().maybeUpdatePreferredLogDir(tp, dir1.getAbsolutePath());
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2);
        this.logManager().maybeUpdatePreferredLogDir(tp, dir2.getAbsolutePath());
        LogManager qual$2 = this.logManager();
        None$ x$7 = None$.MODULE$;
        boolean x$8 = qual$2.getOrCreateLog$default$2();
        qual$2.getOrCreateLog(tp, x$8, true, (Option)x$7);
        LogManagerTest.verifyMetrics$2(2, metricTag, topicName);
        this.logManager().replaceCurrentWithFutureLog(tp);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
        Assertions.assertEquals((int)0, (int)LogManagerTest.logMetrics$3(topicName).count((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$3(m))));
        this.time().sleep(this.logConfig().fileDeleteDelayMs + 1L);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
    }

    @Test
    public void testWaitForAllToComplete() {
        IntRef invokedCount = IntRef.create((int)0);
        Future success = (Future)Mockito.mock(Future.class);
        Mockito.when(success.get()).thenAnswer(x$21 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testWaitForAllToComplete$1(invokedCount, x$21)));
        Future failure = (Future)Mockito.mock(Future.class);
        Mockito.when(failure.get()).thenAnswer(x$22 -> {
            ++invokedCount$1.elem;
            throw new RuntimeException();
        });
        IntRef failureCount = IntRef.create((int)0);
        Assertions.assertFalse((new .colon.colon((Object)success, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$)).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$23 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$3(failureCount, x$23);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)invokedCount.elem);
        Assertions.assertEquals((int)1, (int)failureCount.elem);
        Assertions.assertFalse((new .colon.colon((Object)failure, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$)).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$24 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$4(failureCount, x$24);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)4, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Assertions.assertTrue((new .colon.colon((Object)success, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$)).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$25 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$5(failureCount, x$25);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)6, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Assertions.assertFalse((new .colon.colon((Object)failure, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$)).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$26 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$6(failureCount, x$26);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)8, (int)invokedCount.elem);
        Assertions.assertEquals((int)4, (int)failureCount.elem);
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$2(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
            LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$1(VolatileIntRef loadLogCalled$1, InvocationOnMock invocation) {
        Thread.sleep(5000L);
        UnifiedLog cfr_ignored_0 = (UnifiedLog)invocation.callRealMethod();
        ++loadLogCalled$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$2(VolatileIntRef loadLogCalled$1) {
        return loadLogCalled$1.elem == 1;
    }

    public static final /* synthetic */ String $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$3() {
        return "Timed out waiting for only the first log to be loaded";
    }

    public static final /* synthetic */ String $anonfun$testCreateLogWithLogDirFallback$1(int x$3) {
        return Integer.toString(x$3);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateLogWithLogDirFallback$4(LogManagerTest $this, File dir) {
        return new File(dir, new StringBuilder(2).append($this.name()).append("-0").toString()).exists();
    }

    public static final /* synthetic */ boolean $anonfun$testCleanupExpiredSegments$2(LogManagerTest $this, LogSegment x$6) {
        return x$6.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ boolean $anonfun$testDoesntCleanLogs$2(LogManagerTest $this, LogSegment x$9) {
        return x$9.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$1(UnifiedLog log$4, int x$10) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
        return log$4.appendAsLeader(set, 0, log$4.appendAsLeader$default$3(), log$4.appendAsLeader$default$4(), log$4.appendAsLeader$default$5(), log$4.appendAsLeader$default$6());
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$2(UnifiedLog log) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable)x$14 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$4(Map checkpoints$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            UnifiedLog log = (UnifiedLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$1(File x$15) {
        return x$15.getName().endsWith("index");
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$3(File fileBeforeDelete$1, File x$16) {
        String string = x$16.getName();
        String string2 = fileBeforeDelete$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testFileReferencesAfterAsyncDelete$2(scala.collection.immutable.Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        Option fileInIndex = indexFilesAfterDelete$1.find((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3(fileBeforeDelete, x$16)));
        Assertions.assertEquals((Object)new Some((Object)fileBeforeDelete.getName()), (Object)fileInIndex.map((Function1 & Serializable)x$17 -> x$17.getName()), (String)new StringBuilder(51).append("Could not find index file ").append(fileBeforeDelete.getName()).append(" in indexFilesAfterDelete").toString());
        Assertions.assertNotEquals((Object)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (String)((File)fileInIndex.get()).getAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$2(UnifiedLog log) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable)x$19 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$4(Map checkpoints$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            UnifiedLog log = (UnifiedLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$2.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            return;
        }
        throw new MatchError(null);
    }

    private static final MemoryRecords createRecord$1(MockTime time$1) {
        byte[] x$1 = "test".getBytes();
        long x$2 = time$1.milliseconds();
        CompressionType x$4 = CompressionType.NONE;
        byte x$5 = 2;
        return TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, x$5);
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemainingLogsToRecoverMetric$1(String logManagerClassName$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metric = (MetricName)x0$1._1();
            String string = metric.getType();
            String string2 = String.valueOf(logManagerClassName$1);
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = metric.getName();
                String string4 = "remainingLogsToRecover";
                if (string3 != null && string3.equals(string4)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingLogsToRecoverMetric$3(java.util.List paths$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String path = (String)x0$3._1();
            Assertions.assertEquals((int)x0$3._2$mcI$sp(), (int)Collections.frequency(paths$1, path));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingLogsToRecoverMetric$4(Gauge gauge) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemainingSegmentsToRecoverMetric$1(String logManagerClassName$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metric = (MetricName)x0$1._1();
            String string = metric.getType();
            String string2 = String.valueOf(logManagerClassName$2);
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = metric.getName();
                String string4 = "remainingSegmentsToRecover";
                if (string3 != null && string3.equals(string4)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingSegmentsToRecoverMetric$4(Gauge gauge) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingSegmentsToRecoverMetric$5(java.util.List threadNames$1, java.util.List numRemainingSegments$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String threadName = (String)x0$3._1();
            IntRef expectedCurRemainingSegments = IntRef.create((int)(x0$3._2$mcI$sp() + 1));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), threadNames$1.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                if (((String)threadNames$1.get(i)).contains(threadName)) {
                    --expectedCurRemainingSegments$1.elem;
                    Assertions.assertEquals((int)expectedCurRemainingSegments$1.elem, (int)BoxesRunTime.unboxToInt(numRemainingSegments$1.get(i)));
                    return;
                }
            });
            Assertions.assertEquals((int)0, (int)expectedCurRemainingSegments.elem);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogRecoverMetricsRemoved$1(String spyLogManagerClassName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$1);
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = metric.getName();
            String string4 = "remainingLogsToRecover";
            if (string3 != null && string3.equals(string4)) {
                return true;
            }
        }
        return false;
    }

    private static final scala.collection.mutable.Set logMetrics$1(String spyLogManagerClassName$1) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyLogRecoverMetricsRemoved$1(spyLogManagerClassName$1, metric)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogRecoverMetricsRemoved$2(String spyLogManagerClassName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$1);
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = metric.getName();
            String string4 = "remainingSegmentsToRecover";
            if (string3 != null && string3.equals(string4)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(String topicName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$1);
    }

    private static final scala.collection.mutable.Set logMetrics$2(String topicName$1) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(topicName$1, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(String metricTag$1, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$1));
    }

    private static final void verifyMetrics$1(String metricTag$1, String topicName$1) {
        Assertions.assertEquals((int)LogMetricNames$.MODULE$.allMetricNames().size(), (int)LogManagerTest.logMetrics$2(topicName$1).size());
        LogManagerTest.logMetrics$2(topicName$1).foreach((Function1 & Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(metricTag$1, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(String topicName$2, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$2);
    }

    private static final scala.collection.mutable.Set logMetrics$3(String topicName$2) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(topicName$2, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(String metricTag$2, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$2));
    }

    private static final void verifyMetrics$2(int logCount, String metricTag$2, String topicName$2) {
        Assertions.assertEquals((int)(LogMetricNames$.MODULE$.allMetricNames().size() * logCount), (int)LogManagerTest.logMetrics$3(topicName$2).size());
        LogManagerTest.logMetrics$3(topicName$2).foreach((Function1 & Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(metricTag$2, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$3(MetricName m) {
        return m.getMBeanName().contains("is-future");
    }

    public static final /* synthetic */ boolean $anonfun$testWaitForAllToComplete$1(IntRef invokedCount$1, InvocationOnMock x$21) {
        ++invokedCount$1.elem;
        return true;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$3(IntRef failureCount$1, Throwable x$23) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$4(IntRef failureCount$1, Throwable x$24) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$5(IntRef failureCount$1, Throwable x$25) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$6(IntRef failureCount$1, Throwable x$26) {
        ++failureCount$1.elem;
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        this.logProps().put("segment.index.bytes", Predef$.MODULE$.int2Integer(4096));
        this.logProps().put("retention.ms", Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logConfig = new LogConfig((java.util.Map)this.logProps());
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
    }

    public static final /* synthetic */ Object $anonfun$testFileReferencesAfterAsyncDelete$2$adapted(scala.collection.immutable.Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(indexFilesAfterDelete$1, fileBeforeDelete);
        return BoxedUnit.UNIT;
    }
}

