/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.security.authorizer.AclEntry$;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ConfigType$;
import kafka.server.ControllerMigrationSupport;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.test.ClusterGenerator;
import kafka.test.ClusterInstance;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTemplate;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.ZkClusterInvocationContext;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.EncryptingPasswordEncoder;
import kafka.utils.Logging;
import kafka.utils.NoOpPasswordEncoder;
import kafka.utils.PasswordEncoder;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import kafka.zk.TopicZNode;
import kafka.zk.ZkMigrationClient;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkMigrationIntegrationTest$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.migration.MigrationDriverState;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ExtendWith(value={ClusterTestExtensions.class})
@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0005\r=r!\u0002\u0014(\u0011\u0003ac!\u0002\u0018(\u0011\u0003y\u0003\"\u0002\u001c\u0002\t\u00039\u0004\"\u0002\u001d\u0002\t\u0003I\u0004\"B$\u0002\t\u0003Ae\u0001\u0002\u0018(\u0001ECQAN\u0003\u0005\u0002ICq\u0001V\u0003C\u0002\u0013\u0005Q\u000b\u0003\u0004_\u000b\u0001\u0006IA\u0016\u0004\u0005?\u0016\u0001\u0001\rC\u00037\u0013\u0011\u0005\u0011\rC\u0004e\u0013\t\u0007I\u0011A3\t\r=L\u0001\u0015!\u0003g\u0011\u001d\u0001\u0018\u00021A\u0005\u0002EDq!^\u0005A\u0002\u0013\u0005a\u000f\u0003\u0004z\u0013\u0001\u0006KA\u001d\u0005\u0006u&!\ta\u001f\u0005\b\u0003'IA\u0011AA\u000b\u0011\u001d\t9#\u0002C\u0001\u0003SAq!!$\u0006\t\u0003\ty\tC\u0004\u0002>\u0016!\t!a0\t\u000f\u0005\u0015W\u0001\"\u0001\u0002H\"9\u0011Q[\u0003\u0005\u0002\u0005]\u0007bBAs\u000b\u0011\u0005\u0011q\u001d\u0005\b\u0003[,A\u0011AAx\u0011\u001d\t90\u0002C\u0001\u0003sDqA!\u0001\u0006\t\u0003\u0011\u0019\u0001C\u0004\u0003D\u0015!\tA!\u0012\t\u000f\t%T\u0001\"\u0001\u0003l!9!\u0011U\u0003\u0005\u0002\t\r\u0006b\u0002BW\u000b\u0011\u0005!q\u0016\u0005\b\u0005s+A\u0011\u0001B^\u0011\u001d\u0011)-\u0002C\u0001\u0005\u000fDqA!5\u0006\t\u0003\u0011\u0019\u000eC\u0004\u0003X\u0016!\tA!7\t\u000f\tuW\u0001\"\u0001\u0003`\"9!1]\u0003\u0005\u0002\t\u0015\bb\u0002Bu\u000b\u0011\u0005!1^\u0001\u001b5.l\u0015n\u001a:bi&|g.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003Q%\n!A_6\u000b\u0003)\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002.\u00035\tqE\u0001\u000e[W6KwM]1uS>t\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cHo\u0005\u0002\u0002aA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0017\u0002!\u0005$GMW6Ce>\\WM\u001d)s_B\u001cHC\u0001\u001e>!\t\t4(\u0003\u0002=e\t!QK\\5u\u0011\u0015q4\u00011\u0001@\u0003\u0015\u0001(o\u001c9t!\t\u0001U)D\u0001B\u0015\t\u00115)\u0001\u0003vi&d'\"\u0001#\u0002\t)\fg/Y\u0005\u0003\r\u0006\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003\u0005R8n\u00117vgR,'o\u001d$pe\u0006cG.T5he\u0006$\u0018n\u001c8WKJ\u001c\u0018n\u001c8t)\tQ\u0014\nC\u0003K\t\u0001\u00071*\u0001\tdYV\u001cH/\u001a:HK:,'/\u0019;peB\u0011AjT\u0007\u0002\u001b*\u0011a*K\u0001\u0005i\u0016\u001cH/\u0003\u0002Q\u001b\n\u00012\t\\;ti\u0016\u0014x)\u001a8fe\u0006$xN]\n\u0003\u000bA\"\u0012a\u0015\t\u0003[\u0015\t1\u0001\\8h+\u00051\u0006CA,]\u001b\u0005A&BA-[\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005Y\u0016aA8sO&\u0011Q\f\u0017\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\r\t\u0002\u0016\u001b\u0016$\u0018\rZ1uC\u0012+G\u000e^1WKJLg-[3s'\tI\u0001\u0007F\u0001c!\t\u0019\u0017\"D\u0001\u0006\u00035iW\r^1eCR\fG)\u001a7uCV\ta\r\u0005\u0002h[6\t\u0001N\u0003\u0002jU\u0006)\u0011.\\1hK*\u0011!f\u001b\u0006\u0003Yj\u000ba!\u00199bG\",\u0017B\u00018i\u00055iU\r^1eCR\fG)\u001a7uC\u0006qQ.\u001a;bI\u0006$\u0018\rR3mi\u0006\u0004\u0013AB8gMN,G/F\u0001s!\t\t4/\u0003\u0002ue\t\u0019\u0011J\u001c;\u0002\u0015=4gm]3u?\u0012*\u0017\u000f\u0006\u0002;o\"9\u0001PDA\u0001\u0002\u0004\u0011\u0018a\u0001=%c\u00059qN\u001a4tKR\u0004\u0013AB1dG\u0016\u0004H\u000f\u0006\u0002;y\")Q\u0010\u0005a\u0001}\u0006)!-\u0019;dQB!\u0001i`A\u0002\u0013\r\t\t!\u0011\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\r\r|W.\\8o\u0015\r\tiA[\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005E\u0011q\u0001\u0002\u0015\u0003BLW*Z:tC\u001e,\u0017I\u001c3WKJ\u001c\u0018n\u001c8\u0002\rY,'/\u001b4z)\rQ\u0014q\u0003\u0005\b\u00033\t\u0002\u0019AA\u000e\u0003!1XM]5gS\u0016\u0014\bCB\u0019\u0002\u001e\u0005\u0005\"(C\u0002\u0002 I\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007\u001d\f\u0019#C\u0002\u0002&!\u0014Q\"T3uC\u0012\fG/Y%nC\u001e,\u0017a\u0004;fgRl\u0015n\u001a:bi\u0016\f5\r\\:\u0015\u0007i\nY\u0003C\u0004\u0002.I\u0001\r!a\f\u0002\u001f\rdWo\u001d;fe&s7\u000f^1oG\u0016\u00042\u0001TA\u0019\u0013\r\t\u0019$\u0014\u0002\u0010\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK\":\"#a\u000e\u0002D\u0005\u0015\u0013qIA%\u0003'\n)&a\u0018\u0002b\u0005-\u0014Q\u000e\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011QH'\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002B\u0005m\"aC\"mkN$XM\u001d+fgR\fqA\u0019:pW\u0016\u00148/H\u0001\u0004\u0003-\u0019G.^:uKJ$\u0016\u0010]3%\u0005\u0005-\u0013\u0002BA'\u0003\u001f\n!AW&\u000b\t\u0005E\u00131H\u0001\u0005)f\u0004X-A\u0005bkR|7\u000b^1si\u0012\u0012\u0011qK\u0005\u0005\u00033\nY&A\u0002Z\u000bNSA!!\u0018\u0002<\u0005I\u0011)\u001e;p'R\f'\u000f^\u0001\u0010[\u0016$\u0018\rZ1uCZ+'o]5p]\u0012\u0012\u00111M\u0005\u0005\u0003K\n9'A\u0006J\u0005B{6g\u0018\u001b`\u0013Z\u0003$\u0002BA5\u0003\u000f\tq\"T3uC\u0012\fG/\u0019,feNLwN\\\u0001\u0011g\u0016\u0014h/\u001a:Qe>\u0004XM\u001d;jKNdC!a\u001c\u0002\u0004.R\u0011\u0011OA<\u0003s\ni(a \u0011\t\u0005e\u00121O\u0005\u0005\u0003k\nYDA\u000bDYV\u001cH/\u001a:D_:4\u0017n\u001a)s_B,'\u000f^=\u0002\u0007-,\u00170\t\u0002\u0002|\u0005)\u0012-\u001e;i_JL'0\u001a:/G2\f7o\u001d\u0018oC6,\u0017!\u0002<bYV,\u0017EAAA\u0003\u001dZ\u0017MZ6b]M,7-\u001e:jift\u0013-\u001e;i_JL'0\u001a:/\u0003\u000ed\u0017)\u001e;i_JL'0\u001a:,\u0015\u0005E\u0014qOAC\u0003{\nI)\t\u0002\u0002\b\u0006Y1/\u001e9fe:*8/\u001a:tC\t\tY)\u0001\bVg\u0016\u0014((\u0011(P\u001dfku*V*\u0002?Q,7\u000f^*uCJ$(l\u001b\"s_.,'oV5uQ\u0006+H\u000f[8sSj,'\u000fF\u0002;\u0003#Cq!a%\u0014\u0001\u0004\ty#A\u0005{W\u000ecWo\u001d;fe\":2#a\u000e\u0002D\u0005\u0015\u0013qIA%\u0003'\n)&a\u0018\u0002b\u0005-\u0014q\u0013\u0017\r\u0003_\n\u0019)!'\u0002$\u00065\u00161W\u0016\u000b\u0003c\n9(a'\u0002~\u0005}\u0015EAAO\u0003iIg\u000e^3s]\t\u0014xn[3s]1L7\u000f^3oKJtc.Y7fC\t\t\t+\u0001\u0005F1R+%KT!MW)\t\t(a\u001e\u0002&\u0006u\u0014\u0011V\u0011\u0003\u0003O\u000b\u0011\u0002\\5ti\u0016tWM]:\"\u0005\u0005-\u0016A\f)M\u0003&sE+\u0012-Uu=zCn\\2bY\"|7\u000f\u001e\u001e1Y\u0015CF+\u0012*O\u00032Stf\f7pG\u0006d\u0007n\\:uuAZ#\"!\u001d\u0002x\u0005=\u0016QPAUC\t\t\t,\u0001\u000bbIZ,'\u000f^5tK\u0012tC.[:uK:,'o]\u0016\u000b\u0003c\n9(!.\u0002~\u0005e\u0016EAA\\\u0003ya\u0017n\u001d;f]\u0016\u0014hf]3dkJLG/\u001f\u0018qe>$xnY8m]5\f\u0007/\t\u0002\u0002<\u00061S\t\u0017+F%:\u000bEJ\u000f)M\u0003&sE+\u0012-UYAc\u0015)\u0013(U\u000bb#&\b\u0015'B\u0013:#V\t\u0017+\u0002\u0017Q,7\u000f^'jOJ\fG/\u001a\u000b\u0004u\u0005\u0005\u0007bBA\u0017)\u0001\u0007\u0011q\u0006\u0015\u0010)\u0005]\u00121IA#\u0003\u000f\nI%a\u0018\u0002b\u0005IB/Z:u\u001b&<'/\u0019;f)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8t)\rQ\u0014\u0011\u001a\u0005\b\u0003'+\u0002\u0019AA\u0018Q\u001d)\u0012QZA?\u0003'\u0004B!!\u000f\u0002P&!\u0011\u0011[A\u001e\u0005=\u0019E.^:uKJ$V-\u001c9mCR,\u0017%A$\u0002%Q,7\u000f\u001e#vC2<&/\u001b;f'\u000e\u0014\u0018-\u001c\u000b\u0004u\u0005e\u0007bBAJ-\u0001\u0007\u0011q\u0006\u0015\u0014-\u0005]\u0012qIA%\u0003\u0007\n)%a\u0018\u0002^\u0006-\u00141\u001d\u0013\u0003\u0003?LA!!9\u0002h\u0005Y\u0011J\u0011)`g}+t,\u0013,3Y!\tI*a)\u0002.\u0006M\u0016!\u0004;fgR$U/\u00197Xe&$X\rF\u0002;\u0003SDq!a%\u0018\u0001\u0004\ty\u0003K\u0004\u0018\u0003\u001b\fi(a5\u00025Q,7\u000f\u001e#vC2<&/\u001b;f#V|G/Y!oIN\u001b'/Y7\u0015\u0007i\n\t\u0010C\u0004\u0002\u0014b\u0001\r!a\f)'a\t9$a\u0012\u0002J\u0005\r\u0013QIA0\u0003;\fY'!>-\u0011\u0005e\u00151UAW\u0003g\u000b!\u0005^3ti:+w/\u00118e\u0007\"\fgnZ3e)>\u0004\u0018nY:J]\u0012+\u0018\r\\,sSR,Gc\u0001\u001e\u0002|\"9\u00111S\rA\u0002\u0005=\u0002fE\r\u00028\u0005\u001d\u0013\u0011JA\"\u0003\u000b\ny&!\u0019\u0002l\u0005}H\u0006CAM\u0003G\u000bi+a-\u00029Y,'/\u001b4z)>\u0004\u0018n\u0019)beRLG/[8o\u001b\u0016$\u0018\rZ1uCR9!H!\u0002\u0003 \te\u0002b\u0002B\u00045\u0001\u0007!\u0011B\u0001\ni>\u0004\u0018n\u0019(b[\u0016\u0004BAa\u0003\u0003\u001a9!!Q\u0002B\u000b!\r\u0011yAM\u0007\u0003\u0005#Q1Aa\u0005,\u0003\u0019a$o\\8u}%\u0019!q\u0003\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011YB!\b\u0003\rM#(/\u001b8h\u0015\r\u00119B\r\u0005\b\u0005CQ\u0002\u0019\u0001B\u0012\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0007\u0005K\u0011YCa\f\u000e\u0005\t\u001d\"b\u0001B\u0015e\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t5\"q\u0005\u0002\u0004'\u0016\f\b\u0003\u0002B\u0019\u0005ki!Aa\r\u000b\u0007\u0005%!.\u0003\u0003\u00038\tM\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0005wQ\u0002\u0019\u0001B\u001f\u0003!Q8n\u00117jK:$\bcA\u0017\u0003@%\u0019!\u0011I\u0014\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003%!x\u000e]5d\t\u0016\u001c8\r\u0006\u0004\u0003H\tu#\u0011\r\t\u0006c\t%#QJ\u0005\u0004\u0005\u0017\u0012$AB(qi&|g\u000e\u0005\u0003\u0003P\teSB\u0001B)\u0015\u0011\u0011\u0019F!\u0016\u0002\u000b\u0005$W.\u001b8\u000b\u0007\t]#.A\u0004dY&,g\u000e^:\n\t\tm#\u0011\u000b\u0002\u0011)>\u0004\u0018n\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:DqAa\u0018\u001c\u0001\u0004\u0011I!A\u0003u_BL7\rC\u0004\u0003Tm\u0001\rAa\u0019\u0011\t\t=#QM\u0005\u0005\u0005O\u0012\tFA\u0003BI6Lg.A\ftK:$\u0017\t\u001c7pG\u0006$X\r\u0015:pIV\u001cWM]%egR!!Q\u000eB@!\u0019\u0011yG!\u001e\u0003z5\u0011!\u0011\u000f\u0006\u0004\u0005g\n\u0015AC2p]\u000e,(O]3oi&!!q\u000fB9\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\u0004c\tm\u0014b\u0001B?e\t!Aj\u001c8h\u0011\u001d\u0011\t\t\ba\u0001\u0005\u0007\u000b\u0011C_6DYV\u001cH/\u001a:J]N$\u0018M\\2f!\u0011\u0011)Ia'\u000f\t\t\u001d%Q\u0013\b\u0005\u0005\u0013\u0013\tJ\u0004\u0003\u0003\f\n=e\u0002\u0002B\b\u0005\u001bK\u0011AK\u0005\u0003\u001d&J1Aa%N\u0003\u0015QWO\\5u\u0013\u0011\u00119J!'\u00025i[7\t\\;ti\u0016\u0014\u0018J\u001c<pG\u0006$\u0018n\u001c8D_:$X\r\u001f;\u000b\u0007\tMU*\u0003\u0003\u0003\u001e\n}%!\u0005.l\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK*!!q\u0013BM\u0003M\u0011X-\u00193Qe>$WoY3s\u0013\u0012\u0014En\\2l)\u0011\u0011)Ka+\u0011\t\u0005\u0015!qU\u0005\u0005\u0005S\u000b9A\u0001\tQe>$WoY3s\u0013\u0012\u001c(\t\\8dW\"9!1H\u000fA\u0002\tu\u0012\u0001E1mi\u0016\u0014Hk\u001c9jG\u000e{gNZ5h)\u0011\u0011\tLa.\u0011\t\t=#1W\u0005\u0005\u0005k\u0013\tF\u0001\nBYR,'oQ8oM&<7OU3tk2$\bb\u0002B*=\u0001\u0007!1M\u0001\u0012C2$XM]\"mS\u0016tG/U;pi\u0006\u001cH\u0003\u0002B_\u0005\u0007\u0004BAa\u0014\u0003@&!!\u0011\u0019B)\u0005]\tE\u000e^3s\u00072LWM\u001c;Rk>$\u0018m\u001d*fgVdG\u000fC\u0004\u0003T}\u0001\rAa\u0019\u00025\r\u0014X-\u0019;f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:\u0015\t\t%'q\u001a\t\u0005\u0005\u001f\u0012Y-\u0003\u0003\u0003N\nE#aH!mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014Vm];mi\"9!1\u000b\u0011A\u0002\t\r\u0014!G1mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN$BA!3\u0003V\"9!1K\u0011A\u0002\t\r\u0014A\u0005<fe&4\u0017\u0010V8qS\u000e\u001cuN\u001c4jON$2A\u000fBn\u0011\u001d\u0011YD\ta\u0001\u0005{\t!C^3sS\u001aL8\t\\5f]R\fVo\u001c;bgR\u0019!H!9\t\u000f\tm2\u00051\u0001\u0003>\u0005Qb/\u001a:jMf,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgR\u0019!Ha:\t\u000f\tmB\u00051\u0001\u0003>\u0005\u00112\u000f[;uI><h.\u00138TKF,XM\\2f)\u0015Q$Q\u001eBx\u0011\u001d\t\u0019*\na\u0001\u0003_AqA!=&\u0001\u0004\u0011\u00190\u0001\u0007le\u00064Go\u00117vgR,'\u000f\u0005\u0003\u0003v\nmXB\u0001B|\u0015\r\u0011I0K\u0001\bi\u0016\u001cHo[5u\u0013\u0011\u0011iPa>\u0003'-\u000bgm[1DYV\u001cH/\u001a:UKN$8*\u001b;)\u000f\u0015\u0019\t!! \u0004\u0014A!11AB\b\u001b\t\u0019)A\u0003\u0003\u0004\b\r%\u0011aA1qS*!11BB\u0007\u0003\u001dQW\u000f]5uKJT1Aa%[\u0013\u0011\u0019\tb!\u0002\u0003\u000fQKW.Z8viz\u0011\u0011\u0001\f\u0015\b\u000b\r]\u0011QPB\u0012!\u0011\u0019Iba\b\u000e\u0005\rm!\u0002BB\u000f\u0007\u000b\t\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\t\r\u000521\u0004\u0002\u000b\u000bb$XM\u001c3XSRDGFAB\u0013G\t\u00199\u0003\u0005\u0003\u0004*\r-RB\u0001BM\u0013\u0011\u0019iC!'\u0003+\rcWo\u001d;feR+7\u000f^#yi\u0016t7/[8og\u0002")
public class ZkMigrationIntegrationTest {
    private final Logger log = LoggerFactory.getLogger(ZkMigrationIntegrationTest.class);

    public static void zkClustersForAllMigrationVersions(ClusterGenerator clusterGenerator) {
        new .colon.colon((Object)MetadataVersion.IBP_3_4_IV0, (List)new .colon.colon((Object)MetadataVersion.IBP_3_5_IV2, (List)new .colon.colon((Object)MetadataVersion.IBP_3_6_IV2, (List)Nil$.MODULE$))).foreach(arg_0 -> ZkMigrationIntegrationTest$.$anonfun$zkClustersForAllMigrationVersions$1$adapted(clusterGenerator, arg_0));
    }

    public static void addZkBrokerProps(Properties props) {
        ZkMigrationIntegrationTest$.MODULE$.addZkBrokerProps(props);
    }

    public Logger log() {
        return this.log;
    }

    @ClusterTest(brokers=3, clusterType=Type.ZK, autoStart=AutoStart.YES, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="authorizer.class.name", value="kafka.security.authorizer.AclAuthorizer"), @ClusterConfigProperty(key="super.users", value="User:ANONYMOUS")})
    public void testMigrateAcls(ClusterInstance clusterInstance) {
        Admin admin = clusterInstance.createAdminClient();
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        String username = "alice";
        KafkaPrincipal principal = new KafkaPrincipal("User", username);
        KafkaPrincipal wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry$.MODULE$.WildcardPrincipalString());
        AclBinding acl1 = new AclBinding(resource1, new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding acl2 = new AclBinding(resource1, new AccessControlEntry(principal.toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(wildcardPrincipal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        admin.createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)new .colon.colon((Object)acl3, (List)new .colon.colon((Object)acl4, (List)Nil$.MODULE$))))).asJava()).all().get();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().zkClient();
        ZkMigrationClient migrationClient = ZkMigrationClient$.MODULE$.apply(zkClient, (PasswordEncoder)new NoOpPasswordEncoder());
        MetadataDeltaVerifier verifier = new MetadataDeltaVerifier();
        migrationClient.readAllMetadata(batch -> verifier.accept((java.util.List<ApiMessageAndVersion>)batch), x$1 -> {});
        verifier.verify((Function1<MetadataImage, BoxedUnit>)(Function1 & Serializable)image -> {
            ZkMigrationIntegrationTest.$anonfun$testMigrateAcls$3(acl1, acl2, acl3, acl4, image);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(brokers=3, clusterType=Type.ZK, autoStart=AutoStart.YES, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="authorizer.class.name", value="kafka.security.authorizer.AclAuthorizer"), @ClusterConfigProperty(key="super.users", value="User:ANONYMOUS"), @ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testStartZkBrokerWithAuthorizer(ClusterInstance zkCluster) {
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testStartZkBrokerWithAuthorizer$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.inDualWrite$1(kraftCluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timed out waiting for dual-write mode");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(brokers=3, clusterType=Type.ZK, metadataVersion=MetadataVersion.IBP_3_4_IV0)
    public void testMigrate(ClusterInstance clusterInstance) {
        NoOpPasswordEncoder noOpPasswordEncoder;
        Admin admin = clusterInstance.createAdminClient();
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic("test-topic-1", 2, (short)3).configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"102400"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"300000")}))).asJava()));
        newTopics.add(new NewTopic("test-topic-2", 1, (short)3));
        newTopics.add(new NewTopic("test-topic-3", 10, (short)3));
        admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
        ArrayList<ClientQuotaAlteration> quotas = new ArrayList<ClientQuotaAlteration>();
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), (List)Nil$.MODULE$)).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(800.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(100.0)), (List)Nil$.MODULE$))).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"8.8.8.8")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)), (List)Nil$.MODULE$)).asJava()));
        admin.alterClientQuotas(quotas).all().get(60L, TimeUnit.SECONDS);
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().zkClient();
        KafkaConfig kafkaConfig = ((KafkaServer)((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().servers().head()).config();
        Option option = kafkaConfig.passwordEncoderSecret();
        if (option instanceof Some) {
            void encrypting_iterations;
            void encrypting_keyLength;
            void encrypting_cipherAlgorithm;
            Password secret = (Password)((Some)option).value();
            int n = Predef$.MODULE$.Integer2int(kafkaConfig.passwordEncoderIterations());
            int n2 = Predef$.MODULE$.Integer2int(kafkaConfig.passwordEncoderKeyLength());
            String string = kafkaConfig.passwordEncoderCipherAlgorithm();
            Option encrypting_keyFactoryAlgorithm = kafkaConfig.passwordEncoderKeyFactoryAlgorithm();
            noOpPasswordEncoder = new EncryptingPasswordEncoder(secret, encrypting_keyFactoryAlgorithm, (String)encrypting_cipherAlgorithm, (int)encrypting_keyLength, (int)encrypting_iterations);
            Object var14_12 = null;
            string = null;
        } else if (None$.MODULE$.equals(option)) {
            noOpPasswordEncoder = new NoOpPasswordEncoder();
        } else {
            throw new MatchError((Object)option);
        }
        NoOpPasswordEncoder zkConfigEncoder = noOpPasswordEncoder;
        ZkMigrationClient migrationClient = ZkMigrationClient$.MODULE$.apply(zkClient, (PasswordEncoder)zkConfigEncoder);
        ZkMigrationLeadershipState migrationState = migrationClient.getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState.EMPTY);
        migrationState = migrationState.withNewKRaftController(3000, 42);
        migrationState = migrationClient.claimControllerLeadership(migrationState);
        HashSet brokers = new HashSet();
        MetadataDeltaVerifier verifier = new MetadataDeltaVerifier();
        migrationClient.readAllMetadata(batch -> verifier.accept((java.util.List<ApiMessageAndVersion>)batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(brokers).asScala().toSeq());
        verifier.verify((Function1<MetadataImage, BoxedUnit>)(Function1 & Serializable)image -> {
            ZkMigrationIntegrationTest.$anonfun$testMigrate$3(image);
            return BoxedUnit.UNIT;
        });
        migrationClient.releaseControllerLeadership(migrationState);
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTemplate(value="zkClustersForAllMigrationVersions")
    public void testMigrateTopicDeletions(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic("test-topic-1", 10, (short)3));
        newTopics.add(new NewTopic("test-topic-2", 10, (short)3));
        newTopics.add(new NewTopic("test-topic-3", 10, (short)3));
        admin.createTopics(newTopics).all().get(300L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(zkCluster.config().metadataVersion()).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkClient.createDeleteTopicPath("test-topic-1");
            zkClient.createDeleteTopicPath("test-topic-2");
            zkClient.createDeleteTopicPath("test-topic-3");
            zkCluster.waitForReadyBrokers();
            readyFuture.get(60L, TimeUnit.SECONDS);
            Assumptions.assumeTrue((boolean)zkClient.getTopicDeletions().nonEmpty(), (String)"This test needs pending topic deletions after a migration in order to verify the behavior");
            this.log().info("Waiting for ZK migration to complete");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testMigrateTopicDeletions$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for migration to complete");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            admin = zkCluster.createAdminClient();
            this.log().info("Waiting for topics to be deleted");
            long l2 = 1000L;
            long waitUntilTrue_waitTimeMs2 = 30000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.topicsAllDeleted$1(admin)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timed out waiting for topics to be deleted");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            ArrayList<NewTopic> newTopics2 = new ArrayList<NewTopic>();
            newTopics2.add(new NewTopic("test-topic-1", 2, (short)3));
            newTopics2.add(new NewTopic("test-topic-2", 1, (short)3));
            newTopics2.add(new NewTopic("test-topic-3", 10, (short)3));
            admin.createTopics(newTopics2).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Waiting for topics to be re-created");
            long l3 = 1000L;
            long waitUntilTrue_waitTimeMs3 = 30000L;
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.topicsAllRecreated$1(admin)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)"Timed out waiting for topics to be created");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
            }
            long l4 = 300000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l5 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    scala.collection.immutable.Map map;
                    try {
                        map = CollectionConverters$.MODULE$.MapHasAsScala(admin.describeTopics(Arrays.asList("test-topic-1", "test-topic-2", "test-topic-3")).topicNameValues()).asScala().map((Function1 & Serializable)x0$1 -> {
                            if (x0$1 != null) {
                                String name = (String)x0$1._1();
                                KafkaFuture description = (KafkaFuture)x0$1._2();
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), description.get(60L, TimeUnit.SECONDS));
                            }
                            throw new MatchError(null);
                        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException) {
                            map = Predef$.MODULE$.Map().empty();
                        }
                        if (throwable != null) {
                            map = (scala.collection.immutable.Map)Assertions.fail((String)"Error describing topics", (Throwable)throwable.getCause());
                        }
                        throw null;
                    }
                    scala.collection.immutable.Map $anonfun$testMigrateTopicDeletions$7_topicDescriptions = map;
                    Assertions.assertEquals((int)2, (int)((TopicDescription)$anonfun$testMigrateTopicDeletions$7_topicDescriptions.apply((Object)"test-topic-1")).partitions().size());
                    Assertions.assertEquals((int)1, (int)((TopicDescription)$anonfun$testMigrateTopicDeletions$7_topicDescriptions.apply((Object)"test-topic-2")).partitions().size());
                    Assertions.assertEquals((int)10, (int)((TopicDescription)$anonfun$testMigrateTopicDeletions$7_topicDescriptions.apply((Object)"test-topic-3")).partitions().size());
                    $anonfun$testMigrateTopicDeletions$7_topicDescriptions.foreach((Function1 & Serializable)x0$2 -> {
                        ZkMigrationIntegrationTest.$anonfun$testMigrateTopicDeletions$9(x0$2);
                        return BoxedUnit.UNIT;
                    });
                    scala.collection.mutable.Set $anonfun$testMigrateTopicDeletions$7_absentTopics = CollectionConverters$.MODULE$.SetHasAsScala((Set)admin.listTopics().names().get(60L, TimeUnit.SECONDS)).asScala();
                    Assertions.assertTrue((boolean)$anonfun$testMigrateTopicDeletions$7_absentTopics.contains((Object)"test-topic-1"));
                    Assertions.assertTrue((boolean)$anonfun$testMigrateTopicDeletions$7_absentTopics.contains((Object)"test-topic-2"));
                    Assertions.assertTrue((boolean)$anonfun$testMigrateTopicDeletions$7_absentTopics.contains((Object)"test-topic-3"));
                    Object var35_27 = null;
                    Object var36_26 = null;
                    Object var37_28 = null;
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l5).append(", and then retrying.").toString();
                        Object var34_29 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l5);
                    l5 += package$.MODULE$.min(l5, 1000L);
                    continue;
                }
                break;
            }
            Object var28_20 = null;
            Object var33_24 = null;
            admin.close();
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_5_IV2, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDualWriteScram(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        this.createUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_5_IV2).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWriteScram$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyUserScramCredentials(zkClient);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTemplate(value="zkClustersForAllMigrationVersions")
    public void testDualWrite(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic("test", 2, (short)3).configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"102400"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"300000")}))).asJava()));
        admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        Properties propsBefore = zkClient.getEntityConfigs(ConfigType$.MODULE$.Topic(), "test");
        Assertions.assertEquals((Object)"102400", (Object)propsBefore.getProperty("segment.bytes"));
        Assertions.assertEquals((Object)"300000", (Object)propsBefore.getProperty("segment.ms"));
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(zkCluster.config().metadataVersion()).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            long nextProducerId = BoxesRunTime.unboxToLong((Object)this.sendAllocateProducerIds((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).get(30L, TimeUnit.SECONDS));
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWrite$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterTopicConfig(admin).all().get(60L, TimeUnit.SECONDS);
            this.alterClientQuotas(admin).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyTopicConfigs(zkClient);
            this.verifyClientQuotas(zkClient);
            long nextKRaftProducerId = BoxesRunTime.unboxToLong((Object)this.sendAllocateProducerIds((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).get(30L, TimeUnit.SECONDS));
            Assertions.assertNotEquals((long)nextProducerId, (long)nextKRaftProducerId);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_5_IV2, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDualWriteQuotaAndScram(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        this.createUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_5_IV2).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWriteQuotaAndScram$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
            this.alterClientQuotas(admin).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyUserScramCredentials(zkClient);
            this.verifyClientQuotas(zkClient);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testNewAndChangedTopicsInDualWrite(ClusterInstance zkCluster) {
        String topicName = "test";
        zkCluster.createAdminClient();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            void var12_20;
            Tuple2 tuple2;
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testNewAndChangedTopicsInDualWrite$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Create new topic with AdminClient");
            Admin admin = zkCluster.createAdminClient();
            ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
            newTopics.add(new NewTopic(topicName, 2, (short)3));
            admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
            .colon.colon existingPartitions = new .colon.colon((Object)new TopicPartition(topicName, 0), (List)new .colon.colon((Object)new TopicPartition(topicName, 1), (List)Nil$.MODULE$));
            this.verifyTopicPartitionMetadata(topicName, (Seq<TopicPartition>)existingPartitions, zkClient);
            int newPartitionCount = 3;
            this.log().info("Create new partitions with AdminClient");
            admin.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)NewPartitions.increaseTo((int)newPartitionCount))}))).asJava()).all().get(60L, TimeUnit.SECONDS);
            long l2 = 100L;
            long computeUntilTrue_waitTime = 15000L;
            long computeUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                void computeUntilTrue_pause;
                Option<TopicDescription> computeUntilTrue_result;
                if (ZkMigrationIntegrationTest.$anonfun$testNewAndChangedTopicsInDualWrite$4(newPartitionCount, computeUntilTrue_result = this.topicDesc(topicName, admin))) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    break;
                }
                if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    break;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
            }
            Object var27_18 = null;
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            Option topicDescOpt = (Option)tuple22._1();
            Assertions.assertTrue((boolean)var12_20.isDefined());
            Buffer partitions = CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)var12_20.get()).partitions()).asScala();
            Assertions.assertEquals((int)newPartitionCount, (int)partitions.size());
            this.verifyTopicPartitionMetadata(topicName, (Seq<TopicPartition>)((Seq)existingPartitions.$plus$plus((IterableOnce)new .colon.colon((Object)new TopicPartition(topicName, 2), (List)Nil$.MODULE$))), zkClient);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void verifyTopicPartitionMetadata(String topicName, Seq<TopicPartition> partitions, KafkaZkClient zkClient) {
        void var5_9;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Option computeUntilTrue_result;
            if ((computeUntilTrue_result = ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$1(zkClient, topicName)).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$3(partitions$1, x$2)))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Option topicIdReplicaAssignment = (Option)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)"Unable to find topic metadata in Zk");
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$4(zkClient, partitions, (Option)var5_9)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Unable to find topic partition metadata");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public Option<TopicDescription> topicDesc(String topic, Admin admin) {
        try {
            return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)admin.describeTopics(Collections.singleton(topic)).allTopicNames().get()).asScala().get((Object)topic);
        }
        catch (Throwable throwable) {
            return None$.MODULE$;
        }
    }

    public CompletableFuture<Object> sendAllocateProducerIds(ZkClusterInvocationContext.ZkClusterInstance zkClusterInstance) {
        BrokerToControllerChannelManager channel = ((KafkaBroker)zkClusterInstance.getUnderlying().brokers().head()).clientToControllerChannelManager();
        int brokerId = ((KafkaBroker)zkClusterInstance.getUnderlying().brokers().head()).config().brokerId();
        long brokerEpoch = ((KafkaBroker)zkClusterInstance.getUnderlying().brokers().head()).replicaManager().brokerEpochSupplier().apply$mcJ$sp();
        AllocateProducerIdsRequest.Builder request = new AllocateProducerIdsRequest.Builder(new AllocateProducerIdsRequestData().setBrokerId(brokerId).setBrokerEpoch(brokerEpoch));
        CompletableFuture<Object> producerIdStart = new CompletableFuture<Object>();
        channel.sendRequest((AbstractRequest.Builder)request, new ControllerRequestCompletionHandler(null, producerIdStart){
            private final CompletableFuture producerIdStart$1;

            public void onTimeout() {
                this.producerIdStart$1.completeExceptionally((Throwable)new TimeoutException("Request timed out"));
            }

            public void onComplete(ClientResponse response) {
                AllocateProducerIdsResponse body = (AllocateProducerIdsResponse)response.responseBody();
                this.producerIdStart$1.complete(BoxesRunTime.boxToLong((long)body.data().producerIdStart()));
            }
            {
                this.producerIdStart$1 = producerIdStart$1;
            }
        });
        return producerIdStart;
    }

    /*
     * WARNING - void declaration
     */
    public ProducerIdsBlock readProducerIdBlock(KafkaZkClient zkClient) {
        void var3_3;
        Tuple2 tuple2 = zkClient.getDataAndVersion("/latest_producer_id_block");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option dataOpt = (Option)tuple2._1();
        return (ProducerIdsBlock)var3_3.map((Function1 & Serializable)jsonData -> ProducerIdBlockZNode$.MODULE$.parseProducerIdBlockData(jsonData)).get();
    }

    public AlterConfigsResult alterTopicConfig(Admin admin) {
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "test");
        Collection alterConfigs = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.bytes", "204800"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.ms", null), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))).asJavaCollection();
        return admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource), (Object)alterConfigs)}))).asJava());
    }

    public AlterClientQuotasResult alterClientQuotas(Admin admin) {
        ArrayList<ClientQuotaAlteration> quotas = new ArrayList<ClientQuotaAlteration>();
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), (List)Nil$.MODULE$)).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(800.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(100.0)), (List)Nil$.MODULE$))).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"8.8.8.8")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)), (List)Nil$.MODULE$)).asJava()));
        return admin.alterClientQuotas(quotas);
    }

    public AlterUserScramCredentialsResult createUserScramCredentials(Admin admin) {
        ArrayList<UserScramCredentialUpsertion> alterations = new ArrayList<UserScramCredentialUpsertion>();
        alterations.add(new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8190), "password0"));
        return admin.alterUserScramCredentials(alterations);
    }

    public AlterUserScramCredentialsResult alterUserScramCredentials(Admin admin) {
        ArrayList<UserScramCredentialUpsertion> alterations = new ArrayList<UserScramCredentialUpsertion>();
        alterations.add(new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8191), "password1"));
        alterations.add(new UserScramCredentialUpsertion("user2", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8192), "password2"));
        return admin.alterUserScramCredentials(alterations);
    }

    public void verifyTopicConfigs(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyTopicConfigs$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public void verifyClientQuotas(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyClientQuotas$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public void verifyUserScramCredentials(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyUserScramCredentials$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public void shutdownInSequence(ClusterInstance zkCluster, KafkaClusterTestKit kraftCluster) {
        zkCluster.brokerIds().forEach(x$5 -> zkCluster.shutdownBroker(Predef$.MODULE$.Integer2int(x$5)));
        kraftCluster.close();
        zkCluster.stop();
    }

    public static final /* synthetic */ void $anonfun$testMigrateAcls$3(AclBinding acl1$1, AclBinding acl2$1, AclBinding acl3$1, AclBinding acl4$1, MetadataImage image) {
        java.util.Map aclMap = image.acls().acls();
        Assertions.assertEquals((int)4, (int)aclMap.size());
        Assertions.assertTrue((boolean)aclMap.values().containsAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl1$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl2$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl3$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl4$1), (List)Nil$.MODULE$))))).asJava()));
    }

    public static final /* synthetic */ boolean $anonfun$testStartZkBrokerWithAuthorizer$1(KafkaZkClient zkClient$1) {
        return zkClient$1.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testStartZkBrokerWithAuthorizer$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    private static final boolean inDualWrite$1(KafkaClusterTestKit kraftCluster$1) {
        return ((MigrationDriverState)((ControllerMigrationSupport)kraftCluster$1.controllers().get(BoxesRunTime.boxToInteger((int)3000)).migrationSupport().get()).migrationDriver().migrationState().get(10L, TimeUnit.SECONDS)).allowDualWrite();
    }

    public static final /* synthetic */ boolean $anonfun$testStartZkBrokerWithAuthorizer$3(KafkaClusterTestKit kraftCluster$1) {
        return ZkMigrationIntegrationTest.inDualWrite$1(kraftCluster$1);
    }

    public static final /* synthetic */ String $anonfun$testStartZkBrokerWithAuthorizer$4() {
        return "Timed out waiting for dual-write mode";
    }

    public static final /* synthetic */ void $anonfun$testMigrate$3(MetadataImage image) {
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-1"));
        Assertions.assertEquals((int)2, (int)image.topics().getTopic("test-topic-1").partitions().size());
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-2"));
        Assertions.assertEquals((int)1, (int)image.topics().getTopic("test-topic-2").partitions().size());
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-3"));
        Assertions.assertEquals((int)10, (int)image.topics().getTopic("test-topic-3").partitions().size());
        java.util.Map clientQuotas = image.clientQuotas().entities();
        Assertions.assertEquals((int)3, (int)clientQuotas.size());
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateTopicDeletions$1(KafkaZkClient zkClient$2) {
        return zkClient$2.getOrCreateMigrationState(ZkMigrationLeadershipState.EMPTY).initialZkMigrationComplete();
    }

    public static final /* synthetic */ String $anonfun$testMigrateTopicDeletions$2() {
        return "Timed out waiting for migration to complete";
    }

    private static final boolean topicsAllDeleted$1(Admin admin) {
        Set topics = (Set)admin.listTopics().names().get(60L, TimeUnit.SECONDS);
        topics.retainAll(Arrays.asList("test-topic-1", "test-topic-2", "test-topic-3"));
        return topics.isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateTopicDeletions$3(ObjectRef admin$1) {
        return ZkMigrationIntegrationTest.topicsAllDeleted$1((Admin)admin$1.elem);
    }

    public static final /* synthetic */ String $anonfun$testMigrateTopicDeletions$4() {
        return "Timed out waiting for topics to be deleted";
    }

    private static final boolean topicsAllRecreated$1(Admin admin) {
        Set topics = (Set)admin.listTopics().names().get(60L, TimeUnit.SECONDS);
        topics.retainAll(Arrays.asList("test-topic-1", "test-topic-2", "test-topic-3"));
        return topics.size() == 3;
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateTopicDeletions$5(ObjectRef admin$1) {
        return ZkMigrationIntegrationTest.topicsAllRecreated$1((Admin)admin$1.elem);
    }

    public static final /* synthetic */ String $anonfun$testMigrateTopicDeletions$6() {
        return "Timed out waiting for topics to be created";
    }

    public static final /* synthetic */ void $anonfun$testMigrateTopicDeletions$9(Tuple2 x0$2) {
        if (x0$2 != null) {
            String topic = (String)x0$2._1();
            ((TopicDescription)x0$2._2()).partitions().forEach(partition -> {
                Assertions.assertEquals((int)3, (int)partition.replicas().size(), (String)new StringBuilder(35).append("Unexpected number of replicas for ").append(topic).append("-").append(partition.partition()).toString());
                Assertions.assertEquals((int)3, (int)partition.isr().size(), (String)new StringBuilder(20).append("Unexpected ISR for ").append(topic).append("-").append(partition.partition()).toString());
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testMigrateTopicDeletions$7(ObjectRef admin$1) {
        scala.collection.immutable.Map map;
        try {
            map = CollectionConverters$.MODULE$.MapHasAsScala(((Admin)admin$1.elem).describeTopics(Arrays.asList("test-topic-1", "test-topic-2", "test-topic-3")).topicNameValues()).asScala().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String name = (String)x0$1._1();
                    KafkaFuture description = (KafkaFuture)x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), description.get(60L, TimeUnit.SECONDS));
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException) {
                map = Predef$.MODULE$.Map().empty();
            }
            if (throwable != null) {
                map = (scala.collection.immutable.Map)Assertions.fail((String)"Error describing topics", (Throwable)throwable.getCause());
            }
            throw null;
        }
        scala.collection.immutable.Map topicDescriptions = map;
        Assertions.assertEquals((int)2, (int)((TopicDescription)topicDescriptions.apply((Object)"test-topic-1")).partitions().size());
        Assertions.assertEquals((int)1, (int)((TopicDescription)topicDescriptions.apply((Object)"test-topic-2")).partitions().size());
        Assertions.assertEquals((int)10, (int)((TopicDescription)topicDescriptions.apply((Object)"test-topic-3")).partitions().size());
        topicDescriptions.foreach((Function1 & Serializable)x0$2 -> {
            ZkMigrationIntegrationTest.$anonfun$testMigrateTopicDeletions$9(x0$2);
            return BoxedUnit.UNIT;
        });
        scala.collection.mutable.Set absentTopics = CollectionConverters$.MODULE$.SetHasAsScala((Set)((Admin)admin$1.elem).listTopics().names().get(60L, TimeUnit.SECONDS)).asScala();
        Assertions.assertTrue((boolean)absentTopics.contains((Object)"test-topic-1"));
        Assertions.assertTrue((boolean)absentTopics.contains((Object)"test-topic-2"));
        Assertions.assertTrue((boolean)absentTopics.contains((Object)"test-topic-3"));
    }

    public static final /* synthetic */ boolean $anonfun$testDualWriteScram$1(KafkaZkClient zkClient$3) {
        return zkClient$3.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWriteScram$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testDualWrite$1(KafkaZkClient zkClient$4) {
        return zkClient$4.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWrite$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testDualWriteQuotaAndScram$1(KafkaZkClient zkClient$5) {
        return zkClient$5.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWriteQuotaAndScram$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testNewAndChangedTopicsInDualWrite$1(KafkaZkClient zkClient$6) {
        return zkClient$6.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testNewAndChangedTopicsInDualWrite$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ Option $anonfun$testNewAndChangedTopicsInDualWrite$3(ZkMigrationIntegrationTest $this, String topicName$1, ObjectRef admin$2) {
        return $this.topicDesc(topicName$1, (Admin)admin$2.elem);
    }

    public static final /* synthetic */ boolean $anonfun$testNewAndChangedTopicsInDualWrite$4(int newPartitionCount$1, Option td) {
        return td.isDefined() && CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)td.get()).partitions()).asScala().size() == newPartitionCount$1;
    }

    public static final /* synthetic */ Option $anonfun$verifyTopicPartitionMetadata$1(KafkaZkClient zkClient$7, String topicName$2) {
        return zkClient$7.getReplicaAssignmentAndTopicIdForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName$2}))).headOption();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicPartitionMetadata$3(Seq partitions$1, TopicZNode.TopicIdReplicaAssignment x$2) {
        return x$2.assignment().size() == partitions$1.size();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicPartitionMetadata$6(TopicPartition tp$1, LeaderIsrAndControllerEpoch lisr$1, TopicZNode.TopicIdReplicaAssignment x$4) {
        Seq seq = ((ReplicaAssignment)x$4.assignment().apply((Object)tp$1)).replicas();
        List list = lisr$1.leaderAndIsr().isr();
        return !(seq != null ? !seq.equals(list) : list != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicPartitionMetadata$5(Option topicIdReplicaAssignment$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            LeaderIsrAndControllerEpoch lisr = (LeaderIsrAndControllerEpoch)x0$1._2();
            return lisr.leaderAndIsr().leader() >= 0 && topicIdReplicaAssignment$1.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$6(tp, lisr, x$4)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicPartitionMetadata$4(KafkaZkClient zkClient$7, Seq partitions$1, Option topicIdReplicaAssignment$1) {
        Map lisrMap = zkClient$7.getTopicPartitionStates((Seq)partitions$1.toSeq());
        return lisrMap.size() == partitions$1.size() && lisrMap.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$5(topicIdReplicaAssignment$1, x0$1)));
    }

    public static final /* synthetic */ String $anonfun$verifyTopicPartitionMetadata$7() {
        return "Unable to find topic partition metadata";
    }

    public static final /* synthetic */ void $anonfun$verifyTopicConfigs$1(KafkaZkClient zkClient$8) {
        Properties propsAfter = zkClient$8.getEntityConfigs(ConfigType$.MODULE$.Topic(), "test");
        Assertions.assertEquals((Object)"204800", (Object)propsAfter.getProperty("segment.bytes"));
        Assertions.assertFalse((boolean)propsAfter.containsKey("segment.ms"));
    }

    public static final /* synthetic */ void $anonfun$verifyClientQuotas$1(KafkaZkClient zkClient$9) {
        Assertions.assertEquals((Object)"1000", (Object)zkClient$9.getEntityConfigs(ConfigType$.MODULE$.User(), "user1").getProperty("consumer_byte_rate"));
        Assertions.assertEquals((Object)"800", (Object)zkClient$9.getEntityConfigs("users/user1/clients", "clientA").getProperty("consumer_byte_rate"));
        Assertions.assertEquals((Object)"100", (Object)zkClient$9.getEntityConfigs("users/user1/clients", "clientA").getProperty("producer_byte_rate"));
        Assertions.assertEquals((Object)"10", (Object)zkClient$9.getEntityConfigs(ConfigType$.MODULE$.Ip(), "8.8.8.8").getProperty("connection_creation_rate"));
    }

    public static final /* synthetic */ void $anonfun$verifyUserScramCredentials$1(KafkaZkClient zkClient$10) {
        ScramCredential scramCredentials1 = ScramCredentialUtils.credentialFromString((String)zkClient$10.getEntityConfigs(ConfigType$.MODULE$.User(), "user1").getProperty("SCRAM-SHA-256"));
        Assertions.assertEquals((int)8191, (int)scramCredentials1.iterations());
        String propertyValue2 = zkClient$10.getEntityConfigs(ConfigType$.MODULE$.User(), "user2").getProperty("SCRAM-SHA-256");
        Assertions.assertNotNull((Object)propertyValue2);
        ScramCredential scramCredentials2 = ScramCredentialUtils.credentialFromString((String)propertyValue2);
        Assertions.assertEquals((int)8192, (int)scramCredentials2.iterations());
    }

    public static final /* synthetic */ Object $anonfun$testNewAndChangedTopicsInDualWrite$4$adapted(int newPartitionCount$1, Option td) {
        return BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$testNewAndChangedTopicsInDualWrite$4(newPartitionCount$1, td));
    }

    public static final /* synthetic */ Object $anonfun$verifyTopicPartitionMetadata$2$adapted(Seq partitions$1, Option x) {
        return BoxesRunTime.boxToBoolean((boolean)x.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$3(partitions$1, x$2))));
    }

    public class MetadataDeltaVerifier {
        private final MetadataDelta metadataDelta;
        private int offset;

        public MetadataDelta metadataDelta() {
            return this.metadataDelta;
        }

        public int offset() {
            return this.offset;
        }

        public void offset_$eq(int x$1) {
            this.offset = x$1;
        }

        public void accept(java.util.List<ApiMessageAndVersion> batch) {
            batch.forEach(message -> {
                this.metadataDelta().replay(message.message());
                this.offset_$eq(this.offset() + 1);
            });
        }

        public void verify(Function1<MetadataImage, BoxedUnit> verifier) {
            MetadataImage image = this.metadataDelta().apply(new MetadataProvenance((long)this.offset(), 0, 0L));
            verifier.apply((Object)image);
        }

        public /* synthetic */ ZkMigrationIntegrationTest kafka$zk$ZkMigrationIntegrationTest$MetadataDeltaVerifier$$$outer() {
            return ZkMigrationIntegrationTest.this;
        }

        public MetadataDeltaVerifier() {
            if (ZkMigrationIntegrationTest.this == null) {
                throw null;
            }
            this.metadataDelta = new MetadataDelta(MetadataImage.EMPTY);
            this.offset = 0;
        }
    }
}

