/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.cluster.EndPoint;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.migration.MigrationPropagator;
import kafka.network.DataPlaneAcceptor$;
import kafka.network.SocketServer;
import kafka.raft.KafkaRaftManager;
import kafka.security.CredentialProvider;
import kafka.server.BrokerConfigHandler;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.ControllerApis;
import kafka.server.ControllerConfigurationValidator;
import kafka.server.ControllerMigrationSupport;
import kafka.server.DelegationTokenManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.KafkaServer$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.Server;
import kafka.server.Server$SHUTDOWN$;
import kafka.server.Server$SHUTTING_DOWN$;
import kafka.server.Server$STARTED$;
import kafka.server.Server$STARTING$;
import kafka.server.SharedServer;
import kafka.server.SimpleApiVersionManager;
import kafka.server.metadata.AclPublisher;
import kafka.server.metadata.ClientQuotaMetadataManager;
import kafka.server.metadata.DelegationTokenPublisher;
import kafka.server.metadata.DynamicClientQuotaPublisher;
import kafka.server.metadata.DynamicConfigPublisher;
import kafka.server.metadata.ScramPublisher;
import kafka.utils.CoreUtils$;
import kafka.utils.EncryptingPasswordEncoder;
import kafka.utils.Logging;
import kafka.utils.NoOpPasswordEncoder;
import kafka.utils.PasswordEncoder;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.ZkMigrationClient;
import kafka.zk.ZkMigrationClient$;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.controller.metrics.ControllerMetadataMetricsPublisher;
import org.apache.kafka.controller.metrics.QuorumControllerMetrics;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.migration.KRaftMigrationDriver;
import org.apache.kafka.metadata.migration.LegacyPropagator;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.publisher.FeaturesPublisher;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.network.EndpointReadyFutures;
import org.apache.kafka.server.network.KafkaAuthorizerServerInfo;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import org.apache.kafka.server.util.Deadline;
import org.apache.kafka.server.util.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r5e\u0001B'O\u0001MC\u0001\u0002\u0019\u0001\u0003\u0006\u0004%\t!\u0019\u0005\tM\u0002\u0011\t\u0011)A\u0005E\"Aq\r\u0001BC\u0002\u0013\u0005\u0001\u000e\u0003\u0005u\u0001\t\u0005\t\u0015!\u0003j\u0011!)\bA!b\u0001\n\u00031\b\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011B<\t\u000by\u0004A\u0011A@\t\u0013\u0005%\u0001A1A\u0005\n\u0005-\u0001\u0002CA\u000e\u0001\u0001\u0006I!!\u0004\t\u0013\u0005u\u0001A1A\u0005\u0002\u0005}\u0001\u0002CA\u0014\u0001\u0001\u0006I!!\t\t\u0013\u0005%\u0002A1A\u0005\u0002\u0005-\u0002\u0002CA\u001e\u0001\u0001\u0006I!!\f\t\u000f\u0005M\u0001\u0001\"\u0001\u0002>!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003\"CA2\u0001\t\u0007I\u0011AA3\u0011!\ty\b\u0001Q\u0001\n\u0005\u001d\u0004\"CAA\u0001\t\u0007I\u0011AAB\u0011!\tY\t\u0001Q\u0001\n\u0005\u0015\u0005\"CAG\u0001\u0001\u0007I\u0011AAH\u0011%\ti\u000b\u0001a\u0001\n\u0003\ty\u000b\u0003\u0005\u0002<\u0002\u0001\u000b\u0015BAI\u0011-\ti\f\u0001a\u0001\u0002\u0004%\t!a0\t\u0017\u0005-\u0007\u00011AA\u0002\u0013\u0005\u0011Q\u001a\u0005\f\u0003#\u0004\u0001\u0019!A!B\u0013\t\t\rC\u0005\u0002T\u0002\u0001\r\u0011\"\u0001\u0002V\"I\u0011q\u001d\u0001A\u0002\u0013\u0005\u0011\u0011\u001e\u0005\t\u0003[\u0004\u0001\u0015)\u0003\u0002X\"Y\u0011q\u001f\u0001A\u0002\u0003\u0007I\u0011AA}\u0011-\u0011\u0019\u0002\u0001a\u0001\u0002\u0004%\tA!\u0006\t\u0017\te\u0001\u00011A\u0001B\u0003&\u00111 \u0005\f\u00057\u0001\u0001\u0019!a\u0001\n\u0003\u0011i\u0002C\u0006\u0003*\u0001\u0001\r\u00111A\u0005\u0002\t-\u0002b\u0003B\u0018\u0001\u0001\u0007\t\u0011)Q\u0005\u0005?A1B!\r\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00034!Y!\u0011\t\u0001A\u0002\u0003\u0007I\u0011\u0001B\"\u0011-\u00119\u0005\u0001a\u0001\u0002\u0003\u0006KA!\u000e\t\u0013\t%\u0003A1A\u0005\u0002\t-\u0003\u0002\u0003B1\u0001\u0001\u0006IA!\u0014\t\u0013\t\r\u0004\u00011A\u0005\u0002\t\u0015\u0004\"\u0003B;\u0001\u0001\u0007I\u0011\u0001B<\u0011!\u0011Y\b\u0001Q!\n\t\u001d\u0004\"\u0003B?\u0001\u0001\u0007I\u0011\u0001B@\u0011%\u0011I\t\u0001a\u0001\n\u0003\u0011Y\t\u0003\u0005\u0003\u0010\u0002\u0001\u000b\u0015\u0002BA\u0011-\u0011\t\n\u0001a\u0001\u0002\u0004%\tAa%\t\u0017\t\r\u0006\u00011AA\u0002\u0013\u0005!Q\u0015\u0005\f\u0005S\u0003\u0001\u0019!A!B\u0013\u0011)\nC\u0006\u0003\u001e\u0002\u0001\r\u00111A\u0005\u0002\t5\u0006b\u0003B\\\u0001\u0001\u0007\t\u0019!C\u0001\u0005sC1B!0\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00030\"Y!q\u0018\u0001A\u0002\u0003\u0007I\u0011\u0001Ba\u0011-\u0011\t\u000e\u0001a\u0001\u0002\u0004%\tAa5\t\u0017\t]\u0007\u00011A\u0001B\u0003&!1\u0019\u0005\f\u00053\u0004\u0001\u0019!a\u0001\n\u0003\u0011Y\u000eC\u0006\u0003h\u0002\u0001\r\u00111A\u0005\u0002\t%\bb\u0003Bw\u0001\u0001\u0007\t\u0011)Q\u0005\u0005;D1Ba<\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003r\"Y!\u0011 \u0001A\u0002\u0003\u0007I\u0011\u0001B~\u0011-\u0011y\u0010\u0001a\u0001\u0002\u0003\u0006KAa=\t\u0017\r\u0005\u0001\u00011AA\u0002\u0013\u000511\u0001\u0005\f\u0007\u0017\u0001\u0001\u0019!a\u0001\n\u0003\u0019i\u0001C\u0006\u0004\u0012\u0001\u0001\r\u0011!Q!\n\r\u0015\u0001\"CB\n\u0001\u0001\u0007I\u0011AB\u000b\u0011%\u0019y\u0002\u0001a\u0001\n\u0003\u0019\t\u0003\u0003\u0005\u0004&\u0001\u0001\u000b\u0015BB\f\u0011\u001d\u00199\u0003\u0001C\u0001\u0007SA\u0011b!\r\u0001\u0005\u0004%\taa\r\t\u0011\r5\u0003\u0001)A\u0005\u0007kA\u0011ba\u0014\u0001\u0005\u0004%\ta!\u0015\t\u0011\ru\u0003\u0001)A\u0005\u0007'Bqaa\u0018\u0001\t\u0013\u0019\t\u0007C\u0004\u0004r\u0001!\taa\u001d\t\u000f\r\u0015\u0005\u0001\"\u0001\u0004\b\"91\u0011\u0012\u0001\u0005\u0002\r\u001d\u0005bBBF\u0001\u0011\u00051q\u0011\u0002\u0011\u0007>tGO]8mY\u0016\u00148+\u001a:wKJT!a\u0014)\u0002\rM,'O^3s\u0015\u0005\t\u0016!B6bM.\f7\u0001A\n\u0004\u0001QS\u0006CA+Y\u001b\u00051&\"A,\u0002\u000bM\u001c\u0017\r\\1\n\u0005e3&AB!osJ+g\r\u0005\u0002\\=6\tAL\u0003\u0002^!\u0006)Q\u000f^5mg&\u0011q\f\u0018\u0002\b\u0019><w-\u001b8h\u00031\u0019\b.\u0019:fIN+'O^3s+\u0005\u0011\u0007CA2e\u001b\u0005q\u0015BA3O\u00051\u0019\u0006.\u0019:fIN+'O^3s\u00035\u0019\b.\u0019:fIN+'O^3sA\u0005a1m\u001c8gS\u001e\u001c6\r[3nCV\t\u0011\u000e\u0005\u0002ke6\t1N\u0003\u0002m[\u0006AQ.\u001a;bI\u0006$\u0018M\u0003\u0002R]*\u0011q\u000e]\u0001\u0007CB\f7\r[3\u000b\u0003E\f1a\u001c:h\u0013\t\u00198NA\tLC\u001a\\\u0017mQ8oM&<7k\u00195f[\u0006\fQbY8oM&<7k\u00195f[\u0006\u0004\u0013!\u00052p_R\u001cHO]1q\u001b\u0016$\u0018\rZ1uCV\tq\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{W\u0006I!m\\8ugR\u0014\u0018\r]\u0005\u0003yf\u0014\u0011CQ8piN$(/\u00199NKR\fG-\u0019;b\u0003I\u0011wn\u001c;tiJ\f\u0007/T3uC\u0012\fG/\u0019\u0011\u0002\rqJg.\u001b;?)!\t\t!a\u0001\u0002\u0006\u0005\u001d\u0001CA2\u0001\u0011\u0015\u0001w\u00011\u0001c\u0011\u00159w\u00011\u0001j\u0011\u0015)x\u00011\u0001x\u00031iW\r\u001e:jGN<%o\\;q+\t\ti\u0001\u0005\u0003\u0002\u0010\u0005]QBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u000f5,GO]5dg*\u0011q*\\\u0005\u0005\u00033\t\tBA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\fQ\"\\3ue&\u001c7o\u0012:pkB\u0004\u0013AB2p]\u001aLw-\u0006\u0002\u0002\"A\u00191-a\t\n\u0007\u0005\u0015bJA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u0005i&lW-\u0006\u0002\u0002.A!\u0011qFA\u001c\u001b\t\t\tDC\u0002^\u0003gQ1!!\u000en\u0003\u0019\u0019w.\\7p]&!\u0011\u0011HA\u0019\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0016\u0005\u0005}\u0002\u0003BA!\u0003\u000bj!!a\u0011\u000b\t\u0005M\u00111G\u0005\u0005\u0003\u000f\n\u0019EA\u0004NKR\u0014\u0018nY:\u0002\u0017I\fg\r^'b]\u0006<WM]\u000b\u0003\u0003\u001b\u0002b!a\u0014\u0002V\u0005eSBAA)\u0015\r\t\u0019\u0006U\u0001\u0005e\u00064G/\u0003\u0003\u0002X\u0005E#\u0001E&bM.\f'+\u00194u\u001b\u0006t\u0017mZ3s!\u0011\tY&a\u0018\u000e\u0005\u0005u#\u0002BA\u001b\u0003+IA!!\u0019\u0002^\t!\u0012\t]5NKN\u001c\u0018mZ3B]\u00124VM]:j_:\fA\u0001\\8dWV\u0011\u0011q\r\t\u0005\u0003S\nY(\u0004\u0002\u0002l)!\u0011QNA8\u0003\u0015awnY6t\u0015\u0011\t\t(a\u001d\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002v\u0005]\u0014\u0001B;uS2T!!!\u001f\u0002\t)\fg/Y\u0005\u0005\u0003{\nYGA\u0007SK\u0016tGO]1oi2{7m[\u0001\u0006Y>\u001c7\u000eI\u0001\u0012C^\f\u0017\u000e^*ikR$wn\u001e8D_:$WCAAC!\u0011\tI'a\"\n\t\u0005%\u00151\u000e\u0002\n\u0007>tG-\u001b;j_:\f!#Y<bSR\u001c\u0006.\u001e;e_^t7i\u001c8eA\u000511\u000f^1ukN,\"!!%\u0011\t\u0005M\u0015q\u0015\b\u0005\u0003+\u000b\u0019K\u0004\u0003\u0002\u0018\u0006\u0005f\u0002BAM\u0003?k!!a'\u000b\u0007\u0005u%+\u0001\u0004=e>|GOP\u0005\u0002#&\u0011q\nU\u0005\u0004\u0003Ks\u0015AB*feZ,'/\u0003\u0003\u0002*\u0006-&!\u0004)s_\u000e,7o]*uCR,8OC\u0002\u0002&:\u000b!b\u001d;biV\u001cx\fJ3r)\u0011\t\t,a.\u0011\u0007U\u000b\u0019,C\u0002\u00026Z\u0013A!\u00168ji\"I\u0011\u0011X\u000b\u0002\u0002\u0003\u0007\u0011\u0011S\u0001\u0004q\u0012\n\u0014aB:uCR,8\u000fI\u0001\u0018Y&tW\u000f_%p\u001b\u0016$(/[2t\u0007>dG.Z2u_J,\"!!1\u0011\t\u0005\r\u0017qY\u0007\u0003\u0003\u000bT1!a\u0005Q\u0013\u0011\tI-!2\u0003/1Kg.\u001e=J_6+GO]5dg\u000e{G\u000e\\3di>\u0014\u0018a\u00077j]VD\u0018j\\'fiJL7m]\"pY2,7\r^8s?\u0012*\u0017\u000f\u0006\u0003\u00022\u0006=\u0007\"CA]1\u0005\u0005\t\u0019AAa\u0003aa\u0017N\\;y\u0013>lU\r\u001e:jGN\u001cu\u000e\u001c7fGR|'\u000fI\u0001\u000bCV$\bn\u001c:ju\u0016\u0014XCAAl!\u0015)\u0016\u0011\\Ao\u0013\r\tYN\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005}\u00171]\u0007\u0003\u0003CTA!a5\u0002\u0016%!\u0011Q]Aq\u0005)\tU\u000f\u001e5pe&TXM]\u0001\u000fCV$\bn\u001c:ju\u0016\u0014x\fJ3r)\u0011\t\t,a;\t\u0013\u0005e6$!AA\u0002\u0005]\u0017aC1vi\"|'/\u001b>fe\u0002B3\u0001HAy!\r)\u00161_\u0005\u0004\u0003k4&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0015Q|7.\u001a8DC\u000eDW-\u0006\u0002\u0002|B!\u0011Q B\b\u001b\t\tyP\u0003\u0003\u0003\u0002\t\r\u0011!C5oi\u0016\u0014h.\u00197t\u0015\u0011\u0011)Aa\u0002\u0002\u0015\u0011,G.Z4bi&|gN\u0003\u0003\u0003\n\t-\u0011!\u0002;pW\u0016t'\u0002\u0002B\u0007\u0003g\t\u0001b]3dkJLG/_\u0005\u0005\u0005#\tyP\u0001\u000bEK2,w-\u0019;j_:$vn[3o\u0007\u0006\u001c\u0007.Z\u0001\u000fi>\\WM\\\"bG\",w\fJ3r)\u0011\t\tLa\u0006\t\u0013\u0005ef$!AA\u0002\u0005m\u0018a\u0003;pW\u0016t7)Y2iK\u0002\n!c\u0019:fI\u0016tG/[1m!J|g/\u001b3feV\u0011!q\u0004\t\u0005\u0005C\u0011)#\u0004\u0002\u0003$)\u0019!Q\u0002)\n\t\t\u001d\"1\u0005\u0002\u0013\u0007J,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'/\u0001\fde\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014x\fJ3r)\u0011\t\tL!\f\t\u0013\u0005e\u0016%!AA\u0002\t}\u0011aE2sK\u0012,g\u000e^5bYB\u0013xN^5eKJ\u0004\u0013\u0001D:pG.,GoU3sm\u0016\u0014XC\u0001B\u001b!\u0011\u00119D!\u0010\u000e\u0005\te\"b\u0001B\u001e!\u00069a.\u001a;x_J\\\u0017\u0002\u0002B \u0005s\u0011AbU8dW\u0016$8+\u001a:wKJ\f\u0001c]8dW\u0016$8+\u001a:wKJ|F%Z9\u0015\t\u0005E&Q\t\u0005\n\u0003s#\u0013\u0011!a\u0001\u0005k\tQb]8dW\u0016$8+\u001a:wKJ\u0004\u0013\u0001I:pG.,GoU3sm\u0016\u0014h)\u001b:ti\n{WO\u001c3Q_J$h)\u001e;ve\u0016,\"A!\u0014\u0011\r\t=#\u0011\u000bB+\u001b\t\ty'\u0003\u0003\u0003T\u0005=$!E\"p[BdW\r^1cY\u00164U\u000f^;sKB!!q\u000bB/\u001b\t\u0011IF\u0003\u0003\u0003\\\u0005]\u0014\u0001\u00027b]\u001eLAAa\u0018\u0003Z\t9\u0011J\u001c;fO\u0016\u0014\u0018!I:pG.,GoU3sm\u0016\u0014h)\u001b:ti\n{WO\u001c3Q_J$h)\u001e;ve\u0016\u0004\u0013!E2sK\u0006$X\rV8qS\u000e\u0004v\u000e\\5dsV\u0011!q\r\t\u0006+\u0006e'\u0011\u000e\t\u0005\u0005W\u0012\t(\u0004\u0002\u0003n)!!qNA\u000b\u0003\u0019\u0001x\u000e\\5ds&!!1\u000fB7\u0005E\u0019%/Z1uKR{\u0007/[2Q_2L7-_\u0001\u0016GJ,\u0017\r^3U_BL7\rU8mS\u000eLx\fJ3r)\u0011\t\tL!\u001f\t\u0013\u0005e\u0016&!AA\u0002\t\u001d\u0014AE2sK\u0006$X\rV8qS\u000e\u0004v\u000e\\5ds\u0002\n\u0011#\u00197uKJ\u001cuN\u001c4jOB{G.[2z+\t\u0011\t\tE\u0003V\u00033\u0014\u0019\t\u0005\u0003\u0003l\t\u0015\u0015\u0002\u0002BD\u0005[\u0012\u0011#\u00117uKJ\u001cuN\u001c4jOB{G.[2z\u0003U\tG\u000e^3s\u0007>tg-[4Q_2L7-_0%KF$B!!-\u0003\u000e\"I\u0011\u0011\u0018\u0017\u0002\u0002\u0003\u0007!\u0011Q\u0001\u0013C2$XM]\"p]\u001aLw\rU8mS\u000eL\b%A\frk>\u0014X/\\\"p]R\u0014x\u000e\u001c7fe6+GO]5dgV\u0011!Q\u0013\t\u0005\u0005/\u0013y*\u0004\u0002\u0003\u001a*!\u00111\u0003BN\u0015\r\u0011i*\\\u0001\u000bG>tGO]8mY\u0016\u0014\u0018\u0002\u0002BQ\u00053\u0013q#U;peVl7i\u001c8ue>dG.\u001a:NKR\u0014\u0018nY:\u00027E,xN];n\u0007>tGO]8mY\u0016\u0014X*\u001a;sS\u000e\u001cx\fJ3r)\u0011\t\tLa*\t\u0013\u0005ev&!AA\u0002\tU\u0015\u0001G9v_J,XnQ8oiJ|G\u000e\\3s\u001b\u0016$(/[2tA!\u001a\u0001'!=\u0016\u0005\t=\u0006\u0003\u0002BY\u0005gk!Aa'\n\t\tU&1\u0014\u0002\u000b\u0007>tGO]8mY\u0016\u0014\u0018AD2p]R\u0014x\u000e\u001c7fe~#S-\u001d\u000b\u0005\u0003c\u0013Y\fC\u0005\u0002:J\n\t\u00111\u0001\u00030\u0006Y1m\u001c8ue>dG.\u001a:!\u00035\tXo\u001c;b\u001b\u0006t\u0017mZ3sgV\u0011!1\u0019\t\u0005\u0005\u000b\u0014YM\u0004\u0003\u0002\u0016\n\u001d\u0017b\u0001Be\u001d\u0006a\u0011+^8uC\u001a\u000b7\r^8ss&!!Q\u001aBh\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0019!\u0011\u001a(\u0002#E,x\u000e^1NC:\fw-\u001a:t?\u0012*\u0017\u000f\u0006\u0003\u00022\nU\u0007\"CA]k\u0005\u0005\t\u0019\u0001Bb\u00039\tXo\u001c;b\u001b\u0006t\u0017mZ3sg\u0002\n!d\u00197jK:$\u0018+^8uC6+G/\u00193bi\u0006l\u0015M\\1hKJ,\"A!8\u0011\t\t}'1]\u0007\u0003\u0005CT!\u0001\u001c(\n\t\t\u0015(\u0011\u001d\u0002\u001b\u00072LWM\u001c;Rk>$\u0018-T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u001fG2LWM\u001c;Rk>$\u0018-T3uC\u0012\fG/Y'b]\u0006<WM]0%KF$B!!-\u0003l\"I\u0011\u0011\u0018\u001d\u0002\u0002\u0003\u0007!Q\\\u0001\u001cG2LWM\u001c;Rk>$\u0018-T3uC\u0012\fG/Y'b]\u0006<WM\u001d\u0011\u0002\u001d\r|g\u000e\u001e:pY2,'/\u00119jgV\u0011!1\u001f\t\u0004G\nU\u0018b\u0001B|\u001d\nq1i\u001c8ue>dG.\u001a:Ba&\u001c\u0018AE2p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018n]0%KF$B!!-\u0003~\"I\u0011\u0011X\u001e\u0002\u0002\u0003\u0007!1_\u0001\u0010G>tGO]8mY\u0016\u0014\u0018\t]5tA\u0005I2m\u001c8ue>dG.\u001a:Ba&\u001c\b*\u00198eY\u0016\u0014\bk\\8m+\t\u0019)\u0001E\u0002d\u0007\u000fI1a!\u0003O\u0005]Y\u0015MZ6b%\u0016\fX/Z:u\u0011\u0006tG\r\\3s!>|G.A\u000fd_:$(o\u001c7mKJ\f\u0005/[:IC:$G.\u001a:Q_>dw\fJ3r)\u0011\t\tla\u0004\t\u0013\u0005ef(!AA\u0002\r\u0015\u0011AG2p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018n\u001d%b]\u0012dWM\u001d)p_2\u0004\u0013\u0001E7jOJ\fG/[8o'V\u0004\bo\u001c:u+\t\u00199\u0002E\u0003V\u00033\u001cI\u0002E\u0002d\u00077I1a!\bO\u0005i\u0019uN\u001c;s_2dWM]'jOJ\fG/[8o'V\u0004\bo\u001c:u\u0003Qi\u0017n\u001a:bi&|gnU;qa>\u0014Ho\u0018\u0013fcR!\u0011\u0011WB\u0012\u0011%\tI,QA\u0001\u0002\u0004\u00199\"A\tnS\u001e\u0014\u0018\r^5p]N+\b\u000f]8si\u0002\n!c[1gW\u0006L\u0016-\\7fe6+GO]5dgV\u001111\u0006\t\u0005\u0003\u001f\u0019i#\u0003\u0003\u00040\u0005E!AE&bM.\f\u0017,Y7nKJlU\r\u001e:jGN\f!#\\3uC\u0012\fG/\u0019)vE2L7\u000f[3sgV\u00111Q\u0007\t\u0007\u0007o\u0019Id!\u0010\u000e\u0005\u0005M\u0014\u0002BB\u001e\u0003g\u0012A\u0001T5tiB!1qHB%\u001b\t\u0019\tE\u0003\u0003\u0004D\r\u0015\u0013!\u00039vE2L7\u000f[3s\u0015\r\u00199%\\\u0001\u0006S6\fw-Z\u0005\u0005\u0007\u0017\u001a\tEA\tNKR\fG-\u0019;b!V\u0014G.[:iKJ\f1#\\3uC\u0012\fG/\u0019)vE2L7\u000f[3sg\u0002\n\u0011CZ3biV\u0014Xm\u001d)vE2L7\u000f[3s+\t\u0019\u0019\u0006\u0005\u0003\u0004V\reSBAB,\u0015\r\u0019\u0019e[\u0005\u0005\u00077\u001a9FA\tGK\u0006$XO]3t!V\u0014G.[:iKJ\f!CZ3biV\u0014Xm\u001d)vE2L7\u000f[3sA\u0005\tR.Y=cK\u000eC\u0017M\\4f'R\fG/^:\u0015\r\r\r4\u0011NB7!\r)6QM\u0005\u0004\u0007O2&a\u0002\"p_2,\u0017M\u001c\u0005\b\u0007WB\u0005\u0019AAI\u0003\u00111'o\\7\t\u000f\r=\u0004\n1\u0001\u0002\u0012\u0006\u0011Ao\\\u0001\nG2,8\u000f^3s\u0013\u0012,\"a!\u001e\u0011\t\r]4q\u0010\b\u0005\u0007s\u001aY\bE\u0002\u0002\u001aZK1a! W\u0003\u0019\u0001&/\u001a3fM&!1\u0011QBB\u0005\u0019\u0019FO]5oO*\u00191Q\u0010,\u0002\u000fM$\u0018M\u001d;vaR\u0011\u0011\u0011W\u0001\tg\",H\u000fZ8x]\u0006i\u0011m^1jiNCW\u000f\u001e3po:\u0004")
public class ControllerServer
implements Logging {
    private final SharedServer sharedServer;
    private final KafkaConfigSchema configSchema;
    private final BootstrapMetadata bootstrapMetadata;
    private final KafkaMetricsGroup metricsGroup;
    private final KafkaConfig config;
    private final Time time;
    private final ReentrantLock lock;
    private final Condition awaitShutdownCond;
    private Server.ProcessStatus status;
    private LinuxIoMetricsCollector linuxIoMetricsCollector;
    private volatile Option<Authorizer> authorizer;
    private DelegationTokenCache tokenCache;
    private CredentialProvider credentialProvider;
    private SocketServer socketServer;
    private final CompletableFuture<Integer> socketServerFirstBoundPortFuture;
    private Option<CreateTopicPolicy> createTopicPolicy;
    private Option<AlterConfigPolicy> alterConfigPolicy;
    private volatile QuorumControllerMetrics quorumControllerMetrics;
    private Controller controller;
    private QuotaFactory.QuotaManagers quotaManagers;
    private ClientQuotaMetadataManager clientQuotaMetadataManager;
    private ControllerApis controllerApis;
    private KafkaRequestHandlerPool controllerApisHandlerPool;
    private Option<ControllerMigrationSupport> migrationSupport;
    private final List<MetadataPublisher> metadataPublishers;
    private final FeaturesPublisher featuresPublisher;
    private com.typesafe.scalalogging.Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public com.typesafe.scalalogging.Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public SharedServer sharedServer() {
        return this.sharedServer;
    }

    public KafkaConfigSchema configSchema() {
        return this.configSchema;
    }

    public BootstrapMetadata bootstrapMetadata() {
        return this.bootstrapMetadata;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Time time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.sharedServer().metrics();
    }

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.sharedServer().raftManager();
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public Condition awaitShutdownCond() {
        return this.awaitShutdownCond;
    }

    public Server.ProcessStatus status() {
        return this.status;
    }

    public void status_$eq(Server.ProcessStatus x$1) {
        this.status = x$1;
    }

    public LinuxIoMetricsCollector linuxIoMetricsCollector() {
        return this.linuxIoMetricsCollector;
    }

    public void linuxIoMetricsCollector_$eq(LinuxIoMetricsCollector x$1) {
        this.linuxIoMetricsCollector = x$1;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public void authorizer_$eq(Option<Authorizer> x$1) {
        this.authorizer = x$1;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public void tokenCache_$eq(DelegationTokenCache x$1) {
        this.tokenCache = x$1;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public void credentialProvider_$eq(CredentialProvider x$1) {
        this.credentialProvider = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public void socketServer_$eq(SocketServer x$1) {
        this.socketServer = x$1;
    }

    public CompletableFuture<Integer> socketServerFirstBoundPortFuture() {
        return this.socketServerFirstBoundPortFuture;
    }

    public Option<CreateTopicPolicy> createTopicPolicy() {
        return this.createTopicPolicy;
    }

    public void createTopicPolicy_$eq(Option<CreateTopicPolicy> x$1) {
        this.createTopicPolicy = x$1;
    }

    public Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public void alterConfigPolicy_$eq(Option<AlterConfigPolicy> x$1) {
        this.alterConfigPolicy = x$1;
    }

    public QuorumControllerMetrics quorumControllerMetrics() {
        return this.quorumControllerMetrics;
    }

    public void quorumControllerMetrics_$eq(QuorumControllerMetrics x$1) {
        this.quorumControllerMetrics = x$1;
    }

    public Controller controller() {
        return this.controller;
    }

    public void controller_$eq(Controller x$1) {
        this.controller = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public void quotaManagers_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManagers = x$1;
    }

    public ClientQuotaMetadataManager clientQuotaMetadataManager() {
        return this.clientQuotaMetadataManager;
    }

    public void clientQuotaMetadataManager_$eq(ClientQuotaMetadataManager x$1) {
        this.clientQuotaMetadataManager = x$1;
    }

    public ControllerApis controllerApis() {
        return this.controllerApis;
    }

    public void controllerApis_$eq(ControllerApis x$1) {
        this.controllerApis = x$1;
    }

    public KafkaRequestHandlerPool controllerApisHandlerPool() {
        return this.controllerApisHandlerPool;
    }

    public void controllerApisHandlerPool_$eq(KafkaRequestHandlerPool x$1) {
        this.controllerApisHandlerPool = x$1;
    }

    public Option<ControllerMigrationSupport> migrationSupport() {
        return this.migrationSupport;
    }

    public void migrationSupport_$eq(Option<ControllerMigrationSupport> x$1) {
        this.migrationSupport = x$1;
    }

    public KafkaYammerMetrics kafkaYammerMetrics() {
        return KafkaYammerMetrics.INSTANCE;
    }

    public List<MetadataPublisher> metadataPublishers() {
        return this.metadataPublishers;
    }

    public FeaturesPublisher featuresPublisher() {
        return this.featuresPublisher;
    }

    private boolean maybeChangeStatus(Server.ProcessStatus from, Server.ProcessStatus to) {
        block8: {
            boolean bl;
            block7: {
                this.lock().lock();
                try {
                    Server.ProcessStatus processStatus = this.status();
                    if (processStatus == null ? from != null : !processStatus.equals(from)) {
                        bl = false;
                        break block7;
                    }
                    this.status_$eq(to);
                    Server.ProcessStatus processStatus2 = to;
                    Server$SHUTDOWN$ server$SHUTDOWN$ = Server$SHUTDOWN$.MODULE$;
                    if (processStatus2 == null) {
                    } else if (processStatus2.equals(server$SHUTDOWN$)) {
                        this.awaitShutdownCond().signalAll();
                    }
                    break block8;
                }
                finally {
                    this.lock().unlock();
                }
            }
            return bl;
        }
        return true;
    }

    public String clusterId() {
        return this.sharedServer().metaProps().clusterId();
    }

    /*
     * WARNING - void declaration
     */
    public void startup() {
        if (!this.maybeChangeStatus(Server$SHUTDOWN$.MODULE$, Server$STARTING$.MODULE$)) {
            return;
        }
        Deadline startupDeadline = Deadline.fromDelay((Time)this.time(), (long)Predef$.MODULE$.Long2long(this.config().serverMaxStartupTimeMs()), (TimeUnit)TimeUnit.MILLISECONDS);
        try {
            Authorizer a;
            this.logIdent_$eq(new LogContext(new StringBuilder(23).append("[ControllerServer id=").append(this.config().nodeId()).append("] ").toString()).logPrefix());
            this.info((Function0<String>)(Function0 & Serializable)() -> "Starting controller");
            this.config().dynamicConfig().initialize((Option<KafkaZkClient>)None$.MODULE$);
            this.maybeChangeStatus(Server$STARTING$.MODULE$, Server$STARTED$.MODULE$);
            this.metricsGroup().newGauge("ClusterId", (Gauge)new Gauge<String>(this){
                private final /* synthetic */ ControllerServer $outer;

                public final String value() {
                    ControllerServer controllerServer = this.$outer;
                    if (controllerServer == null) {
                        throw null;
                    }
                    return controllerServer.clusterId();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.metricsGroup().newGauge("yammer-metrics-count", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ ControllerServer $outer;

                public final int value() {
                    return ControllerServer.kafka$server$ControllerServer$$$anonfun$startup$4();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.linuxIoMetricsCollector_$eq(new LinuxIoMetricsCollector("/proc", this.time(), this.logger().underlying()));
            if (this.linuxIoMetricsCollector().usable()) {
                this.metricsGroup().newGauge("linux-disk-read-bytes", (Gauge)new Gauge<Object>(this){
                    private final /* synthetic */ ControllerServer $outer;

                    public final long value() {
                        return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$6();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.metricsGroup().newGauge("linux-disk-write-bytes", (Gauge)new Gauge<Object>(this){
                    private final /* synthetic */ ControllerServer $outer;

                    public final long value() {
                        return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$8();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            List javaListeners = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.config().controllerListeners().map((Function1 & Serializable)x$11 -> x$11.toJava())).asJava();
            this.authorizer_$eq(this.config().createNewAuthorizer());
            this.authorizer().foreach((Function1 & Serializable)x$12 -> {
                x$12.configure(this.config().originals());
                return BoxedUnit.UNIT;
            });
            EndpointReadyFutures endpointReadyFutures = new EndpointReadyFutures.Builder().build(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.authorizer())), (AuthorizerServerInfo)new KafkaAuthorizerServerInfo(new ClusterResource(this.clusterId()), this.config().nodeId(), (Collection)javaListeners, (Endpoint)javaListeners.get(0), (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)this.config().earlyStartListeners().map((Function1 & Serializable)x$13 -> x$13.value())).asJava()));
            SimpleApiVersionManager apiVersionManager = new SimpleApiVersionManager(ApiMessageType.ListenerType.CONTROLLER, Predef$.MODULE$.Boolean2boolean(this.config().unstableApiVersionsEnabled()), this.config().migrationEnabled(), (Function0<Features>)(Function0 & Serializable)() -> this.featuresPublisher().features());
            this.tokenCache_$eq(new DelegationTokenCache(ScramMechanism.mechanismNames()));
            this.credentialProvider_$eq(new CredentialProvider(ScramMechanism.mechanismNames(), this.tokenCache()));
            this.socketServer_$eq(new SocketServer(this.config(), this.metrics(), this.time(), this.credentialProvider(), apiVersionManager));
            if (!this.config().controllerListeners().nonEmpty()) {
                throw new ConfigException("No controller.listener.names defined for controller");
            }
            this.socketServerFirstBoundPortFuture().complete(Predef$.MODULE$.int2Integer(this.socketServer().boundPort(((EndPoint)this.config().controllerListeners().head()).listenerName())));
            this.sharedServer().startForController();
            this.createTopicPolicy_$eq((Option<CreateTopicPolicy>)Option$.MODULE$.apply(this.config().getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class)));
            this.alterConfigPolicy_$eq((Option<AlterConfigPolicy>)Option$.MODULE$.apply(this.config().getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class)));
            List controllerNodes = RaftConfig.voterConnectionsToNodes((java.util.Map)((java.util.Map)FutureUtils.waitWithLogging((Logger)this.logger().underlying(), (String)this.logIdent(), (String)"controller quorum voters future", this.sharedServer().controllerQuorumVotersFuture(), (Deadline)startupDeadline, (Time)this.time())));
            QuorumFeatures quorumFeatures = QuorumFeatures.create((int)this.config().nodeId(), (ApiVersions)this.sharedServer().raftManager().apiVersions(), (java.util.Map)QuorumFeatures.defaultFeatureMap(), (Collection)controllerNodes);
            String delegationTokenKeyString = this.config().tokenAuthEnabled() ? this.config().delegationTokenSecretKey().value() : null;
            OptionalLong leaderImbalanceCheckIntervalNs = Predef$.MODULE$.Boolean2boolean(this.config().autoLeaderRebalanceEnable()) ? OptionalLong.of(TimeUnit.NANOSECONDS.convert(this.config().leaderImbalanceCheckIntervalSeconds(), TimeUnit.SECONDS)) : OptionalLong.empty();
            OptionalLong maxIdleIntervalNs = (OptionalLong)this.config().metadataMaxIdleIntervalNs().fold((Function0 & Serializable)() -> OptionalLong.empty(), (Function1 & Serializable)x$1 -> ControllerServer.$anonfun$startup$15(BoxesRunTime.unboxToLong((Object)x$1)));
            this.quorumControllerMetrics_$eq(new QuorumControllerMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), this.time(), this.config().migrationEnabled()));
            QuorumController.Builder controllerBuilder = new QuorumController.Builder(this.config().nodeId(), this.sharedServer().metaProps().clusterId()).setTime(this.time()).setThreadNamePrefix(new StringBuilder(19).append("quorum-controller-").append(this.config().nodeId()).append("-").toString()).setConfigSchema(this.configSchema()).setRaftClient(this.raftManager().client()).setQuorumFeatures(quorumFeatures).setDefaultReplicationFactor((short)this.config().defaultReplicationFactor()).setDefaultNumPartitions(this.config().numPartitions().intValue()).setSessionTimeoutNs(TimeUnit.NANOSECONDS.convert(this.config().brokerSessionTimeoutMs(), TimeUnit.MILLISECONDS)).setLeaderImbalanceCheckIntervalNs(leaderImbalanceCheckIntervalNs).setMaxIdleIntervalNs(maxIdleIntervalNs).setMetrics(this.quorumControllerMetrics()).setCreateTopicPolicy(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.createTopicPolicy()))).setAlterConfigPolicy(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.alterConfigPolicy()))).setConfigurationValidator((ConfigurationValidator)new ControllerConfigurationValidator(this.sharedServer().brokerConfig())).setStaticConfig(this.config().originals()).setBootstrapMetadata(this.bootstrapMetadata()).setFatalFaultHandler(this.sharedServer().fatalQuorumControllerFaultHandler()).setNonFatalFaultHandler(this.sharedServer().nonFatalQuorumControllerFaultHandler()).setZkMigrationEnabled(this.config().migrationEnabled()).setDelegationTokenCache(this.tokenCache()).setDelegationTokenSecretKey(delegationTokenKeyString).setDelegationTokenMaxLifeMs(Predef$.MODULE$.Long2long(this.config().delegationTokenMaxLifeMs())).setDelegationTokenExpiryTimeMs(Predef$.MODULE$.Long2long(this.config().delegationTokenExpiryTimeMs())).setDelegationTokenExpiryCheckIntervalMs(Predef$.MODULE$.Long2long(this.config().delegationTokenExpiryCheckIntervalMs()));
            this.controller_$eq((Controller)controllerBuilder.build());
            Option<Authorizer> option = this.authorizer();
            if (option instanceof Some && (a = (Authorizer)((Some)option).value()) instanceof ClusterMetadataAuthorizer) {
                ((ClusterMetadataAuthorizer)a).setAclMutator((AclMutator)this.controller());
            }
            if (this.config().migrationEnabled()) {
                PasswordEncoder passwordEncoder;
                KafkaZkClient zkClient = KafkaZkClient$.MODULE$.createZkClient("KRaft Migration", this.time(), this.config(), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(this.config(), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2()));
                Option<Password> option2 = this.config().passwordEncoderSecret();
                if (option2 instanceof Some) {
                    void encrypting_iterations;
                    void encrypting_keyLength;
                    void encrypting_cipherAlgorithm;
                    Password secret = (Password)((Some)option2).value();
                    int n = Predef$.MODULE$.Integer2int(this.config().passwordEncoderIterations());
                    int n2 = Predef$.MODULE$.Integer2int(this.config().passwordEncoderKeyLength());
                    String string = this.config().passwordEncoderCipherAlgorithm();
                    Option<String> encrypting_keyFactoryAlgorithm = this.config().passwordEncoderKeyFactoryAlgorithm();
                    passwordEncoder = new EncryptingPasswordEncoder(secret, encrypting_keyFactoryAlgorithm, (String)encrypting_cipherAlgorithm, (int)encrypting_keyLength, (int)encrypting_iterations);
                    Object var23_19 = null;
                    string = null;
                } else if (None$.MODULE$.equals(option2)) {
                    passwordEncoder = new NoOpPasswordEncoder();
                } else {
                    throw new MatchError(option2);
                }
                NoOpPasswordEncoder zkConfigEncoder = passwordEncoder;
                ZkMigrationClient migrationClient = ZkMigrationClient$.MODULE$.apply(zkClient, zkConfigEncoder);
                MigrationPropagator propagator = new MigrationPropagator(this.config().nodeId(), this.config());
                KRaftMigrationDriver migrationDriver = new KRaftMigrationDriver.Builder().setNodeId(this.config().nodeId()).setZkRecordConsumer(((QuorumController)this.controller()).zkRecordConsumer()).setZkMigrationClient((MigrationClient)migrationClient).setPropagator((LegacyPropagator)propagator).setInitialZkLoadHandler(publisher -> this.sharedServer().loader().installPublishers(Collections.singletonList(publisher))).setFaultHandler(this.sharedServer().faultHandlerFactory().build("zk migration", false, () -> {})).setQuorumFeatures(quorumFeatures).setConfigSchema(this.configSchema()).setControllerMetrics(this.quorumControllerMetrics()).setTime(this.time()).build();
                migrationDriver.start();
                this.migrationSupport_$eq((Option<ControllerMigrationSupport>)new Some((Object)new ControllerMigrationSupport(zkClient, migrationDriver, propagator)));
            }
            this.quotaManagers_$eq(QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), this.time(), new StringBuilder(12).append("controller-").append(this.config().nodeId()).append("-").toString()));
            this.clientQuotaMetadataManager_$eq(new ClientQuotaMetadataManager(this.quotaManagers(), this.socketServer().connectionQuotas()));
            this.controllerApis_$eq(new ControllerApis(this.socketServer().dataPlaneRequestChannel(), this.authorizer(), this.quotaManagers(), this.time(), this.controller(), this.raftManager(), this.config(), this.sharedServer().metaProps(), (scala.collection.immutable.Seq<Node>)CollectionConverters$.MODULE$.ListHasAsScala(controllerNodes).asScala().toSeq(), apiVersionManager));
            this.controllerApisHandlerPool_$eq(new KafkaRequestHandlerPool(this.config().nodeId(), this.socketServer().dataPlaneRequestChannel(), this.controllerApis(), this.time(), Predef$.MODULE$.Integer2int(this.config().numIoThreads()), new StringBuilder(28).append(DataPlaneAcceptor$.MODULE$.MetricPrefix()).append("RequestHandlerAvgIdlePercent").toString(), DataPlaneAcceptor$.MODULE$.ThreadPrefix()));
            this.metadataPublishers().add((MetadataPublisher)this.featuresPublisher());
            this.metadataPublishers().add(new DynamicConfigPublisher(this.config(), this.sharedServer().metadataPublishingFaultHandler(), (scala.collection.immutable.Map<String, ConfigHandler>)((scala.collection.immutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigType$.MODULE$.Broker()), (Object)new BrokerConfigHandler(this.config(), this.quotaManagers()))}))), "controller"));
            this.metadataPublishers().add(new DynamicClientQuotaPublisher(this.config(), this.sharedServer().metadataPublishingFaultHandler(), "controller", this.clientQuotaMetadataManager()));
            this.metadataPublishers().add(new ScramPublisher(this.config(), this.sharedServer().metadataPublishingFaultHandler(), "controller", this.credentialProvider()));
            this.metadataPublishers().add(new DelegationTokenPublisher(this.config(), this.sharedServer().metadataPublishingFaultHandler(), "controller", new DelegationTokenManager(this.config(), this.tokenCache(), this.time())));
            this.metadataPublishers().add((MetadataPublisher)new ControllerMetadataMetricsPublisher(this.sharedServer().controllerServerMetrics(), this.sharedServer().metadataPublishingFaultHandler()));
            this.metadataPublishers().add(new AclPublisher(this.config().nodeId(), this.sharedServer().metadataPublishingFaultHandler(), "controller", this.authorizer()));
            FutureUtils.waitWithLogging((Logger)this.logger().underlying(), (String)this.logIdent(), (String)"the controller metadata publishers to be installed", (CompletableFuture)this.sharedServer().loader().installPublishers(this.metadataPublishers()), (Deadline)startupDeadline, (Time)this.time());
            scala.collection.immutable.Map authorizerFutures = CollectionConverters$.MODULE$.MapHasAsScala(endpointReadyFutures.futures()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            CompletableFuture<Void> socketServerFuture = this.socketServer().enableRequestProcessing((Map<Endpoint, CompletableFuture<Void>>)authorizerFutures);
            FutureUtils.waitWithLogging((Logger)this.logger().underlying(), (String)this.logIdent(), (String)"all of the authorizer futures to be completed", CompletableFuture.allOf((CompletableFuture[])authorizerFutures.values().toSeq().toArray(ClassTag$.MODULE$.apply(CompletableFuture.class))), (Deadline)startupDeadline, (Time)this.time());
            FutureUtils.waitWithLogging((Logger)this.logger().underlying(), (String)this.logIdent(), (String)"all of the SocketServer Acceptors to be started", socketServerFuture, (Deadline)startupDeadline, (Time)this.time());
            this.config().dynamicConfig().addReconfigurables(this);
            return;
        }
        catch (Throwable e) {
            this.maybeChangeStatus(Server$STARTING$.MODULE$, Server$STARTED$.MODULE$);
            this.sharedServer().controllerStartupFaultHandler().handleFault("caught exception", e);
            this.shutdown();
            throw e;
        }
    }

    public void shutdown() {
        if (!this.maybeChangeStatus(Server$STARTED$.MODULE$, Server$SHUTTING_DOWN$.MODULE$)) {
            return;
        }
        try {
            try {
                this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
                this.sharedServer().ensureNotRaftLeader();
                this.metadataPublishers().forEach(p -> this.sharedServer().loader().removeAndClosePublisher(p).get());
                this.metadataPublishers().clear();
                if (this.socketServer() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.socketServer().stopProcessingRequests(), this, Level.WARN);
                }
                this.migrationSupport().foreach((Function1 & Serializable)x$14 -> {
                    x$14.shutdown(this);
                    return BoxedUnit.UNIT;
                });
                if (this.controller() != null) {
                    this.controller().beginShutdown();
                }
                if (this.socketServer() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.socketServer().shutdown(), this, Level.WARN);
                }
                if (this.controllerApisHandlerPool() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.controllerApisHandlerPool().shutdown(), this, Level.WARN);
                }
                if (this.controllerApis() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.controllerApis().close(), this, Level.WARN);
                }
                if (this.quotaManagers() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.quotaManagers().shutdown(), this, Level.WARN);
                }
                if (this.controller() != null) {
                    this.controller().close();
                }
                if (this.quorumControllerMetrics() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.quorumControllerMetrics().close(), this, Level.WARN);
                }
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.authorizer().foreach((Function1 & Serializable)x$15 -> {
                    x$15.close();
                    return BoxedUnit.UNIT;
                }), this, Level.WARN);
                this.createTopicPolicy().foreach((Function1 & Serializable)policy -> {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> policy.close(), this, Level.WARN);
                    return BoxedUnit.UNIT;
                });
                this.alterConfigPolicy().foreach((Function1 & Serializable)policy -> {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> policy.close(), this, Level.WARN);
                    return BoxedUnit.UNIT;
                });
                this.socketServerFirstBoundPortFuture().completeExceptionally(new RuntimeException("shutting down"));
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.config().dynamicConfig().clear(), this, Level.WARN);
                this.sharedServer().stopForController();
            }
            catch (Throwable e) {
                this.fatal((Function0<String>)(Function0 & Serializable)() -> "Fatal error during controller shutdown.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        }
        finally {
            this.maybeChangeStatus(Server$SHUTTING_DOWN$.MODULE$, Server$SHUTDOWN$.MODULE$);
        }
    }

    public void awaitShutdown() {
        this.lock().lock();
        try {
            while (true) {
                Server.ProcessStatus processStatus = this.status();
                Server$SHUTDOWN$ server$SHUTDOWN$ = Server$SHUTDOWN$.MODULE$;
                if (processStatus == null || !processStatus.equals(server$SHUTDOWN$)) {
                    this.awaitShutdownCond().awaitUninterruptibly();
                    continue;
                }
                break;
            }
        }
        finally {
            this.lock().unlock();
        }
    }

    public final /* synthetic */ String kafka$server$ControllerServer$$$anonfun$startup$2() {
        return this.clusterId();
    }

    public static final /* synthetic */ int kafka$server$ControllerServer$$$anonfun$startup$4() {
        return KafkaYammerMetrics.defaultRegistry().allMetrics().size();
    }

    public final /* synthetic */ long kafka$server$ControllerServer$$$anonfun$startup$6() {
        return this.linuxIoMetricsCollector().readBytes();
    }

    public final /* synthetic */ long kafka$server$ControllerServer$$$anonfun$startup$8() {
        return this.linuxIoMetricsCollector().writeBytes();
    }

    public static final /* synthetic */ OptionalLong $anonfun$startup$15(long x$1) {
        return OptionalLong.of(x$1);
    }

    public ControllerServer(SharedServer sharedServer, KafkaConfigSchema configSchema, BootstrapMetadata bootstrapMetadata) {
        this.sharedServer = sharedServer;
        this.configSchema = configSchema;
        this.bootstrapMetadata = bootstrapMetadata;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.config = sharedServer.controllerConfig();
        this.time = sharedServer.time();
        this.lock = new ReentrantLock();
        this.awaitShutdownCond = this.lock().newCondition();
        this.status = Server$SHUTDOWN$.MODULE$;
        this.authorizer = None$.MODULE$;
        this.socketServerFirstBoundPortFuture = new CompletableFuture();
        this.createTopicPolicy = None$.MODULE$;
        this.alterConfigPolicy = None$.MODULE$;
        this.migrationSupport = None$.MODULE$;
        this.metadataPublishers = new ArrayList<MetadataPublisher>();
        this.featuresPublisher = new FeaturesPublisher();
    }
}

