/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import javax.security.auth.login.Configuration;
import kafka.admin.ZkSecurityMigrator$;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.ReplicaAssignment;
import kafka.server.QuorumTestHarness;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.TopicZNode$;
import kafka.zk.ZkData$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001\u0002\r\u001a\u0001\u0001BQ!\f\u0001\u0005\u00029Bq!\r\u0001C\u0002\u0013\u0005!\u0007\u0003\u0004<\u0001\u0001\u0006Ia\r\u0005\by\u0001\u0011\r\u0011\"\u0001>\u0011\u0019!\u0005\u0001)A\u0005}!)Q\t\u0001C!\r\")q\f\u0001C!A\")Q\r\u0001C\u0001A\")!\u000e\u0001C\u0001A\")A\u000e\u0001C\u0005[\"I\u00111\u0007\u0001\u0012\u0002\u0013%\u0011Q\u0007\u0005\b\u0003\u0017\u0002A\u0011BA'\u0011\u0019\t\u0019\u0007\u0001C\u0001A\"1\u0011q\r\u0001\u0005\u0002\u0001Da!a\u001b\u0001\t\u0003\u0001\u0007BBA8\u0001\u0011\u0005\u0001\r\u0003\u0004\u0002t\u0001!\t\u0001\u0019\u0005\b\u0003o\u0002A\u0011BA=\u0011\u001d\t9\t\u0001C\u0005\u0003\u0013Cq!a$\u0001\t\u0013\t\t\n\u0003\u0004\u0002<\u0002!I\u0001\u0019\u0005\b\u0003{\u0003A\u0011BA`\u0011\u0019\t\u0019\u000e\u0001C\u0001A\n\u0019\"l[!vi\"|'/\u001b>bi&|g\u000eV3ti*\u0011!dG\u0001\u0005CV$\bN\u0003\u0002\u001d;\u0005A1/Z2ve&$\u0018PC\u0001\u001f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\t!S$\u0001\u0004tKJ4XM]\u0005\u0003M\r\u0012\u0011#U;peVlG+Z:u\u0011\u0006\u0014h.Z:t!\tA3&D\u0001*\u0015\tQS$A\u0003vi&d7/\u0003\u0002-S\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u00010!\t\u0001\u0004!D\u0001\u001a\u0003!Q\u0017-Y:GS2,W#A\u001a\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014AA5p\u0015\u0005A\u0014\u0001\u00026bm\u0006L!AO\u001b\u0003\t\u0019KG.Z\u0001\nU\u0006\f7OR5mK\u0002\nA\"Y;uQB\u0013xN^5eKJ,\u0012A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003^\nA\u0001\\1oO&\u00111\t\u0011\u0002\u0007'R\u0014\u0018N\\4\u0002\u001b\u0005,H\u000f\u001b)s_ZLG-\u001a:!\u0003\u0015\u0019X\r^+q)\t9U\n\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015J\u0001\u0003V]&$\b\"\u0002(\u0007\u0001\u0004y\u0015\u0001\u0003;fgRLeNZ8\u0011\u0005AKV\"A)\u000b\u0005I\u001b\u0016aA1qS*\u0011A+V\u0001\bUV\u0004\u0018\u000e^3s\u0015\t1v+A\u0003kk:LGOC\u0001Y\u0003\ry'oZ\u0005\u00035F\u0013\u0001\u0002V3ti&sgm\u001c\u0015\u0003\rq\u0003\"\u0001U/\n\u0005y\u000b&A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eF\u0001HQ\t9!\r\u0005\u0002QG&\u0011A-\u0015\u0002\n\u0003\u001a$XM]#bG\"\fq\u0003^3ti&\u001b(l[*fGV\u0014\u0018\u000e^=F]\u0006\u0014G.\u001a3)\u0005!9\u0007C\u0001)i\u0013\tI\u0017K\u0001\u0003UKN$\u0018!\u0005;fgR\\\u0015MZ6b5.\u001cE.[3oi\"\u0012\u0011bZ\u0001\u0011GJ,\u0017\r^3Ce>\\WM]%oM>$\u0012B\u001c;z\u0003\u0017\ty!!\u000b\u0011\u0005=\u0014X\"\u00019\u000b\u0005El\u0012A\u0001>l\u0013\t\u0019\bO\u0001\u0006Ce>\\WM]%oM>DQ!\u001e\u0006A\u0002Y\f!!\u001b3\u0011\u0005!;\u0018B\u0001=J\u0005\rIe\u000e\u001e\u0005\u0006u*\u0001\ra_\u0001\u0005Q>\u001cH\u000fE\u0002}\u0003\u000fq1!`A\u0002!\tq\u0018*D\u0001\u0000\u0015\r\t\taH\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0015\u0011*\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u0007\u0006%!bAA\u0003\u0013\"1\u0011Q\u0002\u0006A\u0002Y\fA\u0001]8si\"9\u0011\u0011\u0003\u0006A\u0002\u0005M\u0011\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m!\u0011\t)\"!\n\u000e\u0005\u0005]!b\u0001\u000e\u0002\u001a)\u0019A$a\u0007\u000b\t\u0005u\u0011qD\u0001\u0007G>lWn\u001c8\u000b\u0007y\t\tCC\u0002\u0002$]\u000ba!\u00199bG\",\u0017\u0002BA\u0014\u0003/\u0011\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\t\u0013\u0005-\"\u0002%AA\u0002\u00055\u0012\u0001\u0002:bG.\u0004B\u0001SA\u0018w&\u0019\u0011\u0011G%\u0003\r=\u0003H/[8o\u0003i\u0019'/Z1uK\n\u0013xn[3s\u0013:4w\u000e\n3fM\u0006,H\u000e\u001e\u00136+\t\t9D\u000b\u0003\u0002.\u0005e2FAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015\u0013*\u0001\u0006b]:|G/\u0019;j_:LA!!\u0013\u0002@\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002!9,woS1gW\u0006T6n\u00117jK:$HCBA(\u0003+\nI\u0006E\u0002p\u0003#J1!a\u0015q\u00055Y\u0015MZ6b5.\u001cE.[3oi\"1\u0011q\u000b\u0007A\u0002m\f\u0001cY8o]\u0016\u001cG/[8o'R\u0014\u0018N\\4\t\u000f\u0005mC\u00021\u0001\u0002^\u0005A\u0011n]*fGV\u0014X\rE\u0002I\u0003?J1!!\u0019J\u0005\u001d\u0011un\u001c7fC:\fq\u0002^3tij[W*[4sCRLwN\u001c\u0015\u0003\u001b\u001d\f1\u0003^3tij[\u0017I\u001c;j\u001b&<'/\u0019;j_:D#AD4\u0002\u0015Q,7\u000f\u001e#fY\u0016$X\r\u000b\u0002\u0010O\u0006\u0019B/Z:u\t\u0016dW\r^3SK\u000e,(o]5wK\"\u0012\u0001cZ\u0001\u000bi\u0016\u001cHo\u00115s_>$\bFA\th\u00035!Xm\u001d;NS\u001e\u0014\u0018\r^5p]R9q)a\u001f\u0002\u0000\u0005\r\u0005BBA?%\u0001\u000710A\u0003{WV\u0013H\u000eC\u0004\u0002\u0002J\u0001\r!a\u0014\u0002\u000f\u0019L'o\u001d;[W\"9\u0011Q\u0011\nA\u0002\u0005=\u0013\u0001C:fG>tGMW6\u0002\rY,'/\u001b4z)\r9\u00151\u0012\u0005\u0007\u0003\u001b\u001b\u0002\u0019A>\u0002\tA\fG\u000f[\u0001\rSN\f5\r\\\"peJ,7\r\u001e\u000b\t\u0003;\n\u0019*a-\u00028\"9\u0011Q\u0013\u000bA\u0002\u0005]\u0015\u0001\u00027jgR\u0004b!!'\u0002 \u0006\rVBAAN\u0015\r\ti*S\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAQ\u00037\u00131aU3r!\u0011\t)+a,\u000e\u0005\u0005\u001d&\u0002BAU\u0003W\u000bA\u0001Z1uC*!\u0011QVA\u0011\u0003%Qxn\\6fKB,'/\u0003\u0003\u00022\u0006\u001d&aA!D\u0019\"9\u0011Q\u0017\u000bA\u0002\u0005u\u0013AB:fGV\u0014X\rC\u0004\u0002:R\u0001\r!!\u0018\u0002\u0013M,gn]5uSZ,\u0017!\u00053fY\u0016$X-\u00117m+:\u001cXmY;sK\u0006yA-\u001a7fi\u0016\u0014VmY;sg&4X\r\u0006\u0004\u0002B\u00065\u0017\u0011\u001b\t\u0007\u0003\u0007\fI-!\u0018\u000e\u0005\u0005\u0015'bAAd\u0013\u0006!Q\u000f^5m\u0013\u0011\tY-!2\u0003\u0007Q\u0013\u0018\u0010C\u0004\u0002PZ\u0001\r!a\u0014\u0002\u0011i\\7\t\\5f]RDa!!$\u0017\u0001\u0004Y\u0018A\u0007;fgR\u001cuN\\:v[\u0016\u0014xJ\u001a4tKR\u0004\u0016\r\u001e5BG2\u001c\bFA\fh\u0001")
public class ZkAuthorizationTest
extends QuorumTestHarness {
    private final File jaasFile = JaasTestUtils$.MODULE$.writeJaasContextsToFile(JaasTestUtils$.MODULE$.zkSections());
    private final String authProvider;

    public File jaasFile() {
        return this.jaasFile;
    }

    public String authProvider() {
        return this.authProvider;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        System.setProperty("java.security.auth.login.config", this.jaasFile().getAbsolutePath());
        Configuration.setConfiguration(null);
        System.setProperty(this.authProvider(), "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty(this.authProvider());
        Configuration.setConfiguration(null);
    }

    @Test
    public void testIsZkSecurityEnabled() {
        Assertions.assertTrue((boolean)JaasUtils.isZkSaslEnabled());
        Configuration.setConfiguration(null);
        System.clearProperty("java.security.auth.login.config");
        Assertions.assertFalse((boolean)JaasUtils.isZkSaslEnabled());
        Configuration.setConfiguration(null);
        System.setProperty("java.security.auth.login.config", "no-such-file-exists.conf");
        Assertions.assertThrows(KafkaException.class, () -> JaasUtils.isZkSaslEnabled());
    }

    @Test
    public void testKafkaZkClient() {
        Assertions.assertTrue((boolean)this.zkClient().secure());
        ZkData$.MODULE$.PersistentZkPaths().foreach((Function1 & Serializable)path -> {
            ZkAuthorizationTest.$anonfun$testKafkaZkClient$1(this, path);
            return BoxedUnit.UNIT;
        });
        BrokerInfo brokerInfo = this.createBrokerInfo(1, "test.host", 9999, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$);
        this.zkClient().registerBroker(brokerInfo);
        this.verify(brokerInfo.path());
        String topic1 = "topic1";
        Some topicId = new Some((Object)Uuid.randomUuid());
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic1, 0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic1, 1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic1, 2)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        this.zkClient().createTopicAssignment(topic1, (Option)topicId, (Map)assignment);
        this.verify(TopicZNode$.MODULE$.path(topic1));
        String seqPath = this.zkClient().createSequentialPersistentPath("/c", "".getBytes(StandardCharsets.UTF_8));
        this.verify(seqPath);
        BrokerInfo updatedBrokerInfo = this.createBrokerInfo(1, "test.host2", 9995, SecurityProtocol.SSL, (Option<String>)None$.MODULE$);
        this.zkClient().updateBrokerInfo(updatedBrokerInfo);
        Assertions.assertEquals((Object)new Some((Object)updatedBrokerInfo.broker()), (Object)this.zkClient().getBroker(1));
        scala.collection.immutable.Map updatedAssignment = (scala.collection.immutable.Map)assignment.$minus((Object)new TopicPartition(topic1, 2));
        KafkaZkClient qual$1 = this.zkClient();
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)updatedAssignment.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                void apply_removingReplicas;
                TopicPartition k = (TopicPartition)x0$1._1();
                Seq v = (Seq)x0$1._2();
                Nil$ nil$ = Nil$.MODULE$;
                Nil$ apply_addingReplicas = Nil$.MODULE$;
                Object var3_4 = null;
                nil$ = null;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)new ReplicaAssignment(v, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas));
            }
            throw new MatchError(null);
        });
        int x$4 = qual$1.setTopicAssignment$default$4();
        qual$1.setTopicAssignment(topic1, (Option)topicId, (Map)x$3, x$4);
        Assertions.assertEquals((int)updatedAssignment.size(), (int)BoxesRunTime.unboxToInt((Object)this.zkClient().getTopicPartitionCount(topic1).get()));
    }

    private BrokerInfo createBrokerInfo(int id, String host, int port, SecurityProtocol securityProtocol, Option<String> rack) {
        return BrokerInfo$.MODULE$.apply(Broker$.MODULE$.apply(id, (Seq)new .colon.colon((Object)new EndPoint(host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol), (List)Nil$.MODULE$), rack), MetadataVersion.latest(), port + 10);
    }

    private Option<String> createBrokerInfo$default$5() {
        return None$.MODULE$;
    }

    private KafkaZkClient newKafkaZkClient(String connectionString, boolean isSecure) {
        return KafkaZkClient$.MODULE$.apply(connectionString, isSecure, 6000, 6000, Integer.MAX_VALUE, Time.SYSTEM, "ZkAuthorizationTest", new ZKClientConfig(), "kafka.server", "SessionExpireListener", false);
    }

    @Test
    public void testZkMigration() {
        try (KafkaZkClient unsecureZkClient = this.newKafkaZkClient(this.zkConnect(), false);){
            this.testMigration(this.zkConnect(), unsecureZkClient, this.zkClient());
        }
    }

    @Test
    public void testZkAntiMigration() {
        try (KafkaZkClient unsecureZkClient = this.newKafkaZkClient(this.zkConnect(), false);){
            this.testMigration(this.zkConnect(), this.zkClient(), unsecureZkClient);
        }
    }

    @Test
    public void testDelete() {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("zkConnect string: ").append(this.zkConnect()).toString());
        ZkSecurityMigrator$.MODULE$.run(new String[]{"--zookeeper.acl=secure", new StringBuilder(20).append("--zookeeper.connect=").append(this.zkConnect()).toString()});
        this.deleteAllUnsecure();
    }

    @Test
    public void testDeleteRecursive() {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("zkConnect string: ").append(this.zkConnect()).toString());
        ZkData$.MODULE$.SecureRootPaths().foreach((Function1 & Serializable)path -> {
            ZkAuthorizationTest.$anonfun$testDeleteRecursive$2(this, path);
            return BoxedUnit.UNIT;
        });
        this.zkClient().setAcl("/", this.zkClient().defaultAcls("/"));
        this.deleteAllUnsecure();
    }

    @Test
    public void testChroot() {
        String zkUrl = new StringBuilder(6).append(this.zkConnect()).append("/kafka").toString();
        KafkaZkClient qual$1 = this.zkClient();
        byte[] x$2 = qual$1.createRecursive$default$2();
        boolean x$3 = qual$1.createRecursive$default$3();
        qual$1.createRecursive("/kafka", x$2, x$3);
        KafkaZkClient unsecureZkClient = this.newKafkaZkClient(zkUrl, false);
        KafkaZkClient secureZkClient = this.newKafkaZkClient(zkUrl, true);
        try {
            this.testMigration(zkUrl, unsecureZkClient, secureZkClient);
        }
        finally {
            unsecureZkClient.close();
            secureZkClient.close();
        }
    }

    private void testMigration(String zkUrl, KafkaZkClient firstZk, KafkaZkClient secondZk) {
        String string;
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("zkConnect string: ").append(zkUrl).toString());
        ((IterableOnceOps)ZkData$.MODULE$.SecureRootPaths().$plus$plus((IterableOnce)ZkData$.MODULE$.SensitiveRootPaths())).foreach((Function1 & Serializable)path -> {
            ZkAuthorizationTest.$anonfun$testMigration$2(this, firstZk, path);
            return BoxedUnit.UNIT;
        });
        if (secondZk.secure()) {
            firstZk.createRecursive("/consumers", firstZk.createRecursive$default$2(), firstZk.createRecursive$default$3());
            string = "secure";
        } else {
            secondZk.createRecursive("/consumers", secondZk.createRecursive$default$2(), secondZk.createRecursive$default$3());
            string = "unsecure";
        }
        String secureOpt = string;
        ZkSecurityMigrator$.MODULE$.run(new String[]{new StringBuilder(16).append("--zookeeper.acl=").append(secureOpt).toString(), new StringBuilder(20).append("--zookeeper.connect=").append(zkUrl).toString()});
        this.info((Function0<String>)(Function0 & Serializable)() -> "Done with migration");
        ((IterableOnceOps)ZkData$.MODULE$.SecureRootPaths().$plus$plus((IterableOnce)ZkData$.MODULE$.SensitiveRootPaths())).foreach((Function1 & Serializable)path -> {
            ZkAuthorizationTest.$anonfun$testMigration$5(this, secondZk, path);
            return BoxedUnit.UNIT;
        });
        Seq consumersAcl = firstZk.getAcl("/consumers");
        Assertions.assertTrue((boolean)this.isAclCorrect((Seq<ACL>)consumersAcl, false, false), (String)"/consumers");
        Assertions.assertTrue((boolean)this.isAclCorrect((Seq<ACL>)firstZk.getAcl("/kafka-acl-extended"), secondZk.secure(), ZkData$.MODULE$.sensitivePath("/kafka-acl-extended")), (String)"/kafka-acl-extended");
        Assertions.assertTrue((boolean)this.isAclCorrect((Seq<ACL>)firstZk.getAcl("/feature"), secondZk.secure(), ZkData$.MODULE$.sensitivePath("/feature")), (String)"ACL mismatch for /feature path");
    }

    private void verify(String path) {
        boolean sensitive = ZkData$.MODULE$.sensitivePath(path);
        Assertions.assertTrue((boolean)this.zkClient().getAcl(path).forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclSecure(x$1, sensitive))));
    }

    private boolean isAclCorrect(Seq<ACL> list, boolean secure, boolean sensitive) {
        return (secure && !sensitive ? list.size() == 2 : list.size() == 1) && list.forall((Function1)(secure ? (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclSecure(x$2, sensitive)) : (Function1 & Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclUnsecure(acl))));
    }

    private void deleteAllUnsecure() {
        System.setProperty("zookeeper.sasl.client", "false");
        KafkaZkClient unsecureZkClient = this.newKafkaZkClient(this.zkConnect(), false);
        Try<Object> result = this.deleteRecursive(unsecureZkClient, "/");
        unsecureZkClient.close();
        System.clearProperty("zookeeper.sasl.client");
        if (result instanceof Success) {
            return;
        }
        if (result instanceof Failure) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)((Failure)result).exception().getMessage());
            return;
        }
        throw new MatchError(result);
    }

    private Try<Object> deleteRecursive(KafkaZkClient zkClient, String path) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(9).append("Deleting ").append(path).toString());
        ObjectRef result = ObjectRef.create((Object)new Success((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        zkClient.getChildren(path).foreach((Function1 & Serializable)child -> {
            ZkAuthorizationTest.$anonfun$deleteRecursive$2(this, result, path, zkClient, child);
            return BoxedUnit.UNIT;
        });
        switch (path == null ? 0 : path.hashCode()) {
            case 47: {
                if (!"/".equals(path)) break;
                return (Try)result.elem;
            }
        }
        try {
            int x$3 = zkClient.deletePath$default$2();
            zkClient.deletePath(path, x$3, false);
            return new Failure((Throwable)new Exception(new StringBuilder(25).append("Have been able to delete ").append(path).toString()));
        }
        catch (Exception exception) {
            return (Try)result.elem;
        }
    }

    @Test
    public void testConsumerOffsetPathAcls() {
        this.zkClient().makeSurePersistentPathExists("/consumers");
        java.util.List consumerPathAcls = this.zkClient().currentZooKeeper().getACL("/consumers", new Stat());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(consumerPathAcls).asScala().forall((Function1 & Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclUnsecure(acl))), (String)"old consumer znode path acls are not open");
    }

    public static final /* synthetic */ void $anonfun$testKafkaZkClient$2(ACL acl) {
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.isAclSecure(acl, true));
    }

    public static final /* synthetic */ void $anonfun$testKafkaZkClient$3(ACL acl) {
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.isAclSecure(acl, false));
    }

    public static final /* synthetic */ void $anonfun$testKafkaZkClient$1(ZkAuthorizationTest $this, String path) {
        $this.zkClient().makeSurePersistentPathExists(path);
        if (ZkData$.MODULE$.sensitivePath(path)) {
            Seq aclList = $this.zkClient().getAcl(path);
            Assertions.assertEquals((int)1, (int)aclList.size(), (String)new StringBuilder(29).append("Unexpected acl list size for ").append(path).toString());
            aclList.foreach((Function1 & Serializable)acl -> {
                ZkAuthorizationTest.$anonfun$testKafkaZkClient$2(acl);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (!path.equals("/consumers")) {
            Seq aclList = $this.zkClient().getAcl(path);
            Assertions.assertEquals((int)2, (int)aclList.size(), (String)new StringBuilder(29).append("Unexpected acl list size for ").append(path).toString());
            aclList.foreach((Function1 & Serializable)acl -> {
                ZkAuthorizationTest.$anonfun$testKafkaZkClient$3(acl);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testDeleteRecursive$2(ZkAuthorizationTest $this, String path) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(9).append("Creating ").append(path).toString());
        $this.zkClient().makeSurePersistentPathExists(path);
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(11).append(path).append("/fpjwashere").toString();
        byte[] x$2 = "".getBytes(StandardCharsets.UTF_8);
        boolean x$3 = qual$1.createRecursive$default$3();
        qual$1.createRecursive(x$1, x$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$testMigration$2(ZkAuthorizationTest $this, KafkaZkClient firstZk$1, String path) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(9).append("Creating ").append(path).toString());
        firstZk$1.makeSurePersistentPathExists(path);
        firstZk$1.createRecursive(new StringBuilder(11).append(path).append("/fpjwashere").toString(), "".getBytes(StandardCharsets.UTF_8), firstZk$1.createRecursive$default$3());
    }

    public static final /* synthetic */ void $anonfun$testMigration$5(ZkAuthorizationTest $this, KafkaZkClient secondZk$1, String path) {
        boolean sensitive = ZkData$.MODULE$.sensitivePath(path);
        Seq listParent = secondZk$1.getAcl(path);
        Assertions.assertTrue((boolean)$this.isAclCorrect((Seq<ACL>)listParent, secondZk$1.secure(), sensitive), (String)path);
        String childPath = new StringBuilder(11).append(path).append("/fpjwashere").toString();
        Seq listChild = secondZk$1.getAcl(childPath);
        Assertions.assertTrue((boolean)$this.isAclCorrect((Seq<ACL>)listChild, secondZk$1.secure(), sensitive), (String)childPath);
    }

    public static final /* synthetic */ void $anonfun$deleteRecursive$2(ZkAuthorizationTest $this, ObjectRef result$1, String path$3, KafkaZkClient zkClient$1, String child) {
        Try try_;
        Try<Object> try_2;
        switch (path$3 == null ? 0 : path$3.hashCode()) {
            case 47: {
                Try<Object> try_3;
                if ("/".equals(path$3)) {
                    try_3 = $this.deleteRecursive(zkClient$1, new StringBuilder(1).append("/").append(child).toString());
                    break;
                }
            }
            default: {
                Try<Object> try_3 = try_2 = $this.deleteRecursive(zkClient$1, new StringBuilder(1).append(path$3).append("/").append(child).toString());
            }
        }
        if (try_2 instanceof Success) {
            try_ = (Try)result$1.elem;
        } else if (try_2 instanceof Failure) {
            Throwable e = ((Failure)try_2).exception();
            try_ = new Failure(e);
        } else {
            throw new MatchError(try_2);
        }
        result$1.elem = try_;
    }

    public ZkAuthorizationTest() {
        this.authProvider = "zookeeper.authProvider.1";
    }
}

