/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.UnifiedLog;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArraySeq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001B\t\u0013\u0001]AQ\u0001\b\u0001\u0005\u0002uAqa\b\u0001C\u0002\u0013\u0005\u0001\u0005\u0003\u0004/\u0001\u0001\u0006I!\t\u0005\b_\u0001\u0011\r\u0011\"\u00011\u0011\u0019I\u0004\u0001)A\u0005c!9!\b\u0001b\u0001\n\u0003Y\u0004B\u0002$\u0001A\u0003%A\bC\u0003H\u0001\u0011\u0005\u0001\nC\u0003X\u0001\u0011\u0005\u0001\nC\u0003]\u0001\u0011%Q\f\u0003\u0004]\u0001\u0011%\u00111\u0001\u0005\u00079\u0002!I!a\n\t\r\u0005]\u0002\u0001\"\u0001I\u0011\u001d\tY\u0004\u0001C\u0005\u0003{Aq!a\u0018\u0001\t\u0013\t\t\u0007\u0003\u0004\u0002\b\u0002!\t\u0001\u0013\u0002\u001a\u0019><7\t\\3b]\u0016\u0014\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0014)\u0005\u0019An\\4\u000b\u0003U\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011DG\u0007\u0002%%\u00111D\u0005\u0002\"\u0003\n\u001cHO]1di2{wm\u00117fC:,'/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0001\"!\u0007\u0001\u0002\u000b\r|G-Z2\u0016\u0003\u0005\u0002\"A\t\u0017\u000e\u0003\rR!\u0001J\u0013\u0002\rI,7m\u001c:e\u0015\t1s%\u0001\u0004d_6lwN\u001c\u0006\u0003+!R!!\u000b\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0013aA8sO&\u0011Qf\t\u0002\u0010\u0007>l\u0007O]3tg&|g\u000eV=qK\u000611m\u001c3fG\u0002\nA\u0001^5nKV\t\u0011\u0007\u0005\u00023o5\t1G\u0003\u00025k\u0005!Q\u000f^5m\u0015\t1t%\u0001\u0004tKJ4XM]\u0005\u0003qM\u0012\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogV\tA\bE\u0002>\u0001\nk\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0007\u0012k\u0011!J\u0005\u0003\u000b\u0016\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\tu_BL7\rU1si&$\u0018n\u001c8tA\u000591\r\\3b]V\u0004H#A%\u0011\u0005uR\u0015BA&?\u0005\u0011)f.\u001b;)\u0005!i\u0005C\u0001(V\u001b\u0005y%B\u0001)R\u0003\r\t\u0007/\u001b\u0006\u0003%N\u000bqA[;qSR,'O\u0003\u0002UU\u0005)!.\u001e8ji&\u0011ak\u0014\u0002\n\u0003\u001a$XM]#bG\"\f!\b^3ti6\u000b'o[:QCJ$\u0018\u000e^5p]N\f5o\u00144gY&tW-\u00118e!>\u0004X\u000f\\1uKN,fn\u00197fC:\f'\r\\3NKR\u0014\u0018nY:)\u0005%I\u0006C\u0001([\u0013\tYvJ\u0001\u0003UKN$\u0018\u0001C4fi\u001e\u000bWoZ3\u0016\u0005ykGCA0w!\r\u0001\u0017n[\u0007\u0002C*\u0011!mY\u0001\u0005G>\u0014XM\u0003\u0002eK\u00069Q.\u001a;sS\u000e\u001c(B\u00014h\u0003\u0019I\u0018-\\7fe*\t\u0001.A\u0002d_6L!A[1\u0003\u000b\u001d\u000bWoZ3\u0011\u00051lG\u0002\u0001\u0003\u0006]*\u0011\ra\u001c\u0002\u0002)F\u0011\u0001o\u001d\t\u0003{EL!A\u001d \u0003\u000f9{G\u000f[5oOB\u0011Q\b^\u0005\u0003kz\u00121!\u00118z\u0011\u00159(\u00021\u0001y\u0003\u00191\u0017\u000e\u001c;feB!Q(_>\u007f\u0013\tQhHA\u0005Gk:\u001cG/[8ocA\u0011\u0001\r`\u0005\u0003{\u0006\u0014!\"T3ue&\u001cg*Y7f!\tit0C\u0002\u0002\u0002y\u0012qAQ8pY\u0016\fg.\u0006\u0003\u0002\u0006\u0005-A\u0003BA\u0004\u0003\u001b\u0001B\u0001Y5\u0002\nA\u0019A.a\u0003\u0005\u000b9\\!\u0019A8\t\u000f\u0005=1\u00021\u0001\u0002\u0012\u0005QQ.\u001a;sS\u000et\u0015-\\3\u0011\t\u0005M\u0011\u0011\u0005\b\u0005\u0003+\ti\u0002E\u0002\u0002\u0018yj!!!\u0007\u000b\u0007\u0005ma#\u0001\u0004=e>|GOP\u0005\u0004\u0003?q\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002$\u0005\u0015\"AB*ue&twMC\u0002\u0002 y*B!!\u000b\u00020Q1\u00111FA\u0019\u0003g\u0001B\u0001Y5\u0002.A\u0019A.a\f\u0005\u000b9d!\u0019A8\t\u000f\u0005=A\u00021\u0001\u0002\u0012!9\u0011Q\u0007\u0007A\u0002\u0005E\u0011aC7fiJL7mU2pa\u0016\fq\u0003^3ti6\u000b\u0007\u0010T8h\u0007>l\u0007/Y2uS>tG*Y4)\u00055I\u0016a\u0003:fC\u00124%o\\7M_\u001e$B!a\u0010\u0002XA1\u0011\u0011IA$\u0003\u0017j!!a\u0011\u000b\u0007\u0005\u0015c(\u0001\u0006d_2dWm\u0019;j_:LA!!\u0013\u0002D\tA\u0011\n^3sC\ndW\rE\u0004>\u0003\u001b\n\t&!\u0015\n\u0007\u0005=cH\u0001\u0004UkBdWM\r\t\u0004{\u0005M\u0013bAA+}\t\u0019\u0011J\u001c;\t\rMq\u0001\u0019AA-!\rI\u00121L\u0005\u0004\u0003;\u0012\"AC+oS\u001aLW\r\u001a'pO\u0006aqO]5uK.+\u0017\u0010R;qgR\u0001\u00121MA5\u0003[\n\t(a\u001d\u0002v\u0005}\u00141\u0011\t\u0007\u0003\u0003\n)'a\u0013\n\t\u0005\u001d\u00141\t\u0002\u0004'\u0016\f\bbBA6\u001f\u0001\u0007\u0011\u0011K\u0001\b]Vl7*Z=t\u0011\u001d\tyg\u0004a\u0001\u0003#\nqA\\;n\tV\u00048\u000f\u0003\u0004\u0014\u001f\u0001\u0007\u0011\u0011\f\u0005\u0006?=\u0001\r!\t\u0005\b\u0003oz\u0001\u0019AA=\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0002>\u0003wJ1!! ?\u0005\u0011auN\\4\t\u000f\u0005\u0005u\u00021\u0001\u0002R\u0005Q1\u000f^1siZ\u000bG.^3\t\u000f\u0005\u0015u\u00021\u0001\u0002R\u0005!1\u000f^3q\u0003I!Xm\u001d;JgRC'/Z1e\r\u0006LG.\u001a3)\u0005AI\u0006")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final CompressionType codec = CompressionType.LZ4;
    private final MockTime time = new MockTime();
    private final TopicPartition[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};

    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @AfterEach
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics() {
        void var3_3;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, this.codec());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var3_3.sizeInBytes();
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, 100L, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11));
        this.breakPartitionLog$1(this.topicPartitions()[0]);
        this.breakPartitionLog$1(this.topicPartitions()[1]);
        this.cleaner().startup();
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        UnifiedLog log2 = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[1]);
        String uncleanableDirectory = log.dir().getParent();
        Gauge uncleanablePartitionsCountGauge = this.getGauge("uncleanable-partitions-count", uncleanableDirectory);
        Gauge uncleanableBytesGauge = this.getGauge("uncleanable-bytes", uncleanableDirectory);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 2000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(uncleanablePartitionsCountGauge)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"There should be 2 uncleanable partitions");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long expectedTotalUncleanableBytes = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, 0L, ((LogSegment)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().last()).baseOffset())._2$mcJ$sp() + LogCleanerManager$.MODULE$.calculateCleanableBytes(log2, 0L, ((LogSegment)CollectionConverters$.MODULE$.CollectionHasAsScala(log2.logSegments()).asScala().last()).baseOffset())._2$mcJ$sp();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 1000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(uncleanableBytesGauge, expectedTotalUncleanableBytes)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4(expectedTotalUncleanableBytes));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Set uncleanablePartitions = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[2]));
        this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 2000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(this, uncleanablePartitionsCountGauge)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"There should be 1 uncleanable partitions");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Set uncleanablePartitions2 = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Assertions.assertFalse((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[2]));
    }

    private <T> Gauge<T> getGauge(Function1<MetricName, Object> filter) {
        return (Gauge)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    private <T> Gauge<T> getGauge(String metricName) {
        Function1 & Serializable getGauge_filter = (Function1 & Serializable)mName -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$3(metricName, mName));
        return (Gauge)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    private <T> Gauge<T> getGauge(String metricName, String metricScope) {
        Function1 & Serializable getGauge_filter = (Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$4(metricName, metricScope, k));
        return (Gauge)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    @Test
    public void testMaxLogCompactionLag() {
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        Object[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};
        float minCleanableDirtyRatio = 1.0f;
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray(topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get(topicPartitions[0]);
        long T0 = this.time().milliseconds();
        this.writeKeyDups(100, 3, log, CompressionType.NONE, T0, 0, 1);
        long startSizeBlock0 = log.size();
        LogSegment activeSegAtT0 = log.activeSegment();
        this.cleaner().startup();
        this.time().sleep((long)(maxCompactionLagMs / 2));
        Thread.sleep(5L * cleanerBackOffMs);
        Assertions.assertEquals((long)startSizeBlock0, (long)log.size(), (String)"There should be no cleaning until the max compaction lag has passed");
        this.time().sleep((long)(maxCompactionLagMs / 2 + 1));
        long T1 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends1 = this.writeKeyDups(100, 1, log, CompressionType.NONE, T1, 0, 0);
        log.roll(log.roll$default$1());
        LogSegment activeSegAtT1 = log.activeSegment();
        long firstBlockCleanableSegmentOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$12 = new TopicPartition("log", 0);
        long x$14 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$12, firstBlockCleanableSegmentOffset, x$14);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assertions.assertTrue((lastCleaned >= firstBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(firstBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned).toString());
        Assertions.assertNotEquals(appends1, read1, (String)"log should still contain non-zero keys");
        this.time().sleep((long)(maxCompactionLagMs + 1));
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$15 = new TopicPartition("log", 0);
        long x$16 = activeSegAtT1.baseOffset();
        long x$17 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$15, x$16, x$17);
        Iterable<Tuple2<Object, Object>> read2 = this.readFromLog(log);
        Assertions.assertEquals(appends1, read2, (String)"log should only contains zero keys now");
        long lastCleaned2 = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        long secondBlockCleanableSegmentOffset = activeSegAtT1.baseOffset();
        Assertions.assertTrue((lastCleaned2 >= secondBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(secondBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned2).toString());
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(UnifiedLog log) {
        return (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().flatMap((Function1 & Serializable)segment -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().records()).asScala().map((Function1 & Serializable)record -> {
            int key = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2())));
            int value = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2())));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
        }));
    }

    private Seq<Tuple2<Object, Object>> writeKeyDups(int numKeys, int numDups, UnifiedLog log, CompressionType codec, long timestamp, int startValue, int step) {
        IntRef valCounter = IntRef.create((int)startValue);
        return (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable)x$1 -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$1(numKeys, valCounter, log, codec, timestamp, step, BoxesRunTime.unboxToInt((Object)x$1)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsThreadFailed() {
        String metricName = "DeadThreadCount";
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, 100L, 100000, x$6, x$7, x$8, x$9, x$10, x$11));
        this.cleaner().startup();
        Assertions.assertEquals((int)0, (int)this.cleaner().deadThreadCount());
        this.cleaner().cleaners().foreach((Function1 & Serializable)x$2 -> {
            x$2.interrupt();
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Threads didn't terminate unexpectedly");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)BoxesRunTime.unboxToInt((Object)this.getGauge(metricName).value()));
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)this.cleaner().deadThreadCount());
    }

    private final void breakPartitionLog$1(TopicPartition tp) {
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)tp);
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        File partitionFile = ((LogSegment)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().last()).log().file();
        PrintWriter writer = new PrintWriter(partitionFile);
        writer.write("jogeajgoea");
        writer.close();
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(Gauge uncleanablePartitionsCountGauge$1) {
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 2;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2() {
        return "There should be 2 uncleanable partitions";
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(Gauge uncleanableBytesGauge$1, long expectedTotalUncleanableBytes$1) {
        return BoxesRunTime.unboxToLong((Object)uncleanableBytesGauge$1.value()) == expectedTotalUncleanableBytes$1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4(long expectedTotalUncleanableBytes$1) {
        return new StringBuilder(34).append("There should be ").append(expectedTotalUncleanableBytes$1).append(" uncleanable bytes").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(LogCleanerIntegrationTest $this, Gauge uncleanablePartitionsCountGauge$1) {
        $this.time().sleep(1000L);
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$6() {
        return "There should be 1 uncleanable partitions";
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(Function1 filter$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName k = (MetricName)x0$1._1();
            return BoxesRunTime.unboxToBoolean((Object)filter$1.apply((Object)k));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$3(String metricName$1, MetricName mName) {
        return mName.getName().endsWith(metricName$1) && mName.getScope() == null;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$4(String metricName$2, String metricScope$1, MetricName k) {
        return k.getName().endsWith(metricName$2) && k.getScope().endsWith(metricScope$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeKeyDups$2(IntRef valCounter$1, UnifiedLog log$1, CompressionType codec$1, long timestamp$1, int step$1, int key) {
        int curValue = valCounter$1.elem;
        byte[] x$1 = Integer.toString(curValue).getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        byte x$5 = 2;
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, timestamp$1, x$5), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5(), log$1.appendAsLeader$default$6());
        log$1.updateHighWatermark(log$1.logEndOffset());
        valCounter$1.elem += step$1;
        return new Tuple2.mcII.sp(key, curValue);
    }

    public static final /* synthetic */ IterableOnce $anonfun$writeKeyDups$1(int numKeys$1, IntRef valCounter$1, UnifiedLog log$1, CompressionType codec$1, long timestamp$1, int step$1, int x$1) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable)key -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$2(valCounter$1, log$1, codec$1, timestamp$1, step$1, BoxesRunTime.unboxToInt((Object)key)));
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$3(boolean result, LogCleaner.CleanerThread thread) {
        return thread.isThreadFailed() && result;
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$2(LogCleanerIntegrationTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.cleaner().cleaners().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable)(result, thread) -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$3(BoxesRunTime.unboxToBoolean((Object)result), thread))));
    }

    public static final /* synthetic */ String $anonfun$testIsThreadFailed$4() {
        return "Threads didn't terminate unexpectedly";
    }
}

