/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerContext;
import kafka.controller.StateChangeLogger;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0005\tub\u0001B\u0011#\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013\u00051\u0007\u0003\u0004=\u0001\u0001\u0006I\u0001\u000e\u0005\b{\u0001\u0011\r\u0011\"\u00014\u0011\u0019q\u0004\u0001)A\u0005i!9q\b\u0001b\u0001\n\u0003\u0001\u0005BB&\u0001A\u0003%\u0011\tC\u0004M\u0001\t\u0007I\u0011\u0001!\t\r5\u0003\u0001\u0015!\u0003B\u0011\u001dq\u0005A1A\u0005\u0002=CaA\u0016\u0001!\u0002\u0013\u0001\u0006bB,\u0001\u0001\u0004%\t\u0001\u0017\u0005\bA\u0002\u0001\r\u0011\"\u0001b\u0011\u00199\u0007\u0001)Q\u00053\")\u0001\u000e\u0001C!S\")a\u000e\u0001C!_\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA(\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u00037\u0002A\u0011AA/\u0011\u001d\t9\u0007\u0001C\u0001\u0003SBq!a\u001d\u0001\t\u0003\t)\bC\u0004\u0002\b\u0002!I!!#\t\u000f\u0005}\u0006\u0001\"\u0003\u0002B\"A\u0011q\u001d\u0001!\n\u0013\tI\u000fC\u0004\u0002|\u0002!\t!!@\t\u000f\u0005}\b\u0001\"\u0001\u0003\u0002!9!1\u0002\u0001\u0005\u0002\t5\u0001b\u0002B\f\u0001\u0011%!\u0011\u0004\u0005\b\u00057\u0001A\u0011\u0002B\u000f\u0011\u001d\u0011)\u0003\u0001C\u0005\u0003{DqAa\n\u0001\t\u0013\ti\u0010C\u0004\u0003*\u0001!IAa\u000b\u0003%M+'O^3s'\",H\u000fZ8x]R+7\u000f\u001e\u0006\u0003G\u0011\naa]3sm\u0016\u0014(\"A\u0013\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u000b\t\u0003S1j\u0011A\u000b\u0006\u0003W\u0011\n1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011QF\u000b\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012\u0001\r\t\u0003c\u0001i\u0011AI\u0001\u0005Q>\u001cH/F\u00015!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0003mC:<'\"A\u001d\u0002\t)\fg/Y\u0005\u0003wY\u0012aa\u0015;sS:<\u0017!\u00025pgR\u0004\u0013!\u0002;pa&\u001c\u0017A\u0002;pa&\u001c\u0007%A\u0003tK:$\u0018'F\u0001B!\r\u0011\u0015\nN\u0007\u0002\u0007*\u0011A)R\u0001\nS6lW\u000f^1cY\u0016T!AR$\u0002\u0015\r|G\u000e\\3di&|gNC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQ5I\u0001\u0003MSN$\u0018AB:f]R\f\u0004%A\u0003tK:$('\u0001\u0004tK:$(\u0007I\u0001\u0019aJ|\u0007o\u001d+p\u0007\"\fgnZ3Va>t'+Z:uCJ$X#\u0001)\u0011\u0005E#V\"\u0001*\u000b\u0005MC\u0014\u0001B;uS2L!!\u0016*\u0003\u0015A\u0013x\u000e]3si&,7/A\rqe>\u00048\u000fV8DQ\u0006tw-Z+q_:\u0014Vm\u001d;beR\u0004\u0013a\u00039sS>\u00148i\u001c8gS\u001e,\u0012!\u0017\t\u00045nkV\"A$\n\u0005q;%AB(qi&|g\u000e\u0005\u00022=&\u0011qL\t\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\bqe&|'oQ8oM&<w\fJ3r)\t\u0011W\r\u0005\u0002[G&\u0011Am\u0012\u0002\u0005+:LG\u000fC\u0004g\u001b\u0005\u0005\t\u0019A-\u0002\u0007a$\u0013'\u0001\u0007qe&|'oQ8oM&<\u0007%A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005Q\u0007cA6m;6\tQ)\u0003\u0002n\u000b\n\u00191+Z9\u0002\u000bM,G/\u00169\u0015\u0005\t\u0004\b\"B9\u0011\u0001\u0004\u0011\u0018\u0001\u0003;fgRLeNZ8\u0011\u0005MdX\"\u0001;\u000b\u0005U4\u0018aA1qS*\u0011q\u000f_\u0001\bUV\u0004\u0018\u000e^3s\u0015\tI(0A\u0003kk:LGOC\u0001|\u0003\ry'oZ\u0005\u0003{R\u0014\u0001\u0002V3ti&sgm\u001c\u0015\u0003!}\u00042a]A\u0001\u0013\r\t\u0019\u0001\u001e\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!\u0005;fgR\u001cE.Z1o'\",H\u000fZ8x]R\u0019!-!\u0003\t\u000f\u0005-\u0011\u00031\u0001\u0002\u000e\u00051\u0011/^8sk6\u0004B!a\u0004\u0002\u001e9!\u0011\u0011CA\r!\r\t\u0019bR\u0007\u0003\u0003+Q1!a\u0006'\u0003\u0019a$o\\8u}%\u0019\u00111D$\u0002\rA\u0013X\rZ3g\u0013\rY\u0014q\u0004\u0006\u0004\u000379\u0005fB\t\u0002$\u0005=\u0012\u0011\u0007\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006<\u0002\rA\f'/Y7t\u0013\u0011\ti#a\n\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAA\u001a\u0003\tZH-[:qY\u0006Lh*Y7f{:Z\u0018M]4v[\u0016tGo],ji\"t\u0015-\\3t{\":\u0011#a\u000e\u0002D\u0005\u0015\u0003\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\t\u0005u\u0012qE\u0001\taJ|g/\u001b3fe&!\u0011\u0011IA\u001e\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\"\u0011qIA&C\t\tI%\u0001\u0002{W\u0006\u0012\u0011QJ\u0001\u0006WJ\fg\r^\u0001$i\u0016\u001cHo\u00117fC:\u001c\u0006.\u001e;e_^t\u0017I\u001a;fe\u001a\u000b\u0017\u000e\\3e'R\f'\u000f^;q)\r\u0011\u00171\u000b\u0005\b\u0003\u0017\u0011\u0002\u0019AA\u0007Q\u001d\u0011\u00121EA\u0018\u0003cAsAEA\u001c\u0003\u0007\nI\u0006\f\u0003\u0002H\u0005-\u0013!\u000e;fgRtun\u00117fC:\u001c\u0006.\u001e;e_^t\u0017I\u001a;fe\u001a\u000b\u0017\u000e\\3e'R\f'\u000f^;q\tV,Gk\\\"peJ,\b\u000f\u001e'pON$2AYA0\u0011\u001d\tYa\u0005a\u0001\u0003\u001bAsaEA\u0012\u0003_\t\t\u0004K\u0004\u0014\u0003o\t\u0019%!\u001a-\t\u0005\u001d\u00131J\u0001#i\u0016\u001cHo\u00117fC:\u001c\u0006.\u001e;e_^tw+\u001b;i5.,f.\u0019<bS2\f'\r\\3\u0015\u0007\t\fY\u0007C\u0004\u0002\fQ\u0001\r!!\u0004)\u000fQ\t\u0019#a\f\u00022!:A#a\u000e\u0002D\u0005EDFAA$\u0003=\"Xm\u001d;DY\u0016\fgn\u00155vi\u0012|wO\\,ji\"\\%+\u00194u\u0007>tGO]8mY\u0016\u0014XK\\1wC&d\u0017M\u00197f)\r\u0011\u0017q\u000f\u0005\b\u0003\u0017)\u0002\u0019AA\u0007Q\r)\u00121\u0010\t\u0004g\u0006u\u0014bAA@i\nAA)[:bE2,G\rK\u0004\u0016\u0003G\ty#!\r)\u000fU\t9$a\u0011\u0002\u00062\u0012\u00111J\u0001&m\u0016\u0014\u0018NZ=DY\u0016\fgn\u00155vi\u0012|wO\\!gi\u0016\u0014h)Y5mK\u0012\u001cF/\u0019:ukB,B!a#\u0002\"R\u0019!-!$\t\u000f\u0005=e\u0003q\u0001\u0002\u0012\u0006\tR\r_2faRLwN\\\"mCN\u001cH+Y4\u0011\r\u0005M\u0015\u0011TAO\u001b\t\t)JC\u0002\u0002\u0018\u001e\u000bqA]3gY\u0016\u001cG/\u0003\u0003\u0002\u001c\u0006U%\u0001C\"mCN\u001cH+Y4\u0011\t\u0005}\u0015\u0011\u0015\u0007\u0001\t\u001d\t\u0019K\u0006b\u0001\u0003K\u0013\u0011!R\t\u0005\u0003O\u000bi\u000bE\u0002[\u0003SK1!a+H\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a,\u0002::!\u0011\u0011WA[\u001d\u0011\t\u0019\"a-\n\u0003!K1!a.H\u0003\u001d\u0001\u0018mY6bO\u0016LA!a/\u0002>\nIQ\t_2faRLwN\u001c\u0006\u0004\u0003o;\u0015aC1tg\u0016\u0014HoQ1vg\u0016$RAYAb\u0003;Dq!!2\u0018\u0001\u0004\t9-A\u0007fqB,7\r^3e\u00072\f7o\u001d\u0019\u0005\u0003\u0013\f\t\u000e\u0005\u0004\u0002\u0010\u0005-\u0017qZ\u0005\u0005\u0003\u001b\fyBA\u0003DY\u0006\u001c8\u000f\u0005\u0003\u0002 \u0006EG\u0001DAj\u0003\u0007\f\t\u0011!A\u0003\u0002\u0005U'aA0%cE!\u0011qUAl!\rQ\u0016\u0011\\\u0005\u0004\u00037<%aA!os\"9\u0011q\\\fA\u0002\u0005\u0005\u0018!A3\u0011\t\u0005=\u00161]\u0005\u0005\u0003K\fiLA\u0005UQJ|w/\u00192mK\u00061\u0012n\u001d(p]\u0012\u000bW-\\8o\u0017\u000647.\u0019+ie\u0016\fG\r\u0006\u0003\u0002l\u0006E\bc\u0001.\u0002n&\u0019\u0011q^$\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u001f\rA\u0002\u0005U\u0018!\u0001;\u0011\u0007U\n90C\u0002\u0002zZ\u0012a\u0001\u00165sK\u0006$\u0017\u0001\b<fe&4\u0017PT8o\t\u0006,Wn\u001c8UQJ,\u0017\rZ:Ti\u0006$Xo\u001d\u000b\u0002E\u00069B/Z:u\u0007>t7/Z2vi&4Xm\u00155vi\u0012|wO\u001c\u000b\u0004E\n\r\u0001bBA\u00065\u0001\u0007\u0011Q\u0002\u0015\b5\u0005\r\u0012qFA\u0019Q\u001dQ\u0012qGA\"\u0005\u0013aC!a\u0012\u0002L\u0005\u0001C/Z:u\u0007>tGO]8mY\u0016\u00148\u000b[;uI><h\u000eR;sS:<7+\u001a8e)\r\u0011'q\u0002\u0005\b\u0003\u0017Y\u0002\u0019AA\u0007Q\u001dY\u00121EA\u0018\u0003cAsaGA\u001c\u0003\u0007\u0012)\u0002\f\u0002\u0002H\u000511m\u001c8gS\u001e,\u0012!X\u0001\u0007EJ|7.\u001a:\u0016\u0005\t}\u0001cA\u0019\u0003\"%\u0019!1\u0005\u0012\u0003\u0017-\u000bgm[1Ce>\\WM]\u0001\u000fg\",H\u000fZ8x]\n\u0013xn[3s\u00035\u0011Xm\u001d;beR\u0014%o\\6fe\u0006q!/Z2sK\u0006$XM\u0011:pW\u0016\u0014Hc\u00012\u0003.!9!q\u0006\u0011A\u0002\u0005-\u0018aB:uCJ$X\u000f\u001d\u0015\b\u0001\tM\"\u0011\bB\u001e!\r\u0019(QG\u0005\u0004\u0005o!(a\u0002+j[\u0016|W\u000f^\u0001\u0006m\u0006dW/\u001a\u0010\u0002y\u0001")
public class ServerShutdownTest
extends KafkaServerTestHarness {
    private final String host;
    private final String topic;
    private final List<String> sent1 = new .colon.colon((Object)"hello", (List)new .colon.colon((Object)"there", (List)Nil$.MODULE$));
    private final List<String> sent2 = new .colon.colon((Object)"more", (List)new .colon.colon((Object)"messages", (List)Nil$.MODULE$));
    private final Properties propsToChangeUponRestart = new Properties();
    private Option<KafkaConfig> priorConfig = None$.MODULE$;

    public String host() {
        return this.host;
    }

    public String topic() {
        return this.topic;
    }

    public List<String> sent1() {
        return this.sent1;
    }

    public List<String> sent2() {
        return this.sent2;
    }

    public Properties propsToChangeUponRestart() {
        return this.propsToChangeUponRestart;
    }

    public Option<KafkaConfig> priorConfig() {
        return this.priorConfig;
    }

    public void priorConfig_$eq(Option<KafkaConfig> x$1) {
        this.priorConfig = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        this.priorConfig().foreach((Function1 & Serializable)config -> {
            java.util.Map originals = config.originals();
            Object logDirsValue = originals.get(KafkaConfig$.MODULE$.LogDirsProp());
            if (logDirsValue != null) {
                return this.propsToChangeUponRestart().put(KafkaConfig$.MODULE$.LogDirsProp(), logDirsValue);
            }
            return this.propsToChangeUponRestart().put(KafkaConfig$.MODULE$.LogDirProp(), originals.get(KafkaConfig$.MODULE$.LogDirProp()));
        });
        this.priorConfig_$eq((Option<KafkaConfig>)new Some((Object)KafkaConfig$.MODULE$.fromProps((Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head(), this.propsToChangeUponRestart(), true)));
        return new .colon.colon((Object)((KafkaConfig)this.priorConfig().get()), (List)Nil$.MODULE$);
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.priorConfig_$eq((Option<KafkaConfig>)None$.MODULE$);
        this.propsToChangeUponRestart().clear();
        super.setUp(testInfo);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdown(String quorum) {
        ObjectRef producer = ObjectRef.create((Object)this.createProducer$1());
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sent1().map((Function1 & Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value))).foreach((Function1 & Serializable)x$1 -> (RecordMetadata)x$1.get());
        this.killBroker(0);
        this.config().logDirs().foreach((Function1 & Serializable)logDir -> {
            ServerShutdownTest.$anonfun$testCleanShutdown$3(logDir);
            return BoxedUnit.UNIT;
        });
        ((KafkaProducer)producer.elem).close();
        this.restartBroker();
        TestUtils$.MODULE$.waitForPartitionMetadata(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), this.topic(), 0, 15000L);
        producer.elem = this.createProducer$1();
        Consumer consumer = this.createConsumer$1();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        Seq consumerRecords = TestUtils$.MODULE$.consumeRecords(consumer, this.sent1().size(), 15000L);
        Assertions.assertEquals(this.sent1(), (Object)consumerRecords.map((Function1 & Serializable)x$2 -> (String)x$2.value()));
        this.sent2().map((Function1 & Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value))).foreach((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get());
        Seq consumerRecords2 = TestUtils$.MODULE$.consumeRecords(consumer, this.sent2().size(), 15000L);
        Assertions.assertEquals(this.sent2(), (Object)consumerRecords2.map((Function1 & Serializable)x$4 -> (String)x$4.value()));
        consumer.close();
        ((KafkaProducer)producer.elem).close();
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdownAfterFailedStartup(String quorum) {
        if (this.isKRaftTest()) {
            this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.InitialBrokerRegistrationTimeoutMsProp(), "1000");
            this.killBroker(0);
            this.shutdownKRaftController();
            this.verifyCleanShutdownAfterFailedStartup(ClassTag$.MODULE$.apply(CancellationException.class));
            return;
        }
        this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "50");
        this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "some.invalid.hostname.foo.bar.local:65535");
        this.verifyCleanShutdownAfterFailedStartup(ClassTag$.MODULE$.apply(ZooKeeperClientTimeoutException.class));
    }

    /*
     * Unable to fully structure code
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testNoCleanShutdownAfterFailedStartupDueToCorruptLogs(String quorum) {
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.killBroker(0);
        this.config().logDirs().foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1$adapted(kafka.server.ServerShutdownTest java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((ServerShutdownTest)this));
        expectedStatusCode = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        receivedStatusCode = VolatileObjectRef.create((Object)Option$.MODULE$.empty());
        hasHaltProcedureCalled = VolatileBooleanRef.create((boolean)false);
        setHaltProcedure_haltProcedure = (Function2 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3$adapted(scala.runtime.VolatileBooleanRef scala.runtime.VolatileObjectRef java.lang.Object scala.Option ), (Ljava/lang/Object;Lscala/Option;)Lscala/runtime/Nothing$;)((VolatileBooleanRef)hasHaltProcedureCalled, (VolatileObjectRef)receivedStatusCode);
        Exit.setHaltProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        var6_5 = null;
        try {
            Assertions.assertDoesNotThrow((Executable)(Executable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$4(kafka.server.ServerShutdownTest ), ()V)((ServerShutdownTest)this));
            var9_6 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if (!hasHaltProcedureCalled.elem) ** GOTO lbl-1000
                v0 = expectedStatusCode;
                var13_9 = (Option)receivedStatusCode.elem;
                if (!(v0 != null ? v0.equals(var13_9) == false : var13_9 != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                var13_9 = null;
                if (!v1) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)new StringBuilder(117).append("Expected to halt directly with the expected status code:").append(expectedStatusCode.get()).append(", ").append("but got hasHaltProcedureCalled: ").append(hasHaltProcedureCalled.elem).append(" and received status code: ").append(((Option)receivedStatusCode.elem).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).toString());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                    continue;
                }
                break;
            }
        }
        finally {
            Exit.resetHaltProcedure();
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testCleanShutdownWithZkUnavailable(String quorum) {
        this.shutdownZooKeeper();
        this.killBroker(0);
        CoreUtils$.MODULE$.delete(this.broker().config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft"})
    public void testCleanShutdownWithKRaftControllerUnavailable(String quorum) {
        this.shutdownKRaftController();
        this.killBroker(0);
        CoreUtils$.MODULE$.delete(this.broker().config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    private <E extends Exception> void verifyCleanShutdownAfterFailedStartup(ClassTag<E> exceptionClassTag) {
        try {
            try {
                this.recreateBroker(true);
                Assertions.fail((String)"Expected KafkaServer setup to fail and throw exception");
            }
            catch (Exception e) {
                this.assertCause(exceptionClassTag.runtimeClass(), e);
                Assertions.assertEquals((Object)(this.isKRaftTest() ? BrokerState.SHUTTING_DOWN : BrokerState.NOT_RUNNING), (Object)((KafkaBroker)this.brokers().head()).brokerState());
            }
        }
        finally {
            this.killBroker(0);
        }
    }

    private void assertCause(Class<?> expectedClass, Throwable e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!expectedClass.isInstance(cause)) continue;
            return;
        }
        Assertions.fail((String)new StringBuilder(43).append("Failed to assert cause of ").append(e).append(", expected cause ").append(expectedClass).toString());
    }

    private boolean isNonDaemonKafkaThread(Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(this.getClass().getName());
    }

    public void verifyNonDaemonThreadsStatus() {
        Assertions.assertEquals((int)0, (int)ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(Thread.getAllStackTraces().keySet().toArray()), (Function1 & Serializable)x$6 -> (Thread)x$6, ClassTag$.MODULE$.apply(Thread.class))), (Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)this.isNonDaemonKafkaThread(t))));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConsecutiveShutdown(String quorum) {
        this.killBroker(0);
        ((KafkaBroker)this.brokers().head()).shutdown();
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testControllerShutdownDuringSend(String quorum) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        int controllerId = 2;
        Metrics metrics = new Metrics();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ObjectRef serverSocket = ObjectRef.create(null);
        ObjectRef controllerChannelManager = ObjectRef.create(null);
        try {
            serverSocket.elem = new ServerSocket(0);
            Future<?> receiveFuture = executor.submit(new Runnable(null, serverSocket){
                private final ObjectRef serverSocket$1;

                public void run() {
                    Socket socket = ((ServerSocket)this.serverSocket$1.elem).accept();
                    new DataInputStream(socket.getInputStream()).readByte();
                }
                {
                    this.serverSocket$1 = serverSocket$1;
                }
            });
            scala.collection.immutable.Map brokerAndEpochs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Broker(1, "localhost", ((ServerSocket)serverSocket.elem).getLocalPort(), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)0L))}));
            KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
            ControllerContext controllerContext = new ControllerContext();
            controllerContext.setLiveBrokers((Map)brokerAndEpochs);
            controllerChannelManager.elem = new ControllerChannelManager((Function0)(JFunction0.mcI.sp & Serializable)() -> controllerContext.epoch(), controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), (Option)None$.MODULE$);
            ((ControllerChannelManager)controllerChannelManager.elem).startup(controllerContext.liveOrShuttingDownBrokers());
            LeaderAndIsrRequest.Builder requestBuilder = new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, 1, 0L, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), Collections.singletonMap(this.topic(), Uuid.randomUuid()), (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)((IterableOnceOps)brokerAndEpochs.keys().map((Function1 & Serializable)x$7 -> x$7.node(listenerName))).toSet()).asJava());
            ControllerChannelManager qual$1 = (ControllerChannelManager)controllerChannelManager.elem;
            Function1 x$3 = qual$1.sendRequest$default$3();
            qual$1.sendRequest(1, (AbstractControlRequest.Builder)requestBuilder, x$3);
            receiveFuture.get(10L, TimeUnit.SECONDS);
            executor.submit(new Runnable(null, controllerChannelManager){
                private final ObjectRef controllerChannelManager$1;

                public void run() {
                    ((ControllerChannelManager)this.controllerChannelManager$1.elem).shutdown();
                }
                {
                    this.controllerChannelManager$1 = controllerChannelManager$1;
                }
            }).get(10L, TimeUnit.SECONDS);
        }
        finally {
            if ((ServerSocket)serverSocket.elem != null) {
                ((ServerSocket)serverSocket.elem).close();
            }
            if ((ControllerChannelManager)controllerChannelManager.elem != null) {
                ((ControllerChannelManager)controllerChannelManager.elem).shutdown();
            }
            executor.shutdownNow();
            metrics.close();
        }
    }

    private KafkaConfig config() {
        return (KafkaConfig)this.configs().head();
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private void shutdownBroker() {
        this.killBroker(0);
    }

    private void restartBroker() {
        this.killBroker(0);
        this.restartDeadBrokers(!this.propsToChangeUponRestart().isEmpty());
    }

    private void recreateBroker(boolean startup) {
        this.recreateBrokers(!this.propsToChangeUponRestart().isEmpty(), startup);
    }

    private final KafkaProducer createProducer$1() {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        IntegerSerializer x$2 = new IntegerSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = -1;
        long x$5 = 60000L;
        long x$6 = 0x100000L;
        int x$7 = Integer.MAX_VALUE;
        int x$8 = 30000;
        int x$9 = 0;
        int x$10 = 16384;
        String x$11 = "none";
        int x$12 = 20000;
        SecurityProtocol x$13 = SecurityProtocol.PLAINTEXT;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        boolean x$16 = false;
        return TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$2, x$3, x$16);
    }

    private final Consumer createConsumer$1() {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        IntegerDeserializer x$3 = new IntegerDeserializer();
        StringDeserializer x$4 = new StringDeserializer();
        String x$5 = "group";
        String x$6 = "earliest";
        boolean x$7 = true;
        boolean x$8 = false;
        int x$9 = 500;
        None$ x$10 = None$.MODULE$;
        None$ x$11 = None$.MODULE$;
        return TestUtils$.MODULE$.createConsumer(x$1, x$5, x$6, x$7, x$8, x$9, SecurityProtocol.PLAINTEXT, (Option<File>)x$10, (Option<Properties>)x$11, x$3, x$4);
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdown$3(String logDir) {
        File OffsetCheckpointFile2 = new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile());
        Assertions.assertTrue((boolean)OffsetCheckpointFile2.exists());
        Assertions.assertTrue((OffsetCheckpointFile2.length() > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1(ServerShutdownTest $this, String dirName) {
        File partitionDir = new File(dirName, new StringBuilder(2).append($this.topic()).append("-0").toString());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])partitionDir.listFiles()), (Function1 & Serializable)f -> {
            TestUtils$.MODULE$.appendNonsenseToFile(f, TestUtils$.MODULE$.random().nextInt(1024) + 1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Nothing$ $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3(VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1, int statusCode, Option x$5) {
        hasHaltProcedureCalled$1.elem = true;
        receivedStatusCode$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
        return (Nothing$)BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$4(ServerShutdownTest $this) {
        $this.recreateBroker(true);
    }

    public static final /* synthetic */ boolean $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$5(VolatileBooleanRef hasHaltProcedureCalled$1, Some expectedStatusCode$1, VolatileObjectRef receivedStatusCode$1) {
        if (hasHaltProcedureCalled$1.elem) {
            Some some = expectedStatusCode$1;
            Option option = (Option)receivedStatusCode$1.elem;
            if (!(some != null ? !some.equals(option) : option != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$6(Some expectedStatusCode$1, VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1) {
        return new StringBuilder(117).append("Expected to halt directly with the expected status code:").append(expectedStatusCode$1.get()).append(", ").append("but got hasHaltProcedureCalled: ").append(hasHaltProcedureCalled$1.elem).append(" and received status code: ").append(((Option)receivedStatusCode$1.elem).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).toString();
    }

    public ServerShutdownTest() {
        this.host = "localhost";
        this.topic = "test";
    }

    public static final /* synthetic */ Object $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1$adapted(ServerShutdownTest $this, String dirName) {
        ServerShutdownTest.$anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1($this, dirName);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Nothing$ $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3$adapted(VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1, Object statusCode, Option x$5) {
        return ServerShutdownTest.$anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3(hasHaltProcedureCalled$1, receivedStatusCode$1, BoxesRunTime.unboxToInt((Object)statusCode), x$5);
    }
}

